/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.Reference<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.Reference::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    default public HolderLookup<T> filterElements(final Predicate<T> p_256028_) {
        return new Delegate<T>(this){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255836_) {
                return this.parent.get(p_255836_).filter(p_256496_ -> p_256028_.test(p_256496_.value()));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return this.parent.listElements().filter(p_255794_ -> p_256028_.test(p_255794_.value()));
            }
        };
    }

    public static interface RegistryLookup<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public HolderLookup<T> filterFeatures(FeatureFlagSet p_249397_) {
            return FeatureElement.FILTERED_REGISTRIES.contains(this.key()) ? this.filterElements(p_250240_ -> ((FeatureElement)p_250240_).isEnabled(p_249397_)) : this;
        }

        public static abstract class Delegate<T>
        implements RegistryLookup<T> {
            protected abstract RegistryLookup<T> parent();

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255619_) {
                return this.parent().get(p_255619_);
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return this.parent().listElements();
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_256245_) {
                return this.parent().get(p_256245_);
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }
        }
    }

    public static interface Provider {
        public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> RegistryLookup<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> p_255957_) {
            return this.lookup(p_255957_).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(p_255957_.location()) + " not found"));
        }

        default public HolderGetter.Provider asGetterLookup() {
            return new HolderGetter.Provider(){

                @Override
                public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256379_) {
                    return this.lookup(p_256379_).map(p_255952_ -> p_255952_);
                }
            };
        }

        public static Provider create(Stream<RegistryLookup<?>> p_256054_) {
            final Map<ResourceKey, RegistryLookup> map = p_256054_.collect(Collectors.toUnmodifiableMap(RegistryLookup::key, p_256335_ -> p_256335_));
            return new Provider(){

                @Override
                public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_255663_) {
                    return Optional.ofNullable((RegistryLookup)map.get(p_255663_));
                }
            };
        }
    }

    public static class Delegate<T>
    implements HolderLookup<T> {
        protected final HolderLookup<T> parent;

        public Delegate(HolderLookup<T> p_256052_) {
            this.parent = p_256052_;
        }

        @Override
        public Optional<Holder.Reference<T>> get(ResourceKey<T> p_256195_) {
            return this.parent.get(p_256195_);
        }

        @Override
        public Stream<Holder.Reference<T>> listElements() {
            return this.parent.listElements();
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256388_) {
            return this.parent.get(p_256388_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return this.parent.listTags();
        }
    }
}

