/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class TimeArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType ERROR_INVALID_UNIT = new SimpleCommandExceptionType((Message)Component.translatable("argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType ERROR_TICK_COUNT_TOO_LOW = new Dynamic2CommandExceptionType((p_264715_, p_264716_) -> Component.translatable("argument.time.tick_count_too_low", p_264716_, p_264715_));
    private static final Object2IntMap<String> UNITS = new Object2IntOpenHashMap();
    final int minimum;

    private TimeArgument(int p_265107_) {
        this.minimum = p_265107_;
    }

    public static TimeArgument time() {
        return new TimeArgument(0);
    }

    public static TimeArgument time(int p_265722_) {
        return new TimeArgument(p_265722_);
    }

    public Integer parse(StringReader p_113039_) throws CommandSyntaxException {
        float f = p_113039_.readFloat();
        String s = p_113039_.readUnquotedString();
        int i = UNITS.getOrDefault((Object)s, 0);
        if (i == 0) {
            throw ERROR_INVALID_UNIT.create();
        }
        int j = Math.round(f * (float)i);
        if (j < this.minimum) {
            throw ERROR_TICK_COUNT_TOO_LOW.create((Object)j, (Object)this.minimum);
        }
        return j;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_113044_, SuggestionsBuilder p_113045_) {
        StringReader stringreader = new StringReader(p_113045_.getRemaining());
        try {
            stringreader.readFloat();
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return p_113045_.buildFuture();
        }
        return SharedSuggestionProvider.suggest((Iterable<String>)UNITS.keySet(), p_113045_.createOffset(p_113045_.getStart() + stringreader.getCursor()));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static {
        UNITS.put((Object)"d", 24000);
        UNITS.put((Object)"s", 20);
        UNITS.put((Object)"t", 1);
        UNITS.put((Object)"", 1);
    }

    public static class Info
    implements ArgumentTypeInfo<TimeArgument, Template> {
        @Override
        public void serializeToNetwork(Template p_265434_, FriendlyByteBuf p_265320_) {
            p_265320_.writeInt(p_265434_.min);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_265324_) {
            int i = p_265324_.readInt();
            return new Template(i);
        }

        @Override
        public void serializeToJson(Template p_265110_, JsonObject p_265629_) {
            p_265629_.addProperty("min", (Number)p_265110_.min);
        }

        @Override
        public Template unpack(TimeArgument p_265544_) {
            return new Template(p_265544_.minimum);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TimeArgument> {
            final int min;

            Template(int p_265096_) {
                this.min = p_265096_;
            }

            @Override
            public TimeArgument instantiate(CommandBuildContext p_265466_) {
                return TimeArgument.time(this.min);
            }

            @Override
            public ArgumentTypeInfo<TimeArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

