/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType ERROR_UNKNOWN_TAG = new Dynamic2CommandExceptionType((p_250953_, p_249704_) -> Component.translatable("argument.resource_tag.not_found", p_250953_, p_249704_));
    private static final Dynamic3CommandExceptionType ERROR_INVALID_TAG_TYPE = new Dynamic3CommandExceptionType((p_250188_, p_252173_, p_251453_) -> Component.translatable("argument.resource_tag.invalid_type", p_250188_, p_252173_, p_251453_));
    private final HolderLookup<T> registryLookup;
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceOrTagArgument(CommandBuildContext p_249382_, ResourceKey<? extends Registry<T>> p_251209_) {
        this.registryKey = p_251209_;
        this.registryLookup = p_249382_.holderLookup(p_251209_);
    }

    public static <T> ResourceOrTagArgument<T> resourceOrTag(CommandBuildContext p_251101_, ResourceKey<? extends Registry<T>> p_248888_) {
        return new ResourceOrTagArgument<T>(p_251101_, p_248888_);
    }

    public static <T> Result<T> getResourceOrTag(CommandContext<CommandSourceStack> p_249001_, String p_251520_, ResourceKey<Registry<T>> p_250370_) throws CommandSyntaxException {
        Result result = (Result)p_249001_.getArgument(p_251520_, Result.class);
        Optional<Result<T>> optional = result.cast(p_250370_);
        return optional.orElseThrow(() -> (CommandSyntaxException)((Object)((Object)result.unwrap().map(p_252340_ -> {
            ResourceKey resourcekey = p_252340_.key();
            return ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)resourcekey.location(), (Object)resourcekey.registry(), (Object)p_250370_.location());
        }, p_250301_ -> {
            TagKey tagkey = p_250301_.key();
            return ERROR_INVALID_TAG_TYPE.create((Object)tagkey.location(), tagkey.registry(), (Object)p_250370_.location());
        }))));
    }

    public Result<T> parse(StringReader p_250860_) throws CommandSyntaxException {
        if (p_250860_.canRead() && p_250860_.peek() == '#') {
            int i = p_250860_.getCursor();
            try {
                p_250860_.skip();
                ResourceLocation resourcelocation1 = ResourceLocation.read(p_250860_);
                TagKey tagkey = TagKey.create(this.registryKey, resourcelocation1);
                HolderSet.Named named = this.registryLookup.get(tagkey).orElseThrow(() -> ERROR_UNKNOWN_TAG.create((Object)resourcelocation1, (Object)this.registryKey.location()));
                return new TagResult(named);
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                p_250860_.setCursor(i);
                throw commandsyntaxexception;
            }
        }
        ResourceLocation resourcelocation = ResourceLocation.read(p_250860_);
        ResourceKey resourcekey = ResourceKey.create(this.registryKey, resourcelocation);
        Holder.Reference reference = this.registryLookup.get(resourcekey).orElseThrow(() -> ResourceArgument.ERROR_UNKNOWN_RESOURCE.create((Object)resourcelocation, (Object)this.registryKey.location()));
        return new ResourceResult(reference);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_250223_, SuggestionsBuilder p_252354_) {
        SharedSuggestionProvider.suggestResource(this.registryLookup.listTagIds().map(TagKey::location), p_252354_, "#");
        return SharedSuggestionProvider.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), p_252354_);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap();

        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var1);

        public String asPrintable();
    }

    record TagResult<T>(HolderSet.Named<T> tag) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.right(this.tag);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> p_250945_) {
            return this.tag.key().isFor(p_250945_) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> p_252187_) {
            return this.tag.contains(p_252187_);
        }

        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.tag.key().location());
        }
    }

    record ResourceResult<T>(Holder.Reference<T> value) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.left(this.value);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> p_250007_) {
            return this.value.key().isFor(p_250007_) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> p_249230_) {
            return p_249230_.equals(this.value);
        }

        @Override
        public String asPrintable() {
            return this.value.key().location().toString();
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template p_250419_, FriendlyByteBuf p_249726_) {
            p_249726_.writeResourceLocation(p_250419_.registryKey.location());
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_250205_) {
            ResourceLocation resourcelocation = p_250205_.readResourceLocation();
            return new Template(ResourceKey.createRegistryKey(resourcelocation));
        }

        @Override
        public void serializeToJson(Template p_251957_, JsonObject p_249067_) {
            p_249067_.addProperty("registry", p_251957_.registryKey.location().toString());
        }

        @Override
        public Template unpack(ResourceOrTagArgument<T> p_252206_) {
            return new Template(p_252206_.registryKey);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> p_250107_) {
                this.registryKey = p_250107_;
            }

            @Override
            public ResourceOrTagArgument<T> instantiate(CommandBuildContext p_251386_) {
                return new ResourceOrTagArgument(p_251386_, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> type() {
                return Info.this;
            }
        }
    }
}

