/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MultiPartBakedModel
implements IDynamicBakedModel {
    private final List<Pair<Predicate<BlockState>, BakedModel>> selectors;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    protected final ItemOverrides overrides;
    private final Map<BlockState, BitSet> selectorCache = new Object2ObjectOpenCustomHashMap(Util.identityStrategy());
    private final BakedModel defaultModel;

    public MultiPartBakedModel(List<Pair<Predicate<BlockState>, BakedModel>> p_119462_) {
        BakedModel bakedmodel;
        this.selectors = p_119462_;
        this.defaultModel = bakedmodel = (BakedModel)p_119462_.iterator().next().getRight();
        this.hasAmbientOcclusion = bakedmodel.useAmbientOcclusion();
        this.isGui3d = bakedmodel.isGui3d();
        this.usesBlockLight = bakedmodel.usesBlockLight();
        this.particleIcon = bakedmodel.getParticleIcon();
        this.transforms = bakedmodel.getTransforms();
        this.overrides = bakedmodel.getOverrides();
    }

    public BitSet getSelectors(@javax.annotation.Nullable BlockState p_235050_) {
        BitSet bitset = this.selectorCache.get(p_235050_);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                Pair<Predicate<BlockState>, BakedModel> pair = this.selectors.get(i);
                if (!((Predicate)pair.getLeft()).test(p_235050_)) continue;
                bitset.set(i);
            }
            this.selectorCache.put(p_235050_, bitset);
        }
        return bitset;
    }

    @Override
    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState p_235050_, @javax.annotation.Nullable Direction p_235051_, RandomSource p_235052_, ModelData modelData, @Nullable RenderType renderType) {
        if (p_235050_ == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.getSelectors(p_235050_);
        ArrayList list = Lists.newArrayList();
        long k = p_235052_.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            BakedModel model = (BakedModel)this.selectors.get(j).getRight();
            if (renderType != null && !model.getRenderTypes(p_235050_, p_235052_, modelData).contains(renderType)) continue;
            list.add(model.getQuads(p_235050_, p_235051_, RandomSource.create(k), MultipartModelData.resolve(modelData, model), renderType));
        }
        return ConcatenatedListView.of(list);
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    @Override
    public boolean useAmbientOcclusion(BlockState state) {
        return this.defaultModel.useAmbientOcclusion(state);
    }

    @Override
    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return this.defaultModel.useAmbientOcclusion(state, renderType);
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    @Override
    public boolean isCustomRenderer() {
        return false;
    }

    @Override
    @Deprecated
    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    @Override
    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        return this.defaultModel.getParticleIcon(modelData);
    }

    @Override
    @Deprecated
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @Override
    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.defaultModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    @Override
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        LinkedList<ChunkRenderTypeSet> renderTypeSets = new LinkedList<ChunkRenderTypeSet>();
        BitSet selectors = this.getSelectors(state);
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            renderTypeSets.add(((BakedModel)this.selectors.get(i).getRight()).getRenderTypes(state, rand, data));
        }
        return ChunkRenderTypeSet.union(renderTypeSets);
    }

    @Override
    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<Pair<Predicate<BlockState>, BakedModel>> selectors = Lists.newArrayList();

        public void add(Predicate<BlockState> p_119478_, BakedModel p_119479_) {
            this.selectors.add((Pair<Predicate<BlockState>, BakedModel>)Pair.of(p_119478_, (Object)p_119479_));
        }

        public BakedModel build() {
            return new MultiPartBakedModel(this.selectors);
        }
    }
}

