/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.animation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;

@OnlyIn(value=Dist.CLIENT)
public class AnimationMetadataSectionSerializer
implements MetadataSectionSerializer<AnimationMetadataSection> {
    @Override
    public AnimationMetadataSection fromJson(JsonObject p_119064_) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = GsonHelper.getAsInt(p_119064_, "frametime", 1);
        if (i != 1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid default frame time");
        }
        if (p_119064_.has("frames")) {
            try {
                JsonArray jsonarray = GsonHelper.getAsJsonArray(p_119064_, "frames");
                for (int j = 0; j < jsonarray.size(); ++j) {
                    JsonElement jsonelement = jsonarray.get(j);
                    AnimationFrame animationframe = this.getFrame(j, jsonelement);
                    if (animationframe == null) continue;
                    builder.add((Object)animationframe);
                }
            }
            catch (ClassCastException classcastexception) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + String.valueOf(p_119064_.get("frames")), (Throwable)classcastexception);
            }
        }
        int k = GsonHelper.getAsInt(p_119064_, "width", -1);
        int l = GsonHelper.getAsInt(p_119064_, "height", -1);
        if (k != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)k, (String)"Invalid width");
        }
        if (l != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)l, (String)"Invalid height");
        }
        boolean flag = GsonHelper.getAsBoolean(p_119064_, "interpolate", false);
        return new AnimationMetadataSection((List<AnimationFrame>)builder.build(), k, l, i, flag);
    }

    @Nullable
    private AnimationFrame getFrame(int p_119059_, JsonElement p_119060_) {
        if (p_119060_.isJsonPrimitive()) {
            return new AnimationFrame(GsonHelper.convertToInt(p_119060_, "frames[" + p_119059_ + "]"));
        }
        if (p_119060_.isJsonObject()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_119060_, "frames[" + p_119059_ + "]");
            int i = GsonHelper.getAsInt(jsonobject, "time", -1);
            if (jsonobject.has("time")) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid frame time");
            }
            int j = GsonHelper.getAsInt(jsonobject, "index");
            Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)j, (String)"Invalid frame index");
            return new AnimationFrame(j, i);
        }
        return null;
    }

    @Override
    public String getMetadataSectionName() {
        return "animation";
    }
}

