/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultPlayerSkin {
    private static final SkinType[] DEFAULT_SKINS = new SkinType[]{new SkinType("textures/entity/player/slim/alex.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/ari.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/efe.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/kai.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/makena.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/noor.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/steve.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/sunny.png", ModelType.SLIM), new SkinType("textures/entity/player/slim/zuri.png", ModelType.SLIM), new SkinType("textures/entity/player/wide/alex.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/ari.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/efe.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/kai.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/makena.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/noor.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/steve.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/sunny.png", ModelType.WIDE), new SkinType("textures/entity/player/wide/zuri.png", ModelType.WIDE)};

    public static ResourceLocation getDefaultSkin() {
        return DEFAULT_SKINS[6].texture();
    }

    public static ResourceLocation getDefaultSkin(UUID p_118628_) {
        return DefaultPlayerSkin.getSkinType((UUID)p_118628_).texture;
    }

    public static String getSkinModelName(UUID p_118630_) {
        return DefaultPlayerSkin.getSkinType((UUID)p_118630_).model.id;
    }

    private static SkinType getSkinType(UUID p_260299_) {
        return DEFAULT_SKINS[Math.floorMod(p_260299_.hashCode(), DEFAULT_SKINS.length)];
    }

    @OnlyIn(value=Dist.CLIENT)
    record SkinType(ResourceLocation texture, ModelType model) {
        public SkinType(String p_259984_, ModelType p_259456_) {
            this(new ResourceLocation(p_259984_), p_259456_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum ModelType {
        SLIM("slim"),
        WIDE("default");

        final String id;

        private ModelType(String p_260160_) {
            this.id = p_260160_;
        }
    }
}

