/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Unstitcher
implements SpriteSource {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<Unstitcher> CODEC = RecordCodecBuilder.create(p_262047_ -> p_262047_.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(p_261910_ -> p_261910_.resource), (App)ExtraCodecs.nonEmptyList(Region.CODEC.listOf()).fieldOf("regions").forGetter(p_261944_ -> p_261944_.regions), (App)Codec.DOUBLE.optionalFieldOf("divisor_x", (Object)1.0).forGetter(p_261601_ -> p_261601_.xDivisor), (App)Codec.DOUBLE.optionalFieldOf("divisor_y", (Object)1.0).forGetter(p_262039_ -> p_262039_.yDivisor)).apply((Applicative)p_262047_, Unstitcher::new));
    private final ResourceLocation resource;
    private final List<Region> regions;
    private final double xDivisor;
    private final double yDivisor;

    public Unstitcher(ResourceLocation p_261679_, List<Region> p_261974_, double p_262181_, double p_261631_) {
        this.resource = p_261679_;
        this.regions = p_261974_;
        this.xDivisor = p_262181_;
        this.yDivisor = p_261631_;
    }

    @Override
    public void run(ResourceManager p_261498_, SpriteSource.Output p_261828_) {
        ResourceLocation resourcelocation = TEXTURE_ID_CONVERTER.idToFile(this.resource);
        Optional<Resource> optional = p_261498_.getResource(resourcelocation);
        if (optional.isPresent()) {
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(resourcelocation, optional.get(), this.regions.size());
            for (Region unstitcher$region : this.regions) {
                p_261828_.add(unstitcher$region.sprite, new RegionInstance(lazyloadedimage, unstitcher$region, this.xDivisor, this.yDivisor));
            }
        } else {
            LOGGER.warn("Missing sprite: {}", (Object)resourcelocation);
        }
    }

    @Override
    public SpriteSourceType type() {
        return SpriteSources.UNSTITCHER;
    }

    @OnlyIn(value=Dist.CLIENT)
    record Region(ResourceLocation sprite, double x, double y, double width, double height) {
        public static final Codec<Region> CODEC = RecordCodecBuilder.create(p_261521_ -> p_261521_.group((App)ResourceLocation.CODEC.fieldOf("sprite").forGetter(Region::sprite), (App)Codec.DOUBLE.fieldOf("x").forGetter(Region::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(Region::y), (App)Codec.DOUBLE.fieldOf("width").forGetter(Region::width), (App)Codec.DOUBLE.fieldOf("height").forGetter(Region::height)).apply((Applicative)p_261521_, Region::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class RegionInstance
    implements SpriteSource.SpriteSupplier {
        private final LazyLoadedImage image;
        private final Region region;
        private final double xDivisor;
        private final double yDivisor;

        RegionInstance(LazyLoadedImage p_266678_, Region p_267197_, double p_266911_, double p_266789_) {
            this.image = p_266678_;
            this.region = p_267197_;
            this.xDivisor = p_266911_;
            this.yDivisor = p_266789_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SpriteContents get() {
            try {
                NativeImage nativeimage = this.image.get();
                double d0 = (double)nativeimage.getWidth() / this.xDivisor;
                double d1 = (double)nativeimage.getHeight() / this.yDivisor;
                int i = Mth.floor(this.region.x * d0);
                int j = Mth.floor(this.region.y * d1);
                int k = Mth.floor(this.region.width * d0);
                int l = Mth.floor(this.region.height * d1);
                NativeImage nativeimage1 = new NativeImage(NativeImage.Format.RGBA, k, l, false);
                nativeimage.copyRect(nativeimage1, i, j, 0, 0, k, l, false, false);
                SpriteContents spriteContents = new SpriteContents(this.region.sprite, new FrameSize(k, l), nativeimage1, AnimationMetadataSection.EMPTY);
                return spriteContents;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to unstitch region {}", (Object)this.region.sprite, (Object)exception);
            }
            finally {
                this.image.release();
            }
            return MissingTextureAtlasSprite.create();
        }

        @Override
        public void discard() {
            this.image.release();
        }
    }
}

