/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface SpriteSource {
    public static final FileToIdConverter TEXTURE_ID_CONVERTER = new FileToIdConverter("textures", ".png");

    public void run(ResourceManager var1, Output var2);

    public SpriteSourceType type();

    @OnlyIn(value=Dist.CLIENT)
    public static interface SpriteSupplier
    extends Supplier<SpriteContents> {
        default public void discard() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Output {
        default public void add(ResourceLocation p_261841_, Resource p_261651_) {
            this.add(p_261841_, () -> SpriteLoader.loadSprite(p_261841_, p_261651_));
        }

        public void add(ResourceLocation var1, SpriteSupplier var2);

        public void removeAll(Predicate<ResourceLocation> var1);
    }
}

