/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BeeStingerLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private static final ResourceLocation BEE_STINGER_LOCATION = new ResourceLocation("textures/entity/bee/bee_stinger.png");

    public BeeStingerLayer(LivingEntityRenderer<T, M> p_116580_) {
        super(p_116580_);
    }

    @Override
    protected int numStuck(T p_116582_) {
        return ((LivingEntity)p_116582_).getStingerCount();
    }

    @Override
    protected void renderStuckItem(PoseStack p_116584_, MultiBufferSource p_116585_, int p_116586_, Entity p_116587_, float p_116588_, float p_116589_, float p_116590_, float p_116591_) {
        float f = Mth.sqrt(p_116588_ * p_116588_ + p_116590_ * p_116590_);
        float f1 = (float)(Math.atan2(p_116588_, p_116590_) * 57.2957763671875);
        float f2 = (float)(Math.atan2(p_116589_, f) * 57.2957763671875);
        p_116584_.translate(0.0f, 0.0f, 0.0f);
        p_116584_.mulPose(Axis.YP.rotationDegrees(f1 - 90.0f));
        p_116584_.mulPose(Axis.ZP.rotationDegrees(f2));
        float f3 = 0.0f;
        float f4 = 0.125f;
        float f5 = 0.0f;
        float f6 = 0.0625f;
        float f7 = 0.03125f;
        p_116584_.mulPose(Axis.XP.rotationDegrees(45.0f));
        p_116584_.scale(0.03125f, 0.03125f, 0.03125f);
        p_116584_.translate(2.5f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = p_116585_.getBuffer(RenderType.entityCutoutNoCull(BEE_STINGER_LOCATION));
        for (int i = 0; i < 4; ++i) {
            p_116584_.mulPose(Axis.XP.rotationDegrees(90.0f));
            PoseStack.Pose posestack$pose = p_116584_.last();
            Matrix4f matrix4f = posestack$pose.pose();
            Matrix3f matrix3f = posestack$pose.normal();
            BeeStingerLayer.vertex(vertexconsumer, matrix4f, matrix3f, -4.5f, -1, 0.0f, 0.0f, p_116586_);
            BeeStingerLayer.vertex(vertexconsumer, matrix4f, matrix3f, 4.5f, -1, 0.125f, 0.0f, p_116586_);
            BeeStingerLayer.vertex(vertexconsumer, matrix4f, matrix3f, 4.5f, 1, 0.125f, 0.0625f, p_116586_);
            BeeStingerLayer.vertex(vertexconsumer, matrix4f, matrix3f, -4.5f, 1, 0.0f, 0.0625f, p_116586_);
        }
    }

    private static void vertex(VertexConsumer p_254470_, Matrix4f p_254513_, Matrix3f p_254052_, float p_253749_, int p_254520_, float p_254099_, float p_253914_, int p_254168_) {
        p_254470_.vertex(p_254513_, p_253749_, p_254520_, 0.0f).color(255, 255, 255, 255).uv(p_254099_, p_253914_).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(p_254168_).normal(p_254052_, 0.0f, 1.0f, 0.0f).endVertex();
    }
}

