/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class MobRenderer<T extends Mob, M extends EntityModel<T>>
extends LivingEntityRenderer<T, M> {
    public static final int LEASH_RENDER_STEPS = 24;

    public MobRenderer(EntityRendererProvider.Context p_174304_, M p_174305_, float p_174306_) {
        super(p_174304_, p_174305_, p_174306_);
    }

    @Override
    protected boolean shouldShowName(T p_115506_) {
        return super.shouldShowName(p_115506_) && (((LivingEntity)p_115506_).shouldShowName() || ((Entity)p_115506_).hasCustomName() && p_115506_ == this.entityRenderDispatcher.crosshairPickEntity);
    }

    @Override
    public boolean shouldRender(T p_115468_, Frustum p_115469_, double p_115470_, double p_115471_, double p_115472_) {
        if (super.shouldRender(p_115468_, p_115469_, p_115470_, p_115471_, p_115472_)) {
            return true;
        }
        Entity entity = ((Mob)p_115468_).getLeashHolder();
        return entity != null ? p_115469_.isVisible(entity.getBoundingBoxForCulling()) : false;
    }

    @Override
    public void render(T p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        super.render(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        Entity entity = ((Mob)p_115455_).getLeashHolder();
        if (entity != null) {
            this.renderLeash(p_115455_, p_115457_, p_115458_, p_115459_, entity);
        }
    }

    private <E extends Entity> void renderLeash(T p_115462_, float p_115463_, PoseStack p_115464_, MultiBufferSource p_115465_, E p_115466_) {
        p_115464_.pushPose();
        Vec3 vec3 = p_115466_.getRopeHoldPosition(p_115463_);
        double d0 = (double)(Mth.lerp(p_115463_, ((Mob)p_115462_).yBodyRotO, ((Mob)p_115462_).yBodyRot) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = ((Entity)p_115462_).getLeashOffset(p_115463_);
        double d1 = Math.cos(d0) * vec31.z + Math.sin(d0) * vec31.x;
        double d2 = Math.sin(d0) * vec31.z - Math.cos(d0) * vec31.x;
        double d3 = Mth.lerp((double)p_115463_, ((Mob)p_115462_).xo, ((Entity)p_115462_).getX()) + d1;
        double d4 = Mth.lerp((double)p_115463_, ((Mob)p_115462_).yo, ((Entity)p_115462_).getY()) + vec31.y;
        double d5 = Mth.lerp((double)p_115463_, ((Mob)p_115462_).zo, ((Entity)p_115462_).getZ()) + d2;
        p_115464_.translate(d1, vec31.y, d2);
        float f = (float)(vec3.x - d3);
        float f1 = (float)(vec3.y - d4);
        float f2 = (float)(vec3.z - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = p_115465_.getBuffer(RenderType.leash());
        Matrix4f matrix4f = p_115464_.last().pose();
        float f4 = Mth.invSqrt(f * f + f2 * f2) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.containing(((Entity)p_115462_).getEyePosition(p_115463_));
        BlockPos blockpos1 = BlockPos.containing(p_115466_.getEyePosition(p_115463_));
        int i = this.getBlockLightLevel(p_115462_, blockpos);
        int j = this.entityRenderDispatcher.getRenderer(p_115466_).getBlockLightLevel(p_115466_, blockpos1);
        int k = ((Entity)p_115462_).level().getBrightness(LightLayer.SKY, blockpos);
        int l = ((Entity)p_115462_).level().getBrightness(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            MobRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            MobRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.0f, f5, f6, j1, true);
        }
        p_115464_.popPose();
    }

    private static void addVertexPair(VertexConsumer p_174308_, Matrix4f p_254405_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.lerp(f, p_174313_, p_174314_);
        int j = (int)Mth.lerp(f, p_174315_, p_174316_);
        int k = LightTexture.pack(i, j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.vertex(p_254405_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).color(f2, f3, f4, 1.0f).uv2(k).endVertex();
        p_174308_.vertex(p_254405_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).color(f2, f3, f4, 1.0f).uv2(k).endVertex();
    }
}

