/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChunkDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    final Minecraft minecraft;
    private double lastUpdateTime = Double.MIN_VALUE;
    private final int radius = 12;
    @Nullable
    private ChunkData data;

    public ChunkDebugRenderer(Minecraft p_113368_) {
        this.minecraft = p_113368_;
    }

    @Override
    public void render(PoseStack p_113370_, MultiBufferSource p_113371_, double p_113372_, double p_113373_, double p_113374_) {
        double d0 = Util.getNanos();
        if (d0 - this.lastUpdateTime > 3.0E9) {
            this.lastUpdateTime = d0;
            IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
            this.data = integratedserver != null ? new ChunkData(integratedserver, p_113372_, p_113374_) : null;
        }
        if (this.data != null) {
            Map<ChunkPos, String> map = this.data.serverData.getNow(null);
            double d1 = this.minecraft.gameRenderer.getMainCamera().getPosition().y * 0.85;
            for (Map.Entry<ChunkPos, String> entry : this.data.clientData.entrySet()) {
                ChunkPos chunkpos = entry.getKey();
                Object s = entry.getValue();
                if (map != null) {
                    s = (String)s + map.get(chunkpos);
                }
                String[] astring = ((String)s).split("\n");
                int i = 0;
                for (String s1 : astring) {
                    DebugRenderer.renderFloatingText(p_113370_, p_113371_, s1, SectionPos.sectionToBlockCoord(chunkpos.x, 8), d1 + (double)i, SectionPos.sectionToBlockCoord(chunkpos.z, 8), -1, 0.15f, true, 0.0f, true);
                    i -= 2;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ChunkData {
        final Map<ChunkPos, String> clientData;
        final CompletableFuture<Map<ChunkPos, String>> serverData;

        ChunkData(IntegratedServer p_113382_, double p_113383_, double p_113384_) {
            ClientLevel clientlevel = ChunkDebugRenderer.this.minecraft.level;
            ResourceKey<Level> resourcekey = clientlevel.dimension();
            int i = SectionPos.posToSectionCoord(p_113383_);
            int j = SectionPos.posToSectionCoord(p_113384_);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ClientChunkCache clientchunkcache = clientlevel.getChunkSource();
            for (int k = i - 12; k <= i + 12; ++k) {
                for (int l = j - 12; l <= j + 12; ++l) {
                    ChunkPos chunkpos = new ChunkPos(k, l);
                    Object s = "";
                    LevelChunk levelchunk = clientchunkcache.getChunk(k, l, false);
                    s = (String)s + "Client: ";
                    if (levelchunk == null) {
                        s = (String)s + "0n/a\n";
                    } else {
                        s = (String)s + (levelchunk.isEmpty() ? " E" : "");
                        s = (String)s + "\n";
                    }
                    builder.put((Object)chunkpos, s);
                }
            }
            this.clientData = builder.build();
            this.serverData = p_113382_.submit(() -> {
                ServerLevel serverlevel = p_113382_.getLevel(resourcekey);
                if (serverlevel == null) {
                    return ImmutableMap.of();
                }
                ImmutableMap.Builder builder1 = ImmutableMap.builder();
                ServerChunkCache serverchunkcache = serverlevel.getChunkSource();
                for (int i1 = i - 12; i1 <= i + 12; ++i1) {
                    for (int j1 = j - 12; j1 <= j + 12; ++j1) {
                        ChunkPos chunkpos1 = new ChunkPos(i1, j1);
                        builder1.put((Object)chunkpos1, (Object)("Server: " + serverchunkcache.getChunkDebugData(chunkpos1)));
                    }
                }
                return builder1.build();
            });
        }
    }
}

