/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeyValueCondition
implements Condition {
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').omitEmptyStrings();
    private final String key;
    private final String value;

    public KeyValueCondition(String p_111939_, String p_111940_) {
        this.key = p_111939_;
        this.value = p_111940_;
    }

    @Override
    public Predicate<BlockState> getPredicate(StateDefinition<Block, BlockState> p_111960_) {
        Predicate<BlockState> predicate;
        List list;
        boolean flag;
        Property<?> property = p_111960_.getProperty(this.key);
        if (property == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "Unknown property '%s' on '%s'", this.key, p_111960_.getOwner()));
        }
        String s = this.value;
        boolean bl = flag = !s.isEmpty() && s.charAt(0) == '!';
        if (flag) {
            s = s.substring(1);
        }
        if ((list = PIPE_SPLITTER.splitToList((CharSequence)s)).isEmpty()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Empty value '%s' for property '%s' on '%s'", this.value, this.key, p_111960_.getOwner()));
        }
        if (list.size() == 1) {
            predicate = this.getBlockStatePredicate(p_111960_, property, s);
        } else {
            List list1 = list.stream().map(p_111958_ -> this.getBlockStatePredicate(p_111960_, property, (String)p_111958_)).collect(Collectors.toList());
            predicate = p_111954_ -> list1.stream().anyMatch(p_173509_ -> p_173509_.test(p_111954_));
        }
        return flag ? predicate.negate() : predicate;
    }

    private Predicate<BlockState> getBlockStatePredicate(StateDefinition<Block, BlockState> p_111945_, Property<?> p_111946_, String p_111947_) {
        Optional<?> optional = p_111946_.getValue(p_111947_);
        if (!optional.isPresent()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Unknown value '%s' for property '%s' on '%s' in '%s'", p_111947_, this.key, p_111945_.getOwner(), this.value));
        }
        return p_111951_ -> p_111951_.getValue(p_111946_).equals(optional.get());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }
}

