/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.SortedMap;
import net.minecraft.Util;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBuffers {
    private final ChunkBufferBuilderPack fixedBufferPack = new ChunkBufferBuilderPack();
    private final SortedMap<RenderType, BufferBuilder> fixedBuffers = (SortedMap)Util.make(new Object2ObjectLinkedOpenHashMap(), p_269658_ -> {
        p_269658_.put((Object)Sheets.solidBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.solid()));
        p_269658_.put((Object)Sheets.cutoutBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutout()));
        p_269658_.put((Object)Sheets.bannerSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutoutMipped()));
        p_269658_.put((Object)Sheets.translucentCullBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.translucent()));
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.shieldSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.bedSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.shulkerBoxSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.signSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.hangingSignSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, Sheets.chestSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.translucentNoCrumbling());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.armorGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.armorEntityGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.glint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.glintDirect());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.glintTranslucent());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.entityGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.entityGlintDirect());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, RenderType.waterMask());
        ModelBakery.DESTROY_TYPES.forEach(p_173062_ -> RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_269658_, p_173062_));
    });
    private final MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediateWithBuffers(this.fixedBuffers, new BufferBuilder(256));
    private final MultiBufferSource.BufferSource crumblingBufferSource = MultiBufferSource.immediate(new BufferBuilder(256));
    private final OutlineBufferSource outlineBufferSource = new OutlineBufferSource(this.bufferSource);

    private static void put(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> p_110102_, RenderType p_110103_) {
        p_110102_.put((Object)p_110103_, (Object)new BufferBuilder(p_110103_.bufferSize()));
    }

    public ChunkBufferBuilderPack fixedBufferPack() {
        return this.fixedBufferPack;
    }

    public MultiBufferSource.BufferSource bufferSource() {
        return this.bufferSource;
    }

    public MultiBufferSource.BufferSource crumblingBufferSource() {
        return this.crumblingBufferSource;
    }

    public OutlineBufferSource outlineBufferSource() {
        return this.outlineBufferSource;
    }
}

