/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WitherBossModel<T extends WitherBoss>
extends HierarchicalModel<T> {
    private static final String RIBCAGE = "ribcage";
    private static final String CENTER_HEAD = "center_head";
    private static final String RIGHT_HEAD = "right_head";
    private static final String LEFT_HEAD = "left_head";
    private static final float RIBCAGE_X_ROT_OFFSET = 0.065f;
    private static final float TAIL_X_ROT_OFFSET = 0.265f;
    private final ModelPart root;
    private final ModelPart centerHead;
    private final ModelPart rightHead;
    private final ModelPart leftHead;
    private final ModelPart ribcage;
    private final ModelPart tail;

    public WitherBossModel(ModelPart p_171070_) {
        this.root = p_171070_;
        this.ribcage = p_171070_.getChild(RIBCAGE);
        this.tail = p_171070_.getChild("tail");
        this.centerHead = p_171070_.getChild(CENTER_HEAD);
        this.rightHead = p_171070_.getChild(RIGHT_HEAD);
        this.leftHead = p_171070_.getChild(LEFT_HEAD);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_171076_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("shoulders", CubeListBuilder.create().texOffs(0, 16).addBox(-10.0f, 3.9f, -0.5f, 20.0f, 3.0f, 3.0f, p_171076_), PartPose.ZERO);
        float f = 0.20420352f;
        partdefinition.addOrReplaceChild(RIBCAGE, CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, p_171076_).texOffs(24, 22).addBox(-4.0f, 1.5f, 0.5f, 11.0f, 2.0f, 2.0f, p_171076_).texOffs(24, 22).addBox(-4.0f, 4.0f, 0.5f, 11.0f, 2.0f, 2.0f, p_171076_).texOffs(24, 22).addBox(-4.0f, 6.5f, 0.5f, 11.0f, 2.0f, 2.0f, p_171076_), PartPose.offsetAndRotation(-2.0f, 6.9f, -0.5f, 0.20420352f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(12, 22).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f, p_171076_), PartPose.offsetAndRotation(-2.0f, 6.9f + Mth.cos(0.20420352f) * 10.0f, -0.5f + Mth.sin(0.20420352f) * 10.0f, 0.83252203f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(CENTER_HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_171076_), PartPose.ZERO);
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 6.0f, 6.0f, 6.0f, p_171076_);
        partdefinition.addOrReplaceChild(RIGHT_HEAD, cubelistbuilder, PartPose.offset(-8.0f, 4.0f, 0.0f));
        partdefinition.addOrReplaceChild(LEFT_HEAD, cubelistbuilder, PartPose.offset(10.0f, 4.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(T p_104100_, float p_104101_, float p_104102_, float p_104103_, float p_104104_, float p_104105_) {
        float f = Mth.cos(p_104103_ * 0.1f);
        this.ribcage.xRot = (0.065f + 0.05f * f) * (float)Math.PI;
        this.tail.setPos(-2.0f, 6.9f + Mth.cos(this.ribcage.xRot) * 10.0f, -0.5f + Mth.sin(this.ribcage.xRot) * 10.0f);
        this.tail.xRot = (0.265f + 0.1f * f) * (float)Math.PI;
        this.centerHead.yRot = p_104104_ * ((float)Math.PI / 180);
        this.centerHead.xRot = p_104105_ * ((float)Math.PI / 180);
    }

    @Override
    public void prepareMobModel(T p_104095_, float p_104096_, float p_104097_, float p_104098_) {
        WitherBossModel.setupHeadRotation(p_104095_, this.rightHead, 0);
        WitherBossModel.setupHeadRotation(p_104095_, this.leftHead, 1);
    }

    private static <T extends WitherBoss> void setupHeadRotation(T p_171072_, ModelPart p_171073_, int p_171074_) {
        p_171073_.yRot = (p_171072_.getHeadYRot(p_171074_) - p_171072_.yBodyRot) * ((float)Math.PI / 180);
        p_171073_.xRot = p_171072_.getHeadXRot(p_171074_) * ((float)Math.PI / 180);
    }
}

