/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.animation.definitions.WardenAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WardenModel<T extends Warden>
extends HierarchicalModel<T> {
    private static final float DEFAULT_ARM_X_Y = 13.0f;
    private static final float DEFAULT_ARM_Z = 1.0f;
    private final ModelPart root;
    protected final ModelPart bone;
    protected final ModelPart body;
    protected final ModelPart head;
    protected final ModelPart rightTendril;
    protected final ModelPart leftTendril;
    protected final ModelPart leftLeg;
    protected final ModelPart leftArm;
    protected final ModelPart leftRibcage;
    protected final ModelPart rightArm;
    protected final ModelPart rightLeg;
    protected final ModelPart rightRibcage;
    private final List<ModelPart> tendrilsLayerModelParts;
    private final List<ModelPart> heartLayerModelParts;
    private final List<ModelPart> bioluminescentLayerModelParts;
    private final List<ModelPart> pulsatingSpotsLayerModelParts;

    public WardenModel(ModelPart p_233512_) {
        super(RenderType::entityCutoutNoCull);
        this.root = p_233512_;
        this.bone = p_233512_.getChild("bone");
        this.body = this.bone.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.bone.getChild("right_leg");
        this.leftLeg = this.bone.getChild("left_leg");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightTendril = this.head.getChild("right_tendril");
        this.leftTendril = this.head.getChild("left_tendril");
        this.rightRibcage = this.body.getChild("right_ribcage");
        this.leftRibcage = this.body.getChild("left_ribcage");
        this.tendrilsLayerModelParts = ImmutableList.of((Object)this.leftTendril, (Object)this.rightTendril);
        this.heartLayerModelParts = ImmutableList.of((Object)this.body);
        this.bioluminescentLayerModelParts = ImmutableList.of((Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.pulsatingSpotsLayerModelParts = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset(0.0f, 24.0f, 0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f), PartPose.offset(0.0f, -21.0f, 0.0f));
        partdefinition2.addOrReplaceChild("right_ribcage", CubeListBuilder.create().texOffs(90, 11).addBox(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f), PartPose.offset(-7.0f, -2.0f, -4.0f));
        partdefinition2.addOrReplaceChild("left_ribcage", CubeListBuilder.create().texOffs(90, 11).mirror().addBox(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f).mirror(false), PartPose.offset(7.0f, -2.0f, -4.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f), PartPose.offset(0.0f, -13.0f, 0.0f));
        partdefinition3.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(52, 32).addBox(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset(-8.0f, -12.0f, 0.0f));
        partdefinition3.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(58, 0).addBox(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset(8.0f, -12.0f, 0.0f));
        partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 50).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.offset(-13.0f, -13.0f, 1.0f));
        partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 58).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.offset(13.0f, -13.0f, 1.0f));
        partdefinition1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(76, 48).addBox(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset(-5.9f, -13.0f, 0.0f));
        partdefinition1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(76, 76).addBox(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset(5.9f, -13.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 128, 128);
    }

    @Override
    public void setupAnim(T p_233531_, float p_233532_, float p_233533_, float p_233534_, float p_233535_, float p_233536_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float f = p_233534_ - (float)((Warden)p_233531_).tickCount;
        this.animateHeadLookTarget(p_233535_, p_233536_);
        this.animateWalk(p_233532_, p_233533_);
        this.animateIdlePose(p_233534_);
        this.animateTendrils(p_233531_, p_233534_, f);
        this.animate(((Warden)p_233531_).attackAnimationState, WardenAnimation.WARDEN_ATTACK, p_233534_);
        this.animate(((Warden)p_233531_).sonicBoomAnimationState, WardenAnimation.WARDEN_SONIC_BOOM, p_233534_);
        this.animate(((Warden)p_233531_).diggingAnimationState, WardenAnimation.WARDEN_DIG, p_233534_);
        this.animate(((Warden)p_233531_).emergeAnimationState, WardenAnimation.WARDEN_EMERGE, p_233534_);
        this.animate(((Warden)p_233531_).roarAnimationState, WardenAnimation.WARDEN_ROAR, p_233534_);
        this.animate(((Warden)p_233531_).sniffAnimationState, WardenAnimation.WARDEN_SNIFF, p_233534_);
    }

    private void animateHeadLookTarget(float p_233517_, float p_233518_) {
        this.head.xRot = p_233518_ * ((float)Math.PI / 180);
        this.head.yRot = p_233517_ * ((float)Math.PI / 180);
    }

    private void animateIdlePose(float p_233515_) {
        float f = p_233515_ * 0.1f;
        float f1 = Mth.cos(f);
        float f2 = Mth.sin(f);
        this.head.zRot += 0.06f * f1;
        this.head.xRot += 0.06f * f2;
        this.body.zRot += 0.025f * f2;
        this.body.xRot += 0.025f * f1;
    }

    private void animateWalk(float p_233539_, float p_233540_) {
        float f = Math.min(0.5f, 3.0f * p_233540_);
        float f1 = p_233539_ * 0.8662f;
        float f2 = Mth.cos(f1);
        float f3 = Mth.sin(f1);
        float f4 = Math.min(0.35f, f);
        this.head.zRot += 0.3f * f3 * f;
        this.head.xRot += 1.2f * Mth.cos(f1 + 1.5707964f) * f4;
        this.body.zRot = 0.1f * f3 * f;
        this.body.xRot = 1.0f * f2 * f4;
        this.leftLeg.xRot = 1.0f * f2 * f;
        this.rightLeg.xRot = 1.0f * Mth.cos(f1 + (float)Math.PI) * f;
        this.leftArm.xRot = -(0.8f * f2 * f);
        this.leftArm.zRot = 0.0f;
        this.rightArm.xRot = -(0.8f * f3 * f);
        this.rightArm.zRot = 0.0f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.leftArm.yRot = 0.0f;
        this.leftArm.z = 1.0f;
        this.leftArm.x = 13.0f;
        this.leftArm.y = -13.0f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.z = 1.0f;
        this.rightArm.x = -13.0f;
        this.rightArm.y = -13.0f;
    }

    private void animateTendrils(T p_233527_, float p_233528_, float p_233529_) {
        float f;
        this.leftTendril.xRot = f = ((Warden)p_233527_).getTendrilAnimation(p_233529_) * (float)(Math.cos((double)p_233528_ * 2.25) * Math.PI * (double)0.1f);
        this.rightTendril.xRot = -f;
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    public List<ModelPart> getTendrilsLayerModelParts() {
        return this.tendrilsLayerModelParts;
    }

    public List<ModelPart> getHeartLayerModelParts() {
        return this.heartLayerModelParts;
    }

    public List<ModelPart> getBioluminescentLayerModelParts() {
        return this.bioluminescentLayerModelParts;
    }

    public List<ModelPart> getPulsatingSpotsLayerModelParts() {
        return this.pulsatingSpotsLayerModelParts;
    }
}

