/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpiderModel<T extends Entity>
extends HierarchicalModel<T> {
    private static final String BODY_0 = "body0";
    private static final String BODY_1 = "body1";
    private static final String RIGHT_MIDDLE_FRONT_LEG = "right_middle_front_leg";
    private static final String LEFT_MIDDLE_FRONT_LEG = "left_middle_front_leg";
    private static final String RIGHT_MIDDLE_HIND_LEG = "right_middle_hind_leg";
    private static final String LEFT_MIDDLE_HIND_LEG = "left_middle_hind_leg";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart rightMiddleFrontLeg;
    private final ModelPart leftMiddleFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public SpiderModel(ModelPart p_170984_) {
        this.root = p_170984_;
        this.head = p_170984_.getChild("head");
        this.rightHindLeg = p_170984_.getChild("right_hind_leg");
        this.leftHindLeg = p_170984_.getChild("left_hind_leg");
        this.rightMiddleHindLeg = p_170984_.getChild(RIGHT_MIDDLE_HIND_LEG);
        this.leftMiddleHindLeg = p_170984_.getChild(LEFT_MIDDLE_HIND_LEG);
        this.rightMiddleFrontLeg = p_170984_.getChild(RIGHT_MIDDLE_FRONT_LEG);
        this.leftMiddleFrontLeg = p_170984_.getChild(LEFT_MIDDLE_FRONT_LEG);
        this.rightFrontLeg = p_170984_.getChild("right_front_leg");
        this.leftFrontLeg = p_170984_.getChild("left_front_leg");
    }

    public static LayerDefinition createSpiderBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 15;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f), PartPose.offset(0.0f, 15.0f, -3.0f));
        partdefinition.addOrReplaceChild(BODY_0, CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset(0.0f, 15.0f, 0.0f));
        partdefinition.addOrReplaceChild(BODY_1, CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 12.0f), PartPose.offset(0.0f, 15.0f, 9.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(18, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset(-4.0f, 15.0f, 2.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder1, PartPose.offset(4.0f, 15.0f, 2.0f));
        partdefinition.addOrReplaceChild(RIGHT_MIDDLE_HIND_LEG, cubelistbuilder, PartPose.offset(-4.0f, 15.0f, 1.0f));
        partdefinition.addOrReplaceChild(LEFT_MIDDLE_HIND_LEG, cubelistbuilder1, PartPose.offset(4.0f, 15.0f, 1.0f));
        partdefinition.addOrReplaceChild(RIGHT_MIDDLE_FRONT_LEG, cubelistbuilder, PartPose.offset(-4.0f, 15.0f, 0.0f));
        partdefinition.addOrReplaceChild(LEFT_MIDDLE_FRONT_LEG, cubelistbuilder1, PartPose.offset(4.0f, 15.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset(-4.0f, 15.0f, -1.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder1, PartPose.offset(4.0f, 15.0f, -1.0f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(T p_103866_, float p_103867_, float p_103868_, float p_103869_, float p_103870_, float p_103871_) {
        this.head.yRot = p_103870_ * ((float)Math.PI / 180);
        this.head.xRot = p_103871_ * ((float)Math.PI / 180);
        float f = 0.7853982f;
        this.rightHindLeg.zRot = -0.7853982f;
        this.leftHindLeg.zRot = 0.7853982f;
        this.rightMiddleHindLeg.zRot = -0.58119464f;
        this.leftMiddleHindLeg.zRot = 0.58119464f;
        this.rightMiddleFrontLeg.zRot = -0.58119464f;
        this.leftMiddleFrontLeg.zRot = 0.58119464f;
        this.rightFrontLeg.zRot = -0.7853982f;
        this.leftFrontLeg.zRot = 0.7853982f;
        float f1 = -0.0f;
        float f2 = 0.3926991f;
        this.rightHindLeg.yRot = 0.7853982f;
        this.leftHindLeg.yRot = -0.7853982f;
        this.rightMiddleHindLeg.yRot = 0.3926991f;
        this.leftMiddleHindLeg.yRot = -0.3926991f;
        this.rightMiddleFrontLeg.yRot = -0.3926991f;
        this.leftMiddleFrontLeg.yRot = 0.3926991f;
        this.rightFrontLeg.yRot = -0.7853982f;
        this.leftFrontLeg.yRot = 0.7853982f;
        float f3 = -(Mth.cos(p_103867_ * 0.6662f * 2.0f + 0.0f) * 0.4f) * p_103868_;
        float f4 = -(Mth.cos(p_103867_ * 0.6662f * 2.0f + (float)Math.PI) * 0.4f) * p_103868_;
        float f5 = -(Mth.cos(p_103867_ * 0.6662f * 2.0f + 1.5707964f) * 0.4f) * p_103868_;
        float f6 = -(Mth.cos(p_103867_ * 0.6662f * 2.0f + 4.712389f) * 0.4f) * p_103868_;
        float f7 = Math.abs(Mth.sin(p_103867_ * 0.6662f + 0.0f) * 0.4f) * p_103868_;
        float f8 = Math.abs(Mth.sin(p_103867_ * 0.6662f + (float)Math.PI) * 0.4f) * p_103868_;
        float f9 = Math.abs(Mth.sin(p_103867_ * 0.6662f + 1.5707964f) * 0.4f) * p_103868_;
        float f10 = Math.abs(Mth.sin(p_103867_ * 0.6662f + 4.712389f) * 0.4f) * p_103868_;
        this.rightHindLeg.yRot += f3;
        this.leftHindLeg.yRot += -f3;
        this.rightMiddleHindLeg.yRot += f4;
        this.leftMiddleHindLeg.yRot += -f4;
        this.rightMiddleFrontLeg.yRot += f5;
        this.leftMiddleFrontLeg.yRot += -f5;
        this.rightFrontLeg.yRot += f6;
        this.leftFrontLeg.yRot += -f6;
        this.rightHindLeg.zRot += f7;
        this.leftHindLeg.zRot += -f7;
        this.rightMiddleHindLeg.zRot += f8;
        this.leftMiddleHindLeg.zRot += -f8;
        this.rightMiddleFrontLeg.zRot += f9;
        this.leftMiddleFrontLeg.zRot += -f9;
        this.rightFrontLeg.zRot += f10;
        this.leftFrontLeg.zRot += -f10;
    }
}

