/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.OptimizeWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EditWorldScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component NAME_LABEL = Component.translatable("selectWorld.enterName");
    private Button renameButton;
    private final BooleanConsumer callback;
    private EditBox nameEdit;
    private final LevelStorageSource.LevelStorageAccess levelAccess;

    public EditWorldScreen(BooleanConsumer p_101252_, LevelStorageSource.LevelStorageAccess p_101253_) {
        super(Component.translatable("selectWorld.edit.title"));
        this.callback = p_101252_;
        this.levelAccess = p_101253_;
    }

    @Override
    public void tick() {
        this.nameEdit.tick();
    }

    @Override
    protected void init() {
        this.renameButton = Button.builder(Component.translatable("selectWorld.edit.save"), p_101280_ -> this.onRename()).bounds(this.width / 2 - 100, this.height / 4 + 144 + 5, 98, 20).build();
        this.nameEdit = new EditBox(this.font, this.width / 2 - 100, 38, 200, 20, Component.translatable("selectWorld.enterName"));
        LevelSummary levelsummary = this.levelAccess.getSummary();
        String s = levelsummary == null ? "" : levelsummary.getLevelName();
        this.nameEdit.setValue(s);
        this.nameEdit.setResponder(p_280914_ -> {
            this.renameButton.active = !p_280914_.trim().isEmpty();
        });
        this.addWidget(this.nameEdit);
        Button button = this.addRenderableWidget(Button.builder(Component.translatable("selectWorld.edit.resetIcon"), p_280916_ -> {
            this.levelAccess.getIconFile().ifPresent(p_182594_ -> FileUtils.deleteQuietly((File)p_182594_.toFile()));
            p_280916_.active = false;
        }).bounds(this.width / 2 - 100, this.height / 4 + 0 + 5, 200, 20).build());
        this.addRenderableWidget(Button.builder(Component.translatable("selectWorld.edit.openFolder"), p_101294_ -> Util.getPlatform().openFile(this.levelAccess.getLevelPath(LevelResource.ROOT).toFile())).bounds(this.width / 2 - 100, this.height / 4 + 24 + 5, 200, 20).build());
        this.addRenderableWidget(Button.builder(Component.translatable("selectWorld.edit.backup"), p_101292_ -> {
            boolean flag = EditWorldScreen.makeBackupAndShowToast(this.levelAccess);
            this.callback.accept(!flag);
        }).bounds(this.width / 2 - 100, this.height / 4 + 48 + 5, 200, 20).build());
        this.addRenderableWidget(Button.builder(Component.translatable("selectWorld.edit.backupFolder"), p_280915_ -> {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            Path path = levelstoragesource.getBackupPath();
            try {
                FileUtil.createDirectoriesSafe(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Util.getPlatform().openFile(path.toFile());
        }).bounds(this.width / 2 - 100, this.height / 4 + 72 + 5, 200, 20).build());
        this.addRenderableWidget(Button.builder(Component.translatable("selectWorld.edit.optimize"), p_280913_ -> this.minecraft.setScreen(new BackupConfirmScreen(this, (p_280911_, p_280912_) -> {
            if (p_280911_) {
                EditWorldScreen.makeBackupAndShowToast(this.levelAccess);
            }
            this.minecraft.setScreen(OptimizeWorldScreen.create(this.minecraft, this.callback, this.minecraft.getFixerUpper(), this.levelAccess, p_280912_));
        }, Component.translatable("optimizeWorld.confirm.title"), Component.translatable("optimizeWorld.confirm.description"), true))).bounds(this.width / 2 - 100, this.height / 4 + 96 + 5, 200, 20).build());
        this.addRenderableWidget(this.renameButton);
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_101273_ -> this.callback.accept(false)).bounds(this.width / 2 + 2, this.height / 4 + 144 + 5, 98, 20).build());
        button.active = this.levelAccess.getIconFile().filter(p_182587_ -> Files.isRegularFile(p_182587_, new LinkOption[0])).isPresent();
        this.setInitialFocus(this.nameEdit);
    }

    @Override
    public void resize(Minecraft p_101269_, int p_101270_, int p_101271_) {
        String s = this.nameEdit.getValue();
        this.init(p_101269_, p_101270_, p_101271_);
        this.nameEdit.setValue(s);
    }

    @Override
    public void onClose() {
        this.callback.accept(false);
    }

    private void onRename() {
        try {
            this.levelAccess.renameLevel(this.nameEdit.getValue().trim());
            this.callback.accept(true);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to access world '{}'", (Object)this.levelAccess.getLevelId(), (Object)ioexception);
            SystemToast.onWorldAccessFailure(this.minecraft, this.levelAccess.getLevelId());
            this.callback.accept(true);
        }
    }

    public static void makeBackupAndShowToast(LevelStorageSource p_101261_, String p_101262_) {
        boolean flag = false;
        try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_101261_.validateAndCreateAccess(p_101262_);){
            flag = true;
            EditWorldScreen.makeBackupAndShowToast(levelstoragesource$levelstorageaccess);
        }
        catch (IOException ioexception) {
            if (!flag) {
                SystemToast.onWorldAccessFailure(Minecraft.getInstance(), p_101262_);
            }
            LOGGER.warn("Failed to create backup of level {}", (Object)p_101262_, (Object)ioexception);
        }
        catch (ContentValidationException contentvalidationexception) {
            LOGGER.warn("{}", (Object)contentvalidationexception.getMessage());
            SystemToast.onWorldAccessFailure(Minecraft.getInstance(), p_101262_);
        }
    }

    public static boolean makeBackupAndShowToast(LevelStorageSource.LevelStorageAccess p_101259_) {
        long i = 0L;
        IOException ioexception = null;
        try {
            i = p_101259_.makeWorldBackup();
        }
        catch (IOException ioexception1) {
            ioexception = ioexception1;
        }
        if (ioexception != null) {
            MutableComponent component2 = Component.translatable("selectWorld.edit.backupFailed");
            MutableComponent component3 = Component.literal(ioexception.getMessage());
            Minecraft.getInstance().getToasts().addToast(new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, component2, component3));
            return false;
        }
        MutableComponent component = Component.translatable("selectWorld.edit.backupCreated", p_101259_.getLevelId());
        MutableComponent component1 = Component.translatable("selectWorld.edit.backupSize", Mth.ceil((double)i / 1048576.0));
        Minecraft.getInstance().getToasts().addToast(new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, component, component1));
        return true;
    }

    @Override
    public void render(GuiGraphics p_281742_, int p_101265_, int p_101266_, float p_101267_) {
        this.renderBackground(p_281742_);
        p_281742_.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        p_281742_.drawString(this.font, NAME_LABEL, this.width / 2 - 100, 24, 0xA0A0A0);
        this.nameEdit.render(p_281742_, p_101265_, p_101266_, p_101267_);
        super.render(p_281742_, p_101265_, p_101266_, p_101267_);
    }
}

