/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.navigation;

import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ScreenAxis {
    HORIZONTAL,
    VERTICAL;


    public ScreenAxis orthogonal() {
        return switch (this) {
            case HORIZONTAL -> VERTICAL;
            case VERTICAL -> HORIZONTAL;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public ScreenDirection getPositive() {
        return switch (this) {
            case HORIZONTAL -> ScreenDirection.RIGHT;
            case VERTICAL -> ScreenDirection.DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public ScreenDirection getNegative() {
        return switch (this) {
            case HORIZONTAL -> ScreenDirection.LEFT;
            case VERTICAL -> ScreenDirection.UP;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public ScreenDirection getDirection(boolean p_265698_) {
        return p_265698_ ? this.getPositive() : this.getNegative();
    }
}

