/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.narration;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationThunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenNarrationCollector {
    int generation;
    final Map<EntryKey, NarrationEntry> entries = Maps.newTreeMap(Comparator.comparing(p_169196_ -> p_169196_.type).thenComparing(p_169185_ -> p_169185_.depth));

    public void update(Consumer<NarrationElementOutput> p_169187_) {
        ++this.generation;
        p_169187_.accept(new Output(0));
    }

    public String collectNarrationText(boolean p_169189_) {
        final StringBuilder stringbuilder = new StringBuilder();
        Consumer<String> consumer = new Consumer<String>(){
            private boolean firstEntry = true;

            @Override
            public void accept(String p_169204_) {
                if (!this.firstEntry) {
                    stringbuilder.append(". ");
                }
                this.firstEntry = false;
                stringbuilder.append(p_169204_);
            }
        };
        this.entries.forEach((p_169193_, p_169194_) -> {
            if (p_169194_.generation == this.generation && (p_169189_ || !p_169194_.alreadyNarrated)) {
                p_169194_.contents.getText(consumer);
                p_169194_.alreadyNarrated = true;
            }
        });
        return stringbuilder.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Output
    implements NarrationElementOutput {
        private final int depth;

        Output(int p_169223_) {
            this.depth = p_169223_;
        }

        @Override
        public void add(NarratedElementType p_169226_, NarrationThunk<?> p_169227_) {
            ScreenNarrationCollector.this.entries.computeIfAbsent(new EntryKey(p_169226_, this.depth), p_169229_ -> new NarrationEntry()).update(ScreenNarrationCollector.this.generation, p_169227_);
        }

        @Override
        public NarrationElementOutput nest() {
            ScreenNarrationCollector screenNarrationCollector = ScreenNarrationCollector.this;
            Objects.requireNonNull(screenNarrationCollector);
            return screenNarrationCollector.new Output(this.depth + 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class NarrationEntry {
        NarrationThunk<?> contents = NarrationThunk.EMPTY;
        int generation = -1;
        boolean alreadyNarrated;

        NarrationEntry() {
        }

        public NarrationEntry update(int p_169217_, NarrationThunk<?> p_169218_) {
            if (!this.contents.equals(p_169218_)) {
                this.contents = p_169218_;
                this.alreadyNarrated = false;
            } else if (this.generation + 1 != p_169217_) {
                this.alreadyNarrated = false;
            }
            this.generation = p_169217_;
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class EntryKey {
        final NarratedElementType type;
        final int depth;

        EntryKey(NarratedElementType p_169210_, int p_169211_) {
            this.type = p_169210_;
            this.depth = p_169211_;
        }
    }
}

