/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface Toast {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/toasts.png");
    public static final Object NO_TOKEN = new Object();
    public static final int SLOT_HEIGHT = 32;

    public Visibility render(GuiGraphics var1, ToastComponent var2, long var3);

    default public Object getToken() {
        return NO_TOKEN;
    }

    default public int width() {
        return 160;
    }

    default public int height() {
        return 32;
    }

    default public int slotCount() {
        return Mth.positiveCeilDiv(this.height(), 32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Visibility {
        SHOW(SoundEvents.UI_TOAST_IN),
        HIDE(SoundEvents.UI_TOAST_OUT);

        private final SoundEvent soundEvent;

        private Visibility(SoundEvent p_94908_) {
            this.soundEvent = p_94908_;
        }

        public void playSound(SoundManager p_94910_) {
            p_94910_.play(SimpleSoundInstance.forUI(this.soundEvent, 1.0f, 1.0f));
        }
    }
}

