/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSelectionList<E extends Entry<E>>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected boolean centerListVertically = true;
    private double scrollAmount;
    private boolean renderSelection = true;
    private boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    private boolean renderBackground = true;
    private boolean renderTopAndBottom = true;
    @Nullable
    private E hovered;

    public AbstractSelectionList(Minecraft p_93404_, int p_93405_, int p_93406_, int p_93407_, int p_93408_, int p_93409_) {
        this.minecraft = p_93404_;
        this.width = p_93405_;
        this.height = p_93406_;
        this.y0 = p_93407_;
        this.y1 = p_93408_;
        this.itemHeight = p_93409_;
        this.x0 = 0;
        this.x1 = p_93405_;
    }

    public void setRenderSelection(boolean p_93472_) {
        this.renderSelection = p_93472_;
    }

    protected void setRenderHeader(boolean p_93474_, int p_93475_) {
        this.renderHeader = p_93474_;
        this.headerHeight = p_93475_;
        if (!p_93474_) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E p_93462_) {
        this.selected = p_93462_;
    }

    public E getFirstElement() {
        return (E)((Entry)this.children.get(0));
    }

    public void setRenderBackground(boolean p_93489_) {
        this.renderBackground = p_93489_;
    }

    public void setRenderTopAndBottom(boolean p_93497_) {
        this.renderTopAndBottom = p_93497_;
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.getFocused());
    }

    public final List<E> children() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    protected void replaceEntries(Collection<E> p_93470_) {
        this.clearEntries();
        this.children.addAll(p_93470_);
    }

    protected E getEntry(int p_93501_) {
        return (E)((Entry)this.children().get(p_93501_));
    }

    protected int addEntry(E p_93487_) {
        this.children.add(p_93487_);
        return this.children.size() - 1;
    }

    protected void addEntryToTop(E p_239858_) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        this.children.add(0, p_239858_);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
    }

    protected boolean removeEntryFromTop(E p_239046_) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        boolean flag = this.removeEntry(p_239046_);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
        return flag;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int p_93504_) {
        return Objects.equals(this.getSelected(), this.children().get(p_93504_));
    }

    @Nullable
    protected final E getEntryAtPosition(double p_93413_, double p_93414_) {
        int i = this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2;
        int k = j - i;
        int l = j + i;
        int i1 = Mth.floor(p_93414_ - (double)this.y0) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(p_93413_ < (double)this.getScrollbarPosition() && p_93413_ >= (double)k && p_93413_ <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.children().get(j1) : null);
    }

    public void updateSize(int p_93438_, int p_93439_, int p_93440_, int p_93441_) {
        this.width = p_93438_;
        this.height = p_93439_;
        this.y0 = p_93440_;
        this.y1 = p_93441_;
        this.x0 = 0;
        this.x1 = p_93438_;
    }

    public void setLeftPos(int p_93508_) {
        this.x0 = p_93508_;
        this.x1 = p_93508_ + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int p_93431_, int p_93432_) {
    }

    protected void renderHeader(GuiGraphics p_282337_, int p_93444_, int p_93445_) {
    }

    protected void renderBackground(GuiGraphics p_283512_) {
    }

    protected void renderDecorations(GuiGraphics p_281477_, int p_93459_, int p_93460_) {
    }

    @Override
    public void render(GuiGraphics p_282708_, int p_283242_, int p_282891_, float p_283683_) {
        int i2;
        this.renderBackground(p_282708_);
        int i = this.getScrollbarPosition();
        int j = i + 6;
        this.hovered = this.isMouseOver(p_283242_, p_282891_) ? this.getEntryAtPosition(p_283242_, p_282891_) : null;
        Object v0 = this.hovered;
        if (this.renderBackground) {
            p_282708_.setColor(0.125f, 0.125f, 0.125f, 1.0f);
            int k = 32;
            p_282708_.blit(Screen.BACKGROUND_LOCATION, this.x0, this.y0, this.x1, this.y1 + (int)this.getScrollAmount(), this.x1 - this.x0, this.y1 - this.y0, 32, 32);
            p_282708_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        int l1 = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        this.enableScissor(p_282708_);
        if (this.renderHeader) {
            this.renderHeader(p_282708_, l1, l);
        }
        this.renderList(p_282708_, p_283242_, p_282891_, p_283683_);
        p_282708_.disableScissor();
        if (this.renderTopAndBottom) {
            int i1 = 32;
            p_282708_.setColor(0.25f, 0.25f, 0.25f, 1.0f);
            p_282708_.blit(Screen.BACKGROUND_LOCATION, this.x0, 0, 0.0f, 0.0f, this.width, this.y0, 32, 32);
            p_282708_.blit(Screen.BACKGROUND_LOCATION, this.x0, this.y1, 0.0f, this.y1, this.width, this.height - this.y1, 32, 32);
            p_282708_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int j1 = 4;
            p_282708_.fillGradient(RenderType.guiOverlay(), this.x0, this.y0, this.x1, this.y0 + 4, -16777216, 0, 0);
            p_282708_.fillGradient(RenderType.guiOverlay(), this.x0, this.y1 - 4, this.x1, this.y1, 0, -16777216, 0);
        }
        if ((i2 = this.getMaxScroll()) > 0) {
            int j2 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            j2 = Mth.clamp(j2, 32, this.y1 - this.y0 - 8);
            int k1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - j2) / i2 + this.y0;
            if (k1 < this.y0) {
                k1 = this.y0;
            }
            p_282708_.fill(i, this.y0, j, this.y1, -16777216);
            p_282708_.fill(i, k1, j, k1 + j2, -8355712);
            p_282708_.fill(i, k1, j - 1, k1 + j2 - 1, -4144960);
        }
        this.renderDecorations(p_282708_, p_283242_, p_282891_);
        RenderSystem.disableBlend();
    }

    protected void enableScissor(GuiGraphics p_282811_) {
        p_282811_.enableScissor(this.x0, this.y0, this.x1, this.y1);
    }

    protected void centerScrollOn(E p_93495_) {
        this.setScrollAmount(this.children().indexOf(p_93495_) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E p_93499_) {
        int k;
        int i = this.getRowTop(this.children().indexOf(p_93499_));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int p_93430_) {
        this.setScrollAmount(this.getScrollAmount() + (double)p_93430_);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double p_93411_) {
        this.scrollAmount = Mth.clamp(p_93411_, 0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double p_93482_, double p_93483_, int p_93484_) {
        this.scrolling = p_93484_ == 0 && p_93482_ >= (double)this.getScrollbarPosition() && p_93482_ < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    @Override
    public boolean mouseClicked(double p_93420_, double p_93421_, int p_93422_) {
        this.updateScrollingState(p_93420_, p_93421_, p_93422_);
        if (!this.isMouseOver(p_93420_, p_93421_)) {
            return false;
        }
        E e = this.getEntryAtPosition(p_93420_, p_93421_);
        if (e != null) {
            if (e.mouseClicked(p_93420_, p_93421_, p_93422_)) {
                GuiEventListener e1 = this.getFocused();
                if (e1 != e && e1 instanceof ContainerEventHandler) {
                    ContainerEventHandler containereventhandler = (ContainerEventHandler)e1;
                    containereventhandler.setFocused(null);
                }
                this.setFocused((GuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (p_93422_ == 0) {
            this.clickedHeader((int)(p_93420_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_93421_ - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double p_93491_, double p_93492_, int p_93493_) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(p_93491_, p_93492_, p_93493_);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double p_93424_, double p_93425_, int p_93426_, double p_93427_, double p_93428_) {
        if (super.mouseDragged(p_93424_, p_93425_, p_93426_, p_93427_, p_93428_)) {
            return true;
        }
        if (p_93426_ == 0 && this.scrolling) {
            if (p_93425_ < (double)this.y0) {
                this.setScrollAmount(0.0);
            } else if (p_93425_ > (double)this.y1) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.y1 - this.y0;
                int j = Mth.clamp((int)((float)(i * i) / (float)this.getMaxPosition()), 32, i - 8);
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + p_93428_ * d1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double p_93416_, double p_93417_, double p_93418_) {
        this.setScrollAmount(this.getScrollAmount() - p_93418_ * (double)this.itemHeight / 2.0);
        return true;
    }

    @Override
    public void setFocused(@Nullable GuiEventListener p_265738_) {
        super.setFocused(p_265738_);
        int i = this.children.indexOf(p_265738_);
        if (i >= 0) {
            Entry e = (Entry)this.children.get(i);
            this.setSelected(e);
            if (this.minecraft.getLastInputType().isKeyboard()) {
                this.ensureVisible(e);
            }
        }
    }

    @Nullable
    protected E nextEntry(ScreenDirection p_265160_) {
        return (E)this.nextEntry(p_265160_, p_93510_ -> true);
    }

    @Nullable
    protected E nextEntry(ScreenDirection p_265210_, Predicate<E> p_265604_) {
        return this.nextEntry(p_265210_, p_265604_, this.getSelected());
    }

    @Nullable
    protected E nextEntry(ScreenDirection p_265159_, Predicate<E> p_265109_, @Nullable E p_265379_) {
        int i = switch (p_265159_) {
            case ScreenDirection.RIGHT, ScreenDirection.LEFT -> 0;
            case ScreenDirection.UP -> -1;
            case ScreenDirection.DOWN -> 1;
            default -> throw new IncompatibleClassChangeError();
        };
        if (!this.children().isEmpty() && i != 0) {
            int j = p_265379_ == null ? (i > 0 ? 0 : this.children().size() - 1) : this.children().indexOf(p_265379_) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry e = (Entry)this.children().get(k);
                if (!p_265109_.test(e)) continue;
                return (E)e;
            }
        }
        return (E)((Entry)null);
    }

    @Override
    public boolean isMouseOver(double p_93479_, double p_93480_) {
        return p_93480_ >= (double)this.y0 && p_93480_ <= (double)this.y1 && p_93479_ >= (double)this.x0 && p_93479_ <= (double)this.x1;
    }

    protected void renderList(GuiGraphics p_282079_, int p_239229_, int p_239230_, float p_239231_) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getItemCount();
        for (int i1 = 0; i1 < l; ++i1) {
            int j1 = this.getRowTop(i1);
            int k1 = this.getRowBottom(i1);
            if (k1 < this.y0 || j1 > this.y1) continue;
            this.renderItem(p_282079_, p_239229_, p_239230_, p_239231_, i1, i, j1, j, k);
        }
    }

    protected void renderItem(GuiGraphics p_282205_, int p_238966_, int p_238967_, float p_238968_, int p_238969_, int p_238970_, int p_238971_, int p_238972_, int p_238973_) {
        E e = this.getEntry(p_238969_);
        ((Entry)e).renderBack(p_282205_, p_238969_, p_238971_, p_238970_, p_238972_, p_238973_, p_238966_, p_238967_, Objects.equals(this.hovered, e), p_238968_);
        if (this.renderSelection && this.isSelectedItem(p_238969_)) {
            int i = this.isFocused() ? -1 : -8355712;
            this.renderSelection(p_282205_, p_238971_, p_238972_, p_238973_, i, -16777216);
        }
        ((Entry)e).render(p_282205_, p_238969_, p_238971_, p_238970_, p_238972_, p_238973_, p_238966_, p_238967_, Objects.equals(this.hovered, e), p_238968_);
    }

    protected void renderSelection(GuiGraphics p_283589_, int p_240142_, int p_240143_, int p_240144_, int p_240145_, int p_240146_) {
        int i = this.x0 + (this.width - p_240143_) / 2;
        int j = this.x0 + (this.width + p_240143_) / 2;
        p_283589_.fill(i, p_240142_ - 2, j, p_240142_ + p_240144_ + 2, p_240145_);
        p_283589_.fill(i + 1, p_240142_ - 1, j - 1, p_240142_ + p_240144_ + 1, p_240146_);
    }

    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int p_93512_) {
        return this.y0 + 4 - (int)this.getScrollAmount() + p_93512_ * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int p_93486_) {
        return this.getRowTop(p_93486_) + this.itemHeight;
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Nullable
    protected E remove(int p_93515_) {
        Entry e = (Entry)this.children.get(p_93515_);
        return (E)(this.removeEntry((Entry)this.children.get(p_93515_)) ? e : null);
    }

    protected boolean removeEntry(E p_93503_) {
        boolean flag = this.children.remove(p_93503_);
        if (flag && p_93503_ == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> p_93506_) {
        p_93506_.list = this;
    }

    protected void narrateListElementPosition(NarrationElementOutput p_168791_, E p_168792_) {
        int i;
        List<E> list = this.children();
        if (list.size() > 1 && (i = list.indexOf(p_168792_)) != -1) {
            p_168791_.add(NarratedElementType.POSITION, (Component)Component.translatable("narrator.position.list", i + 1, list.size()));
        }
    }

    @Override
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getLeft() {
        return this.x0;
    }

    public int getRight() {
        return this.x1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int p_93557_) {
            return (Entry)this.delegate.get(p_93557_);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int p_93559_, E p_93560_) {
            Entry e = (Entry)this.delegate.set(p_93559_, p_93560_);
            AbstractSelectionList.this.bindEntryToSelf(p_93560_);
            return e;
        }

        @Override
        public void add(int p_93567_, E p_93568_) {
            this.delegate.add(p_93567_, p_93568_);
            AbstractSelectionList.this.bindEntryToSelf(p_93568_);
        }

        @Override
        public E remove(int p_93565_) {
            return (Entry)this.delegate.remove(p_93565_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static abstract class Entry<E extends Entry<E>>
    implements GuiEventListener {
        @Deprecated
        protected AbstractSelectionList<E> list;

        protected Entry() {
        }

        @Override
        public void setFocused(boolean p_265302_) {
        }

        @Override
        public boolean isFocused() {
            return this.list.getFocused() == this;
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderBack(GuiGraphics p_282673_, int p_275556_, int p_275667_, int p_275713_, int p_275408_, int p_275330_, int p_275603_, int p_275450_, boolean p_275434_, float p_275384_) {
        }

        @Override
        public boolean isMouseOver(double p_93537_, double p_93538_) {
            return Objects.equals(this.list.getEntryAtPosition(p_93537_, p_93538_), this);
        }
    }
}

