/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.animation;

import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public record AnimationChannel(Target target, Keyframe[] keyframes) {

    @OnlyIn(value=Dist.CLIENT)
    public static interface Target {
        public void apply(ModelPart var1, Vector3f var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Targets {
        public static final Target POSITION = ModelPart::offsetPos;
        public static final Target ROTATION = ModelPart::offsetRotation;
        public static final Target SCALE = ModelPart::offsetScale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Interpolations {
        public static final Interpolation LINEAR = (p_253292_, p_253293_, p_253294_, p_253295_, p_253296_, p_253297_) -> {
            Vector3f vector3f = p_253294_[p_253295_].target();
            Vector3f vector3f1 = p_253294_[p_253296_].target();
            return vector3f.lerp((Vector3fc)vector3f1, p_253293_, p_253292_).mul(p_253297_);
        };
        public static final Interpolation CATMULLROM = (p_254076_, p_232235_, p_232236_, p_232237_, p_232238_, p_232239_) -> {
            Vector3f vector3f = p_232236_[Math.max(0, p_232237_ - 1)].target();
            Vector3f vector3f1 = p_232236_[p_232237_].target();
            Vector3f vector3f2 = p_232236_[p_232238_].target();
            Vector3f vector3f3 = p_232236_[Math.min(p_232236_.length - 1, p_232238_ + 1)].target();
            p_254076_.set(Mth.catmullrom(p_232235_, vector3f.x(), vector3f1.x(), vector3f2.x(), vector3f3.x()) * p_232239_, Mth.catmullrom(p_232235_, vector3f.y(), vector3f1.y(), vector3f2.y(), vector3f3.y()) * p_232239_, Mth.catmullrom(p_232235_, vector3f.z(), vector3f1.z(), vector3f2.z(), vector3f3.z()) * p_232239_);
            return p_254076_;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }
}

