/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerPredicate
implements EntitySubPredicate {
    public static final int LOOKING_AT_RANGE = 100;
    private final MinMaxBounds.Ints level;
    @Nullable
    private final GameType gameType;
    private final Map<Stat<?>, MinMaxBounds.Ints> stats;
    private final Object2BooleanMap<ResourceLocation> recipes;
    private final Map<ResourceLocation, AdvancementPredicate> advancements;
    private final EntityPredicate lookingAt;

    private static AdvancementPredicate advancementPredicateFromJson(JsonElement p_62290_) {
        if (p_62290_.isJsonPrimitive()) {
            boolean flag = p_62290_.getAsBoolean();
            return new AdvancementDonePredicate(flag);
        }
        Object2BooleanOpenHashMap object2booleanmap = new Object2BooleanOpenHashMap();
        JsonObject jsonobject = GsonHelper.convertToJsonObject(p_62290_, "criterion data");
        jsonobject.entrySet().forEach(arg_0 -> PlayerPredicate.lambda$advancementPredicateFromJson$0((Object2BooleanMap)object2booleanmap, arg_0));
        return new AdvancementCriterionsPredicate((Object2BooleanMap<String>)object2booleanmap);
    }

    PlayerPredicate(MinMaxBounds.Ints p_156746_, @Nullable GameType p_156747_, Map<Stat<?>, MinMaxBounds.Ints> p_156748_, Object2BooleanMap<ResourceLocation> p_156749_, Map<ResourceLocation, AdvancementPredicate> p_156750_, EntityPredicate p_156751_) {
        this.level = p_156746_;
        this.gameType = p_156747_;
        this.stats = p_156748_;
        this.recipes = p_156749_;
        this.advancements = p_156750_;
        this.lookingAt = p_156751_;
    }

    @Override
    public boolean matches(Entity p_222484_, ServerLevel p_222485_, @Nullable Vec3 p_222486_) {
        if (!(p_222484_ instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverplayer = (ServerPlayer)p_222484_;
        if (!this.level.matches(serverplayer.experienceLevel)) {
            return false;
        }
        if (this.gameType != null && this.gameType != serverplayer.gameMode.getGameModeForPlayer()) {
            return false;
        }
        ServerStatsCounter statscounter = serverplayer.getStats();
        for (Map.Entry<Stat<?>, MinMaxBounds.Ints> entry : this.stats.entrySet()) {
            int i = statscounter.getValue(entry.getKey());
            if (entry.getValue().matches(i)) continue;
            return false;
        }
        ServerRecipeBook recipebook = serverplayer.getRecipeBook();
        for (Object2BooleanMap.Entry entry2 : this.recipes.object2BooleanEntrySet()) {
            if (recipebook.contains((ResourceLocation)entry2.getKey()) == entry2.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            PlayerAdvancements playerAdvancements = serverplayer.getAdvancements();
            ServerAdvancementManager serveradvancementmanager = serverplayer.getServer().getAdvancements();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> entry1 : this.advancements.entrySet()) {
                Advancement advancement = serveradvancementmanager.getAdvancement(entry1.getKey());
                if (advancement != null && entry1.getValue().test(playerAdvancements.getOrStartProgress(advancement))) continue;
                return false;
            }
        }
        if (this.lookingAt != EntityPredicate.ANY) {
            Vec3 vec3 = serverplayer.getEyePosition();
            Vec3 vec31 = serverplayer.getViewVector(1.0f);
            Vec3 vec32 = vec3.add(vec31.x * 100.0, vec31.y * 100.0, vec31.z * 100.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult(serverplayer.level(), serverplayer, vec3, vec32, new AABB(vec3, vec32).inflate(1.0), p_156765_ -> !p_156765_.isSpectator(), 0.0f);
            if (entityhitresult == null || entityhitresult.getType() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity entity = entityhitresult.getEntity();
            if (!this.lookingAt.matches(serverplayer, entity) || !serverplayer.hasLineOfSight(entity)) {
                return false;
            }
        }
        return true;
    }

    public static PlayerPredicate fromJson(JsonObject p_222492_) {
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(p_222492_.get("level"));
        String s = GsonHelper.getAsString(p_222492_, "gamemode", "");
        GameType gametype = GameType.byName(s, null);
        HashMap map = Maps.newHashMap();
        JsonArray jsonarray = GsonHelper.getAsJsonArray(p_222492_, "stats", null);
        if (jsonarray != null) {
            for (JsonElement jsonelement : jsonarray) {
                JsonObject jsonobject = GsonHelper.convertToJsonObject(jsonelement, "stats entry");
                ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(jsonobject, "type"));
                StatType<?> stattype = BuiltInRegistries.STAT_TYPE.get(resourcelocation);
                if (stattype == null) {
                    throw new JsonParseException("Invalid stat type: " + String.valueOf(resourcelocation));
                }
                ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.getAsString(jsonobject, "stat"));
                Stat<?> stat = PlayerPredicate.getStat(stattype, resourcelocation1);
                MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(jsonobject.get("value"));
                map.put(stat, minmaxbounds$ints1);
            }
        }
        Object2BooleanOpenHashMap object2booleanmap = new Object2BooleanOpenHashMap();
        JsonObject jsonobject1 = GsonHelper.getAsJsonObject(p_222492_, "recipes", new JsonObject());
        for (Map.Entry entry : jsonobject1.entrySet()) {
            ResourceLocation resourcelocation2 = new ResourceLocation((String)entry.getKey());
            boolean flag = GsonHelper.convertToBoolean((JsonElement)entry.getValue(), "recipe present");
            object2booleanmap.put((Object)resourcelocation2, flag);
        }
        HashMap map1 = Maps.newHashMap();
        JsonObject jsonobject2 = GsonHelper.getAsJsonObject(p_222492_, "advancements", new JsonObject());
        for (Map.Entry entry1 : jsonobject2.entrySet()) {
            ResourceLocation resourcelocation3 = new ResourceLocation((String)entry1.getKey());
            AdvancementPredicate playerpredicate$advancementpredicate = PlayerPredicate.advancementPredicateFromJson((JsonElement)entry1.getValue());
            map1.put(resourcelocation3, playerpredicate$advancementpredicate);
        }
        EntityPredicate entitypredicate = EntityPredicate.fromJson(p_222492_.get("looking_at"));
        return new PlayerPredicate(minmaxbounds$ints, gametype, map, (Object2BooleanMap<ResourceLocation>)object2booleanmap, map1, entitypredicate);
    }

    private static <T> Stat<T> getStat(StatType<T> p_62268_, ResourceLocation p_62269_) {
        Registry<T> registry = p_62268_.getRegistry();
        T t = registry.get(p_62269_);
        if (t == null) {
            throw new JsonParseException("Unknown object " + String.valueOf(p_62269_) + " for stat type " + String.valueOf(BuiltInRegistries.STAT_TYPE.getKey(p_62268_)));
        }
        return p_62268_.get(t);
    }

    private static <T> ResourceLocation getStatValueId(Stat<T> p_62266_) {
        return p_62266_.getType().getRegistry().getKey(p_62266_.getValue());
    }

    @Override
    public JsonObject serializeCustomData() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("level", this.level.serializeToJson());
        if (this.gameType != null) {
            jsonobject.addProperty("gamemode", this.gameType.getName());
        }
        if (!this.stats.isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            this.stats.forEach((p_222489_, p_222490_) -> {
                JsonObject jsonobject3 = new JsonObject();
                jsonobject3.addProperty("type", BuiltInRegistries.STAT_TYPE.getKey(p_222489_.getType()).toString());
                jsonobject3.addProperty("stat", PlayerPredicate.getStatValueId(p_222489_).toString());
                jsonobject3.add("value", p_222490_.serializeToJson());
                jsonarray.add((JsonElement)jsonobject3);
            });
            jsonobject.add("stats", (JsonElement)jsonarray);
        }
        if (!this.recipes.isEmpty()) {
            JsonObject jsonobject1 = new JsonObject();
            this.recipes.forEach((p_222499_, p_222500_) -> jsonobject1.addProperty(p_222499_.toString(), p_222500_));
            jsonobject.add("recipes", (JsonElement)jsonobject1);
        }
        if (!this.advancements.isEmpty()) {
            JsonObject jsonobject2 = new JsonObject();
            this.advancements.forEach((p_222495_, p_222496_) -> jsonobject2.add(p_222495_.toString(), p_222496_.toJson()));
            jsonobject.add("advancements", (JsonElement)jsonobject2);
        }
        jsonobject.add("looking_at", this.lookingAt.serializeToJson());
        return jsonobject;
    }

    @Override
    public EntitySubPredicate.Type type() {
        return EntitySubPredicate.Types.PLAYER;
    }

    private static /* synthetic */ void lambda$advancementPredicateFromJson$0(Object2BooleanMap object2booleanmap, Map.Entry p_62288_) {
        boolean flag1 = GsonHelper.convertToBoolean((JsonElement)p_62288_.getValue(), "criterion test");
        object2booleanmap.put((Object)((String)p_62288_.getKey()), flag1);
    }

    static class AdvancementDonePredicate
    implements AdvancementPredicate {
        private final boolean state;

        public AdvancementDonePredicate(boolean p_62301_) {
            this.state = p_62301_;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(Boolean.valueOf(this.state));
        }

        @Override
        public boolean test(AdvancementProgress p_62304_) {
            return p_62304_.isDone() == this.state;
        }
    }

    static class AdvancementCriterionsPredicate
    implements AdvancementPredicate {
        private final Object2BooleanMap<String> criterions;

        public AdvancementCriterionsPredicate(Object2BooleanMap<String> p_62293_) {
            this.criterions = p_62293_;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonobject = new JsonObject();
            this.criterions.forEach((arg_0, arg_1) -> ((JsonObject)jsonobject).addProperty(arg_0, arg_1));
            return jsonobject;
        }

        @Override
        public boolean test(AdvancementProgress p_62296_) {
            for (Object2BooleanMap.Entry entry : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress criterionprogress = p_62296_.getCriterion((String)entry.getKey());
                if (criterionprogress != null && criterionprogress.isDone() == entry.getBooleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public JsonElement toJson();
    }

    public static class Builder {
        private MinMaxBounds.Ints level = MinMaxBounds.Ints.ANY;
        @Nullable
        private GameType gameType;
        private final Map<Stat<?>, MinMaxBounds.Ints> stats = Maps.newHashMap();
        private final Object2BooleanMap<ResourceLocation> recipes = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> advancements = Maps.newHashMap();
        private EntityPredicate lookingAt = EntityPredicate.ANY;

        public static Builder player() {
            return new Builder();
        }

        public Builder setLevel(MinMaxBounds.Ints p_156776_) {
            this.level = p_156776_;
            return this;
        }

        public Builder addStat(Stat<?> p_156769_, MinMaxBounds.Ints p_156770_) {
            this.stats.put(p_156769_, p_156770_);
            return this;
        }

        public Builder addRecipe(ResourceLocation p_156781_, boolean p_156782_) {
            this.recipes.put((Object)p_156781_, p_156782_);
            return this;
        }

        public Builder setGameType(GameType p_156774_) {
            this.gameType = p_156774_;
            return this;
        }

        public Builder setLookingAt(EntityPredicate p_156772_) {
            this.lookingAt = p_156772_;
            return this;
        }

        public Builder checkAdvancementDone(ResourceLocation p_156784_, boolean p_156785_) {
            this.advancements.put(p_156784_, new AdvancementDonePredicate(p_156785_));
            return this;
        }

        public Builder checkAdvancementCriterions(ResourceLocation p_156778_, Map<String, Boolean> p_156779_) {
            this.advancements.put(p_156778_, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(p_156779_)));
            return this;
        }

        public PlayerPredicate build() {
            return new PlayerPredicate(this.level, this.gameType, this.stats, this.recipes, this.advancements, this.lookingAt);
        }
    }
}

