/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.storage.loot.LootContext;

public class LightningStrikeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("lightning_strike");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286889_, ContextAwarePredicate p_286650_, DeserializationContext p_286384_) {
        ContextAwarePredicate contextawarepredicate = EntityPredicate.fromJson(p_286889_, "lightning", p_286384_);
        ContextAwarePredicate contextawarepredicate1 = EntityPredicate.fromJson(p_286889_, "bystander", p_286384_);
        return new TriggerInstance(p_286650_, contextawarepredicate, contextawarepredicate1);
    }

    public void trigger(ServerPlayer p_153392_, LightningBolt p_153393_, List<Entity> p_153394_) {
        List list = p_153394_.stream().map(p_153390_ -> EntityPredicate.createContext(p_153392_, p_153390_)).collect(Collectors.toList());
        LootContext lootcontext = EntityPredicate.createContext(p_153392_, p_153393_);
        this.trigger(p_153392_, p_153402_ -> p_153402_.matches(lootcontext, list));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ContextAwarePredicate lightning;
        private final ContextAwarePredicate bystander;

        public TriggerInstance(ContextAwarePredicate p_286747_, ContextAwarePredicate p_286287_, ContextAwarePredicate p_286566_) {
            super(ID, p_286747_);
            this.lightning = p_286287_;
            this.bystander = p_286566_;
        }

        public static TriggerInstance lighthingStrike(EntityPredicate p_153414_, EntityPredicate p_153415_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, EntityPredicate.wrap(p_153414_), EntityPredicate.wrap(p_153415_));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(LootContext p_153419_, List<LootContext> p_153420_) {
            if (!this.lightning.matches(p_153419_)) {
                return false;
            }
            if (this.bystander == ContextAwarePredicate.ANY) return true;
            if (p_153420_.stream().noneMatch(this.bystander::matches)) return false;
            return true;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_153417_) {
            JsonObject jsonobject = super.serializeToJson(p_153417_);
            jsonobject.add("lightning", this.lightning.toJson(p_153417_));
            jsonobject.add("bystander", this.bystander.toJson(p_153417_));
            return jsonobject;
        }
    }
}

