/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.phys.Vec3;

public class LighthingBoltPredicate
implements EntitySubPredicate {
    private static final String BLOCKS_SET_ON_FIRE_KEY = "blocks_set_on_fire";
    private static final String ENTITY_STRUCK_KEY = "entity_struck";
    private final MinMaxBounds.Ints blocksSetOnFire;
    private final EntityPredicate entityStruck;

    private LighthingBoltPredicate(MinMaxBounds.Ints p_153239_, EntityPredicate p_153240_) {
        this.blocksSetOnFire = p_153239_;
        this.entityStruck = p_153240_;
    }

    public static LighthingBoltPredicate blockSetOnFire(MinMaxBounds.Ints p_153251_) {
        return new LighthingBoltPredicate(p_153251_, EntityPredicate.ANY);
    }

    public static LighthingBoltPredicate fromJson(JsonObject p_220333_) {
        return new LighthingBoltPredicate(MinMaxBounds.Ints.fromJson(p_220333_.get(BLOCKS_SET_ON_FIRE_KEY)), EntityPredicate.fromJson(p_220333_.get(ENTITY_STRUCK_KEY)));
    }

    @Override
    public JsonObject serializeCustomData() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add(BLOCKS_SET_ON_FIRE_KEY, this.blocksSetOnFire.serializeToJson());
        jsonobject.add(ENTITY_STRUCK_KEY, this.entityStruck.serializeToJson());
        return jsonobject;
    }

    @Override
    public EntitySubPredicate.Type type() {
        return EntitySubPredicate.Types.LIGHTNING;
    }

    @Override
    public boolean matches(Entity p_153247_, ServerLevel p_153248_, @Nullable Vec3 p_153249_) {
        if (!(p_153247_ instanceof LightningBolt)) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)p_153247_;
        return this.blocksSetOnFire.matches(lightningbolt.getBlocksSetOnFire()) && (this.entityStruck == EntityPredicate.ANY || lightningbolt.getHitEntities().anyMatch(p_153245_ -> this.entityStruck.matches(p_153248_, p_153249_, (Entity)p_153245_)));
    }
}

