/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConstructBeaconTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("construct_beacon");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286465_, ContextAwarePredicate p_286914_, DeserializationContext p_286803_) {
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(p_286465_.get("level"));
        return new TriggerInstance(p_286914_, minmaxbounds$ints);
    }

    public void trigger(ServerPlayer p_148030_, int p_148031_) {
        this.trigger(p_148030_, p_148028_ -> p_148028_.matches(p_148031_));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints level;

        public TriggerInstance(ContextAwarePredicate p_286868_, MinMaxBounds.Ints p_286272_) {
            super(ID, p_286868_);
            this.level = p_286272_;
        }

        public static TriggerInstance constructedBeacon() {
            return new TriggerInstance(ContextAwarePredicate.ANY, MinMaxBounds.Ints.ANY);
        }

        public static TriggerInstance constructedBeacon(MinMaxBounds.Ints p_22766_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, p_22766_);
        }

        public boolean matches(int p_148033_) {
            return this.level.matches(p_148033_);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_22770_) {
            JsonObject jsonobject = super.serializeToJson(p_22770_);
            jsonobject.add("level", this.level.serializeToJson());
            return jsonobject;
        }
    }
}

