/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class ChanneledLightningTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("channeled_lightning");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286858_, ContextAwarePredicate p_286240_, DeserializationContext p_286562_) {
        ContextAwarePredicate[] acontextawarepredicate = EntityPredicate.fromJsonArray(p_286858_, "victims", p_286562_);
        return new TriggerInstance(p_286240_, acontextawarepredicate);
    }

    @Override
    public void trigger(ServerPlayer p_21722_, Collection<? extends Entity> p_21723_) {
        List list = p_21723_.stream().map(p_21720_ -> EntityPredicate.createContext(p_21722_, p_21720_)).collect(Collectors.toList());
        this.trigger(p_21722_, (T p_21730_) -> p_21730_.matches(list));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ContextAwarePredicate[] victims;

        public TriggerInstance(ContextAwarePredicate p_286697_, ContextAwarePredicate[] p_286366_) {
            super(ID, p_286697_);
            this.victims = p_286366_;
        }

        public static TriggerInstance channeledLightning(EntityPredicate ... p_21747_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, (ContextAwarePredicate[])Stream.of(p_21747_).map(EntityPredicate::wrap).toArray(ContextAwarePredicate[]::new));
        }

        public boolean matches(Collection<? extends LootContext> p_21745_) {
            for (ContextAwarePredicate contextawarepredicate : this.victims) {
                boolean flag = false;
                for (LootContext lootContext : p_21745_) {
                    if (!contextawarepredicate.matches(lootContext)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                return false;
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_21743_) {
            JsonObject jsonobject = super.serializeToJson(p_21743_);
            jsonobject.add("victims", ContextAwarePredicate.toJson(this.victims, p_21743_));
            return jsonobject;
        }
    }
}

