/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long BYTES_PER_MEBIBYTE = 0x100000L;
    private static final long ONE_GIGA = 1000000000L;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String OPERATING_SYSTEM = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String JAVA_VERSION = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String JAVA_VM_VERSION = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> entries = Maps.newLinkedHashMap();

    public SystemReport() {
        this.setDetail("Minecraft Version", SharedConstants.getCurrentVersion().getName());
        this.setDetail("Minecraft Version ID", SharedConstants.getCurrentVersion().getId());
        this.setDetail("Operating System", OPERATING_SYSTEM);
        this.setDetail("Java Version", JAVA_VERSION);
        this.setDetail("Java VM Version", JAVA_VM_VERSION);
        this.setDetail("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long i = runtime.maxMemory();
            long j = runtime.totalMemory();
            long k = runtime.freeMemory();
            long l = i / 0x100000L;
            long i1 = j / 0x100000L;
            long j1 = k / 0x100000L;
            return k + " bytes (" + j1 + " MiB) / " + j + " bytes (" + i1 + " MiB) up to " + i + " bytes (" + l + " MiB)";
        });
        this.setDetail("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.ignoreErrors("hardware", () -> this.putHardware(new SystemInfo()));
        this.setDetail("JVM Flags", () -> {
            List list = Util.getVmArguments().collect(Collectors.toList());
            return String.format(Locale.ROOT, "%d total; %s", list.size(), String.join((CharSequence)" ", list));
        });
    }

    public void setDetail(String p_143520_, String p_143521_) {
        this.entries.put(p_143520_, p_143521_);
    }

    public void setDetail(String p_143523_, Supplier<String> p_143524_) {
        try {
            this.setDetail(p_143523_, p_143524_.get());
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to get system info for {}", (Object)p_143523_, (Object)exception);
            this.setDetail(p_143523_, "ERR");
        }
    }

    private void putHardware(SystemInfo p_143536_) {
        HardwareAbstractionLayer hardwareabstractionlayer = p_143536_.getHardware();
        this.ignoreErrors("processor", () -> this.putProcessor(hardwareabstractionlayer.getProcessor()));
        this.ignoreErrors("graphics", () -> this.putGraphics(hardwareabstractionlayer.getGraphicsCards()));
        this.ignoreErrors("memory", () -> this.putMemory(hardwareabstractionlayer.getMemory()));
    }

    private void ignoreErrors(String p_143517_, Runnable p_143518_) {
        try {
            p_143518_.run();
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed retrieving info for group {}", (Object)p_143517_, (Object)throwable);
        }
    }

    private void putPhysicalMemory(List<PhysicalMemory> p_143532_) {
        int i = 0;
        for (PhysicalMemory physicalmemory : p_143532_) {
            String s = String.format(Locale.ROOT, "Memory slot #%d ", i++);
            this.setDetail(s + "capacity (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)physicalmemory.getCapacity() / 1048576.0f)));
            this.setDetail(s + "clockSpeed (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)physicalmemory.getClockSpeed() / 1.0E9f)));
            this.setDetail(s + "type", () -> ((PhysicalMemory)physicalmemory).getMemoryType());
        }
    }

    private void putVirtualMemory(VirtualMemory p_143550_) {
        this.setDetail("Virtual memory max (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_143550_.getVirtualMax() / 1048576.0f)));
        this.setDetail("Virtual memory used (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_143550_.getVirtualInUse() / 1048576.0f)));
        this.setDetail("Swap memory total (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_143550_.getSwapTotal() / 1048576.0f)));
        this.setDetail("Swap memory used (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_143550_.getSwapUsed() / 1048576.0f)));
    }

    private void putMemory(GlobalMemory p_143542_) {
        this.ignoreErrors("physical memory", () -> this.putPhysicalMemory(p_143542_.getPhysicalMemory()));
        this.ignoreErrors("virtual memory", () -> this.putVirtualMemory(p_143542_.getVirtualMemory()));
    }

    private void putGraphics(List<GraphicsCard> p_143553_) {
        int i = 0;
        for (GraphicsCard graphicscard : p_143553_) {
            String s = String.format(Locale.ROOT, "Graphics card #%d ", i++);
            this.setDetail(s + "name", () -> ((GraphicsCard)graphicscard).getName());
            this.setDetail(s + "vendor", () -> ((GraphicsCard)graphicscard).getVendor());
            this.setDetail(s + "VRAM (MB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)graphicscard.getVRam() / 1048576.0f)));
            this.setDetail(s + "deviceId", () -> ((GraphicsCard)graphicscard).getDeviceId());
            this.setDetail(s + "versionInfo", () -> ((GraphicsCard)graphicscard).getVersionInfo());
        }
    }

    private void putProcessor(CentralProcessor p_143540_) {
        CentralProcessor.ProcessorIdentifier processoridentifier = p_143540_.getProcessorIdentifier();
        this.setDetail("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getVendor());
        this.setDetail("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getName());
        this.setDetail("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getIdentifier());
        this.setDetail("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)processoridentifier).getMicroarchitecture());
        this.setDetail("Frequency (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)processoridentifier.getVendorFreq() / 1.0E9f)));
        this.setDetail("Number of physical packages", () -> String.valueOf(p_143540_.getPhysicalPackageCount()));
        this.setDetail("Number of physical CPUs", () -> String.valueOf(p_143540_.getPhysicalProcessorCount()));
        this.setDetail("Number of logical CPUs", () -> String.valueOf(p_143540_.getLogicalProcessorCount()));
    }

    public void appendToCrashReportString(StringBuilder p_143526_) {
        p_143526_.append("-- ").append("System Details").append(" --\n");
        p_143526_.append("Details:");
        this.entries.forEach((p_143529_, p_143530_) -> {
            p_143526_.append("\n\t");
            p_143526_.append((String)p_143529_);
            p_143526_.append(": ");
            p_143526_.append((String)p_143530_);
        });
    }

    public String toLineSeparatedString() {
        return this.entries.entrySet().stream().map(p_143534_ -> (String)p_143534_.getKey() + ": " + (String)p_143534_.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

