/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.dto.RegionPingResult;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class Ping {
    public static List<RegionPingResult> ping(Region ... p_87131_) {
        for (Region ping$region : p_87131_) {
            Ping.ping(ping$region.endpoint);
        }
        ArrayList list = Lists.newArrayList();
        for (Region ping$region1 : p_87131_) {
            list.add(new RegionPingResult(ping$region1.name, Ping.ping(ping$region1.endpoint)));
        }
        list.sort(Comparator.comparingInt(RegionPingResult::ping));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ping(String p_87127_) {
        int i = 700;
        long j = 0L;
        Socket socket = null;
        for (int k = 0; k < 5; ++k) {
            try {
                InetSocketAddress socketaddress = new InetSocketAddress(p_87127_, 80);
                socket = new Socket();
                long l = Ping.now();
                socket.connect(socketaddress, 700);
                j += Ping.now() - l;
                IOUtils.closeQuietly((Socket)socket);
                continue;
            }
            catch (Exception exception) {
                j += 700L;
                continue;
            }
            finally {
                IOUtils.closeQuietly(socket);
            }
        }
        return (int)((double)j / 5.0);
    }

    private static long now() {
        return Util.getMillis();
    }

    public static List<RegionPingResult> pingAllRegions() {
        return Ping.ping(Region.values());
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Region {
        US_EAST_1("us-east-1", "ec2.us-east-1.amazonaws.com"),
        US_WEST_2("us-west-2", "ec2.us-west-2.amazonaws.com"),
        US_WEST_1("us-west-1", "ec2.us-west-1.amazonaws.com"),
        EU_WEST_1("eu-west-1", "ec2.eu-west-1.amazonaws.com"),
        AP_SOUTHEAST_1("ap-southeast-1", "ec2.ap-southeast-1.amazonaws.com"),
        AP_SOUTHEAST_2("ap-southeast-2", "ec2.ap-southeast-2.amazonaws.com"),
        AP_NORTHEAST_1("ap-northeast-1", "ec2.ap-northeast-1.amazonaws.com"),
        SA_EAST_1("sa-east-1", "ec2.sa-east-1.amazonaws.com");

        final String name;
        final String endpoint;

        private Region(String p_87148_, String p_87149_) {
            this.name = p_87148_;
            this.endpoint = p_87149_;
        }
    }
}

