/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.font;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class TrueTypeGlyphProvider
implements GlyphProvider {
    @Nullable
    private ByteBuffer fontMemory;
    @Nullable
    private STBTTFontinfo font;
    final float oversample;
    private final IntSet skip = new IntArraySet();
    final float shiftX;
    final float shiftY;
    final float pointScale;
    final float ascent;

    public TrueTypeGlyphProvider(ByteBuffer p_83846_, STBTTFontinfo p_83847_, float p_83848_, float p_83849_, float p_83850_, float p_83851_, String p_83852_) {
        this.fontMemory = p_83846_;
        this.font = p_83847_;
        this.oversample = p_83849_;
        p_83852_.codePoints().forEach(arg_0 -> ((IntSet)this.skip).add(arg_0));
        this.shiftX = p_83850_ * p_83849_;
        this.shiftY = p_83851_ * p_83849_;
        this.pointScale = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)p_83847_, (float)(p_83848_ * p_83849_));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            STBTruetype.stbtt_GetFontVMetrics((STBTTFontinfo)p_83847_, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2);
            this.ascent = (float)intbuffer.get(0) * this.pointScale;
        }
    }

    @Override
    @Nullable
    public GlyphInfo getGlyph(int p_231116_) {
        STBTTFontinfo stbttfontinfo = this.validateFontOpen();
        if (this.skip.contains(p_231116_)) {
            return null;
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = STBTruetype.stbtt_FindGlyphIndex((STBTTFontinfo)stbttfontinfo, (int)p_231116_);
            if (i == 0) {
                GlyphInfo glyphInfo = null;
                return glyphInfo;
            }
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            IntBuffer intbuffer3 = memorystack.mallocInt(1);
            IntBuffer intbuffer4 = memorystack.mallocInt(1);
            IntBuffer intbuffer5 = memorystack.mallocInt(1);
            STBTruetype.stbtt_GetGlyphHMetrics((STBTTFontinfo)stbttfontinfo, (int)i, (IntBuffer)intbuffer4, (IntBuffer)intbuffer5);
            STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel((STBTTFontinfo)stbttfontinfo, (int)i, (float)this.pointScale, (float)this.pointScale, (float)this.shiftX, (float)this.shiftY, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (IntBuffer)intbuffer3);
            float f = (float)intbuffer4.get(0) * this.pointScale;
            int j = intbuffer2.get(0) - intbuffer.get(0);
            int k = intbuffer3.get(0) - intbuffer1.get(0);
            GlyphInfo glyphInfo = j > 0 && k > 0 ? new Glyph(intbuffer.get(0), intbuffer2.get(0), -intbuffer1.get(0), -intbuffer3.get(0), f, (float)intbuffer5.get(0) * this.pointScale, i) : () -> f / this.oversample;
            return glyphInfo;
        }
    }

    STBTTFontinfo validateFontOpen() {
        if (this.fontMemory != null && this.font != null) {
            return this.font;
        }
        throw new IllegalArgumentException("Provider already closed");
    }

    @Override
    public void close() {
        if (this.font != null) {
            this.font.free();
            this.font = null;
        }
        MemoryUtil.memFree((Buffer)this.fontMemory);
        this.fontMemory = null;
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return (IntSet)IntStream.range(0, 65535).filter(p_231118_ -> !this.skip.contains(p_231118_)).collect(IntOpenHashSet::new, IntCollection::add, IntCollection::addAll);
    }

    @OnlyIn(value=Dist.CLIENT)
    class Glyph
    implements GlyphInfo {
        final int width;
        final int height;
        final float bearingX;
        final float bearingY;
        private final float advance;
        final int index;

        Glyph(int p_83882_, int p_83883_, int p_83884_, int p_83885_, float p_83886_, float p_83887_, int p_83888_) {
            this.width = p_83883_ - p_83882_;
            this.height = p_83884_ - p_83885_;
            this.advance = p_83886_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingX = (p_83887_ + (float)p_83882_ + TrueTypeGlyphProvider.this.shiftX) / TrueTypeGlyphProvider.this.oversample;
            this.bearingY = (TrueTypeGlyphProvider.this.ascent - (float)p_83884_ + TrueTypeGlyphProvider.this.shiftY) / TrueTypeGlyphProvider.this.oversample;
            this.index = p_83888_;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public BakedGlyph bake(Function<SheetGlyphInfo, BakedGlyph> p_231120_) {
            return p_231120_.apply(new SheetGlyphInfo(){

                @Override
                public int getPixelWidth() {
                    return Glyph.this.width;
                }

                @Override
                public int getPixelHeight() {
                    return Glyph.this.height;
                }

                @Override
                public float getOversample() {
                    return TrueTypeGlyphProvider.this.oversample;
                }

                @Override
                public float getBearingX() {
                    return Glyph.this.bearingX;
                }

                @Override
                public float getBearingY() {
                    return Glyph.this.bearingY;
                }

                @Override
                public void upload(int p_231126_, int p_231127_) {
                    STBTTFontinfo stbttfontinfo = TrueTypeGlyphProvider.this.validateFontOpen();
                    NativeImage nativeimage = new NativeImage(NativeImage.Format.LUMINANCE, Glyph.this.width, Glyph.this.height, false);
                    nativeimage.copyFromFont(stbttfontinfo, Glyph.this.index, Glyph.this.width, Glyph.this.height, TrueTypeGlyphProvider.this.pointScale, TrueTypeGlyphProvider.this.pointScale, TrueTypeGlyphProvider.this.shiftX, TrueTypeGlyphProvider.this.shiftY, 0, 0);
                    nativeimage.upload(0, p_231126_, p_231127_, 0, 0, Glyph.this.width, Glyph.this.height, false, true);
                }

                @Override
                public boolean isColored() {
                    return false;
                }
            });
        }
    }
}

