/*
 *******************************************************************************
 * Copyright (c) 2020, STMicroelectronics
 * All rights reserved.
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 *******************************************************************************
 */
#if defined(ARDUINO_GENERIC_G431K6TX) || defined(ARDUINO_GENERIC_G431K6UX) ||\
    defined(ARDUINO_GENERIC_G431K8TX) || defined(ARDUINO_GENERIC_G431K8UX) ||\
    defined(ARDUINO_GENERIC_G431KBTX) || defined(ARDUINO_GENERIC_G431KBUX) ||\
    defined(ARDUINO_GENERIC_G441KBTX) || defined(ARDUINO_GENERIC_G441KBUX)
#include "pins_arduino.h"

// Digital PinName array
const PinName digitalPin[] = {
  PA_0,   // D0/A0
  PA_1,   // D1/A1
  PA_2,   // D2/A2
  PA_3,   // D3/A3
  PA_4,   // D4/A4
  PA_5,   // D5/A5
  PA_6,   // D6/A6
  PA_7,   // D7/A7
  PA_8,   // D8
  PA_9,   // D9
  PA_10,  // D10
  PA_11,  // D11
  PA_12,  // D12
  PA_13,  // D13
  PA_14,  // D14
  PA_15,  // D15
  PB_0,   // D16/A8
  PB_3,   // D17
  PB_4,   // D18
  PB_5,   // D19
  PB_6,   // D20
  PB_7,   // D21
  PB_8,   // D22
  PF_0,   // D23/A9
  PF_1,   // D24/A10
  PG_10   // D25
};

// Analog (Ax) pin number array
const uint32_t analogInputPin[] = {
  0,  // A0,  PA0
  1,  // A1,  PA1
  2,  // A2,  PA2
  3,  // A3,  PA3
  4,  // A4,  PA4
  5,  // A5,  PA5
  6,  // A6,  PA6
  7,  // A7,  PA7
  16, // A8,  PB0
  23, // A9,  PF0
  24  // A10, PF1
};

#endif /* ARDUINO_GENERIC_* */
