/**
  ******************************************************************************
  * @file    stm32u3b5xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32U3B5xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

#ifndef STM32U3B5xx_H
#define STM32U3B5xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */

/** @addtogroup STM32U3B5xx
  * @{
  */

/** @addtogroup Configuration_of_CMSIS
  * @{
  */
#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
#define CPU_IN_SECURE_STATE
#endif

/* ================================================================================================================== */
/* ================                     Interrupt Number Definition                                  ================ */
/* ================================================================================================================== */
typedef enum
{
  /* ================================== ARM Cortex-M33 Specific Interrupt Numbers =================================== */
  NonMaskableInt_IRQn         = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn              = -13,    /*!< -13 Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn       = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation and No
                                                 No Match                                                             */
  BusFault_IRQn               = -11,    /*!< -11 Bus Fault, Pre-Fetch, Memory Access Fault, other address/memory
                                                 related Fault                                                        */
  UsageFault_IRQn             = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SecureFault_IRQn            = -9,     /*!< -9  Secure Fault                                                         */
  SVCall_IRQn                 = -5,     /*!< -5  System Service Call via SVC instruction                              */
  DebugMonitor_IRQn           = -4,     /*!< -4  Debug Monitor                                                        */
  PendSV_IRQn                 = -2,     /*!< -2  Pendable request for system service                                  */
  SysTick_IRQn                = -1,     /*!< -1  System Tick Timer                                                    */

  /* ================================== STM32U3B5xx Specific Interrupt Numbers ================================= */
  WWDG_IRQn                   = 0,      /*!< Window WatchDog interrupt                                                */
  PVD_PVM_IRQn                = 1,      /*!< PVD and PVM through EXTI Line detection Interrupt                        */
  RTC_IRQn                    = 2,      /*!< RTC non-secure interrupt                                                 */
  RTC_S_IRQn                  = 3,      /*!< RTC secure interrupt                                                     */
  TAMP_IRQn                   = 4,      /*!< Tamper global interrupt                                                  */
  RAMCFG_IRQn                 = 5,      /*!< RAMCFG global interrupt                                                  */
  FLASH_IRQn                  = 6,      /*!< FLASH non-secure global interrupt                                        */
  FLASH_S_IRQn                = 7,      /*!< FLASH secure global interrupt                                            */
  GTZC_IRQn                   = 8,      /*!< Global TrustZone Controller interrupt                                    */
  RCC_IRQn                    = 9,      /*!< RCC non secure global interrupt                                          */
  RCC_S_IRQn                  = 10,     /*!< RCC secure global interrupt                                              */
  EXTI0_IRQn                  = 11,     /*!< EXTI Line 0 interrupt                                                    */
  EXTI1_IRQn                  = 12,     /*!< EXTI Line 1 interrupt                                                    */
  EXTI2_IRQn                  = 13,     /*!< EXTI Line 2 interrupt                                                    */
  EXTI3_IRQn                  = 14,     /*!< EXTI Line 3 interrupt                                                    */
  EXTI4_IRQn                  = 15,     /*!< EXTI Line 4 interrupt                                                    */
  EXTI5_IRQn                  = 16,     /*!< EXTI Line 5 interrupt                                                    */
  EXTI6_IRQn                  = 17,     /*!< EXTI Line 6 interrupt                                                    */
  EXTI7_IRQn                  = 18,     /*!< EXTI Line 7 interrupt                                                    */
  EXTI8_IRQn                  = 19,     /*!< EXTI Line 8 interrupt                                                    */
  EXTI9_IRQn                  = 20,     /*!< EXTI Line 9 interrupt                                                    */
  EXTI10_IRQn                 = 21,     /*!< EXTI Line 10 interrupt                                                   */
  EXTI11_IRQn                 = 22,     /*!< EXTI Line 11 interrupt                                                   */
  EXTI12_IRQn                 = 23,     /*!< EXTI Line 12 interrupt                                                   */
  EXTI13_IRQn                 = 24,     /*!< EXTI Line 13 interrupt                                                   */
  EXTI14_IRQn                 = 25,     /*!< EXTI Line 14 interrupt                                                   */
  EXTI15_IRQn                 = 26,     /*!< EXTI Line 15 interrupt                                                   */
  IWDG_IRQn                   = 27,     /*!< IWDG global interrupt                                                    */
  GPDMA1_Channel0_IRQn        = 29,     /*!< GPDMA1 Channel 0 global interrupt                                        */
  GPDMA1_Channel1_IRQn        = 30,     /*!< GPDMA1 Channel 1 global interrupt                                        */
  GPDMA1_Channel2_IRQn        = 31,     /*!< GPDMA1 Channel 2 global interrupt                                        */
  GPDMA1_Channel3_IRQn        = 32,     /*!< GPDMA1 Channel 3 global interrupt                                        */
  GPDMA1_Channel4_IRQn        = 33,     /*!< GPDMA1 Channel 4 global interrupt                                        */
  GPDMA1_Channel5_IRQn        = 34,     /*!< GPDMA1 Channel 5 global interrupt                                        */
  GPDMA1_Channel6_IRQn        = 35,     /*!< GPDMA1 Channel 6 global interrupt                                        */
  GPDMA1_Channel7_IRQn        = 36,     /*!< GPDMA1 Channel 7 global interrupt                                        */
  ADC1_IRQn                   = 37,     /*!< ADC1 global interrupt                                                    */
  DAC1_IRQn                   = 38,     /*!< DAC1 global interrupt                                                    */
  FDCAN1_IT0_IRQn             = 39,     /*!< FDCAN1 interrupt 0                                                       */
  FDCAN1_IT1_IRQn             = 40,     /*!< FDCAN1 interrupt 1                                                       */
  TIM1_BRK_TERR_IERR_IRQn     = 41,     /*!< TIM1 Break, Transition error and Index error interrupt                   */
  TIM1_UP_IRQn                = 42,     /*!< TIM1 Update interrupt                                                    */
  TIM1_TRG_COM_DIR_IDX_IRQn   = 43,     /*!< TIM1 Trigger, Commutation, Direction change and Index interrupt          */
  TIM1_CC_IRQn                = 44,     /*!< TIM1 Capture Compare interrupt                                           */
  TIM2_IRQn                   = 45,     /*!< TIM2 global interrupt                                                    */
  TIM3_IRQn                   = 46,     /*!< TIM3 global interrupt                                                    */
  TIM4_IRQn                   = 47,     /*!< TIM4 global interrupt                                                    */
  TIM6_IRQn                   = 49,     /*!< TIM6 global interrupt                                                    */
  TIM7_IRQn                   = 50,     /*!< TIM7 global interrupt                                                    */
  TIM12_IRQn                  = 51,     /*!< TIM12 global interrupt                                                   */
  I3C1_EV_IRQn                = 53,     /*!< I3C1 event interrupt                                                     */
  I3C1_ER_IRQn                = 54,     /*!< I3C1 error interrupt                                                     */
  I2C1_EV_IRQn                = 55,     /*!< I2C1 Event interrupt                                                     */
  I2C1_ER_IRQn                = 56,     /*!< I2C1 Error interrupt                                                     */
  I2C2_EV_IRQn                = 57,     /*!< I2C2 Event interrupt                                                     */
  I2C2_ER_IRQn                = 58,     /*!< I2C2 Error interrupt                                                     */
  SPI1_IRQn                   = 59,     /*!< SPI1 global interrupt                                                    */
  SPI2_IRQn                   = 60,     /*!< SPI2 global interrupt                                                    */
  USART1_IRQn                 = 61,     /*!< USART1 global interrupt                                                  */
  USART2_IRQn                 = 62,     /*!< USART2 global interrupt                                                  */
  USART3_IRQn                 = 63,     /*!< USART3 global interrupt                                                  */
  UART4_IRQn                  = 64,     /*!< UART4 global interrupt                                                   */
  UART5_IRQn                  = 65,     /*!< UART5 global interrupt                                                   */
  LPUART1_IRQn                = 66,     /*!< LPUART1 global interrupt                                                 */
  LPTIM1_IRQn                 = 67,     /*!< LPTIM1 global interrupt                                                  */
  LPTIM2_IRQn                 = 68,     /*!< LPTIM2 global interrupt                                                  */
  TIM15_IRQn                  = 69,     /*!< TIM15 global interrupt                                                   */
  TIM16_IRQn                  = 70,     /*!< TIM16 global interrupt                                                   */
  TIM17_IRQn                  = 71,     /*!< TIM17 global interrupt                                                   */
  COMP_IRQn                   = 72,     /*!< COMP1 and COMP2 through EXTI Lines interrupts                            */
  USB_FS_IRQn                 = 73,     /*!< USB FS global interrupt                                                  */
  CRS_IRQn                    = 74,     /*!< CRS global interrupt                                                     */
  OCTOSPI1_IRQn               = 76,     /*!< OctoSPI1 global interrupt                                                */
  HSP1_IRQn                   = 77,     /*!< HSP1 global interrupt                                                    */
  SDMMC1_IRQn                 = 78,     /*!< SDMMC1 global interrupt                                                  */
  GPDMA1_Channel8_IRQn        = 80,     /*!< GPDMA1 Channel 8 global interrupt                                        */
  GPDMA1_Channel9_IRQn        = 81,     /*!< GPDMA1 Channel 9 global interrupt                                        */
  GPDMA1_Channel10_IRQn       = 82,     /*!< GPDMA1 Channel 10 global interrupt                                       */
  GPDMA1_Channel11_IRQn       = 83,     /*!< GPDMA1 Channel 11 global interrupt                                       */
  I2C3_EV_IRQn                = 88,     /*!< I2C3 event interrupt                                                     */
  I2C3_ER_IRQn                = 89,     /*!< I2C3 error interrupt                                                     */
  SAI1_IRQn                   = 90,     /*!< Serial Audio Interface 1 global interrupt                                */
  TSC_IRQn                    = 92,     /*!< Touch Sense Controller global interrupt                                  */
  RNG_IRQn                    = 94,     /*!< RNG global interrupt                                                     */
  FPU_IRQn                    = 95,     /*!< FPU global interrupt                                                     */
  HASH_IRQn                   = 96,     /*!< HASH global interrupt                                                    */
  LPTIM3_IRQn                 = 98,     /*!< LPTIM3 global interrupt                                                  */
  SPI3_IRQn                   = 99,     /*!< SPI3 global interrupt                                                    */
  I3C2_EV_IRQn                = 100,    /*!< I3C2 Event interrupt                                                     */
  I3C2_ER_IRQn                = 101,    /*!< I3C2 Error interrupt                                                     */
  TIM8_BRK_TERR_IERR_IRQn     = 102,    /*!< TIM8 Break, Transition error and Index error interrupt                   */
  TIM8_UP_IRQn                = 103,    /*!< TIM8 Update interrupt                                                    */
  TIM8_TRG_COM_DIR_IDX_IRQn   = 104,    /*!< TIM8 Trigger, Commutation, Direction change and Index interrupt          */
  TIM8_CC_IRQn                = 105,    /*!< TIM8 Capture Compare interrupt                                           */
  ICACHE_IRQn                 = 107,    /*!< Instruction cache global interrupt                                       */
  LPTIM4_IRQn                 = 110,    /*!< LPTIM4 global interrupt                                                  */
  ADF1_IRQn                   = 112,    /*!< ADF1 interrupt                                                           */
  ADC2_IRQn                   = 113,    /*!< ADC2 (12bits) global interrupt                                           */
  FDCAN2_IT0_IRQn             = 114,    /*!< FDCAN2 interrupt 0                                                       */
  FDCAN2_IT1_IRQn             = 115,    /*!< FDCAN2 interrupt 1                                                       */
  I2C4_EV_IRQn                = 116,    /*!< I2C4 Event interrupt                                                     */
  I2C4_ER_IRQn                = 117,    /*!< I2C4 Error interrupt                                                     */
  SPI4_IRQn                   = 119,    /*!< SPI4 global interrupt                                                    */
  PWR_IRQn                    = 123,    /*!< PWR non-secure interrupt                                                 */
  PWR_S_IRQn                  = 124     /*!< PWR secure interrupt                                                     */
} IRQn_Type;

/* ================================================================================================================== */
/* ================                     Processor and Core Peripheral Section                        ================ */
/* ================================================================================================================== */
/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

/* --------  Configuration of the Cortex-M33 Processor and Core Peripherals  ------ */
#define __CM33_REV                      0x0000U   /* Core revision r0p4 */
#define __SAUREGION_PRESENT             1U        /* SAU regions present */
#define __MPU_PRESENT                   1U        /* MPU present */
#define __VTOR_PRESENT                  1U        /* VTOR present */
#define __NVIC_PRIO_BITS                4U        /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig          0U        /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT                   1U        /* FPU present */
#define __DSP_PRESENT                   1U        /* DSP extension present */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm33.h"                            /*!< ARM Cortex-M33 processor and core peripherals */
#include "system_stm32u3xx.h"                     /*!< STM32U3xx System */


/* ================================================================================================================== */
/* ================                     Device Specific Peripheral Section                           ================ */
/* ================================================================================================================== */
/** @addtogroup STM32U3xx_peripherals
  * @{
  */

/**
  * @brief ADC Analog to Digital Converter
  */
typedef struct
{
  __IO uint32_t ISR;              /*!< ADC interrupt and status register,                        Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC interrupt enable register,                            Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                                     Address offset: 0x08 */
  __IO uint32_t CFGR1;            /*!< ADC configuration register 1,                             Address offset: 0x0C */
  __IO uint32_t CFGR2;            /*!< ADC configuration register 2,                             Address offset: 0x10 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                               Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                               Address offset: 0x18 */
  __IO uint32_t PCSEL;            /*!< ADC channel preselection register,                        Address offset: 0x1C */
  uint32_t      RESERVED1[4];     /*!< Reserved,                                                 Address offset: 0x20 */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                          Address offset: 0x30 */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                          Address offset: 0x34 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                          Address offset: 0x38 */
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                          Address offset: 0x3C */
  __IO uint32_t DR;               /*!< ADC regular data register,                                Address offset: 0x40 */
  uint32_t      RESERVED2[2];     /*!< Reserved,                                                 Address offset: 0x44 */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                           Address offset: 0x4C */
  __IO uint32_t OFCFGR1;          /*!< ADC offset configuration register 1,                      Address offset: 0x50 */
  __IO uint32_t OFCFGR2;          /*!< ADC offset configuration register 2,                      Address offset: 0x54 */
  __IO uint32_t OFCFGR3;          /*!< ADC offset configuration register 3,                      Address offset: 0x58 */
  __IO uint32_t OFCFGR4;          /*!< ADC offset configuration register 4,                      Address offset: 0x5C */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                                    Address offset: 0x60 */
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                                    Address offset: 0x64 */
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                                    Address offset: 0x68 */
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                                    Address offset: 0x6C */
  __IO uint32_t GCOMP;            /*!< ADC gain compensation register,                           Address offset: 0x70 */
  uint32_t      RESERVED3[3];     /*!< Reserved,                                                 Address offset: 0x74 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                             Address offset: 0x80 */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                             Address offset: 0x84 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                             Address offset: 0x88 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                             Address offset: 0x8C */
  uint32_t      RESERVED4[4];     /*!< Reserved,                                                 Address offset: 0x90 */
  __IO uint32_t AWD2CR;           /*!< ADC analog watchdog 2 configuration register,             Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC analog watchdog 3 configuration register,             Address offset: 0xA4 */
  __IO uint32_t AWD1LTR;          /*!< ADC analog watchdog 1 low threshold register,             Address offset: 0xA8 */
  __IO uint32_t AWD1HTR;          /*!< ADC analog watchdog 1 high threshold register,            Address offset: 0xAC */
  __IO uint32_t AWD2LTR;          /*!< ADC analog watchdog 2 low threshold register,             Address offset: 0xB0 */
  __IO uint32_t AWD2HTR;          /*!< ADC analog watchdog 2 high threshold register,            Address offset: 0xB4 */
  __IO uint32_t AWD3LTR;          /*!< ADC analog watchdog 3 low threshold register,             Address offset: 0xB8 */
  __IO uint32_t AWD3HTR;          /*!< ADC analog watchdog 3 high threshold register,            Address offset: 0xBC */
  __IO uint32_t DIFSEL;           /*!< ADC differential mode selection register,                 Address offset: 0xC0 */
  __IO uint32_t CALFACT;          /*!< ADC calibration factors,                                  Address offset: 0xC4 */
  uint32_t      RESERVED5[2];     /*!< Reserved,                                                 Address offset: 0xC8 */
  __IO uint32_t OR;               /*!< ADC option register,                                      Address offset: 0xD0 */
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;              /*!< ADC common status register,                              Address offset: 0x300 */
  uint32_t RESERVED;              /*!< Reserved,                                                Address offset: 0x304 */
  __IO uint32_t CCR;              /*!< ADC common control register,                             Address offset: 0x308 */
  __IO uint32_t CDR;              /*!< ADC common regular data register for dual mode,          Address offset: 0x30C */
  __IO uint32_t CDR2;             /*!< ADC common regular data register for dual mode 32-bit,   Address offset: 0x310 */
} ADC_Common_TypeDef;


/**
  * @brief Comparator
  */
typedef struct
{
  __IO uint32_t CSR;              /*!< Comparator control/status register  ,             Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR_ODD;          /*!< COMP control and status register located in register of comparator instance odd, used for bits common to several COMP instances, Address offset: 0x00 */
  __IO uint32_t CSR_EVEN;         /*!< COMP control and status register located in register of comparator instance even, used for bits common to several COMP instances, Address offset: 0x04 */
} COMP_Common_TypeDef;

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;               /*!< CRC Data register,                                   Address offset: 0x00 */
  __IO uint32_t IDR;              /*!< CRC Independent data register,                       Address offset: 0x04 */
  __IO uint32_t CR;               /*!< CRC Control register,                                Address offset: 0x08 */
       uint32_t RESERVED2;        /*!< Reserved,                                                            0x0C */
  __IO uint32_t INIT;             /*!< Initial CRC value register,                          Address offset: 0x10 */
  __IO uint32_t POL;              /*!< CRC polynomial register,                             Address offset: 0x14 */
} CRC_TypeDef;

/**
  * @brief Clock Recovery System
  */
typedef struct
{
__IO uint32_t CR;                 /*!< CRS ccontrol register,              Address offset: 0x00 */
__IO uint32_t CFGR;               /*!< CRS configuration register,         Address offset: 0x04 */
__IO uint32_t ISR;                /*!< CRS interrupt and status register,  Address offset: 0x08 */
__IO uint32_t ICR;                /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;

/**
  * @brief DAC
  */
typedef struct
{
  __IO uint32_t CR;               /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;          /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;          /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;          /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;           /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;          /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;          /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;           /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;          /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;          /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;           /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;             /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;             /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;               /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;              /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;              /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;            /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;            /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;             /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;             /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
  __IO uint32_t RESERVED[1];
  __IO uint32_t AUTOCR;           /*!< DAC Autonomous mode register,                         Address offset: 0x54 */
} DAC_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;           /*!< MCU device ID code,                 Address offset: 0x00 */
  __IO uint32_t CR;               /*!< Debug MCU configuration register,   Address offset: 0x04 */
  __IO uint32_t APB1FZR1;         /*!< Debug MCU APB1 freeze register 1,   Address offset: 0x08 */
  __IO uint32_t APB1FZR2;         /*!< Debug MCU APB1 freeze register 2,   Address offset: 0x0C */
  __IO uint32_t APB2FZR;          /*!< Debug MCU APB2 freeze register,     Address offset: 0x10 */
  __IO uint32_t APB3FZR;          /*!< Debug MCU APB3 freeze register,     Address offset: 0x14 */
       uint32_t RESERVED1[2];     /*!< Reserved,                                    0x18 - 0x1C */
  __IO uint32_t AHB1FZR;          /*!< Debug MCU AHB1 freeze register,     Address offset: 0x20 */
       uint32_t RESERVED2;        /*!< Reserved,                                           0x24 */
  __IO uint32_t AHB3FZR;          /*!< Debug MCU AHB3 freeze register,     Address offset: 0x28 */
} DBGMCU_TypeDef;

/**
  * @ brief Delay Block
  */
typedef struct
{
  __IO uint32_t CR;   /*!< Delay Block Control Register,       Address offset: 0x00 */
  __IO uint32_t CFGR; /*!< Delay Block Configuration Register, Address offset: 0x04 */
} DLYB_TypeDef;

/**
  * @brief DMA Controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;          /*!< DMA secure configuration register,               Address offset: 0x00  */
  __IO uint32_t PRIVCFGR;         /*!< DMA privileged configuration register,           Address offset: 0x04  */
  __IO uint32_t RCFGLOCKR;        /*!< DMA lock configuration register,                 Address offset: 0x08  */
  __IO uint32_t MISR;             /*!< DMA non secure masked interrupt status register, Address offset: 0x0C  */
  __IO uint32_t SMISR;            /*!< DMA secure masked interrupt status register,     Address offset: 0x10  */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CLBAR;            /*!< DMA channel x linked-list base address register, Address offset: 0x50 + (x * 0x80) */
       uint32_t RESERVED1[2];     /*!< Reserved 1,                                      Address offset: 0x54 -- 0x58      */
  __IO uint32_t CFCR;             /*!< DMA channel x flag clear register,               Address offset: 0x5C + (x * 0x80) */
  __IO uint32_t CSR;              /*!< DMA channel x flag status register,              Address offset: 0x60 + (x * 0x80) */
  __IO uint32_t CCR;              /*!< DMA channel x control register,                  Address offset: 0x64 + (x * 0x80) */
       uint32_t RESERVED2[10];    /*!< Reserved 2,                                      Address offset: 0x68 -- 0x8C      */
  __IO uint32_t CTR1;             /*!< DMA channel x transfer register 1,               Address offset: 0x90 + (x * 0x80) */
  __IO uint32_t CTR2;             /*!< DMA channel x transfer register 2,               Address offset: 0x94 + (x * 0x80) */
  __IO uint32_t CBR1;             /*!< DMA channel x block register 1,                  Address offset: 0x98 + (x * 0x80) */
  __IO uint32_t CSAR;             /*!< DMA channel x source address register,           Address offset: 0x9C + (x * 0x80) */
  __IO uint32_t CDAR;             /*!< DMA channel x destination address register,      Address offset: 0xA0 + (x * 0x80) */
  __IO uint32_t CTR3;             /*!< DMA channel x transfer register 3,               Address offset: 0xA4 + (x * 0x80) */
  __IO uint32_t CBR2;             /*!< DMA channel x block register 2,                  Address offset: 0xA8 + (x * 0x80) */
       uint32_t RESERVED3[8];     /*!< Reserved 3,                                      Address offset: 0xAC -- 0xC8      */
  __IO uint32_t CLLR;             /*!< DMA channel x linked-list address register,      Address offset: 0xCC + (x * 0x80) */
} DMA_Channel_TypeDef;

/**
  * @brief Asynch Interrupt/Event Controller (EXTI)
  */
typedef struct
{
  __IO uint32_t RTSR1;            /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;            /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;           /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;             /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;             /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;         /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;        /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1[17];    /*!< Reserved 1,                                                0x1C -- 0x5C */
  __IO uint32_t EXTICR[4];        /*!< EXIT External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;            /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED2[3];     /*!< Reserved 2,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;             /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;             /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
} EXTI_TypeDef;

/**
  * @brief FD Controller Area Network
  */
typedef struct
{
  __IO uint32_t CREL;             /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;             /*!< FDCAN Endian register,                                           Address offset: 0x004 */
       uint32_t RESERVED1;        /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;             /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;             /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;              /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;             /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;             /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;             /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;             /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;             /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;             /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
       uint32_t RESERVED2[4];     /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;              /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;              /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;             /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
       uint32_t RESERVED3;        /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;               /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;               /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;              /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;              /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
       uint32_t RESERVED4[8];     /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t RXGFC;            /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t XIDAM;            /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x084 */
  __IO uint32_t HPMS;             /*!< FDCAN High Priority Message Status register,                     Address offset: 0x088 */
       uint32_t RESERVED5;        /*!< Reserved,                                                                        0x08C */
  __IO uint32_t RXF0S;            /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x090 */
  __IO uint32_t RXF0A;            /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x094 */
  __IO uint32_t RXF1S;            /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x098 */
  __IO uint32_t RXF1A;            /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x09C */
       uint32_t RESERVED6[8];     /*!< Reserved,                                                                0x0A0 - 0x0BC */
  __IO uint32_t TXBC;             /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;            /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXBRP;            /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0C8 */
  __IO uint32_t TXBAR;            /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0CC */
  __IO uint32_t TXBCR;            /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D0 */
  __IO uint32_t TXBTO;            /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D4 */
  __IO uint32_t TXBCF;            /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBTIE;           /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0DC */
  __IO uint32_t TXBCIE;           /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E0 */
  __IO uint32_t TXEFS;            /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0E4 */
  __IO uint32_t TXEFA;            /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0E8 */
} FDCAN_GlobalTypeDef;

/**
  * @brief FD Controller Area Network Configuration
  */
typedef struct
{
  __IO uint32_t CKDIV;            /*!< FDCAN clock divider register,                            Address offset: 0x100 + 0x000 */
       uint32_t RESERVED1[128];   /*!< Reserved,                                                0x100 + 0x004 - 0x100 + 0x200 */
  __IO uint32_t OPTR;             /*!< FDCAN option register,                                   Address offset: 0x100 + 0x204 */
       uint32_t RESERVED2[58];    /*!< Reserved,                                                0x100 + 0x208 - 0x100 + 0x2EC */
  __IO uint32_t HWCFG;            /*!< FDCAN hardware configuration register,                   Address offset: 0x100 + 0x2F0 */
  __IO uint32_t VERR;             /*!< FDCAN IP version register,                               Address offset: 0x100 + 0x2F4 */
  __IO uint32_t IPIDR;            /*!< FDCAN IP ID register,                                    Address offset: 0x100 + 0x2F8 */
  __IO uint32_t SIDR;             /*!< FDCAN size ID register,                                  Address offset: 0x100 + 0x2FC */
} FDCAN_Config_TypeDef;

/**
  * @brief FLASH Registers
  */
typedef struct
{
  __IO uint32_t ACR;              /*!< FLASH access control register,                  Address offset: 0x00 */
       uint32_t RESERVED1;        /*!< Reserved,                                       Address offset: 0x04 */
  __IO uint32_t KEYR;             /*!< FLASH non-secure key register,                  Address offset: 0x08 */
  __IO uint32_t SKEYR;            /*!< FLASH secure key register,                      Address offset: 0x0C */
  __IO uint32_t OPTKEYR;          /*!< FLASH option key register,                      Address offset: 0x10 */
       uint32_t RESERVED2;        /*!< Reserved,                                       Address offset: 0x14 */
  __IO uint32_t PDKEY1R;          /*!< FLASH bank 1 power-down key register,           Address offset: 0x18 */
  __IO uint32_t PDKEY2R;          /*!< FLASH bank 2 power-down key register,           Address offset: 0x1C */
  __IO uint32_t SR;               /*!< FLASH non-secure status register,               Address offset: 0x20 */
  __IO uint32_t SSR;              /*!< FLASH secure status register,                   Address offset: 0x24 */
  __IO uint32_t CR;               /*!< FLASH non-secure control register,              Address offset: 0x28 */
  __IO uint32_t SCR;              /*!< FLASH secure control register,                  Address offset: 0x2C */
  __IO uint32_t ECCCR;            /*!< FLASH ECC correction register,                  Address offset: 0x30 */
  __IO uint32_t ECCDR;            /*!< FLASH ECC detection register,                   Address offset: 0x34 */
  __IO uint32_t OPSR;             /*!< FLASH OPSR register,                            Address offset: 0x38 */
       uint32_t RESERVED3;        /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t OPTR;             /*!< FLASH option control register,                  Address offset: 0x40 */
  __IO uint32_t BOOT0R;           /*!< FLASH non-secure boot address 0 register,       Address offset: 0x44 */
  __IO uint32_t BOOT1R;           /*!< FLASH non-secure boot address 1 register,       Address offset: 0x48 */
  __IO uint32_t SBOOT0R;          /*!< FLASH secure boot address 0 register,           Address offset: 0x4C */
  __IO uint32_t SECWM1R1;         /*!< FLASH secure watermark1 register 1,             Address offset: 0x50 */
  __IO uint32_t SECWM1R2;         /*!< FLASH secure watermark1 register 2,             Address offset: 0x54 */
  __IO uint32_t WRP1AR;           /*!< FLASH WRP1 area A address register,             Address offset: 0x58 */
  __IO uint32_t WRP1BR;           /*!< FLASH WRP1 area B address register,             Address offset: 0x5C */
  __IO uint32_t SECWM2R1;         /*!< FLASH secure watermark2 register 1,             Address offset: 0x60 */
  __IO uint32_t SECWM2R2;         /*!< FLASH secure watermark2 register 2,             Address offset: 0x64 */
  __IO uint32_t WRP2AR;           /*!< FLASH WRP2 area A address register,             Address offset: 0x68 */
  __IO uint32_t WRP2BR;           /*!< FLASH WRP2 area B address register,             Address offset: 0x6C */
       uint32_t RESERVED4[4];     /*!< Reserved,                                       Address offset: 0x70-0x7C */
  __IO uint32_t SECBB1R1;         /*!< FLASH secure block-based bank 1 register 1,     Address offset: 0x80 */
  __IO uint32_t SECBB1R2;         /*!< FLASH secure block-based bank 1 register 2,     Address offset: 0x84 */
  __IO uint32_t SECBB1R3;         /*!< FLASH secure block-based bank 1 register 3,     Address offset: 0x88 */
  __IO uint32_t SECBB1R4;         /*!< FLASH secure block-based bank 1 register 4,     Address offset: 0x8C */
       uint32_t RESERVED5[4];     /*!< Reserved,                                       Address offset: 0x90-0x9C */
  __IO uint32_t SECBB2R1;         /*!< FLASH secure block-based bank 2 register 1,     Address offset: 0xA0 */
  __IO uint32_t SECBB2R2;         /*!< FLASH secure block-based bank 2 register 2,     Address offset: 0xA4 */
  __IO uint32_t SECBB2R3;         /*!< FLASH secure block-based bank 2 register 3,     Address offset: 0xA8 */
  __IO uint32_t SECBB2R4;         /*!< FLASH secure block-based bank 2 register 4,     Address offset: 0xAC */
       uint32_t RESERVED6[4];     /*!< Reserved,                                       Address offset: 0xB0-0xBC */
  __IO uint32_t SECHDPCR;         /*!< FLASH secure HDP control register,              Address offset: 0xC0 */
  __IO uint32_t PRIVCFGR;         /*!< FLASH privilege configuration register,         Address offset: 0xC4 */
  __IO uint32_t SECHDPEXTR;       /*!< FLASH HDP extension register,                   Address offset: 0xC8 */
       uint32_t RESERVED7;        /*!< Reserved,                                       Address offset: 0xCC */
  __IO uint32_t PRIVBB1R1;        /*!< FLASH privilege block-based bank 1 register 1,  Address offset: 0xD0 */
  __IO uint32_t PRIVBB1R2;        /*!< FLASH privilege block-based bank 1 register 2,  Address offset: 0xD4 */
  __IO uint32_t PRIVBB1R3;        /*!< FLASH privilege block-based bank 1 register 3,  Address offset: 0xD8 */
  __IO uint32_t PRIVBB1R4;        /*!< FLASH privilege block-based bank 1 register 4,  Address offset: 0xDC */
       uint32_t RESERVED8[4];     /*!< Reserved,                                       Address offset: 0xE0-0xEC */
  __IO uint32_t PRIVBB2R1;        /*!< FLASH privilege block-based bank 2 register 1,  Address offset: 0xF0 */
  __IO uint32_t PRIVBB2R2;        /*!< FLASH privilege block-based bank 2 register 2,  Address offset: 0xF4 */
  __IO uint32_t PRIVBB2R3;        /*!< FLASH privilege block-based bank 2 register 3,  Address offset: 0xF8 */
  __IO uint32_t PRIVBB2R4;        /*!< FLASH privilege block-based bank 2 register 4,  Address offset: 0xFC */
       uint32_t RESERVED9[4];     /*!< Reserved,                                       Address offset: 0x100-0x10C */
  __IO uint32_t OEM1KEYR1;        /*!< FLASH OEM1 key register 1,                      Address offset: 0x110 */
  __IO uint32_t OEM1KEYR2;        /*!< FLASH OEM1 key register 2,                      Address offset: 0x114 */
  __IO uint32_t OEM1KEYR3;        /*!< FLASH OEM1 key register 3,                      Address offset: 0x118 */
  __IO uint32_t OEM1KEYR4;        /*!< FLASH OEM1 key register 4,                      Address offset: 0x11C */
  __IO uint32_t OEM2KEYR1;        /*!< FLASH OEM2 key register 1,                      Address offset: 0x120 */
  __IO uint32_t OEM2KEYR2;        /*!< FLASH OEM2 key register 2,                      Address offset: 0x124 */
  __IO uint32_t OEM2KEYR3;        /*!< FLASH OEM2 key register 3,                      Address offset: 0x128 */
  __IO uint32_t OEM2KEYR4;        /*!< FLASH OEM2 key register 4,                      Address offset: 0x12C */
  __IO uint32_t OEMKEYSR;         /*!< FLASH OEM key status register,                  Address offset: 0x130 */
} FLASH_TypeDef;

/**
  * @brief General Purpose I/O
  */
typedef struct
{
  __IO uint32_t MODER;            /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;           /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;          /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;            /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;              /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;              /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;             /*!< GPIO port bit set/reset  register,     Address offset: 0x18      */
  __IO uint32_t LCKR;             /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];           /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;              /*!< GPIO Bit Reset register,               Address offset: 0x28      */
  __IO uint32_t HSLVR;            /*!< GPIO high-speed low voltage register,  Address offset: 0x2C      */
  __IO uint32_t SECCFGR;          /*!< GPIO secure configuration register,    Address offset: 0x30      */
} GPIO_TypeDef;

typedef struct
{
  __IO uint32_t IER1;             /*!< TZIC interrupt enable register 1, Address offset: 0x00 */
  __IO uint32_t IER2;             /*!< TZIC interrupt enable register 2, Address offset: 0x04 */
  __IO uint32_t IER3;             /*!< TZIC interrupt enable register 3, Address offset: 0x08 */
  __IO uint32_t IER4;             /*!< TZIC interrupt enable register 4, Address offset: 0x0C */
  __IO uint32_t SR1;              /*!< TZIC status register 1,           Address offset: 0x10 */
  __IO uint32_t SR2;              /*!< TZIC status register 2,           Address offset: 0x14 */
  __IO uint32_t SR3;              /*!< TZIC status register 3,           Address offset: 0x18 */
  __IO uint32_t SR4;              /*!< TZIC status register 4,           Address offset: 0x1C */
  __IO uint32_t FCR1;             /*!< TZIC flag clear register 1,       Address offset: 0x20 */
  __IO uint32_t FCR2;             /*!< TZIC flag clear register 2,       Address offset: 0x24 */
  __IO uint32_t FCR3;             /*!< TZIC flag clear register 3,       Address offset: 0x28 */
  __IO uint32_t FCR4;             /*!< TZIC flag clear register 3,       Address offset: 0x2C */
} GTZC_TZIC_TypeDef;

typedef struct
{
  __IO uint32_t CR;               /*!< MPCBBx control register,                  Address offset: 0x00        */
  uint32_t RESERVED1[3];          /*!< Reserved1,                                Address offset: 0x04-0x0C   */
  __IO uint32_t CFGLOCKR1;        /*!< MPCBBx Configuration lock register,       Address offset: 0x10        */
  uint32_t RESERVED2[59];         /*!< Reserved2,                                Address offset: 0x14-0xFC   */
  __IO uint32_t SECCFGR[12];      /*!< MPCBBx security configuration registers,  Address offset: 0x100-0x12C */
  uint32_t RESERVED3[52];         /*!< Reserved3,                                Address offset: 0x130-0x200 */
  __IO uint32_t PRIVCFGR[12];     /*!< MPCBBx privilege configuration registers, Address offset: 0x200-0x22C */
} GTZC_MPCBB_TypeDef;

/**
  * @brief Global TrustZone Controller
  */
typedef struct
{
  __IO uint32_t CR;               /*!< TZSC control register,                                                Address offset: 0x00      */
       uint32_t RESERVED1[3];     /*!< Reserved1,                                                            Address offset: 0x04-0x0C */
  __IO uint32_t SECCFGR1;         /*!< TZSC secure configuration register 1,                                 Address offset: 0x10      */
  __IO uint32_t SECCFGR2;         /*!< TZSC secure configuration register 2,                                 Address offset: 0x14      */
  __IO uint32_t SECCFGR3;         /*!< TZSC secure configuration register 3,                                 Address offset: 0x18      */
       uint32_t RESERVED2;        /*!< Reserved2,                                                            Address offset: 0x1C      */
  __IO uint32_t PRIVCFGR1;        /*!< TZSC privilege configuration register 1,                              Address offset: 0x20      */
  __IO uint32_t PRIVCFGR2;        /*!< TZSC privilege configuration register 2,                              Address offset: 0x24      */
  __IO uint32_t PRIVCFGR3;        /*!< TZSC privilege configuration register 3,                              Address offset: 0x28      */
} GTZC_TZSC_TypeDef;

/**
  * @brief HASH
  */
typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
  __IO uint32_t SHA3CFGR;         /*!< HASH SHA-3 configuration register,  Address offset: 0x28    */
       uint32_t RESERVED[51];     /*!< Reserved, 0x2C-0xF4                                         */
  __IO uint32_t CSR[103];         /*!< HASH context swap registers,    Address offset: 0x0F8-0x290 */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */
typedef struct
{
  __IO uint32_t HR[50];           /*!< HASH digest registers,          Address offset: 0x310-0x3D4 */
} HASH_DIGEST_TypeDef;

/**
  * @brief HSP
  */
typedef struct
{
  __IO uint32_t CR;             /*!< HSP control register                           Address offset: 0x00 */
       uint32_t RESERVED0[7];   /*!< Reserved                                       Address offset: 0x04 - 0x1C */
  __IO uint32_t OR;             /*!< HSP option register                            Address offset: 0x20 */
       uint32_t RESERVED1[7];   /*!< Reserved                                       Address offset: 0x24 - 0x3C */
  __IO uint32_t C2HSEMR;        /*!< HSP CPU to HSP semaphore register              Address offset: 0x40 */
  __IO uint32_t C2HMSGDR;       /*!< HSP CPU to HSP message data register           Address offset: 0x44 */
  __IO uint32_t H2CSEMR;        /*!< HSP HSP to CPU semaphore register              Address offset: 0x48 */
  __IO uint32_t H2CMSGDR;       /*!< HSP HSP to CPU message data register           Address offset: 0x4C */
       uint32_t RESERVED2[2];   /*!< Reserved                                       Address offset: 0x50 - 0x54 */
  __IO uint32_t DCMDSR;         /*!< HSP DCMD Command status register               Address offset: 0x58 */
  __IO uint32_t DCMDPTSR;       /*!< HSP DCMD Pointer status register               Address offset: 0x5C */
  __IO uint32_t DCMDIDR;        /*!< HSP DCMD Command ID register                   Address offset: 0x60 */
  __IO uint32_t DCMDPTR0;       /*!< HSP DCMD address pointer register 0            Address offset: 0x64 */
  __IO uint32_t DCMDPTR1;       /*!< HSP DCMD address pointer register 1            Address offset: 0x68 */
  __IO uint32_t DCMDPTR2;       /*!< HSP DCMD address pointer register 2            Address offset: 0x6C */
       uint32_t RESERVED3[4];   /*!< Reserved                                       Address offset: 0x70 - 0x7C */
  __IO uint32_t EVTENR;         /*!< HSP event enable register                      Address offset: 0x80 */
  __IO uint32_t ESYNCENR;       /*!< HSP Event synchronization enable register      Address offset: 0x84 */
  __IO uint32_t ESYNC0SRCR;     /*!< HSP Event synchronization source register 0    Address offset: 0x88 */
  __IO uint32_t ESYNC1SRCR;     /*!< HSP Event synchronization source register 1    Address offset: 0x8C */
  __IO uint32_t ESYNC2SRCR;     /*!< HSP Event synchronization source register 2    Address offset: 0x90 */
       uint32_t RESERVED4;      /*!< Reserved                                       Address offset: 0x94 */
  __IO uint32_t PEVTLR;         /*!< HSP pending event level register               Address offset: 0x98 */
       uint32_t RESERVED5;      /*!< Reserved                                       Address offset: 0x9C */
  __IO uint32_t ITFENR;         /*!< HSP interfaces enable register                 Address offset: 0xA0 */
       uint32_t RESERVED6[4];   /*!< Reserved                                       Address offset: 0xA4 - 0xB0 */
  __IO uint32_t EVTSRC0R;       /*!< HSP Event source register 0                    Address offset: 0xB4 */
  __IO uint32_t EVTSRC1R;       /*!< HSP Event source register 1                    Address offset: 0xB8 */
  __IO uint32_t EVTSRC2R;       /*!< HSP Event source register 2                    Address offset: 0xBC */
       uint32_t RESERVED7[13];  /*!< Reserved                                       Address offset: 0xC0 - 0xF0 */
  __IO uint32_t BUFFCFGR;       /*!< HSP BUFF configuration register                Address offset: 0xF4 */
  __IO uint32_t BUFF0DR;        /*!< HSP BUFF0 data register 0                      Address offset: 0xF8 */
  __IO uint32_t BUFF1DR;        /*!< HSP BUFF1 data register 1                      Address offset: 0xFC */
  __IO uint32_t BUFF2DR;        /*!< HSP BUFF2 data register 2                      Address offset: 0x100 */
  __IO uint32_t BUFF3DR;        /*!< HSP BUFF3 data register 3                      Address offset: 0x104 */
       uint32_t RESERVED8[6];   /*!< Reserved                                       Address offset: 0x108 - 0x11C */
  __IO uint32_t TRGINCFGR;      /*!< HSP TRGIN configuration register               Address offset: 0x120 */
  __IO uint32_t TRGOCFGR;       /*!< HSP TRGO configuration register                Address offset: 0x124 */
       uint32_t RESERVED9;      /*!< Reserved                                       Address offset: 0x128 */
  __IO uint32_t CSEGR;          /*!< HSP CPU shared event generator register        Address offset: 0x12C */
  __IO uint32_t CDEGR;          /*!< HSP CPU dedicated event generation register    Address offset: 0x130 */
       uint32_t RESERVED10[7];  /*!< Reserved                                       Address offset: 0x134 - 0x14C */
  __IO uint32_t TRGINSELR0;     /*!< HSP TRGIN input selection register 0           Address offset: 0x150 */
  __IO uint32_t TRGINSELR1;     /*!< HSP TRGIN input selection register 1           Address offset: 0x154 */
  __IO uint32_t TRGINSELR2;     /*!< HSP TRGIN input selection register 2           Address offset: 0x158 */
       uint32_t RESERVED11[3];  /*!< Reserved                                       Address offset: 0x15C - 0x164 */
  __IO uint32_t BKO0CFGR;       /*!< HSP break output configuration register 0      Address offset: 0x168 */
  __IO uint32_t BKO1CFGR;       /*!< HSP break output configuration register 1      Address offset: 0x16C */
  __IO uint32_t BKO2CFGR;       /*!< HSP break output configuration register 2      Address offset: 0x170 */
  __IO uint32_t BKO3CFGR;       /*!< HSP break output configuration register 3      Address offset: 0x174 */
  __IO uint32_t BKICFGR;        /*!< HSP break input configuration register         Address offset: 0x178 */
       uint32_t RESERVED12[3];  /*!< Reserved                                       Address offset: 0x17C - 0x184 */
  __IO uint32_t FWERR;          /*!< HSP firmware error register                    Address offset: 0x188 */
       uint32_t RESERVED13[2];  /*!< Reserved                                       Address offset: 0x18C - 0x190 */
  __IO uint32_t PARAMR0;        /*!< HSP parameter register 0                       Address offset: 0x194 */
  __IO uint32_t PARAMR1;        /*!< HSP parameter register 1                       Address offset: 0x198 */
  __IO uint32_t PARAMR2;        /*!< HSP parameter register 2                       Address offset: 0x19C */
  __IO uint32_t PARAMR3;        /*!< HSP parameter register 3                       Address offset: 0x1A0 */
  __IO uint32_t PARAMR4;        /*!< HSP parameter register 4                       Address offset: 0x1A4 */
  __IO uint32_t PARAMR5;        /*!< HSP parameter register 5                       Address offset: 0x1A8 */
  __IO uint32_t PARAMR6;        /*!< HSP parameter register 6                       Address offset: 0x1AC */
  __IO uint32_t PARAMR7;        /*!< HSP parameter register 7                       Address offset: 0x1B0 */
  __IO uint32_t PARAMR8;        /*!< HSP parameter register 8                       Address offset: 0x1B4 */
  __IO uint32_t PARAMR9;        /*!< HSP parameter register 9                       Address offset: 0x1B8 */
  __IO uint32_t PARAMR10;       /*!< HSP parameter register 10                      Address offset: 0x1BC */
  __IO uint32_t PARAMR11;       /*!< HSP parameter register 11                      Address offset: 0x1C0 */
  __IO uint32_t PARAMR12;       /*!< HSP parameter register 12                      Address offset: 0x1C4 */
  __IO uint32_t PARAMR13;       /*!< HSP parameter register 13                      Address offset: 0x1C8 */
  __IO uint32_t PARAMR14;       /*!< HSP parameter register 14                      Address offset: 0x1CC */
  __IO uint32_t PARAMR15;       /*!< HSP parameter register 15                      Address offset: 0x1D0 */
       uint32_t RESERVED14[43]; /*!< Reserved                                       Address offset: 0x1D4 - 0x27C */
  __IO uint32_t SPE_IER;        /*!< HSP SPE interrupt enable register              Address offset: 0x280 */
  __IO uint32_t SPE_ISR;        /*!< HSP SPE interrupt status register              Address offset: 0x284 */
       uint32_t RESERVED15[46]; /*!< Reserved                                       Address offset: 0x288 - 0x33C */
  __IO uint32_t TCUCFGR;        /*!< HSP task comparator unit register              Address offset: 0x340 */
  __IO uint32_t TOVLPCR;        /*!< HSP task overlap control register              Address offset: 0x344 */
       uint32_t RESERVED16[12]; /*!< Reserved                                       Address offset: 0x348 - 0x374 */
  __IO uint32_t SNPR;           /*!< HSP snoop register                             Address offset: 0x378 */
  __IO uint32_t CCNTR;          /*!< HSP conflict counter register                  Address offset: 0x37C */
  __IO uint32_t CAPDR;          /*!< HSP data capture register                      Address offset: 0x380 */
  __IO uint32_t CAPCR;          /*!< HSP capture control register                   Address offset: 0x384 */
       uint32_t RESERVED17[4];  /*!< Reserved                                       Address offset: 0x388 - 0x394 */
  __IO uint32_t ERR_IER;        /*!< HSP error interrupt enable register            Address offset: 0x398 */
  __IO uint32_t EVT_IER;        /*!< HSP events interrupt enable register           Address offset: 0x39C */
  __IO uint32_t PFCTEVT_IER;    /*!< HSP processing event interrupt enable register Address offset: 0x3A0 */
  __IO uint32_t ERR_ISR;        /*!< HSP error interrupt status register            Address offset: 0x3A4 */
  __IO uint32_t EVT_ISR;        /*!< HSP events interrupt status register           Address offset: 0x3A8 */
  __IO uint32_t PFCTEVT_ISR;    /*!< HSP processing event interrupt status register Address offset: 0x3AC */
  __IO uint32_t ERRINFR;        /*!< HSP error information register                 Address offset: 0x3B0 */
  __IO uint32_t ERR_ICR;        /*!< HSP error interrupt clear register             Address offset: 0x3B4 */
  __IO uint32_t EVT_ICR;        /*!< HSP events Interrupt clear register            Address offset: 0x3B8 */
  __IO uint32_t PFCTEVT_ICR;    /*!< HSP processing event interrupt clear register  Address offset: 0x3BC */
       uint32_t RESERVED18[7];  /*!< Reserved                                       Address offset: 0x3C0 - 0x3D8 */
  __IO uint32_t FWVERR;         /*!< HSP firmware versions register                 Address offset: 0x3DC */
  __IO uint32_t SPEVERR;        /*!< HSP SPE version register                       Address offset: 0x3E0 */
  __IO uint32_t HWCFGR4;        /*!< HSP hardware configuration register 4          Address offset: 0x3E4 */
  __IO uint32_t HWCFGR3;        /*!< HSP hardware configuration register 3          Address offset: 0x3E8 */
  __IO uint32_t HWCFGR2;        /*!< HSP hardware configuration register 2          Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;        /*!< HSP hardware configuration register 1          Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< HSP version register                           Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< HSP identification register                    Address offset: 0x3F8 */
  __IO uint32_t SIDR; /*!< HSP size identification register Address offset: 0x3FC */
}HSP_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< I2C Control register 1,                  Address offset: 0x00 */
  __IO uint32_t CR2;              /*!< I2C Control register 2,                  Address offset: 0x04 */
  __IO uint32_t OAR1;             /*!< I2C Own address 1 register,              Address offset: 0x08 */
  __IO uint32_t OAR2;             /*!< I2C Own address 2 register,              Address offset: 0x0C */
  __IO uint32_t TIMINGR;          /*!< I2C Timing register,                     Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;         /*!< I2C Timeout register,                    Address offset: 0x14 */
  __IO uint32_t ISR;              /*!< I2C Interrupt and status register,       Address offset: 0x18 */
  __IO uint32_t ICR;              /*!< I2C Interrupt clear register,            Address offset: 0x1C */
  __IO uint32_t PECR;             /*!< I2C PEC register,                        Address offset: 0x20 */
  __IO uint32_t RXDR;             /*!< I2C Receive data register,               Address offset: 0x24 */
  __IO uint32_t TXDR;             /*!< I2C Transmit data register,              Address offset: 0x28 */
  __IO uint32_t AUTOCR;           /*!< I2C Autonomous mode control register,    Address offset: 0x2C */
} I2C_TypeDef;

/**
  * @brief Improved Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR;             /*!< I3C Control register,                      Address offset: 0x00      */
  __IO uint32_t CFGR;           /*!< I3C Controller Configuration register,     Address offset: 0x04      */
  uint32_t      RESERVED1[2];   /*!< Reserved,                                  Address offset: 0x08-0x0C */
  __IO uint32_t RDR;            /*!< I3C Received Data register,                Address offset: 0x10      */
  __IO uint32_t RDWR;           /*!< I3C Received Data Word register,           Address offset: 0x14      */
  __IO uint32_t TDR;            /*!< I3C Transmit Data register,                Address offset: 0x18      */
  __IO uint32_t TDWR;           /*!< I3C Transmit Data Word register,           Address offset: 0x1C      */
  __IO uint32_t IBIDR;          /*!< I3C IBI payload Data register,             Address offset: 0x20      */
  __IO uint32_t TGTTDR;         /*!< I3C Target Transmit register,              Address offset: 0x24      */
  uint32_t      RESERVED2[2];   /*!< Reserved,                                  Address offset: 0x28-0x2C */
  __IO uint32_t SR;             /*!< I3C Status register,                       Address offset: 0x30      */
  __IO uint32_t SER;            /*!< I3C Status Error register,                 Address offset: 0x34      */
  uint32_t      RESERVED3[2];   /*!< Reserved,                                  Address offset: 0x38-0x3C */
  __IO uint32_t RMR;            /*!< I3C Received Message register,             Address offset: 0x40      */
  uint32_t      RESERVED4[3];   /*!< Reserved,                                  Address offset: 0x44-0x4C */
  __IO uint32_t EVR;            /*!< I3C Event register,                        Address offset: 0x50      */
  __IO uint32_t IER;            /*!< I3C Interrupt Enable register,             Address offset: 0x54      */
  __IO uint32_t CEVR;           /*!< I3C Clear Event register,                  Address offset: 0x58      */
  __IO uint32_t MISR;           /*!< I3C Masked Interrupt Status register,      Address offset: 0x5C      */
  __IO uint32_t DEVR0;          /*!< I3C own Target characteristics register,   Address offset: 0x60      */
  __IO uint32_t DEVRX[4];       /*!< I3C Target x (1<=x<=4) register,           Address offset: 0x64-0x70 */
  uint32_t      RESERVED6[7];   /*!< Reserved,                                  Address offset: 0x74-0x8C */
  __IO uint32_t MAXRLR;         /*!< I3C Maximum Read Length register,          Address offset: 0x90      */
  __IO uint32_t MAXWLR;         /*!< I3C Maximum Write Length register,         Address offset: 0x94      */
  uint32_t      RESERVED7[2];   /*!< Reserved,                                  Address offset: 0x98-0x9C */
  __IO uint32_t TIMINGR0;       /*!< I3C Timing 0 register,                     Address offset: 0xA0      */
  __IO uint32_t TIMINGR1;       /*!< I3C Timing 1 register,                     Address offset: 0xA4      */
  __IO uint32_t TIMINGR2;       /*!< I3C Timing 2 register,                     Address offset: 0xA8      */
  uint32_t      RESERVED9[5];   /*!< Reserved,                                  Address offset: 0xAC-0xBC */
  __IO uint32_t BCR;            /*!< I3C Bus Characteristics register,          Address offset: 0xC0      */
  __IO uint32_t DCR;            /*!< I3C Device Characteristics register,       Address offset: 0xC4      */
  __IO uint32_t GETCAPR;        /*!< I3C GET CAPabilities register,             Address offset: 0xC8      */
  __IO uint32_t CRCAPR;         /*!< I3C Controller CAPabilities register,      Address offset: 0xCC      */
  __IO uint32_t GETMXDSR;       /*!< I3C GET Max Data Speed register,           Address offset: 0xD0      */
  __IO uint32_t EPIDR;          /*!< I3C Extended Provisioned ID register,      Address offset: 0xD4      */
} I3C_TypeDef;

/**
  * @brief Instruction Cache
  */
typedef struct
{
  __IO uint32_t CR;               /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;               /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;              /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;              /*!< ICACHE Flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;            /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;            /*!< ICACHE miss monitor register,           Address offset: 0x14 */
       uint32_t RESERVED1[2];     /*!< Reserved,                                        0x018-0x01C */
  __IO uint32_t CRR0;             /*!< ICACHE region 0 configuration register, Address offset: 0x20 */
  __IO uint32_t CRR1;             /*!< ICACHE region 1 configuration register, Address offset: 0x24 */
  __IO uint32_t CRR2;             /*!< ICACHE region 2 configuration register, Address offset: 0x28 */
  __IO uint32_t CRR3;             /*!< ICACHE region 3 configuration register, Address offset: 0x2C */
} ICACHE_TypeDef;

/**
  * @brief IWDG
  */
typedef struct
{
  __IO uint32_t KR;               /*!< IWDG Key register,          Address offset: 0x00 */
  __IO uint32_t PR;               /*!< IWDG Prescaler register,    Address offset: 0x04 */
  __IO uint32_t RLR;              /*!< IWDG Reload register,       Address offset: 0x08 */
  __IO uint32_t SR;               /*!< IWDG Status register,       Address offset: 0x0C */
  __IO uint32_t WINR;             /*!< IWDG Window register,       Address offset: 0x10 */
  __IO uint32_t EWCR;             /*!< IWDG Early Wakeup register, Address offset: 0x14 */
} IWDG_TypeDef;


/**
  * @brief LPTIMER
  */
typedef struct
{
  __IO uint32_t ISR;              /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;              /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t DIER;             /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;             /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;               /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CCR1;             /*!< LPTIM Capture/Compare register 1,       Address offset: 0x14 */
  __IO uint32_t ARR;              /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;              /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t RESERVED0;        /*!< Reserved,                               Address offset: 0x20 */
  __IO uint32_t CFGR2;            /*!< LPTIM Configuration register 2,         Address offset: 0x24 */
  __IO uint32_t RCR;              /*!< LPTIM Repetition register,              Address offset: 0x28 */
  __IO uint32_t CCMR1;            /*!< LPTIM Capture/Compare mode register,    Address offset: 0x2C */
  __IO uint32_t RESERVED1;        /*!< Reserved,                               Address offset: 0x30 */
  __IO uint32_t CCR2;             /*!< LPTIM Capture/Compare register 2,       Address offset: 0x34 */
} LPTIM_TypeDef;

/**
  * @brief MDF/ADF
  */
typedef struct
{
  __IO uint32_t GCR;              /*!< MDF Global Control register,            Address offset: 0x00  */
  __IO uint32_t CKGCR;            /*!< MDF Clock Generator Control Register,   Address offset: 0x04  */
 uint32_t       RESERVED0[6];     /*!< Reserved, 0x08-0x1C                                           */
  __IO uint32_t TRGISELR;         /*!< MDF Trigger Input Selection Register,   Address offset: 0x20  */
} MDF_TypeDef;

/**
  * @brief MDF/ADF filter
  */
typedef struct
{
 __IO uint32_t SITFCR;            /*!< MDF Serial Interface Control Register,          Address offset: 0x80 */
 __IO uint32_t BSMXCR;            /*!< MDF Bitstream Matrix Control Register,          Address offset: 0x84 */
 __IO uint32_t DFLTCR;            /*!< MDF Digital Filter Control Register,            Address offset: 0x88 */
 __IO uint32_t DFLTCICR;          /*!< MDF MCIC Configuration Register,                Address offset: 0x8C */
 __IO uint32_t DFLTRSFR;          /*!< MDF Reshape Filter Configuration Register,      Address offset: 0x90 */
 uint32_t      RESERVED0[4];      /*!< Reserved, 0x94-0xA0                                                  */
 __IO uint32_t DLYCR;             /*!< MDF Delay control Register,                     Address offset: 0xA4 */
 uint32_t      RESERVED1[1];      /*!< Reserved, 0xA8                                                       */
 __IO uint32_t DFLTIER;           /*!< MDF DFLT Interrupt enable Register,             Address offset: 0xAC */
 __IO uint32_t DFLTISR;           /*!< MDF DFLT Interrupt status Register,             Address offset: 0xB0 */
 uint32_t      RESERVED2[1];      /*!< Reserved, 0xB4                                                       */
 __IO uint32_t SADCR;             /*!< MDF SAD Control Register,                       Address offset: 0xB8 */
 __IO uint32_t SADCFGR;           /*!< MDF SAD configuration register,                 Address offset: 0xBC */
 __IO uint32_t SADSDLVR;          /*!< MDF SAD Sound level Register,                   Address offset: 0xC0 */
 __IO uint32_t SADANLVR;          /*!< MDF SAD Ambient Noise level Register,           Address offset: 0xC4 */
 uint32_t      RESERVED3[10];     /*!< Reserved, 0xC8-0xEC                                                  */
 __IO uint32_t DFLTDR;            /*!< MDF Digital Filter Data Register,               Address offset: 0xF0 */
} MDF_Filter_TypeDef;

/**
  * @brief Operational Amplifier (OPAMP)
  */
typedef struct
{
  __IO uint32_t CSR;              /*!< OPAMP control/status register,                     Address offset: 0x00 */
  __IO uint32_t OTR;              /*!< OPAMP offset trimming register for normal mode,    Address offset: 0x04 */
  __IO uint32_t LPOTR;            /*!< OPAMP offset trimming register for low power mode, Address offset: 0x08 */
} OPAMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR;              /*!< OPAMP control/status register, used for bits common to
                                    several OPAMP instances, Address offset: 0x00         */
} OPAMP_Common_TypeDef;

/**
  * @brief Power Control
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< Power control register 1,                          Address offset: 0x00 */
  __IO uint32_t CR2;              /*!< Power control register 2,                          Address offset: 0x04 */
  __IO uint32_t CR3;              /*!< Power control register 3,                          Address offset: 0x08 */
  __IO uint32_t VOSR;             /*!< Power voltage scaling register,                    Address offset: 0x0C */
  __IO uint32_t SVMCR;            /*!< Power supply voltage monitoring control register,  Address offset: 0x10 */
  __IO uint32_t WUCR1;            /*!< Power wakeup control register 1,                   Address offset: 0x14 */
  __IO uint32_t WUCR2;            /*!< Power wakeup control register 2,                   Address offset: 0x18 */
  __IO uint32_t WUCR3;            /*!< Power wakeup control register 3,                   Address offset: 0x1C */
  uint32_t      RESERVED1;        /*!< Reserved,                                          Address offset: 0x20 */
  __IO uint32_t BDCR;             /*!< Power backup domain control register,              Address offset: 0x24 */
  __IO uint32_t DBPR;             /*!< Power disable backup domain register,              Address offset: 0x28 */
  uint32_t      RESERVED2;        /*!< Reserved,                                          Address offset: 0x2C */
  __IO uint32_t SECCFGR;          /*!< Power Security configuration register,             Address offset: 0x30 */
  __IO uint32_t PRIVCFGR;         /*!< Power privilege control register,                  Address offset: 0x34 */
  __IO uint32_t SR;               /*!< Power status register,                             Address offset: 0x38 */
  __IO uint32_t SVMSR;            /*!< Power supply voltage monitoring status register,   Address offset: 0x3C */
  uint32_t      RESERVED3;        /*!< Reserved,                                          Address offset: 0x20 */
  __IO uint32_t WUSR;             /*!< Power wakeup status register,                      Address offset: 0x44 */
  __IO uint32_t WUSCR;            /*!< Power wakeup status clear register,                Address offset: 0x48 */
  __IO uint32_t APCR;             /*!< Power apply pull configuration register,           Address offset: 0x4C */
  __IO uint32_t PUCRA;            /*!< Power Port A pull-up control register,             Address offset: 0x50 */
  __IO uint32_t PDCRA;            /*!< Power Port A pull-down control register,           Address offset: 0x54 */
  __IO uint32_t PUCRB;            /*!< Power Port B pull-up control register,             Address offset: 0x58 */
  __IO uint32_t PDCRB;            /*!< Power Port B pull-down control register,           Address offset: 0x5C */
  __IO uint32_t PUCRC;            /*!< Power Port C pull-up control register,             Address offset: 0x60 */
  __IO uint32_t PDCRC;            /*!< Power Port C pull-down control register,           Address offset: 0x64 */
  __IO uint32_t PUCRD;            /*!< Power Port D pull-up control register,             Address offset: 0x68 */
  __IO uint32_t PDCRD;            /*!< Power Port D pull-down control register,           Address offset: 0x6C */
  __IO uint32_t PUCRE;            /*!< Power Port E pull-up control register,             Address offset: 0x70 */
  __IO uint32_t PDCRE;            /*!< Power Port E pull-down control register,           Address offset: 0x74 */
  __IO uint32_t PUCRF;            /*!< Power Port F pull-up control register,             Address offset: 0x78 */
  __IO uint32_t PDCRF;            /*!< Power Port F pull-down control register,           Address offset: 0x7C */
  __IO uint32_t PUCRG;            /*!< Power Port G pull-up control register,             Address offset: 0x80 */
  __IO uint32_t PDCRG;            /*!< Power Port G pull-down control register,           Address offset: 0x84 */
  __IO uint32_t PUCRH;            /*!< Power Port H pull-up control register,             Address offset: 0x88 */
  __IO uint32_t PDCRH;            /*!< Power Port H pull-down control register,           Address offset: 0x8C */
  uint32_t      RESERVED4[8];     /*!< Reserved,                                          Address offset: 0x90 -> 0xAC */
  __IO uint32_t I3CPUCR1;         /*!< Power I3C pull-up control register 1,              Address offset: 0xB0 */
  __IO uint32_t I3CPUCR2;         /*!< Power I3C pull-up control register 2,              Address offset: 0xB4 */
} PWR_TypeDef;

/**
  * @brief SRAMs configuration controller
  */
typedef struct
{
  __IO uint32_t CR;           /*!< Control Register,                  Address offset: 0x00 */
  __IO uint32_t IER;          /*!< Interrupt enable register,         Address offset: 0x04 */
  __IO uint32_t ISR;          /*!< Interrupt status register,         Address offset: 0x08 */
  uint32_t      RESERVED0;    /*!< Reserved,                          Address offset: 0x0C */
  __IO uint32_t PEAR;         /*!< Parity error address register,     Address offset: 0x10 */
  __IO uint32_t ICR;          /*!< Interrupt clear register,          Address offset: 0x14 */
  __IO uint32_t WPR1;         /*!< Write protection register 1,       Address offset: 0x18 */
  __IO uint32_t WPR2;         /*!< Write protection register 2,       Address offset: 0x1C */
  uint32_t      RESERVED1;    /*!< Reserved,                          Address offset: 0x20 */
  __IO uint32_t PARKEYR;      /*!< Parity key register,               Address offset: 0x24 */
  __IO uint32_t ERKEYR;       /*!< Erase key register,                Address offset: 0x28 */
}RAMCFG_TypeDef;

/**
  * @brief Reset and Clock Control
  */
typedef struct
{
  __IO uint32_t CR;               /*!< RCC Clock Control Register                               Address offset: 0x000 */
  uint32_t      RESERVED0;        /*!< Reserved                                                 Address offset: 0x004 */
  __IO uint32_t ICSCR1;           /*!< RCC Internal Clock Sources Calibration Register 1        Address offset: 0x008 */
  __IO uint32_t ICSCR2;           /*!< RCC Internal Clock Sources Calibration Register 2        Address offset: 0x00C */
  __IO uint32_t ICSCR3;           /*!< RCC Internal Clock Sources Calibration Register 3        Address offset: 0x010 */
  __IO uint32_t CRRCR;            /*!< RCC Clock Recovery RC Register                           Address offset: 0x014 */
  uint32_t      RESERVED1;        /*!< Reserved                                                 Address offset: 0x018 */
  __IO uint32_t CFGR1;            /*!< RCC Clock Configuration Register 1                       Address offset: 0x01C */
  __IO uint32_t CFGR2;            /*!< RCC Clock Configuration Register 2                       Address offset: 0x020 */
  __IO uint32_t CFGR3;            /*!< RCC Clock Configuration Register 3                       Address offset: 0x024 */
  __IO uint32_t CFGR4;            /*!< RCC Clock Configuration Register 4                       Address offset: 0x028 */
  uint32_t      RESERVED2[9];     /*!< Reserved                                                 Address offset: 0x02C */
  __IO uint32_t CIER;             /*!< Clock Interrupt Enable Register                          Address offset: 0x050 */
  __IO uint32_t CIFR;             /*!< Clock Interrupt Flag Register                            Address offset: 0x054 */
  __IO uint32_t CICR;             /*!< Clock Interrupt Clear Register                           Address offset: 0x058 */
  uint32_t      RESERVED3;        /*!< Reserved                                                 Address offset: 0x05C */
  __IO uint32_t AHB1RSTR1;        /*!< AHB1 Peripherals Reset Register 1                        Address offset: 0x060 */
  __IO uint32_t AHB2RSTR1;        /*!< AHB2 Peripherals Reset Register 1                        Address offset: 0x064 */
  __IO uint32_t AHB2RSTR2;        /*!< AHB2 Peripherals Reset Register 2                        Address offset: 0x068 */
  uint32_t      RESERVED4[2];     /*!< Reserved                                                 Address offset: 0x06C */
  __IO uint32_t APB1RSTR1;        /*!< APB1 Peripherals Reset Register 1                        Address offset: 0x074 */
  __IO uint32_t APB1RSTR2;        /*!< APB1 Peripherals Reset Register 2                        Address offset: 0x078 */
  __IO uint32_t APB2RSTR;         /*!< APB2 Peripherals Reset Register                          Address offset: 0x07C */
  __IO uint32_t APB3RSTR;         /*!< APB3 Peripherals Reset Register                          Address offset: 0x080 */
  uint32_t      RESERVED5;        /*!< Reserved                                                 Address offset: 0x084 */
  __IO uint32_t AHB1ENR1;         /*!< AHB1 Peripherals Clock Enable Register 1                 Address offset: 0x088 */
  __IO uint32_t AHB2ENR1;         /*!< AHB2 Peripherals Clock Enable Register 1                 Address offset: 0x08C */
  __IO uint32_t AHB2ENR2;         /*!< AHB2 Peripherals Clock Enable Register 2                 Address offset: 0x090 */
  __IO uint32_t AHB1ENR2;         /*!< AHB1 Peripherals Clock Enable Register 2                 Address offset: 0x094 */
  uint32_t      RESERVED6;        /*!< Reserved                                                 Address offset: 0x098 */
  __IO uint32_t APB1ENR1;         /*!< APB1 Peripherals Clock Enable Register 1                 Address offset: 0x09C */
  __IO uint32_t APB1ENR2;         /*!< APB1 Peripherals Clock Enable Register 2                 Address offset: 0x0A0 */
  __IO uint32_t APB2ENR;          /*!< APB2 Peripherals Clock Enable Register                   Address offset: 0x0A4 */
  __IO uint32_t APB3ENR;          /*!< APB3 Peripherals Clock Enable Register                   Address offset: 0x0A8 */
  uint32_t      RESERVED7;        /*!< Reserved                                                 Address offset: 0x0AC */
  __IO uint32_t AHB1SLPENR1;      /*!< AHB1 Peripherals Clock Enable in Sleep Mode Register 1   Address offset: 0x0B0 */
  __IO uint32_t AHB2SLPENR1;      /*!< AHB2 Peripherals Clock Enable in Sleep Mode Register 1   Address offset: 0x0B4 */
  __IO uint32_t AHB2SLPENR2;      /*!< AHB2 Peripherals Clock Enable in Sleep Mode Register 2   Address offset: 0x0B8 */
  __IO uint32_t AHB1SLPENR2;      /*!< AHB1 Peripherals Clock Enable in Sleep Mode Register 2   Address offset: 0x0BC */
  uint32_t      RESERVED8;        /*!< Reserved                                                 Address offset: 0x0C0 */
  __IO uint32_t APB1SLPENR1;      /*!< APB1 Peripherals Clock Enable in Sleep Mode Register 1   Address offset: 0x0C4 */
  __IO uint32_t APB1SLPENR2;      /*!< APB1 Peripherals Clock Enable in Sleep Mode Register 2   Address offset: 0x0C8 */
  __IO uint32_t APB2SLPENR;       /*!< APB2 Peripherals Clock Enable in Sleep Mode Register     Address offset: 0x0CC */
  __IO uint32_t APB3SLPENR;       /*!< APB3 Peripherals Clock Enable in Sleep Mode Register     Address offset: 0x0D0 */
  uint32_t      RESERVED9;        /*!< Reserved                                                 Address offset: 0x0D4 */
  __IO uint32_t AHB1STPENR1;      /*!< AHB1 Peripherals Clock Enable in Stop Mode Register 1    Address offset: 0x0D8 */
  __IO uint32_t AHB2STPENR1;      /*!< AHB2 Peripherals Clock Enable in Stop Mode Register 1    Address offset: 0x0DC */
  uint32_t      RESERVED10[3];    /*!< Reserved                                                 Address offset: 0x0E0 */
  __IO uint32_t APB1STPENR1;      /*!< APB1 Peripherals Clock Enable in Stop Mode Register 1    Address offset: 0x0EC */
  __IO uint32_t APB1STPENR2;      /*!< APB1 Peripherals Clock Enable in Stop Mode Register 2    Address offset: 0x0F0 */
  __IO uint32_t APB2STPENR;       /*!< APB2 Peripherals Clock Enable in Stop Mode Register      Address offset: 0x0F4 */
  __IO uint32_t APB3STPENR;       /*!< APB3 Peripherals Clock Enable in Stop Mode Register      Address offset: 0x0F8 */
       uint32_t RESERVED11;       /*!< Reserved                                                 Address offset: 0x0FC */
  __IO uint32_t CCIPR1;           /*!< Peripherals Independent Clocks Configuration Register 1  Address offset: 0x100 */
  __IO uint32_t CCIPR2;           /*!< Peripherals Independent Clocks Configuration Register 2  Address offset: 0x104 */
  __IO uint32_t CCIPR3;           /*!< Peripherals Independent Clocks Configuration Register 3  Address offset: 0x108 */
  uint32_t      RESERVED12;       /*!< Reserved                                                 Address offset: 0x10C */
  __IO uint32_t BDCR;             /*!< Backup Domain Control Register                           Address offset: 0x110 */
  __IO uint32_t CSR;              /*!< Control & Status Register                                Address offset: 0x114 */
  uint32_t      RESERVED13[6];    /*!< Reserved                                                 Address offset: 0x118 */
  __IO uint32_t SECCFGR;          /*!< RCC Secure Configuration Register                        Address offset: 0x130 */
  __IO uint32_t PRIVCFGR;         /*!< RCC Privilege Configuration Register                     Address offset: 0x134 */
} RCC_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;               /*!< RNG control register,                     Address offset: 0x00 */
  __IO uint32_t SR;               /*!< RNG status register,                      Address offset: 0x04 */
  __IO uint32_t DR;               /*!< RNG data register,                        Address offset: 0x08 */
  __IO uint32_t NSCR;             /*!< RNG noise source control register,        Address offset: 0x0C */
  __IO uint32_t HTCR;             /*!< RNG health test configuration register,   Address offset: 0x10 */
} RNG_TypeDef;

/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;               /*!< RTC time register,                              Address offset: 0x00 */
  __IO uint32_t DR;               /*!< RTC date register,                              Address offset: 0x04 */
  __IO uint32_t SSR;              /*!< RTC sub second register,                        Address offset: 0x08 */
  __IO uint32_t ICSR;             /*!< RTC initialization control and status register, Address offset: 0x0C */
  __IO uint32_t PRER;             /*!< RTC prescaler register,                         Address offset: 0x10 */
  __IO uint32_t WUTR;             /*!< RTC wakeup timer register,                      Address offset: 0x14 */
  __IO uint32_t CR;               /*!< RTC control register,                           Address offset: 0x18 */
  __IO uint32_t PRIVCFGR;         /*!< RTC privilege mode control register,            Address offset: 0x1C */
  __IO uint32_t SECCFGR;          /*!< RTC secure mode control register,               Address offset: 0x20 */
  __IO uint32_t WPR;              /*!< RTC write protection register,                  Address offset: 0x24 */
  __IO uint32_t CALR;             /*!< RTC calibration register,                       Address offset: 0x28 */
  __IO uint32_t SHIFTR;           /*!< RTC shift control register,                     Address offset: 0x2C */
  __IO uint32_t TSTR;             /*!< RTC time stamp time register,                   Address offset: 0x30 */
  __IO uint32_t TSDR;             /*!< RTC time stamp date register,                   Address offset: 0x34 */
  __IO uint32_t TSSSR;            /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
       uint32_t RESERVED0;        /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t ALRMAR;           /*!< RTC alarm A register,                           Address offset: 0x40 */
  __IO uint32_t ALRMASSR;         /*!< RTC alarm A sub second register,                Address offset: 0x44 */
  __IO uint32_t ALRMBR;           /*!< RTC alarm B register,                           Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;         /*!< RTC alarm B sub second register,                Address offset: 0x4C */
  __IO uint32_t SR;               /*!< RTC Status register,                            Address offset: 0x50 */
  __IO uint32_t MISR;             /*!< RTC masked interrupt status register,           Address offset: 0x54 */
  __IO uint32_t SMISR;            /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
  __IO uint32_t SCR;              /*!< RTC status Clear register,                      Address offset: 0x5C */
       uint32_t RESERVED1;        /*!< Reserved,                                       Address offset: 0x60 */
  __IO uint32_t TAMPTSCR;         /*!< RTC timestamp on tamper control register,       Address offset: 0x64 */
  __IO uint32_t TSIDR;            /*!< RTC timestamp status register,                  Address offset: 0x68 */
       uint32_t RESERVED2;        /*!< Reserved,                                       Address offset: 0x6C */
  __IO uint32_t ALRABINR;         /*!< RTC alarm A binary mode register,               Address offset: 0x70 */
  __IO uint32_t ALRBBINR;         /*!< RTC alarm B binary mode register,               Address offset: 0x74 */
} RTC_TypeDef;

/**
  * @brief Serial Audio Interface
  */
typedef struct
{
  uint32_t      RESERVED[17];     /*!< Reserved,                         Address offset: 0x00 to 0x40 */
  __IO uint32_t PDMCR;            /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;           /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;              /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;              /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;             /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;            /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;              /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;               /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;            /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;               /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief Secure digital input/output Interface
  */
typedef struct
{
  __IO uint32_t POWER;            /*!< SDMMC power control register,                Address offset: 0x00 */
  __IO uint32_t CLKCR;            /*!< SDMMC clock control register,                Address offset: 0x04 */
  __IO uint32_t ARG;              /*!< SDMMC argument register,                     Address offset: 0x08 */
  __IO uint32_t CMD;              /*!< SDMMC command register,                      Address offset: 0x0C */
  __I uint32_t  RESPCMD;          /*!< SDMMC command response register,             Address offset: 0x10 */
  __I uint32_t  RESP1;            /*!< SDMMC response 1 register,                   Address offset: 0x14 */
  __I uint32_t  RESP2;            /*!< SDMMC response 2 register,                   Address offset: 0x18 */
  __I uint32_t  RESP3;            /*!< SDMMC response 3 register,                   Address offset: 0x1C */
  __I uint32_t  RESP4;            /*!< SDMMC response 4 register,                   Address offset: 0x20 */
  __IO uint32_t DTIMER;           /*!< SDMMC data timer register,                   Address offset: 0x24 */
  __IO uint32_t DLEN;             /*!< SDMMC data length register,                  Address offset: 0x28 */
  __IO uint32_t DCTRL;            /*!< SDMMC data control register,                 Address offset: 0x2C */
  __I uint32_t  DCOUNT;           /*!< SDMMC data counter register,                 Address offset: 0x30 */
  __I uint32_t  STA;              /*!< SDMMC status register,                       Address offset: 0x34 */
  __IO uint32_t ICR;              /*!< SDMMC interrupt clear register,              Address offset: 0x38 */
  __IO uint32_t MASK;             /*!< SDMMC mask register,                         Address offset: 0x3C */
  __IO uint32_t ACKTIME;          /*!< SDMMC Acknowledgement timer register,        Address offset: 0x40 */
  uint32_t      RESERVED0[3];     /*!< Reserved, 0x44 - 0x4C - 0x4C                                      */
  __IO uint32_t IDMACTRL;         /*!< SDMMC DMA control register,                  Address offset: 0x50 */
  __IO uint32_t IDMABSIZE;        /*!< SDMMC DMA buffer size register,              Address offset: 0x54 */
  __IO uint32_t IDMABASER;        /*!< SDMMC DMA buffer base address register,      Address offset: 0x58 */
  uint32_t      RESERVED1[2];     /*!< Reserved, 0x60                                                    */
  __IO uint32_t IDMALAR;          /*!< SDMMC DMA linked list address register,      Address offset: 0x64 */
  __IO uint32_t IDMABAR;          /*!< SDMMC DMA linked list memory base register,  Address offset: 0x68 */
  uint32_t      RESERVED2[5];     /*!< Reserved, 0x6C-0x7C                                               */
  __IO uint32_t FIFO;             /*!< SDMMC data FIFO register,                    Address offset: 0x80 */
} SDMMC_TypeDef;

/**
  * @brief SPI
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;               /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;              /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;              /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;               /*!< SPI Interrupt Enable register,                   Address offset: 0x10 */
  __IO uint32_t SR;                /*!< SPI Status register,                             Address offset: 0x14 */
  __IO uint32_t IFCR;              /*!< SPI Interrupt/Status Flags Clear register,       Address offset: 0x18 */
  __IO uint32_t AUTOCR;            /*!< SPI Autonomous Mode Control register,            Address offset: 0x1C */
  __IO uint32_t TXDR;              /*!< SPI Transmit data register,                      Address offset: 0x20 */
  uint32_t      RESERVED1[3];      /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;              /*!< SPI/I2S data register,                           Address offset: 0x30 */
  uint32_t      RESERVED2[3];      /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;           /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;             /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;             /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;             /*!< SPI Underrun data register,                      Address offset: 0x4C */
} SPI_TypeDef;

/**
  * @brief System configuration controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;          /*!< SYSCFG secure configuration register,            Address offset: 0x00 */
  __IO uint32_t CFGR1;            /*!< SYSCFG configuration register 1,                 Address offset: 0x04 */
  __IO uint32_t FPUIMR;           /*!< SYSCFG FPU interrupt mask register,              Address offset: 0x08 */
  __IO uint32_t CNSLCKR;          /*!< SYSCFG CPU non-secure lock register,             Address offset: 0x0C */
  __IO uint32_t CSLCKR;           /*!< SYSCFG CPU secure lock register,                 Address offset: 0x10 */
  __IO uint32_t CFGR2;            /*!< SYSCFG configuration register 2,                 Address offset: 0x14 */
       uint32_t RESERVED1;        /*!< RESERVED1,                                       Address offset: 0x28 */
  __IO uint32_t CCCSR;            /*!< SYSCFG Conpensaion Cell Control&Status register, Address offset: 0x1C */
  __IO uint32_t CCVR;             /*!< SYSCFG Conpensaion Cell value register,          Address offset: 0x20 */
  __IO uint32_t CCCR;             /*!< SYSCFG Conpensaion Cell Code register,           Address offset: 0x24 */
       uint32_t RESERVED2;        /*!< RESERVED2,                                       Address offset: 0x28 */
  __IO uint32_t RSSCMDR;          /*!< SYSCFG RSS command mode register,                Address offset: 0x2C */
} SYSCFG_TypeDef;

/**
  * @brief Tamper and backup registers
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< TAMP configuration register 1,                    Address offset: 0x00 */
  __IO uint32_t CR2;              /*!< TAMP configuration register 2,                    Address offset: 0x04 */
  __IO uint32_t CR3;              /*!< TAMP configuration register 3,                    Address offset: 0x08 */
  __IO uint32_t FLTCR;            /*!< TAMP filter control register,                     Address offset: 0x0C */
       uint32_t RESERVED1[4];     /*!< Reserved,                                                 0x10 -- 0x1C */
  __IO uint32_t SECCFGR;          /*!< TAMP secure mode control register,                Address offset: 0x20 */
  __IO uint32_t PRIVCFGR;         /*!< TAMP privilege mode control register,             Address offset: 0x24 */
       uint32_t RESERVED0;        /*!< Reserved,                                         Address offset: 0x28 */
  __IO uint32_t IER;              /*!< TAMP interrupt enable register,                   Address offset: 0x2C */
  __IO uint32_t SR;               /*!< TAMP status register,                             Address offset: 0x30 */
  __IO uint32_t MISR;             /*!< TAMP masked interrupt status register,            Address offset: 0x34 */
  __IO uint32_t SMISR;            /*!< TAMP secure masked interrupt status register,     Address offset: 0x38 */
  __IO uint32_t SCR;              /*!< TAMP status clear register,                       Address offset: 0x3C */
  __IO uint32_t COUNT1R;          /*!< TAMP monotonic counter register,                  Address offset: 0x40 */
       uint32_t RESERVED2[4];     /*!< Reserved,                                                 0x44 -- 0x50 */
  __IO uint32_t RPCFGR;           /*!< TAMP resources protection configuration register, Address offset: 0x54 */
       uint32_t RESERVED3[42];    /*!< Reserved,                                                 0x58 -- 0xFC */
  __IO uint32_t BKP0R;            /*!< TAMP backup register 0,                          Address offset: 0x100 */
  __IO uint32_t BKP1R;            /*!< TAMP backup register 1,                          Address offset: 0x104 */
  __IO uint32_t BKP2R;            /*!< TAMP backup register 2,                          Address offset: 0x108 */
  __IO uint32_t BKP3R;            /*!< TAMP backup register 3,                          Address offset: 0x10C */
  __IO uint32_t BKP4R;            /*!< TAMP backup register 4,                          Address offset: 0x110 */
  __IO uint32_t BKP5R;            /*!< TAMP backup register 5,                          Address offset: 0x114 */
  __IO uint32_t BKP6R;            /*!< TAMP backup register 6,                          Address offset: 0x118 */
  __IO uint32_t BKP7R;            /*!< TAMP backup register 7,                          Address offset: 0x11C */
  __IO uint32_t BKP8R;            /*!< TAMP backup register 8,                          Address offset: 0x120 */
  __IO uint32_t BKP9R;            /*!< TAMP backup register 9,                          Address offset: 0x124 */
  __IO uint32_t BKP10R;           /*!< TAMP backup register 10,                         Address offset: 0x128 */
  __IO uint32_t BKP11R;           /*!< TAMP backup register 11,                         Address offset: 0x12C */
  __IO uint32_t BKP12R;           /*!< TAMP backup register 12,                         Address offset: 0x130 */
  __IO uint32_t BKP13R;           /*!< TAMP backup register 13,                         Address offset: 0x134 */
  __IO uint32_t BKP14R;           /*!< TAMP backup register 14,                         Address offset: 0x138 */
  __IO uint32_t BKP15R;           /*!< TAMP backup register 15,                         Address offset: 0x13C */
  __IO uint32_t BKP16R;           /*!< TAMP backup register 16,                         Address offset: 0x140 */
  __IO uint32_t BKP17R;           /*!< TAMP backup register 17,                         Address offset: 0x144 */
  __IO uint32_t BKP18R;           /*!< TAMP backup register 18,                         Address offset: 0x148 */
  __IO uint32_t BKP19R;           /*!< TAMP backup register 19,                         Address offset: 0x14C */
  __IO uint32_t BKP20R;           /*!< TAMP backup register 20,                         Address offset: 0x150 */
  __IO uint32_t BKP21R;           /*!< TAMP backup register 21,                         Address offset: 0x154 */
  __IO uint32_t BKP22R;           /*!< TAMP backup register 22,                         Address offset: 0x158 */
  __IO uint32_t BKP23R;           /*!< TAMP backup register 23,                         Address offset: 0x15C */
  __IO uint32_t BKP24R;           /*!< TAMP backup register 24,                         Address offset: 0x160 */
  __IO uint32_t BKP25R;           /*!< TAMP backup register 25,                         Address offset: 0x164 */
  __IO uint32_t BKP26R;           /*!< TAMP backup register 26,                         Address offset: 0x168 */
  __IO uint32_t BKP27R;           /*!< TAMP backup register 27,                         Address offset: 0x16C */
  __IO uint32_t BKP28R;           /*!< TAMP backup register 28,                         Address offset: 0x170 */
  __IO uint32_t BKP29R;           /*!< TAMP backup register 29,                         Address offset: 0x174 */
  __IO uint32_t BKP30R;           /*!< TAMP backup register 30,                         Address offset: 0x178 */
  __IO uint32_t BKP31R;           /*!< TAMP backup register 31,                         Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief Touch Sensing Controller (TSC)
  */
typedef struct
{
  __IO uint32_t CR;               /*!< TSC control register,                           Address offset: 0x00 */
  __IO uint32_t IER;              /*!< TSC interrupt enable register,                  Address offset: 0x04 */
  __IO uint32_t ICR;              /*!< TSC interrupt clear register,                   Address offset: 0x08 */
  __IO uint32_t ISR;              /*!< TSC interrupt status register,                  Address offset: 0x0C */
  __IO uint32_t IOHCR;            /*!< TSC I/O hysteresis control register,            Address offset: 0x10 */
  uint32_t      RESERVED1;        /*!< Reserved,                                       Address offset: 0x14 */
  __IO uint32_t IOASCR;           /*!< TSC I/O analog switch control register,         Address offset: 0x18 */
  uint32_t      RESERVED2;        /*!< Reserved,                                       Address offset: 0x1C */
  __IO uint32_t IOSCR;            /*!< TSC I/O sampling control register,              Address offset: 0x20 */
  uint32_t      RESERVED3;        /*!< Reserved,                                       Address offset: 0x24 */
  __IO uint32_t IOCCR;            /*!< TSC I/O channel control register,               Address offset: 0x28 */
  uint32_t      RESERVED4;        /*!< Reserved,                                       Address offset: 0x2C */
  __IO uint32_t IOGCSR;           /*!< TSC I/O group control status register,          Address offset: 0x30 */
  __IO uint32_t IOGXCR[7];        /*!< TSC I/O group x counter register,                          0x34-0x4C */
} TSC_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;              /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;             /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;             /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;               /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;              /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;            /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;            /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;             /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;              /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;              /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;              /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;              /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;             /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;             /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;             /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;             /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;             /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t CCR5;             /*!< TIM capture/compare register 5,           Address offset: 0x48 */
  __IO uint32_t CCR6;             /*!< TIM capture/compare register 6,           Address offset: 0x4C */
  __IO uint32_t CCMR3;            /*!< TIM capture/compare mode register 3,      Address offset: 0x50 */
  __IO uint32_t DTR2;             /*!< TIM deadtime register 2,                  Address offset: 0x54 */
  __IO uint32_t ECR;              /*!< TIM encoder control register,             Address offset: 0x58 */
  __IO uint32_t TISEL;            /*!< TIM Input Selection register,             Address offset: 0x5C */
  __IO uint32_t AF1;              /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;              /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t OR1 ;             /*!< TIM option register,                      Address offset: 0x68 */
       uint32_t RESERVED0[220];     /*!< Reserved,                               Address offset: 0x6C */
  __IO uint32_t DCR;              /*!< TIM DMA control register,                Address offset: 0x3DC */
  __IO uint32_t DMAR;             /*!< TIM DMA address for full transfer,       Address offset: 0x3E0 */
} TIM_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;              /*!< USART Control register 1,                 Address offset: 0x00  */
  __IO uint32_t CR2;              /*!< USART Control register 2,                 Address offset: 0x04  */
  __IO uint32_t CR3;              /*!< USART Control register 3,                 Address offset: 0x08  */
  __IO uint32_t BRR;              /*!< USART Baud rate register,                 Address offset: 0x0C  */
  __IO uint32_t GTPR;             /*!< USART Guard time and prescaler register,  Address offset: 0x10  */
  __IO uint32_t RTOR;             /*!< USART Receiver Time Out register,         Address offset: 0x14  */
  __IO uint32_t RQR;              /*!< USART Request register,                   Address offset: 0x18  */
  __IO uint32_t ISR;              /*!< USART Interrupt and status register,      Address offset: 0x1C  */
  __IO uint32_t ICR;              /*!< USART Interrupt flag Clear register,      Address offset: 0x20  */
  __IO uint32_t RDR;              /*!< USART Receive Data register,              Address offset: 0x24  */
  __IO uint32_t TDR;              /*!< USART Transmit Data register,             Address offset: 0x28  */
  __IO uint32_t PRESC;            /*!< USART Prescaler register,                 Address offset: 0x2C  */
  __IO uint32_t AUTOCR;           /*!< USART Autonomous mode control register    Address offset: 0x30  */
} USART_TypeDef;

/**
  * @brief Universal Serial Bus Full Speed Dual Role Device
  */
typedef struct
{
  __IO uint32_t CHEP0R;          /*!< USB Channel/Endpoint 0 register,      Address offset: 0x00 */
  __IO uint32_t CHEP1R;          /*!< USB Channel/Endpoint 1 register,      Address offset: 0x04 */
  __IO uint32_t CHEP2R;          /*!< USB Channel/Endpoint 2 register,      Address offset: 0x08 */
  __IO uint32_t CHEP3R;          /*!< USB Channel/Endpoint 3 register,      Address offset: 0x0C */
  __IO uint32_t CHEP4R;          /*!< USB Channel/Endpoint 4 register,      Address offset: 0x10 */
  __IO uint32_t CHEP5R;          /*!< USB Channel/Endpoint 5 register,      Address offset: 0x14 */
  __IO uint32_t CHEP6R;          /*!< USB Channel/Endpoint 6 register,      Address offset: 0x18 */
  __IO uint32_t CHEP7R;          /*!< USB Channel/Endpoint 7 register,      Address offset: 0x1C */
  __IO uint32_t RESERVED0[8];    /*!< Reserved,                                                  */
  __IO uint32_t CNTR;            /*!< Control register,                     Address offset: 0x40 */
  __IO uint32_t ISTR;            /*!< Interrupt status register,            Address offset: 0x44 */
  __IO uint32_t FNR;             /*!< Frame number register,                Address offset: 0x48 */
  __IO uint32_t DADDR;           /*!< Device address register,              Address offset: 0x4C */
  __IO uint32_t RESERVED1;       /*!< Reserved */
  __IO uint32_t LPMCSR;          /*!< LPM Control and Status register,      Address offset: 0x54 */
  __IO uint32_t BCDR;            /*!< Battery Charging detector register,   Address offset: 0x58 */
} USB_DRD_TypeDef;

/**
  * @brief Universal Serial Bus PacketMemoryArea Buffer Descriptor Table
  */
typedef struct
{
  __IO uint32_t TXBD;             /*!<Transmission buffer address*/
  __IO uint32_t RXBD;             /*!<Reception buffer address */
} USB_DRD_PMABuffDescTypeDef;

/**
  * @brief VREFBUF
  */
typedef struct
{
  __IO uint32_t CSR;              /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;              /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;

/**
  * @brief WWDG
  */
typedef struct
{
  __IO uint32_t CR;               /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;              /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;               /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;

/**
  * @brief OCTO Serial Peripheral Interface
  */
typedef struct
{
  __IO uint32_t CR;               /*!< XSPI Control register,                            Address offset: 0x000 */
  uint32_t RESERVED;              /*!< Reserved,                                         Address offset: 0x004 */
  __IO uint32_t DCR1;             /*!< XSPI Device Configuration register 1,             Address offset: 0x008 */
  __IO uint32_t DCR2;             /*!< XSPI Device Configuration register 2,             Address offset: 0x00C */
  __IO uint32_t DCR3;             /*!< XSPI Device Configuration register 3,             Address offset: 0x010 */
  __IO uint32_t DCR4;             /*!< XSPI Device Configuration register 4,             Address offset: 0x014 */
  uint32_t RESERVED1[2];          /*!< Reserved,                                         Address offset: 0x018-0x01C */
  __IO uint32_t SR;               /*!< XSPI Status register,                             Address offset: 0x020 */
  __IO uint32_t FCR;              /*!< XSPI Flag Clear register,                         Address offset: 0x024 */
  uint32_t RESERVED2[6];          /*!< Reserved,                                         Address offset: 0x028-0x03C */
  __IO uint32_t DLR;              /*!< XSPI Data Length register,                        Address offset: 0x040 */
  uint32_t RESERVED3;             /*!< Reserved,                                         Address offset: 0x044 */
  __IO uint32_t AR;               /*!< XSPI Address register,                            Address offset: 0x048 */
  uint32_t RESERVED4;             /*!< Reserved,                                         Address offset: 0x04C */
  __IO uint32_t DR;               /*!< XSPI Data register,                               Address offset: 0x050 */
  uint32_t RESERVED5[11];         /*!< Reserved,                                         Address offset: 0x054-0x07C */
  __IO uint32_t PSMKR;            /*!< XSPI Polling Status Mask register,                Address offset: 0x080 */
  uint32_t RESERVED6;             /*!< Reserved,                                         Address offset: 0x084 */
  __IO uint32_t PSMAR;            /*!< XSPI Polling Status Match register,               Address offset: 0x088 */
  uint32_t RESERVED7;             /*!< Reserved,                                         Address offset: 0x08C */
  __IO uint32_t PIR;              /*!< XSPI Polling Interval register,                   Address offset: 0x090 */
  uint32_t RESERVED8[27];         /*!< Reserved,                                         Address offset: 0x094-0x0FC */
  __IO uint32_t CCR;              /*!< XSPI Communication Configuration register,        Address offset: 0x100 */
  uint32_t RESERVED9;             /*!< Reserved,                                         Address offset: 0x104 */
  __IO uint32_t TCR;              /*!< XSPI Timing Configuration register,               Address offset: 0x108 */
  uint32_t RESERVED10;            /*!< Reserved,                                         Address offset: 0x10C */
  __IO uint32_t IR;               /*!< XSPI Instruction register,                        Address offset: 0x110 */
  uint32_t RESERVED11[3];         /*!< Reserved,                                         Address offset: 0x114-0x11C */
  __IO uint32_t ABR;              /*!< XSPI Alternate Bytes register,                    Address offset: 0x120 */
  uint32_t RESERVED12[3];         /*!< Reserved,                                         Address offset: 0x124-0x12C */
  __IO uint32_t LPTR;             /*!< XSPI Low Power Timeout register,                  Address offset: 0x130 */
  uint32_t RESERVED13[3];         /*!< Reserved,                                         Address offset: 0x134-0x13C */
  __IO uint32_t WPCCR;            /*!< XSPI Wrap Communication Configuration register,   Address offset: 0x140 */
  uint32_t RESERVED14;            /*!< Reserved,                                         Address offset: 0x144 */
  __IO uint32_t WPTCR;            /*!< XSPI Wrap Timing Configuration register,          Address offset: 0x148 */
  uint32_t RESERVED15;            /*!< Reserved,                                         Address offset: 0x14C */
  __IO uint32_t WPIR;             /*!< XSPI Wrap Instruction register,                   Address offset: 0x150 */
  uint32_t RESERVED16[3];         /*!< Reserved,                                         Address offset: 0x154-0x15C */
  __IO uint32_t WPABR;            /*!< XSPI Wrap Alternate Bytes register,               Address offset: 0x160 */
  uint32_t RESERVED17[7];         /*!< Reserved,                                         Address offset: 0x164-0x17C */
  __IO uint32_t WCCR;             /*!< XSPI Write Communication Configuration register,  Address offset: 0x180 */
  uint32_t RESERVED18;            /*!< Reserved,                                         Address offset: 0x184 */
  __IO uint32_t WTCR;             /*!< XSPI Write Timing Configuration register,         Address offset: 0x188 */
  uint32_t RESERVED19;            /*!< Reserved,                                         Address offset: 0x18C */
  __IO uint32_t WIR;              /*!< XSPI Write Instruction register,                  Address offset: 0x190 */
  uint32_t RESERVED20[3];         /*!< Reserved,                                         Address offset: 0x194-0x19C */
  __IO uint32_t WABR;             /*!< XSPI Write Alternate Bytes register,              Address offset: 0x1A0 */
  uint32_t RESERVED21[23];        /*!< Reserved,                                         Address offset: 0x1A4-0x1FC */
  __IO uint32_t HLCR;             /*!< XSPI Hyperbus Latency Configuration register,     Address offset: 0x200 */
} XSPI_TypeDef;

typedef  XSPI_TypeDef OCTOSPI_TypeDef;

/**
  * @brief Serial Peripheral Interface IO Manager
  */
typedef struct
{
  __IO uint32_t CR;               /*!< OCTOSPIM IO Manager Control register,                 Address offset: 0x00 */
  __IO uint32_t PCR[8];           /*!< OCTOSPIM IO Manager Port[1:8] Configuration register, Address offset: 0x04-0x20 */
} XSPIM_TypeDef;

typedef  XSPIM_TypeDef OCTOSPIM_TypeDef;

/*@}*/ /* end of group STM32U3xx_peripherals */

/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* ================================================================================================================== */
/* ================                     Device Specific Peripheral Address Map                       ================ */
/* ================================================================================================================== */
/** @addtogroup STM32U3xx_Peripheral_peripheralAddr
  * @{
  */

/*!< Flash, Peripheral and internal SRAMs base addresses - Non secure */
#define FLASH_BASE_NS                   0x08000000UL  /*!< FLASH non-secure base address        */
#define SYSTEM_FLASH_BASE_NS            0x0BF80000UL  /*!< System FLASH non-secure base address */
#define SRAM1_BASE_NS                   0x20000000UL  /*!< SRAM1 non-secure base address        */
#define SRAM2_BASE_NS                   0x20030000UL  /*!< SRAM2 non-secure base address        */
#define SRAM3_BASE_NS                   0x20040000UL  /*!< SRAM3 non-secure base address        */
#define SRAM4_BASE_NS                   0x20090000UL  /*!< SRAM4 non-secure base address        */

#define PERIPH_BASE_NS                  0x40000000UL  /*!< Peripheral non-secure base address   */
#define EXTRAM_BASE_NS                  0x90000000UL  /*!< External RAM base address            */
#define EPPB_BASE                       0xE0040000UL  /*!< External Private Peripheral Bus      */

/*!< OTP, Engineering bytes, Option bytes defines */
#define FLASH_OTP_BASE                  (SYSTEM_FLASH_BASE_NS + 0x00020000UL) /*!< FLASH OTP (one-time programmable) base address */
#define FLASH_OTP_SIZE                  0x00000200U                           /*!< 512 bytes OTP (one-time programmable)          */
#define FLASH_ENGY_BASE                 (SYSTEM_FLASH_BASE_NS + 0x00020500UL)
#define PACKAGE_BASE                    (FLASH_ENGY_BASE)                     /*!< Package data register base address     */
#define UID_BASE                        (FLASH_ENGY_BASE + 0x00000200UL)      /*!< Unique device ID register base address */
#define FLASHSIZE_BASE                  (FLASH_ENGY_BASE + 0x000002A0UL)      /*!< Flash size data register base address  */
#define UID64_BASE                      (FLASH_ENGY_BASE + 0x00000500UL)      /*!< 64-bit Unique device Identification    */

/*!< Memory sizes */
/* Internal Flash size */
#define FLASH_SIZE                      ((((*((uint16_t *)FLASHSIZE_BASE)) == 0xFFFFU)) ? 0x200000U : \
                                         ((((*((uint16_t *)FLASHSIZE_BASE)) == 0x0000U)) ? 0x200000U : \
                                           (((uint32_t)(*((uint16_t *)FLASHSIZE_BASE)) & (0xFFFFU)) << 10U)))

/*!< Internal SRAMs size */
#define SRAM1_SIZE                      0x00030000UL  /*!< SRAM1=192k */
#define SRAM2_SIZE                      0x00010000UL  /*!< SRAM2=64k  */
#define SRAM3_SIZE                      0x00050000UL  /*!< SRAM3=320k */
#define SRAM4_SIZE                      0x00010000UL  /*!< SRAM4=64k  */

/*!< Peripheral memory map - Non secure */
#define APB1PERIPH_BASE_NS              PERIPH_BASE_NS
#define APB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00010000UL)
#define AHB1PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00020000UL)
#define APB3PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00040000UL)
#define AHB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x02020000UL)

/*!< APB1 Non secure peripherals */
#define TIM2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00000000UL)
#define TIM3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00000400UL)
#define TIM4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00000800UL)
#define TIM6_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00001000UL)
#define TIM7_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00001400UL)
#define SPI3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00002000UL)
#define SPI4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00002400UL)
#define WWDG_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00002C00UL)
#define IWDG_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00003000UL)
#define SPI2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00003800UL)
#define USART2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x00004400UL)
#define USART3_BASE_NS                  (APB1PERIPH_BASE_NS + 0x00004800UL)
#define UART4_BASE_NS                   (APB1PERIPH_BASE_NS + 0x00004C00UL)
#define UART5_BASE_NS                   (APB1PERIPH_BASE_NS + 0x00005000UL)
#define I2C1_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00005400UL)
#define I2C2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00005800UL)
#define I3C1_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00005C00UL)
#define CRS_BASE_NS                     (APB1PERIPH_BASE_NS + 0x00006000UL)
#define OPAMP1_BASE_NS                  (APB1PERIPH_BASE_NS + 0x00007000UL)
#define OPAMP2_BASE_NS                  (OPAMP1_BASE_NS + 0x0000010UL)
#define VREFBUF_BASE_NS                 (APB1PERIPH_BASE_NS + 0x00007400UL)
#define RTC_BASE_NS                     (APB1PERIPH_BASE_NS + 0x00007800UL)
#define TAMP_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00007C00UL)
#define I2C4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x00008400UL)
#define LPTIM2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x00009400UL)
#define FDCAN1_BASE_NS                  (APB1PERIPH_BASE_NS + 0x0000A400UL)
#define FDCAN2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x0000A800UL)
#define FDCAN_CONFIG_BASE_NS            (APB1PERIPH_BASE_NS + 0x0000A500UL)
#define SRAMCAN_BASE_NS                 (APB1PERIPH_BASE_NS + 0x0000AC00UL)

/*!< APB2 Non secure peripherals */
#define TIM1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x00002C00UL)
#define SPI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x00003000UL)
#define TIM8_BASE_NS                    (APB2PERIPH_BASE_NS + 0x00003400UL)
#define USART1_BASE_NS                  (APB2PERIPH_BASE_NS + 0x00003800UL)
#define TIM12_BASE_NS                   (APB2PERIPH_BASE_NS + 0x00003C00UL)
#define TIM15_BASE_NS                   (APB2PERIPH_BASE_NS + 0x00004000UL)
#define TIM16_BASE_NS                   (APB2PERIPH_BASE_NS + 0x00004400UL)
#define TIM17_BASE_NS                   (APB2PERIPH_BASE_NS + 0x00004800UL)
#define SAI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x00005400UL)
#define SAI1_Block_A_BASE_NS            (SAI1_BASE_NS + 0x0000004UL)
#define SAI1_Block_B_BASE_NS            (SAI1_BASE_NS + 0x0000024UL)
#define USB_DRD_BASE_NS                 (APB2PERIPH_BASE_NS + 0x00006000UL)
#define USB_DRD_PMAADDR_NS              (APB2PERIPH_BASE_NS + 0x00006400UL)
#define I3C2_BASE_NS                    (APB2PERIPH_BASE_NS + 0x00006C00UL)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_BASE_NS                  (AHB1PERIPH_BASE_NS)
#define GPDMA1_Channel0_BASE_NS         (GPDMA1_BASE_NS + 0x00000050UL)
#define GPDMA1_Channel1_BASE_NS         (GPDMA1_BASE_NS + 0x000000D0UL)
#define GPDMA1_Channel2_BASE_NS         (GPDMA1_BASE_NS + 0x00000150UL)
#define GPDMA1_Channel3_BASE_NS         (GPDMA1_BASE_NS + 0x000001D0UL)
#define GPDMA1_Channel4_BASE_NS         (GPDMA1_BASE_NS + 0x00000250UL)
#define GPDMA1_Channel5_BASE_NS         (GPDMA1_BASE_NS + 0x000002D0UL)
#define GPDMA1_Channel6_BASE_NS         (GPDMA1_BASE_NS + 0x00000350UL)
#define GPDMA1_Channel7_BASE_NS         (GPDMA1_BASE_NS + 0x000003D0UL)
#define GPDMA1_Channel8_BASE_NS         (GPDMA1_BASE_NS + 0x00000450UL)
#define GPDMA1_Channel9_BASE_NS         (GPDMA1_BASE_NS + 0x000004D0UL)
#define GPDMA1_Channel10_BASE_NS        (GPDMA1_BASE_NS + 0x00000550UL)
#define GPDMA1_Channel11_BASE_NS        (GPDMA1_BASE_NS + 0x000005D0UL)
#define FLASH_R_BASE_NS                 (AHB1PERIPH_BASE_NS + 0x00002000UL)
#define CRC_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x00003000UL)
#define TSC_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x00004000UL)
#define RAMCFG_BASE_NS                  (AHB1PERIPH_BASE_NS + 0x00006000UL)
#define RAMCFG_SRAM1_BASE_NS            (RAMCFG_BASE_NS)
#define RAMCFG_SRAM2_BASE_NS            (RAMCFG_BASE_NS + 0x00000040UL)
#define RAMCFG_SRAM3_BASE_NS            (RAMCFG_BASE_NS + 0x00000080UL)
#define HSP1_BASE_NS                    (AHB1PERIPH_BASE_NS + 0x0000C000UL)
#define ICACHE_BASE_NS                  (AHB1PERIPH_BASE_NS + 0x00010400UL)
#define PWR_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x00010800UL)
#define RCC_BASE_NS                     (AHB1PERIPH_BASE_NS + 0x00010C00UL)
#define EXTI_BASE_NS                    (AHB1PERIPH_BASE_NS + 0x00012000UL)
#define GTZC_TZSC1_BASE_NS              (AHB1PERIPH_BASE_NS + 0x00012400UL)
#define GTZC_MPCBB1_BASE_NS             (AHB1PERIPH_BASE_NS + 0x00012C00UL)
#define GTZC_MPCBB2_BASE_NS             (AHB1PERIPH_BASE_NS + 0x00013000UL)
#define GTZC_MPCBB3_BASE_NS             (AHB1PERIPH_BASE_NS + 0x00013400UL)
#define GTZC_MPCBB4_BASE_NS             (AHB1PERIPH_BASE_NS + 0x00013800UL)
#define ADF1_BASE_NS                    (AHB1PERIPH_BASE_NS + 0x00014000UL)
#define ADF1_Filter0_BASE_NS            (ADF1_BASE_NS + 0x00000080UL)

/*!< APB3 Non secure peripherals */
#define SYSCFG_BASE_NS                  (APB3PERIPH_BASE_NS + 0x00000400UL)
#define LPUART1_BASE_NS                 (APB3PERIPH_BASE_NS + 0x00002400UL)
#define I2C3_BASE_NS                    (APB3PERIPH_BASE_NS + 0x00002800UL)
#define LPTIM1_BASE_NS                  (APB3PERIPH_BASE_NS + 0x00004400UL)
#define LPTIM3_BASE_NS                  (APB3PERIPH_BASE_NS + 0x00004800UL)
#define LPTIM4_BASE_NS                  (APB3PERIPH_BASE_NS + 0x00004C00UL)
#define COMP1_BASE_NS                   (APB3PERIPH_BASE_NS + 0x00005400UL)
#define COMP2_BASE_NS                   (COMP1_BASE_NS + 0x00000004UL)

/*!< AHB2 Non secure peripherals */
#define GPIOA_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00000000UL)
#define GPIOB_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00000400UL)
#define GPIOC_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00000800UL)
#define GPIOD_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00000C00UL)
#define GPIOE_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00001000UL)
#define GPIOF_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00001400UL)
#define GPIOG_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00001800UL)
#define GPIOH_BASE_NS                   (AHB2PERIPH_BASE_NS + 0x00001C00UL)
#define ADC1_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x00008000UL)
#define ADC2_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x00008100UL)
#define ADC12_COMMON_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00008300UL)
#define DAC1_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x00008400UL)
#define HASH_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x000A0400UL)
#define HASH_DIGEST_BASE_NS             (AHB2PERIPH_BASE_NS + 0x000A0710UL)
#define RNG_BASE_NS                     (AHB2PERIPH_BASE_NS + 0x000A0800UL)
#define SDMMC1_BASE_NS                  (AHB2PERIPH_BASE_NS + 0x000A8000UL)
#define DLYB_SDMMC1_BASE_NS             (AHB2PERIPH_BASE_NS + 0x000A8400UL)
#define DLYB_OCTOSPI1_BASE_NS           (AHB2PERIPH_BASE_NS + 0x000AF000UL)
#define OCTOSPI1_R_BASE_NS              (AHB2PERIPH_BASE_NS + 0x000B1400UL)

#if defined(CPU_IN_SECURE_STATE)
/*!< Flash, Peripheral and internal SRAMs base addresses - secure */
#define FLASH_BASE_S                    0x0C000000UL  /*!< FLASH secure base address        */
#define SYSTEM_FLASH_BASE_S             0x0FF80000UL  /*!< System FLASH secure base address */
#define SRAM1_BASE_S                    0x30000000UL  /*!< SRAM1 secure base address        */
#define SRAM2_BASE_S                    0x30030000UL  /*!< SRAM2 secure base address        */
#define SRAM3_BASE_S                    0x30040000UL  /*!< SRAM3 secure base address        */
#define SRAM4_BASE_S                    0x30090000UL  /*!< SRAM4 secure base address        */
#define PERIPH_BASE_S                   0x50000000UL  /*!< Peripheral secure base address   */

/*!< Peripheral memory map - secure */
#define APB1PERIPH_BASE_S               PERIPH_BASE_S
#define APB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x00010000UL)
#define AHB1PERIPH_BASE_S               (PERIPH_BASE_S + 0x00020000UL)
#define APB3PERIPH_BASE_S               (PERIPH_BASE_S + 0x00040000UL)
#define AHB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x02020000UL)

/*!< APB1 secure peripherals */
#define TIM2_BASE_S                     (APB1PERIPH_BASE_S + 0x00000000UL)
#define TIM3_BASE_S                     (APB1PERIPH_BASE_S + 0x00000400UL)
#define TIM4_BASE_S                     (APB1PERIPH_BASE_S + 0x00000800UL)
#define TIM6_BASE_S                     (APB1PERIPH_BASE_S + 0x00001000UL)
#define TIM7_BASE_S                     (APB1PERIPH_BASE_S + 0x00001400UL)
#define SPI3_BASE_S                     (APB1PERIPH_BASE_S + 0x00002000UL)
#define SPI4_BASE_S                     (APB1PERIPH_BASE_S + 0x00002400UL)
#define WWDG_BASE_S                     (APB1PERIPH_BASE_S + 0x00002C00UL)
#define IWDG_BASE_S                     (APB1PERIPH_BASE_S + 0x00003000UL)
#define SPI2_BASE_S                     (APB1PERIPH_BASE_S + 0x00003800UL)
#define USART2_BASE_S                   (APB1PERIPH_BASE_S + 0x00004400UL)
#define USART3_BASE_S                   (APB1PERIPH_BASE_S + 0x00004800UL)
#define UART4_BASE_S                    (APB1PERIPH_BASE_S + 0x00004C00UL)
#define UART5_BASE_S                    (APB1PERIPH_BASE_S + 0x00005000UL)
#define I2C1_BASE_S                     (APB1PERIPH_BASE_S + 0x00005400UL)
#define I2C2_BASE_S                     (APB1PERIPH_BASE_S + 0x00005800UL)
#define I3C1_BASE_S                     (APB1PERIPH_BASE_S + 0x00005C00UL)
#define CRS_BASE_S                      (APB1PERIPH_BASE_S + 0x00006000UL)
#define OPAMP1_BASE_S                   (APB1PERIPH_BASE_S + 0x00007000UL)
#define OPAMP2_BASE_S                   (OPAMP1_BASE_S + 0x0000010UL)
#define VREFBUF_BASE_S                  (APB1PERIPH_BASE_S + 0x00007400UL)
#define RTC_BASE_S                      (APB1PERIPH_BASE_S + 0x00007800UL)
#define TAMP_BASE_S                     (APB1PERIPH_BASE_S + 0x00007C00UL)
#define I2C4_BASE_S                     (APB1PERIPH_BASE_S + 0x00008400UL)
#define LPTIM2_BASE_S                   (APB1PERIPH_BASE_S + 0x00009400UL)
#define FDCAN1_BASE_S                   (APB1PERIPH_BASE_S + 0x0000A400UL)
#define FDCAN2_BASE_S                   (APB1PERIPH_BASE_S + 0x0000A800UL)
#define FDCAN_CONFIG_BASE_S             (APB1PERIPH_BASE_S + 0x0000A500UL)
#define SRAMCAN_BASE_S                  (APB1PERIPH_BASE_S + 0x0000AC00UL)

/*!< APB2 secure peripherals */
#define TIM1_BASE_S                     (APB2PERIPH_BASE_S + 0x00002C00UL)
#define SPI1_BASE_S                     (APB2PERIPH_BASE_S + 0x00003000UL)
#define TIM8_BASE_S                     (APB2PERIPH_BASE_S + 0x00003400UL)
#define USART1_BASE_S                   (APB2PERIPH_BASE_S + 0x00003800UL)
#define TIM12_BASE_S                    (APB2PERIPH_BASE_S + 0x00003C00UL)
#define TIM15_BASE_S                    (APB2PERIPH_BASE_S + 0x00004000UL)
#define TIM16_BASE_S                    (APB2PERIPH_BASE_S + 0x00004400UL)
#define TIM17_BASE_S                    (APB2PERIPH_BASE_S + 0x00004800UL)
#define SAI1_BASE_S                     (APB2PERIPH_BASE_S + 0x00005400UL)
#define SAI1_Block_A_BASE_S             (SAI1_BASE_S + 0x0000004UL)
#define SAI1_Block_B_BASE_S             (SAI1_BASE_S + 0x0000024UL)
#define USB_DRD_BASE_S                  (APB2PERIPH_BASE_S + 0x00006000UL)
#define USB_DRD_PMAADDR_S               (APB2PERIPH_BASE_S + 0x00006400UL)
#define I3C2_BASE_S                     (APB2PERIPH_BASE_S + 0x00006C00UL)

/*!< AHB1 secure peripherals */
#define GPDMA1_BASE_S                   (AHB1PERIPH_BASE_S)
#define GPDMA1_Channel0_BASE_S          (GPDMA1_BASE_S + 0x00000050UL)
#define GPDMA1_Channel1_BASE_S          (GPDMA1_BASE_S + 0x000000D0UL)
#define GPDMA1_Channel2_BASE_S          (GPDMA1_BASE_S + 0x00000150UL)
#define GPDMA1_Channel3_BASE_S          (GPDMA1_BASE_S + 0x000001D0UL)
#define GPDMA1_Channel4_BASE_S          (GPDMA1_BASE_S + 0x00000250UL)
#define GPDMA1_Channel5_BASE_S          (GPDMA1_BASE_S + 0x000002D0UL)
#define GPDMA1_Channel6_BASE_S          (GPDMA1_BASE_S + 0x00000350UL)
#define GPDMA1_Channel7_BASE_S          (GPDMA1_BASE_S + 0x000003D0UL)
#define GPDMA1_Channel8_BASE_S          (GPDMA1_BASE_S + 0x00000450UL)
#define GPDMA1_Channel9_BASE_S          (GPDMA1_BASE_S + 0x000004D0UL)
#define GPDMA1_Channel10_BASE_S         (GPDMA1_BASE_S + 0x00000550UL)
#define GPDMA1_Channel11_BASE_S         (GPDMA1_BASE_S + 0x000005D0UL)
#define FLASH_R_BASE_S                  (AHB1PERIPH_BASE_S + 0x00002000UL)
#define CRC_BASE_S                      (AHB1PERIPH_BASE_S + 0x00003000UL)
#define TSC_BASE_S                      (AHB1PERIPH_BASE_S + 0x00004000UL)
#define RAMCFG_BASE_S                   (AHB1PERIPH_BASE_S + 0x00006000UL)
#define RAMCFG_SRAM1_BASE_S             (RAMCFG_BASE_S)
#define RAMCFG_SRAM2_BASE_S             (RAMCFG_BASE_S + 0x00000040UL)
#define RAMCFG_SRAM3_BASE_S             (RAMCFG_BASE_S + 0x00000080UL)
#define HSP1_BASE_S                     (AHB1PERIPH_BASE_S + 0x0000C000UL)
#define ICACHE_BASE_S                   (AHB1PERIPH_BASE_S + 0x00010400UL)
#define PWR_BASE_S                      (AHB1PERIPH_BASE_S + 0x00010800UL)
#define RCC_BASE_S                      (AHB1PERIPH_BASE_S + 0x00010C00UL)
#define EXTI_BASE_S                     (AHB1PERIPH_BASE_S + 0x00012000UL)
#define GTZC_TZSC1_BASE_S               (AHB1PERIPH_BASE_S + 0x00012400UL)
#define GTZC_TZIC1_BASE_S               (AHB1PERIPH_BASE_S + 0x00012800UL)
#define GTZC_MPCBB1_BASE_S              (AHB1PERIPH_BASE_S + 0x00012C00UL)
#define GTZC_MPCBB2_BASE_S              (AHB1PERIPH_BASE_S + 0x00013000UL)
#define GTZC_MPCBB3_BASE_S              (AHB1PERIPH_BASE_S + 0x00013400UL)
#define GTZC_MPCBB4_BASE_S              (AHB1PERIPH_BASE_S + 0x00013800UL)
#define ADF1_BASE_S                     (AHB1PERIPH_BASE_S + 0x00014000UL)
#define ADF1_Filter0_BASE_S             (ADF1_BASE_S + 0x00000080UL)

/*!< APB3 secure peripherals */
#define SYSCFG_BASE_S                   (APB3PERIPH_BASE_S + 0x00000400UL)
#define LPUART1_BASE_S                  (APB3PERIPH_BASE_S + 0x00002400UL)
#define I2C3_BASE_S                     (APB3PERIPH_BASE_S + 0x00002800UL)
#define LPTIM1_BASE_S                   (APB3PERIPH_BASE_S + 0x00004400UL)
#define LPTIM3_BASE_S                   (APB3PERIPH_BASE_S + 0x00004800UL)
#define LPTIM4_BASE_S                   (APB3PERIPH_BASE_S + 0x00004C00UL)
#define COMP1_BASE_S                    (APB3PERIPH_BASE_S + 0x00005400UL)
#define COMP2_BASE_S                    (COMP1_BASE_S + 0x00000004UL)

/*!< AHB2 secure peripherals */
#define GPIOA_BASE_S                    (AHB2PERIPH_BASE_S + 0x00000000UL)
#define GPIOB_BASE_S                    (AHB2PERIPH_BASE_S + 0x00000400UL)
#define GPIOC_BASE_S                    (AHB2PERIPH_BASE_S + 0x00000800UL)
#define GPIOD_BASE_S                    (AHB2PERIPH_BASE_S + 0x00000C00UL)
#define GPIOE_BASE_S                    (AHB2PERIPH_BASE_S + 0x00001000UL)
#define GPIOF_BASE_S                    (AHB2PERIPH_BASE_S + 0x00001400UL)
#define GPIOG_BASE_S                    (AHB2PERIPH_BASE_S + 0x00001800UL)
#define GPIOH_BASE_S                    (AHB2PERIPH_BASE_S + 0x00001C00UL)
#define ADC1_BASE_S                     (AHB2PERIPH_BASE_S + 0x00008000UL)
#define ADC2_BASE_S                     (AHB2PERIPH_BASE_S + 0x00008100UL)
#define ADC12_COMMON_BASE_S             (AHB2PERIPH_BASE_S + 0x00008300UL)
#define DAC1_BASE_S                     (AHB2PERIPH_BASE_S + 0x00008400UL)
#define HASH_BASE_S                     (AHB2PERIPH_BASE_S + 0x000A0400UL)
#define HASH_DIGEST_BASE_S              (AHB2PERIPH_BASE_S + 0x000A0710UL)
#define RNG_BASE_S                      (AHB2PERIPH_BASE_S + 0x000A0800UL)
#define SDMMC1_BASE_S                   (AHB2PERIPH_BASE_S + 0x000A8000UL)
#define DLYB_SDMMC1_BASE_S              (AHB2PERIPH_BASE_S + 0x000A8400UL)
#define DLYB_OCTOSPI1_BASE_S            (AHB2PERIPH_BASE_S + 0x000AF000UL)
#define OCTOSPI1_R_BASE_S               (AHB2PERIPH_BASE_S + 0x000B1400UL)
#endif /* CPU_IN_SECURE_STATE */

/*!< External memories base addresses - Not aliased */
#define OCTOSPI1_BASE                   EXTRAM_BASE_NS

/*!< DBGMCU base addresses - Not aliased */
#define DBGMCU_BASE                     (EPPB_BASE + 0x00004000UL)

/*!< USB PMA SIZE */
#define USB_DRD_PMA_SIZE        (2048U)         /*!< USB PMA Size 2Kbyte */

#if defined (CPU_IN_SECURE_STATE)
/*!< Root Secure Service Library */
/************ RSSLIB SAU system Flash region definition constants *************/
#define RSSLIB_SYS_FLASH_NS_PFUNC_START 0x0BF99040UL
#define RSSLIB_SYS_FLASH_NS_PFUNC_END   0x0BF990FFUL

/************ RSSLIB function return constants ********************************/
#define RSSLIB_ERROR                    0xF5F5F5F5UL
#define RSSLIB_SUCCESS                  0xEAEAEAEAUL

/*!< RSSLIB  pointer function structure address definition */
#define RSSLIB_PFUNC_BASE               RSSLIB_SYS_FLASH_NS_PFUNC_START
#define RSSLIB_PFUNC                    ((RSSLIB_pFunc_TypeDef *)RSSLIB_PFUNC_BASE)

/*!< HDP Area constant definition */
#define RSSLIB_HDP_AREA_Pos             0U
#define RSSLIB_HDP_AREA_Msk             (0x3UL << RSSLIB_HDP_AREA_Pos )
#define RSSLIB_HDP_AREA1_Pos            0U
#define RSSLIB_HDP_AREA1_Msk            (0x1UL << RSSLIB_HDP_AREA1_Pos )
#define RSSLIB_HDP_AREA2_Pos            1U
#define RSSLIB_HDP_AREA2_Msk            (0x1UL << RSSLIB_HDP_AREA2_Pos )
#define RSSLIB_HDPEXT_CLOSE_BOUNDARY_OPEN 0xC9C9C9C9UL  /* Access to HDPx extension area and HDPx area denied but HDPx_EXT (in FLASH_HDPEXTR) increment allowed at any time */
#define RSSLIB_HDPEXT_CLOSE_BOUNDARY_LOCK 0xD6D6D6D6UL  /* Access to HDPx extension area and HDPx area denied. Update of HDPx_EXT size is not possible anymore */

/**
  * @brief  Prototype of RSSLIB Close and exit HDP Function
  * @detail This function close the requested hdp area passed in input
  *         parameter and jump to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  HdpArea notifies which hdp area to close, can be a combination of
  *         hdpa area 1 and hdp area 2
  * @param  VectorTableAddr pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t ( *RSSLIB_S_CloseExitHDP_TypeDef)( uint32_t HdpArea, uint32_t VectorTableAddr );

/**
  * @brief  Prototype of RSSLIB Close and exit HDP extension Function
  * @detail This function close the requested hdp extension area passed in input
  *         parameter and jump to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  HdpExtArea notifies which hdp extension area to close, can be a combination of
  *         hdp extension area 1 and hdp extension area 2
  * @param  VectorTableAddr pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @param  CloseBound notifies if the HDP extension area should be closed with
  *         HDPx_EXT increment allowed or not
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t ( *RSSLIB_S_CloseExitHDPExt_TypeDef)( uint32_t HdpExtArea, uint32_t VectorTableAddr, uint32_t CloseBound );


/**
  * @brief RSSLib non-secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved[8];
}NSC_pFuncTypeDef;

/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved2[2];
  __IM RSSLIB_S_CloseExitHDP_TypeDef CloseExitHDP;        /*!< RSSLIB Bootloader Close and exit HDP           Address offset: 0x28 */
  __IM RSSLIB_S_CloseExitHDPExt_TypeDef CloseExitHDPExt;  /*!< RSSLIB Bootloader Close and exit HDP extension Address offset: 0x2C */
}S_pFuncTypeDef;

/**
  * @brief RSSLib function pointer structure
  */
typedef struct
{
  NSC_pFuncTypeDef NSC;
  S_pFuncTypeDef S;
}RSSLIB_pFunc_TypeDef;
#endif /* CPU_IN_SECURE_STATE */

/*
 * Certificate address description
 */
#define CERT_CHIP_PACK1_ADDR (0x0BF9FE00U)
#define CERT_CHIP_PACK1_SIZE (0x200U)
#define CERT_CHIP_PACK2_ADDR (0x0BF9FC00U)
#define CERT_CHIP_PACK2_SIZE (0x200U)

#define CERT_CHIP_PACK_ADDR (CERT_CHIP_PACK2_ADDR)
#define CERT_CHIP_PACK_SIZE (CERT_CHIP_PACK1_SIZE + CERT_CHIP_PACK2_SIZE)

#define CERT_ST_DUA_USER_FU_PUB_KEY_OFFSET  (12U)
#define CERT_ST_DUA_USER_FU_PUB_KEY_ADDR    (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_FU_PUB_KEY_OFFSET)
#define CERT_ST_DUA_USER_FU_SIGN_OFFSET     (76U)
#define CERT_ST_DUA_USER_FU_SIGN_ADDR       (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_FU_SIGN_OFFSET)
#define CERT_ST_DUA_USER_FU_SERIAL_OFFSET   (140U)
#define CERT_ST_DUA_USER_FU_SERIAL_ADDR     (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_FU_SERIAL_OFFSET)

#define CERT_ST_DUA_USER_LU_PUB_KEY_OFFSET  (162U)
#define CERT_ST_DUA_USER_LU_PUB_KEY_ADDR    (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_LU_PUB_KEY_OFFSET)
#define CERT_ST_DUA_USER_LU_SIGN_OFFSET     (226U)
#define CERT_ST_DUA_USER_LU_SIGN_ADDR       (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_LU_SIGN_OFFSET)
#define CERT_ST_DUA_USER_LU_SERIAL_OFFSET   (290U)
#define CERT_ST_DUA_USER_LU_SERIAL_ADDR     (CERT_CHIP_PACK2_ADDR + CERT_ST_DUA_USER_LU_SERIAL_OFFSET)
/** @} */ /* End of group STM32U3xx_Peripheral_peripheralAddr */


/* ================================================================================================================== */
/* ================                     Peripheral declaration                                       ================ */
/* ================================================================================================================== */
/** @addtogroup STM32U3xx_Peripheral_declaration
  * @{
  */
#define ADC12_COMMON_NS                 ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_NS)
#define ADC1_NS                         ((ADC_TypeDef *) ADC1_BASE_NS)
#define ADC2_NS                         ((ADC_TypeDef *) ADC2_BASE_NS)
#define ADF1_NS                         ((MDF_TypeDef *) ADF1_BASE_NS)
#define ADF1_Filter0_NS                 ((MDF_Filter_TypeDef*) ADF1_Filter0_BASE_NS)
#define COMP1_NS                        ((COMP_TypeDef *) COMP1_BASE_NS)
#define COMP2_NS                        ((COMP_TypeDef *) COMP2_BASE_NS)
#define COMP12_COMMON_NS                ((COMP_Common_TypeDef *) COMP1_BASE_NS)
#define CRC_NS                          ((CRC_TypeDef *) CRC_BASE_NS)
#define CRS_NS                          ((CRS_TypeDef *) CRS_BASE_NS)
#define DAC1_NS                         ((DAC_TypeDef *) DAC1_BASE_NS)
#define DLYB_SDMMC1_NS                  ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_NS)
#define DLYB_OCTOSPI1_NS                ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_NS)
#define EXTI_NS                         ((EXTI_TypeDef *) EXTI_BASE_NS)
#define FDCAN1_NS                       ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_NS)
#define FDCAN2_NS                       ((FDCAN_GlobalTypeDef *) FDCAN2_BASE_NS)
#define FDCAN_CONFIG_NS                 ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_NS)
#define FLASH_NS                        ((FLASH_TypeDef *) FLASH_R_BASE_NS)
#define GPDMA1_NS                       ((DMA_TypeDef *) GPDMA1_BASE_NS)
#define GPDMA1_Channel0_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_NS)
#define GPDMA1_Channel1_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_NS)
#define GPDMA1_Channel2_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_NS)
#define GPDMA1_Channel3_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_NS)
#define GPDMA1_Channel4_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_NS)
#define GPDMA1_Channel5_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_NS)
#define GPDMA1_Channel6_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_NS)
#define GPDMA1_Channel7_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_NS)
#define GPDMA1_Channel8_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_NS)
#define GPDMA1_Channel9_NS              ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_NS)
#define GPDMA1_Channel10_NS             ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_NS)
#define GPDMA1_Channel11_NS             ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_NS)
#define GPIOA_NS                        ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS                        ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS                        ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS                        ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS                        ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOF_NS                        ((GPIO_TypeDef *) GPIOF_BASE_NS)
#define GPIOG_NS                        ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS                        ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define GTZC_MPCBB1_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_NS)
#define GTZC_MPCBB2_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_NS)
#define GTZC_MPCBB3_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_NS)
#define GTZC_MPCBB4_NS                  ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB4_BASE_NS)
#define GTZC_TZSC1_NS                   ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_NS)
#define HASH_NS                         ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS                  ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define I2C1_NS                         ((I2C_TypeDef *) I2C1_BASE_NS)
#define I2C2_NS                         ((I2C_TypeDef *) I2C2_BASE_NS)
#define I2C3_NS                         ((I2C_TypeDef *) I2C3_BASE_NS)
#define I2C4_NS                         ((I2C_TypeDef *) I2C4_BASE_NS)
#define I3C1_NS                         ((I3C_TypeDef *) I3C1_BASE_NS)
#define I3C2_NS                         ((I3C_TypeDef *) I3C2_BASE_NS)
#define HSP1_NS                         ((HSP_TypeDef *) HSP1_BASE_NS)
#define ICACHE_NS                       ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define IWDG_NS                         ((IWDG_TypeDef *) IWDG_BASE_NS)
#define LPTIM1_NS                       ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPTIM2_NS                       ((LPTIM_TypeDef *) LPTIM2_BASE_NS)
#define LPTIM3_NS                       ((LPTIM_TypeDef *) LPTIM3_BASE_NS)
#define LPTIM4_NS                       ((LPTIM_TypeDef *) LPTIM4_BASE_NS)
#define LPUART1_NS                      ((USART_TypeDef *) LPUART1_BASE_NS)
#define OCTOSPI1_NS                     ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_NS)
#define OPAMP1_NS                       ((OPAMP_TypeDef *) OPAMP1_BASE_NS)
#define OPAMP2_NS                       ((OPAMP_TypeDef *) OPAMP2_BASE_NS)
#define OPAMP12_COMMON_NS               ((OPAMP_Common_TypeDef *) OPAMP1_BASE_NS)
#define PWR_NS                          ((PWR_TypeDef *) PWR_BASE_NS)
#define RAMCFG_SRAM1_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_NS)
#define RAMCFG_SRAM2_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_NS)
#define RAMCFG_SRAM3_NS                 ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_NS)
#define RCC_NS                          ((RCC_TypeDef *) RCC_BASE_NS)
#define RNG_NS                          ((RNG_TypeDef *) RNG_BASE_NS)
#define RTC_NS                          ((RTC_TypeDef *) RTC_BASE_NS)
#define SAI1_NS                         ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS                 ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS                 ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_NS)
#define SDMMC1_NS                       ((SDMMC_TypeDef *) SDMMC1_BASE_NS)
#define SPI1_NS                         ((SPI_TypeDef *) SPI1_BASE_NS)
#define SPI2_NS                         ((SPI_TypeDef *) SPI2_BASE_NS)
#define SPI3_NS                         ((SPI_TypeDef *) SPI3_BASE_NS)
#define SPI4_NS                         ((SPI_TypeDef *) SPI4_BASE_NS)
#define SYSCFG_NS                       ((SYSCFG_TypeDef *) SYSCFG_BASE_NS)
#define TAMP_NS                         ((TAMP_TypeDef *) TAMP_BASE_NS)
#define TIM1_NS                         ((TIM_TypeDef *) TIM1_BASE_NS)
#define TIM2_NS                         ((TIM_TypeDef *) TIM2_BASE_NS)
#define TIM3_NS                         ((TIM_TypeDef *) TIM3_BASE_NS)
#define TIM4_NS                         ((TIM_TypeDef *) TIM4_BASE_NS)
#define TIM6_NS                         ((TIM_TypeDef *) TIM6_BASE_NS)
#define TIM7_NS                         ((TIM_TypeDef *) TIM7_BASE_NS)
#define TIM12_NS                        ((TIM_TypeDef *) TIM12_BASE_NS)
#define TIM15_NS                        ((TIM_TypeDef *) TIM15_BASE_NS)
#define TIM16_NS                        ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS                        ((TIM_TypeDef *) TIM17_BASE_NS)
#define TSC_NS                          ((TSC_TypeDef *) TSC_BASE_NS)
#define UART4_NS                        ((USART_TypeDef *) UART4_BASE_NS)
#define UART5_NS                        ((USART_TypeDef *) UART5_BASE_NS)
#define TIM8_NS                         ((TIM_TypeDef *) TIM8_BASE_NS)
#define USART1_NS                       ((USART_TypeDef *) USART1_BASE_NS)
#define USART2_NS                       ((USART_TypeDef *) USART2_BASE_NS)
#define USART3_NS                       ((USART_TypeDef *) USART3_BASE_NS)
#define USB_DRD_FS_NS                   ((USB_DRD_TypeDef *) USB_DRD_BASE_NS)
#define USB_DRD_PMA_BUFF_NS             ((USB_DRD_PMABuffDescTypeDef *) USB_DRD_PMAADDR_NS)
#define VREFBUF_NS                      ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define WWDG_NS                         ((WWDG_TypeDef *) WWDG_BASE_NS)

/*!< DBGMCU peripheral */
#define DBGMCU                          ((DBGMCU_TypeDef *) DBGMCU_BASE)

#if defined (CPU_IN_SECURE_STATE)
#define ADC12_COMMON_S                  ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_S)
#define ADC1_S                          ((ADC_TypeDef *) ADC1_BASE_S)
#define ADC2_S                          ((ADC_TypeDef *) ADC2_BASE_S)
#define ADF1_S                          ((MDF_TypeDef *) ADF1_BASE_S)
#define ADF1_Filter0_S                  ((MDF_Filter_TypeDef*) ADF1_Filter0_BASE_S)
#define COMP1_S                         ((COMP_TypeDef *) COMP1_BASE_S)
#define COMP2_S                         ((COMP_TypeDef *) COMP2_BASE_S)
#define COMP12_COMMON_S                 ((COMP_Common_TypeDef *) COMP1_BASE_S)
#define CRC_S                           ((CRC_TypeDef *) CRC_BASE_S)
#define CRS_S                           ((CRS_TypeDef *) CRS_BASE_S)
#define DAC1_S                          ((DAC_TypeDef *) DAC1_BASE_S)
#define DLYB_SDMMC1_S                   ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_S)
#define DLYB_OCTOSPI1_S                 ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_S)
#define EXTI_S                          ((EXTI_TypeDef *) EXTI_BASE_S)
#define FDCAN1_S                        ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_S)
#define FDCAN2_S                        ((FDCAN_GlobalTypeDef *) FDCAN2_BASE_S)
#define FDCAN_CONFIG_S                  ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_S)
#define FLASH_S                         ((FLASH_TypeDef *) FLASH_R_BASE_S)
#define GPDMA1_S                        ((DMA_TypeDef *) GPDMA1_BASE_S)
#define GPDMA1_Channel0_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_S)
#define GPDMA1_Channel1_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_S)
#define GPDMA1_Channel2_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_S)
#define GPDMA1_Channel3_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_S)
#define GPDMA1_Channel4_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_S)
#define GPDMA1_Channel5_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_S)
#define GPDMA1_Channel6_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_S)
#define GPDMA1_Channel7_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_S)
#define GPDMA1_Channel8_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_S)
#define GPDMA1_Channel9_S               ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_S)
#define GPDMA1_Channel10_S              ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_S)
#define GPDMA1_Channel11_S              ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_S)
#define GPIOA_S                         ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S                         ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S                         ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S                         ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S                         ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOF_S                         ((GPIO_TypeDef *) GPIOF_BASE_S)
#define GPIOG_S                         ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S                         ((GPIO_TypeDef *) GPIOH_BASE_S)
#define GTZC_TZSC1_S                    ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_S)
#define GTZC_TZIC1_S                    ((GTZC_TZIC_TypeDef *) GTZC_TZIC1_BASE_S)
#define GTZC_MPCBB1_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_S)
#define GTZC_MPCBB2_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_S)
#define GTZC_MPCBB3_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_S)
#define GTZC_MPCBB4_S                   ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB4_BASE_S)
#define HASH_S                          ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S                   ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define I2C1_S                          ((I2C_TypeDef *) I2C1_BASE_S)
#define I2C2_S                          ((I2C_TypeDef *) I2C2_BASE_S)
#define I2C3_S                          ((I2C_TypeDef *) I2C3_BASE_S)
#define I2C4_S                          ((I2C_TypeDef *) I2C4_BASE_S)
#define I3C1_S                          ((I3C_TypeDef *) I3C1_BASE_S)
#define I3C2_S                          ((I3C_TypeDef *) I3C2_BASE_S)
#define HSP1_S                          ((HSP_TypeDef *) HSP1_BASE_S)
#define ICACHE_S                        ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define IWDG_S                          ((IWDG_TypeDef *) IWDG_BASE_S)
#define LPTIM1_S                        ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPTIM2_S                        ((LPTIM_TypeDef *) LPTIM2_BASE_S)
#define LPTIM3_S                        ((LPTIM_TypeDef *) LPTIM3_BASE_S)
#define LPTIM4_S                        ((LPTIM_TypeDef *) LPTIM4_BASE_S)
#define LPUART1_S                       ((USART_TypeDef *) LPUART1_BASE_S)
#define OCTOSPI1_S                      ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_S)
#define OPAMP1_S                        ((OPAMP_TypeDef *) OPAMP1_BASE_S)
#define OPAMP2_S                        ((OPAMP_TypeDef *) OPAMP2_BASE_S)
#define OPAMP12_COMMON_S                ((OPAMP_Common_TypeDef *) OPAMP1_BASE_S)
#define PWR_S                           ((PWR_TypeDef *) PWR_BASE_S)
#define RAMCFG_SRAM1_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_S)
#define RAMCFG_SRAM2_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_S)
#define RAMCFG_SRAM3_S                  ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_S)
#define RCC_S                           ((RCC_TypeDef *) RCC_BASE_S)
#define RNG_S                           ((RNG_TypeDef *) RNG_BASE_S)
#define RTC_S                           ((RTC_TypeDef *) RTC_BASE_S)
#define SAI1_S                          ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S                  ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S                  ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_S)
#define SDMMC1_S                        ((SDMMC_TypeDef *) SDMMC1_BASE_S)
#define SPI1_S                          ((SPI_TypeDef *) SPI1_BASE_S)
#define SPI2_S                          ((SPI_TypeDef *) SPI2_BASE_S)
#define SPI3_S                          ((SPI_TypeDef *) SPI3_BASE_S)
#define SPI4_S                          ((SPI_TypeDef *) SPI4_BASE_S)
#define SYSCFG_S                        ((SYSCFG_TypeDef *) SYSCFG_BASE_S)
#define TAMP_S                          ((TAMP_TypeDef *) TAMP_BASE_S)
#define TIM1_S                          ((TIM_TypeDef *) TIM1_BASE_S)
#define TIM2_S                          ((TIM_TypeDef *) TIM2_BASE_S)
#define TIM3_S                          ((TIM_TypeDef *) TIM3_BASE_S)
#define TIM4_S                          ((TIM_TypeDef *) TIM4_BASE_S)
#define TIM6_S                          ((TIM_TypeDef *) TIM6_BASE_S)
#define TIM7_S                          ((TIM_TypeDef *) TIM7_BASE_S)
#define TIM12_S                         ((TIM_TypeDef *) TIM12_BASE_S)
#define TIM15_S                         ((TIM_TypeDef *) TIM15_BASE_S)
#define TIM16_S                         ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S                         ((TIM_TypeDef *) TIM17_BASE_S)
#define TSC_S                           ((TSC_TypeDef *) TSC_BASE_S)
#define UART4_S                         ((USART_TypeDef *) UART4_BASE_S)
#define UART5_S                         ((USART_TypeDef *) UART5_BASE_S)
#define TIM8_S                          ((TIM_TypeDef *) TIM18_BASE_S)
#define USART1_S                        ((USART_TypeDef *) USART1_BASE_S)
#define USART2_S                        ((USART_TypeDef *) USART2_BASE_S)
#define USART3_S                        ((USART_TypeDef *) USART3_BASE_S)
#define USB_DRD_FS_S                    ((USB_DRD_TypeDef *) USB_DRD_BASE_S)
#define USB_DRD_PMA_BUFF_S              ((USB_DRD_PMABuffDescTypeDef *) USB_DRD_PMAADDR_S)
#define VREFBUF_S                       ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define WWDG_S                          ((WWDG_TypeDef *) WWDG_BASE_S)

/*!< Memory & Instance aliases and base addresses for Non-Secure/Secure peripherals */
/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                      FLASH_BASE_S
#define SRAM1_BASE                      SRAM1_BASE_S
#define SRAM2_BASE                      SRAM2_BASE_S
#define SRAM3_BASE                      SRAM3_BASE_S
#define SRAM4_BASE                      SRAM4_BASE_S

/*!< Instance aliases and base addresses for Secure peripherals */
#define ADC12_COMMON                    ADC12_COMMON_S
#define ADC12_COMMON_BASE               ADC12_COMMON_BASE_S
#define ADC1                            ADC1_S
#define ADC1_BASE                       ADC1_BASE_S
#define ADC2                            ADC2_S
#define ADC2_BASE                       ADC2_BASE_S
#define ADF1                            ADF1_S
#define ADF1_BASE                       ADF1_BASE_S
#define ADF1_Filter0                    ADF1_Filter0_S
#define ADF1_Filter0_BASE               ADF1_Filter0_BASE_S
#define COMP1                           COMP1_S
#define COMP1_BASE                      COMP1_BASE_S
#define COMP2                           COMP2_S
#define COMP2_BASE                      COMP2_BASE_S
#define COMP12_COMMON                   COMP12_COMMON_S
#define COMP12_COMMON_BASE              COMP12_BASE_S
#define CRC                             CRC_S
#define CRC_BASE                        CRC_BASE_S
#define CRS                             CRS_S
#define CRS_BASE                        CRS_BASE_S
#define DAC1                            DAC1_S
#define DAC1_BASE                       DAC1_BASE_S
#define DLYB_SDMMC1                     DLYB_SDMMC1_S
#define DLYB_SDMMC1_BASE                DLYB_SDMMC1_BASE_S
#define DLYB_OCTOSPI1                   DLYB_OCTOSPI1_S
#define DLYB_OCTOSPI1_BASE              DLYB_OCTOSPI1_BASE_S
#define EXTI                            EXTI_S
#define EXTI_BASE                       EXTI_BASE_S
#define FDCAN1                          FDCAN1_S
#define FDCAN1_BASE                     FDCAN1_BASE_S
#define FDCAN2                          FDCAN2_S
#define FDCAN2_BASE                     FDCAN2_BASE_S
#define FDCAN_CONFIG                    FDCAN_CONFIG_S
#define FDCAN_CONFIG_BASE               FDCAN_CONFIG_BASE_S
#define FLASH                           FLASH_S
#define FLASH_R_BASE                    FLASH_R_BASE_S
#define GPDMA1                          GPDMA1_S
#define GPDMA1_BASE                     GPDMA1_BASE_S
#define GPDMA1_Channel0                 GPDMA1_Channel0_S
#define GPDMA1_Channel0_BASE            GPDMA1_Channel0_BASE_S
#define GPDMA1_Channel1                 GPDMA1_Channel1_S
#define GPDMA1_Channel1_BASE            GPDMA1_Channel1_BASE_S
#define GPDMA1_Channel2                 GPDMA1_Channel2_S
#define GPDMA1_Channel2_BASE            GPDMA1_Channel2_BASE_S
#define GPDMA1_Channel3                 GPDMA1_Channel3_S
#define GPDMA1_Channel3_BASE            GPDMA1_Channel3_BASE_S
#define GPDMA1_Channel4                 GPDMA1_Channel4_S
#define GPDMA1_Channel4_BASE            GPDMA1_Channel4_BASE_S
#define GPDMA1_Channel5                 GPDMA1_Channel5_S
#define GPDMA1_Channel5_BASE            GPDMA1_Channel5_BASE_S
#define GPDMA1_Channel6                 GPDMA1_Channel6_S
#define GPDMA1_Channel6_BASE            GPDMA1_Channel6_BASE_S
#define GPDMA1_Channel7                 GPDMA1_Channel7_S
#define GPDMA1_Channel7_BASE            GPDMA1_Channel7_BASE_S
#define GPDMA1_Channel8                 GPDMA1_Channel8_S
#define GPDMA1_Channel8_BASE            GPDMA1_Channel8_BASE_S
#define GPDMA1_Channel9                 GPDMA1_Channel9_S
#define GPDMA1_Channel9_BASE            GPDMA1_Channel9_BASE_S
#define GPDMA1_Channel10                GPDMA1_Channel10_S
#define GPDMA1_Channel10_BASE           GPDMA1_Channel10_BASE_S
#define GPDMA1_Channel11                GPDMA1_Channel11_S
#define GPDMA1_Channel11_BASE           GPDMA1_Channel11_BASE_S
#define GPIOA                           GPIOA_S
#define GPIOA_BASE                      GPIOA_BASE_S
#define GPIOB                           GPIOB_S
#define GPIOB_BASE                      GPIOB_BASE_S
#define GPIOC                           GPIOC_S
#define GPIOC_BASE                      GPIOC_BASE_S
#define GPIOD                           GPIOD_S
#define GPIOD_BASE                      GPIOD_BASE_S
#define GPIOE                           GPIOE_S
#define GPIOE_BASE                      GPIOE_BASE_S
#define GPIOF                           GPIOF_S
#define GPIOF_BASE                      GPIOF_BASE_S
#define GPIOG                           GPIOG_S
#define GPIOG_BASE                      GPIOG_BASE_S
#define GPIOH                           GPIOH_S
#define GPIOH_BASE                      GPIOH_BASE_S
#define GTZC_MPCBB1                     GTZC_MPCBB1_S
#define GTZC_MPCBB1_BASE                GTZC_MPCBB1_BASE_S
#define GTZC_MPCBB2                     GTZC_MPCBB2_S
#define GTZC_MPCBB2_BASE                GTZC_MPCBB2_BASE_S
#define GTZC_MPCBB3                     GTZC_MPCBB3_S
#define GTZC_MPCBB3_BASE                GTZC_MPCBB3_BASE_S
#define GTZC_MPCBB4                     GTZC_MPCBB4_S
#define GTZC_MPCBB4_BASE                GTZC_MPCBB4_BASE_S
#define GTZC_TZSC1                      GTZC_TZSC1_S
#define GTZC_TZSC1_BASE                 GTZC_TZSC1_BASE_S
#define GTZC_TZIC1                      GTZC_TZIC1_S
#define GTZC_TZIC1_BASE                 GTZC_TZIC1_BASE_S
#define HASH                            HASH_S
#define HASH_BASE                       HASH_BASE_S
#define HASH_DIGEST                     HASH_DIGEST_S
#define HASH_DIGEST_BASE                HASH_DIGEST_BASE_S
#define I2C1                            I2C1_S
#define I2C1_BASE                       I2C1_BASE_S
#define I2C2                            I2C2_S
#define I2C2_BASE                       I2C2_BASE_S
#define I2C3                            I2C3_S
#define I2C3_BASE                       I2C3_BASE_S
#define I2C4                            I2C4_S
#define I2C4_BASE                       I2C4_BASE_S
#define I3C1                            I3C1_S
#define I3C1_BASE                       I3C1_BASE_S
#define I3C2                            I3C2_S
#define I3C2_BASE                       I3C2_BASE_S
#define HSP1                            HSP1_S
#define HSP1_BASE                       HSP1_BASE_S
#define ICACHE                          ICACHE_S
#define ICACHE_BASE                     ICACHE_BASE_S
#define IWDG                            IWDG_S
#define IWDG_BASE                       IWDG_BASE_S
#define LPTIM1                          LPTIM1_S
#define LPTIM1_BASE                     LPTIM1_BASE_S
#define LPTIM2                          LPTIM2_S
#define LPTIM2_BASE                     LPTIM2_BASE_S
#define LPTIM3                          LPTIM3_S
#define LPTIM3_BASE                     LPTIM3_BASE_S
#define LPTIM4                          LPTIM4_S
#define LPTIM4_BASE                     LPTIM4_BASE_S
#define LPUART1                         LPUART1_S
#define LPUART1_BASE                    LPUART1_BASE_S
#define OCTOSPI1                        OCTOSPI1_S
#define OCTOSPI1_R_BASE                 OCTOSPI1_R_BASE_S
#define OPAMP1                          OPAMP1_S
#define OPAMP1_BASE                     OPAMP1_BASE_S
#define OPAMP2                          OPAMP2_S
#define OPAMP2_BASE                     OPAMP2_BASE_S
#define OPAMP12_COMMON                  OPAMP12_COMMON_S
#define OPAMP12_COMMON_BASE             OPAMP12_COMMON_BASE_S
#define PWR                             PWR_S
#define PWR_BASE                        PWR_BASE_S
#define RAMCFG_SRAM1                    RAMCFG_SRAM1_S
#define RAMCFG_SRAM1_BASE               RAMCFG_SRAM1_BASE_S
#define RAMCFG_SRAM2                    RAMCFG_SRAM2_S
#define RAMCFG_SRAM2_BASE               RAMCFG_SRAM2_BASE_S
#define RAMCFG_SRAM3                    RAMCFG_SRAM3_S
#define RAMCFG_SRAM3_BASE               RAMCFG_SRAM3_BASE_S
#define RCC                             RCC_S
#define RCC_BASE                        RCC_BASE_S
#define RNG                             RNG_S
#define RNG_BASE                        RNG_BASE_S
#define RTC                             RTC_S
#define RTC_BASE                        RTC_BASE_S
#define SAI1                            SAI1_S
#define SAI1_BASE                       SAI1_BASE_S
#define SAI1_Block_A                    SAI1_Block_A_S
#define SAI1_Block_A_BASE               SAI1_Block_A_BASE_S
#define SAI1_Block_B                    SAI1_Block_B_S
#define SAI1_Block_B_BASE               SAI1_Block_B_BASE_S
#define SDMMC1                          SDMMC1_S
#define SDMMC1_BASE                     SDMMC1_BASE_S
#define SPI1                            SPI1_S
#define SPI1_BASE                       SPI1_BASE_S
#define SPI2                            SPI2_S
#define SPI2_BASE                       SPI2_BASE_S
#define SPI3                            SPI3_S
#define SPI3_BASE                       SPI3_BASE_S
#define SPI4                            SPI4_S
#define SPI4_BASE                       SPI4_BASE_S
#define SRAMCAN_BASE                    SRAMCAN_BASE_S
#define SYSCFG                          SYSCFG_S
#define SYSCFG_BASE                     SYSCFG_BASE_S
#define TAMP                            TAMP_S
#define TAMP_BASE                       TAMP_BASE_S
#define TIM1                            TIM1_S
#define TIM1_BASE                       TIM1_BASE_S
#define TIM2                            TIM2_S
#define TIM2_BASE                       TIM2_BASE_S
#define TIM3                            TIM3_S
#define TIM3_BASE                       TIM3_BASE_S
#define TIM4                            TIM4_S
#define TIM4_BASE                       TIM4_BASE_S
#define TIM6                            TIM6_S
#define TIM6_BASE                       TIM6_BASE_S
#define TIM7                            TIM7_S
#define TIM7_BASE                       TIM7_BASE_S
#define TIM12                           TIM12_S
#define TIM12_BASE                      TIM12_BASE_S
#define TIM15                           TIM15_S
#define TIM15_BASE                      TIM15_BASE_S
#define TIM16                           TIM16_S
#define TIM16_BASE                      TIM16_BASE_S
#define TIM17                           TIM17_S
#define TIM17_BASE                      TIM17_BASE_S
#define TSC                             TSC_S
#define TSC_BASE                        TSC_BASE_S
#define UART4                           UART4_S
#define UART4_BASE                      UART4_BASE_S
#define UART5                           UART5_S
#define UART5_BASE                      UART5_BASE_S
#define TIM8                            TIM8_S
#define TIM8_BASE                       TIM8_BASE_S
#define USART1                          USART1_S
#define USART1_BASE                     USART1_BASE_S
#define USART2                          USART2_S
#define USART2_BASE                     USART2_BASE_S
#define USART3                          USART3_S
#define USART3_BASE                     USART3_BASE_S
#define USB_DRD_FS                      USB_DRD_FS_S
#define USB_DRD_BASE                    USB_DRD_BASE_S
#define USB_DRD_PMAADDR                 USB_DRD_PMAADDR_S
#define USB_DRD_PMA_BUFF                USB_DRD_PMA_BUFF_S
#define VREFBUF                         VREFBUF_S
#define VREFBUF_BASE                    VREFBUF_BASE_S
#define WWDG                            WWDG_S
#define WWDG_BASE                       WWDG_BASE_S

#else /* CPU_IN_SECURE_STATE */
/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                      FLASH_BASE_NS
#define SRAM1_BASE                      SRAM1_BASE_NS
#define SRAM2_BASE                      SRAM2_BASE_NS
#define SRAM3_BASE                      SRAM3_BASE_NS
#define SRAM4_BASE                      SRAM4_BASE_NS

/*!< Instance aliases and base addresses for Secure peripherals */
#define ADC12_COMMON                    ADC12_COMMON_NS
#define ADC12_COMMON_BASE               ADC12_COMMON_BASE_NS
#define ADC1                            ADC1_NS
#define ADC1_BASE                       ADC1_BASE_NS
#define ADC2                            ADC2_NS
#define ADC2_BASE                       ADC2_BASE_NS
#define ADF1                            ADF1_NS
#define ADF1_BASE                       ADF1_BASE_NS
#define ADF1_Filter0                    ADF1_Filter0_NS
#define ADF1_Filter0_BASE               ADF1_Filter0_BASE_NS
#define COMP1                           COMP1_NS
#define COMP1_BASE                      COMP1_BASE_NS
#define COMP2                           COMP2_NS
#define COMP2_BASE                      COMP2_BASE_NS
#define COMP12_COMMON                   COMP12_COMMON_NS
#define COMP12_COMMON_BASE              COMP12_BASE_NS
#define CRC                             CRC_NS
#define CRC_BASE                        CRC_BASE_NS
#define CRS                             CRS_NS
#define CRS_BASE                        CRS_BASE_NS
#define DAC1                            DAC1_NS
#define DAC1_BASE                       DAC1_BASE_NS
#define DLYB_SDMMC1                     DLYB_SDMMC1_NS
#define DLYB_SDMMC1_BASE                DLYB_SDMMC1_BASE_NS
#define DLYB_OCTOSPI1                   DLYB_OCTOSPI1_NS
#define DLYB_OCTOSPI1_BASE              DLYB_OCTOSPI1_BASE_NS
#define EXTI                            EXTI_NS
#define EXTI_BASE                       EXTI_BASE_NS
#define FDCAN1                          FDCAN1_NS
#define FDCAN1_BASE                     FDCAN1_BASE_NS
#define FDCAN2                          FDCAN2_NS
#define FDCAN2_BASE                     FDCAN2_BASE_NS
#define FDCAN_CONFIG                    FDCAN_CONFIG_NS
#define FDCAN_CONFIG_BASE               FDCAN_CONFIG_BASE_NS
#define FLASH                           FLASH_NS
#define FLASH_R_BASE                    FLASH_R_BASE_NS
#define GPDMA1                          GPDMA1_NS
#define GPDMA1_BASE                     GPDMA1_BASE_NS
#define GPDMA1_Channel0                 GPDMA1_Channel0_NS
#define GPDMA1_Channel0_BASE            GPDMA1_Channel0_BASE_NS
#define GPDMA1_Channel1                 GPDMA1_Channel1_NS
#define GPDMA1_Channel1_BASE            GPDMA1_Channel1_BASE_NS
#define GPDMA1_Channel2                 GPDMA1_Channel2_NS
#define GPDMA1_Channel2_BASE            GPDMA1_Channel2_BASE_NS
#define GPDMA1_Channel3                 GPDMA1_Channel3_NS
#define GPDMA1_Channel3_BASE            GPDMA1_Channel3_BASE_NS
#define GPDMA1_Channel4                 GPDMA1_Channel4_NS
#define GPDMA1_Channel4_BASE            GPDMA1_Channel4_BASE_NS
#define GPDMA1_Channel5                 GPDMA1_Channel5_NS
#define GPDMA1_Channel5_BASE            GPDMA1_Channel5_BASE_NS
#define GPDMA1_Channel6                 GPDMA1_Channel6_NS
#define GPDMA1_Channel6_BASE            GPDMA1_Channel6_BASE_NS
#define GPDMA1_Channel7                 GPDMA1_Channel7_NS
#define GPDMA1_Channel7_BASE            GPDMA1_Channel7_BASE_NS
#define GPDMA1_Channel8                 GPDMA1_Channel8_NS
#define GPDMA1_Channel8_BASE            GPDMA1_Channel8_BASE_NS
#define GPDMA1_Channel9                 GPDMA1_Channel9_NS
#define GPDMA1_Channel9_BASE            GPDMA1_Channel9_BASE_NS
#define GPDMA1_Channel10                GPDMA1_Channel10_NS
#define GPDMA1_Channel10_BASE           GPDMA1_Channel10_BASE_NS
#define GPDMA1_Channel11                GPDMA1_Channel11_NS
#define GPDMA1_Channel11_BASE           GPDMA1_Channel11_BASE_NS
#define GPIOA                           GPIOA_NS
#define GPIOA_BASE                      GPIOA_BASE_NS
#define GPIOB                           GPIOB_NS
#define GPIOB_BASE                      GPIOB_BASE_NS
#define GPIOC                           GPIOC_NS
#define GPIOC_BASE                      GPIOC_BASE_NS
#define GPIOD                           GPIOD_NS
#define GPIOD_BASE                      GPIOD_BASE_NS
#define GPIOE                           GPIOE_NS
#define GPIOE_BASE                      GPIOE_BASE_NS
#define GPIOF                           GPIOF_NS
#define GPIOF_BASE                      GPIOF_BASE_NS
#define GPIOG                           GPIOG_NS
#define GPIOG_BASE                      GPIOG_BASE_NS
#define GPIOH                           GPIOH_NS
#define GPIOH_BASE                      GPIOH_BASE_NS
#define GTZC_MPCBB1                     GTZC_MPCBB1_NS
#define GTZC_MPCBB1_BASE                GTZC_MPCBB1_BASE_NS
#define GTZC_MPCBB2                     GTZC_MPCBB2_NS
#define GTZC_MPCBB2_BASE                GTZC_MPCBB2_BASE_NS
#define GTZC_MPCBB3                     GTZC_MPCBB3_NS
#define GTZC_MPCBB3_BASE                GTZC_MPCBB3_BASE_NS
#define GTZC_MPCBB4                     GTZC_MPCBB4_NS
#define GTZC_MPCBB4_BASE                GTZC_MPCBB4_BASE_NS
#define GTZC_TZSC1                      GTZC_TZSC1_NS
#define GTZC_TZSC1_BASE                 GTZC_TZSC1_BASE_NS
#define HASH                            HASH_NS
#define HASH_BASE                       HASH_BASE_NS
#define HASH_DIGEST                     HASH_DIGEST_NS
#define HASH_DIGEST_BASE                HASH_DIGEST_BASE_NS
#define I2C1                            I2C1_NS
#define I2C1_BASE                       I2C1_BASE_NS
#define I2C2                            I2C2_NS
#define I2C2_BASE                       I2C2_BASE_NS
#define I2C3                            I2C3_NS
#define I2C3_BASE                       I2C3_BASE_NS
#define I2C4                            I2C4_NS
#define I2C4_BASE                       I2C4_BASE_NS
#define I3C1                            I3C1_NS
#define I3C1_BASE                       I3C1_BASE_NS
#define I3C2                            I3C2_NS
#define I3C2_BASE                       I3C2_BASE_NS
#define HSP1                            HSP1_NS
#define HSP1_BASE                       HSP1_BASE_NS
#define ICACHE                          ICACHE_NS
#define ICACHE_BASE                     ICACHE_BASE_NS
#define IWDG                            IWDG_NS
#define IWDG_BASE                       IWDG_BASE_NS
#define LPTIM1                          LPTIM1_NS
#define LPTIM1_BASE                     LPTIM1_BASE_NS
#define LPTIM2                          LPTIM2_NS
#define LPTIM2_BASE                     LPTIM2_BASE_NS
#define LPTIM3                          LPTIM3_NS
#define LPTIM3_BASE                     LPTIM3_BASE_NS
#define LPTIM4                          LPTIM4_NS
#define LPTIM4_BASE                     LPTIM4_BASE_NS
#define LPUART1                         LPUART1_NS
#define LPUART1_BASE                    LPUART1_BASE_NS
#define OCTOSPI1                        OCTOSPI1_NS
#define OCTOSPI1_R_BASE                 OCTOSPI1_R_BASE_NS
#define OPAMP1                          OPAMP1_NS
#define OPAMP1_BASE                     OPAMP1_BASE_NS
#define OPAMP2                          OPAMP2_NS
#define OPAMP2_BASE                     OPAMP2_BASE_NS
#define OPAMP12_COMMON                  OPAMP12_COMMON_NS
#define OPAMP12_COMMON_BASE             OPAMP12_COMMON_BASE_NS
#define PWR                             PWR_NS
#define PWR_BASE                        PWR_BASE_NS
#define RAMCFG_SRAM1                    RAMCFG_SRAM1_NS
#define RAMCFG_SRAM1_BASE               RAMCFG_SRAM1_BASE_NS
#define RAMCFG_SRAM2                    RAMCFG_SRAM2_NS
#define RAMCFG_SRAM2_BASE               RAMCFG_SRAM2_BASE_NS
#define RAMCFG_SRAM3                    RAMCFG_SRAM3_NS
#define RAMCFG_SRAM3_BASE               RAMCFG_SRAM3_BASE_NS
#define RCC                             RCC_NS
#define RCC_BASE                        RCC_BASE_NS
#define RNG                             RNG_NS
#define RNG_BASE                        RNG_BASE_NS
#define RTC                             RTC_NS
#define RTC_BASE                        RTC_BASE_NS
#define SAI1                            SAI1_NS
#define SAI1_BASE                       SAI1_BASE_NS
#define SAI1_Block_A                    SAI1_Block_A_NS
#define SAI1_Block_A_BASE               SAI1_Block_A_BASE_NS
#define SAI1_Block_B                    SAI1_Block_B_NS
#define SAI1_Block_B_BASE               SAI1_Block_B_BASE_NS
#define SDMMC1                          SDMMC1_NS
#define SDMMC1_BASE                     SDMMC1_BASE_NS
#define SPI1                            SPI1_NS
#define SPI1_BASE                       SPI1_BASE_NS
#define SPI2                            SPI2_NS
#define SPI2_BASE                       SPI2_BASE_NS
#define SPI3                            SPI3_NS
#define SPI3_BASE                       SPI3_BASE_NS
#define SPI4                            SPI4_NS
#define SPI4_BASE                       SPI4_BASE_NS
#define SRAMCAN_BASE                    SRAMCAN_BASE_NS
#define SYSCFG                          SYSCFG_NS
#define SYSCFG_BASE                     SYSCFG_BASE_NS
#define TAMP                            TAMP_NS
#define TAMP_BASE                       TAMP_BASE_NS
#define TIM1                            TIM1_NS
#define TIM1_BASE                       TIM1_BASE_NS
#define TIM2                            TIM2_NS
#define TIM2_BASE                       TIM2_BASE_NS
#define TIM3                            TIM3_NS
#define TIM3_BASE                       TIM3_BASE_NS
#define TIM4                            TIM4_NS
#define TIM4_BASE                       TIM4_BASE_NS
#define TIM6                            TIM6_NS
#define TIM6_BASE                       TIM6_BASE_NS
#define TIM7                            TIM7_NS
#define TIM7_BASE                       TIM7_BASE_NS
#define TIM12                           TIM12_NS
#define TIM12_BASE                      TIM12_BASE_NS
#define TIM15                           TIM15_NS
#define TIM15_BASE                      TIM15_BASE_NS
#define TIM16                           TIM16_NS
#define TIM16_BASE                      TIM16_BASE_NS
#define TIM17                           TIM17_NS
#define TIM17_BASE                      TIM17_BASE_NS
#define TSC                             TSC_NS
#define TSC_BASE                        TSC_BASE_NS
#define UART4                           UART4_NS
#define UART4_BASE                      UART4_BASE_NS
#define UART5                           UART5_NS
#define UART5_BASE                      UART5_BASE_NS
#define TIM8                            TIM8_NS
#define TIM8_BASE                       TIM8_BASE_NS
#define USART1                          USART1_NS
#define USART1_BASE                     USART1_BASE_NS
#define USART2                          USART2_NS
#define USART2_BASE                     USART2_BASE_NS
#define USART3                          USART3_NS
#define USART3_BASE                     USART3_BASE_NS
#define USB_DRD_FS                      USB_DRD_FS_NS
#define USB_DRD_BASE                    USB_DRD_BASE_NS
#define USB_DRD_PMAADDR                 USB_DRD_PMAADDR_NS
#define USB_DRD_PMA_BUFF                USB_DRD_PMA_BUFF_NS
#define VREFBUF                         VREFBUF_NS
#define VREFBUF_BASE                    VREFBUF_BASE_NS
#define WWDG                            WWDG_NS
#define WWDG_BASE                       WWDG_BASE_NS
#endif /* CPU_IN_SECURE_STATE */

/** @addtogroup Exported_constants
  * @{
  */

/** @addtogroup Hardware_Constant_Definition
  * @{
  */
#define LSI_STARTUP_TIME                16000U /*!< LSI Maximum startup time in us : 4 cycles @ 250 Hz = 16 ms */
/**
  * @}
  */

/** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter (ADC)                   */
/*                                                                            */
/******************************************************************************/

/* Specific device feature definitions */
#define ADC_MULTIMODE_SUPPORT         /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  *******************/
#define ADC_ISR_ADRDY_Pos                   (0U)
#define ADC_ISR_ADRDY_Msk                   (0x1UL << ADC_ISR_ADRDY_Pos)            /*!< 0x00000001 */
#define ADC_ISR_ADRDY                       ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos                   (1U)
#define ADC_ISR_EOSMP_Msk                   (0x1UL << ADC_ISR_EOSMP_Pos)            /*!< 0x00000002 */
#define ADC_ISR_EOSMP                       ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                     (2U)
#define ADC_ISR_EOC_Msk                     (0x1UL << ADC_ISR_EOC_Pos)              /*!< 0x00000004 */
#define ADC_ISR_EOC                         ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                     (3U)
#define ADC_ISR_EOS_Msk                     (0x1UL << ADC_ISR_EOS_Pos)              /*!< 0x00000008 */
#define ADC_ISR_EOS                         ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                     (4U)
#define ADC_ISR_OVR_Msk                     (0x1UL << ADC_ISR_OVR_Pos)              /*!< 0x00000010 */
#define ADC_ISR_OVR                         ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_JEOC_Pos                    (5U)
#define ADC_ISR_JEOC_Msk                    (0x1UL << ADC_ISR_JEOC_Pos)             /*!< 0x00000020 */
#define ADC_ISR_JEOC                        ADC_ISR_JEOC_Msk                        /*!< ADC group injected end of unitary conversion flag */
#define ADC_ISR_JEOS_Pos                    (6U)
#define ADC_ISR_JEOS_Msk                    (0x1UL << ADC_ISR_JEOS_Pos)             /*!< 0x00000040 */
#define ADC_ISR_JEOS                        ADC_ISR_JEOS_Msk                        /*!< ADC group injected end of sequence conversions flag */
#define ADC_ISR_AWD1_Pos                    (7U)
#define ADC_ISR_AWD1_Msk                    (0x1UL << ADC_ISR_AWD1_Pos)             /*!< 0x00000080 */
#define ADC_ISR_AWD1                        ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos                    (8U)
#define ADC_ISR_AWD2_Msk                    (0x1UL << ADC_ISR_AWD2_Pos)             /*!< 0x00000100 */
#define ADC_ISR_AWD2                        ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos                    (9U)
#define ADC_ISR_AWD3_Msk                    (0x1UL << ADC_ISR_AWD3_Pos)             /*!< 0x00000200 */
#define ADC_ISR_AWD3                        ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos                   (10U)
#define ADC_ISR_JQOVF_Msk                   (0x1UL << ADC_ISR_JQOVF_Pos)            /*!< 0x00000400 */
#define ADC_ISR_JQOVF                       ADC_ISR_JQOVF_Msk                       /*!< ADC group injected contexts queue overflow flag */
#define ADC_ISR_LDORDY_Pos                  (12U)
#define ADC_ISR_LDORDY_Msk                  (0x1UL << ADC_ISR_LDORDY_Pos)           /*!< 0x00001000 */
#define ADC_ISR_LDORDY                      ADC_ISR_LDORDY_Msk                      /*!< ADC internal voltage regulator output ready flag */

/********************  Bit definition for ADC_IER register  *******************/
#define ADC_IER_ADRDYIE_Pos                 (0U)
#define ADC_IER_ADRDYIE_Msk                 (0x1UL << ADC_IER_ADRDYIE_Pos)          /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                     ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos                 (1U)
#define ADC_IER_EOSMPIE_Msk                 (0x1UL << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                     ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos                   (2U)
#define ADC_IER_EOCIE_Msk                   (0x1UL << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                       ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos                   (3U)
#define ADC_IER_EOSIE_Msk                   (0x1UL << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                       ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos                   (4U)
#define ADC_IER_OVRIE_Msk                   (0x1UL << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                       ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_JEOCIE_Pos                  (5U)
#define ADC_IER_JEOCIE_Msk                  (0x1UL << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                      ADC_IER_JEOCIE_Msk                      /*!< ADC group injected end of unitary conversion interrupt */
#define ADC_IER_JEOSIE_Pos                  (6U)
#define ADC_IER_JEOSIE_Msk                  (0x1UL << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                      ADC_IER_JEOSIE_Msk                      /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_IER_AWD1IE_Pos                  (7U)
#define ADC_IER_AWD1IE_Msk                  (0x1UL << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                      ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos                  (8U)
#define ADC_IER_AWD2IE_Msk                  (0x1UL << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                      ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos                  (9U)
#define ADC_IER_AWD3IE_Msk                  (0x1UL << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                      ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */
#define ADC_IER_JQOVFIE_Pos                 (10U)
#define ADC_IER_JQOVFIE_Msk                 (0x1UL << ADC_IER_JQOVFIE_Pos)          /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                     ADC_IER_JQOVFIE_Msk                     /*!< ADC group injected contexts queue overflow interrupt */
#define ADC_IER_LDORDYIE_Pos                (12U)
#define ADC_IER_LDORDYIE_Msk                (0x1UL << ADC_IER_LDORDYIE_Pos)         /*!< 0x00001000 */
#define ADC_IER_LDORDYIE                    ADC_IER_LDORDYIE_Msk                    /*!< ADC internal voltage regulator interrupt*/

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                     (0U)
#define ADC_CR_ADEN_Msk                     (0x1UL << ADC_CR_ADEN_Pos)              /*!< 0x00000001 */
#define ADC_CR_ADEN                         ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos                    (1U)
#define ADC_CR_ADDIS_Msk                    (0x1UL << ADC_CR_ADDIS_Pos)             /*!< 0x00000002 */
#define ADC_CR_ADDIS                        ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos                  (2U)
#define ADC_CR_ADSTART_Msk                  (0x1UL << ADC_CR_ADSTART_Pos)           /*!< 0x00000004 */
#define ADC_CR_ADSTART                      ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_JADSTART_Pos                 (3U)
#define ADC_CR_JADSTART_Msk                 (0x1UL << ADC_CR_JADSTART_Pos)          /*!< 0x00000008 */
#define ADC_CR_JADSTART                     ADC_CR_JADSTART_Msk                     /*!< ADC group injected conversion start */
#define ADC_CR_ADSTP_Pos                    (4U)
#define ADC_CR_ADSTP_Msk                    (0x1UL << ADC_CR_ADSTP_Pos)             /*!< 0x00000010 */
#define ADC_CR_ADSTP                        ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_JADSTP_Pos                   (5U)
#define ADC_CR_JADSTP_Msk                   (0x1UL << ADC_CR_JADSTP_Pos)            /*!< 0x00000020 */
#define ADC_CR_JADSTP                       ADC_CR_JADSTP_Msk                       /*!< ADC group injected conversion stop */
#define ADC_CR_ADVREGEN_Pos                 (28U)
#define ADC_CR_ADVREGEN_Msk                 (0x1UL << ADC_CR_ADVREGEN_Pos)          /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                     ADC_CR_ADVREGEN_Msk                     /*!< ADC internal voltage regulator */
#define ADC_CR_DEEPPWD_Pos                  (29U)
#define ADC_CR_DEEPPWD_Msk                  (0x1UL << ADC_CR_DEEPPWD_Pos)           /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                      ADC_CR_DEEPPWD_Msk                      /*!< ADC deep power down enable */
#define ADC_CR_ADCAL_Pos                    (31U)
#define ADC_CR_ADCAL_Msk                    (0x1UL << ADC_CR_ADCAL_Pos)             /*!< 0x80000000 */
#define ADC_CR_ADCAL                        ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR1 register  ******************/
#define ADC_CFGR1_DMNGT_Pos                 (0U)
#define ADC_CFGR1_DMNGT_Msk                 (0x3UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000003 */
#define ADC_CFGR1_DMNGT                     ADC_CFGR1_DMNGT_Msk                     /*!< ADC data management configuration */
#define ADC_CFGR1_DMNGT_0                   (0x1UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000001 */
#define ADC_CFGR1_DMNGT_1                   (0x2UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000002 */

#define ADC_CFGR1_RES_Pos                   (2U)
#define ADC_CFGR1_RES_Msk                   (0x3UL << ADC_CFGR1_RES_Pos)            /*!< 0x0000000C */
#define ADC_CFGR1_RES                       ADC_CFGR1_RES_Msk                       /*!< ADC data resolution */
#define ADC_CFGR1_RES_0                     (0x1UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000004 */
#define ADC_CFGR1_RES_1                     (0x2UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000008 */

#define ADC_CFGR1_EXTSEL_Pos                (5U)
#define ADC_CFGR1_EXTSEL_Msk                (0x1FUL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x000003E0 */
#define ADC_CFGR1_EXTSEL                    ADC_CFGR1_EXTSEL_Msk                    /*!< ADC group regular external trigger source */
#define ADC_CFGR1_EXTSEL_0                  (0x01UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000020 */
#define ADC_CFGR1_EXTSEL_1                  (0x02UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000040 */
#define ADC_CFGR1_EXTSEL_2                  (0x04UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000080 */
#define ADC_CFGR1_EXTSEL_3                  (0x08UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000100 */
#define ADC_CFGR1_EXTSEL_4                  (0x10UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000200 */

#define ADC_CFGR1_EXTEN_Pos                 (10U)
#define ADC_CFGR1_EXTEN_Msk                 (0x3UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000C00 */
#define ADC_CFGR1_EXTEN                     ADC_CFGR1_EXTEN_Msk                     /*!< ADC group regular external trigger polarity */
#define ADC_CFGR1_EXTEN_0                   (0x1UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000400 */
#define ADC_CFGR1_EXTEN_1                   (0x2UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000800 */

#define ADC_CFGR1_OVRMOD_Pos                (12U)
#define ADC_CFGR1_OVRMOD_Msk                (0x1UL << ADC_CFGR1_OVRMOD_Pos)         /*!< 0x00001000 */
#define ADC_CFGR1_OVRMOD                    ADC_CFGR1_OVRMOD_Msk                    /*!< ADC group regular overrun configuration */
#define ADC_CFGR1_CONT_Pos                  (13U)
#define ADC_CFGR1_CONT_Msk                  (0x1UL << ADC_CFGR1_CONT_Pos)           /*!< 0x00002000 */
#define ADC_CFGR1_CONT                      ADC_CFGR1_CONT_Msk                      /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR1_AUTDLY_Pos                (14U)
#define ADC_CFGR1_AUTDLY_Msk                (0x1UL << ADC_CFGR1_AUTDLY_Pos)         /*!< 0x00004000 */
#define ADC_CFGR1_AUTDLY                    ADC_CFGR1_AUTDLY_Msk                    /*!< ADC low power auto wait */

#define ADC_CFGR1_DISCEN_Pos                (16U)
#define ADC_CFGR1_DISCEN_Msk                (0x1UL << ADC_CFGR1_DISCEN_Pos)         /*!< 0x00010000 */
#define ADC_CFGR1_DISCEN                    ADC_CFGR1_DISCEN_Msk                    /*!< ADC group regular sequencer discontinuous mode */

#define ADC_CFGR1_DISCNUM_Pos               (17U)
#define ADC_CFGR1_DISCNUM_Msk               (0x7UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x000E0000 */
#define ADC_CFGR1_DISCNUM                   ADC_CFGR1_DISCNUM_Msk                   /*!< ADC group regular sequencer discontinuous number of ranks */
#define ADC_CFGR1_DISCNUM_0                 (0x1UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00020000 */
#define ADC_CFGR1_DISCNUM_1                 (0x2UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00040000 */
#define ADC_CFGR1_DISCNUM_2                 (0x4UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00080000 */

#define ADC_CFGR1_JDISCEN_Pos               (20U)
#define ADC_CFGR1_JDISCEN_Msk               (0x1UL << ADC_CFGR1_JDISCEN_Pos)        /*!< 0x00100000 */
#define ADC_CFGR1_JDISCEN                   ADC_CFGR1_JDISCEN_Msk                   /*!< ADC group injected sequencer discontinuous mode */

#define ADC_CFGR1_JQM_Pos                   (21U)
#define ADC_CFGR1_JQM_Msk                   (0x1UL << ADC_CFGR1_JQM_Pos)            /*!< 0x00200000 */
#define ADC_CFGR1_JQM                       ADC_CFGR1_JQM_Msk                       /*!< ADC group injected contexts queue mode */

#define ADC_CFGR1_AWD1SGL_Pos               (22U)
#define ADC_CFGR1_AWD1SGL_Msk               (0x1UL << ADC_CFGR1_AWD1SGL_Pos)        /*!< 0x00400000 */
#define ADC_CFGR1_AWD1SGL                   ADC_CFGR1_AWD1SGL_Msk                   /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR1_AWD1EN_Pos                (23U)
#define ADC_CFGR1_AWD1EN_Msk                (0x1UL << ADC_CFGR1_AWD1EN_Pos)         /*!< 0x00800000 */
#define ADC_CFGR1_AWD1EN                    ADC_CFGR1_AWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group regular */
#define ADC_CFGR1_JAWD1EN_Pos               (24U)
#define ADC_CFGR1_JAWD1EN_Msk               (0x1UL << ADC_CFGR1_JAWD1EN_Pos)        /*!< 0x01000000 */
#define ADC_CFGR1_JAWD1EN                   ADC_CFGR1_JAWD1EN_Msk                   /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CFGR1_JAUTO_Pos                 (25U)
#define ADC_CFGR1_JAUTO_Msk                 (0x1UL << ADC_CFGR1_JAUTO_Pos)          /*!< 0x02000000 */
#define ADC_CFGR1_JAUTO                     ADC_CFGR1_JAUTO_Msk                     /*!< ADC group injected automatic trigger mode */

#define ADC_CFGR1_AWD1CH_Pos                (26U)
#define ADC_CFGR1_AWD1CH_Msk                (0x1FUL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x7C000000 */
#define ADC_CFGR1_AWD1CH                    ADC_CFGR1_AWD1CH_Msk                    /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR1_AWD1CH_0                  (0x01UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x04000000 */
#define ADC_CFGR1_AWD1CH_1                  (0x02UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x08000000 */
#define ADC_CFGR1_AWD1CH_2                  (0x04UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x10000000 */
#define ADC_CFGR1_AWD1CH_3                  (0x08UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x20000000 */
#define ADC_CFGR1_AWD1CH_4                  (0x10UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x40000000 */

#define ADC_CFGR1_JQDIS_Pos                 (31U)
#define ADC_CFGR1_JQDIS_Msk                 (0x1UL << ADC_CFGR1_JQDIS_Pos)          /*!< 0x80000000 */
#define ADC_CFGR1_JQDIS                     ADC_CFGR1_JQDIS_Msk                     /*!< ADC group injected contexts queue disable */

/********************  Bit definition for ADC_CFGR2 register  *****************/
#define ADC_CFGR2_ROVSE_Pos                 (0U)
#define ADC_CFGR2_ROVSE_Msk                 (0x1UL << ADC_CFGR2_ROVSE_Pos)          /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                     ADC_CFGR2_ROVSE_Msk                     /*!< ADC oversampler enable on scope ADC group regular */
#define ADC_CFGR2_JOVSE_Pos                 (1U)
#define ADC_CFGR2_JOVSE_Msk                 (0x1UL << ADC_CFGR2_JOVSE_Pos)          /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                     ADC_CFGR2_JOVSE_Msk                     /*!< ADC oversampler enable on scope ADC group injected */

#define ADC_CFGR2_OVSS_Pos                  (5U)
#define ADC_CFGR2_OVSS_Msk                  (0xFUL << ADC_CFGR2_OVSS_Pos)           /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                      ADC_CFGR2_OVSS_Msk                      /*!< ADC oversampling shift */
#define ADC_CFGR2_OVSS_0                    (0x1UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1                    (0x2UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2                    (0x4UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3                    (0x8UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos                 (9U)
#define ADC_CFGR2_TROVS_Msk                 (0x1UL << ADC_CFGR2_TROVS_Pos)          /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                     ADC_CFGR2_TROVS_Msk                     /*!< ADC oversampling discontinuous mode (triggered mode) for ADC group regular */
#define ADC_CFGR2_ROVSM_Pos                 (10U)
#define ADC_CFGR2_ROVSM_Msk                 (0x1UL << ADC_CFGR2_ROVSM_Pos)          /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                     ADC_CFGR2_ROVSM_Msk                     /*!< ADC oversampling mode managing interlaced conversions of ADC group regular and group injected */

#define ADC_CFGR2_BULB_Pos                  (13U)
#define ADC_CFGR2_BULB_Msk                  (0x1UL << ADC_CFGR2_BULB_Pos)            /*!< 0x00002000 */
#define ADC_CFGR2_BULB                      ADC_CFGR2_BULB_Msk                       /*!< ADC bulb sampling mode */

#define ADC_CFGR2_SWTRIG_Pos                (14U)
#define ADC_CFGR2_SWTRIG_Msk                (0x1UL << ADC_CFGR2_SWTRIG_Pos)          /*!< 0x00004000 */
#define ADC_CFGR2_SWTRIG                    ADC_CFGR2_SWTRIG_Msk                     /*!< ADC software trigger bit for sampling time control trigger mode */

#define ADC_CFGR2_SMPTRIG_Pos               (15U)
#define ADC_CFGR2_SMPTRIG_Msk               (0x1UL << ADC_CFGR2_SMPTRIG_Pos)         /*!< 0x00008000 */
#define ADC_CFGR2_SMPTRIG                   ADC_CFGR2_SMPTRIG_Msk                    /*!< ADC sampling time control trigger mode */

#define ADC_CFGR2_OVSR_Pos                  (16U)
#define ADC_CFGR2_OVSR_Msk                  (0x3FFUL << ADC_CFGR2_OVSR_Pos)          /*!< 0x03FF0000 */
#define ADC_CFGR2_OVSR                      ADC_CFGR2_OVSR_Msk                       /*!< ADC oversampling ratio */
#define ADC_CFGR2_OVSR_0                    (0x001UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00010000 */
#define ADC_CFGR2_OVSR_1                    (0x002UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00020000 */
#define ADC_CFGR2_OVSR_2                    (0x004UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00040000 */
#define ADC_CFGR2_OVSR_3                    (0x008UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00080000 */
#define ADC_CFGR2_OVSR_4                    (0x010UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00100000 */
#define ADC_CFGR2_OVSR_5                    (0x020UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00200000 */
#define ADC_CFGR2_OVSR_6                    (0x040UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00400000 */
#define ADC_CFGR2_OVSR_7                    (0x080UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00800000 */
#define ADC_CFGR2_OVSR_8                    (0x100UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x01000000 */
#define ADC_CFGR2_OVSR_9                    (0x200UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x02000000 */

#define ADC_CFGR2_LFTRIG_Pos                (27U)
#define ADC_CFGR2_LFTRIG_Msk                (0x1UL << ADC_CFGR2_LFTRIG_Pos)          /*!< 0x08000000 */
#define ADC_CFGR2_LFTRIG                    ADC_CFGR2_LFTRIG_Msk                     /*!< ADC Low-frequency trigge */

#define ADC_CFGR2_LSHIFT_Pos                (28U)
#define ADC_CFGR2_LSHIFT_Msk                (0xFUL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT                    ADC_CFGR2_LSHIFT_Msk                     /*!< ADC left shift factor */
#define ADC_CFGR2_LSHIFT_0                  (0x1UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1                  (0x2UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2                  (0x4UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3                  (0x8UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x80000000 */

/********************  Bit definition for ADC_SMPR1 register  *****************/
#define ADC_SMPR1_SMP0_Pos                  (0U)
#define ADC_SMPR1_SMP0_Msk                  (0x7UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                      ADC_SMPR1_SMP0_Msk                      /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR1_SMP0_0                    (0x1UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1                    (0x2UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2                    (0x4UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos                  (3U)
#define ADC_SMPR1_SMP1_Msk                  (0x7UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                      ADC_SMPR1_SMP1_Msk                      /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR1_SMP1_0                    (0x1UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1                    (0x2UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2                    (0x4UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos                  (6U)
#define ADC_SMPR1_SMP2_Msk                  (0x7UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                      ADC_SMPR1_SMP2_Msk                      /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR1_SMP2_0                    (0x1UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1                    (0x2UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2                    (0x4UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos                  (9U)
#define ADC_SMPR1_SMP3_Msk                  (0x7UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                      ADC_SMPR1_SMP3_Msk                      /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR1_SMP3_0                    (0x1UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1                    (0x2UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2                    (0x4UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos                  (12U)
#define ADC_SMPR1_SMP4_Msk                  (0x7UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                      ADC_SMPR1_SMP4_Msk                      /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR1_SMP4_0                    (0x1UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1                    (0x2UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2                    (0x4UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos                  (15U)
#define ADC_SMPR1_SMP5_Msk                  (0x7UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                      ADC_SMPR1_SMP5_Msk                      /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR1_SMP5_0                    (0x1UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1                    (0x2UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2                    (0x4UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos                  (18U)
#define ADC_SMPR1_SMP6_Msk                  (0x7UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                      ADC_SMPR1_SMP6_Msk                      /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR1_SMP6_0                    (0x1UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1                    (0x2UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2                    (0x4UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos                  (21U)
#define ADC_SMPR1_SMP7_Msk                  (0x7UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                      ADC_SMPR1_SMP7_Msk                      /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR1_SMP7_0                    (0x1UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1                    (0x2UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2                    (0x4UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos                  (24U)
#define ADC_SMPR1_SMP8_Msk                  (0x7UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                      ADC_SMPR1_SMP8_Msk                      /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR1_SMP8_0                    (0x1UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1                    (0x2UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2                    (0x4UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos                  (27U)
#define ADC_SMPR1_SMP9_Msk                  (0x7UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                      ADC_SMPR1_SMP9_Msk                      /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR1_SMP9_0                    (0x1UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1                    (0x2UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2                    (0x4UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  *****************/
#define ADC_SMPR2_SMP10_Pos                 (0U)
#define ADC_SMPR2_SMP10_Msk                 (0x7UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                     ADC_SMPR2_SMP10_Msk                     /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR2_SMP10_0                   (0x1UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1                   (0x2UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2                   (0x4UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos                 (3U)
#define ADC_SMPR2_SMP11_Msk                 (0x7UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                     ADC_SMPR2_SMP11_Msk                     /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR2_SMP11_0                   (0x1UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1                   (0x2UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2                   (0x4UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos                 (6U)
#define ADC_SMPR2_SMP12_Msk                 (0x7UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                     ADC_SMPR2_SMP12_Msk                     /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR2_SMP12_0                   (0x1UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1                   (0x2UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2                   (0x4UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos                 (9U)
#define ADC_SMPR2_SMP13_Msk                 (0x7UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                     ADC_SMPR2_SMP13_Msk                     /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR2_SMP13_0                   (0x1UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1                   (0x2UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2                   (0x4UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos                 (12U)
#define ADC_SMPR2_SMP14_Msk                 (0x7UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                     ADC_SMPR2_SMP14_Msk                     /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR2_SMP14_0                   (0x1UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1                   (0x2UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2                   (0x4UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos                 (15U)
#define ADC_SMPR2_SMP15_Msk                 (0x7UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                     ADC_SMPR2_SMP15_Msk                     /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR2_SMP15_0                   (0x1UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1                   (0x2UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2                   (0x4UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos                 (18U)
#define ADC_SMPR2_SMP16_Msk                 (0x7UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                     ADC_SMPR2_SMP16_Msk                     /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR2_SMP16_0                   (0x1UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1                   (0x2UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2                   (0x4UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos                 (21U)
#define ADC_SMPR2_SMP17_Msk                 (0x7UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                     ADC_SMPR2_SMP17_Msk                     /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR2_SMP17_0                   (0x1UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1                   (0x2UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2                   (0x4UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos                 (24U)
#define ADC_SMPR2_SMP18_Msk                 (0x7UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                     ADC_SMPR2_SMP18_Msk                     /*!< ADC channel 18 sampling time selection  */
#define ADC_SMPR2_SMP18_0                   (0x1UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1                   (0x2UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2                   (0x4UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos                 (27U)
#define ADC_SMPR2_SMP19_Msk                 (0x7UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                     ADC_SMPR2_SMP19_Msk                     /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0                   (0x1UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1                   (0x2UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2                   (0x4UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  *****************/
#define ADC_PCSEL_PCSEL_Pos                 (0U)
#define ADC_PCSEL_PCSEL_Msk                 (0xFFFFFUL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                     ADC_PCSEL_PCSEL_Msk                   /*!< ADC channel preselection */
#define ADC_PCSEL_PCSEL_0                   (0x00001UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1                   (0x00002UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2                   (0x00004UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3                   (0x00008UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4                   (0x00010UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5                   (0x00020UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6                   (0x00040UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7                   (0x00080UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8                   (0x00100UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9                   (0x00200UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10                  (0x00400UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11                  (0x00800UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12                  (0x01000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13                  (0x02000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14                  (0x04000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15                  (0x08000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16                  (0x10000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17                  (0x20000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18                  (0x40000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_SQR1 register  ******************/
#define ADC_SQR1_L_Pos                      (0U)
#define ADC_SQR1_L_Msk                      (0xFUL << ADC_SQR1_L_Pos)               /*!< 0x0000000F */
#define ADC_SQR1_L                          ADC_SQR1_L_Msk                          /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                        (0x1UL << ADC_SQR1_L_Pos)               /*!< 0x00000001 */
#define ADC_SQR1_L_1                        (0x2UL << ADC_SQR1_L_Pos)               /*!< 0x00000002 */
#define ADC_SQR1_L_2                        (0x4UL << ADC_SQR1_L_Pos)               /*!< 0x00000004 */
#define ADC_SQR1_L_3                        (0x8UL << ADC_SQR1_L_Pos)               /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos                    (6U)
#define ADC_SQR1_SQ1_Msk                    (0x1FUL << ADC_SQR1_SQ1_Pos)            /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                        ADC_SQR1_SQ1_Msk                        /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR1_SQ1_0                      (0x01UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                      (0x02UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                      (0x04UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                      (0x08UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                      (0x10UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos                    (12U)
#define ADC_SQR1_SQ2_Msk                    (0x1FUL << ADC_SQR1_SQ2_Pos)            /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                        ADC_SQR1_SQ2_Msk                        /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR1_SQ2_0                      (0x01UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                      (0x02UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                      (0x04UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                      (0x08UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                      (0x10UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos                    (18U)
#define ADC_SQR1_SQ3_Msk                    (0x1FUL << ADC_SQR1_SQ3_Pos)            /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                        ADC_SQR1_SQ3_Msk                        /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR1_SQ3_0                      (0x01UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                      (0x02UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                      (0x04UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                      (0x08UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                      (0x10UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos                    (24U)
#define ADC_SQR1_SQ4_Msk                    (0x1FUL << ADC_SQR1_SQ4_Pos)            /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                        ADC_SQR1_SQ4_Msk                        /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR1_SQ4_0                      (0x01UL << ADC_SQR1_SQ4_Pos)            /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                      (0x02UL << ADC_SQR1_SQ4_Pos)            /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                      (0x04UL << ADC_SQR1_SQ4_Pos)            /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                      (0x08UL << ADC_SQR1_SQ4_Pos)            /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                      (0x10UL << ADC_SQR1_SQ4_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ******************/
#define ADC_SQR2_SQ5_Pos                    (0U)
#define ADC_SQR2_SQ5_Msk                    (0x1FUL << ADC_SQR2_SQ5_Pos)            /*!< 0x0000001F */
#define ADC_SQR2_SQ5                        ADC_SQR2_SQ5_Msk                        /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR2_SQ5_0                      (0x01UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                      (0x02UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                      (0x04UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                      (0x08UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                      (0x10UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos                    (6U)
#define ADC_SQR2_SQ6_Msk                    (0x1FUL << ADC_SQR2_SQ6_Pos)            /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                        ADC_SQR2_SQ6_Msk                        /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR2_SQ6_0                      (0x01UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                      (0x02UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                      (0x04UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                      (0x08UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                      (0x10UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos                    (12U)
#define ADC_SQR2_SQ7_Msk                    (0x1FUL << ADC_SQR2_SQ7_Pos)            /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                        ADC_SQR2_SQ7_Msk                        /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                      (0x01UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                      (0x02UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                      (0x04UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                      (0x08UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                      (0x10UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos                    (18U)
#define ADC_SQR2_SQ8_Msk                    (0x1FUL << ADC_SQR2_SQ8_Pos)            /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                        ADC_SQR2_SQ8_Msk                        /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                      (0x01UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                      (0x02UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                      (0x04UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                      (0x08UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                      (0x10UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos                    (24U)
#define ADC_SQR2_SQ9_Msk                    (0x1FUL << ADC_SQR2_SQ9_Pos)            /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                        ADC_SQR2_SQ9_Msk                        /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                      (0x01UL << ADC_SQR2_SQ9_Pos)            /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                      (0x02UL << ADC_SQR2_SQ9_Pos)            /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                      (0x04UL << ADC_SQR2_SQ9_Pos)            /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                      (0x08UL << ADC_SQR2_SQ9_Pos)            /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                      (0x10UL << ADC_SQR2_SQ9_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ******************/
#define ADC_SQR3_SQ10_Pos                   (0U)
#define ADC_SQR3_SQ10_Msk                   (0x1FUL << ADC_SQR3_SQ10_Pos)           /*!< 0x0000001F */
#define ADC_SQR3_SQ10                       ADC_SQR3_SQ10_Msk                       /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR3_SQ10_0                     (0x01UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                     (0x02UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                     (0x04UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                     (0x08UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                     (0x10UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos                   (6U)
#define ADC_SQR3_SQ11_Msk                   (0x1FUL << ADC_SQR3_SQ11_Pos)           /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                       ADC_SQR3_SQ11_Msk                       /*!< ADC group regular sequencer rank 11 */
#define ADC_SQR3_SQ11_0                     (0x01UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                     (0x02UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                     (0x04UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                     (0x08UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                     (0x10UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos                   (12U)
#define ADC_SQR3_SQ12_Msk                   (0x1FUL << ADC_SQR3_SQ12_Pos)           /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                       ADC_SQR3_SQ12_Msk                       /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR3_SQ12_0                     (0x01UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                     (0x02UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                     (0x04UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                     (0x08UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                     (0x10UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos                   (18U)
#define ADC_SQR3_SQ13_Msk                   (0x1FUL << ADC_SQR3_SQ13_Pos)           /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                       ADC_SQR3_SQ13_Msk                       /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR3_SQ13_0                     (0x01UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                     (0x02UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                     (0x04UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                     (0x08UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                     (0x10UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos                   (24U)
#define ADC_SQR3_SQ14_Msk                   (0x1FUL << ADC_SQR3_SQ14_Pos)           /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                       ADC_SQR3_SQ14_Msk                       /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR3_SQ14_0                     (0x01UL << ADC_SQR3_SQ14_Pos)           /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                     (0x02UL << ADC_SQR3_SQ14_Pos)           /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                     (0x04UL << ADC_SQR3_SQ14_Pos)           /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                     (0x08UL << ADC_SQR3_SQ14_Pos)           /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                     (0x10UL << ADC_SQR3_SQ14_Pos)           /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ******************/
#define ADC_SQR4_SQ15_Pos                   (0U)
#define ADC_SQR4_SQ15_Msk                   (0x1FUL << ADC_SQR4_SQ15_Pos)           /*!< 0x0000001F */
#define ADC_SQR4_SQ15                       ADC_SQR4_SQ15_Msk                       /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR4_SQ15_0                     (0x01UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                     (0x02UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                     (0x04UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                     (0x08UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                     (0x10UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos                   (6U)
#define ADC_SQR4_SQ16_Msk                   (0x1FUL << ADC_SQR4_SQ16_Pos)           /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                       ADC_SQR4_SQ16_Msk                       /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR4_SQ16_0                     (0x01UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                     (0x02UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                     (0x04UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                     (0x08UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                     (0x10UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000400 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos                    (0U)
#define ADC_DR_RDATA_Msk                    (0xFFFFFFFFUL << ADC_DR_RDATA_Pos)      /*!< 0xFFFFFFFF */
#define ADC_DR_RDATA                        ADC_DR_RDATA_Msk                        /*!< ADC group regular conversion data */
#define ADC_DR_RDATA_0                      (0x00000001UL << ADC_DR_RDATA_Pos)      /*!< 0x00000001 */
#define ADC_DR_RDATA_1                      (0x00000002UL << ADC_DR_RDATA_Pos)      /*!< 0x00000002 */
#define ADC_DR_RDATA_2                      (0x00000004UL << ADC_DR_RDATA_Pos)      /*!< 0x00000004 */
#define ADC_DR_RDATA_3                      (0x00000008UL << ADC_DR_RDATA_Pos)      /*!< 0x00000008 */
#define ADC_DR_RDATA_4                      (0x00000010UL << ADC_DR_RDATA_Pos)      /*!< 0x00000010 */
#define ADC_DR_RDATA_5                      (0x00000020UL << ADC_DR_RDATA_Pos)      /*!< 0x00000020 */
#define ADC_DR_RDATA_6                      (0x00000040UL << ADC_DR_RDATA_Pos)      /*!< 0x00000040 */
#define ADC_DR_RDATA_7                      (0x00000080UL << ADC_DR_RDATA_Pos)      /*!< 0x00000080 */
#define ADC_DR_RDATA_8                      (0x00000100UL << ADC_DR_RDATA_Pos)      /*!< 0x00000100 */
#define ADC_DR_RDATA_9                      (0x00000200UL << ADC_DR_RDATA_Pos)      /*!< 0x00000200 */
#define ADC_DR_RDATA_10                     (0x00000400UL << ADC_DR_RDATA_Pos)      /*!< 0x00000400 */
#define ADC_DR_RDATA_11                     (0x00000800UL << ADC_DR_RDATA_Pos)      /*!< 0x00000800 */
#define ADC_DR_RDATA_12                     (0x00001000UL << ADC_DR_RDATA_Pos)      /*!< 0x00001000 */
#define ADC_DR_RDATA_13                     (0x00002000UL << ADC_DR_RDATA_Pos)      /*!< 0x00002000 */
#define ADC_DR_RDATA_14                     (0x00004000UL << ADC_DR_RDATA_Pos)      /*!< 0x00004000 */
#define ADC_DR_RDATA_15                     (0x00008000UL << ADC_DR_RDATA_Pos)      /*!< 0x00008000 */
#define ADC_DR_RDATA_16                     (0x00010000UL << ADC_DR_RDATA_Pos)      /*!< 0x00010000 */
#define ADC_DR_RDATA_17                     (0x00020000UL << ADC_DR_RDATA_Pos)      /*!< 0x00020000 */
#define ADC_DR_RDATA_18                     (0x00040000UL << ADC_DR_RDATA_Pos)      /*!< 0x00040000 */
#define ADC_DR_RDATA_19                     (0x00080000UL << ADC_DR_RDATA_Pos)      /*!< 0x00080000 */
#define ADC_DR_RDATA_20                     (0x00100000UL << ADC_DR_RDATA_Pos)      /*!< 0x00100000 */
#define ADC_DR_RDATA_21                     (0x00200000UL << ADC_DR_RDATA_Pos)      /*!< 0x00200000 */
#define ADC_DR_RDATA_22                     (0x00400000UL << ADC_DR_RDATA_Pos)      /*!< 0x00400000 */
#define ADC_DR_RDATA_23                     (0x00800000UL << ADC_DR_RDATA_Pos)      /*!< 0x00800000 */
#define ADC_DR_RDATA_24                     (0x01000000UL << ADC_DR_RDATA_Pos)      /*!< 0x01000000 */
#define ADC_DR_RDATA_25                     (0x02000000UL << ADC_DR_RDATA_Pos)      /*!< 0x02000000 */
#define ADC_DR_RDATA_26                     (0x04000000UL << ADC_DR_RDATA_Pos)      /*!< 0x04000000 */
#define ADC_DR_RDATA_27                     (0x08000000UL << ADC_DR_RDATA_Pos)      /*!< 0x08000000 */
#define ADC_DR_RDATA_28                     (0x10000000UL << ADC_DR_RDATA_Pos)      /*!< 0x10000000 */
#define ADC_DR_RDATA_29                     (0x20000000UL << ADC_DR_RDATA_Pos)      /*!< 0x20000000 */
#define ADC_DR_RDATA_30                     (0x40000000UL << ADC_DR_RDATA_Pos)      /*!< 0x40000000 */
#define ADC_DR_RDATA_31                     (0x80000000UL << ADC_DR_RDATA_Pos)      /*!< 0x80000000 */

/********************  Bit definition for ADC_JSQR register  ******************/
#define ADC_JSQR_JL_Pos                     (0U)
#define ADC_JSQR_JL_Msk                     (0x3UL << ADC_JSQR_JL_Pos)              /*!< 0x00000003 */
#define ADC_JSQR_JL                         ADC_JSQR_JL_Msk                         /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                       (0x1UL << ADC_JSQR_JL_Pos)              /*!< 0x00000001 */
#define ADC_JSQR_JL_1                       (0x2UL << ADC_JSQR_JL_Pos)              /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos                (2U)
#define ADC_JSQR_JEXTSEL_Msk                (0x1FUL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL                    ADC_JSQR_JEXTSEL_Msk                    /*!< ADC group injected external trigger source */
#define ADC_JSQR_JEXTSEL_0                  (0x01UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1                  (0x02UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2                  (0x04UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3                  (0x08UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4                  (0x10UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos                 (7U)
#define ADC_JSQR_JEXTEN_Msk                 (0x3UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                     ADC_JSQR_JEXTEN_Msk                     /*!< ADC group injected external trigger polarity */
#define ADC_JSQR_JEXTEN_0                   (0x1UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1                   (0x2UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos                   (9U)
#define ADC_JSQR_JSQ1_Msk                   (0x1FUL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                       ADC_JSQR_JSQ1_Msk                       /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                     (0x01UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                     (0x02UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                     (0x04UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                     (0x08UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                     (0x10UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos                   (15U)
#define ADC_JSQR_JSQ2_Msk                   (0x1FUL << ADC_JSQR_JSQ2_Pos)           /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                       ADC_JSQR_JSQ2_Msk                       /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                     (0x01UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                     (0x02UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                     (0x04UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                     (0x08UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                     (0x10UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos                   (21U)
#define ADC_JSQR_JSQ3_Msk                   (0x1FUL << ADC_JSQR_JSQ3_Pos)           /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                       ADC_JSQR_JSQ3_Msk                       /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                     (0x01UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                     (0x02UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                     (0x04UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                     (0x08UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                     (0x10UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos                   (27U)
#define ADC_JSQR_JSQ4_Msk                   (0x1FUL << ADC_JSQR_JSQ4_Pos)           /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                       ADC_JSQR_JSQ4_Msk                       /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                     (0x01UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                     (0x02UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                     (0x04UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                     (0x08UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                     (0x10UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR1 register  ***************/
#define ADC_OFCFGR1_POSOFF_Pos              (24U)
#define ADC_OFCFGR1_POSOFF_Msk              (0x01UL << ADC_OFCFGR1_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR1_POSOFF                  ADC_OFCFGR1_POSOFF_Msk                  /*!< ADC offset instance 1 positive offset enable */

#define ADC_OFCFGR1_USAT_Pos                (25U)
#define ADC_OFCFGR1_USAT_Msk                (0x01UL << ADC_OFCFGR1_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR1_USAT                    ADC_OFCFGR1_USAT_Msk                    /*!< ADC offset instance 1  unsigned saturation value */

#define ADC_OFCFGR1_SSAT_Pos                (26U)
#define ADC_OFCFGR1_SSAT_Msk                (0x01UL << ADC_OFCFGR1_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR1_SSAT                    ADC_OFCFGR1_SSAT_Msk                    /*!< ADC offset instance 1 signed satuaration enable */

#define ADC_OFCFGR1_OFFSET_CH_Pos           (27U)
#define ADC_OFCFGR1_OFFSET_CH_Msk           (0x1FUL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR1_OFFSET_CH               ADC_OFCFGR1_OFFSET_CH_Msk               /*!< ADC offset instance 1 channel selection */
#define ADC_OFCFGR1_OFFSET_CH_0             (0x01UL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFCFGR1_OFFSET_CH_1             (0x02UL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFCFGR1_OFFSET_CH_2             (0x03UL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFCFGR1_OFFSET_CH_3             (0x04UL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0x40000000 */
#define ADC_OFCFGR1_OFFSET_CH_4             (0x05UL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR2 register  ***************/
#define ADC_OFCFGR2_POSOFF_Pos              (24U)
#define ADC_OFCFGR2_POSOFF_Msk              (0x01UL << ADC_OFCFGR2_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR2_POSOFF                  ADC_OFCFGR2_POSOFF_Msk                  /*!< ADC offset instance 2 positive offset enable */

#define ADC_OFCFGR2_USAT_Pos                (25U)
#define ADC_OFCFGR2_USAT_Msk                (0x01UL << ADC_OFCFGR2_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR2_USAT                    ADC_OFCFGR2_USAT_Msk                    /*!< ADC offset instance 2 unsigned saturation value */

#define ADC_OFCFGR2_SSAT_Pos                (26U)
#define ADC_OFCFGR2_SSAT_Msk                (0x01UL << ADC_OFCFGR2_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR2_SSAT                    ADC_OFCFGR2_SSAT_Msk                    /*!< ADC offset instance 2 signed satuaration enable */

#define ADC_OFCFGR2_OFFSET_CH_Pos           (27U)
#define ADC_OFCFGR2_OFFSET_CH_Msk           (0x1FUL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR2_OFFSET_CH               ADC_OFCFGR2_OFFSET_CH_Msk               /*!< ADC offset instance 2 channel selection */
#define ADC_OFCFGR2_OFFSET_CH_0             (0x01UL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFCFGR2_OFFSET_CH_1             (0x02UL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFCFGR2_OFFSET_CH_2             (0x03UL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFCFGR2_OFFSET_CH_3             (0x04UL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0x40000000 */
#define ADC_OFCFGR2_OFFSET_CH_4             (0x05UL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR3 register  ***************/
#define ADC_OFCFGR3_POSOFF_Pos              (24U)
#define ADC_OFCFGR3_POSOFF_Msk              (0x01UL << ADC_OFCFGR3_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR3_POSOFF                  ADC_OFCFGR3_POSOFF_Msk                  /*!< ADC offset instance 3 positive offset enable */

#define ADC_OFCFGR3_USAT_Pos                (25U)
#define ADC_OFCFGR3_USAT_Msk                (0x01UL << ADC_OFCFGR3_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR3_USAT                    ADC_OFCFGR3_USAT_Msk                    /*!< ADC offset instance 3 unsigned saturation value */

#define ADC_OFCFGR3_SSAT_Pos                (26U)
#define ADC_OFCFGR3_SSAT_Msk                (0x01UL << ADC_OFCFGR3_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR3_SSAT                    ADC_OFCFGR3_SSAT_Msk                    /*!< ADC offset instance 3 signed satuaration enable */

#define ADC_OFCFGR3_OFFSET_CH_Pos           (27U)
#define ADC_OFCFGR3_OFFSET_CH_Msk           (0x1FUL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR3_OFFSET_CH               ADC_OFCFGR3_OFFSET_CH_Msk               /*!< ADC offset instance 3 channel selection for the data offset */
#define ADC_OFCFGR3_OFFSET_CH_0             (0x01UL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFCFGR3_OFFSET_CH_1             (0x02UL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFCFGR3_OFFSET_CH_2             (0x03UL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFCFGR3_OFFSET_CH_3             (0x04UL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0x40000000 */
#define ADC_OFCFGR3_OFFSET_CH_4             (0x05UL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR4 register  ***************/
#define ADC_OFCFGR4_POSOFF_Pos              (24U)
#define ADC_OFCFGR4_POSOFF_Msk              (0x01UL << ADC_OFCFGR4_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR4_POSOFF                  ADC_OFCFGR4_POSOFF_Msk                  /*!< ADC offset instance 4 positive offset enable */

#define ADC_OFCFGR4_USAT_Pos                (25U)
#define ADC_OFCFGR4_USAT_Msk                (0x01UL << ADC_OFCFGR4_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR4_USAT                    ADC_OFCFGR4_USAT_Msk                    /*!< ADC offset instance 4 unsigned saturation value */

#define ADC_OFCFGR4_SSAT_Pos                (26U)
#define ADC_OFCFGR4_SSAT_Msk                (0x01UL << ADC_OFCFGR4_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR4_SSAT                    ADC_OFCFGR4_SSAT_Msk                    /*!< ADC offset instance 4 signed satuaration enable */

#define ADC_OFCFGR4_OFFSET_CH_Pos           (27U)
#define ADC_OFCFGR4_OFFSET_CH_Msk           (0x1FUL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR4_OFFSET_CH               ADC_OFCFGR4_OFFSET_CH_Msk               /*!< ADC offset instance 4 channel selection for the data offset */
#define ADC_OFCFGR4_OFFSET_CH_0             (0x01UL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFCFGR4_OFFSET_CH_1             (0x02UL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFCFGR4_OFFSET_CH_2             (0x03UL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFCFGR4_OFFSET_CH_3             (0x04UL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0x40000000 */
#define ADC_OFCFGR4_OFFSET_CH_4             (0x05UL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ******************/
#define ADC_OFR1_OFFSET_Pos                 (0U)
#define ADC_OFR1_OFFSET_Msk                 (0x03FFFFFUL << ADC_OFR1_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR1_OFFSET                     ADC_OFR1_OFFSET_Msk                     /*!< ADC offset instance 1 offset level */
#define ADC_OFR1_OFFSET_0                   (0x0000001UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR1_OFFSET_1                   (0x0000002UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR1_OFFSET_2                   (0x0000004UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR1_OFFSET_3                   (0x0000008UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR1_OFFSET_4                   (0x0000010UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR1_OFFSET_5                   (0x0000020UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR1_OFFSET_6                   (0x0000040UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR1_OFFSET_7                   (0x0000080UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR1_OFFSET_8                   (0x0000100UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR1_OFFSET_9                   (0x0000200UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR1_OFFSET_10                  (0x0000400UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR1_OFFSET_11                  (0x0000800UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR1_OFFSET_12                  (0x0001000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR1_OFFSET_13                  (0x0002000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR1_OFFSET_14                  (0x0004000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR1_OFFSET_15                  (0x0008000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR1_OFFSET_16                  (0x0010000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR1_OFFSET_17                  (0x0020000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR1_OFFSET_18                  (0x0040000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR1_OFFSET_19                  (0x0080000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR1_OFFSET_20                  (0x0100000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR1_OFFSET_21                  (0x0200000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR2 register  ******************/
#define ADC_OFR2_OFFSET_Pos                 (0U)
#define ADC_OFR2_OFFSET_Msk                 (0x03FFFFFUL << ADC_OFR2_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR2_OFFSET                     ADC_OFR2_OFFSET_Msk                     /*!< ADC offset instance 2 offset level */
#define ADC_OFR2_OFFSET_0                   (0x0000001UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR2_OFFSET_1                   (0x0000002UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR2_OFFSET_2                   (0x0000004UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR2_OFFSET_3                   (0x0000008UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR2_OFFSET_4                   (0x0000010UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR2_OFFSET_5                   (0x0000020UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR2_OFFSET_6                   (0x0000040UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR2_OFFSET_7                   (0x0000080UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR2_OFFSET_8                   (0x0000100UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR2_OFFSET_9                   (0x0000200UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR2_OFFSET_10                  (0x0000400UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR2_OFFSET_11                  (0x0000800UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR2_OFFSET_12                  (0x0001000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR2_OFFSET_13                  (0x0002000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR2_OFFSET_14                  (0x0004000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR2_OFFSET_15                  (0x0008000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR2_OFFSET_16                  (0x0010000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR2_OFFSET_17                  (0x0020000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR2_OFFSET_18                  (0x0040000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR2_OFFSET_19                  (0x0080000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR2_OFFSET_20                  (0x0100000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR2_OFFSET_21                  (0x0200000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR3 register  ******************/
#define ADC_OFR3_OFFSET_Pos                 (0U)
#define ADC_OFR3_OFFSET_Msk                 (0x03FFFFFUL << ADC_OFR3_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR3_OFFSET                     ADC_OFR3_OFFSET_Msk                     /*!< ADC offset instance 3 offset level */
#define ADC_OFR3_OFFSET_0                   (0x0000001UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR3_OFFSET_1                   (0x0000002UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR3_OFFSET_2                   (0x0000004UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR3_OFFSET_3                   (0x0000008UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR3_OFFSET_4                   (0x0000010UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR3_OFFSET_5                   (0x0000020UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR3_OFFSET_6                   (0x0000040UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR3_OFFSET_7                   (0x0000080UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR3_OFFSET_8                   (0x0000100UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR3_OFFSET_9                   (0x0000200UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR3_OFFSET_10                  (0x0000400UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR3_OFFSET_11                  (0x0000800UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR3_OFFSET_12                  (0x0001000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR3_OFFSET_13                  (0x0002000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR3_OFFSET_14                  (0x0004000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR3_OFFSET_15                  (0x0008000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR3_OFFSET_16                  (0x0010000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR3_OFFSET_17                  (0x0020000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR3_OFFSET_18                  (0x0040000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR3_OFFSET_19                  (0x0080000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR3_OFFSET_20                  (0x0100000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR3_OFFSET_21                  (0x0200000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR4 register  ******************/
#define ADC_OFR4_OFFSET_Pos                 (0U)
#define ADC_OFR4_OFFSET_Msk                 (0x03FFFFFUL << ADC_OFR4_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR4_OFFSET                     ADC_OFR4_OFFSET_Msk                     /*!< ADC offset instance 4 offset level */
#define ADC_OFR4_OFFSET_0                   (0x0000001UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR4_OFFSET_1                   (0x0000002UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR4_OFFSET_2                   (0x0000004UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR4_OFFSET_3                   (0x0000008UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR4_OFFSET_4                   (0x0000010UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR4_OFFSET_5                   (0x0000020UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR4_OFFSET_6                   (0x0000040UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR4_OFFSET_7                   (0x0000080UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR4_OFFSET_8                   (0x0000100UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR4_OFFSET_9                   (0x0000200UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR4_OFFSET_10                  (0x0000400UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR4_OFFSET_11                  (0x0000800UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR4_OFFSET_12                  (0x0001000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR4_OFFSET_13                  (0x0002000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR4_OFFSET_14                  (0x0004000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR4_OFFSET_15                  (0x0008000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR4_OFFSET_16                  (0x0010000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR4_OFFSET_17                  (0x0020000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR4_OFFSET_18                  (0x0040000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR4_OFFSET_19                  (0x0080000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR4_OFFSET_20                  (0x0100000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR4_OFFSET_21                  (0x0200000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_GCOMP register  *****************/
#define ADC_GCOMP_GCOMPCOEFF_Pos            (0U)
#define ADC_GCOMP_GCOMPCOEFF_Msk            (0x3FFFUL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00003FFF */
#define ADC_GCOMP_GCOMPCOEFF                ADC_GCOMP_GCOMPCOEFF_Msk                /*!< Gain compensation coefficient */
#define ADC_GCOMP_GCOMPCOEFF_0              (0x0001UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000001 */
#define ADC_GCOMP_GCOMPCOEFF_1              (0x0002UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000002 */
#define ADC_GCOMP_GCOMPCOEFF_2              (0x0004UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000004 */
#define ADC_GCOMP_GCOMPCOEFF_3              (0x0008UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000008 */
#define ADC_GCOMP_GCOMPCOEFF_4              (0x0010UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000010 */
#define ADC_GCOMP_GCOMPCOEFF_5              (0x0020UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000020 */
#define ADC_GCOMP_GCOMPCOEFF_6              (0x0040UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000040 */
#define ADC_GCOMP_GCOMPCOEFF_7              (0x0080UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000080 */
#define ADC_GCOMP_GCOMPCOEFF_8              (0x0100UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000100 */
#define ADC_GCOMP_GCOMPCOEFF_9              (0x0200UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000200 */
#define ADC_GCOMP_GCOMPCOEFF_10             (0x0400UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000400 */
#define ADC_GCOMP_GCOMPCOEFF_11             (0x0800UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00000800 */
#define ADC_GCOMP_GCOMPCOEFF_12             (0x1000UL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00001000 */
#define ADC_GCOMP_GCOMPCOEFF_13             (0x2000UL << ADC_GCOMP_GCOMPCOEFF_Pos)   /*!< 0x00002000 */

#define ADC_GCOMP_GCOMP_Pos                 (31U)
#define ADC_GCOMP_GCOMP_Msk                 (0x1UL << ADC_GCOMP_GCOMP_Pos)          /*!< 0x80000000 */
#define ADC_GCOMP_GCOMP                     ADC_GCOMP_GCOMP_Msk                     /*!< Gain compensation mode */

/********************  Bit definition for ADC_JDR1 register  ******************/
#define ADC_JDR1_JDATA_Pos                  (0U)
#define ADC_JDR1_JDATA_Msk                  (0xFFFFFFFFUL << ADC_JDR1_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR1_JDATA                      ADC_JDR1_JDATA_Msk                      /*!< ADC group injected sequencer rank 1 conversion data */
#define ADC_JDR1_JDATA_0                    (0x00000001UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1                    (0x00000002UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2                    (0x00000004UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3                    (0x00000008UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4                    (0x00000010UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5                    (0x00000020UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6                    (0x00000040UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7                    (0x00000080UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8                    (0x00000100UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9                    (0x00000200UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10                   (0x00000400UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11                   (0x00000800UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12                   (0x00001000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13                   (0x00002000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14                   (0x00004000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15                   (0x00008000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16                   (0x00010000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17                   (0x00020000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18                   (0x00040000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19                   (0x00080000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20                   (0x00100000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21                   (0x00200000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22                   (0x00400000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23                   (0x00800000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24                   (0x01000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25                   (0x02000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26                   (0x04000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27                   (0x08000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28                   (0x10000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29                   (0x20000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30                   (0x40000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31                   (0x80000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos                  (0U)
#define ADC_JDR2_JDATA_Msk                  (0xFFFFFFFFUL << ADC_JDR2_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR2_JDATA                      ADC_JDR2_JDATA_Msk                      /*!< ADC group injected sequencer rank 2 conversion data */
#define ADC_JDR2_JDATA_0                    (0x00000001UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1                    (0x00000002UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2                    (0x00000004UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3                    (0x00000008UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4                    (0x00000010UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5                    (0x00000020UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6                    (0x00000040UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7                    (0x00000080UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8                    (0x00000100UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9                    (0x00000200UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10                   (0x00000400UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11                   (0x00000800UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12                   (0x00001000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13                   (0x00002000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14                   (0x00004000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15                   (0x00008000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16                   (0x00010000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17                   (0x00020000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18                   (0x00040000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19                   (0x00080000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20                   (0x00100000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21                   (0x00200000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22                   (0x00400000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23                   (0x00800000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24                   (0x01000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25                   (0x02000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26                   (0x04000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27                   (0x08000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28                   (0x10000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29                   (0x20000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30                   (0x40000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31                   (0x80000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos                  (0U)
#define ADC_JDR3_JDATA_Msk                  (0xFFFFFFFFUL << ADC_JDR3_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR3_JDATA                      ADC_JDR3_JDATA_Msk                      /*!< ADC group injected sequencer rank 3 conversion data */
#define ADC_JDR3_JDATA_0                    (0x00000001UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1                    (0x00000002UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2                    (0x00000004UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3                    (0x00000008UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4                    (0x00000010UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5                    (0x00000020UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6                    (0x00000040UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7                    (0x00000080UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8                    (0x00000100UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9                    (0x00000200UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10                   (0x00000400UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11                   (0x00000800UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12                   (0x00001000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13                   (0x00002000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14                   (0x00004000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15                   (0x00008000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16                   (0x00010000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17                   (0x00020000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18                   (0x00040000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19                   (0x00080000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20                   (0x00100000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21                   (0x00200000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22                   (0x00400000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23                   (0x00800000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24                   (0x01000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25                   (0x02000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26                   (0x04000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27                   (0x08000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28                   (0x10000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29                   (0x20000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30                   (0x40000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31                   (0x80000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos                  (0U)
#define ADC_JDR4_JDATA_Msk                  (0xFFFFFFFFUL << ADC_JDR4_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR4_JDATA                      ADC_JDR4_JDATA_Msk                      /*!< ADC group injected sequencer rank 4 conversion data */
#define ADC_JDR4_JDATA_0                    (0x00000001UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1                    (0x00000002UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2                    (0x00000004UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3                    (0x00000008UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4                    (0x00000010UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5                    (0x00000020UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6                    (0x00000040UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7                    (0x00000080UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8                    (0x00000100UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9                    (0x00000200UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10                   (0x00000400UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11                   (0x00000800UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12                   (0x00001000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13                   (0x00002000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14                   (0x00004000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15                   (0x00008000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16                   (0x00010000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17                   (0x00020000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18                   (0x00040000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19                   (0x00080000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20                   (0x00100000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21                   (0x00200000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22                   (0x00400000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23                   (0x00800000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24                   (0x01000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25                   (0x02000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26                   (0x04000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27                   (0x08000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28                   (0x10000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29                   (0x20000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30                   (0x40000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31                   (0x80000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos               (0U)
#define ADC_AWD2CR_AWD2CH_Msk               (0x7FFFFUL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x000FFFFF */
#define ADC_AWD2CR_AWD2CH                   ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0                 (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1                 (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2                 (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3                 (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4                 (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5                 (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6                 (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7                 (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8                 (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9                 (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10                (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11                (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12                (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13                (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14                (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15                (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16                (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17                (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18                (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos               (0U)
#define ADC_AWD3CR_AWD3CH_Msk               (0x7FFFFUL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x000FFFFF */
#define ADC_AWD3CR_AWD3CH                   ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0                 (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1                 (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2                 (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3                 (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4                 (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5                 (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6                 (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7                 (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8                 (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9                 (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10                (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11                (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12                (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13                (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14                (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15                (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16                (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17                (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18                (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_AWD1TR_LT register  *************/
#define ADC_AWD1LTR_LTR_Pos                 (0U)
#define ADC_AWD1LTR_LTR_Msk                 (0x007FFFFFUL << ADC_AWD1LTR_LTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD1LTR_LTR                     ADC_AWD1LTR_LTR_Msk                     /*!< ADC analog watchdog 1 threshold low */
#define ADC_AWD1LTR_LTR_0                   (0x000001UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD1LTR_LTR_1                   (0x000002UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD1LTR_LTR_2                   (0x000004UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD1LTR_LTR_3                   (0x000008UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD1LTR_LTR_4                   (0x000010UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD1LTR_LTR_5                   (0x000020UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD1LTR_LTR_6                   (0x000040UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD1LTR_LTR_7                   (0x000080UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD1LTR_LTR_8                   (0x000100UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD1LTR_LTR_9                   (0x000200UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD1LTR_LTR_10                  (0x000400UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD1LTR_LTR_11                  (0x000800UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD1LTR_LTR_12                  (0x001000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD1LTR_LTR_13                  (0x002000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD1LTR_LTR_14                  (0x004000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD1LTR_LTR_15                  (0x008000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD1LTR_LTR_16                  (0x010000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD1LTR_LTR_17                  (0x020000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD1LTR_LTR_18                  (0x040000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD1LTR_LTR_19                  (0x080000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD1LTR_LTR_20                  (0x100000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD1LTR_LTR_21                  (0x200000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD1LTR_LTR_22                  (0x400000UL << ADC_AWD1LTR_LTR_Pos)     /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD1TR_HT register  *******************/
#define ADC_AWD1HTR_HTR_Pos                 (0U)
#define ADC_AWD1HTR_HTR_Msk                 (0x007FFFFFUL << ADC_AWD1HTR_HTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD1HTR_HTR                     ADC_AWD1HTR_HTR_Msk                     /*!< ADC analog watchdog 1 threshold high */
#define ADC_AWD1HTR_HTR_0                   (0x000001UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD1HTR_HTR_1                   (0x000002UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD1HTR_HTR_2                   (0x000004UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD1HTR_HTR_3                   (0x000008UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD1HTR_HTR_4                   (0x000010UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD1HTR_HTR_5                   (0x000020UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD1HTR_HTR_6                   (0x000040UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD1HTR_HTR_7                   (0x000080UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD1HTR_HTR_8                   (0x000100UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD1HTR_HTR_9                   (0x000200UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD1HTR_HTR_10                  (0x000400UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD1HTR_HTR_11                  (0x000800UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD1HTR_HTR_12                  (0x001000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD1HTR_HTR_13                  (0x002000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD1HTR_HTR_14                  (0x004000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD1HTR_HTR_15                  (0x008000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD1HTR_HTR_16                  (0x010000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD1HTR_HTR_17                  (0x020000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD1HTR_HTR_18                  (0x040000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD1HTR_HTR_19                  (0x080000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD1HTR_HTR_20                  (0x100000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD1HTR_HTR_21                  (0x200000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD1HTR_HTR_22                  (0x400000UL << ADC_AWD1HTR_HTR_Pos)     /*!< 0x00400000 */

#define ADC_AWD1HTR_AWDFILT_Pos             (29U)
#define ADC_AWD1HTR_AWDFILT_Msk             (0x7UL << ADC_AWD1HTR_AWDFILT_Pos)      /*!< 0x00000007 */
#define ADC_AWD1HTR_AWDFILT                 ADC_AWD1HTR_AWDFILT_Msk                 /*!< ADC analog watchdog 1 filtering */
#define ADC_AWD1HTR_AWDFILT_0               (0x000001UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000001 */
#define ADC_AWD1HTR_AWDFILT_1               (0x000002UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000002 */
#define ADC_AWD1HTR_AWDFILT_2               (0x000004UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000004 */

/********************  Bit definition for ADC_AWD2TR_LT register  *******************/
#define ADC_AWD2LTR_LTR_Pos                 (0U)
#define ADC_AWD2LTR_LTR_Msk                 (0x007FFFFFUL << ADC_AWD2LTR_LTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD2LTR_LTR                     ADC_AWD2LTR_LTR_Msk                     /*!< ADC analog watchdog 2 threshold low */
#define ADC_AWD2LTR_LTR_0                   (0x000001UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD2LTR_LTR_1                   (0x000002UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD2LTR_LTR_2                   (0x000004UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD2LTR_LTR_3                   (0x000008UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD2LTR_LTR_4                   (0x000010UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD2LTR_LTR_5                   (0x000020UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD2LTR_LTR_6                   (0x000040UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD2LTR_LTR_7                   (0x000080UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD2LTR_LTR_8                   (0x000100UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD2LTR_LTR_9                   (0x000200UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD2LTR_LTR_10                  (0x000400UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD2LTR_LTR_11                  (0x000800UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD2LTR_LTR_12                  (0x001000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD2LTR_LTR_13                  (0x002000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD2LTR_LTR_14                  (0x004000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD2LTR_LTR_15                  (0x008000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD2LTR_LTR_16                  (0x010000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD2LTR_LTR_17                  (0x020000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD2LTR_LTR_18                  (0x040000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD2LTR_LTR_19                  (0x080000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD2LTR_LTR_20                  (0x100000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD2LTR_LTR_21                  (0x200000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD2LTR_LTR_22                  (0x400000UL << ADC_AWD2LTR_LTR_Pos)     /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD2TR_HT register  *******************/
#define ADC_AWD2HTR_HTR_Pos                 (0U)
#define ADC_AWD2HTR_HTR_Msk                 (0x007FFFFFUL << ADC_AWD2HTR_HTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD2HTR_HTR                     ADC_AWD2HTR_HTR_Msk                     /*!< ADC analog watchdog 2 threshold high */
#define ADC_AWD2HTR_HTR_0                   (0x000001UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD2HTR_HTR_1                   (0x000002UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD2HTR_HTR_2                   (0x000004UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD2HTR_HTR_3                   (0x000008UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD2HTR_HTR_4                   (0x000010UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD2HTR_HTR_5                   (0x000020UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD2HTR_HTR_6                   (0x000040UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD2HTR_HTR_7                   (0x000080UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD2HTR_HTR_8                   (0x000100UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD2HTR_HTR_9                   (0x000200UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD2HTR_HTR_10                  (0x000400UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD2HTR_HTR_11                  (0x000800UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD2HTR_HTR_12                  (0x001000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD2HTR_HTR_13                  (0x002000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD2HTR_HTR_14                  (0x004000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD2HTR_HTR_15                  (0x008000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD2HTR_HTR_16                  (0x010000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD2HTR_HTR_17                  (0x020000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD2HTR_HTR_18                  (0x040000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD2HTR_HTR_19                  (0x080000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD2HTR_HTR_20                  (0x100000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD2HTR_HTR_21                  (0x200000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD2HTR_HTR_22                  (0x400000UL << ADC_AWD2HTR_HTR_Pos)     /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD3TR_LT register  *******************/
#define ADC_AWD3LTR_LTR_Pos                 (0U)
#define ADC_AWD3LTR_LTR_Msk                 (0x007FFFFFUL << ADC_AWD3LTR_LTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD3LTR_LTR                     ADC_AWD3LTR_LTR_Msk                     /*!< ADC analog watchdog 3 threshold low */
#define ADC_AWD3LTR_LTR_0                   (0x000001UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD3LTR_LTR_1                   (0x000002UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD3LTR_LTR_2                   (0x000004UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD3LTR_LTR_3                   (0x000008UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD3LTR_LTR_4                   (0x000010UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD3LTR_LTR_5                   (0x000020UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD3LTR_LTR_6                   (0x000040UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD3LTR_LTR_7                   (0x000080UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD3LTR_LTR_8                   (0x000100UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD3LTR_LTR_9                   (0x000200UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD3LTR_LTR_10                  (0x000400UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD3LTR_LTR_11                  (0x000800UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD3LTR_LTR_12                  (0x001000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD3LTR_LTR_13                  (0x002000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD3LTR_LTR_14                  (0x004000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD3LTR_LTR_15                  (0x008000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD3LTR_LTR_16                  (0x010000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD3LTR_LTR_17                  (0x020000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD3LTR_LTR_18                  (0x040000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD3LTR_LTR_19                  (0x080000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD3LTR_LTR_20                  (0x100000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD3LTR_LTR_21                  (0x200000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD3LTR_LTR_22                  (0x400000UL << ADC_AWD3LTR_LTR_Pos)     /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD3TR_HT register  *******************/
#define ADC_AWD3HTR_HTR_Pos                 (0U)
#define ADC_AWD3HTR_HTR_Msk                 (0x007FFFFFUL << ADC_AWD3HTR_HTR_Pos)   /*!< 0x007FFFFF */
#define ADC_AWD3HTR_HTR                     ADC_AWD3HTR_HTR_Msk                     /*!< ADC analog watchdog 3 threshold high */
#define ADC_AWD3HTR_HTR_0                   (0x000001UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000001 */
#define ADC_AWD3HTR_HTR_1                   (0x000002UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000002 */
#define ADC_AWD3HTR_HTR_2                   (0x000004UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000004 */
#define ADC_AWD3HTR_HTR_3                   (0x000008UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000008 */
#define ADC_AWD3HTR_HTR_4                   (0x000010UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000010 */
#define ADC_AWD3HTR_HTR_5                   (0x000020UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000020 */
#define ADC_AWD3HTR_HTR_6                   (0x000040UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000040 */
#define ADC_AWD3HTR_HTR_7                   (0x000080UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000080 */
#define ADC_AWD3HTR_HTR_8                   (0x000100UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000100 */
#define ADC_AWD3HTR_HTR_9                   (0x000200UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000200 */
#define ADC_AWD3HTR_HTR_10                  (0x000400UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000400 */
#define ADC_AWD3HTR_HTR_11                  (0x000800UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00000800 */
#define ADC_AWD3HTR_HTR_12                  (0x001000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00001000 */
#define ADC_AWD3HTR_HTR_13                  (0x002000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00002000 */
#define ADC_AWD3HTR_HTR_14                  (0x004000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00004000 */
#define ADC_AWD3HTR_HTR_15                  (0x008000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00008000 */
#define ADC_AWD3HTR_HTR_16                  (0x010000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00010000 */
#define ADC_AWD3HTR_HTR_17                  (0x020000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00020000 */
#define ADC_AWD3HTR_HTR_18                  (0x040000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00040000 */
#define ADC_AWD3HTR_HTR_19                  (0x080000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00080000 */
#define ADC_AWD3HTR_HTR_20                  (0x100000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00100000 */
#define ADC_AWD3HTR_HTR_21                  (0x200000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00200000 */
#define ADC_AWD3HTR_HTR_22                  (0x400000UL << ADC_AWD3HTR_HTR_Pos)     /*!< 0x00400000 */

/********************  Bit definition for ADC_DIFSEL register  ****************/
#define ADC_DIFSEL_DIFSEL_Pos               (0U)
#define ADC_DIFSEL_DIFSEL_Msk               (0xFFFFFUL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL                   ADC_DIFSEL_DIFSEL_Msk                   /*!< ADC channel differential or single-ended mode selection */
#define ADC_DIFSEL_DIFSEL_0                 (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1                 (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2                 (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3                 (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4                 (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5                 (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6                 (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7                 (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8                 (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9                 (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10                (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11                (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12                (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13                (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14                (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15                (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16                (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17                (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18                (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19                (0x80000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ***************/

#define ADC_CALFACT_CALFACT_Pos             (0U)
#define ADC_CALFACT_CALFACT_Msk             (0x7FUL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x0000007F */
#define ADC_CALFACT_CALFACT                 ADC_CALFACT_CALFACT_Msk                 /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_0               (0x01UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_1               (0x02UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_2               (0x04UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_3               (0x08UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_4               (0x10UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_5               (0x20UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_6               (0x40UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000040 */
#define ADC_CALFACT_CALFACT_7               (0x80UL << ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000080 */
#define ADC_CALFACT_CALFACT_8               (0x100UL<< ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000100 */
#define ADC_CALFACT_CALFACT_9               (0x200UL<< ADC_CALFACT_CALFACT_Pos)     /*!< 0x00000200 */


/********************  Bit definition for ADC_OR option register  ***************/
#define ADC_OR_VDDCOREEN_Pos                (0U)
#define ADC_OR_VDDCOREEN_Msk                (0x1UL << ADC_OR_VDDCOREEN_Pos)         /*!< 0x00000004 */
#define ADC_OR_VDDCOREEN                    ADC_OR_VDDCOREEN_Msk                    /*!< ADC internal path to VDDCORE */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  *******************/
#define ADC_CSR_ADRDY_MST_Pos               (0U)
#define ADC_CSR_ADRDY_MST_Msk               (0x1UL << ADC_CSR_ADRDY_MST_Pos)        /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST                   ADC_CSR_ADRDY_MST_Msk                   /*!< ADC multimode master ready flag */
#define ADC_CSR_EOSMP_MST_Pos               (1U)
#define ADC_CSR_EOSMP_MST_Msk               (0x1UL << ADC_CSR_EOSMP_MST_Pos)        /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST                   ADC_CSR_EOSMP_MST_Msk                   /*!< ADC multimode master group regular end of sampling flag */
#define ADC_CSR_EOC_MST_Pos                 (2U)
#define ADC_CSR_EOC_MST_Msk                 (0x1UL << ADC_CSR_EOC_MST_Pos)          /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                     ADC_CSR_EOC_MST_Msk                     /*!< ADC multimode master group regular end of unitary conversion flag */
#define ADC_CSR_EOS_MST_Pos                 (3U)
#define ADC_CSR_EOS_MST_Msk                 (0x1UL << ADC_CSR_EOS_MST_Pos)          /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                     ADC_CSR_EOS_MST_Msk                     /*!< ADC multimode master group regular end of sequence conversions flag */
#define ADC_CSR_OVR_MST_Pos                 (4U)
#define ADC_CSR_OVR_MST_Msk                 (0x1UL << ADC_CSR_OVR_MST_Pos)          /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                     ADC_CSR_OVR_MST_Msk                     /*!< ADC multimode master group regular overrun flag */
#define ADC_CSR_JEOC_MST_Pos                (5U)
#define ADC_CSR_JEOC_MST_Msk                (0x1UL << ADC_CSR_JEOC_MST_Pos)         /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST                    ADC_CSR_JEOC_MST_Msk                    /*!< ADC multimode master group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_MST_Pos                (6U)
#define ADC_CSR_JEOS_MST_Msk                (0x1UL << ADC_CSR_JEOS_MST_Pos)         /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST                    ADC_CSR_JEOS_MST_Msk                    /*!< ADC multimode master group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_MST_Pos                (7U)
#define ADC_CSR_AWD1_MST_Msk                (0x1UL << ADC_CSR_AWD1_MST_Pos)         /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST                    ADC_CSR_AWD1_MST_Msk                    /*!< ADC multimode master analog watchdog 1 flag */
#define ADC_CSR_AWD2_MST_Pos                (8U)
#define ADC_CSR_AWD2_MST_Msk                (0x1UL << ADC_CSR_AWD2_MST_Pos)         /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST                    ADC_CSR_AWD2_MST_Msk                    /*!< ADC multimode master analog watchdog 2 flag */
#define ADC_CSR_AWD3_MST_Pos                (9U)
#define ADC_CSR_AWD3_MST_Msk                (0x1UL << ADC_CSR_AWD3_MST_Pos)         /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST                    ADC_CSR_AWD3_MST_Msk                    /*!< ADC multimode master analog watchdog 3 flag */
#define ADC_CSR_JQOVF_MST_Pos               (10U)
#define ADC_CSR_JQOVF_MST_Msk               (0x1UL << ADC_CSR_JQOVF_MST_Pos)        /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST                   ADC_CSR_JQOVF_MST_Msk                   /*!< ADC multimode master group injected contexts queue overflow flag */
#define ADC_CSR_LDORDY_MST_Pos              (12U)
#define ADC_CSR_LDORDY_MST_Msk              (0x1UL << ADC_CSR_LDORDY_MST_Pos)       /*!< 0x00001000 */
#define ADC_CSR_LDORDY_MST                  ADC_CSR_LDORDY_MST_Msk                  /*!< ADC multimode master internal voltage regulator output ready flag */

#define ADC_CSR_ADRDY_SLV_Pos               (16U)
#define ADC_CSR_ADRDY_SLV_Msk               (0x1UL << ADC_CSR_ADRDY_SLV_Pos)        /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV                   ADC_CSR_ADRDY_SLV_Msk                   /*!< ADC multimode slave ready flag */
#define ADC_CSR_EOSMP_SLV_Pos               (17U)
#define ADC_CSR_EOSMP_SLV_Msk               (0x1UL << ADC_CSR_EOSMP_SLV_Pos)        /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV                   ADC_CSR_EOSMP_SLV_Msk                   /*!< ADC multimode slave group regular end of sampling flag */
#define ADC_CSR_EOC_SLV_Pos                 (18U)
#define ADC_CSR_EOC_SLV_Msk                 (0x1UL << ADC_CSR_EOC_SLV_Pos)          /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                     ADC_CSR_EOC_SLV_Msk                     /*!< ADC multimode slave group regular end of unitary conversion flag */
#define ADC_CSR_EOS_SLV_Pos                 (19U)
#define ADC_CSR_EOS_SLV_Msk                 (0x1UL << ADC_CSR_EOS_SLV_Pos)           /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                     ADC_CSR_EOS_SLV_Msk                     /*!< ADC multimode slave group regular end of sequence conversions flag */
#define ADC_CSR_OVR_SLV_Pos                 (20U)
#define ADC_CSR_OVR_SLV_Msk                 (0x1UL << ADC_CSR_OVR_SLV_Pos)          /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                     ADC_CSR_OVR_SLV_Msk                     /*!< ADC multimode slave group regular overrun flag */
#define ADC_CSR_JEOC_SLV_Pos                (21U)
#define ADC_CSR_JEOC_SLV_Msk                (0x1UL << ADC_CSR_JEOC_SLV_Pos)         /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV                    ADC_CSR_JEOC_SLV_Msk                    /*!< ADC multimode slave group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_SLV_Pos                (22U)
#define ADC_CSR_JEOS_SLV_Msk                (0x1UL << ADC_CSR_JEOS_SLV_Pos)         /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV                    ADC_CSR_JEOS_SLV_Msk                    /*!< ADC multimode slave group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_SLV_Pos                (23U)
#define ADC_CSR_AWD1_SLV_Msk                (0x1UL << ADC_CSR_AWD1_SLV_Pos)         /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV                    ADC_CSR_AWD1_SLV_Msk                    /*!< ADC multimode slave analog watchdog 1 flag */
#define ADC_CSR_AWD2_SLV_Pos                (24U)
#define ADC_CSR_AWD2_SLV_Msk                (0x1UL << ADC_CSR_AWD2_SLV_Pos)         /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV                    ADC_CSR_AWD2_SLV_Msk                    /*!< ADC multimode slave analog watchdog 2 flag */
#define ADC_CSR_AWD3_SLV_Pos                (25U)
#define ADC_CSR_AWD3_SLV_Msk                (0x1UL << ADC_CSR_AWD3_SLV_Pos)         /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV                    ADC_CSR_AWD3_SLV_Msk                    /*!< ADC multimode slave analog watchdog 3 flag */
#define ADC_CSR_JQOVF_SLV_Pos               (26U)
#define ADC_CSR_JQOVF_SLV_Msk               (0x1UL << ADC_CSR_JQOVF_SLV_Pos)        /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV                   ADC_CSR_JQOVF_SLV_Msk                   /*!< ADC multimode slave group injected contexts queue overflow flag */
#define ADC_CSR_LDORDY_SLV_Pos              (28U)
#define ADC_CSR_LDORDY_SLV_Msk              (0x1UL << ADC_CSR_LDORDY_SLV_Pos)       /*!< 0x10000000 */
#define ADC_CSR_LDORDY_SLV                  ADC_CSR_LDORDY_SLV_Msk                  /*!< ADC multimode slave internal voltage regulator output ready flag */

/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_DUAL_Pos                    (0U)
#define ADC_CCR_DUAL_Msk                    (0x1FUL << ADC_CCR_DUAL_Pos)            /*!< 0x0000001F */
#define ADC_CCR_DUAL                        ADC_CCR_DUAL_Msk                        /*!< ADC multimode mode selection */
#define ADC_CCR_DUAL_0                      (0x01UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                      (0x02UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                      (0x04UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                      (0x08UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                      (0x10UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos                   (8U)
#define ADC_CCR_DELAY_Msk                   (0xFUL << ADC_CCR_DELAY_Pos)            /*!< 0x00000F00 */
#define ADC_CCR_DELAY                       ADC_CCR_DELAY_Msk                       /*!< ADC multimode delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                     (0x1UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                     (0x2UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                     (0x4UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                     (0x8UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000800 */

#define ADC_CCR_DAMDF_Pos                   (14U)
#define ADC_CCR_DAMDF_Msk                   (0x3UL << ADC_CCR_DAMDF_Pos)            /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                       ADC_CCR_DAMDF_Msk                       /*!< ADC multimode data format */
#define ADC_CCR_DAMDF_0                     (0x1UL << ADC_CCR_DAMDF_Pos)            /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                     (0x2UL << ADC_CCR_DAMDF_Pos)            /*!< 0x00008000 */

#define ADC_CCR_PRESC_Pos                   (18U)
#define ADC_CCR_PRESC_Msk                   (0xFUL << ADC_CCR_PRESC_Pos)            /*!< 0x003C0000 */
#define ADC_CCR_PRESC                       ADC_CCR_PRESC_Msk                       /*!< ADC common clock prescaler */
#define ADC_CCR_PRESC_0                     (0x1UL << ADC_CCR_PRESC_Pos)            /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                     (0x2UL << ADC_CCR_PRESC_Pos)            /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                     (0x4UL << ADC_CCR_PRESC_Pos)            /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                     (0x8UL << ADC_CCR_PRESC_Pos)            /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos                  (22U)
#define ADC_CCR_VREFEN_Msk                  (0x1UL << ADC_CCR_VREFEN_Pos)           /*!< 0x00400000 */
#define ADC_CCR_VREFEN                      ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */

#define ADC_CCR_TSEN_Pos                    (23U)
#define ADC_CCR_TSEN_Msk                    (0x1UL << ADC_CCR_TSEN_Pos)             /*!< 0x00800000 */
#define ADC_CCR_TSEN                        ADC_CCR_TSEN_Msk                        /*!< ADC internal path to Temperature sensor voltage enable */

#define ADC_CCR_VBATEN_Pos                  (24U)
#define ADC_CCR_VBATEN_Msk                  (0x1UL << ADC_CCR_VBATEN_Pos)           /*!< 0x01000000 */
#define ADC_CCR_VBATEN                      ADC_CCR_VBATEN_Msk                      /*!< ADC internal path to battery voltage enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos               (0U)
#define ADC_CDR_RDATA_MST_Msk               (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST                   ADC_CDR_RDATA_MST_Msk                   /*!< ADC multimode master group regular conversion data */

#define ADC_CDR_RDATA_SLV_Pos               (16U)
#define ADC_CDR_RDATA_SLV_Msk               (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV                   ADC_CDR_RDATA_SLV_Msk                   /*!< ADC multimode slave group regular conversion data */

/********************  Bit definition for ADC_CDR2 register  ******************/
#define ADC_CDR2_RDATA_ALT_Pos              (0U)
#define ADC_CDR2_RDATA_ALT_Msk              (0xFFFFFFFFUL << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT                  ADC_CDR2_RDATA_ALT_Msk                   /*!< ADC multimode master or slave (alternated) group regular conversion data */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos                       (0U)
#define CRC_DR_DR_Msk                       (0xFFFFFFFFUL << CRC_DR_DR_Pos)         /*!< 0xFFFFFFFF */
#define CRC_DR_DR                           CRC_DR_DR_Msk                           /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos                     (0U)
#define CRC_IDR_IDR_Msk                     (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)       /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR                         CRC_IDR_IDR_Msk                         /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos                    (0U)
#define CRC_CR_RESET_Msk                    (0x1UL << CRC_CR_RESET_Pos)             /*!< 0x00000001 */
#define CRC_CR_RESET                        CRC_CR_RESET_Msk                        /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos                 (3U)
#define CRC_CR_POLYSIZE_Msk                 (0x3UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000018 */
#define CRC_CR_POLYSIZE                     CRC_CR_POLYSIZE_Msk                     /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0                   (0x1UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1                   (0x2UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos                   (5U)
#define CRC_CR_REV_IN_Msk                   (0x3UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000060 */
#define CRC_CR_REV_IN                       CRC_CR_REV_IN_Msk                       /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0                     (0x1UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000020 */
#define CRC_CR_REV_IN_1                     (0x2UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos                  (7U)
#define CRC_CR_REV_OUT_Msk                  (0x3UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000180 */
#define CRC_CR_REV_OUT                      CRC_CR_REV_OUT_Msk                      /*!< REV_OUT Reverse Output Data bits */
#define CRC_CR_REV_OUT_0                    (0x1UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000080 */
#define CRC_CR_REV_OUT_1                    (0x2UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000100 */
#define CRC_CR_RTYPE_IN_Pos                 (9U)
#define CRC_CR_RTYPE_IN_Msk                 (0x1UL << CRC_CR_RTYPE_IN_Pos)          /*!< 0x00000200 */
#define CRC_CR_RTYPE_IN                     CRC_CR_RTYPE_IN_Msk                     /*!< RTYPE_IN Reverse Type Input bit */
#define CRC_CR_RTYPE_OUT_Pos                (10U)
#define CRC_CR_RTYPE_OUT_Msk                (0x1UL << CRC_CR_RTYPE_OUT_Pos)         /*!< 0x00000400 */
#define CRC_CR_RTYPE_OUT                    CRC_CR_RTYPE_OUT_Msk                    /*!< RTYPE_OUT Reverse Type Output bit */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos                   (0U)
#define CRC_INIT_INIT_Msk                   (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)     /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT                       CRC_INIT_INIT_Msk                       /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos                     (0U)
#define CRC_POL_POL_Msk                     (0xFFFFFFFFUL << CRC_POL_POL_Pos)       /*!< 0xFFFFFFFF */
#define CRC_POL_POL                         CRC_POL_POL_Msk                         /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/
/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos                 (0U)
#define CRS_CR_SYNCOKIE_Msk                 (0x1UL << CRS_CR_SYNCOKIE_Pos)          /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE                     CRS_CR_SYNCOKIE_Msk                     /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos               (1U)
#define CRS_CR_SYNCWARNIE_Msk               (0x1UL << CRS_CR_SYNCWARNIE_Pos)        /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE                   CRS_CR_SYNCWARNIE_Msk                   /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos                    (2U)
#define CRS_CR_ERRIE_Msk                    (0x1UL << CRS_CR_ERRIE_Pos)             /*!< 0x00000004 */
#define CRS_CR_ERRIE                        CRS_CR_ERRIE_Msk                        /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos                  (3U)
#define CRS_CR_ESYNCIE_Msk                  (0x1UL << CRS_CR_ESYNCIE_Pos)           /*!< 0x00000008 */
#define CRS_CR_ESYNCIE                      CRS_CR_ESYNCIE_Msk                      /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos                      (5U)
#define CRS_CR_CEN_Msk                      (0x1UL << CRS_CR_CEN_Pos)               /*!< 0x00000020 */
#define CRS_CR_CEN                          CRS_CR_CEN_Msk                          /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos               (6U)
#define CRS_CR_AUTOTRIMEN_Msk               (0x1UL << CRS_CR_AUTOTRIMEN_Pos)        /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN                   CRS_CR_AUTOTRIMEN_Msk                   /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos                   (7U)
#define CRS_CR_SWSYNC_Msk                   (0x1UL << CRS_CR_SWSYNC_Pos)            /*!< 0x00000080 */
#define CRS_CR_SWSYNC                       CRS_CR_SWSYNC_Msk                       /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos                     (8U)
#define CRS_CR_TRIM_Msk                     (0x7FUL << CRS_CR_TRIM_Pos)             /*!< 0x00003F00 */
#define CRS_CR_TRIM                         CRS_CR_TRIM_Msk                         /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos                 (0U)
#define CRS_CFGR_RELOAD_Msk                 (0xFFFFUL << CRS_CFGR_RELOAD_Pos)       /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD                     CRS_CFGR_RELOAD_Msk                     /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos                  (16U)
#define CRS_CFGR_FELIM_Msk                  (0xFFUL << CRS_CFGR_FELIM_Pos)          /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM                      CRS_CFGR_FELIM_Msk                      /*!< Frequency error limit */
#define CRS_CFGR_SYNCDIV_Pos                (24U)
#define CRS_CFGR_SYNCDIV_Msk                (0x7UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV                    CRS_CFGR_SYNCDIV_Msk                    /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0                  (0x1UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1                  (0x2UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2                  (0x4UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x04000000 */
#define CRS_CFGR_SYNCSRC_Pos                (28U)
#define CRS_CFGR_SYNCSRC_Msk                (0x3UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC                    CRS_CFGR_SYNCSRC_Msk                    /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0                  (0x1UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1                  (0x2UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x20000000 */
#define CRS_CFGR_SYNCPOL_Pos                (31U)
#define CRS_CFGR_SYNCPOL_Msk                (0x1UL << CRS_CFGR_SYNCPOL_Pos)         /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL                    CRS_CFGR_SYNCPOL_Msk                    /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos                 (0U)
#define CRS_ISR_SYNCOKF_Msk                 (0x1UL << CRS_ISR_SYNCOKF_Pos)          /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF                     CRS_ISR_SYNCOKF_Msk                     /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos               (1U)
#define CRS_ISR_SYNCWARNF_Msk               (0x1UL << CRS_ISR_SYNCWARNF_Pos)        /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF                   CRS_ISR_SYNCWARNF_Msk                   /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos                    (2U)
#define CRS_ISR_ERRF_Msk                    (0x1UL << CRS_ISR_ERRF_Pos)             /*!< 0x00000004 */
#define CRS_ISR_ERRF                        CRS_ISR_ERRF_Msk                        /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos                  (3U)
#define CRS_ISR_ESYNCF_Msk                  (0x1UL << CRS_ISR_ESYNCF_Pos)           /*!< 0x00000008 */
#define CRS_ISR_ESYNCF                      CRS_ISR_ESYNCF_Msk                      /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos                 (8U)
#define CRS_ISR_SYNCERR_Msk                 (0x1UL << CRS_ISR_SYNCERR_Pos)          /*!< 0x00000100 */
#define CRS_ISR_SYNCERR                     CRS_ISR_SYNCERR_Msk                     /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos                (9U)
#define CRS_ISR_SYNCMISS_Msk                (0x1UL << CRS_ISR_SYNCMISS_Pos)         /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS                    CRS_ISR_SYNCMISS_Msk                    /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos                 (10U)
#define CRS_ISR_TRIMOVF_Msk                 (0x1UL << CRS_ISR_TRIMOVF_Pos)          /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF                     CRS_ISR_TRIMOVF_Msk                     /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos                   (15U)
#define CRS_ISR_FEDIR_Msk                   (0x1UL << CRS_ISR_FEDIR_Pos)            /*!< 0x00008000 */
#define CRS_ISR_FEDIR                       CRS_ISR_FEDIR_Msk                       /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos                   (16U)
#define CRS_ISR_FECAP_Msk                   (0xFFFFUL << CRS_ISR_FECAP_Pos)         /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP                       CRS_ISR_FECAP_Msk                       /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos                 (0U)
#define CRS_ICR_SYNCOKC_Msk                 (0x1UL << CRS_ICR_SYNCOKC_Pos)          /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC                     CRS_ICR_SYNCOKC_Msk                     /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos               (1U)
#define CRS_ICR_SYNCWARNC_Msk               (0x1UL << CRS_ICR_SYNCWARNC_Pos)        /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC                   CRS_ICR_SYNCWARNC_Msk                   /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos                    (2U)
#define CRS_ICR_ERRC_Msk                    (0x1UL << CRS_ICR_ERRC_Pos)             /*!< 0x00000004 */
#define CRS_ICR_ERRC                        CRS_ICR_ERRC_Msk                        /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos                  (3U)
#define CRS_ICR_ESYNCC_Msk                  (0x1UL << CRS_ICR_ESYNCC_Pos)           /*!< 0x00000008 */
#define CRS_ICR_ESYNCC                      CRS_ICR_ESYNCC_Msk                      /*!< Expected SYNC clear flag */

/******************************************************************************/
/*                                                                            */
/*                      Analog Comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/
/*!< ******************  Bit definition for COMPx_CSR register  ********************/
#define COMP_CSR_EN_Pos                     (0U)
#define COMP_CSR_EN_Msk                     (0x1UL << COMP_CSR_EN_Pos)              /*!< 0x00000001 */
#define COMP_CSR_EN                         COMP_CSR_EN_Msk                         /*!< COMPx enable bit */
#define COMP_CSR_INMSEL_Pos                 (4U)
#define COMP_CSR_INMSEL_Msk                 (0xFUL << COMP_CSR_INMSEL_Pos)          /*!< 0x00070000 */
#define COMP_CSR_INMSEL                     COMP_CSR_INMSEL_Msk                     /*!< COMPx input minus selection bit  */
#define COMP_CSR_INMSEL_0                   (0x1UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00010000 */
#define COMP_CSR_INMSEL_1                   (0x2UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00020000 */
#define COMP_CSR_INMSEL_2                   (0x4UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00040000 */
#define COMP_CSR_INMSEL_3                   (0x8UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00080000 */
#define COMP_CSR_INPSEL_Pos                 (8U)
#define COMP_CSR_INPSEL_Msk                 (0x3UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00100000 */
#define COMP_CSR_INPSEL                     COMP_CSR_INPSEL_Msk                     /*!< COMPx input plus selection bit */
#define COMP_CSR_INPSEL_0                   (0x1UL << COMP_CSR_INPSEL_Pos)
#define COMP_CSR_INPSEL_1                   (0x2UL << COMP_CSR_INPSEL_Pos)
#define COMP_CSR_WINMODE_Pos                (11U)
#define COMP_CSR_WINMODE_Msk                (0x1UL << COMP_CSR_WINMODE_Pos)         /*!< 0x00000010 */
#define COMP_CSR_WINMODE                    COMP_CSR_WINMODE_Msk                    /*!< COMPx Windows mode selection bit */
#define COMP_CSR_WINOUT_Pos                 (14U)
#define COMP_CSR_WINOUT_Msk                 (0x1UL << COMP_CSR_WINOUT_Pos)          /*!< 0x00000008 */
#define COMP_CSR_WINOUT                     COMP_CSR_WINOUT_Msk                     /*!< COMPx polarity selection bit */
#define COMP_CSR_POLARITY_Pos               (15U)
#define COMP_CSR_POLARITY_Msk               (0x1UL << COMP_CSR_POLARITY_Pos)        /*!< 0x00000008 */
#define COMP_CSR_POLARITY                   COMP_CSR_POLARITY_Msk                   /*!< COMPx polarity selection bit */
#define COMP_CSR_HYST_Pos                   (16U)
#define COMP_CSR_HYST_Msk                   (0x3UL << COMP_CSR_HYST_Pos)            /*!< 0x00000300 */
#define COMP_CSR_HYST                       COMP_CSR_HYST_Msk                       /*!< COMPx hysteresis selection bits */
#define COMP_CSR_HYST_0                     (0x1UL << COMP_CSR_HYST_Pos)            /*!< 0x00000100 */
#define COMP_CSR_HYST_1                     (0x2UL << COMP_CSR_HYST_Pos)            /*!< 0x00000200 */
#define COMP_CSR_PWRMODE_Pos                (18U)
#define COMP_CSR_PWRMODE_Msk                (0x3UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00003000 */
#define COMP_CSR_PWRMODE                    COMP_CSR_PWRMODE_Msk                    /*!< COMPx Power Mode of the comparator */
#define COMP_CSR_PWRMODE_0                  (0x1UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00001000 */
#define COMP_CSR_PWRMODE_1                  (0x2UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00002000 */
#define COMP_CSR_BLANKSEL_Pos               (20U)
#define COMP_CSR_BLANKSEL_Msk               (0x1FUL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x0F000000 */
#define COMP_CSR_BLANKSEL                   COMP_CSR_BLANKSEL_Msk                   /*!< COMPx blanking source selection bits */
#define COMP_CSR_BLANKSEL_0                 (0x1UL << COMP_CSR_BLANKSEL_Pos)        /*!< 0x01000000 */
#define COMP_CSR_BLANKSEL_1                 (0x2UL << COMP_CSR_BLANKSEL_Pos)        /*!< 0x02000000 */
#define COMP_CSR_BLANKSEL_2                 (0x4UL << COMP_CSR_BLANKSEL_Pos)        /*!< 0x04000000 */
#define COMP_CSR_BLANKSEL_3                 (0x8UL << COMP_CSR_BLANKSEL_Pos)        /*!< 0x08000000 */
#define COMP_CSR_BLANKSEL_4                 (0x10UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x01000000 */
#define COMP_CSR_VALUE_Pos                  (30U)
#define COMP_CSR_VALUE_Msk                  (0x1UL << COMP_CSR_VALUE_Pos)           /*!< 0x00000001 */
#define COMP_CSR_VALUE                      COMP_CSR_VALUE_Msk                      /*!< COMPx enable bit */
#define COMP_CSR_LOCK_Pos                   (31U)
#define COMP_CSR_LOCK_Msk                   (0x1UL << COMP_CSR_LOCK_Pos)            /*!< 0x80000000 */
#define COMP_CSR_LOCK                       COMP_CSR_LOCK_Msk                       /*!< COMPx Lock Bit */

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
#define DAC_CHANNEL2_SUPPORT                                                        /*!< DAC feature available only on specific devices: DAC channel 2 available */

/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos                      (0U)
#define DAC_CR_EN1_Msk                      (0x1UL << DAC_CR_EN1_Pos)               /*!< 0x00000001 */
#define DAC_CR_EN1                          DAC_CR_EN1_Msk                          /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos                     (1U)
#define DAC_CR_TEN1_Msk                     (0x1UL << DAC_CR_TEN1_Pos)              /*!< 0x00000002 */
#define DAC_CR_TEN1                         DAC_CR_TEN1_Msk                         /*!<DAC channel1 Trigger enable */
#define DAC_CR_TSEL1_Pos                    (2U)
#define DAC_CR_TSEL1_Msk                    (0xFUL << DAC_CR_TSEL1_Pos)             /*!< 0x0000003C */
#define DAC_CR_TSEL1                        DAC_CR_TSEL1_Msk                        /*!<TSEL1[3:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0                      (0x1UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000004 */
#define DAC_CR_TSEL1_1                      (0x2UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000008 */
#define DAC_CR_TSEL1_2                      (0x4UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000010 */
#define DAC_CR_TSEL1_3                      (0x8UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000020 */
#define DAC_CR_WAVE1_Pos                    (6U)
#define DAC_CR_WAVE1_Msk                    (0x3UL << DAC_CR_WAVE1_Pos)             /*!< 0x000000C0 */
#define DAC_CR_WAVE1                        DAC_CR_WAVE1_Msk                        /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0                      (0x1UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000040 */
#define DAC_CR_WAVE1_1                      (0x2UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000080 */
#define DAC_CR_MAMP1_Pos                    (8U)
#define DAC_CR_MAMP1_Msk                    (0xFUL << DAC_CR_MAMP1_Pos)             /*!< 0x00000F00 */
#define DAC_CR_MAMP1                        DAC_CR_MAMP1_Msk                        /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0                      (0x1UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000100 */
#define DAC_CR_MAMP1_1                      (0x2UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000200 */
#define DAC_CR_MAMP1_2                      (0x4UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000400 */
#define DAC_CR_MAMP1_3                      (0x8UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000800 */
#define DAC_CR_DMAEN1_Pos                   (12U)
#define DAC_CR_DMAEN1_Msk                   (0x1UL << DAC_CR_DMAEN1_Pos)            /*!< 0x00001000 */
#define DAC_CR_DMAEN1                       DAC_CR_DMAEN1_Msk                       /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos                (13U)
#define DAC_CR_DMAUDRIE1_Msk                (0x1UL << DAC_CR_DMAUDRIE1_Pos)         /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1                    DAC_CR_DMAUDRIE1_Msk                    /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos                     (14U)
#define DAC_CR_CEN1_Msk                     (0x1UL << DAC_CR_CEN1_Pos)              /*!< 0x00004000 */
#define DAC_CR_CEN1                         DAC_CR_CEN1_Msk                         /*!<DAC channel 1 calibration enable >*/
#define DAC_CR_EN2_Pos                      (16U)
#define DAC_CR_EN2_Msk                      (0x1UL << DAC_CR_EN2_Pos)               /*!< 0x00010000 */
#define DAC_CR_EN2                          DAC_CR_EN2_Msk                          /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos                     (17U)
#define DAC_CR_TEN2_Msk                     (0x1UL << DAC_CR_TEN2_Pos)              /*!< 0x00020000 */
#define DAC_CR_TEN2                         DAC_CR_TEN2_Msk                         /*!<DAC channel2 Trigger enable */
#define DAC_CR_TSEL2_Pos                    (18U)
#define DAC_CR_TSEL2_Msk                    (0xFUL << DAC_CR_TSEL2_Pos)             /*!< 0x003C0000 */
#define DAC_CR_TSEL2                        DAC_CR_TSEL2_Msk                        /*!<TSEL2[3:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0                      (0x1UL << DAC_CR_TSEL2_Pos)             /*!< 0x00040000 */
#define DAC_CR_TSEL2_1                      (0x2UL << DAC_CR_TSEL2_Pos)             /*!< 0x00080000 */
#define DAC_CR_TSEL2_2                      (0x4UL << DAC_CR_TSEL2_Pos)             /*!< 0x00100000 */
#define DAC_CR_TSEL2_3                      (0x8UL << DAC_CR_TSEL2_Pos)             /*!< 0x00200000 */
#define DAC_CR_WAVE2_Pos                    (22U)
#define DAC_CR_WAVE2_Msk                    (0x3UL << DAC_CR_WAVE2_Pos)             /*!< 0x00C00000 */
#define DAC_CR_WAVE2                        DAC_CR_WAVE2_Msk                        /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0                      (0x1UL << DAC_CR_WAVE2_Pos)             /*!< 0x00400000 */
#define DAC_CR_WAVE2_1                      (0x2UL << DAC_CR_WAVE2_Pos)             /*!< 0x00800000 */
#define DAC_CR_MAMP2_Pos                    (24U)
#define DAC_CR_MAMP2_Msk                    (0xFUL << DAC_CR_MAMP2_Pos)             /*!< 0x0F000000 */
#define DAC_CR_MAMP2                        DAC_CR_MAMP2_Msk                        /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0                      (0x1UL << DAC_CR_MAMP2_Pos)             /*!< 0x01000000 */
#define DAC_CR_MAMP2_1                      (0x2UL << DAC_CR_MAMP2_Pos)             /*!< 0x02000000 */
#define DAC_CR_MAMP2_2                      (0x4UL << DAC_CR_MAMP2_Pos)             /*!< 0x04000000 */
#define DAC_CR_MAMP2_3                      (0x8UL << DAC_CR_MAMP2_Pos)             /*!< 0x08000000 */
#define DAC_CR_DMAEN2_Pos                   (28U)
#define DAC_CR_DMAEN2_Msk                   (0x1UL << DAC_CR_DMAEN2_Pos)            /*!< 0x10000000 */
#define DAC_CR_DMAEN2                       DAC_CR_DMAEN2_Msk                       /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos                (29U)
#define DAC_CR_DMAUDRIE2_Msk                (0x1UL << DAC_CR_DMAUDRIE2_Pos)         /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2                    DAC_CR_DMAUDRIE2_Msk                    /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos                     (30U)
#define DAC_CR_CEN2_Msk                     (0x1UL << DAC_CR_CEN2_Pos)              /*!< 0x40000000 */
#define DAC_CR_CEN2                         DAC_CR_CEN2_Msk                         /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos             (0U)
#define DAC_SWTRIGR_SWTRIG1_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)      /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1                 DAC_SWTRIGR_SWTRIG1_Msk                 /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos             (1U)
#define DAC_SWTRIGR_SWTRIG2_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)      /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2                 DAC_SWTRIGR_SWTRIG2_Msk                 /*!<DAC channel2 software trigger */
#define DAC_SWTRIGR_SWTRIGB1_Pos            (16U)
#define DAC_SWTRIGR_SWTRIGB1_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB1_Pos)     /*!< 0x00010000 */
#define DAC_SWTRIGR_SWTRIGB1                DAC_SWTRIGR_SWTRIGB1_Msk                /*!<DAC channel1 software trigger B */
#define DAC_SWTRIGR_SWTRIGB2_Pos            (17U)
#define DAC_SWTRIGR_SWTRIGB2_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB2_Pos)     /*!< 0x00020000 */
#define DAC_SWTRIGR_SWTRIGB2                DAC_SWTRIGR_SWTRIGB2_Msk                /*!<DAC channel2 software trigger B */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos            (0U)
#define DAC_DHR12R1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR                DAC_DHR12R1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12R1_DACC1DHRB_Pos           (16U)
#define DAC_DHR12R1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12R1_DACC1DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R1_DACC1DHRB               DAC_DHR12R1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos            (4U)
#define DAC_DHR12L1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR                DAC_DHR12L1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12L1_DACC1DHRB_Pos           (20U)
#define DAC_DHR12L1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12L1_DACC1DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L1_DACC1DHRB               DAC_DHR12L1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos             (0U)
#define DAC_DHR8R1_DACC1DHR_Msk             (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR                 DAC_DHR8R1_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8R1_DACC1DHRB_Pos            (8U)
#define DAC_DHR8R1_DACC1DHRB_Msk            (0xFFUL << DAC_DHR8R1_DACC1DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R1_DACC1DHRB                DAC_DHR8R1_DACC1DHRB_Msk                /*!<DAC channel1 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos            (0U)
#define DAC_DHR12R2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR                DAC_DHR12R2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */
#define DAC_DHR12R2_DACC2DHRB_Pos           (16U)
#define DAC_DHR12R2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12R2_DACC2DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R2_DACC2DHRB               DAC_DHR12R2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos            (4U)
#define DAC_DHR12L2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR                DAC_DHR12L2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */
#define DAC_DHR12L2_DACC2DHRB_Pos           (20U)
#define DAC_DHR12L2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12L2_DACC2DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L2_DACC2DHRB               DAC_DHR12L2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos             (0U)
#define DAC_DHR8R2_DACC2DHR_Msk             (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR                 DAC_DHR8R2_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */
#define DAC_DHR8R2_DACC2DHRB_Pos            (8U)
#define DAC_DHR8R2_DACC2DHRB_Msk            (0xFFUL << DAC_DHR8R2_DACC2DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R2_DACC2DHRB                DAC_DHR8R2_DACC2DHRB_Msk                /*!<DAC channel2 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos            (0U)
#define DAC_DHR12RD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR                DAC_DHR12RD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos            (16U)
#define DAC_DHR12RD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos)   /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR                DAC_DHR12RD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos            (4U)
#define DAC_DHR12LD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR                DAC_DHR12LD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos            (20U)
#define DAC_DHR12LD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos)   /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR                DAC_DHR12LD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos             (0U)
#define DAC_DHR8RD_DACC1DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR                 DAC_DHR8RD_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos             (8U)
#define DAC_DHR8RD_DACC2DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)     /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR                 DAC_DHR8RD_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos               (0U)
#define DAC_DOR1_DACC1DOR_Msk               (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR                   DAC_DOR1_DACC1DOR_Msk                   /*!<DAC channel1 data output */
#define DAC_DOR1_DACC1DORB_Pos              (16U)
#define DAC_DOR1_DACC1DORB_Msk              (0xFFFUL << DAC_DOR1_DACC1DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR1_DACC1DORB                  DAC_DOR1_DACC1DORB_Msk                  /*!<DAC channel1 data output B */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos               (0U)
#define DAC_DOR2_DACC2DOR_Msk               (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR                   DAC_DOR2_DACC2DOR_Msk                   /*!<DAC channel2 data output */
#define DAC_DOR2_DACC2DORB_Pos              (16U)
#define DAC_DOR2_DACC2DORB_Msk              (0xFFFUL << DAC_DOR2_DACC2DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR2_DACC2DORB                  DAC_DOR2_DACC2DORB_Msk                  /*!<DAC channel2 data output B */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DAC1RDY_Pos                  (11U)
#define DAC_SR_DAC1RDY_Msk                  (0x1UL << DAC_SR_DAC1RDY_Pos)           /*!< 0x00000800 */
#define DAC_SR_DAC1RDY                      DAC_SR_DAC1RDY_Msk                      /*!<DAC channel 1 ready status bit */
#define DAC_SR_DORSTAT1_Pos                 (12U)
#define DAC_SR_DORSTAT1_Msk                 (0x1UL << DAC_SR_DORSTAT1_Pos)          /*!< 0x00001000 */
#define DAC_SR_DORSTAT1                     DAC_SR_DORSTAT1_Msk                     /*!<DAC channel 1 output register status bit */
#define DAC_SR_DMAUDR1_Pos                  (13U)
#define DAC_SR_DMAUDR1_Msk                  (0x1UL << DAC_SR_DMAUDR1_Pos)           /*!< 0x00002000 */
#define DAC_SR_DMAUDR1                      DAC_SR_DMAUDR1_Msk                      /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos                (14U)
#define DAC_SR_CAL_FLAG1_Msk                (0x1UL << DAC_SR_CAL_FLAG1_Pos)         /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1                    DAC_SR_CAL_FLAG1_Msk                    /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos                    (15U)
#define DAC_SR_BWST1_Msk                    (0x1UL << DAC_SR_BWST1_Pos)             /*!< 0x00008000 */
#define DAC_SR_BWST1                        DAC_SR_BWST1_Msk                        /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DAC2RDY_Pos                  (27U)
#define DAC_SR_DAC2RDY_Msk                  (0x1UL << DAC_SR_DAC2RDY_Pos)           /*!< 0x08000000 */
#define DAC_SR_DAC2RDY                      DAC_SR_DAC2RDY_Msk                      /*!<DAC channel 2 ready status bit */
#define DAC_SR_DORSTAT2_Pos                 (28U)
#define DAC_SR_DORSTAT2_Msk                 (0x1UL << DAC_SR_DORSTAT2_Pos)          /*!< 0x10000000 */
#define DAC_SR_DORSTAT2                     DAC_SR_DORSTAT2_Msk                     /*!<DAC channel 2 output register status bit */
#define DAC_SR_DMAUDR2_Pos                  (29U)
#define DAC_SR_DMAUDR2_Msk                  (0x1UL << DAC_SR_DMAUDR2_Pos)           /*!< 0x20000000 */
#define DAC_SR_DMAUDR2                      DAC_SR_DMAUDR2_Msk                      /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos                (30U)
#define DAC_SR_CAL_FLAG2_Msk                (0x1UL << DAC_SR_CAL_FLAG2_Pos)         /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2                    DAC_SR_CAL_FLAG2_Msk                    /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos                    (31U)
#define DAC_SR_BWST2_Msk                    (0x1UL << DAC_SR_BWST2_Pos)             /*!< 0x80000000 */
#define DAC_SR_BWST2                        DAC_SR_BWST2_Msk                        /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos                  (0U)
#define DAC_CCR_OTRIM1_Msk                  (0x1FUL << DAC_CCR_OTRIM1_Pos)          /*!< 0x0000001F */
#define DAC_CCR_OTRIM1                      DAC_CCR_OTRIM1_Msk                      /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos                  (16U)
#define DAC_CCR_OTRIM2_Msk                  (0x1FUL << DAC_CCR_OTRIM2_Pos)          /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2                      DAC_CCR_OTRIM2_Msk                      /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos                   (0U)
#define DAC_MCR_MODE1_Msk                   (0x7UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000007 */
#define DAC_MCR_MODE1                       DAC_MCR_MODE1_Msk                       /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0                     (0x1UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000001 */
#define DAC_MCR_MODE1_1                     (0x2UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000002 */
#define DAC_MCR_MODE1_2                     (0x4UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000004 */
#define DAC_MCR_DMADOUBLE1_Pos              (8U)
#define DAC_MCR_DMADOUBLE1_Msk              (0x1UL << DAC_MCR_DMADOUBLE1_Pos)       /*!< 0x00000100 */
#define DAC_MCR_DMADOUBLE1                  DAC_MCR_DMADOUBLE1_Msk                  /*!<DAC Channel 1 DMA double data mode */
#define DAC_MCR_SINFORMAT1_Pos              (9U)
#define DAC_MCR_SINFORMAT1_Msk              (0x1UL << DAC_MCR_SINFORMAT1_Pos)       /*!< 0x00000200 */
#define DAC_MCR_SINFORMAT1                  DAC_MCR_SINFORMAT1_Msk                  /*!<DAC Channel 1 enable signed format */
#define DAC_MCR_HFSEL_Pos                   (14U)
#define DAC_MCR_HFSEL_Msk                   (0x3UL << DAC_MCR_HFSEL_Pos)            /*!< 0x0000C000 */
#define DAC_MCR_HFSEL                       DAC_MCR_HFSEL_Msk                       /*!<HFSEL[1:0] (High Frequency interface mode selection) */
#define DAC_MCR_HFSEL_0                     (0x1UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00004000 */
#define DAC_MCR_HFSEL_1                     (0x2UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00008000 */
#define DAC_MCR_MODE2_Pos                   (16U)
#define DAC_MCR_MODE2_Msk                   (0x7UL << DAC_MCR_MODE2_Pos)            /*!< 0x00070000 */
#define DAC_MCR_MODE2                       DAC_MCR_MODE2_Msk                       /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0                     (0x1UL << DAC_MCR_MODE2_Pos)            /*!< 0x00010000 */
#define DAC_MCR_MODE2_1                     (0x2UL << DAC_MCR_MODE2_Pos)            /*!< 0x00020000 */
#define DAC_MCR_MODE2_2                     (0x4UL << DAC_MCR_MODE2_Pos)            /*!< 0x00040000 */
#define DAC_MCR_DMADOUBLE2_Pos              (24U)
#define DAC_MCR_DMADOUBLE2_Msk              (0x1UL << DAC_MCR_DMADOUBLE2_Pos)       /*!< 0x01000000 */
#define DAC_MCR_DMADOUBLE2                  DAC_MCR_DMADOUBLE2_Msk                  /*!<DAC Channel 2 DMA double data mode */
#define DAC_MCR_SINFORMAT2_Pos              (25U)
#define DAC_MCR_SINFORMAT2_Msk              (0x1UL << DAC_MCR_SINFORMAT2_Pos)       /*!< 0x02000000 */
#define DAC_MCR_SINFORMAT2                  DAC_MCR_SINFORMAT2_Msk                  /*!<DAC Channel 2 enable signed format */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos              (0U)
#define DAC_SHSR1_TSAMPLE1_Msk              (0x3FFUL << DAC_SHSR1_TSAMPLE1_Pos)     /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1                  DAC_SHSR1_TSAMPLE1_Msk                  /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR2_TSAMPLE2_Pos              (0U)
#define DAC_SHSR2_TSAMPLE2_Msk              (0x3FFUL << DAC_SHSR2_TSAMPLE2_Pos)     /*!< 0x000003FF */
#define DAC_SHSR2_TSAMPLE2                  DAC_SHSR2_TSAMPLE2_Msk                  /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos                 (0U)
#define DAC_SHHR_THOLD1_Msk                 (0x3FFUL << DAC_SHHR_THOLD1_Pos)        /*!< 0x000003FF */
#define DAC_SHHR_THOLD1                     DAC_SHHR_THOLD1_Msk                     /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos                 (16U)
#define DAC_SHHR_THOLD2_Msk                 (0x3FFUL << DAC_SHHR_THOLD2_Pos)        /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2                     DAC_SHHR_THOLD2_Msk                     /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos              (0U)
#define DAC_SHRR_TREFRESH1_Msk              (0xFFUL << DAC_SHRR_TREFRESH1_Pos)      /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1                  DAC_SHRR_TREFRESH1_Msk                  /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos              (16U)
#define DAC_SHRR_TREFRESH2_Msk              (0xFFUL << DAC_SHRR_TREFRESH2_Pos)      /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2                  DAC_SHRR_TREFRESH2_Msk                  /*!<DAC channel2 refresh time */

/******************  Bit definition for DAC_AUTOCR register  ******************/
#define DAC_AUTOCR_AUTOMODE_Pos             (22U)
#define DAC_AUTOCR_AUTOMODE_Msk             (0x1UL << DAC_AUTOCR_AUTOMODE_Pos)      /*!< 0x00400000 */
#define DAC_AUTOCR_AUTOMODE                 DAC_AUTOCR_AUTOMODE_Msk                 /*!< AUTOCR Enable */

/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos            (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk            (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos            (16U)
#define DBGMCU_IDCODE_REV_ID_Msk            (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_STOP_Pos              (1U)
#define DBGMCU_CR_DBG_STOP_Msk              (0x1UL << DBGMCU_CR_DBG_STOP_Pos)       /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                  DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos           (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk           (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos)    /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY               DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_TRACE_IOEN_Pos            (4U)
#define DBGMCU_CR_TRACE_IOEN_Msk            (0x1UL << DBGMCU_CR_TRACE_IOEN_Pos)     /*!< 0x00000010 */
#define DBGMCU_CR_TRACE_IOEN                DBGMCU_CR_TRACE_IOEN_Msk
#define DBGMCU_CR_TRACE_EN_Pos              (5U)
#define DBGMCU_CR_TRACE_EN_Msk              (0x1UL << DBGMCU_CR_TRACE_EN_Pos)       /*!< 0x00000020 */
#define DBGMCU_CR_TRACE_EN                  DBGMCU_CR_TRACE_EN_Msk
#define DBGMCU_CR_TRACE_MODE_Pos            (6U)
#define DBGMCU_CR_TRACE_MODE_Msk            (0x3UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                DBGMCU_CR_TRACE_MODE_Msk
#define DBGMCU_CR_TRACE_MODE_0              (0x1UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1              (0x2UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000080 */

/********************  Bit definition for DBGMCU_APB1FZR1 register  ***********/
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos   (0U)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP       DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos   (1U)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP       DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos   (2U)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP       DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos   (4U)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP       DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos   (5U)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP       DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos   (11U)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP       DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos   (12U)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP       DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos   (21U)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP       DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos   (22U)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP       DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP_Pos   (23U)
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I3C1_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I3C1_STOP       DBGMCU_APB1FZR1_DBG_I3C1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_RTC_STOP_Pos    (30U)
#define DBGMCU_APB1FZR1_DBG_RTC_STOP_Msk    (0x1UL << DBGMCU_APB1FZR1_DBG_RTC_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_RTC_STOP        DBGMCU_APB1FZR1_DBG_RTC_STOP_Msk

/********************  Bit definition for DBGMCU_APB1FZR2 register  ***********/
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos (5U)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk (0x1UL << DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP     DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk

/********************  Bit definition for DBGMCU_APB2FZR register  ***********/
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos    (11U)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP        DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos   (16U)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP       DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos   (17U)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP       DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos   (18U)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP       DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk
#define DBGMCU_APB2FZR_DBG_I3C2_STOP_Pos    (27U)
#define DBGMCU_APB2FZR_DBG_I3C2_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_I3C2_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_I3C2_STOP        DBGMCU_APB2FZR_DBG_I3C2_STOP_Msk

/********************  Bit definition for DBGMCU_APB3FZR register  ***********/
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos    (10U)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk    (0x1UL << DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP        DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos  (17U)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP      DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos  (18U)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP      DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos  (19U)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP      DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk

/********************  Bit definition for DBGMCU_AHB1FZR register  ***********/
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Pos  (0U)
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP      DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Pos  (1U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Pos  (2U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP      DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Pos  (3U)
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP      DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Pos  (4U)
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP      DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Pos  (5U)
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP      DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Pos  (6U)
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP      DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Pos  (7U)
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP      DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Pos  (8U)
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP      DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Pos  (9U)
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP      DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Pos (10U)
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP     DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Pos (11U)
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP     DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                        Delay Block Interface (DLYB)                        */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DLYB_CR register  ********************/
#define DLYB_CR_DEN_Pos                     (0U)
#define DLYB_CR_DEN_Msk                     (0x1UL << DLYB_CR_DEN_Pos)              /*!< 0x00000001 */
#define DLYB_CR_DEN                         DLYB_CR_DEN_Msk                         /*!<Delay Block enable */
#define DLYB_CR_SEN_Pos                     (1U)
#define DLYB_CR_SEN_Msk                     (0x1UL << DLYB_CR_SEN_Pos)              /*!< 0x00000002 */
#define DLYB_CR_SEN                         DLYB_CR_SEN_Msk                         /*!<Sampler length enable */

/*******************  Bit definition for DLYB_CFGR register  ********************/
#define DLYB_CFGR_SEL_Pos                   (0U)
#define DLYB_CFGR_SEL_Msk                   (0xFUL << DLYB_CFGR_SEL_Pos)            /*!< 0x0000000F */
#define DLYB_CFGR_SEL                       DLYB_CFGR_SEL_Msk                       /*!<Select the phase for the Output clock[3:0] */
#define DLYB_CFGR_SEL_0                     (0x1UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000001 */
#define DLYB_CFGR_SEL_1                     (0x2UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000002 */
#define DLYB_CFGR_SEL_2                     (0x3UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000003 */
#define DLYB_CFGR_SEL_3                     (0x8UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000008 */
#define DLYB_CFGR_UNIT_Pos                  (8U)
#define DLYB_CFGR_UNIT_Msk                  (0x7FUL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00007F00 */
#define DLYB_CFGR_UNIT                      DLYB_CFGR_UNIT_Msk                      /*!<Delay Defines the delay of a Unit delay cell[6:0] */
#define DLYB_CFGR_UNIT_0                    (0x01UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000100 */
#define DLYB_CFGR_UNIT_1                    (0x02UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000200 */
#define DLYB_CFGR_UNIT_2                    (0x04UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000400 */
#define DLYB_CFGR_UNIT_3                    (0x08UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000800 */
#define DLYB_CFGR_UNIT_4                    (0x10UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00001000 */
#define DLYB_CFGR_UNIT_5                    (0x20UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00002000 */
#define DLYB_CFGR_UNIT_6                    (0x40UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00004000 */
#define DLYB_CFGR_LNG_Pos                   (16U)
#define DLYB_CFGR_LNG_Msk                   (0xFFFUL << DLYB_CFGR_LNG_Pos)          /*!< 0x0FFF0000 */
#define DLYB_CFGR_LNG                       DLYB_CFGR_LNG_Msk                       /*!<Delay line length value[11:0] */
#define DLYB_CFGR_LNG_0                     (0x001UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00010000 */
#define DLYB_CFGR_LNG_1                     (0x002UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00020000 */
#define DLYB_CFGR_LNG_2                     (0x004UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00040000 */
#define DLYB_CFGR_LNG_3                     (0x008UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00080000 */
#define DLYB_CFGR_LNG_4                     (0x010UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00100000 */
#define DLYB_CFGR_LNG_5                     (0x020UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00200000 */
#define DLYB_CFGR_LNG_6                     (0x040UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00400000 */
#define DLYB_CFGR_LNG_7                     (0x080UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00800000 */
#define DLYB_CFGR_LNG_8                     (0x100UL << DLYB_CFGR_LNG_Pos)          /*!< 0x01000000 */
#define DLYB_CFGR_LNG_9                     (0x200UL << DLYB_CFGR_LNG_Pos)          /*!< 0x02000000 */
#define DLYB_CFGR_LNG_10                    (0x400UL << DLYB_CFGR_LNG_Pos)          /*!< 0x04000000 */
#define DLYB_CFGR_LNG_11                    (0x800UL << DLYB_CFGR_LNG_Pos)          /*!< 0x08000000 */
#define DLYB_CFGR_LNGF_Pos                  (31U)
#define DLYB_CFGR_LNGF_Msk                  (0x1UL << DLYB_CFGR_LNGF_Pos)            /*!< 0x80000000 */
#define DLYB_CFGR_LNGF                      DLYB_CFGR_LNGF_Msk                       /*!<Length valid flag */

/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DMA_SECCFGR register  ****************/
#define DMA_SECCFGR_SEC0_Pos                (0U)
#define DMA_SECCFGR_SEC0_Msk                (0x1UL << DMA_SECCFGR_SEC0_Pos)         /*!< 0x00000001 */
#define DMA_SECCFGR_SEC0                    DMA_SECCFGR_SEC0_Msk                    /*!< Secure State of Channel 0  */
#define DMA_SECCFGR_SEC1_Pos                (1U)
#define DMA_SECCFGR_SEC1_Msk                (0x1UL << DMA_SECCFGR_SEC1_Pos)         /*!< 0x00000002 */
#define DMA_SECCFGR_SEC1                    DMA_SECCFGR_SEC1_Msk                    /*!< Secure State of Channel 1  */
#define DMA_SECCFGR_SEC2_Pos                (2U)
#define DMA_SECCFGR_SEC2_Msk                (0x1UL << DMA_SECCFGR_SEC2_Pos)         /*!< 0x00000004 */
#define DMA_SECCFGR_SEC2                    DMA_SECCFGR_SEC2_Msk                    /*!< Secure State of Channel 2  */
#define DMA_SECCFGR_SEC3_Pos                (3U)
#define DMA_SECCFGR_SEC3_Msk                (0x1UL << DMA_SECCFGR_SEC3_Pos)         /*!< 0x00000008 */
#define DMA_SECCFGR_SEC3                    DMA_SECCFGR_SEC3_Msk                    /*!< Secure State of Channel 3  */
#define DMA_SECCFGR_SEC4_Pos                (4U)
#define DMA_SECCFGR_SEC4_Msk                (0x1UL << DMA_SECCFGR_SEC4_Pos)         /*!< 0x00000010 */
#define DMA_SECCFGR_SEC4                    DMA_SECCFGR_SEC4_Msk                    /*!< Secure State of Channel 4  */
#define DMA_SECCFGR_SEC5_Pos                (5U)
#define DMA_SECCFGR_SEC5_Msk                (0x1UL << DMA_SECCFGR_SEC5_Pos)         /*!< 0x00000020 */
#define DMA_SECCFGR_SEC5                    DMA_SECCFGR_SEC5_Msk                    /*!< Secure State of Channel 5  */
#define DMA_SECCFGR_SEC6_Pos                (6U)
#define DMA_SECCFGR_SEC6_Msk                (0x1UL << DMA_SECCFGR_SEC6_Pos)         /*!< 0x00000040 */
#define DMA_SECCFGR_SEC6                    DMA_SECCFGR_SEC6_Msk                    /*!< Secure State of Channel 6  */
#define DMA_SECCFGR_SEC7_Pos                (7U)
#define DMA_SECCFGR_SEC7_Msk                (0x1UL << DMA_SECCFGR_SEC7_Pos)         /*!< 0x00000080 */
#define DMA_SECCFGR_SEC7                    DMA_SECCFGR_SEC7_Msk                    /*!< Secure State of Channel 7  */
#define DMA_SECCFGR_SEC8_Pos                (8U)
#define DMA_SECCFGR_SEC8_Msk                (0x1UL << DMA_SECCFGR_SEC8_Pos)         /*!< 0x00000100 */
#define DMA_SECCFGR_SEC8                    DMA_SECCFGR_SEC8_Msk                    /*!< Secure State of Channel 8  */
#define DMA_SECCFGR_SEC9_Pos                (9U)
#define DMA_SECCFGR_SEC9_Msk                (0x1UL << DMA_SECCFGR_SEC9_Pos)         /*!< 0x00000200 */
#define DMA_SECCFGR_SEC9                    DMA_SECCFGR_SEC9_Msk                    /*!< Secure State of Channel 9  */
#define DMA_SECCFGR_SEC10_Pos               (10U)
#define DMA_SECCFGR_SEC10_Msk               (0x1UL << DMA_SECCFGR_SEC10_Pos)        /*!< 0x00000400 */
#define DMA_SECCFGR_SEC10                   DMA_SECCFGR_SEC10_Msk                   /*!< Secure State of Channel 10 */
#define DMA_SECCFGR_SEC11_Pos               (11U)
#define DMA_SECCFGR_SEC11_Msk               (0x1UL << DMA_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define DMA_SECCFGR_SEC11                   DMA_SECCFGR_SEC11_Msk                   /*!< Secure State of Channel 11 */

/*******************  Bit definition for DMA_PRIVCFGR register  ****************/
#define DMA_PRIVCFGR_PRIV0_Pos              (0U)
#define DMA_PRIVCFGR_PRIV0_Msk              (0x1UL << DMA_PRIVCFGR_PRIV0_Pos)       /*!< 0x00000001 */
#define DMA_PRIVCFGR_PRIV0                  DMA_PRIVCFGR_PRIV0_Msk                  /*!< Privileged State of Channel 0  */
#define DMA_PRIVCFGR_PRIV1_Pos              (1U)
#define DMA_PRIVCFGR_PRIV1_Msk              (0x1UL << DMA_PRIVCFGR_PRIV1_Pos)       /*!< 0x00000002 */
#define DMA_PRIVCFGR_PRIV1                  DMA_PRIVCFGR_PRIV1_Msk                  /*!< Privileged State of Channel 1  */
#define DMA_PRIVCFGR_PRIV2_Pos              (2U)
#define DMA_PRIVCFGR_PRIV2_Msk              (0x1UL << DMA_PRIVCFGR_PRIV2_Pos)       /*!< 0x00000004 */
#define DMA_PRIVCFGR_PRIV2                  DMA_PRIVCFGR_PRIV2_Msk                  /*!< Privileged State of Channel 2  */
#define DMA_PRIVCFGR_PRIV3_Pos              (3U)
#define DMA_PRIVCFGR_PRIV3_Msk              (0x1UL << DMA_PRIVCFGR_PRIV3_Pos)       /*!< 0x00000008 */
#define DMA_PRIVCFGR_PRIV3                  DMA_PRIVCFGR_PRIV3_Msk                  /*!< Privileged State of Channel 3  */
#define DMA_PRIVCFGR_PRIV4_Pos              (4U)
#define DMA_PRIVCFGR_PRIV4_Msk              (0x1UL << DMA_PRIVCFGR_PRIV4_Pos)       /*!< 0x00000010 */
#define DMA_PRIVCFGR_PRIV4                  DMA_PRIVCFGR_PRIV4_Msk                  /*!< Privileged State of Channel 4  */
#define DMA_PRIVCFGR_PRIV5_Pos              (5U)
#define DMA_PRIVCFGR_PRIV5_Msk              (0x1UL << DMA_PRIVCFGR_PRIV5_Pos)       /*!< 0x00000020 */
#define DMA_PRIVCFGR_PRIV5                  DMA_PRIVCFGR_PRIV5_Msk                  /*!< Privileged State of Channel 5  */
#define DMA_PRIVCFGR_PRIV6_Pos              (6U)
#define DMA_PRIVCFGR_PRIV6_Msk              (0x1UL << DMA_PRIVCFGR_PRIV6_Pos)       /*!< 0x00000040 */
#define DMA_PRIVCFGR_PRIV6                  DMA_PRIVCFGR_PRIV6_Msk                  /*!< Privileged State of Channel 6  */
#define DMA_PRIVCFGR_PRIV7_Pos              (7U)
#define DMA_PRIVCFGR_PRIV7_Msk              (0x1UL << DMA_PRIVCFGR_PRIV7_Pos)       /*!< 0x00000080 */
#define DMA_PRIVCFGR_PRIV7                  DMA_PRIVCFGR_PRIV7_Msk                  /*!< Privileged State of Channel 7  */
#define DMA_PRIVCFGR_PRIV8_Pos              (8U)
#define DMA_PRIVCFGR_PRIV8_Msk              (0x1UL << DMA_PRIVCFGR_PRIV8_Pos)       /*!< 0x00000100 */
#define DMA_PRIVCFGR_PRIV8                  DMA_PRIVCFGR_PRIV8_Msk                  /*!< Privileged State of Channel 8  */
#define DMA_PRIVCFGR_PRIV9_Pos              (9U)
#define DMA_PRIVCFGR_PRIV9_Msk              (0x1UL << DMA_PRIVCFGR_PRIV9_Pos)       /*!< 0x00000200 */
#define DMA_PRIVCFGR_PRIV9                  DMA_PRIVCFGR_PRIV9_Msk                  /*!< Privileged State of Channel 9  */
#define DMA_PRIVCFGR_PRIV10_Pos             (10U)
#define DMA_PRIVCFGR_PRIV10_Msk             (0x1UL << DMA_PRIVCFGR_PRIV10_Pos)      /*!< 0x00000400 */
#define DMA_PRIVCFGR_PRIV10                 DMA_PRIVCFGR_PRIV10_Msk                 /*!< Privileged State of Channel 10 */
#define DMA_PRIVCFGR_PRIV11_Pos             (11U)
#define DMA_PRIVCFGR_PRIV11_Msk             (0x1UL << DMA_PRIVCFGR_PRIV11_Pos)      /*!< 0x00000800 */
#define DMA_PRIVCFGR_PRIV11                 DMA_PRIVCFGR_PRIV11_Msk                 /*!< Privileged State of Channel 11 */

/*******************  Bit definition for DMA_RCFGLOCKR register  ****************/
#define DMA_RCFGLOCKR_LOCK0_Pos              (0U)
#define DMA_RCFGLOCKR_LOCK0_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK0_Pos)       /*!< 0x00000001 */
#define DMA_RCFGLOCKR_LOCK0                  DMA_RCFGLOCKR_LOCK0_Msk                  /*!< Lock the configuration of Channel 0  */
#define DMA_RCFGLOCKR_LOCK1_Pos              (1U)
#define DMA_RCFGLOCKR_LOCK1_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK1_Pos)       /*!< 0x00000002 */
#define DMA_RCFGLOCKR_LOCK1                  DMA_RCFGLOCKR_LOCK1_Msk                  /*!< Lock the configuration of Channel 1  */
#define DMA_RCFGLOCKR_LOCK2_Pos              (2U)
#define DMA_RCFGLOCKR_LOCK2_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK2_Pos)       /*!< 0x00000004 */
#define DMA_RCFGLOCKR_LOCK2                  DMA_RCFGLOCKR_LOCK2_Msk                  /*!< Lock the configuration of Channel 2  */
#define DMA_RCFGLOCKR_LOCK3_Pos              (3U)
#define DMA_RCFGLOCKR_LOCK3_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK3_Pos)       /*!< 0x00000008 */
#define DMA_RCFGLOCKR_LOCK3                  DMA_RCFGLOCKR_LOCK3_Msk                  /*!< Lock the configuration of Channel 3  */
#define DMA_RCFGLOCKR_LOCK4_Pos              (4U)
#define DMA_RCFGLOCKR_LOCK4_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK4_Pos)       /*!< 0x00000010 */
#define DMA_RCFGLOCKR_LOCK4                  DMA_RCFGLOCKR_LOCK4_Msk                  /*!< Lock the configuration of Channel 4  */
#define DMA_RCFGLOCKR_LOCK5_Pos              (5U)
#define DMA_RCFGLOCKR_LOCK5_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK5_Pos)       /*!< 0x00000020 */
#define DMA_RCFGLOCKR_LOCK5                  DMA_RCFGLOCKR_LOCK5_Msk                  /*!< Lock the configuration of Channel 5  */
#define DMA_RCFGLOCKR_LOCK6_Pos              (6U)
#define DMA_RCFGLOCKR_LOCK6_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK6_Pos)       /*!< 0x00000040 */
#define DMA_RCFGLOCKR_LOCK6                  DMA_RCFGLOCKR_LOCK6_Msk                  /*!< Lock the configuration of Channel 6  */
#define DMA_RCFGLOCKR_LOCK7_Pos              (7U)
#define DMA_RCFGLOCKR_LOCK7_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK7_Pos)       /*!< 0x00000080 */
#define DMA_RCFGLOCKR_LOCK7                  DMA_RCFGLOCKR_LOCK7_Msk                  /*!< Lock the configuration of Channel 7  */
#define DMA_RCFGLOCKR_LOCK8_Pos              (8U)
#define DMA_RCFGLOCKR_LOCK8_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK8_Pos)       /*!< 0x00000100 */
#define DMA_RCFGLOCKR_LOCK8                  DMA_RCFGLOCKR_LOCK8_Msk                  /*!< Lock the configuration of Channel 8  */
#define DMA_RCFGLOCKR_LOCK9_Pos              (9U)
#define DMA_RCFGLOCKR_LOCK9_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK9_Pos)       /*!< 0x00000200 */
#define DMA_RCFGLOCKR_LOCK9                  DMA_RCFGLOCKR_LOCK9_Msk                  /*!< Lock the configuration of Channel 9  */
#define DMA_RCFGLOCKR_LOCK10_Pos             (10U)
#define DMA_RCFGLOCKR_LOCK10_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK10_Pos)      /*!< 0x00000400 */
#define DMA_RCFGLOCKR_LOCK10                 DMA_RCFGLOCKR_LOCK10_Msk                 /*!< Lock the configuration of Channel 10 */
#define DMA_RCFGLOCKR_LOCK11_Pos             (11U)
#define DMA_RCFGLOCKR_LOCK11_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK11_Pos)      /*!< 0x00000800 */
#define DMA_RCFGLOCKR_LOCK11                 DMA_RCFGLOCKR_LOCK11_Msk                 /*!< Lock the configuration of Channel 11 */

/*******************  Bit definition for DMA_MISR register  ****************/
#define DMA_MISR_MIS0_Pos                   (0U)
#define DMA_MISR_MIS0_Msk                   (0x1UL << DMA_MISR_MIS0_Pos)            /*!< 0x00000001 */
#define DMA_MISR_MIS0                       DMA_MISR_MIS0_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 0  */
#define DMA_MISR_MIS1_Pos                   (1U)
#define DMA_MISR_MIS1_Msk                   (0x1UL << DMA_MISR_MIS1_Pos)            /*!< 0x00000002 */
#define DMA_MISR_MIS1                       DMA_MISR_MIS1_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 1  */
#define DMA_MISR_MIS2_Pos                   (2U)
#define DMA_MISR_MIS2_Msk                   (0x1UL << DMA_MISR_MIS2_Pos)            /*!< 0x00000004 */
#define DMA_MISR_MIS2                       DMA_MISR_MIS2_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 2  */
#define DMA_MISR_MIS3_Pos                   (3U)
#define DMA_MISR_MIS3_Msk                   (0x1UL << DMA_MISR_MIS3_Pos)            /*!< 0x00000008 */
#define DMA_MISR_MIS3                       DMA_MISR_MIS3_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 3  */
#define DMA_MISR_MIS4_Pos                   (4U)
#define DMA_MISR_MIS4_Msk                   (0x1UL << DMA_MISR_MIS4_Pos)            /*!< 0x00000010 */
#define DMA_MISR_MIS4                       DMA_MISR_MIS4_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 4  */
#define DMA_MISR_MIS5_Pos                   (5U)
#define DMA_MISR_MIS5_Msk                   (0x1UL << DMA_MISR_MIS5_Pos)            /*!< 0x00000020 */
#define DMA_MISR_MIS5                       DMA_MISR_MIS5_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 5  */
#define DMA_MISR_MIS6_Pos                   (6U)
#define DMA_MISR_MIS6_Msk                   (0x1UL << DMA_MISR_MIS6_Pos)            /*!< 0x00000040 */
#define DMA_MISR_MIS6                       DMA_MISR_MIS6_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 6  */
#define DMA_MISR_MIS7_Pos                   (7U)
#define DMA_MISR_MIS7_Msk                   (0x1UL << DMA_MISR_MIS7_Pos)            /*!< 0x00000080 */
#define DMA_MISR_MIS7                       DMA_MISR_MIS7_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 7  */
#define DMA_MISR_MIS8_Pos                   (8U)
#define DMA_MISR_MIS8_Msk                   (0x1UL << DMA_MISR_MIS8_Pos)            /*!< 0x00000100 */
#define DMA_MISR_MIS8                       DMA_MISR_MIS8_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 8  */
#define DMA_MISR_MIS9_Pos                   (9U)
#define DMA_MISR_MIS9_Msk                   (0x1UL << DMA_MISR_MIS9_Pos)            /*!< 0x00000200 */
#define DMA_MISR_MIS9                       DMA_MISR_MIS9_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 9  */
#define DMA_MISR_MIS10_Pos                  (10U)
#define DMA_MISR_MIS10_Msk                  (0x1UL << DMA_MISR_MIS10_Pos)           /*!< 0x00000400 */
#define DMA_MISR_MIS10                      DMA_MISR_MIS10_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 10 */
#define DMA_MISR_MIS11_Pos                  (11U)
#define DMA_MISR_MIS11_Msk                  (0x1UL << DMA_MISR_MIS11_Pos)           /*!< 0x00000800 */
#define DMA_MISR_MIS11                      DMA_MISR_MIS11_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 11 */

/*******************  Bit definition for DMA_SMISR register  ****************/
#define DMA_SMISR_MIS0_Pos                  (0U)
#define DMA_SMISR_MIS0_Msk                  (0x1UL << DMA_SMISR_MIS0_Pos)           /*!< 0x00000001 */
#define DMA_SMISR_MIS0                      DMA_SMISR_MIS0_Msk                      /*!< Masked Interrupt State of Secure Channel 0  */
#define DMA_SMISR_MIS1_Pos                  (1U)
#define DMA_SMISR_MIS1_Msk                  (0x1UL << DMA_SMISR_MIS1_Pos)           /*!< 0x00000002 */
#define DMA_SMISR_MIS1                      DMA_SMISR_MIS1_Msk                      /*!< Masked Interrupt State of Secure Channel 1  */
#define DMA_SMISR_MIS2_Pos                  (2U)
#define DMA_SMISR_MIS2_Msk                  (0x1UL << DMA_SMISR_MIS2_Pos)           /*!< 0x00000004 */
#define DMA_SMISR_MIS2                      DMA_SMISR_MIS2_Msk                      /*!< Masked Interrupt State of Secure Channel 2  */
#define DMA_SMISR_MIS3_Pos                  (3U)
#define DMA_SMISR_MIS3_Msk                  (0x1UL << DMA_SMISR_MIS3_Pos)           /*!< 0x00000008 */
#define DMA_SMISR_MIS3                      DMA_SMISR_MIS3_Msk                      /*!< Masked Interrupt State of Secure Channel 3  */
#define DMA_SMISR_MIS4_Pos                  (4U)
#define DMA_SMISR_MIS4_Msk                  (0x1UL << DMA_SMISR_MIS4_Pos)           /*!< 0x00000010 */
#define DMA_SMISR_MIS4                      DMA_SMISR_MIS4_Msk                      /*!< Masked Interrupt State of Secure Channel 4  */
#define DMA_SMISR_MIS5_Pos                  (5U)
#define DMA_SMISR_MIS5_Msk                  (0x1UL << DMA_SMISR_MIS5_Pos)           /*!< 0x00000020 */
#define DMA_SMISR_MIS5                      DMA_SMISR_MIS5_Msk                      /*!< Masked Interrupt State of Secure Channel 5  */
#define DMA_SMISR_MIS6_Pos                  (6U)
#define DMA_SMISR_MIS6_Msk                  (0x1UL << DMA_SMISR_MIS6_Pos)           /*!< 0x00000040 */
#define DMA_SMISR_MIS6                      DMA_SMISR_MIS6_Msk                      /*!< Masked Interrupt State of Secure Channel 6  */
#define DMA_SMISR_MIS7_Pos                  (7U)
#define DMA_SMISR_MIS7_Msk                  (0x1UL << DMA_SMISR_MIS7_Pos)           /*!< 0x00000080 */
#define DMA_SMISR_MIS7                      DMA_SMISR_MIS7_Msk                      /*!< Masked Interrupt State of Secure Channel 7  */
#define DMA_SMISR_MIS8_Pos                  (8U)
#define DMA_SMISR_MIS8_Msk                  (0x1UL << DMA_SMISR_MIS8_Pos)           /*!< 0x00000100 */
#define DMA_SMISR_MIS8                      DMA_SMISR_MIS8_Msk                      /*!< Masked Interrupt State of Secure Channel 8  */
#define DMA_SMISR_MIS9_Pos                  (9U)
#define DMA_SMISR_MIS9_Msk                  (0x1UL << DMA_SMISR_MIS9_Pos)           /*!< 0x00000200 */
#define DMA_SMISR_MIS9                      DMA_SMISR_MIS9_Msk                      /*!< Masked Interrupt State of Secure Channel 9  */
#define DMA_SMISR_MIS10_Pos                 (10U)
#define DMA_SMISR_MIS10_Msk                 (0x1UL << DMA_SMISR_MIS10_Pos)          /*!< 0x00000400 */
#define DMA_SMISR_MIS10                     DMA_SMISR_MIS10_Msk                     /*!< Masked Interrupt State of Secure Channel 10 */
#define DMA_SMISR_MIS11_Pos                 (11U)
#define DMA_SMISR_MIS11_Msk                 (0x1UL << DMA_SMISR_MIS11_Pos)          /*!< 0x00000800 */
#define DMA_SMISR_MIS11                     DMA_SMISR_MIS11_Msk                     /*!< Masked Interrupt State of Secure Channel 11 */

/*******************  Bit definition for DMA_CLBAR register  ****************/
#define DMA_CLBAR_LBA_Pos                   (16U)
#define DMA_CLBAR_LBA_Msk                   (0xFFFFUL << DMA_CLBAR_LBA_Pos)         /*!< 0xFFFF0000 */
#define DMA_CLBAR_LBA                       DMA_CLBAR_LBA_Msk                       /*!< Linked-list Base Address of DMA channel x */

/*******************  Bit definition for DMA_CFCR register  *******************/
#define DMA_CFCR_TCF_Pos                    (8U)
#define DMA_CFCR_TCF_Msk                    (0x1UL << DMA_CFCR_TCF_Pos)             /*!< 0x00000100 */
#define DMA_CFCR_TCF                        DMA_CFCR_TCF_Msk                        /*!< Transfer complete flag clear             */
#define DMA_CFCR_HTF_Pos                    (9U)
#define DMA_CFCR_HTF_Msk                    (0x1UL << DMA_CFCR_HTF_Pos)             /*!< 0x00000200 */
#define DMA_CFCR_HTF                        DMA_CFCR_HTF_Msk                        /*!< Half transfer complete flag clear        */
#define DMA_CFCR_DTEF_Pos                   (10U)
#define DMA_CFCR_DTEF_Msk                   (0x1UL << DMA_CFCR_DTEF_Pos)            /*!< 0x00000400 */
#define DMA_CFCR_DTEF                       DMA_CFCR_DTEF_Msk                       /*!< Data transfer error flag clear           */
#define DMA_CFCR_ULEF_Pos                   (11U)
#define DMA_CFCR_ULEF_Msk                   (0x1UL << DMA_CFCR_ULEF_Pos)            /*!< 0x00000800 */
#define DMA_CFCR_ULEF                       DMA_CFCR_ULEF_Msk                       /*!< Update linked-list item error flag clear */
#define DMA_CFCR_USEF_Pos                   (12U)
#define DMA_CFCR_USEF_Msk                   (0x1UL << DMA_CFCR_USEF_Pos)            /*!< 0x00001000 */
#define DMA_CFCR_USEF                       DMA_CFCR_USEF_Msk                       /*!< User setting error flag clear            */
#define DMA_CFCR_SUSPF_Pos                  (13U)
#define DMA_CFCR_SUSPF_Msk                  (0x1UL << DMA_CFCR_SUSPF_Pos)           /*!< 0x00002000 */
#define DMA_CFCR_SUSPF                      DMA_CFCR_SUSPF_Msk                      /*!< Completed suspension flag clear          */
#define DMA_CFCR_TOF_Pos                    (14U)
#define DMA_CFCR_TOF_Msk                    (0x1UL << DMA_CFCR_TOF_Pos)             /*!< 0x00004000 */
#define DMA_CFCR_TOF                        DMA_CFCR_TOF_Msk                        /*!< Trigger overrun flag clear               */

/*******************  Bit definition for DMA_CSR register  *******************/
#define DMA_CSR_IDLEF_Pos                   (0U)
#define DMA_CSR_IDLEF_Msk                   (0x1UL << DMA_CSR_IDLEF_Pos)            /*!< 0x00000001 */
#define DMA_CSR_IDLEF                       DMA_CSR_IDLEF_Msk                       /*!< Idle flag                          */
#define DMA_CSR_TCF_Pos                     (8U)
#define DMA_CSR_TCF_Msk                     (0x1UL << DMA_CSR_TCF_Pos)              /*!< 0x00000100 */
#define DMA_CSR_TCF                         DMA_CSR_TCF_Msk                         /*!< Transfer complete flag             */
#define DMA_CSR_HTF_Pos                     (9U)
#define DMA_CSR_HTF_Msk                     (0x1UL << DMA_CSR_HTF_Pos)              /*!< 0x00000200 */
#define DMA_CSR_HTF                         DMA_CSR_HTF_Msk                         /*!< Half transfer complete flag        */
#define DMA_CSR_DTEF_Pos                    (10U)
#define DMA_CSR_DTEF_Msk                    (0x1UL << DMA_CSR_DTEF_Pos)             /*!< 0x00000400 */
#define DMA_CSR_DTEF                        DMA_CSR_DTEF_Msk                        /*!< Data transfer error flag           */
#define DMA_CSR_ULEF_Pos                    (11U)
#define DMA_CSR_ULEF_Msk                    (0x1UL << DMA_CSR_ULEF_Pos)             /*!< 0x00000800 */
#define DMA_CSR_ULEF                        DMA_CSR_ULEF_Msk                        /*!< Update linked-list item error flag */
#define DMA_CSR_USEF_Pos                    (12U)
#define DMA_CSR_USEF_Msk                    (0x1UL << DMA_CSR_USEF_Pos)             /*!< 0x00001000 */
#define DMA_CSR_USEF                        DMA_CSR_USEF_Msk                        /*!< User setting error flag            */
#define DMA_CSR_SUSPF_Pos                   (13U)
#define DMA_CSR_SUSPF_Msk                   (0x1UL << DMA_CSR_SUSPF_Pos)            /*!< 0x00002000 */
#define DMA_CSR_SUSPF                       DMA_CSR_SUSPF_Msk                       /*!< Completed suspension flag          */
#define DMA_CSR_TOF_Pos                     (14U)
#define DMA_CSR_TOF_Msk                     (0x1UL << DMA_CSR_TOF_Pos)              /*!< 0x00004000 */
#define DMA_CSR_TOF                         DMA_CSR_TOF_Msk                         /*!< Trigger overrun flag               */
#define DMA_CSR_FIFOL_Pos                   (16U)
#define DMA_CSR_FIFOL_Msk                   (0xFFUL << DMA_CSR_FIFOL_Pos)           /*!< 0x00FF0000 */
#define DMA_CSR_FIFOL                       DMA_CSR_FIFOL_Msk                       /*!< Monitored FIFO level in bytes      */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos                      (0U)
#define DMA_CCR_EN_Msk                      (0x1UL << DMA_CCR_EN_Pos)               /*!< 0x00000001 */
#define DMA_CCR_EN                          DMA_CCR_EN_Msk                          /*!< Channel enable                                 */
#define DMA_CCR_RESET_Pos                   (1U)
#define DMA_CCR_RESET_Msk                   (0x1UL << DMA_CCR_RESET_Pos)            /*!< 0x00000002 */
#define DMA_CCR_RESET                       DMA_CCR_RESET_Msk                       /*!< Channel reset                                  */
#define DMA_CCR_SUSP_Pos                    (2U)
#define DMA_CCR_SUSP_Msk                    (0x1UL << DMA_CCR_SUSP_Pos)             /*!< 0x00000004 */
#define DMA_CCR_SUSP                        DMA_CCR_SUSP_Msk                        /*!< Channel suspend                                */
#define DMA_CCR_TCIE_Pos                    (8U)
#define DMA_CCR_TCIE_Msk                    (0x1UL << DMA_CCR_TCIE_Pos)             /*!< 0x00000100 */
#define DMA_CCR_TCIE                        DMA_CCR_TCIE_Msk                        /*!< Transfer complete interrupt enable             */
#define DMA_CCR_HTIE_Pos                    (9U)
#define DMA_CCR_HTIE_Msk                    (0x1UL << DMA_CCR_HTIE_Pos)             /*!< 0x00000200 */
#define DMA_CCR_HTIE                        DMA_CCR_HTIE_Msk                        /*!< Half transfer complete interrupt enable        */
#define DMA_CCR_DTEIE_Pos                   (10U)
#define DMA_CCR_DTEIE_Msk                   (0x1UL << DMA_CCR_DTEIE_Pos)            /*!< 0x00000400 */
#define DMA_CCR_DTEIE                       DMA_CCR_DTEIE_Msk                       /*!< Data transfer error interrupt enable           */
#define DMA_CCR_ULEIE_Pos                   (11U)
#define DMA_CCR_ULEIE_Msk                   (0x1UL << DMA_CCR_ULEIE_Pos)            /*!< 0x00000800 */
#define DMA_CCR_ULEIE                       DMA_CCR_ULEIE_Msk                       /*!< Update linked-list item error interrupt enable */
#define DMA_CCR_USEIE_Pos                   (12U)
#define DMA_CCR_USEIE_Msk                   (0x1UL << DMA_CCR_USEIE_Pos)            /*!< 0x00001000 */
#define DMA_CCR_USEIE                       DMA_CCR_USEIE_Msk                       /*!< User setting error interrupt enable            */
#define DMA_CCR_SUSPIE_Pos                  (13U)
#define DMA_CCR_SUSPIE_Msk                  (0x1UL << DMA_CCR_SUSPIE_Pos)           /*!< 0x00002000 */
#define DMA_CCR_SUSPIE                      DMA_CCR_SUSPIE_Msk                      /*!< Completed suspension interrupt enable          */
#define DMA_CCR_TOIE_Pos                    (14U)
#define DMA_CCR_TOIE_Msk                    (0x1UL << DMA_CCR_TOIE_Pos)             /*!< 0x00004000 */
#define DMA_CCR_TOIE                        DMA_CCR_TOIE_Msk                        /*!< Trigger overrun interrupt enable               */
#define DMA_CCR_LSM_Pos                     (16U)
#define DMA_CCR_LSM_Msk                     (0x1UL << DMA_CCR_LSM_Pos)              /*!< 0x00010000 */
#define DMA_CCR_LSM                         DMA_CCR_LSM_Msk                         /*!< Link step mode                                 */
#define DMA_CCR_LAP_Pos                     (17U)
#define DMA_CCR_LAP_Msk                     (0x1UL << DMA_CCR_LAP_Pos)              /*!< 0x00020000 */
#define DMA_CCR_LAP                         DMA_CCR_LAP_Msk                         /*!< Linked-list allocated port                     */
#define DMA_CCR_PRIO_Pos                    (22U)
#define DMA_CCR_PRIO_Msk                    (0x3UL << DMA_CCR_PRIO_Pos)             /*!< 0x00C00000 */
#define DMA_CCR_PRIO                        DMA_CCR_PRIO_Msk                        /*!< Priority level                                 */
#define DMA_CCR_PRIO_0                      (0x1UL << DMA_CCR_PRIO_Pos)             /*!< 0x00400000 */
#define DMA_CCR_PRIO_1                      (0x2UL << DMA_CCR_PRIO_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for DMA_CTR1 register  *******************/
#define DMA_CTR1_SDW_LOG2_Pos               (0U)
#define DMA_CTR1_SDW_LOG2_Msk               (0x3UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< 0x00000003 */
#define DMA_CTR1_SDW_LOG2                   DMA_CTR1_SDW_LOG2_Msk                   /*!< Binary logarithm of the source data width of a burst                    */
#define DMA_CTR1_SDW_LOG2_0                 (0x1UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_SDW_LOG2_1                 (0x2UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_SINC_Pos                   (3U)
#define DMA_CTR1_SINC_Msk                   (0x1UL << DMA_CTR1_SINC_Pos)            /*!< 0x00000008 */
#define DMA_CTR1_SINC                       DMA_CTR1_SINC_Msk                       /*!< Source incrementing burst                                               */
#define DMA_CTR1_SBL_1_Pos                  (4U)
#define DMA_CTR1_SBL_1_Msk                  (0x3FUL << DMA_CTR1_SBL_1_Pos)          /*!< 0x000003F0 */
#define DMA_CTR1_SBL_1                      DMA_CTR1_SBL_1_Msk                      /*!< Source burst length minus 1                                             */
#define DMA_CTR1_PAM_Pos                    (11U)
#define DMA_CTR1_PAM_Msk                    (0x3UL << DMA_CTR1_PAM_Pos)             /*!< 0x0001800 */
#define DMA_CTR1_PAM                        DMA_CTR1_PAM_Msk                        /*!< Padding / alignment mode                                                */
#define DMA_CTR1_PAM_0                      (0x1UL << DMA_CTR1_PAM_Pos)             /*!< Bit 0 */
#define DMA_CTR1_PAM_1                      (0x2UL << DMA_CTR1_PAM_Pos)             /*!< Bit 1 */
#define DMA_CTR1_SBX_Pos                    (13U)
#define DMA_CTR1_SBX_Msk                    (0x1UL << DMA_CTR1_SBX_Pos)             /*!< 0x00002000 */
#define DMA_CTR1_SBX                        DMA_CTR1_SBX_Msk                        /*!< Source byte exchange within the unaligned half-word of each source word */
#define DMA_CTR1_SAP_Pos                    (14U)
#define DMA_CTR1_SAP_Msk                    (0x1UL << DMA_CTR1_SAP_Pos)             /*!< 0x00004000 */
#define DMA_CTR1_SAP                        DMA_CTR1_SAP_Msk                        /*!< Source allocated port                                                   */
#define DMA_CTR1_SSEC_Pos                   (15U)
#define DMA_CTR1_SSEC_Msk                   (0x1UL << DMA_CTR1_SSEC_Pos)            /*!< 0x00008000 */
#define DMA_CTR1_SSEC                       DMA_CTR1_SSEC_Msk                       /*!< Security attribute of the DMA transfer from the source                  */
#define DMA_CTR1_DDW_LOG2_Pos               (16U)
#define DMA_CTR1_DDW_LOG2_Msk               (0x3UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< 0x00030000 */
#define DMA_CTR1_DDW_LOG2                   DMA_CTR1_DDW_LOG2_Msk                   /*!< Binary logarithm of the destination data width of a burst               */
#define DMA_CTR1_DDW_LOG2_0                 (0x1UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_DDW_LOG2_1                 (0x2UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_DINC_Pos                   (19U)
#define DMA_CTR1_DINC_Msk                   (0x1UL << DMA_CTR1_DINC_Pos)            /*!< 0x00080000 */
#define DMA_CTR1_DINC                       DMA_CTR1_DINC_Msk                       /*!< Destination incrementing burst                                          */
#define DMA_CTR1_DBL_1_Pos                  (20U)
#define DMA_CTR1_DBL_1_Msk                  (0x3FUL << DMA_CTR1_DBL_1_Pos)          /*!< 0x03F00000 */
#define DMA_CTR1_DBL_1                      DMA_CTR1_DBL_1_Msk                      /*!< Destination burst length minus 1                                        */
#define DMA_CTR1_DBX_Pos                    (26U)
#define DMA_CTR1_DBX_Msk                    (0x1UL << DMA_CTR1_DBX_Pos)             /*!< 0x04000000 */
#define DMA_CTR1_DBX                        DMA_CTR1_DBX_Msk                        /*!< Destination byte exchange                                               */
#define DMA_CTR1_DHX_Pos                    (27U)
#define DMA_CTR1_DHX_Msk                    (0x1UL << DMA_CTR1_DHX_Pos)             /*!< 0x08000000 */
#define DMA_CTR1_DHX                        DMA_CTR1_DHX_Msk                        /*!< Destination half-word exchange                                          */
#define DMA_CTR1_DAP_Pos                    (30U)
#define DMA_CTR1_DAP_Msk                    (0x1UL << DMA_CTR1_DAP_Pos)             /*!< 0x40000000 */
#define DMA_CTR1_DAP                        DMA_CTR1_DAP_Msk                        /*!< Destination allocated port                                              */
#define DMA_CTR1_DSEC_Pos                   (31U)
#define DMA_CTR1_DSEC_Msk                   (0x1UL << DMA_CTR1_DSEC_Pos)            /*!< 0x80000000 */
#define DMA_CTR1_DSEC                       DMA_CTR1_DSEC_Msk                       /*!< Security attribute of the DMA transfer from the destination             */

/******************  Bit definition for DMA_CTR2 register  *******************/
#define DMA_CTR2_REQSEL_Pos                 (0U)
#define DMA_CTR2_REQSEL_Msk                 (0x7FUL << DMA_CTR2_REQSEL_Pos)         /*!< 0x0000007F */
#define DMA_CTR2_REQSEL                     DMA_CTR2_REQSEL_Msk                     /*!< DMA hardware request selection */
#define DMA_CTR2_SWREQ_Pos                  (9U)
#define DMA_CTR2_SWREQ_Msk                  (0x1UL << DMA_CTR2_SWREQ_Pos)           /*!< 0x00000200 */
#define DMA_CTR2_SWREQ                      DMA_CTR2_SWREQ_Msk                      /*!< Software request               */
#define DMA_CTR2_DREQ_Pos                   (10U)
#define DMA_CTR2_DREQ_Msk                   (0x1UL << DMA_CTR2_DREQ_Pos)            /*!< 0x00000400 */
#define DMA_CTR2_DREQ                       DMA_CTR2_DREQ_Msk                       /*!< Destination hardware request   */
#define DMA_CTR2_BREQ_Pos                   (11U)
#define DMA_CTR2_BREQ_Msk                   (0x1UL << DMA_CTR2_BREQ_Pos)            /*!< 0x00000800 */
#define DMA_CTR2_BREQ                       DMA_CTR2_BREQ_Msk                       /*!< Block hardware request         */
#define DMA_CTR2_PFREQ_Pos                  (12U)
#define DMA_CTR2_PFREQ_Msk                  (0x1UL << DMA_CTR2_PFREQ_Pos)           /*!< 0x00001000 */
#define DMA_CTR2_PFREQ                      DMA_CTR2_PFREQ_Msk                      /*!< Hardware request in peripheral flow control mode */
#define DMA_CTR2_TRIGM_Pos                  (14U)
#define DMA_CTR2_TRIGM_Msk                  (0x3UL << DMA_CTR2_TRIGM_Pos)           /*!< 0x0000C000 */
#define DMA_CTR2_TRIGM                      DMA_CTR2_TRIGM_Msk                      /*!< Trigger mode                   */
#define DMA_CTR2_TRIGM_0                    (0x1UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 0 */
#define DMA_CTR2_TRIGM_1                    (0x2UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 1 */
#define DMA_CTR2_TRIGSEL_Pos                (16U)
#define DMA_CTR2_TRIGSEL_Msk                (0x3FUL << DMA_CTR2_TRIGSEL_Pos)        /*!< 0x003F0000 */
#define DMA_CTR2_TRIGSEL                    DMA_CTR2_TRIGSEL_Msk                    /*!< Trigger event input selection  */
#define DMA_CTR2_TRIGPOL_Pos                (24U)
#define DMA_CTR2_TRIGPOL_Msk                (0x3UL << DMA_CTR2_TRIGPOL_Pos)         /*!< 0x03000000 */
#define DMA_CTR2_TRIGPOL                    DMA_CTR2_TRIGPOL_Msk                    /*!< Trigger event polarity         */
#define DMA_CTR2_TRIGPOL_0                  (0x1UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 0 */
#define DMA_CTR2_TRIGPOL_1                  (0x2UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 1 */
#define DMA_CTR2_TCEM_Pos                   (30U)
#define DMA_CTR2_TCEM_Msk                   (0x3UL << DMA_CTR2_TCEM_Pos)            /*!< 0xC0000000 */
#define DMA_CTR2_TCEM                       DMA_CTR2_TCEM_Msk                       /*!< Transfer complete event mode   */
#define DMA_CTR2_TCEM_0                     (0x1UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 0 */
#define DMA_CTR2_TCEM_1                     (0x2UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 1 */

/******************  Bit definition for DMA_CBR1 register  *******************/
#define DMA_CBR1_BNDT_Pos                   (0U)
#define DMA_CBR1_BNDT_Msk                   (0xFFFFUL << DMA_CBR1_BNDT_Pos)         /*!< 0x0000FFFF */
#define DMA_CBR1_BNDT                       DMA_CBR1_BNDT_Msk                       /*!< Block number of data bytes to transfer from the source */
#define DMA_CBR1_BRC_Pos                    (16U)
#define DMA_CBR1_BRC_Msk                    (0x7FFUL << DMA_CBR1_BRC_Pos)           /*!< 0x07FF0000 */
#define DMA_CBR1_BRC                        DMA_CBR1_BRC_Msk                        /*!< Block repeat counter                                   */
#define DMA_CBR1_SDEC_Pos                   (28U)
#define DMA_CBR1_SDEC_Msk                   (0x1UL << DMA_CBR1_SDEC_Pos)            /*!< 0x10000000 */
#define DMA_CBR1_SDEC                       DMA_CBR1_SDEC_Msk                       /*!< Source address decrement                               */
#define DMA_CBR1_DDEC_Pos                   (29U)
#define DMA_CBR1_DDEC_Msk                   (0x1UL << DMA_CBR1_DDEC_Pos)            /*!< 0x20000000 */
#define DMA_CBR1_DDEC                       DMA_CBR1_DDEC_Msk                       /*!< Destination address decrement                          */
#define DMA_CBR1_BRSDEC_Pos                 (30U)
#define DMA_CBR1_BRSDEC_Msk                 (0x1UL << DMA_CBR1_BRSDEC_Pos)          /*!< 0x40000000 */
#define DMA_CBR1_BRSDEC                     DMA_CBR1_BRSDEC_Msk                     /*!< Block repeat source address decrement                  */
#define DMA_CBR1_BRDDEC_Pos                 (31U)
#define DMA_CBR1_BRDDEC_Msk                 (0x1UL << DMA_CBR1_BRDDEC_Pos)          /*!< 0x80000000 */
#define DMA_CBR1_BRDDEC                     DMA_CBR1_BRDDEC_Msk                     /*!< Block repeat destination address decrement             */

/******************  Bit definition for DMA_CSAR register  ********************/
#define DMA_CSAR_SA_Pos                     (0U)
#define DMA_CSAR_SA_Msk                     (0xFFFFFFFFUL << DMA_CSAR_SA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CSAR_SA                         DMA_CSAR_SA_Msk                         /*!< Source Address */

/******************  Bit definition for DMA_CDAR register  *******************/
#define DMA_CDAR_DA_Pos                     (0U)
#define DMA_CDAR_DA_Msk                     (0xFFFFFFFFUL << DMA_CDAR_DA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CDAR_DA                         DMA_CDAR_DA_Msk                         /*!< Destination address */

/******************  Bit definition for DMA_CTR3 register  *******************/
#define DMA_CTR3_SAO_Pos                    (0U)
#define DMA_CTR3_SAO_Msk                    (0x1FFFUL << DMA_CTR3_SAO_Pos)          /*!< 0x00001FFF */
#define DMA_CTR3_SAO                        DMA_CTR3_SAO_Msk                        /*!< Source address offset increment      */
#define DMA_CTR3_DAO_Pos                    (16U)
#define DMA_CTR3_DAO_Msk                    (0x1FFFUL << DMA_CTR3_DAO_Pos)          /*!< 0x1FFF0000 */
#define DMA_CTR3_DAO                        DMA_CTR3_DAO_Msk                        /*!< Destination address offset increment */

/******************  Bit definition for DMA_CBR2 register  *******************/
#define DMA_CBR2_BRSAO_Pos                  (0U)
#define DMA_CBR2_BRSAO_Msk                  (0xFFFFUL << DMA_CBR2_BRSAO_Pos)        /*!< 0x0000FFFF */
#define DMA_CBR2_BRSAO                      DMA_CBR2_BRSAO_Msk                      /*!< Block repeated source address offset      */
#define DMA_CBR2_BRDAO_Pos                  (16U)
#define DMA_CBR2_BRDAO_Msk                  (0xFFFFUL << DMA_CBR2_BRDAO_Pos)        /*!< 0xFFFF0000 */
#define DMA_CBR2_BRDAO                      DMA_CBR2_BRDAO_Msk                      /*!< Block repeated destination address offset */

/******************  Bit definition for DMA_CLLR register  *******************/
#define DMA_CLLR_LA_Pos                     (2U)
#define DMA_CLLR_LA_Msk                     (0x3FFFUL << DMA_CLLR_LA_Pos)           /*!< 0x0000FFFC */
#define DMA_CLLR_LA                         DMA_CLLR_LA_Msk                         /*!< Pointer to the next linked-list data structure */
#define DMA_CLLR_ULL_Pos                    (16U)
#define DMA_CLLR_ULL_Msk                    (0x1UL << DMA_CLLR_ULL_Pos)             /*!< 0x00010000 */
#define DMA_CLLR_ULL                        DMA_CLLR_ULL_Msk                        /*!< Update link address register from memory       */
#define DMA_CLLR_UB2_Pos                    (25U)
#define DMA_CLLR_UB2_Msk                    (0x1UL << DMA_CLLR_UB2_Pos)             /*!< 0x02000000 */
#define DMA_CLLR_UB2                        DMA_CLLR_UB2_Msk                        /*!< Update block register 2 from memory            */
#define DMA_CLLR_UT3_Pos                    (26U)
#define DMA_CLLR_UT3_Msk                    (0x1UL << DMA_CLLR_UT3_Pos)             /*!< 0x04000000 */
#define DMA_CLLR_UT3                        DMA_CLLR_UT3_Msk                        /*!< Update transfer register 3 from SRAM           */
#define DMA_CLLR_UDA_Pos                    (27U)
#define DMA_CLLR_UDA_Msk                    (0x1UL << DMA_CLLR_UDA_Pos)             /*!< 0x08000000 */
#define DMA_CLLR_UDA                        DMA_CLLR_UDA_Msk                        /*!< Update destination address register from SRAM  */
#define DMA_CLLR_USA_Pos                    (28U)
#define DMA_CLLR_USA_Msk                    (0x1UL << DMA_CLLR_USA_Pos)             /*!< 0x10000000 */
#define DMA_CLLR_USA                        DMA_CLLR_USA_Msk                        /*!< Update source address register from SRAM       */
#define DMA_CLLR_UB1_Pos                    (29U)
#define DMA_CLLR_UB1_Msk                    (0x1UL << DMA_CLLR_UB1_Pos)             /*!< 0x20000000 */
#define DMA_CLLR_UB1                        DMA_CLLR_UB1_Msk                        /*!< Update block register 1 from SRAM              */
#define DMA_CLLR_UT2_Pos                    (30U)
#define DMA_CLLR_UT2_Msk                    (0x1UL << DMA_CLLR_UT2_Pos)             /*!< 0x40000000 */
#define DMA_CLLR_UT2                        DMA_CLLR_UT2_Msk                        /*!< Update transfer register 2 from SRAM           */
#define DMA_CLLR_UT1_Pos                    (31U)
#define DMA_CLLR_UT1_Msk                    (0x1UL << DMA_CLLR_UT1_Pos)             /*!< 0x80000000 */
#define DMA_CLLR_UT1                        DMA_CLLR_UT1_Msk                        /*!< Update transfer register 1 from SRAM           */

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR1 register  ******************/
#define EXTI_RTSR1_RT0_Pos                  (0U)
#define EXTI_RTSR1_RT0_Msk                  (0x1UL << EXTI_RTSR1_RT0_Pos)           /*!< 0x00000001 */
#define EXTI_RTSR1_RT0                      EXTI_RTSR1_RT0_Msk                      /*!< Rising trigger configuration for input line 0 */
#define EXTI_RTSR1_RT1_Pos                  (1U)
#define EXTI_RTSR1_RT1_Msk                  (0x1UL << EXTI_RTSR1_RT1_Pos)           /*!< 0x00000002 */
#define EXTI_RTSR1_RT1                      EXTI_RTSR1_RT1_Msk                      /*!< Rising trigger configuration for input line 1 */
#define EXTI_RTSR1_RT2_Pos                  (2U)
#define EXTI_RTSR1_RT2_Msk                  (0x1UL << EXTI_RTSR1_RT2_Pos)           /*!< 0x00000004 */
#define EXTI_RTSR1_RT2                      EXTI_RTSR1_RT2_Msk                      /*!< Rising trigger configuration for input line 2 */
#define EXTI_RTSR1_RT3_Pos                  (3U)
#define EXTI_RTSR1_RT3_Msk                  (0x1UL << EXTI_RTSR1_RT3_Pos)           /*!< 0x00000008 */
#define EXTI_RTSR1_RT3                      EXTI_RTSR1_RT3_Msk                      /*!< Rising trigger configuration for input line 3 */
#define EXTI_RTSR1_RT4_Pos                  (4U)
#define EXTI_RTSR1_RT4_Msk                  (0x1UL << EXTI_RTSR1_RT4_Pos)           /*!< 0x00000010 */
#define EXTI_RTSR1_RT4                      EXTI_RTSR1_RT4_Msk                      /*!< Rising trigger configuration for input line 4 */
#define EXTI_RTSR1_RT5_Pos                  (5U)
#define EXTI_RTSR1_RT5_Msk                  (0x1UL << EXTI_RTSR1_RT5_Pos)           /*!< 0x00000020 */
#define EXTI_RTSR1_RT5                      EXTI_RTSR1_RT5_Msk                      /*!< Rising trigger configuration for input line 5 */
#define EXTI_RTSR1_RT6_Pos                  (6U)
#define EXTI_RTSR1_RT6_Msk                  (0x1UL << EXTI_RTSR1_RT6_Pos)           /*!< 0x00000040 */
#define EXTI_RTSR1_RT6                      EXTI_RTSR1_RT6_Msk                      /*!< Rising trigger configuration for input line 6 */
#define EXTI_RTSR1_RT7_Pos                  (7U)
#define EXTI_RTSR1_RT7_Msk                  (0x1UL << EXTI_RTSR1_RT7_Pos)           /*!< 0x00000080 */
#define EXTI_RTSR1_RT7                      EXTI_RTSR1_RT7_Msk                      /*!< Rising trigger configuration for input line 7 */
#define EXTI_RTSR1_RT8_Pos                  (8U)
#define EXTI_RTSR1_RT8_Msk                  (0x1UL << EXTI_RTSR1_RT8_Pos)           /*!< 0x00000100 */
#define EXTI_RTSR1_RT8                      EXTI_RTSR1_RT8_Msk                      /*!< Rising trigger configuration for input line 8 */
#define EXTI_RTSR1_RT9_Pos                  (9U)
#define EXTI_RTSR1_RT9_Msk                  (0x1UL << EXTI_RTSR1_RT9_Pos)           /*!< 0x00000200 */
#define EXTI_RTSR1_RT9                      EXTI_RTSR1_RT9_Msk                      /*!< Rising trigger configuration for input line 9 */
#define EXTI_RTSR1_RT10_Pos                 (10U)
#define EXTI_RTSR1_RT10_Msk                 (0x1UL << EXTI_RTSR1_RT10_Pos)          /*!< 0x00000400 */
#define EXTI_RTSR1_RT10                     EXTI_RTSR1_RT10_Msk                     /*!< Rising trigger configuration for input line 10 */
#define EXTI_RTSR1_RT11_Pos                 (11U)
#define EXTI_RTSR1_RT11_Msk                 (0x1UL << EXTI_RTSR1_RT11_Pos)          /*!< 0x00000800 */
#define EXTI_RTSR1_RT11                     EXTI_RTSR1_RT11_Msk                     /*!< Rising trigger configuration for input line 11 */
#define EXTI_RTSR1_RT12_Pos                 (12U)
#define EXTI_RTSR1_RT12_Msk                 (0x1UL << EXTI_RTSR1_RT12_Pos)          /*!< 0x00001000 */
#define EXTI_RTSR1_RT12                     EXTI_RTSR1_RT12_Msk                     /*!< Rising trigger configuration for input line 12 */
#define EXTI_RTSR1_RT13_Pos                 (13U)
#define EXTI_RTSR1_RT13_Msk                 (0x1UL << EXTI_RTSR1_RT13_Pos)          /*!< 0x00002000 */
#define EXTI_RTSR1_RT13                     EXTI_RTSR1_RT13_Msk                     /*!< Rising trigger configuration for input line 13 */
#define EXTI_RTSR1_RT14_Pos                 (14U)
#define EXTI_RTSR1_RT14_Msk                 (0x1UL << EXTI_RTSR1_RT14_Pos)          /*!< 0x00004000 */
#define EXTI_RTSR1_RT14                     EXTI_RTSR1_RT14_Msk                     /*!< Rising trigger configuration for input line 14 */
#define EXTI_RTSR1_RT15_Pos                 (15U)
#define EXTI_RTSR1_RT15_Msk                 (0x1UL << EXTI_RTSR1_RT15_Pos)          /*!< 0x00008000 */
#define EXTI_RTSR1_RT15                     EXTI_RTSR1_RT15_Msk                     /*!< Rising trigger configuration for input line 15 */
#define EXTI_RTSR1_RT16_Pos                 (16U)
#define EXTI_RTSR1_RT16_Msk                 (0x1UL << EXTI_RTSR1_RT16_Pos)          /*!< 0x00010000 */
#define EXTI_RTSR1_RT16                     EXTI_RTSR1_RT16_Msk                     /*!< Rising trigger configuration for input line 16 */
#define EXTI_RTSR1_RT17_Pos                 (17U)
#define EXTI_RTSR1_RT17_Msk                 (0x1UL << EXTI_RTSR1_RT17_Pos)          /*!< 0x00020000 */
#define EXTI_RTSR1_RT17                     EXTI_RTSR1_RT17_Msk                     /*!< Rising trigger configuration for input line 17 */
#define EXTI_RTSR1_RT18_Pos                 (18U)
#define EXTI_RTSR1_RT18_Msk                 (0x1UL << EXTI_RTSR1_RT18_Pos)          /*!< 0x00040000 */
#define EXTI_RTSR1_RT18                     EXTI_RTSR1_RT18_Msk                     /*!< Rising trigger configuration for input line 18 */
#define EXTI_RTSR1_RT19_Pos                 (19U)
#define EXTI_RTSR1_RT19_Msk                 (0x1UL << EXTI_RTSR1_RT19_Pos)          /*!< 0x00080000 */
#define EXTI_RTSR1_RT19                     EXTI_RTSR1_RT19_Msk                     /*!< Rising trigger configuration for input line 19 */
#define EXTI_RTSR1_RT20_Pos                 (20U)
#define EXTI_RTSR1_RT20_Msk                 (0x1UL << EXTI_RTSR1_RT20_Pos)          /*!< 0x00100000 */
#define EXTI_RTSR1_RT20                     EXTI_RTSR1_RT20_Msk                     /*!< Rising trigger configuration for input line 20 */
#define EXTI_RTSR1_RT21_Pos                 (21U)
#define EXTI_RTSR1_RT21_Msk                 (0x1UL << EXTI_RTSR1_RT21_Pos)          /*!< 0x00200000 */
#define EXTI_RTSR1_RT21                     EXTI_RTSR1_RT21_Msk                     /*!< Rising trigger configuration for input line 21 */
#define EXTI_RTSR1_RT22_Pos                 (22U)
#define EXTI_RTSR1_RT22_Msk                 (0x1UL << EXTI_RTSR1_RT22_Pos)          /*!< 0x00400000 */
#define EXTI_RTSR1_RT22                     EXTI_RTSR1_RT22_Msk                     /*!< Rising trigger configuration for input line 22 */

/******************  Bit definition for EXTI_FTSR1 register  ******************/
#define EXTI_FTSR1_FT0_Pos                  (0U)
#define EXTI_FTSR1_FT0_Msk                  (0x1UL << EXTI_FTSR1_FT0_Pos)           /*!< 0x00000001 */
#define EXTI_FTSR1_FT0                      EXTI_FTSR1_FT0_Msk                      /*!< Falling trigger configuration for input line 0 */
#define EXTI_FTSR1_FT1_Pos                  (1U)
#define EXTI_FTSR1_FT1_Msk                  (0x1UL << EXTI_FTSR1_FT1_Pos)           /*!< 0x00000002 */
#define EXTI_FTSR1_FT1                      EXTI_FTSR1_FT1_Msk                      /*!< Falling trigger configuration for input line 1 */
#define EXTI_FTSR1_FT2_Pos                  (2U)
#define EXTI_FTSR1_FT2_Msk                  (0x1UL << EXTI_FTSR1_FT2_Pos)           /*!< 0x00000004 */
#define EXTI_FTSR1_FT2                      EXTI_FTSR1_FT2_Msk                      /*!< Falling trigger configuration for input line 2 */
#define EXTI_FTSR1_FT3_Pos                  (3U)
#define EXTI_FTSR1_FT3_Msk                  (0x1UL << EXTI_FTSR1_FT3_Pos)           /*!< 0x00000008 */
#define EXTI_FTSR1_FT3                      EXTI_FTSR1_FT3_Msk                      /*!< Falling trigger configuration for input line 3 */
#define EXTI_FTSR1_FT4_Pos                  (4U)
#define EXTI_FTSR1_FT4_Msk                  (0x1UL << EXTI_FTSR1_FT4_Pos)           /*!< 0x00000010 */
#define EXTI_FTSR1_FT4                      EXTI_FTSR1_FT4_Msk                      /*!< Falling trigger configuration for input line 4 */
#define EXTI_FTSR1_FT5_Pos                  (5U)
#define EXTI_FTSR1_FT5_Msk                  (0x1UL << EXTI_FTSR1_FT5_Pos)           /*!< 0x00000020 */
#define EXTI_FTSR1_FT5                      EXTI_FTSR1_FT5_Msk                      /*!< Falling trigger configuration for input line 5 */
#define EXTI_FTSR1_FT6_Pos                  (6U)
#define EXTI_FTSR1_FT6_Msk                  (0x1UL << EXTI_FTSR1_FT6_Pos)           /*!< 0x00000040 */
#define EXTI_FTSR1_FT6                      EXTI_FTSR1_FT6_Msk                      /*!< Falling trigger configuration for input line 6 */
#define EXTI_FTSR1_FT7_Pos                  (7U)
#define EXTI_FTSR1_FT7_Msk                  (0x1UL << EXTI_FTSR1_FT7_Pos)           /*!< 0x00000080 */
#define EXTI_FTSR1_FT7                      EXTI_FTSR1_FT7_Msk                      /*!< Falling trigger configuration for input line 7 */
#define EXTI_FTSR1_FT8_Pos                  (8U)
#define EXTI_FTSR1_FT8_Msk                  (0x1UL << EXTI_FTSR1_FT8_Pos)           /*!< 0x00000100 */
#define EXTI_FTSR1_FT8                      EXTI_FTSR1_FT8_Msk                      /*!< Falling trigger configuration for input line 8 */
#define EXTI_FTSR1_FT9_Pos                  (9U)
#define EXTI_FTSR1_FT9_Msk                  (0x1UL << EXTI_FTSR1_FT9_Pos)           /*!< 0x00000200 */
#define EXTI_FTSR1_FT9                      EXTI_FTSR1_FT9_Msk                      /*!< Falling trigger configuration for input line 9 */
#define EXTI_FTSR1_FT10_Pos                 (10U)
#define EXTI_FTSR1_FT10_Msk                 (0x1UL << EXTI_FTSR1_FT10_Pos)          /*!< 0x00000400 */
#define EXTI_FTSR1_FT10                     EXTI_FTSR1_FT10_Msk                     /*!< Falling trigger configuration for input line 10 */
#define EXTI_FTSR1_FT11_Pos                 (11U)
#define EXTI_FTSR1_FT11_Msk                 (0x1UL << EXTI_FTSR1_FT11_Pos)          /*!< 0x00000800 */
#define EXTI_FTSR1_FT11                     EXTI_FTSR1_FT11_Msk                     /*!< Falling trigger configuration for input line 11 */
#define EXTI_FTSR1_FT12_Pos                 (12U)
#define EXTI_FTSR1_FT12_Msk                 (0x1UL << EXTI_FTSR1_FT12_Pos)          /*!< 0x00001000 */
#define EXTI_FTSR1_FT12                     EXTI_FTSR1_FT12_Msk                     /*!< Falling trigger configuration for input line 12 */
#define EXTI_FTSR1_FT13_Pos                 (13U)
#define EXTI_FTSR1_FT13_Msk                 (0x1UL << EXTI_FTSR1_FT13_Pos)          /*!< 0x00002000 */
#define EXTI_FTSR1_FT13                     EXTI_FTSR1_FT13_Msk                     /*!< Falling trigger configuration for input line 13 */
#define EXTI_FTSR1_FT14_Pos                 (14U)
#define EXTI_FTSR1_FT14_Msk                 (0x1UL << EXTI_FTSR1_FT14_Pos)          /*!< 0x00004000 */
#define EXTI_FTSR1_FT14                     EXTI_FTSR1_FT14_Msk                     /*!< Falling trigger configuration for input line 14 */
#define EXTI_FTSR1_FT15_Pos                 (15U)
#define EXTI_FTSR1_FT15_Msk                 (0x1UL << EXTI_FTSR1_FT15_Pos)          /*!< 0x00008000 */
#define EXTI_FTSR1_FT15                     EXTI_FTSR1_FT15_Msk                     /*!< Falling trigger configuration for input line 15 */
#define EXTI_FTSR1_FT16_Pos                 (16U)
#define EXTI_FTSR1_FT16_Msk                 (0x1UL << EXTI_FTSR1_FT16_Pos)          /*!< 0x00010000 */
#define EXTI_FTSR1_FT16                     EXTI_FTSR1_FT16_Msk                     /*!< Falling trigger configuration for input line 16 */
#define EXTI_FTSR1_FT17_Pos                 (17U)
#define EXTI_FTSR1_FT17_Msk                 (0x1UL << EXTI_FTSR1_FT17_Pos)          /*!< 0x00020000 */
#define EXTI_FTSR1_FT17                     EXTI_FTSR1_FT17_Msk                     /*!< Falling trigger configuration for input line 17 */
#define EXTI_FTSR1_FT18_Pos                 (18U)
#define EXTI_FTSR1_FT18_Msk                 (0x1UL << EXTI_FTSR1_FT18_Pos)          /*!< 0x00040000 */
#define EXTI_FTSR1_FT18                     EXTI_FTSR1_FT18_Msk                     /*!< Falling trigger configuration for input line 18 */
#define EXTI_FTSR1_FT19_Pos                 (19U)
#define EXTI_FTSR1_FT19_Msk                 (0x1UL << EXTI_FTSR1_FT19_Pos)          /*!< 0x00080000 */
#define EXTI_FTSR1_FT19                     EXTI_FTSR1_FT19_Msk                     /*!< Falling trigger configuration for input line 19 */
#define EXTI_FTSR1_FT20_Pos                 (20U)
#define EXTI_FTSR1_FT20_Msk                 (0x1UL << EXTI_FTSR1_FT20_Pos)          /*!< 0x00100000 */
#define EXTI_FTSR1_FT20                     EXTI_FTSR1_FT20_Msk                     /*!< Falling trigger configuration for input line 20 */
#define EXTI_FTSR1_FT21_Pos                 (21U)
#define EXTI_FTSR1_FT21_Msk                 (0x1UL << EXTI_FTSR1_FT21_Pos)          /*!< 0x00200000 */
#define EXTI_FTSR1_FT21                     EXTI_FTSR1_FT21_Msk                     /*!< Falling trigger configuration for input line 21 */
#define EXTI_FTSR1_FT22_Pos                 (22U)
#define EXTI_FTSR1_FT22_Msk                 (0x1UL << EXTI_FTSR1_FT22_Pos)          /*!< 0x00400000 */
#define EXTI_FTSR1_FT22                     EXTI_FTSR1_FT22_Msk                     /*!< Falling trigger configuration for input line 22 */

/******************  Bit definition for EXTI_SWIER1 register  *****************/
#define EXTI_SWIER1_SWI0_Pos                (0U)
#define EXTI_SWIER1_SWI0_Msk                (0x1UL << EXTI_SWIER1_SWI0_Pos)         /*!< 0x00000001 */
#define EXTI_SWIER1_SWI0                    EXTI_SWIER1_SWI0_Msk                    /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWI1_Pos                (1U)
#define EXTI_SWIER1_SWI1_Msk                (0x1UL << EXTI_SWIER1_SWI1_Pos)         /*!< 0x00000002 */
#define EXTI_SWIER1_SWI1                    EXTI_SWIER1_SWI1_Msk                    /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWI2_Pos                (2U)
#define EXTI_SWIER1_SWI2_Msk                (0x1UL << EXTI_SWIER1_SWI2_Pos)         /*!< 0x00000004 */
#define EXTI_SWIER1_SWI2                    EXTI_SWIER1_SWI2_Msk                    /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWI3_Pos                (3U)
#define EXTI_SWIER1_SWI3_Msk                (0x1UL << EXTI_SWIER1_SWI3_Pos)         /*!< 0x00000008 */
#define EXTI_SWIER1_SWI3                    EXTI_SWIER1_SWI3_Msk                    /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWI4_Pos                (4U)
#define EXTI_SWIER1_SWI4_Msk                (0x1UL << EXTI_SWIER1_SWI4_Pos)         /*!< 0x00000010 */
#define EXTI_SWIER1_SWI4                    EXTI_SWIER1_SWI4_Msk                    /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWI5_Pos                (5U)
#define EXTI_SWIER1_SWI5_Msk                (0x1UL << EXTI_SWIER1_SWI5_Pos)         /*!< 0x00000020 */
#define EXTI_SWIER1_SWI5                    EXTI_SWIER1_SWI5_Msk                    /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWI6_Pos                (6U)
#define EXTI_SWIER1_SWI6_Msk                (0x1UL << EXTI_SWIER1_SWI6_Pos)         /*!< 0x00000040 */
#define EXTI_SWIER1_SWI6                    EXTI_SWIER1_SWI6_Msk                    /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWI7_Pos                (7U)
#define EXTI_SWIER1_SWI7_Msk                (0x1UL << EXTI_SWIER1_SWI7_Pos)         /*!< 0x00000080 */
#define EXTI_SWIER1_SWI7                    EXTI_SWIER1_SWI7_Msk                    /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWI8_Pos                (8U)
#define EXTI_SWIER1_SWI8_Msk                (0x1UL << EXTI_SWIER1_SWI8_Pos)         /*!< 0x00000100 */
#define EXTI_SWIER1_SWI8                    EXTI_SWIER1_SWI8_Msk                    /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWI9_Pos                (9U)
#define EXTI_SWIER1_SWI9_Msk                (0x1UL << EXTI_SWIER1_SWI9_Pos)         /*!< 0x00000200 */
#define EXTI_SWIER1_SWI9                    EXTI_SWIER1_SWI9_Msk                    /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWI10_Pos               (10U)
#define EXTI_SWIER1_SWI10_Msk               (0x1UL << EXTI_SWIER1_SWI10_Pos)        /*!< 0x00000400 */
#define EXTI_SWIER1_SWI10                   EXTI_SWIER1_SWI10_Msk                   /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWI11_Pos               (11U)
#define EXTI_SWIER1_SWI11_Msk               (0x1UL << EXTI_SWIER1_SWI11_Pos)        /*!< 0x00000800 */
#define EXTI_SWIER1_SWI11                   EXTI_SWIER1_SWI11_Msk                   /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWI12_Pos               (12U)
#define EXTI_SWIER1_SWI12_Msk               (0x1UL << EXTI_SWIER1_SWI12_Pos)        /*!< 0x00001000 */
#define EXTI_SWIER1_SWI12                   EXTI_SWIER1_SWI12_Msk                   /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWI13_Pos               (13U)
#define EXTI_SWIER1_SWI13_Msk               (0x1UL << EXTI_SWIER1_SWI13_Pos)        /*!< 0x00002000 */
#define EXTI_SWIER1_SWI13                   EXTI_SWIER1_SWI13_Msk                   /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWI14_Pos               (14U)
#define EXTI_SWIER1_SWI14_Msk               (0x1UL << EXTI_SWIER1_SWI14_Pos)        /*!< 0x00004000 */
#define EXTI_SWIER1_SWI14                   EXTI_SWIER1_SWI14_Msk                   /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWI15_Pos               (15U)
#define EXTI_SWIER1_SWI15_Msk               (0x1UL << EXTI_SWIER1_SWI15_Pos)        /*!< 0x00008000 */
#define EXTI_SWIER1_SWI15                   EXTI_SWIER1_SWI15_Msk                   /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWI16_Pos               (16U)
#define EXTI_SWIER1_SWI16_Msk               (0x1UL << EXTI_SWIER1_SWI16_Pos)        /*!< 0x00010000 */
#define EXTI_SWIER1_SWI16                   EXTI_SWIER1_SWI16_Msk                   /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWI17_Pos               (17U)
#define EXTI_SWIER1_SWI17_Msk               (0x1UL << EXTI_SWIER1_SWI17_Pos)        /*!< 0x00020000 */
#define EXTI_SWIER1_SWI17                   EXTI_SWIER1_SWI17_Msk                   /*!< Software Interrupt on line 17 */
#define EXTI_SWIER1_SWI18_Pos               (18U)
#define EXTI_SWIER1_SWI18_Msk               (0x1UL << EXTI_SWIER1_SWI18_Pos)        /*!< 0x00040000 */
#define EXTI_SWIER1_SWI18                   EXTI_SWIER1_SWI18_Msk                   /*!< Software Interrupt on line 18 */
#define EXTI_SWIER1_SWI19_Pos               (19U)
#define EXTI_SWIER1_SWI19_Msk               (0x1UL << EXTI_SWIER1_SWI19_Pos)        /*!< 0x00080000 */
#define EXTI_SWIER1_SWI19                   EXTI_SWIER1_SWI19_Msk                   /*!< Software Interrupt on line 19 */
#define EXTI_SWIER1_SWI20_Pos               (20U)
#define EXTI_SWIER1_SWI20_Msk               (0x1UL << EXTI_SWIER1_SWI20_Pos)        /*!< 0x00100000 */
#define EXTI_SWIER1_SWI20                   EXTI_SWIER1_SWI20_Msk                   /*!< Software Interrupt on line 20 */
#define EXTI_SWIER1_SWI21_Pos               (21U)
#define EXTI_SWIER1_SWI21_Msk               (0x1UL << EXTI_SWIER1_SWI21_Pos)        /*!< 0x00200000 */
#define EXTI_SWIER1_SWI21                   EXTI_SWIER1_SWI21_Msk                   /*!< Software Interrupt on line 21 */
#define EXTI_SWIER1_SWI22_Pos               (22U)
#define EXTI_SWIER1_SWI22_Msk               (0x1UL << EXTI_SWIER1_SWI22_Pos)        /*!< 0x00400000 */
#define EXTI_SWIER1_SWI22                   EXTI_SWIER1_SWI22_Msk                   /*!< Software Interrupt on line 22 */

/*******************  Bit definition for EXTI_RPR1 register  ******************/
#define EXTI_RPR1_RPIF0_Pos                 (0U)
#define EXTI_RPR1_RPIF0_Msk                 (0x1UL << EXTI_RPR1_RPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_RPR1_RPIF0                     EXTI_RPR1_RPIF0_Msk                     /*!< Rising Pending Interrupt Flag on line 0 */
#define EXTI_RPR1_RPIF1_Pos                 (1U)
#define EXTI_RPR1_RPIF1_Msk                 (0x1UL << EXTI_RPR1_RPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_RPR1_RPIF1                     EXTI_RPR1_RPIF1_Msk                     /*!< Rising Pending Interrupt Flag on line 1 */
#define EXTI_RPR1_RPIF2_Pos                 (2U)
#define EXTI_RPR1_RPIF2_Msk                 (0x1UL << EXTI_RPR1_RPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_RPR1_RPIF2                     EXTI_RPR1_RPIF2_Msk                     /*!< Rising Pending Interrupt Flag on line 2 */
#define EXTI_RPR1_RPIF3_Pos                 (3U)
#define EXTI_RPR1_RPIF3_Msk                 (0x1UL << EXTI_RPR1_RPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_RPR1_RPIF3                     EXTI_RPR1_RPIF3_Msk                     /*!< Rising Pending Interrupt Flag on line 3 */
#define EXTI_RPR1_RPIF4_Pos                 (4U)
#define EXTI_RPR1_RPIF4_Msk                 (0x1UL << EXTI_RPR1_RPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_RPR1_RPIF4                     EXTI_RPR1_RPIF4_Msk                     /*!< Rising Pending Interrupt Flag on line 4 */
#define EXTI_RPR1_RPIF5_Pos                 (5U)
#define EXTI_RPR1_RPIF5_Msk                 (0x1UL << EXTI_RPR1_RPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_RPR1_RPIF5                     EXTI_RPR1_RPIF5_Msk                     /*!< Rising Pending Interrupt Flag on line 5 */
#define EXTI_RPR1_RPIF6_Pos                 (6U)
#define EXTI_RPR1_RPIF6_Msk                 (0x1UL << EXTI_RPR1_RPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_RPR1_RPIF6                     EXTI_RPR1_RPIF6_Msk                     /*!< Rising Pending Interrupt Flag on line 6 */
#define EXTI_RPR1_RPIF7_Pos                 (7U)
#define EXTI_RPR1_RPIF7_Msk                 (0x1UL << EXTI_RPR1_RPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_RPR1_RPIF7                     EXTI_RPR1_RPIF7_Msk                     /*!< Rising Pending Interrupt Flag on line 7 */
#define EXTI_RPR1_RPIF8_Pos                 (8U)
#define EXTI_RPR1_RPIF8_Msk                 (0x1UL << EXTI_RPR1_RPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_RPR1_RPIF8                     EXTI_RPR1_RPIF8_Msk                     /*!< Rising Pending Interrupt Flag on line 8 */
#define EXTI_RPR1_RPIF9_Pos                 (9U)
#define EXTI_RPR1_RPIF9_Msk                 (0x1UL << EXTI_RPR1_RPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_RPR1_RPIF9                     EXTI_RPR1_RPIF9_Msk                     /*!< Rising Pending Interrupt Flag on line 9 */
#define EXTI_RPR1_RPIF10_Pos                (10U)
#define EXTI_RPR1_RPIF10_Msk                (0x1UL << EXTI_RPR1_RPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_RPR1_RPIF10                    EXTI_RPR1_RPIF10_Msk                    /*!< Rising Pending Interrupt Flag on line 10 */
#define EXTI_RPR1_RPIF11_Pos                (11U)
#define EXTI_RPR1_RPIF11_Msk                (0x1UL << EXTI_RPR1_RPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_RPR1_RPIF11                    EXTI_RPR1_RPIF11_Msk                    /*!< Rising Pending Interrupt Flag on line 11 */
#define EXTI_RPR1_RPIF12_Pos                (12U)
#define EXTI_RPR1_RPIF12_Msk                (0x1UL << EXTI_RPR1_RPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_RPR1_RPIF12                    EXTI_RPR1_RPIF12_Msk                    /*!< Rising Pending Interrupt Flag on line 12 */
#define EXTI_RPR1_RPIF13_Pos                (13U)
#define EXTI_RPR1_RPIF13_Msk                (0x1UL << EXTI_RPR1_RPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_RPR1_RPIF13                    EXTI_RPR1_RPIF13_Msk                    /*!< Rising Pending Interrupt Flag on line 13 */
#define EXTI_RPR1_RPIF14_Pos                (14U)
#define EXTI_RPR1_RPIF14_Msk                (0x1UL << EXTI_RPR1_RPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_RPR1_RPIF14                    EXTI_RPR1_RPIF14_Msk                    /*!< Rising Pending Interrupt Flag on line 14 */
#define EXTI_RPR1_RPIF15_Pos                (15U)
#define EXTI_RPR1_RPIF15_Msk                (0x1UL << EXTI_RPR1_RPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_RPR1_RPIF15                    EXTI_RPR1_RPIF15_Msk                    /*!< Rising Pending Interrupt Flag on line 15 */
#define EXTI_RPR1_RPIF16_Pos                (16U)
#define EXTI_RPR1_RPIF16_Msk                (0x1UL << EXTI_RPR1_RPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_RPR1_RPIF16                    EXTI_RPR1_RPIF16_Msk                    /*!< Rising Pending Interrupt Flag on line 16 */
#define EXTI_RPR1_RPIF17_Pos                (17U)
#define EXTI_RPR1_RPIF17_Msk                (0x1UL << EXTI_RPR1_RPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_RPR1_RPIF17                    EXTI_RPR1_RPIF17_Msk                    /*!< Rising Pending Interrupt Flag on line 17 */
#define EXTI_RPR1_RPIF18_Pos                (18U)
#define EXTI_RPR1_RPIF18_Msk                (0x1UL << EXTI_RPR1_RPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_RPR1_RPIF18                    EXTI_RPR1_RPIF18_Msk                    /*!< Rising Pending Interrupt Flag on line 18 */
#define EXTI_RPR1_RPIF19_Pos                (19U)
#define EXTI_RPR1_RPIF19_Msk                (0x1UL << EXTI_RPR1_RPIF19_Pos)         /*!< 0x00080000 */
#define EXTI_RPR1_RPIF19                    EXTI_RPR1_RPIF19_Msk                    /*!< Rising Pending Interrupt Flag on line 19 */
#define EXTI_RPR1_RPIF20_Pos                (20U)
#define EXTI_RPR1_RPIF20_Msk                (0x1UL << EXTI_RPR1_RPIF20_Pos)         /*!< 0x00100000 */
#define EXTI_RPR1_RPIF20                    EXTI_RPR1_RPIF20_Msk                    /*!< Rising Pending Interrupt Flag on line 20 */
#define EXTI_RPR1_RPIF21_Pos                (21U)
#define EXTI_RPR1_RPIF21_Msk                (0x1UL << EXTI_RPR1_RPIF21_Pos)         /*!< 0x00200000 */
#define EXTI_RPR1_RPIF21                    EXTI_RPR1_RPIF21_Msk                    /*!< Rising Pending Interrupt Flag on line 21 */
#define EXTI_RPR1_RPIF22_Pos                (22U)
#define EXTI_RPR1_RPIF22_Msk                (0x1UL << EXTI_RPR1_RPIF22_Pos)         /*!< 0x00400000 */
#define EXTI_RPR1_RPIF22                    EXTI_RPR1_RPIF22_Msk                    /*!< Rising Pending Interrupt Flag on line 22 */

/*******************  Bit definition for EXTI_FPR1 register  ******************/
#define EXTI_FPR1_FPIF0_Pos                 (0U)
#define EXTI_FPR1_FPIF0_Msk                 (0x1UL << EXTI_FPR1_FPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_FPR1_FPIF0                     EXTI_FPR1_FPIF0_Msk                     /*!< Falling Pending Interrupt Flag on line 0 */
#define EXTI_FPR1_FPIF1_Pos                 (1U)
#define EXTI_FPR1_FPIF1_Msk                 (0x1UL << EXTI_FPR1_FPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_FPR1_FPIF1                     EXTI_FPR1_FPIF1_Msk                     /*!< Falling Pending Interrupt Flag on line 1 */
#define EXTI_FPR1_FPIF2_Pos                 (2U)
#define EXTI_FPR1_FPIF2_Msk                 (0x1UL << EXTI_FPR1_FPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_FPR1_FPIF2                     EXTI_FPR1_FPIF2_Msk                     /*!< Falling Pending Interrupt Flag on line 2 */
#define EXTI_FPR1_FPIF3_Pos                 (3U)
#define EXTI_FPR1_FPIF3_Msk                 (0x1UL << EXTI_FPR1_FPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_FPR1_FPIF3                     EXTI_FPR1_FPIF3_Msk                     /*!< Falling Pending Interrupt Flag on line 3 */
#define EXTI_FPR1_FPIF4_Pos                 (4U)
#define EXTI_FPR1_FPIF4_Msk                 (0x1UL << EXTI_FPR1_FPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_FPR1_FPIF4                     EXTI_FPR1_FPIF4_Msk                     /*!< Falling Pending Interrupt Flag on line 4 */
#define EXTI_FPR1_FPIF5_Pos                 (5U)
#define EXTI_FPR1_FPIF5_Msk                 (0x1UL << EXTI_FPR1_FPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_FPR1_FPIF5                     EXTI_FPR1_FPIF5_Msk                     /*!< Falling Pending Interrupt Flag on line 5 */
#define EXTI_FPR1_FPIF6_Pos                 (6U)
#define EXTI_FPR1_FPIF6_Msk                 (0x1UL << EXTI_FPR1_FPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_FPR1_FPIF6                     EXTI_FPR1_FPIF6_Msk                     /*!< Falling Pending Interrupt Flag on line 6 */
#define EXTI_FPR1_FPIF7_Pos                 (7U)
#define EXTI_FPR1_FPIF7_Msk                 (0x1UL << EXTI_FPR1_FPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_FPR1_FPIF7                     EXTI_FPR1_FPIF7_Msk                     /*!< Falling Pending Interrupt Flag on line 7 */
#define EXTI_FPR1_FPIF8_Pos                 (8U)
#define EXTI_FPR1_FPIF8_Msk                 (0x1UL << EXTI_FPR1_FPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_FPR1_FPIF8                     EXTI_FPR1_FPIF8_Msk                     /*!< Falling Pending Interrupt Flag on line 8 */
#define EXTI_FPR1_FPIF9_Pos                 (9U)
#define EXTI_FPR1_FPIF9_Msk                 (0x1UL << EXTI_FPR1_FPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_FPR1_FPIF9                     EXTI_FPR1_FPIF9_Msk                     /*!< Falling Pending Interrupt Flag on line 9 */
#define EXTI_FPR1_FPIF10_Pos                (10U)
#define EXTI_FPR1_FPIF10_Msk                (0x1UL << EXTI_FPR1_FPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_FPR1_FPIF10                    EXTI_FPR1_FPIF10_Msk                    /*!< Falling Pending Interrupt Flag on line 10 */
#define EXTI_FPR1_FPIF11_Pos                (11U)
#define EXTI_FPR1_FPIF11_Msk                (0x1UL << EXTI_FPR1_FPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_FPR1_FPIF11                    EXTI_FPR1_FPIF11_Msk                    /*!< Falling Pending Interrupt Flag on line 11 */
#define EXTI_FPR1_FPIF12_Pos                (12U)
#define EXTI_FPR1_FPIF12_Msk                (0x1UL << EXTI_FPR1_FPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_FPR1_FPIF12                    EXTI_FPR1_FPIF12_Msk                    /*!< Falling Pending Interrupt Flag on line 12 */
#define EXTI_FPR1_FPIF13_Pos                (13U)
#define EXTI_FPR1_FPIF13_Msk                (0x1UL << EXTI_FPR1_FPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_FPR1_FPIF13                    EXTI_FPR1_FPIF13_Msk                    /*!< Falling Pending Interrupt Flag on line 13 */
#define EXTI_FPR1_FPIF14_Pos                (14U)
#define EXTI_FPR1_FPIF14_Msk                (0x1UL << EXTI_FPR1_FPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_FPR1_FPIF14                    EXTI_FPR1_FPIF14_Msk                    /*!< Falling Pending Interrupt Flag on line 14 */
#define EXTI_FPR1_FPIF15_Pos                (15U)
#define EXTI_FPR1_FPIF15_Msk                (0x1UL << EXTI_FPR1_FPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_FPR1_FPIF15                    EXTI_FPR1_FPIF15_Msk                    /*!< Falling Pending Interrupt Flag on line 15 */
#define EXTI_FPR1_FPIF16_Pos                (16U)
#define EXTI_FPR1_FPIF16_Msk                (0x1UL << EXTI_FPR1_FPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_FPR1_FPIF16                    EXTI_FPR1_FPIF16_Msk                    /*!< Falling Pending Interrupt Flag on line 16 */
#define EXTI_FPR1_FPIF17_Pos                (17U)
#define EXTI_FPR1_FPIF17_Msk                (0x1UL << EXTI_FPR1_FPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_FPR1_FPIF17                    EXTI_FPR1_FPIF17_Msk                    /*!< Falling Pending Interrupt Flag on line 17 */
#define EXTI_FPR1_FPIF18_Pos                (18U)
#define EXTI_FPR1_FPIF18_Msk                (0x1UL << EXTI_FPR1_FPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_FPR1_FPIF18                    EXTI_FPR1_FPIF18_Msk                    /*!< Falling Pending Interrupt Flag on line 18 */
#define EXTI_FPR1_FPIF19_Pos                (19U)
#define EXTI_FPR1_FPIF19_Msk                (0x1UL << EXTI_FPR1_FPIF19_Pos)         /*!< 0x00080000 */
#define EXTI_FPR1_FPIF19                    EXTI_FPR1_FPIF19_Msk                    /*!< Falling Pending Interrupt Flag on line 19 */
#define EXTI_FPR1_FPIF20_Pos                (20U)
#define EXTI_FPR1_FPIF20_Msk                (0x1UL << EXTI_FPR1_FPIF20_Pos)         /*!< 0x00100000 */
#define EXTI_FPR1_FPIF20                    EXTI_FPR1_FPIF20_Msk                    /*!< Falling Pending Interrupt Flag on line 20 */
#define EXTI_FPR1_FPIF21_Pos                (21U)
#define EXTI_FPR1_FPIF21_Msk                (0x1UL << EXTI_FPR1_FPIF21_Pos)         /*!< 0x00200000 */
#define EXTI_FPR1_FPIF21                    EXTI_FPR1_FPIF21_Msk                    /*!< Falling Pending Interrupt Flag on line 21 */
#define EXTI_FPR1_FPIF22_Pos                (22U)
#define EXTI_FPR1_FPIF22_Msk                (0x1UL << EXTI_FPR1_FPIF22_Pos)         /*!< 0x00400000 */
#define EXTI_FPR1_FPIF22                    EXTI_FPR1_FPIF22_Msk                    /*!< Falling Pending Interrupt Flag on line 22 */

/*******************  Bit definition for EXTI_SECENR1 register  ******************/
#define EXTI_SECCFGR1_RPIF0_Pos             (0U)
#define EXTI_SECCFGR1_RPIF0_Msk             (0x1UL << EXTI_SECCFGR1_RPIF0_Pos)      /*!< 0x00000001 */
#define EXTI_SECCFGR1_RPIF0                 EXTI_SECCFGR1_RPIF0_Msk                 /*!< Security enable on line 0 */
#define EXTI_SECCFGR1_RPIF1_Pos             (1U)
#define EXTI_SECCFGR1_RPIF1_Msk             (0x1UL << EXTI_SECCFGR1_RPIF1_Pos)      /*!< 0x00000002 */
#define EXTI_SECCFGR1_RPIF1                 EXTI_SECCFGR1_RPIF1_Msk                 /*!< Security enable on line 1 */
#define EXTI_SECCFGR1_RPIF2_Pos             (2U)
#define EXTI_SECCFGR1_RPIF2_Msk             (0x1UL << EXTI_SECCFGR1_RPIF2_Pos)      /*!< 0x00000004 */
#define EXTI_SECCFGR1_RPIF2                 EXTI_SECCFGR1_RPIF2_Msk                 /*!< Security enable on line 2 */
#define EXTI_SECCFGR1_RPIF3_Pos             (3U)
#define EXTI_SECCFGR1_RPIF3_Msk             (0x1UL << EXTI_SECCFGR1_RPIF3_Pos)      /*!< 0x00000008 */
#define EXTI_SECCFGR1_RPIF3                 EXTI_SECCFGR1_RPIF3_Msk                 /*!< Security enable on line 3 */
#define EXTI_SECCFGR1_RPIF4_Pos             (4U)
#define EXTI_SECCFGR1_RPIF4_Msk             (0x1UL << EXTI_SECCFGR1_RPIF4_Pos)      /*!< 0x00000010 */
#define EXTI_SECCFGR1_RPIF4                 EXTI_SECCFGR1_RPIF4_Msk                 /*!< Security enable on line 4 */
#define EXTI_SECCFGR1_RPIF5_Pos             (5U)
#define EXTI_SECCFGR1_RPIF5_Msk             (0x1UL << EXTI_SECCFGR1_RPIF5_Pos)      /*!< 0x00000020 */
#define EXTI_SECCFGR1_RPIF5                 EXTI_SECCFGR1_RPIF5_Msk                 /*!< Security enable on line 5 */
#define EXTI_SECCFGR1_RPIF6_Pos             (6U)
#define EXTI_SECCFGR1_RPIF6_Msk             (0x1UL << EXTI_SECCFGR1_RPIF6_Pos)      /*!< 0x00000040 */
#define EXTI_SECCFGR1_RPIF6                 EXTI_SECCFGR1_RPIF6_Msk                 /*!< Security enable on line 6 */
#define EXTI_SECCFGR1_RPIF7_Pos             (7U)
#define EXTI_SECCFGR1_RPIF7_Msk             (0x1UL << EXTI_SECCFGR1_RPIF7_Pos)      /*!< 0x00000080 */
#define EXTI_SECCFGR1_RPIF7                 EXTI_SECCFGR1_RPIF7_Msk                 /*!< Security enable on line 7 */
#define EXTI_SECCFGR1_RPIF8_Pos             (8U)
#define EXTI_SECCFGR1_RPIF8_Msk             (0x1UL << EXTI_SECCFGR1_RPIF8_Pos)      /*!< 0x00000100 */
#define EXTI_SECCFGR1_RPIF8                 EXTI_SECCFGR1_RPIF8_Msk                 /*!< Security enable on line 8 */
#define EXTI_SECCFGR1_RPIF9_Pos             (9U)
#define EXTI_SECCFGR1_RPIF9_Msk             (0x1UL << EXTI_SECCFGR1_RPIF9_Pos)      /*!< 0x00000200 */
#define EXTI_SECCFGR1_RPIF9                 EXTI_SECCFGR1_RPIF9_Msk                 /*!< Security enable on line 9 */
#define EXTI_SECCFGR1_RPIF10_Pos            (10U)
#define EXTI_SECCFGR1_RPIF10_Msk            (0x1UL << EXTI_SECCFGR1_RPIF10_Pos)     /*!< 0x00000400 */
#define EXTI_SECCFGR1_RPIF10                EXTI_SECCFGR1_RPIF10_Msk                /*!< Security enable on line 10 */
#define EXTI_SECCFGR1_RPIF11_Pos            (11U)
#define EXTI_SECCFGR1_RPIF11_Msk            (0x1UL << EXTI_SECCFGR1_RPIF11_Pos)     /*!< 0x00000800 */
#define EXTI_SECCFGR1_RPIF11                EXTI_SECCFGR1_RPIF11_Msk                /*!< Security enable on line 11 */
#define EXTI_SECCFGR1_RPIF12_Pos            (12U)
#define EXTI_SECCFGR1_RPIF12_Msk            (0x1UL << EXTI_SECCFGR1_RPIF12_Pos)     /*!< 0x00001000 */
#define EXTI_SECCFGR1_RPIF12                EXTI_SECCFGR1_RPIF12_Msk                /*!< Security enable on line 12 */
#define EXTI_SECCFGR1_RPIF13_Pos            (13U)
#define EXTI_SECCFGR1_RPIF13_Msk            (0x1UL << EXTI_SECCFGR1_RPIF13_Pos)     /*!< 0x00002000 */
#define EXTI_SECCFGR1_RPIF13                EXTI_SECCFGR1_RPIF13_Msk                /*!< Security enable on line 13 */
#define EXTI_SECCFGR1_RPIF14_Pos            (14U)
#define EXTI_SECCFGR1_RPIF14_Msk            (0x1UL << EXTI_SECCFGR1_RPIF14_Pos)     /*!< 0x00004000 */
#define EXTI_SECCFGR1_RPIF14                EXTI_SECCFGR1_RPIF14_Msk                /*!< Security enable on line 14 */
#define EXTI_SECCFGR1_RPIF15_Pos            (15U)
#define EXTI_SECCFGR1_RPIF15_Msk            (0x1UL << EXTI_SECCFGR1_RPIF15_Pos)     /*!< 0x00008000 */
#define EXTI_SECCFGR1_RPIF15                EXTI_SECCFGR1_RPIF15_Msk                /*!< Security enable on line 15 */
#define EXTI_SECCFGR1_RPIF16_Pos            (16U)
#define EXTI_SECCFGR1_RPIF16_Msk            (0x1UL << EXTI_SECCFGR1_RPIF16_Pos)     /*!< 0x00010000 */
#define EXTI_SECCFGR1_RPIF16                EXTI_SECCFGR1_RPIF16_Msk                /*!< Security enable on line 16 */
#define EXTI_SECCFGR1_RPIF17_Pos            (17U)
#define EXTI_SECCFGR1_RPIF17_Msk            (0x1UL << EXTI_SECCFGR1_RPIF17_Pos)     /*!< 0x00020000 */
#define EXTI_SECCFGR1_RPIF17                EXTI_SECCFGR1_RPIF17_Msk                /*!< Security enable on line 17 */
#define EXTI_SECCFGR1_RPIF18_Pos            (18U)
#define EXTI_SECCFGR1_RPIF18_Msk            (0x1UL << EXTI_SECCFGR1_RPIF18_Pos)     /*!< 0x00040000 */
#define EXTI_SECCFGR1_RPIF18                EXTI_SECCFGR1_RPIF18_Msk                /*!< Security enable on line 18 */
#define EXTI_SECCFGR1_RPIF19_Pos            (19U)
#define EXTI_SECCFGR1_RPIF19_Msk            (0x1UL << EXTI_SECCFGR1_RPIF19_Pos)     /*!< 0x00080000 */
#define EXTI_SECCFGR1_RPIF19                EXTI_SECCFGR1_RPIF19_Msk                /*!< Security enable on line 19 */
#define EXTI_SECCFGR1_RPIF20_Pos            (20U)
#define EXTI_SECCFGR1_RPIF20_Msk            (0x1UL << EXTI_SECCFGR1_RPIF20_Pos)     /*!< 0x00100000 */
#define EXTI_SECCFGR1_RPIF20                EXTI_SECCFGR1_RPIF20_Msk                /*!< Security enable on line 20 */
#define EXTI_SECCFGR1_RPIF21_Pos            (21U)
#define EXTI_SECCFGR1_RPIF21_Msk            (0x1UL << EXTI_SECCFGR1_RPIF21_Pos)     /*!< 0x00200000 */
#define EXTI_SECCFGR1_RPIF21                EXTI_SECCFGR1_RPIF21_Msk                /*!< Security enable on line 21 */
#define EXTI_SECCFGR1_RPIF22_Pos            (22U)
#define EXTI_SECCFGR1_RPIF22_Msk            (0x1UL << EXTI_SECCFGR1_RPIF22_Pos)     /*!< 0x00400000 */
#define EXTI_SECCFGR1_RPIF22                EXTI_SECCFGR1_RPIF22_Msk                /*!< Security enable on line 22 */

/*******************  Bit definition for EXTI_PRIVENR1 register  ******************/
#define EXTI_PRIVCFGR1_RPIF0_Pos            (0U)
#define EXTI_PRIVCFGR1_RPIF0_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF0_Pos)     /*!< 0x00000001 */
#define EXTI_PRIVCFGR1_RPIF0                EXTI_PRIVCFGR1_RPIF0_Msk                /*!< Privilege enable on line 0 */
#define EXTI_PRIVCFGR1_RPIF1_Pos            (1U)
#define EXTI_PRIVCFGR1_RPIF1_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF1_Pos)     /*!< 0x00000002 */
#define EXTI_PRIVCFGR1_RPIF1                EXTI_PRIVCFGR1_RPIF1_Msk                /*!< Privilege enable on line 1 */
#define EXTI_PRIVCFGR1_RPIF2_Pos            (2U)
#define EXTI_PRIVCFGR1_RPIF2_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF2_Pos)     /*!< 0x00000004 */
#define EXTI_PRIVCFGR1_RPIF2                EXTI_PRIVCFGR1_RPIF2_Msk                /*!< Privilege enable on line 2 */
#define EXTI_PRIVCFGR1_RPIF3_Pos            (3U)
#define EXTI_PRIVCFGR1_RPIF3_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF3_Pos)     /*!< 0x00000008 */
#define EXTI_PRIVCFGR1_RPIF3                EXTI_PRIVCFGR1_RPIF3_Msk                /*!< Privilege enable on line 3 */
#define EXTI_PRIVCFGR1_RPIF4_Pos            (4U)
#define EXTI_PRIVCFGR1_RPIF4_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF4_Pos)     /*!< 0x00000010 */
#define EXTI_PRIVCFGR1_RPIF4                EXTI_PRIVCFGR1_RPIF4_Msk                /*!< Privilege enable on line 4 */
#define EXTI_PRIVCFGR1_RPIF5_Pos            (5U)
#define EXTI_PRIVCFGR1_RPIF5_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF5_Pos)     /*!< 0x00000020 */
#define EXTI_PRIVCFGR1_RPIF5                EXTI_PRIVCFGR1_RPIF5_Msk                /*!< Privilege enable on line 5 */
#define EXTI_PRIVCFGR1_RPIF6_Pos            (6U)
#define EXTI_PRIVCFGR1_RPIF6_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF6_Pos)     /*!< 0x00000040 */
#define EXTI_PRIVCFGR1_RPIF6                EXTI_PRIVCFGR1_RPIF6_Msk                /*!< Privilege enable on line 6 */
#define EXTI_PRIVCFGR1_RPIF7_Pos            (7U)
#define EXTI_PRIVCFGR1_RPIF7_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF7_Pos)     /*!< 0x00000080 */
#define EXTI_PRIVCFGR1_RPIF7                EXTI_PRIVCFGR1_RPIF7_Msk                /*!< Privilege enable on line 7 */
#define EXTI_PRIVCFGR1_RPIF8_Pos            (8U)
#define EXTI_PRIVCFGR1_RPIF8_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF8_Pos)     /*!< 0x00000100 */
#define EXTI_PRIVCFGR1_RPIF8                EXTI_PRIVCFGR1_RPIF8_Msk                /*!< Privilege enable on line 8 */
#define EXTI_PRIVCFGR1_RPIF9_Pos            (9U)
#define EXTI_PRIVCFGR1_RPIF9_Msk            (0x1UL << EXTI_PRIVCFGR1_RPIF9_Pos)     /*!< 0x00000200 */
#define EXTI_PRIVCFGR1_RPIF9                EXTI_PRIVCFGR1_RPIF9_Msk                /*!< Privilege enable on line 9 */
#define EXTI_PRIVCFGR1_RPIF10_Pos           (10U)
#define EXTI_PRIVCFGR1_RPIF10_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF10_Pos)    /*!< 0x00000400 */
#define EXTI_PRIVCFGR1_RPIF10               EXTI_PRIVCFGR1_RPIF10_Msk               /*!< Privilege enable on line 10 */
#define EXTI_PRIVCFGR1_RPIF11_Pos           (11U)
#define EXTI_PRIVCFGR1_RPIF11_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF11_Pos)    /*!< 0x00000800 */
#define EXTI_PRIVCFGR1_RPIF11               EXTI_PRIVCFGR1_RPIF11_Msk               /*!< Privilege enable on line 11 */
#define EXTI_PRIVCFGR1_RPIF12_Pos           (12U)
#define EXTI_PRIVCFGR1_RPIF12_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF12_Pos)    /*!< 0x00001000 */
#define EXTI_PRIVCFGR1_RPIF12               EXTI_PRIVCFGR1_RPIF12_Msk               /*!< Privilege enable on line 12 */
#define EXTI_PRIVCFGR1_RPIF13_Pos           (13U)
#define EXTI_PRIVCFGR1_RPIF13_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF13_Pos)    /*!< 0x00002000 */
#define EXTI_PRIVCFGR1_RPIF13               EXTI_PRIVCFGR1_RPIF13_Msk               /*!< Privilege enable on line 13 */
#define EXTI_PRIVCFGR1_RPIF14_Pos           (14U)
#define EXTI_PRIVCFGR1_RPIF14_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF14_Pos)    /*!< 0x00004000 */
#define EXTI_PRIVCFGR1_RPIF14               EXTI_PRIVCFGR1_RPIF14_Msk               /*!< Privilege enable on line 14 */
#define EXTI_PRIVCFGR1_RPIF15_Pos           (15U)
#define EXTI_PRIVCFGR1_RPIF15_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF15_Pos)    /*!< 0x00008000 */
#define EXTI_PRIVCFGR1_RPIF15               EXTI_PRIVCFGR1_RPIF15_Msk               /*!< Privilege enable on line 15 */
#define EXTI_PRIVCFGR1_RPIF16_Pos           (16U)
#define EXTI_PRIVCFGR1_RPIF16_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF16_Pos)    /*!< 0x00010000 */
#define EXTI_PRIVCFGR1_RPIF16               EXTI_PRIVCFGR1_RPIF16_Msk               /*!< Privilege enable on line 16 */
#define EXTI_PRIVCFGR1_RPIF17_Pos           (17U)
#define EXTI_PRIVCFGR1_RPIF17_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF17_Pos)    /*!< 0x00020000 */
#define EXTI_PRIVCFGR1_RPIF17               EXTI_PRIVCFGR1_RPIF17_Msk               /*!< Privilege enable on line 17 */
#define EXTI_PRIVCFGR1_RPIF18_Pos           (18U)
#define EXTI_PRIVCFGR1_RPIF18_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF18_Pos)    /*!< 0x00040000 */
#define EXTI_PRIVCFGR1_RPIF18               EXTI_PRIVCFGR1_RPIF18_Msk               /*!< Privilege enable on line 18 */
#define EXTI_PRIVCFGR1_RPIF19_Pos           (19U)
#define EXTI_PRIVCFGR1_RPIF19_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF19_Pos)    /*!< 0x00080000 */
#define EXTI_PRIVCFGR1_RPIF19               EXTI_PRIVCFGR1_RPIF19_Msk               /*!< Privilege enable on line 19 */
#define EXTI_PRIVCFGR1_RPIF20_Pos           (20U)
#define EXTI_PRIVCFGR1_RPIF20_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF20_Pos)    /*!< 0x00100000 */
#define EXTI_PRIVCFGR1_RPIF20               EXTI_PRIVCFGR1_RPIF20_Msk               /*!< Privilege enable on line 20 */
#define EXTI_PRIVCFGR1_RPIF21_Pos           (21U)
#define EXTI_PRIVCFGR1_RPIF21_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF21_Pos)    /*!< 0x00200000 */
#define EXTI_PRIVCFGR1_RPIF21               EXTI_PRIVCFGR1_RPIF21_Msk               /*!< Privilege enable on line 21 */
#define EXTI_PRIVCFGR1_RPIF22_Pos           (22U)
#define EXTI_PRIVCFGR1_RPIF22_Msk           (0x1UL << EXTI_PRIVCFGR1_RPIF22_Pos)    /*!< 0x00400000 */
#define EXTI_PRIVCFGR1_RPIF22               EXTI_PRIVCFGR1_RPIF22_Msk               /*!< Privilege enable on line 22 */

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
#define EXTI_EXTICR1_EXTI0_Pos              (0U)
#define EXTI_EXTICR1_EXTI0_Msk              (0xFUL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR1_EXTI0                  EXTI_EXTICR1_EXTI0_Msk                  /*!< EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI0_0                (0x1UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_1                (0x2UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_2                (0x4UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI0_3                (0x8UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR1_EXTI1_Pos              (8U)
#define EXTI_EXTICR1_EXTI1_Msk              (0xFUL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR1_EXTI1                  EXTI_EXTICR1_EXTI1_Msk                  /*!< EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI1_0                (0x1UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_1                (0x2UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_2                (0x4UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI1_3                (0x8UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR1_EXTI2_Pos              (16U)
#define EXTI_EXTICR1_EXTI2_Msk              (0xFUL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR1_EXTI2                  EXTI_EXTICR1_EXTI2_Msk                  /*!< EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI2_0                (0x1UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_1                (0x2UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_2                (0x4UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI2_3                (0x8UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR1_EXTI3_Pos              (24U)
#define EXTI_EXTICR1_EXTI3_Msk              (0xFUL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR1_EXTI3                  EXTI_EXTICR1_EXTI3_Msk                  /*!< EXTI 3 configuration */
#define EXTI_EXTICR1_EXTI3_0                (0x1UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_1                (0x2UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_2                (0x4UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR1_EXTI3_3                (0x8UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
#define EXTI_EXTICR2_EXTI4_Pos              (0U)
#define EXTI_EXTICR2_EXTI4_Msk              (0xFUL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR2_EXTI4                  EXTI_EXTICR2_EXTI4_Msk                  /*!< EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI4_0                (0x1UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_1                (0x2UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_2                (0x4UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI4_3                (0x8UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR2_EXTI5_Pos              (8U)
#define EXTI_EXTICR2_EXTI5_Msk              (0xFUL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR2_EXTI5                  EXTI_EXTICR2_EXTI5_Msk                  /*!< EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI5_0                (0x1UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_1                (0x2UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_2                (0x4UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI5_3                (0x8UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR2_EXTI6_Pos              (16U)
#define EXTI_EXTICR2_EXTI6_Msk              (0xFUL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR2_EXTI6                  EXTI_EXTICR2_EXTI6_Msk                  /*!< EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI6_0                (0x1UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_1                (0x2UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_2                (0x4UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI6_3                (0x8UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR2_EXTI7_Pos              (24U)
#define EXTI_EXTICR2_EXTI7_Msk              (0xFUL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR2_EXTI7                  EXTI_EXTICR2_EXTI7_Msk                  /*!< EXTI 7 configuration */
#define EXTI_EXTICR2_EXTI7_0                (0x1UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_1                (0x2UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_2                (0x4UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR2_EXTI7_3                (0x8UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
#define EXTI_EXTICR3_EXTI8_Pos              (0U)
#define EXTI_EXTICR3_EXTI8_Msk              (0xFUL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR3_EXTI8                  EXTI_EXTICR3_EXTI8_Msk                  /*!< EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI8_0                (0x1UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_1                (0x2UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_2                (0x4UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI8_3                (0x8UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR3_EXTI9_Pos              (8U)
#define EXTI_EXTICR3_EXTI9_Msk              (0xFUL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR3_EXTI9                  EXTI_EXTICR3_EXTI9_Msk                  /*!< EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI9_0                (0x1UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_1                (0x2UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_2                (0x4UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI9_3                (0x8UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR3_EXTI10_Pos             (16U)
#define EXTI_EXTICR3_EXTI10_Msk             (0xFUL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR3_EXTI10                 EXTI_EXTICR3_EXTI10_Msk                 /*!< EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI10_0               (0x1UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_1               (0x2UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_2               (0x4UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI10_3               (0x8UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR3_EXTI11_Pos             (24U)
#define EXTI_EXTICR3_EXTI11_Msk             (0xFUL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR3_EXTI11                 EXTI_EXTICR3_EXTI11_Msk                 /*!< EXTI 11 configuration */
#define EXTI_EXTICR3_EXTI11_0               (0x1UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_1               (0x2UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_2               (0x4UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR3_EXTI11_3               (0x8UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR4 register  **************/
#define EXTI_EXTICR4_EXTI12_Pos             (0U)
#define EXTI_EXTICR4_EXTI12_Msk             (0xFUL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR4_EXTI12                 EXTI_EXTICR4_EXTI12_Msk                 /*!< EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI12_0               (0x1UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_1               (0x2UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_2               (0x4UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI12_3               (0x8UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR4_EXTI13_Pos             (8U)
#define EXTI_EXTICR4_EXTI13_Msk             (0xFUL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR4_EXTI13                 EXTI_EXTICR4_EXTI13_Msk                 /*!< EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI13_0               (0x1UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_1               (0x2UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_2               (0x4UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI13_3               (0x8UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR4_EXTI14_Pos             (16U)
#define EXTI_EXTICR4_EXTI14_Msk             (0xFUL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR4_EXTI14                 EXTI_EXTICR4_EXTI14_Msk                 /*!< EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI14_0               (0x1UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_1               (0x2UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_2               (0x4UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI14_3               (0x8UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR4_EXTI15_Pos             (24U)
#define EXTI_EXTICR4_EXTI15_Msk             (0xFUL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR4_EXTI15                 EXTI_EXTICR4_EXTI15_Msk                 /*!< EXTI 15 configuration */
#define EXTI_EXTICR4_EXTI15_0               (0x1UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_1               (0x2UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_2               (0x4UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR4_EXTI15_3               (0x8UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x08000000 */

/*******************  Bit definition for EXTI_LOCKR register  *****************/
#define EXTI_LOCKR_LOCK_Pos                 (0U)
#define EXTI_LOCKR_LOCK_Msk                 (0x1UL << EXTI_LOCKR_LOCK_Pos)          /*!< 0x00000001 */
#define EXTI_LOCKR_LOCK                     EXTI_LOCKR_LOCK_Msk                     /*! Security and privilege lock */

/*******************  Bit definition for EXTI_IMR1 register  ******************/
#define EXTI_IMR1_IM0_Pos                   (0U)
#define EXTI_IMR1_IM0_Msk                   (0x1UL << EXTI_IMR1_IM0_Pos)            /*!< 0x00000001 */
#define EXTI_IMR1_IM0                       EXTI_IMR1_IM0_Msk                       /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos                   (1U)
#define EXTI_IMR1_IM1_Msk                   (0x1UL << EXTI_IMR1_IM1_Pos)            /*!< 0x00000002 */
#define EXTI_IMR1_IM1                       EXTI_IMR1_IM1_Msk                       /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos                   (2U)
#define EXTI_IMR1_IM2_Msk                   (0x1UL << EXTI_IMR1_IM2_Pos)            /*!< 0x00000004 */
#define EXTI_IMR1_IM2                       EXTI_IMR1_IM2_Msk                       /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos                   (3U)
#define EXTI_IMR1_IM3_Msk                   (0x1UL << EXTI_IMR1_IM3_Pos)            /*!< 0x00000008 */
#define EXTI_IMR1_IM3                       EXTI_IMR1_IM3_Msk                       /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos                   (4U)
#define EXTI_IMR1_IM4_Msk                   (0x1UL << EXTI_IMR1_IM4_Pos)            /*!< 0x00000010 */
#define EXTI_IMR1_IM4                       EXTI_IMR1_IM4_Msk                       /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos                   (5U)
#define EXTI_IMR1_IM5_Msk                   (0x1UL << EXTI_IMR1_IM5_Pos)            /*!< 0x00000020 */
#define EXTI_IMR1_IM5                       EXTI_IMR1_IM5_Msk                       /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos                   (6U)
#define EXTI_IMR1_IM6_Msk                   (0x1UL << EXTI_IMR1_IM6_Pos)            /*!< 0x00000040 */
#define EXTI_IMR1_IM6                       EXTI_IMR1_IM6_Msk                       /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos                   (7U)
#define EXTI_IMR1_IM7_Msk                   (0x1UL << EXTI_IMR1_IM7_Pos)            /*!< 0x00000080 */
#define EXTI_IMR1_IM7                       EXTI_IMR1_IM7_Msk                       /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos                   (8U)
#define EXTI_IMR1_IM8_Msk                   (0x1UL << EXTI_IMR1_IM8_Pos)            /*!< 0x00000100 */
#define EXTI_IMR1_IM8                       EXTI_IMR1_IM8_Msk                       /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos                   (9U)
#define EXTI_IMR1_IM9_Msk                   (0x1UL << EXTI_IMR1_IM9_Pos)            /*!< 0x00000200 */
#define EXTI_IMR1_IM9                       EXTI_IMR1_IM9_Msk                       /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos                  (10U)
#define EXTI_IMR1_IM10_Msk                  (0x1UL << EXTI_IMR1_IM10_Pos)           /*!< 0x00000400 */
#define EXTI_IMR1_IM10                      EXTI_IMR1_IM10_Msk                      /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos                  (11U)
#define EXTI_IMR1_IM11_Msk                  (0x1UL << EXTI_IMR1_IM11_Pos)           /*!< 0x00000800 */
#define EXTI_IMR1_IM11                      EXTI_IMR1_IM11_Msk                      /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos                  (12U)
#define EXTI_IMR1_IM12_Msk                  (0x1UL << EXTI_IMR1_IM12_Pos)           /*!< 0x00001000 */
#define EXTI_IMR1_IM12                      EXTI_IMR1_IM12_Msk                      /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos                  (13U)
#define EXTI_IMR1_IM13_Msk                  (0x1UL << EXTI_IMR1_IM13_Pos)           /*!< 0x00002000 */
#define EXTI_IMR1_IM13                      EXTI_IMR1_IM13_Msk                      /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos                  (14U)
#define EXTI_IMR1_IM14_Msk                  (0x1UL << EXTI_IMR1_IM14_Pos)           /*!< 0x00004000 */
#define EXTI_IMR1_IM14                      EXTI_IMR1_IM14_Msk                      /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos                  (15U)
#define EXTI_IMR1_IM15_Msk                  (0x1UL << EXTI_IMR1_IM15_Pos)           /*!< 0x00008000 */
#define EXTI_IMR1_IM15                      EXTI_IMR1_IM15_Msk                      /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos                  (16U)
#define EXTI_IMR1_IM16_Msk                  (0x1UL << EXTI_IMR1_IM16_Pos)           /*!< 0x00010000 */
#define EXTI_IMR1_IM16                      EXTI_IMR1_IM16_Msk                      /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos                  (17U)
#define EXTI_IMR1_IM17_Msk                  (0x1UL << EXTI_IMR1_IM17_Pos)           /*!< 0x00020000 */
#define EXTI_IMR1_IM17                      EXTI_IMR1_IM17_Msk                      /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos                  (18U)
#define EXTI_IMR1_IM18_Msk                  (0x1UL << EXTI_IMR1_IM18_Pos)           /*!< 0x00040000 */
#define EXTI_IMR1_IM18                      EXTI_IMR1_IM18_Msk                      /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos                  (19U)
#define EXTI_IMR1_IM19_Msk                  (0x1UL << EXTI_IMR1_IM19_Pos)           /*!< 0x00080000 */
#define EXTI_IMR1_IM19                      EXTI_IMR1_IM19_Msk                      /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos                  (20U)
#define EXTI_IMR1_IM20_Msk                  (0x1UL << EXTI_IMR1_IM20_Pos)           /*!< 0x00100000 */
#define EXTI_IMR1_IM20                      EXTI_IMR1_IM20_Msk                      /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos                  (21U)
#define EXTI_IMR1_IM21_Msk                  (0x1UL << EXTI_IMR1_IM21_Pos)           /*!< 0x00200000 */
#define EXTI_IMR1_IM21                      EXTI_IMR1_IM21_Msk                      /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos                  (22U)
#define EXTI_IMR1_IM22_Msk                  (0x1UL << EXTI_IMR1_IM22_Pos)           /*!< 0x00400000 */
#define EXTI_IMR1_IM22                      EXTI_IMR1_IM22_Msk                      /*!< Interrupt Mask on line 22 */

/*******************  Bit definition for EXTI_EMR1 register  ******************/
#define EXTI_EMR1_EM0_Pos                   (0U)
#define EXTI_EMR1_EM0_Msk                   (0x1UL << EXTI_EMR1_EM0_Pos)            /*!< 0x00000001 */
#define EXTI_EMR1_EM0                       EXTI_EMR1_EM0_Msk                       /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos                   (1U)
#define EXTI_EMR1_EM1_Msk                   (0x1UL << EXTI_EMR1_EM1_Pos)            /*!< 0x00000002 */
#define EXTI_EMR1_EM1                       EXTI_EMR1_EM1_Msk                       /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos                   (2U)
#define EXTI_EMR1_EM2_Msk                   (0x1UL << EXTI_EMR1_EM2_Pos)            /*!< 0x00000004 */
#define EXTI_EMR1_EM2                       EXTI_EMR1_EM2_Msk                       /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos                   (3U)
#define EXTI_EMR1_EM3_Msk                   (0x1UL << EXTI_EMR1_EM3_Pos)            /*!< 0x00000008 */
#define EXTI_EMR1_EM3                       EXTI_EMR1_EM3_Msk                       /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos                   (4U)
#define EXTI_EMR1_EM4_Msk                   (0x1UL << EXTI_EMR1_EM4_Pos)            /*!< 0x00000010 */
#define EXTI_EMR1_EM4                       EXTI_EMR1_EM4_Msk                       /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos                   (5U)
#define EXTI_EMR1_EM5_Msk                   (0x1UL << EXTI_EMR1_EM5_Pos)            /*!< 0x00000020 */
#define EXTI_EMR1_EM5                       EXTI_EMR1_EM5_Msk                       /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos                   (6U)
#define EXTI_EMR1_EM6_Msk                   (0x1UL << EXTI_EMR1_EM6_Pos)            /*!< 0x00000040 */
#define EXTI_EMR1_EM6                       EXTI_EMR1_EM6_Msk                       /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos                   (7U)
#define EXTI_EMR1_EM7_Msk                   (0x1UL << EXTI_EMR1_EM7_Pos)            /*!< 0x00000080 */
#define EXTI_EMR1_EM7                       EXTI_EMR1_EM7_Msk                       /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos                   (8U)
#define EXTI_EMR1_EM8_Msk                   (0x1UL << EXTI_EMR1_EM8_Pos)            /*!< 0x00000100 */
#define EXTI_EMR1_EM8                       EXTI_EMR1_EM8_Msk                       /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos                   (9U)
#define EXTI_EMR1_EM9_Msk                   (0x1UL << EXTI_EMR1_EM9_Pos)            /*!< 0x00000200 */
#define EXTI_EMR1_EM9                       EXTI_EMR1_EM9_Msk                       /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos                  (10U)
#define EXTI_EMR1_EM10_Msk                  (0x1UL << EXTI_EMR1_EM10_Pos)           /*!< 0x00000400 */
#define EXTI_EMR1_EM10                      EXTI_EMR1_EM10_Msk                      /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos                  (11U)
#define EXTI_EMR1_EM11_Msk                  (0x1UL << EXTI_EMR1_EM11_Pos)           /*!< 0x00000800 */
#define EXTI_EMR1_EM11                      EXTI_EMR1_EM11_Msk                      /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos                  (12U)
#define EXTI_EMR1_EM12_Msk                  (0x1UL << EXTI_EMR1_EM12_Pos)           /*!< 0x00001000 */
#define EXTI_EMR1_EM12                      EXTI_EMR1_EM12_Msk                      /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos                  (13U)
#define EXTI_EMR1_EM13_Msk                  (0x1UL << EXTI_EMR1_EM13_Pos)           /*!< 0x00002000 */
#define EXTI_EMR1_EM13                      EXTI_EMR1_EM13_Msk                      /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos                  (14U)
#define EXTI_EMR1_EM14_Msk                  (0x1UL << EXTI_EMR1_EM14_Pos)           /*!< 0x00004000 */
#define EXTI_EMR1_EM14                      EXTI_EMR1_EM14_Msk                      /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos                  (15U)
#define EXTI_EMR1_EM15_Msk                  (0x1UL << EXTI_EMR1_EM15_Pos)           /*!< 0x00008000 */
#define EXTI_EMR1_EM15                      EXTI_EMR1_EM15_Msk                      /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos                  (16U)
#define EXTI_EMR1_EM16_Msk                  (0x1UL << EXTI_EMR1_EM16_Pos)           /*!< 0x00010000 */
#define EXTI_EMR1_EM16                      EXTI_EMR1_EM16_Msk                      /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos                  (17U)
#define EXTI_EMR1_EM17_Msk                  (0x1UL << EXTI_EMR1_EM17_Pos)           /*!< 0x00020000 */
#define EXTI_EMR1_EM17                      EXTI_EMR1_EM17_Msk                      /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos                  (18U)
#define EXTI_EMR1_EM18_Msk                  (0x1UL << EXTI_EMR1_EM18_Pos)           /*!< 0x00040000 */
#define EXTI_EMR1_EM18                      EXTI_EMR1_EM18_Msk                      /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM19_Pos                  (19U)
#define EXTI_EMR1_EM19_Msk                  (0x1UL << EXTI_EMR1_EM19_Pos)           /*!< 0x00080000 */
#define EXTI_EMR1_EM19                      EXTI_EMR1_EM19_Msk                      /*!< Event Mask on line 19 */
#define EXTI_EMR1_EM20_Pos                  (20U)
#define EXTI_EMR1_EM20_Msk                  (0x1UL << EXTI_EMR1_EM20_Pos)           /*!< 0x00100000 */
#define EXTI_EMR1_EM20                      EXTI_EMR1_EM20_Msk                      /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos                  (21U)
#define EXTI_EMR1_EM21_Msk                  (0x1UL << EXTI_EMR1_EM21_Pos)           /*!< 0x00200000 */
#define EXTI_EMR1_EM21                      EXTI_EMR1_EM21_Msk                      /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos                  (22U)
#define EXTI_EMR1_EM22_Msk                  (0x1UL << EXTI_EMR1_EM22_Pos)           /*!< 0x00400000 */
#define EXTI_EMR1_EM22                      EXTI_EMR1_EM22_Msk                      /*!< Event Mask on line 22 */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos                  (0U)
#define FDCAN_CREL_DAY_Msk                  (0xFFUL << FDCAN_CREL_DAY_Pos)          /*!< 0x000000FF */
#define FDCAN_CREL_DAY                      FDCAN_CREL_DAY_Msk                      /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos                  (8U)
#define FDCAN_CREL_MON_Msk                  (0xFFUL << FDCAN_CREL_MON_Pos)          /*!< 0x0000FF00 */
#define FDCAN_CREL_MON                      FDCAN_CREL_MON_Msk                      /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos                 (16U)
#define FDCAN_CREL_YEAR_Msk                 (0xFUL << FDCAN_CREL_YEAR_Pos)          /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR                     FDCAN_CREL_YEAR_Msk                     /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos              (20U)
#define FDCAN_CREL_SUBSTEP_Msk              (0xFUL << FDCAN_CREL_SUBSTEP_Pos)       /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP                  FDCAN_CREL_SUBSTEP_Msk                  /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos                 (24U)
#define FDCAN_CREL_STEP_Msk                 (0xFUL << FDCAN_CREL_STEP_Pos)          /*!< 0x0F000000 */
#define FDCAN_CREL_STEP                     FDCAN_CREL_STEP_Msk                     /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos                  (28U)
#define FDCAN_CREL_REL_Msk                  (0xFUL << FDCAN_CREL_REL_Pos)           /*!< 0xF0000000 */
#define FDCAN_CREL_REL                      FDCAN_CREL_REL_Msk                      /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos                  (0U)
#define FDCAN_ENDN_ETV_Msk                  (0xFFFFFFFFUL << FDCAN_ENDN_ETV_Pos)    /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV                      FDCAN_ENDN_ETV_Msk                      /*!<Endianness Test Value                    */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos                 (0U)
#define FDCAN_DBTP_DSJW_Msk                 (0xFUL << FDCAN_DBTP_DSJW_Pos)          /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW                     FDCAN_DBTP_DSJW_Msk                     /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos               (4U)
#define FDCAN_DBTP_DTSEG2_Msk               (0xFUL << FDCAN_DBTP_DTSEG2_Pos)        /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2                   FDCAN_DBTP_DTSEG2_Msk                   /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos               (8U)
#define FDCAN_DBTP_DTSEG1_Msk               (0x1FUL << FDCAN_DBTP_DTSEG1_Pos)       /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1                   FDCAN_DBTP_DTSEG1_Msk                   /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos                 (16U)
#define FDCAN_DBTP_DBRP_Msk                 (0x1FUL << FDCAN_DBTP_DBRP_Pos)         /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP                     FDCAN_DBTP_DBRP_Msk                     /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos                  (23U)
#define FDCAN_DBTP_TDC_Msk                  (0x1UL << FDCAN_DBTP_TDC_Pos)           /*!< 0x00800000 */
#define FDCAN_DBTP_TDC                      FDCAN_DBTP_TDC_Msk                      /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos                 (4U)
#define FDCAN_TEST_LBCK_Msk                 (0x1UL << FDCAN_TEST_LBCK_Pos)          /*!< 0x00000010 */
#define FDCAN_TEST_LBCK                     FDCAN_TEST_LBCK_Msk                     /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos                   (5U)
#define FDCAN_TEST_TX_Msk                   (0x3UL << FDCAN_TEST_TX_Pos)            /*!< 0x00000060 */
#define FDCAN_TEST_TX                       FDCAN_TEST_TX_Msk                       /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos                   (7U)
#define FDCAN_TEST_RX_Msk                   (0x1UL << FDCAN_TEST_RX_Pos)            /*!< 0x00000080 */
#define FDCAN_TEST_RX                       FDCAN_TEST_RX_Msk                       /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos                   (0U)
#define FDCAN_RWD_WDC_Msk                   (0xFFUL << FDCAN_RWD_WDC_Pos)           /*!< 0x000000FF */
#define FDCAN_RWD_WDC                       FDCAN_RWD_WDC_Msk                       /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos                   (8U)
#define FDCAN_RWD_WDV_Msk                   (0xFFUL << FDCAN_RWD_WDV_Pos)           /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV                       FDCAN_RWD_WDV_Msk                       /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos                 (0U)
#define FDCAN_CCCR_INIT_Msk                 (0x1UL << FDCAN_CCCR_INIT_Pos)          /*!< 0x00000001 */
#define FDCAN_CCCR_INIT                     FDCAN_CCCR_INIT_Msk                     /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos                  (1U)
#define FDCAN_CCCR_CCE_Msk                  (0x1UL << FDCAN_CCCR_CCE_Pos)           /*!< 0x00000002 */
#define FDCAN_CCCR_CCE                      FDCAN_CCCR_CCE_Msk                      /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos                  (2U)
#define FDCAN_CCCR_ASM_Msk                  (0x1UL << FDCAN_CCCR_ASM_Pos)           /*!< 0x00000004 */
#define FDCAN_CCCR_ASM                      FDCAN_CCCR_ASM_Msk                      /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos                  (3U)
#define FDCAN_CCCR_CSA_Msk                  (0x1UL << FDCAN_CCCR_CSA_Pos)           /*!< 0x00000008 */
#define FDCAN_CCCR_CSA                      FDCAN_CCCR_CSA_Msk                      /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos                  (4U)
#define FDCAN_CCCR_CSR_Msk                  (0x1UL << FDCAN_CCCR_CSR_Pos)           /*!< 0x00000010 */
#define FDCAN_CCCR_CSR                      FDCAN_CCCR_CSR_Msk                      /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos                  (5U)
#define FDCAN_CCCR_MON_Msk                  (0x1UL << FDCAN_CCCR_MON_Pos)           /*!< 0x00000020 */
#define FDCAN_CCCR_MON                      FDCAN_CCCR_MON_Msk                      /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos                  (6U)
#define FDCAN_CCCR_DAR_Msk                  (0x1UL << FDCAN_CCCR_DAR_Pos)           /*!< 0x00000040 */
#define FDCAN_CCCR_DAR                      FDCAN_CCCR_DAR_Msk                      /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos                 (7U)
#define FDCAN_CCCR_TEST_Msk                 (0x1UL << FDCAN_CCCR_TEST_Pos)          /*!< 0x00000080 */
#define FDCAN_CCCR_TEST                     FDCAN_CCCR_TEST_Msk                     /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos                 (8U)
#define FDCAN_CCCR_FDOE_Msk                 (0x1UL << FDCAN_CCCR_FDOE_Pos)          /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE                     FDCAN_CCCR_FDOE_Msk                     /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos                 (9U)
#define FDCAN_CCCR_BRSE_Msk                 (0x1UL << FDCAN_CCCR_BRSE_Pos)          /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE                     FDCAN_CCCR_BRSE_Msk                     /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos                 (12U)
#define FDCAN_CCCR_PXHD_Msk                 (0x1UL << FDCAN_CCCR_PXHD_Pos)          /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD                     FDCAN_CCCR_PXHD_Msk                     /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos                 (13U)
#define FDCAN_CCCR_EFBI_Msk                 (0x1UL << FDCAN_CCCR_EFBI_Pos)          /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI                     FDCAN_CCCR_EFBI_Msk                     /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos                  (14U)
#define FDCAN_CCCR_TXP_Msk                  (0x1UL << FDCAN_CCCR_TXP_Pos)           /*!< 0x00004000 */
#define FDCAN_CCCR_TXP                      FDCAN_CCCR_TXP_Msk                      /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos                 (15U)
#define FDCAN_CCCR_NISO_Msk                 (0x1UL << FDCAN_CCCR_NISO_Pos)          /*!< 0x00008000 */
#define FDCAN_CCCR_NISO                     FDCAN_CCCR_NISO_Msk                     /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ******************* */
#define FDCAN_NBTP_NTSEG2_Pos               (0U)
#define FDCAN_NBTP_NTSEG2_Msk               (0x7FUL << FDCAN_NBTP_NTSEG2_Pos)       /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2                   FDCAN_NBTP_NTSEG2_Msk                   /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos               (8U)
#define FDCAN_NBTP_NTSEG1_Msk               (0xFFUL << FDCAN_NBTP_NTSEG1_Pos)       /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1                   FDCAN_NBTP_NTSEG1_Msk                   /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos                 (16U)
#define FDCAN_NBTP_NBRP_Msk                 (0x1FFUL << FDCAN_NBTP_NBRP_Pos)        /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP                     FDCAN_NBTP_NBRP_Msk                     /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos                 (25U)
#define FDCAN_NBTP_NSJW_Msk                 (0x7FUL << FDCAN_NBTP_NSJW_Pos)         /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW                     FDCAN_NBTP_NSJW_Msk                     /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos                  (0U)
#define FDCAN_TSCC_TSS_Msk                  (0x3UL << FDCAN_TSCC_TSS_Pos)           /*!< 0x00000003 */
#define FDCAN_TSCC_TSS                      FDCAN_TSCC_TSS_Msk                      /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos                  (16U)
#define FDCAN_TSCC_TCP_Msk                  (0xFUL << FDCAN_TSCC_TCP_Pos)           /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP                      FDCAN_TSCC_TCP_Msk                      /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos                  (0U)
#define FDCAN_TSCV_TSC_Msk                  (0xFFFFUL << FDCAN_TSCV_TSC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC                      FDCAN_TSCV_TSC_Msk                      /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos                 (0U)
#define FDCAN_TOCC_ETOC_Msk                 (0x1UL << FDCAN_TOCC_ETOC_Pos)          /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC                     FDCAN_TOCC_ETOC_Msk                     /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos                  (1U)
#define FDCAN_TOCC_TOS_Msk                  (0x3UL << FDCAN_TOCC_TOS_Pos)           /*!< 0x00000006 */
#define FDCAN_TOCC_TOS                      FDCAN_TOCC_TOS_Msk                      /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos                  (16U)
#define FDCAN_TOCC_TOP_Msk                  (0xFFFFUL << FDCAN_TOCC_TOP_Pos)        /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP                      FDCAN_TOCC_TOP_Msk                      /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ******************* */
#define FDCAN_TOCV_TOC_Pos                  (0U)
#define FDCAN_TOCV_TOC_Msk                  (0xFFFFUL << FDCAN_TOCV_TOC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC                      FDCAN_TOCV_TOC_Msk                      /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  ******************** */
#define FDCAN_ECR_TEC_Pos                   (0U)
#define FDCAN_ECR_TEC_Msk                   (0xFFUL << FDCAN_ECR_TEC_Pos)           /*!< 0x000000FF */
#define FDCAN_ECR_TEC                       FDCAN_ECR_TEC_Msk                       /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos                   (8U)
#define FDCAN_ECR_REC_Msk                   (0x7FUL << FDCAN_ECR_REC_Pos)           /*!< 0x00007F00 */
#define FDCAN_ECR_REC                       FDCAN_ECR_REC_Msk                       /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos                    (15U)
#define FDCAN_ECR_RP_Msk                    (0x1UL << FDCAN_ECR_RP_Pos)             /*!< 0x00008000 */
#define FDCAN_ECR_RP                        FDCAN_ECR_RP_Msk                        /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos                   (16U)
#define FDCAN_ECR_CEL_Msk                   (0xFFUL << FDCAN_ECR_CEL_Pos)           /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL                       FDCAN_ECR_CEL_Msk                       /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  ******************** */
#define FDCAN_PSR_LEC_Pos                   (0U)
#define FDCAN_PSR_LEC_Msk                   (0x7UL << FDCAN_PSR_LEC_Pos)            /*!< 0x00000007 */
#define FDCAN_PSR_LEC                       FDCAN_PSR_LEC_Msk                       /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos                   (3U)
#define FDCAN_PSR_ACT_Msk                   (0x3UL << FDCAN_PSR_ACT_Pos)            /*!< 0x00000018 */
#define FDCAN_PSR_ACT                       FDCAN_PSR_ACT_Msk                       /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos                    (5U)
#define FDCAN_PSR_EP_Msk                    (0x1UL << FDCAN_PSR_EP_Pos)             /*!< 0x00000020 */
#define FDCAN_PSR_EP                        FDCAN_PSR_EP_Msk                        /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos                    (6U)
#define FDCAN_PSR_EW_Msk                    (0x1UL << FDCAN_PSR_EW_Pos)             /*!< 0x00000040 */
#define FDCAN_PSR_EW                        FDCAN_PSR_EW_Msk                        /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos                    (7U)
#define FDCAN_PSR_BO_Msk                    (0x1UL << FDCAN_PSR_BO_Pos)             /*!< 0x00000080 */
#define FDCAN_PSR_BO                        FDCAN_PSR_BO_Msk                        /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos                  (8U)
#define FDCAN_PSR_DLEC_Msk                  (0x7UL << FDCAN_PSR_DLEC_Pos)           /*!< 0x00000700 */
#define FDCAN_PSR_DLEC                      FDCAN_PSR_DLEC_Msk                      /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos                  (11U)
#define FDCAN_PSR_RESI_Msk                  (0x1UL << FDCAN_PSR_RESI_Pos)           /*!< 0x00000800 */
#define FDCAN_PSR_RESI                      FDCAN_PSR_RESI_Msk                      /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos                  (12U)
#define FDCAN_PSR_RBRS_Msk                  (0x1UL << FDCAN_PSR_RBRS_Pos)           /*!< 0x00001000 */
#define FDCAN_PSR_RBRS                      FDCAN_PSR_RBRS_Msk                      /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos                  (13U)
#define FDCAN_PSR_REDL_Msk                  (0x1UL << FDCAN_PSR_REDL_Pos)           /*!< 0x00002000 */
#define FDCAN_PSR_REDL                      FDCAN_PSR_REDL_Msk                      /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos                   (14U)
#define FDCAN_PSR_PXE_Msk                   (0x1UL << FDCAN_PSR_PXE_Pos)            /*!< 0x00004000 */
#define FDCAN_PSR_PXE                       FDCAN_PSR_PXE_Msk                       /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos                  (16U)
#define FDCAN_PSR_TDCV_Msk                  (0x7FUL << FDCAN_PSR_TDCV_Pos)          /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV                      FDCAN_PSR_TDCV_Msk                      /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ******************* */
#define FDCAN_TDCR_TDCF_Pos                 (0U)
#define FDCAN_TDCR_TDCF_Msk                 (0x7FUL << FDCAN_TDCR_TDCF_Pos)         /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF                     FDCAN_TDCR_TDCF_Msk                     /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos                 (8U)
#define FDCAN_TDCR_TDCO_Msk                 (0x7FUL << FDCAN_TDCR_TDCO_Pos)         /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO                     FDCAN_TDCR_TDCO_Msk                     /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  ********************* */
#define FDCAN_IR_RF0N_Pos                   (0U)
#define FDCAN_IR_RF0N_Msk                   (0x1UL << FDCAN_IR_RF0N_Pos)            /*!< 0x00000001 */
#define FDCAN_IR_RF0N                       FDCAN_IR_RF0N_Msk                       /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0F_Pos                   (1U)
#define FDCAN_IR_RF0F_Msk                   (0x1UL << FDCAN_IR_RF0F_Pos)            /*!< 0x00000002 */
#define FDCAN_IR_RF0F                       FDCAN_IR_RF0F_Msk                       /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos                   (2U)
#define FDCAN_IR_RF0L_Msk                   (0x1UL << FDCAN_IR_RF0L_Pos)            /*!< 0x00000004 */
#define FDCAN_IR_RF0L                       FDCAN_IR_RF0L_Msk                       /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos                   (3U)
#define FDCAN_IR_RF1N_Msk                   (0x1UL << FDCAN_IR_RF1N_Pos)            /*!< 0x00000008 */
#define FDCAN_IR_RF1N                       FDCAN_IR_RF1N_Msk                       /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1F_Pos                   (4U)
#define FDCAN_IR_RF1F_Msk                   (0x1UL << FDCAN_IR_RF1F_Pos)            /*!< 0x00000010 */
#define FDCAN_IR_RF1F                       FDCAN_IR_RF1F_Msk                       /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos                   (5U)
#define FDCAN_IR_RF1L_Msk                   (0x1UL << FDCAN_IR_RF1L_Pos)            /*!< 0x00000020 */
#define FDCAN_IR_RF1L                       FDCAN_IR_RF1L_Msk                       /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos                    (6U)
#define FDCAN_IR_HPM_Msk                    (0x1UL << FDCAN_IR_HPM_Pos)             /*!< 0x00000040 */
#define FDCAN_IR_HPM                        FDCAN_IR_HPM_Msk                        /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos                     (7U)
#define FDCAN_IR_TC_Msk                     (0x1UL << FDCAN_IR_TC_Pos)              /*!< 0x00000080 */
#define FDCAN_IR_TC                         FDCAN_IR_TC_Msk                         /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos                    (8U)
#define FDCAN_IR_TCF_Msk                    (0x1UL << FDCAN_IR_TCF_Pos)             /*!< 0x00000100 */
#define FDCAN_IR_TCF                        FDCAN_IR_TCF_Msk                        /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos                    (9U)
#define FDCAN_IR_TFE_Msk                    (0x1UL << FDCAN_IR_TFE_Pos)             /*!< 0x00000200 */
#define FDCAN_IR_TFE                        FDCAN_IR_TFE_Msk                        /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos                   (10U)
#define FDCAN_IR_TEFN_Msk                   (0x1UL << FDCAN_IR_TEFN_Pos)            /*!< 0x00000400 */
#define FDCAN_IR_TEFN                       FDCAN_IR_TEFN_Msk                       /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFF_Pos                   (11U)
#define FDCAN_IR_TEFF_Msk                   (0x1UL << FDCAN_IR_TEFF_Pos)            /*!< 0x00000800 */
#define FDCAN_IR_TEFF                       FDCAN_IR_TEFF_Msk                       /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos                   (12U)
#define FDCAN_IR_TEFL_Msk                   (0x1UL << FDCAN_IR_TEFL_Pos)            /*!< 0x00001000 */
#define FDCAN_IR_TEFL                       FDCAN_IR_TEFL_Msk                       /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos                    (13U)
#define FDCAN_IR_TSW_Msk                    (0x1UL << FDCAN_IR_TSW_Pos)             /*!< 0x00002000 */
#define FDCAN_IR_TSW                        FDCAN_IR_TSW_Msk                        /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos                   (14U)
#define FDCAN_IR_MRAF_Msk                   (0x1UL << FDCAN_IR_MRAF_Pos)            /*!< 0x00004000 */
#define FDCAN_IR_MRAF                       FDCAN_IR_MRAF_Msk                       /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos                    (15U)
#define FDCAN_IR_TOO_Msk                    (0x1UL << FDCAN_IR_TOO_Pos)             /*!< 0x00008000 */
#define FDCAN_IR_TOO                        FDCAN_IR_TOO_Msk                        /*!<Timeout Occurred                         */
#define FDCAN_IR_ELO_Pos                    (16U)
#define FDCAN_IR_ELO_Msk                    (0x1UL << FDCAN_IR_ELO_Pos)             /*!< 0x00010000 */
#define FDCAN_IR_ELO                        FDCAN_IR_ELO_Msk                        /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos                     (17U)
#define FDCAN_IR_EP_Msk                     (0x1UL << FDCAN_IR_EP_Pos)              /*!< 0x00020000 */
#define FDCAN_IR_EP                         FDCAN_IR_EP_Msk                         /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos                     (18U)
#define FDCAN_IR_EW_Msk                     (0x1UL << FDCAN_IR_EW_Pos)              /*!< 0x00040000 */
#define FDCAN_IR_EW                         FDCAN_IR_EW_Msk                         /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos                     (19U)
#define FDCAN_IR_BO_Msk                     (0x1UL << FDCAN_IR_BO_Pos)              /*!< 0x00080000 */
#define FDCAN_IR_BO                         FDCAN_IR_BO_Msk                         /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos                    (20U)
#define FDCAN_IR_WDI_Msk                    (0x1UL << FDCAN_IR_WDI_Pos)             /*!< 0x00100000 */
#define FDCAN_IR_WDI                        FDCAN_IR_WDI_Msk                        /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos                    (21U)
#define FDCAN_IR_PEA_Msk                    (0x1UL << FDCAN_IR_PEA_Pos)             /*!< 0x00200000 */
#define FDCAN_IR_PEA                        FDCAN_IR_PEA_Msk                        /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos                    (22U)
#define FDCAN_IR_PED_Msk                    (0x1UL << FDCAN_IR_PED_Pos)             /*!< 0x00400000 */
#define FDCAN_IR_PED                        FDCAN_IR_PED_Msk                        /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos                    (23U)
#define FDCAN_IR_ARA_Msk                    (0x1UL << FDCAN_IR_ARA_Pos)             /*!< 0x00800000 */
#define FDCAN_IR_ARA                        FDCAN_IR_ARA_Msk                        /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  ********************* */
#define FDCAN_IE_RF0NE_Pos                  (0U)
#define FDCAN_IE_RF0NE_Msk                  (0x1UL << FDCAN_IE_RF0NE_Pos)           /*!< 0x00000001 */
#define FDCAN_IE_RF0NE                      FDCAN_IE_RF0NE_Msk                      /*!<Rx FIFO 0 New Message Enable             */
#define FDCAN_IE_RF0FE_Pos                  (1U)
#define FDCAN_IE_RF0FE_Msk                  (0x1UL << FDCAN_IE_RF0FE_Pos)           /*!< 0x00000002 */
#define FDCAN_IE_RF0FE                      FDCAN_IE_RF0FE_Msk                      /*!<Rx FIFO 0 Full Enable                    */
#define FDCAN_IE_RF0LE_Pos                  (2U)
#define FDCAN_IE_RF0LE_Msk                  (0x1UL << FDCAN_IE_RF0LE_Pos)           /*!< 0x00000004 */
#define FDCAN_IE_RF0LE                      FDCAN_IE_RF0LE_Msk                      /*!<Rx FIFO 0 Message Lost Enable            */
#define FDCAN_IE_RF1NE_Pos                  (3U)
#define FDCAN_IE_RF1NE_Msk                  (0x1UL << FDCAN_IE_RF1NE_Pos)           /*!< 0x00000008 */
#define FDCAN_IE_RF1NE                      FDCAN_IE_RF1NE_Msk                      /*!<Rx FIFO 1 New Message Enable             */
#define FDCAN_IE_RF1FE_Pos                  (4U)
#define FDCAN_IE_RF1FE_Msk                  (0x1UL << FDCAN_IE_RF1FE_Pos)           /*!< 0x00000010 */
#define FDCAN_IE_RF1FE                      FDCAN_IE_RF1FE_Msk                      /*!<Rx FIFO 1 Full Enable                    */
#define FDCAN_IE_RF1LE_Pos                  (5U)
#define FDCAN_IE_RF1LE_Msk                  (0x1UL << FDCAN_IE_RF1LE_Pos)           /*!< 0x00000020 */
#define FDCAN_IE_RF1LE                      FDCAN_IE_RF1LE_Msk                      /*!<Rx FIFO 1 Message Lost Enable            */
#define FDCAN_IE_HPME_Pos                   (6U)
#define FDCAN_IE_HPME_Msk                   (0x1UL << FDCAN_IE_HPME_Pos)            /*!< 0x00000040 */
#define FDCAN_IE_HPME                       FDCAN_IE_HPME_Msk                       /*!<High Priority Message Enable             */
#define FDCAN_IE_TCE_Pos                    (7U)
#define FDCAN_IE_TCE_Msk                    (0x1UL << FDCAN_IE_TCE_Pos)             /*!< 0x00000080 */
#define FDCAN_IE_TCE                        FDCAN_IE_TCE_Msk                        /*!<Transmission Completed Enable            */
#define FDCAN_IE_TCFE_Pos                   (8U)
#define FDCAN_IE_TCFE_Msk                   (0x1UL << FDCAN_IE_TCFE_Pos)            /*!< 0x00000100 */
#define FDCAN_IE_TCFE                       FDCAN_IE_TCFE_Msk                       /*!<Transmission Cancellation Finished Enable*/
#define FDCAN_IE_TFEE_Pos                   (9U)
#define FDCAN_IE_TFEE_Msk                   (0x1UL << FDCAN_IE_TFEE_Pos)            /*!< 0x00000200 */
#define FDCAN_IE_TFEE                       FDCAN_IE_TFEE_Msk                       /*!<Tx FIFO Empty Enable                     */
#define FDCAN_IE_TEFNE_Pos                  (10U)
#define FDCAN_IE_TEFNE_Msk                  (0x1UL << FDCAN_IE_TEFNE_Pos)           /*!< 0x00000400 */
#define FDCAN_IE_TEFNE                      FDCAN_IE_TEFNE_Msk                      /*!<Tx Event FIFO New Entry Enable           */
#define FDCAN_IE_TEFFE_Pos                  (11U)
#define FDCAN_IE_TEFFE_Msk                  (0x1UL << FDCAN_IE_TEFFE_Pos)           /*!< 0x00000800 */
#define FDCAN_IE_TEFFE                      FDCAN_IE_TEFFE_Msk                      /*!<Tx Event FIFO Full Enable                */
#define FDCAN_IE_TEFLE_Pos                  (12U)
#define FDCAN_IE_TEFLE_Msk                  (0x1UL << FDCAN_IE_TEFLE_Pos)           /*!< 0x00001000 */
#define FDCAN_IE_TEFLE                      FDCAN_IE_TEFLE_Msk                      /*!<Tx Event FIFO Element Lost Enable        */
#define FDCAN_IE_TSWE_Pos                   (13U)
#define FDCAN_IE_TSWE_Msk                   (0x1UL << FDCAN_IE_TSWE_Pos)            /*!< 0x00002000 */
#define FDCAN_IE_TSWE                       FDCAN_IE_TSWE_Msk                       /*!<Timestamp Wraparound Enable              */
#define FDCAN_IE_MRAFE_Pos                  (14U)
#define FDCAN_IE_MRAFE_Msk                  (0x1UL << FDCAN_IE_MRAFE_Pos)           /*!< 0x00004000 */
#define FDCAN_IE_MRAFE                      FDCAN_IE_MRAFE_Msk                      /*!<Message RAM Access Failure Enable        */
#define FDCAN_IE_TOOE_Pos                   (15U)
#define FDCAN_IE_TOOE_Msk                   (0x1UL << FDCAN_IE_TOOE_Pos)            /*!< 0x00008000 */
#define FDCAN_IE_TOOE                       FDCAN_IE_TOOE_Msk                       /*!<Timeout Occurred Enable                  */
#define FDCAN_IE_ELOE_Pos                   (16U)
#define FDCAN_IE_ELOE_Msk                   (0x1UL << FDCAN_IE_ELOE_Pos)            /*!< 0x00010000 */
#define FDCAN_IE_ELOE                       FDCAN_IE_ELOE_Msk                       /*!<Error Logging Overflow Enable            */
#define FDCAN_IE_EPE_Pos                    (17U)
#define FDCAN_IE_EPE_Msk                    (0x1UL << FDCAN_IE_EPE_Pos)             /*!< 0x00020000 */
#define FDCAN_IE_EPE                        FDCAN_IE_EPE_Msk                        /*!<Error Passive Enable                     */
#define FDCAN_IE_EWE_Pos                    (18U)
#define FDCAN_IE_EWE_Msk                    (0x1UL << FDCAN_IE_EWE_Pos)             /*!< 0x00040000 */
#define FDCAN_IE_EWE                        FDCAN_IE_EWE_Msk                        /*!<Warning Status Enable                    */
#define FDCAN_IE_BOE_Pos                    (19U)
#define FDCAN_IE_BOE_Msk                    (0x1UL << FDCAN_IE_BOE_Pos)             /*!< 0x00080000 */
#define FDCAN_IE_BOE                        FDCAN_IE_BOE_Msk                        /*!<Bus_Off Status Enable                    */
#define FDCAN_IE_WDIE_Pos                   (20U)
#define FDCAN_IE_WDIE_Msk                   (0x1UL << FDCAN_IE_WDIE_Pos)            /*!< 0x00100000 */
#define FDCAN_IE_WDIE                       FDCAN_IE_WDIE_Msk                       /*!<Watchdog Interrupt Enable                */
#define FDCAN_IE_PEAE_Pos                   (21U)
#define FDCAN_IE_PEAE_Msk                   (0x1UL << FDCAN_IE_PEAE_Pos)            /*!< 0x00200000 */
#define FDCAN_IE_PEAE                       FDCAN_IE_PEAE_Msk                       /*!<Protocol Error in Arbitration Phase Enable*/
#define FDCAN_IE_PEDE_Pos                   (22U)
#define FDCAN_IE_PEDE_Msk                   (0x1UL << FDCAN_IE_PEDE_Pos)            /*!< 0x00400000 */
#define FDCAN_IE_PEDE                       FDCAN_IE_PEDE_Msk                       /*!<Protocol Error in Data Phase Enable      */
#define FDCAN_IE_ARAE_Pos                   (23U)
#define FDCAN_IE_ARAE_Msk                   (0x1UL << FDCAN_IE_ARAE_Pos)            /*!< 0x00800000 */
#define FDCAN_IE_ARAE                       FDCAN_IE_ARAE_Msk                       /*!<Access to Reserved Address Enable        */

/*****************  Bit definition for FDCAN_ILS register  ******************** **/
#define FDCAN_ILS_RXFIFO0_Pos               (0U)
#define FDCAN_ILS_RXFIFO0_Msk               (0x1UL << FDCAN_ILS_RXFIFO0_Pos)        /*!< 0x00000001 */
#define FDCAN_ILS_RXFIFO0                   FDCAN_ILS_RXFIFO0_Msk                   /*!<Rx FIFO 0 Message Lost
                                                                                        Rx FIFO 0 is Full
                                                                                        Rx FIFO 0 Has New Message                */
#define FDCAN_ILS_RXFIFO1_Pos               (1U)
#define FDCAN_ILS_RXFIFO1_Msk               (0x1UL << FDCAN_ILS_RXFIFO1_Pos)        /*!< 0x00000002 */
#define FDCAN_ILS_RXFIFO1                   FDCAN_ILS_RXFIFO1_Msk                   /*!<Rx FIFO 1 Message Lost
                                                                                        Rx FIFO 1 is Full
                                                                                        Rx FIFO 1 Has New Message                */
#define FDCAN_ILS_SMSG_Pos                  (2U)
#define FDCAN_ILS_SMSG_Msk                  (0x1UL << FDCAN_ILS_SMSG_Pos)           /*!< 0x00000004 */
#define FDCAN_ILS_SMSG                      FDCAN_ILS_SMSG_Msk                      /*!<Transmission Cancellation Finished
                                                                                        Transmission Completed
                                                                                        High Priority Message                    */
#define FDCAN_ILS_TFERR_Pos                 (3U)
#define FDCAN_ILS_TFERR_Msk                 (0x1UL << FDCAN_ILS_TFERR_Pos)          /*!< 0x00000008 */
#define FDCAN_ILS_TFERR                     FDCAN_ILS_TFERR_Msk                     /*!<Tx Event FIFO Element Lost
                                                                                        Tx Event FIFO Full
                                                                                        Tx Event FIFO New Entry
                                                                                        Tx FIFO Empty Interrupt Line             */
#define FDCAN_ILS_MISC_Pos                  (4U)
#define FDCAN_ILS_MISC_Msk                  (0x1UL << FDCAN_ILS_MISC_Pos)           /*!< 0x00000010 */
#define FDCAN_ILS_MISC                      FDCAN_ILS_MISC_Msk                      /*!<Timeout Occurred
                                                                                        Message RAM Access Failure
                                                                                        Timestamp Wraparound                    */
#define FDCAN_ILS_BERR_Pos                  (5U)
#define FDCAN_ILS_BERR_Msk                  (0x1UL << FDCAN_ILS_BERR_Pos)           /*!< 0x00000020 */
#define FDCAN_ILS_BERR                      FDCAN_ILS_BERR_Msk                      /*!<Error Passive
                                                                                        Error Logging Overflow                   */
#define FDCAN_ILS_PERR_Pos                  (6U)
#define FDCAN_ILS_PERR_Msk                  (0x1UL << FDCAN_ILS_PERR_Pos)           /*!< 0x00000040 */
#define FDCAN_ILS_PERR                      FDCAN_ILS_PERR_Msk                      /*!<Access to Reserved Address Line
                                                                                        Protocol Error in Data Phase Line
                                                                                        Protocol Error in Arbitration Phase Line
                                                                                        Watchdog Interrupt Line
                                                                                        Bus_Off Status
                                                                                        Warning Status                           */

/*****************  Bit definition for FDCAN_ILE register  ******************** **/
#define FDCAN_ILE_EINT0_Pos                 (0U)
#define FDCAN_ILE_EINT0_Msk                 (0x1UL << FDCAN_ILE_EINT0_Pos)          /*!< 0x00000001 */
#define FDCAN_ILE_EINT0                     FDCAN_ILE_EINT0_Msk                     /*!<Enable Interrupt Line 0                  */
#define FDCAN_ILE_EINT1_Pos                 (1U)
#define FDCAN_ILE_EINT1_Msk                 (0x1UL << FDCAN_ILE_EINT1_Pos)          /*!< 0x00000002 */
#define FDCAN_ILE_EINT1                     FDCAN_ILE_EINT1_Msk                     /*!<Enable Interrupt Line 1                  */

/*****************  Bit definition for FDCAN_RXGFC register  ****************** **/
#define FDCAN_RXGFC_RRFE_Pos                (0U)
#define FDCAN_RXGFC_RRFE_Msk                (0x1UL << FDCAN_RXGFC_RRFE_Pos)         /*!< 0x00000001 */
#define FDCAN_RXGFC_RRFE                    FDCAN_RXGFC_RRFE_Msk                    /*!<Reject Remote Frames Extended            */
#define FDCAN_RXGFC_RRFS_Pos                (1U)
#define FDCAN_RXGFC_RRFS_Msk                (0x1UL << FDCAN_RXGFC_RRFS_Pos)         /*!< 0x00000002 */
#define FDCAN_RXGFC_RRFS                    FDCAN_RXGFC_RRFS_Msk                    /*!<Reject Remote Frames Standard            */
#define FDCAN_RXGFC_ANFE_Pos                (2U)
#define FDCAN_RXGFC_ANFE_Msk                (0x3UL << FDCAN_RXGFC_ANFE_Pos)         /*!< 0x0000000C */
#define FDCAN_RXGFC_ANFE                    FDCAN_RXGFC_ANFE_Msk                    /*!<Accept Non-matching Frames Extended      */
#define FDCAN_RXGFC_ANFS_Pos                (4U)
#define FDCAN_RXGFC_ANFS_Msk                (0x3UL << FDCAN_RXGFC_ANFS_Pos)         /*!< 0x00000030 */
#define FDCAN_RXGFC_ANFS                    FDCAN_RXGFC_ANFS_Msk                    /*!<Accept Non-matching Frames Standard      */
#define FDCAN_RXGFC_F1OM_Pos                (8U)
#define FDCAN_RXGFC_F1OM_Msk                (0x1UL << FDCAN_RXGFC_F1OM_Pos)         /*!< 0x00000100 */
#define FDCAN_RXGFC_F1OM                    FDCAN_RXGFC_F1OM_Msk                    /*!<FIFO 1 operation mode                    */
#define FDCAN_RXGFC_F0OM_Pos                (9U)
#define FDCAN_RXGFC_F0OM_Msk                (0x1UL << FDCAN_RXGFC_F0OM_Pos)         /*!< 0x00000200 */
#define FDCAN_RXGFC_F0OM                    FDCAN_RXGFC_F0OM_Msk                    /*!<FIFO 0 operation mode                    */
#define FDCAN_RXGFC_LSS_Pos                 (16U)
#define FDCAN_RXGFC_LSS_Msk                 (0x1FUL << FDCAN_RXGFC_LSS_Pos)         /*!< 0x001F0000 */
#define FDCAN_RXGFC_LSS                     FDCAN_RXGFC_LSS_Msk                     /*!<List Size Standard                       */
#define FDCAN_RXGFC_LSE_Pos                 (24U)
#define FDCAN_RXGFC_LSE_Msk                 (0xFUL << FDCAN_RXGFC_LSE_Pos)          /*!< 0x0F000000 */
#define FDCAN_RXGFC_LSE                     FDCAN_RXGFC_LSE_Msk                     /*!<List Size Extended                       */

/*****************  Bit definition for FDCAN_XIDAM register  ****************** **/
#define FDCAN_XIDAM_EIDM_Pos                (0U)
#define FDCAN_XIDAM_EIDM_Msk                (0x1FFFFFFFUL << FDCAN_XIDAM_EIDM_Pos)  /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM                    FDCAN_XIDAM_EIDM_Msk                    /*!<Extended ID Mask                         */

/*****************  Bit definition for FDCAN_HPMS register  ******************* **/
#define FDCAN_HPMS_BIDX_Pos                 (0U)
#define FDCAN_HPMS_BIDX_Msk                 (0x7UL << FDCAN_HPMS_BIDX_Pos)          /*!< 0x00000007 */
#define FDCAN_HPMS_BIDX                     FDCAN_HPMS_BIDX_Msk                     /*!<Buffer Index                             */
#define FDCAN_HPMS_MSI_Pos                  (6U)
#define FDCAN_HPMS_MSI_Msk                  (0x3UL << FDCAN_HPMS_MSI_Pos)           /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI                      FDCAN_HPMS_MSI_Msk                      /*!<Message Storage Indicator                */
#define FDCAN_HPMS_FIDX_Pos                 (8U)
#define FDCAN_HPMS_FIDX_Msk                 (0x1FUL << FDCAN_HPMS_FIDX_Pos)         /*!< 0x00001F00 */
#define FDCAN_HPMS_FIDX                     FDCAN_HPMS_FIDX_Msk                     /*!<Filter Index                             */
#define FDCAN_HPMS_FLST_Pos                 (15U)
#define FDCAN_HPMS_FLST_Msk                 (0x1UL << FDCAN_HPMS_FLST_Pos)          /*!< 0x00008000 */
#define FDCAN_HPMS_FLST                     FDCAN_HPMS_FLST_Msk                     /*!<Filter List                              */

/*****************  Bit definition for FDCAN_RXF0S register  ****************** **/
#define FDCAN_RXF0S_F0FL_Pos                (0U)
#define FDCAN_RXF0S_F0FL_Msk                (0xFUL << FDCAN_RXF0S_F0FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF0S_F0FL                    FDCAN_RXF0S_F0FL_Msk                    /*!<Rx FIFO 0 Fill Level                     */
#define FDCAN_RXF0S_F0GI_Pos                (8U)
#define FDCAN_RXF0S_F0GI_Msk                (0x3UL << FDCAN_RXF0S_F0GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF0S_F0GI                    FDCAN_RXF0S_F0GI_Msk                    /*!<Rx FIFO 0 Get Index                      */
#define FDCAN_RXF0S_F0PI_Pos                (16U)
#define FDCAN_RXF0S_F0PI_Msk                (0x3UL << FDCAN_RXF0S_F0PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF0S_F0PI                    FDCAN_RXF0S_F0PI_Msk                    /*!<Rx FIFO 0 Put Index                      */
#define FDCAN_RXF0S_F0F_Pos                 (24U)
#define FDCAN_RXF0S_F0F_Msk                 (0x1UL << FDCAN_RXF0S_F0F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F                     FDCAN_RXF0S_F0F_Msk                     /*!<Rx FIFO 0 Full                           */
#define FDCAN_RXF0S_RF0L_Pos                (25U)
#define FDCAN_RXF0S_RF0L_Msk                (0x1UL << FDCAN_RXF0S_RF0L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L                    FDCAN_RXF0S_RF0L_Msk                    /*!<Rx FIFO 0 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF0A register  ****************** **/
#define FDCAN_RXF0A_F0AI_Pos                (0U)
#define FDCAN_RXF0A_F0AI_Msk                (0x7UL << FDCAN_RXF0A_F0AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF0A_F0AI                    FDCAN_RXF0A_F0AI_Msk                    /*!<Rx FIFO 0 Acknowledge Index              */

/*****************  Bit definition for FDCAN_RXF1S register  ****************** **/
#define FDCAN_RXF1S_F1FL_Pos                (0U)
#define FDCAN_RXF1S_F1FL_Msk                (0xFUL << FDCAN_RXF1S_F1FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF1S_F1FL                    FDCAN_RXF1S_F1FL_Msk                    /*!<Rx FIFO 1 Fill Level                     */
#define FDCAN_RXF1S_F1GI_Pos                (8U)
#define FDCAN_RXF1S_F1GI_Msk                (0x3UL << FDCAN_RXF1S_F1GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF1S_F1GI                    FDCAN_RXF1S_F1GI_Msk                    /*!<Rx FIFO 1 Get Index                      */
#define FDCAN_RXF1S_F1PI_Pos                (16U)
#define FDCAN_RXF1S_F1PI_Msk                (0x3UL << FDCAN_RXF1S_F1PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF1S_F1PI                    FDCAN_RXF1S_F1PI_Msk                    /*!<Rx FIFO 1 Put Index                      */
#define FDCAN_RXF1S_F1F_Pos                 (24U)
#define FDCAN_RXF1S_F1F_Msk                 (0x1UL << FDCAN_RXF1S_F1F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F                     FDCAN_RXF1S_F1F_Msk                     /*!<Rx FIFO 1 Full                           */
#define FDCAN_RXF1S_RF1L_Pos                (25U)
#define FDCAN_RXF1S_RF1L_Msk                (0x1UL << FDCAN_RXF1S_RF1L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L                    FDCAN_RXF1S_RF1L_Msk                    /*!<Rx FIFO 1 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF1A register  ****************** **/
#define FDCAN_RXF1A_F1AI_Pos                (0U)
#define FDCAN_RXF1A_F1AI_Msk                (0x7UL << FDCAN_RXF1A_F1AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF1A_F1AI                    FDCAN_RXF1A_F1AI_Msk                    /*!<Rx FIFO 1 Acknowledge Index              */

/*****************  Bit definition for FDCAN_TXBC register  ******************* **/
#define FDCAN_TXBC_TFQM_Pos                 (24U)
#define FDCAN_TXBC_TFQM_Msk                 (0x1UL << FDCAN_TXBC_TFQM_Pos)          /*!< 0x01000000 */
#define FDCAN_TXBC_TFQM                     FDCAN_TXBC_TFQM_Msk                     /*!<Tx FIFO/Queue Mode                       */

/*****************  Bit definition for FDCAN_TXFQS register  ****************** ***/
#define FDCAN_TXFQS_TFFL_Pos                (0U)
#define FDCAN_TXFQS_TFFL_Msk                (0x7UL << FDCAN_TXFQS_TFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXFQS_TFFL                    FDCAN_TXFQS_TFFL_Msk                    /*!<Tx FIFO Free Level                       */
#define FDCAN_TXFQS_TFGI_Pos                (8U)
#define FDCAN_TXFQS_TFGI_Msk                (0x3UL << FDCAN_TXFQS_TFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXFQS_TFGI                    FDCAN_TXFQS_TFGI_Msk                    /*!<Tx FIFO Get Index                        */
#define FDCAN_TXFQS_TFQPI_Pos               (16U)
#define FDCAN_TXFQS_TFQPI_Msk               (0x3UL << FDCAN_TXFQS_TFQPI_Pos)        /*!< 0x00030000 */
#define FDCAN_TXFQS_TFQPI                   FDCAN_TXFQS_TFQPI_Msk                   /*!<Tx FIFO/Queue Put Index                  */
#define FDCAN_TXFQS_TFQF_Pos                (21U)
#define FDCAN_TXFQS_TFQF_Msk                (0x1UL << FDCAN_TXFQS_TFQF_Pos)         /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF                    FDCAN_TXFQS_TFQF_Msk                    /*!<Tx FIFO/Queue Full                       */

/*****************  Bit definition for FDCAN_TXBRP register  ****************** ***/
#define FDCAN_TXBRP_TRP_Pos                 (0U)
#define FDCAN_TXBRP_TRP_Msk                 (0x7UL << FDCAN_TXBRP_TRP_Pos)          /*!< 0x00000007 */
#define FDCAN_TXBRP_TRP                     FDCAN_TXBRP_TRP_Msk                     /*!<Transmission Request Pending             */

/*****************  Bit definition for FDCAN_TXBAR register  ****************** ***/
#define FDCAN_TXBAR_AR_Pos                  (0U)
#define FDCAN_TXBAR_AR_Msk                  (0x7UL << FDCAN_TXBAR_AR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBAR_AR                      FDCAN_TXBAR_AR_Msk                      /*!<Add Request                              */

/*****************  Bit definition for FDCAN_TXBCR register  ****************** ***/
#define FDCAN_TXBCR_CR_Pos                  (0U)
#define FDCAN_TXBCR_CR_Msk                  (0x7UL << FDCAN_TXBCR_CR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCR_CR                      FDCAN_TXBCR_CR_Msk                      /*!<Cancellation Request                     */

/*****************  Bit definition for FDCAN_TXBTO register  ****************** ***/
#define FDCAN_TXBTO_TO_Pos                  (0U)
#define FDCAN_TXBTO_TO_Msk                  (0x7UL << FDCAN_TXBTO_TO_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBTO_TO                      FDCAN_TXBTO_TO_Msk                      /*!<Transmission Occurred                    */

/*****************  Bit definition for FDCAN_TXBCF register  ****************** ***/
#define FDCAN_TXBCF_CF_Pos                  (0U)
#define FDCAN_TXBCF_CF_Msk                  (0x7UL << FDCAN_TXBCF_CF_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCF_CF                      FDCAN_TXBCF_CF_Msk                      /*!<Cancellation Finished                    */

/*****************  Bit definition for FDCAN_TXBTIE register  ***************** ***/
#define FDCAN_TXBTIE_TIE_Pos                (0U)
#define FDCAN_TXBTIE_TIE_Msk                (0x7UL << FDCAN_TXBTIE_TIE_Pos)         /*!< 0x00000007 */
#define FDCAN_TXBTIE_TIE                    FDCAN_TXBTIE_TIE_Msk                    /*!<Transmission Interrupt Enable            */

/*****************  Bit definition for FDCAN_ TXBCIE register  **************** ***/
#define FDCAN_TXBCIE_CFIE_Pos               (0U)
#define FDCAN_TXBCIE_CFIE_Msk               (0x7UL << FDCAN_TXBCIE_CFIE_Pos)        /*!< 0x00000007 */
#define FDCAN_TXBCIE_CFIE                   FDCAN_TXBCIE_CFIE_Msk                   /*!<Cancellation Finished Interrupt Enable   */

/*****************  Bit definition for FDCAN_TXEFS register  ****************** ***/
#define FDCAN_TXEFS_EFFL_Pos                (0U)
#define FDCAN_TXEFS_EFFL_Msk                (0x7UL << FDCAN_TXEFS_EFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXEFS_EFFL                    FDCAN_TXEFS_EFFL_Msk                    /*!<Event FIFO Fill Level                    */
#define FDCAN_TXEFS_EFGI_Pos                (8U)
#define FDCAN_TXEFS_EFGI_Msk                (0x3UL << FDCAN_TXEFS_EFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXEFS_EFGI                    FDCAN_TXEFS_EFGI_Msk                    /*!<Event FIFO Get Index                     */
#define FDCAN_TXEFS_EFPI_Pos                (16U)
#define FDCAN_TXEFS_EFPI_Msk                (0x3UL << FDCAN_TXEFS_EFPI_Pos)         /*!< 0x00030000 */
#define FDCAN_TXEFS_EFPI                    FDCAN_TXEFS_EFPI_Msk                    /*!<Event FIFO Put Index                     */
#define FDCAN_TXEFS_EFF_Pos                 (24U)
#define FDCAN_TXEFS_EFF_Msk                 (0x1UL << FDCAN_TXEFS_EFF_Pos)          /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF                     FDCAN_TXEFS_EFF_Msk                     /*!<Event FIFO Full                          */
#define FDCAN_TXEFS_TEFL_Pos                (25U)
#define FDCAN_TXEFS_TEFL_Msk                (0x1UL << FDCAN_TXEFS_TEFL_Pos)         /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL                    FDCAN_TXEFS_TEFL_Msk                    /*!<Tx Event FIFO Element Lost               */

/*****************  Bit definition for FDCAN_TXEFA register  ****************** ***/
#define FDCAN_TXEFA_EFAI_Pos                (0U)
#define FDCAN_TXEFA_EFAI_Msk                (0x3UL << FDCAN_TXEFA_EFAI_Pos)         /*!< 0x00000003 */
#define FDCAN_TXEFA_EFAI                    FDCAN_TXEFA_EFAI_Msk                    /*!<Event FIFO Acknowledge Index             */

/*!<FDCAN config registers */
/*****************  Bit definition for FDCAN_CKDIV register  ****************** ***/
#define FDCAN_CKDIV_PDIV_Pos                (0U)
#define FDCAN_CKDIV_PDIV_Msk                (0xFUL << FDCAN_CKDIV_PDIV_Pos)         /*!< 0x0000000F */
#define FDCAN_CKDIV_PDIV                    FDCAN_CKDIV_PDIV_Msk                    /*!<Input Clock Divider                      */

/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bits definition for FLASH_ACR register  *****************/
#define FLASH_ACR_LATENCY_Pos               (0U)
#define FLASH_ACR_LATENCY_Msk               (0xFUL << FLASH_ACR_LATENCY_Pos)        /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                   FLASH_ACR_LATENCY_Msk                   /*!< Latency    */
#define FLASH_ACR_LATENCY_0                 (0x1UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000001 */
#define FLASH_ACR_LATENCY_1                 (0x2UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000002 */
#define FLASH_ACR_LATENCY_2                 (0x4UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000004 */
#define FLASH_ACR_LATENCY_3                 (0x8UL << FLASH_ACR_LATENCY_Pos)        /*!< 0x00000008 */
#define FLASH_ACR_PRFTEN_Pos                (8U)
#define FLASH_ACR_PRFTEN_Msk                (0x1UL << FLASH_ACR_PRFTEN_Pos)         /*!< 0x00000100 */
#define FLASH_ACR_PRFTEN                    FLASH_ACR_PRFTEN_Msk                    /*!< Prefetch enable */
#define FLASH_ACR_LPM_Pos                   (11U)
#define FLASH_ACR_LPM_Msk                   (0x1UL << FLASH_ACR_LPM_Pos)            /*!< 0x00000800 */
#define FLASH_ACR_LPM                       FLASH_ACR_LPM_Msk                       /*!< Low-Power read mode */
#define FLASH_ACR_PDREQ1_Pos                (12U)
#define FLASH_ACR_PDREQ1_Msk                (0x1UL << FLASH_ACR_PDREQ1_Pos)         /*!< 0x00001000 */
#define FLASH_ACR_PDREQ1                    FLASH_ACR_PDREQ1_Msk                    /*!< Bank 1 power-down mode request */
#define FLASH_ACR_PDREQ2_Pos                (13U)
#define FLASH_ACR_PDREQ2_Msk                (0x1UL << FLASH_ACR_PDREQ2_Pos)         /*!< 0x00002000 */
#define FLASH_ACR_PDREQ2                    FLASH_ACR_PDREQ2_Msk                    /*!< Bank 2 power-down mode request */
#define FLASH_ACR_SLEEP_PD_Pos              (14U)
#define FLASH_ACR_SLEEP_PD_Msk              (0x1UL << FLASH_ACR_SLEEP_PD_Pos)       /*!< 0x00004000 */
#define FLASH_ACR_SLEEP_PD                  FLASH_ACR_SLEEP_PD_Msk                  /*!< Flash power-down mode during sleep */

/******************  Bits definition for FLASH_KEYR register  *****************/
#define FLASH_KEYR_KEY_Pos                  (0U)
#define FLASH_KEYR_KEY_Msk                  (0xFFFFFFFFUL << FLASH_KEYR_KEY_Pos)    /*!< 0xFFFFFFFFF */
#define FLASH_KEYR_KEY                      FLASH_KEYR_KEY_Msk                      /*!< Flash non-secure key */

/*****************  Bits definition for FLASH_SKEYR register  *****************/
#define FLASH_SKEYR_KEY_Pos                 (0U)
#define FLASH_SKEYR_KEY_Msk                 (0xFFFFFFFFUL << FLASH_SKEYR_KEY_Pos)   /*!< 0xFFFFFFFFF */
#define FLASH_SKEYR_KEY                     FLASH_SKEYR_KEY_Msk                     /*!< Flash secure key */

/****************  Bits definition for FLASH_OPTKEYR register  ****************/
#define FLASH_OPTKEYR_KEY_Pos               (0U)
#define FLASH_OPTKEYR_KEY_Msk               (0xFFFFFFFFUL << FLASH_OPTKEYR_KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OPTKEYR_KEY                   FLASH_OPTKEYR_KEY_Msk                   /*!< Option byte key */

/****************  Bits definition for FLASH_PDKEY1R register  ****************/
#define FLASH_PDKEY1R_KEY1_Pos              (0U)
#define FLASH_PDKEY1R_KEY1_Msk              (0xFFFFFFFFUL << FLASH_PDKEY1R_KEY1_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_PDKEY1R_KEY1                  FLASH_PDKEY1R_KEY1_Msk                   /*!< Bank 1 power-down key */

/****************  Bits definition for FLASH_PDKEY2R register  ****************/
#define FLASH_PDKEY2R_KEY2_Pos              (0U)
#define FLASH_PDKEY2R_KEY2_Msk              (0xFFFFFFFFUL << FLASH_PDKEY2R_KEY2_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_PDKEY2R_KEY2                  FLASH_PDKEY2R_KEY2_Msk                   /*!< Bank 2 power-down key */

/*******************  Bits definition for FLASH_SR register  ******************/
#define FLASH_SR_EOP_Pos                    (0U)
#define FLASH_SR_EOP_Msk                    (0x1UL << FLASH_SR_EOP_Pos)             /*!< 0x00000001 */
#define FLASH_SR_EOP                        FLASH_SR_EOP_Msk                        /*!< Non-secure end of operation */
#define FLASH_SR_OPERR_Pos                  (1U)
#define FLASH_SR_OPERR_Msk                  (0x1UL << FLASH_SR_OPERR_Pos)           /*!< 0x00000002 */
#define FLASH_SR_OPERR                      FLASH_SR_OPERR_Msk                      /*!< Non-secure operation error */
#define FLASH_SR_PROGERR_Pos                (3U)
#define FLASH_SR_PROGERR_Msk                (0x1UL << FLASH_SR_PROGERR_Pos)         /*!< 0x00000008 */
#define FLASH_SR_PROGERR                    FLASH_SR_PROGERR_Msk                    /*!< Non-secure programming error */
#define FLASH_SR_WRPERR_Pos                 (4U)
#define FLASH_SR_WRPERR_Msk                 (0x1UL << FLASH_SR_WRPERR_Pos)          /*!< 0x00000010 */
#define FLASH_SR_WRPERR                     FLASH_SR_WRPERR_Msk                     /*!< Non-secure write protection error */
#define FLASH_SR_PGAERR_Pos                 (5U)
#define FLASH_SR_PGAERR_Msk                 (0x1UL << FLASH_SR_PGAERR_Pos)          /*!< 0x00000020 */
#define FLASH_SR_PGAERR                     FLASH_SR_PGAERR_Msk                     /*!< Non-secure programming alignment error */
#define FLASH_SR_SIZERR_Pos                 (6U)
#define FLASH_SR_SIZERR_Msk                 (0x1UL << FLASH_SR_SIZERR_Pos)          /*!< 0x00000040 */
#define FLASH_SR_SIZERR                     FLASH_SR_SIZERR_Msk                     /*!< Non-secure size error */
#define FLASH_SR_PGSERR_Pos                 (7U)
#define FLASH_SR_PGSERR_Msk                 (0x1UL << FLASH_SR_PGSERR_Pos)          /*!< 0x00000080 */
#define FLASH_SR_PGSERR                     FLASH_SR_PGSERR_Msk                     /*!< Non-secure programming sequence error */
#define FLASH_SR_OPTWERR_Pos                (13U)
#define FLASH_SR_OPTWERR_Msk                (0x1UL << FLASH_SR_OPTWERR_Pos)         /*!< 0x00002000 */
#define FLASH_SR_OPTWERR                    FLASH_SR_OPTWERR_Msk                    /*!< Option write error */
#define FLASH_SR_BSY_Pos                    (16U)
#define FLASH_SR_BSY_Msk                    (0x1UL << FLASH_SR_BSY_Pos)             /*!< 0x00010000 */
#define FLASH_SR_BSY                        FLASH_SR_BSY_Msk                        /*!< Non-secure busy */
#define FLASH_SR_WDW_Pos                    (17U)
#define FLASH_SR_WDW_Msk                    (0x1UL << FLASH_SR_WDW_Pos)             /*!< 0x00020000 */
#define FLASH_SR_WDW                        FLASH_SR_WDW_Msk                        /*!< Non-secure wait data to write */
#define FLASH_SR_OEM1LOCK_Pos               (18U)
#define FLASH_SR_OEM1LOCK_Msk               (0x1UL << FLASH_SR_OEM1LOCK_Pos)        /*!< 0x00040000 */
#define FLASH_SR_OEM1LOCK                   FLASH_SR_OEM1LOCK_Msk                   /*!< OEM1 lock */
#define FLASH_SR_OEM2LOCK_Pos               (19U)
#define FLASH_SR_OEM2LOCK_Msk               (0x1UL << FLASH_SR_OEM2LOCK_Pos)        /*!< 0x00080000 */
#define FLASH_SR_OEM2LOCK                   FLASH_SR_OEM2LOCK_Msk                   /*!< OEM2 lock */
#define FLASH_SR_PD1_Pos                    (20U)
#define FLASH_SR_PD1_Msk                    (0x1UL << FLASH_SR_PD1_Pos)             /*!< 0x00100000 */
#define FLASH_SR_PD1                        FLASH_SR_PD1_Msk                        /*!< Bank 1 in power-down mode */
#define FLASH_SR_PD2_Pos                    (21U)
#define FLASH_SR_PD2_Msk                    (0x1UL << FLASH_SR_PD2_Pos)             /*!< 0x00200000 */
#define FLASH_SR_PD2                        FLASH_SR_PD2_Msk                        /*!< Bank 2 in power-down mode */

/*******************  Bits definition for FLASH_SSR register  *****************/
#define FLASH_SSR_EOP_Pos                   (0U)
#define FLASH_SSR_EOP_Msk                   (0x1UL << FLASH_SSR_EOP_Pos)            /*!< 0x00000001 */
#define FLASH_SSR_EOP                       FLASH_SSR_EOP_Msk                       /*!< Secure end of operation */
#define FLASH_SSR_OPERR_Pos                 (1U)
#define FLASH_SSR_OPERR_Msk                 (0x1UL << FLASH_SSR_OPERR_Pos)          /*!< 0x00000002 */
#define FLASH_SSR_OPERR                     FLASH_SSR_OPERR_Msk                     /*!< Secure operation error */
#define FLASH_SSR_PROGERR_Pos               (3U)
#define FLASH_SSR_PROGERR_Msk               (0x1UL << FLASH_SSR_PROGERR_Pos)        /*!< 0x00000008 */
#define FLASH_SSR_PROGERR                   FLASH_SSR_PROGERR_Msk                   /*!< Secure programming error */
#define FLASH_SSR_WRPERR_Pos                (4U)
#define FLASH_SSR_WRPERR_Msk                (0x1UL << FLASH_SSR_WRPERR_Pos)         /*!< 0x00000010 */
#define FLASH_SSR_WRPERR                    FLASH_SSR_WRPERR_Msk                    /*!< Secure write protection error */
#define FLASH_SSR_PGAERR_Pos                (5U)
#define FLASH_SSR_PGAERR_Msk                (0x1UL << FLASH_SSR_PGAERR_Pos)         /*!< 0x00000020 */
#define FLASH_SSR_PGAERR                    FLASH_SSR_PGAERR_Msk                    /*!< Secure programming alignment error */
#define FLASH_SSR_SIZERR_Pos                (6U)
#define FLASH_SSR_SIZERR_Msk                (0x1UL << FLASH_SSR_SIZERR_Pos)         /*!< 0x00000040 */
#define FLASH_SSR_SIZERR                    FLASH_SSR_SIZERR_Msk                    /*!< Secure size error */
#define FLASH_SSR_PGSERR_Pos                (7U)
#define FLASH_SSR_PGSERR_Msk                (0x1UL << FLASH_SSR_PGSERR_Pos)         /*!< 0x00000080 */
#define FLASH_SSR_PGSERR                    FLASH_SSR_PGSERR_Msk                    /*!< Secure programming sequence error */
#define FLASH_SSR_BSY_Pos                   (16U)
#define FLASH_SSR_BSY_Msk                   (0x1UL << FLASH_SSR_BSY_Pos)            /*!< 0x00010000 */
#define FLASH_SSR_BSY                       FLASH_SSR_BSY_Msk                       /*!< Secure busy */
#define FLASH_SSR_WDW_Pos                   (17U)
#define FLASH_SSR_WDW_Msk                   (0x1UL << FLASH_SSR_WDW_Pos)            /*!< 0x00020000 */
#define FLASH_SSR_WDW                       FLASH_SSR_WDW_Msk                       /*!< Secure wait data to write */

/*******************  Bits definition for FLASH_CR register  ******************/
#define FLASH_CR_PG_Pos                     (0U)
#define FLASH_CR_PG_Msk                     (0x1UL << FLASH_CR_PG_Pos)              /*!< 0x00000001 */
#define FLASH_CR_PG                         FLASH_CR_PG_Msk                         /*!< Non-secure programming */
#define FLASH_CR_PER_Pos                    (1U)
#define FLASH_CR_PER_Msk                    (0x1UL << FLASH_CR_PER_Pos)             /*!< 0x00000002 */
#define FLASH_CR_PER                        FLASH_CR_PER_Msk                        /*!< Non-secure page erase */
#define FLASH_CR_MER1_Pos                   (2U)
#define FLASH_CR_MER1_Msk                   (0x1UL << FLASH_CR_MER1_Pos)            /*!< 0x00000004 */
#define FLASH_CR_MER1                       FLASH_CR_MER1_Msk                       /*!< Non-secure bank 1 mass erase */
#define FLASH_CR_PNB_Pos                    (3U)
#define FLASH_CR_PNB_Msk                    (0xFFUL << FLASH_CR_PNB_Pos)            /*!< 0x000007F8 */
#define FLASH_CR_PNB                        FLASH_CR_PNB_Msk                        /*!< Non-secure page number selection */
#define FLASH_CR_BKER_Pos                   (11U)
#define FLASH_CR_BKER_Msk                   (0x1UL << FLASH_CR_BKER_Pos)            /*!< 0x00000800 */
#define FLASH_CR_BKER                       FLASH_CR_BKER_Msk                       /*!< Non-secure bank selection for page erase */
#define FLASH_CR_BWR_Pos                    (14U)
#define FLASH_CR_BWR_Msk                    (0x1UL << FLASH_CR_BWR_Pos)             /*!< 0x00004000 */
#define FLASH_CR_BWR                        FLASH_CR_BWR_Msk                        /*!< Non-secure burst write programming mode */
#define FLASH_CR_MER2_Pos                   (15U)
#define FLASH_CR_MER2_Msk                   (0x1UL << FLASH_CR_MER2_Pos)            /*!< 0x00008000 */
#define FLASH_CR_MER2                       FLASH_CR_MER2_Msk                       /*!< Non-secure bank 2 mass erase */
#define FLASH_CR_STRT_Pos                   (16U)
#define FLASH_CR_STRT_Msk                   (0x1UL << FLASH_CR_STRT_Pos)            /*!< 0x00010000 */
#define FLASH_CR_STRT                       FLASH_CR_STRT_Msk                       /*!< Non-secure start */
#define FLASH_CR_OPTSTRT_Pos                (17U)
#define FLASH_CR_OPTSTRT_Msk                (0x1UL << FLASH_CR_OPTSTRT_Pos)         /*!< 0x00020000 */
#define FLASH_CR_OPTSTRT                    FLASH_CR_OPTSTRT_Msk                    /*!< Option modification Start */
#define FLASH_CR_EOPIE_Pos                  (24U)
#define FLASH_CR_EOPIE_Msk                  (0x1UL << FLASH_CR_EOPIE_Pos)           /*!< 0x01000000 */
#define FLASH_CR_EOPIE                      FLASH_CR_EOPIE_Msk                      /*!< Non-secure end of operation interrupt enable */
#define FLASH_CR_ERRIE_Pos                  (25U)
#define FLASH_CR_ERRIE_Msk                  (0x1UL << FLASH_CR_ERRIE_Pos)           /*!< 0x02000000 */
#define FLASH_CR_ERRIE                      FLASH_CR_ERRIE_Msk                      /*!< Non-secure error interrupt enable */
#define FLASH_CR_OBL_LAUNCH_Pos             (27U)
#define FLASH_CR_OBL_LAUNCH_Msk             (0x1UL << FLASH_CR_OBL_LAUNCH_Pos)      /*!< 0x08000000 */
#define FLASH_CR_OBL_LAUNCH                 FLASH_CR_OBL_LAUNCH_Msk                 /*!< Force the option byte loading */
#define FLASH_CR_OPTLOCK_Pos                (30U)
#define FLASH_CR_OPTLOCK_Msk                (0x1UL << FLASH_CR_OPTLOCK_Pos)         /*!< 0x40000000 */
#define FLASH_CR_OPTLOCK                    FLASH_CR_OPTLOCK_Msk                    /*!< Option Lock */
#define FLASH_CR_LOCK_Pos                   (31U)
#define FLASH_CR_LOCK_Msk                   (0x1UL << FLASH_CR_LOCK_Pos)            /*!< 0x80000000 */
#define FLASH_CR_LOCK                       FLASH_CR_LOCK_Msk                       /*!< Non-secure Lock */

/*******************  Bits definition for FLASH_SCR register  *****************/
#define FLASH_SCR_PG_Pos                    (0U)
#define FLASH_SCR_PG_Msk                    (0x1UL << FLASH_SCR_PG_Pos)             /*!< 0x00000001 */
#define FLASH_SCR_PG                        FLASH_SCR_PG_Msk                        /*!< Secure programming */
#define FLASH_SCR_PER_Pos                   (1U)
#define FLASH_SCR_PER_Msk                   (0x1UL << FLASH_SCR_PER_Pos)            /*!< 0x00000002 */
#define FLASH_SCR_PER                       FLASH_SCR_PER_Msk                       /*!< Secure page erase */
#define FLASH_SCR_MER1_Pos                  (2U)
#define FLASH_SCR_MER1_Msk                  (0x1UL << FLASH_SCR_MER1_Pos)           /*!< 0x00000004 */
#define FLASH_SCR_MER1                      FLASH_SCR_MER1_Msk                      /*!< Secure bank 1 mass erase */
#define FLASH_SCR_PNB_Pos                   (3U)
#define FLASH_SCR_PNB_Msk                   (0x7FUL << FLASH_SCR_PNB_Pos)           /*!< 0x000003F8 */
#define FLASH_SCR_PNB                       FLASH_SCR_PNB_Msk                       /*!< Secure page number selection */
#define FLASH_SCR_BKER_Pos                  (11U)
#define FLASH_SCR_BKER_Msk                  (0x1UL << FLASH_SCR_BKER_Pos)           /*!< 0x00000800 */
#define FLASH_SCR_BKER                      FLASH_SCR_BKER_Msk                      /*!< Secure bank selection for page erase */
#define FLASH_SCR_BWR_Pos                   (14U)
#define FLASH_SCR_BWR_Msk                   (0x1UL << FLASH_SCR_BWR_Pos)            /*!< 0x00004000 */
#define FLASH_SCR_BWR                       FLASH_SCR_BWR_Msk                       /*!< Secure burst write programming mode */
#define FLASH_SCR_MER2_Pos                  (15U)
#define FLASH_SCR_MER2_Msk                  (0x1UL << FLASH_SCR_MER2_Pos)           /*!< 0x00008000 */
#define FLASH_SCR_MER2                      FLASH_SCR_MER2_Msk                      /*!< Secure bank 2 mass erase */
#define FLASH_SCR_STRT_Pos                  (16U)
#define FLASH_SCR_STRT_Msk                  (0x1UL << FLASH_SCR_STRT_Pos)           /*!< 0x00010000 */
#define FLASH_SCR_STRT                      FLASH_SCR_STRT_Msk                      /*!< Secure start */
#define FLASH_SCR_EOPIE_Pos                 (24U)
#define FLASH_SCR_EOPIE_Msk                 (0x1UL << FLASH_SCR_EOPIE_Pos)          /*!< 0x01000000 */
#define FLASH_SCR_EOPIE                     FLASH_SCR_EOPIE_Msk                     /*!< Secure end of operation interrupt enable */
#define FLASH_SCR_ERRIE_Pos                 (25U)
#define FLASH_SCR_ERRIE_Msk                 (0x1UL << FLASH_SCR_ERRIE_Pos)          /*!< 0x02000000 */
#define FLASH_SCR_ERRIE                     FLASH_SCR_ERRIE_Msk                     /*!< Secure error interrupt enable */
#define FLASH_SCR_INV_Pos                   (29U)
#define FLASH_SCR_INV_Msk                   (0x1UL << FLASH_SCR_INV_Pos)            /*!< 0x20000000 */
#define FLASH_SCR_INV                       FLASH_SCR_INV_Msk                       /*!< Flash security state invert */
#define FLASH_SCR_LOCK_Pos                  (31U)
#define FLASH_SCR_LOCK_Msk                  (0x1UL << FLASH_SCR_LOCK_Pos)           /*!< 0x80000000 */
#define FLASH_SCR_LOCK                      FLASH_SCR_LOCK_Msk                      /*!< Secure lock */

/*******************  Bits definition for FLASH_ECCCR register  **************/
#define FLASH_ECCCR_ADDR_ECC_Pos            (0U)
#define FLASH_ECCCR_ADDR_ECC_Msk            (0xFFFFFUL << FLASH_ECCCR_ADDR_ECC_Pos) /*!< 0x000FFFFF */
#define FLASH_ECCCR_ADDR_ECC                FLASH_ECCCR_ADDR_ECC_Msk                /*!< ECC fail address */
#define FLASH_ECCCR_BK_ECC_Pos              (21U)
#define FLASH_ECCCR_BK_ECC_Msk              (0x1UL << FLASH_ECCCR_BK_ECC_Pos)       /*!< 0x00200000 */
#define FLASH_ECCCR_BK_ECC                  FLASH_ECCCR_BK_ECC_Msk                  /*!< ECC fail bank */
#define FLASH_ECCCR_SYSF_ECC_Pos            (22U)
#define FLASH_ECCCR_SYSF_ECC_Msk            (0x1UL << FLASH_ECCCR_SYSF_ECC_Pos)     /*!< 0x00400000 */
#define FLASH_ECCCR_SYSF_ECC                FLASH_ECCCR_SYSF_ECC_Msk                /*!< System Flash ECC fail */
#define FLASH_ECCCR_ECCIE_Pos               (24U)
#define FLASH_ECCCR_ECCIE_Msk               (0x1UL << FLASH_ECCCR_ECCIE_Pos)        /*!< 0x01000000 */
#define FLASH_ECCCR_ECCIE                   FLASH_ECCCR_ECCIE_Msk                   /*!< ECC correction interrupt enable */
#define FLASH_ECCCR_ECCC_Pos                (30U)
#define FLASH_ECCCR_ECCC_Msk                (0x1UL << FLASH_ECCCR_ECCC_Pos)         /*!< 0x40000000 */
#define FLASH_ECCCR_ECCC                    FLASH_ECCCR_ECCC_Msk                    /*!< ECC correction */

/*******************  Bits definition for FLASH_ECCDR register  **************/
#define FLASH_ECCDR_ADDR_ECC_Pos            (0U)
#define FLASH_ECCDR_ADDR_ECC_Msk            (0xFFFFFUL << FLASH_ECCDR_ADDR_ECC_Pos) /*!< 0x000FFFFF */
#define FLASH_ECCDR_ADDR_ECC                FLASH_ECCDR_ADDR_ECC_Msk                /*!< ECC fail address */
#define FLASH_ECCDR_BK_ECC_Pos              (21U)
#define FLASH_ECCDR_BK_ECC_Msk              (0x1UL << FLASH_ECCDR_BK_ECC_Pos)       /*!< 0x00200000 */
#define FLASH_ECCDR_BK_ECC                  FLASH_ECCDR_BK_ECC_Msk                  /*!< ECC fail bank */
#define FLASH_ECCDR_SYSF_ECC_Pos            (22U)
#define FLASH_ECCDR_SYSF_ECC_Msk            (0x1UL << FLASH_ECCDR_SYSF_ECC_Pos)     /*!< 0x00400000 */
#define FLASH_ECCDR_SYSF_ECC                FLASH_ECCDR_SYSF_ECC_Msk                /*!< System Flash ECC fail */
#define FLASH_ECCDR_ECCD_Pos                (31U)
#define FLASH_ECCDR_ECCD_Msk                (0x1UL << FLASH_ECCDR_ECCD_Pos)         /*!< 0x80000000 */
#define FLASH_ECCDR_ECCD                    FLASH_ECCDR_ECCD_Msk                    /*!< ECC detection */

/*******************  Bits definition for FLASH_OPSR register  ***************/
#define FLASH_OPSR_ADDR_OP_Pos              (0U)
#define FLASH_OPSR_ADDR_OP_Msk              (0xFFFFFUL << FLASH_OPSR_ADDR_OP_Pos)   /*!< 0x000FFFFF */
#define FLASH_OPSR_ADDR_OP                  FLASH_OPSR_ADDR_OP_Msk                  /*!< Interrupted operation address */
#define FLASH_OPSR_BK_OP_Pos                (21U)
#define FLASH_OPSR_BK_OP_Msk                (0x1UL << FLASH_OPSR_BK_OP_Pos)         /*!< 0x00200000 */
#define FLASH_OPSR_BK_OP                    FLASH_OPSR_BK_OP_Msk                    /*!< Interrupted operation bank */
#define FLASH_OPSR_SYSF_OP_Pos              (22U)
#define FLASH_OPSR_SYSF_OP_Msk              (0x1UL << FLASH_OPSR_SYSF_OP_Pos)       /*!< 0x00400000 */
#define FLASH_OPSR_SYSF_OP                  FLASH_OPSR_SYSF_OP_Msk                  /*!< Operation in System Flash interrupted */
#define FLASH_OPSR_CODE_OP_Pos              (29U)
#define FLASH_OPSR_CODE_OP_Msk              (0x7UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0xE0000000 */
#define FLASH_OPSR_CODE_OP                  FLASH_OPSR_CODE_OP_Msk                  /*!< Flash operation code */
#define FLASH_OPSR_CODE_OP_0                (0x1UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x20000000 */
#define FLASH_OPSR_CODE_OP_1                (0x2UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x40000000 */
#define FLASH_OPSR_CODE_OP_2                (0x4UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x80000000 */

/*******************  Bits definition for FLASH_OPTR register  ***************/
#define FLASH_OPTR_RDP_Pos                  (0U)
#define FLASH_OPTR_RDP_Msk                  (0xFFUL << FLASH_OPTR_RDP_Pos)          /*!< 0x000000FF */
#define FLASH_OPTR_RDP                      FLASH_OPTR_RDP_Msk                      /*!< Readout protection level */
#define FLASH_OPTR_BOR_LEV_Pos              (8U)
#define FLASH_OPTR_BOR_LEV_Msk              (0x7UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000700 */
#define FLASH_OPTR_BOR_LEV                  FLASH_OPTR_BOR_LEV_Msk                  /*!< BOR reset level */
#define FLASH_OPTR_BOR_LEV_0                (0x1UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000100 */
#define FLASH_OPTR_BOR_LEV_1                (0x2UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000200 */
#define FLASH_OPTR_BOR_LEV_2                (0x4UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000400 */
#define FLASH_OPTR_BDRST_POR_Pos            (11U)
#define FLASH_OPTR_BDRST_POR_Msk            (0x1UL << FLASH_OPTR_BDRST_POR_Pos)     /*!< 0x00000800 */
#define FLASH_OPTR_BDRST_POR                FLASH_OPTR_BDRST_POR_Msk                /*!< Backup domain reset with power on reset */
#define FLASH_OPTR_nRST_STOP_Pos            (12U)
#define FLASH_OPTR_nRST_STOP_Msk            (0x1UL << FLASH_OPTR_nRST_STOP_Pos)     /*!< 0x00001000 */
#define FLASH_OPTR_nRST_STOP                FLASH_OPTR_nRST_STOP_Msk                /*!< Reset generation in stop mode */
#define FLASH_OPTR_nRST_STDBY_Pos           (13U)
#define FLASH_OPTR_nRST_STDBY_Msk           (0x1UL << FLASH_OPTR_nRST_STDBY_Pos)    /*!< 0x00002000 */
#define FLASH_OPTR_nRST_STDBY               FLASH_OPTR_nRST_STDBY_Msk               /*!< Reset generation in standby mode */
#define FLASH_OPTR_nRST_SHDW_Pos            (14U)
#define FLASH_OPTR_nRST_SHDW_Msk            (0x1UL << FLASH_OPTR_nRST_SHDW_Pos)     /*!< 0x00004000 */
#define FLASH_OPTR_nRST_SHDW                FLASH_OPTR_nRST_SHDW_Msk                /*!< Reset generation in shutdown mode */
#define FLASH_OPTR_SRAM1_RST_Pos            (15U)
#define FLASH_OPTR_SRAM1_RST_Msk            (0x1UL << FLASH_OPTR_SRAM1_RST_Pos)     /*!< 0x00008000 */
#define FLASH_OPTR_SRAM1_RST                FLASH_OPTR_SRAM1_RST_Msk                /*!< SRAM1 erase upon system reset */
#define FLASH_OPTR_IWDG_SW_Pos              (16U)
#define FLASH_OPTR_IWDG_SW_Msk              (0x1UL << FLASH_OPTR_IWDG_SW_Pos)       /*!< 0x00010000 */
#define FLASH_OPTR_IWDG_SW                  FLASH_OPTR_IWDG_SW_Msk                  /*!< Independent watchdog selection */
#define FLASH_OPTR_IWDG_STOP_Pos            (17U)
#define FLASH_OPTR_IWDG_STOP_Msk            (0x1UL << FLASH_OPTR_IWDG_STOP_Pos)     /*!< 0x00020000 */
#define FLASH_OPTR_IWDG_STOP                FLASH_OPTR_IWDG_STOP_Msk                /*!< Independent watchdog counter freeze in stop mode */
#define FLASH_OPTR_IWDG_STDBY_Pos           (18U)
#define FLASH_OPTR_IWDG_STDBY_Msk           (0x1UL << FLASH_OPTR_IWDG_STDBY_Pos)    /*!< 0x00040000 */
#define FLASH_OPTR_IWDG_STDBY               FLASH_OPTR_IWDG_STDBY_Msk               /*!< Independent watchdog counter freeze in standby mode */
#define FLASH_OPTR_WWDG_SW_Pos              (19U)
#define FLASH_OPTR_WWDG_SW_Msk              (0x1UL << FLASH_OPTR_WWDG_SW_Pos)       /*!< 0x00080000 */
#define FLASH_OPTR_WWDG_SW                  FLASH_OPTR_WWDG_SW_Msk                  /*!< Window watchdog selection */
#define FLASH_OPTR_SWAP_BANK_Pos            (20U)
#define FLASH_OPTR_SWAP_BANK_Msk            (0x1UL << FLASH_OPTR_SWAP_BANK_Pos)     /*!< 0x00100000 */
#define FLASH_OPTR_SWAP_BANK                FLASH_OPTR_SWAP_BANK_Msk                /*!< Swap banks */
#define FLASH_OPTR_DUALBANK_Pos             (21U)
#define FLASH_OPTR_DUALBANK_Msk             (0x1UL << FLASH_OPTR_DUALBANK_Pos)      /*!< 0x00200000 */
#define FLASH_OPTR_DUALBANK                 FLASH_OPTR_DUALBANK_Msk                 /*!< Dual-bank on 1Mbyte Flash memory devices */
#define FLASH_OPTR_SRAM3_PE_Pos             (23U)
#define FLASH_OPTR_SRAM3_PE_Msk             (0x1UL << FLASH_OPTR_SRAM3_PE_Pos)      /*!< 0x00800000 */
#define FLASH_OPTR_SRAM3_PE                 FLASH_OPTR_SRAM3_PE_Msk                 /*!< SRAM3 parity check enable*/
#define FLASH_OPTR_SRAM2_PE_Pos             (24U)
#define FLASH_OPTR_SRAM2_PE_Msk             (0x1UL << FLASH_OPTR_SRAM2_PE_Pos)      /*!< 0x01000000 */
#define FLASH_OPTR_SRAM2_PE                 FLASH_OPTR_SRAM2_PE_Msk                 /*!< SRAM2 parity check enable*/
#define FLASH_OPTR_SRAM2_RST_Pos            (25U)
#define FLASH_OPTR_SRAM2_RST_Msk            (0x1UL << FLASH_OPTR_SRAM2_RST_Pos)     /*!< 0x02000000 */
#define FLASH_OPTR_SRAM2_RST                FLASH_OPTR_SRAM2_RST_Msk                /*!< SRAM2 erase when system reset */
#define FLASH_OPTR_nSWBOOT0_Pos             (26U)
#define FLASH_OPTR_nSWBOOT0_Msk             (0x1UL << FLASH_OPTR_nSWBOOT0_Pos)      /*!< 0x04000000 */
#define FLASH_OPTR_nSWBOOT0                 FLASH_OPTR_nSWBOOT0_Msk                 /*!< Software BOOT0 */
#define FLASH_OPTR_nBOOT0_Pos               (27U)
#define FLASH_OPTR_nBOOT0_Msk               (0x1UL << FLASH_OPTR_nBOOT0_Pos)        /*!< 0x08000000 */
#define FLASH_OPTR_nBOOT0                   FLASH_OPTR_nBOOT0_Msk                   /*!< nBOOT0 option bit */
#define FLASH_OPTR_IO_VDD_HSLV_Pos          (29U)
#define FLASH_OPTR_IO_VDD_HSLV_Msk          (0x1UL << FLASH_OPTR_IO_VDD_HSLV_Pos)   /*!< 0x20000000 */
#define FLASH_OPTR_IO_VDD_HSLV              FLASH_OPTR_IO_VDD_HSLV_Msk              /*!< High speed IO at low VDD voltage configuration bit */
#define FLASH_OPTR_IO_VDDIO2_HSLV_Pos       (30U)
#define FLASH_OPTR_IO_VDDIO2_HSLV_Msk       (0x1UL << FLASH_OPTR_IO_VDDIO2_HSLV_Pos) /*!< 0x40000000 */
#define FLASH_OPTR_IO_VDDIO2_HSLV           FLASH_OPTR_IO_VDDIO2_HSLV_Msk            /*!< High speed IO at low VDDIO2 voltage configuration bit */
#define FLASH_OPTR_TZEN_Pos                 (31U)
#define FLASH_OPTR_TZEN_Msk                 (0x1UL << FLASH_OPTR_TZEN_Pos)          /*!< 0x80000000 */
#define FLASH_OPTR_TZEN                     FLASH_OPTR_TZEN_Msk                     /*!< Global TrustZone security enable */

/******************  Bits definition for FLASH_BOOT0R register  ***************/
#define FLASH_BOOT0R_ADD_Pos                (7U)
#define FLASH_BOOT0R_ADD_Msk                (0x1FFFFFFUL << FLASH_BOOT0R_ADD_Pos)   /*!< 0xFFFFFF80 */
#define FLASH_BOOT0R_ADD                    FLASH_BOOT0R_ADD_Msk                    /*!< Non-secure boot base address 0 */

/******************  Bits definition for FLASH_BOOT1R register  ***************/
#define FLASH_BOOT1R_ADD_Pos                (7U)
#define FLASH_BOOT1R_ADD_Msk                (0x1FFFFFFUL << FLASH_BOOT1R_ADD_Pos)   /*!< 0xFFFFFF80 */
#define FLASH_BOOT1R_ADD                    FLASH_BOOT1R_ADD_Msk                    /*!< Non-secure boot base address 1 */

/******************  Bits definition for FLASH_SBOOT0R register  **************/
#define FLASH_SBOOT0R_BOOT_LOCK_Pos         (0U)
#define FLASH_SBOOT0R_BOOT_LOCK_Msk         (0x1UL << FLASH_SBOOT0R_BOOT_LOCK_Pos)  /*!< 0x00000001 */
#define FLASH_SBOOT0R_BOOT_LOCK             FLASH_SBOOT0R_BOOT_LOCK_Msk             /*!< Boot Lock */
#define FLASH_SBOOT0R_ADD_Pos               (7U)
#define FLASH_SBOOT0R_ADD_Msk               (0x1FFFFFFUL << FLASH_SBOOT0R_ADD_Pos)  /*!< 0xFFFFFF80 */
#define FLASH_SBOOT0R_ADD                   FLASH_SBOOT0R_ADD_Msk                   /*!< Secure boot base address 0 */

/*****************  Bits definition for FLASH_SECWM1R1 register  **************/
#define FLASH_SECWM1R1_SECWM1_STRT_Pos      (0U)
#define FLASH_SECWM1R1_SECWM1_STRT_Msk      (0xFFUL << FLASH_SECWM1R1_SECWM1_STRT_Pos) /*!< 0x000000FF */
#define FLASH_SECWM1R1_SECWM1_STRT          FLASH_SECWM1R1_SECWM1_STRT_Msk             /*!< Start page of first secure area */
#define FLASH_SECWM1R1_SECWM1_END_Pos       (16U)
#define FLASH_SECWM1R1_SECWM1_END_Msk       (0xFFUL << FLASH_SECWM1R1_SECWM1_END_Pos)  /*!< 0x00FF0000 */
#define FLASH_SECWM1R1_SECWM1_END           FLASH_SECWM1R1_SECWM1_END_Msk              /*!< End page of first secure area */

/*****************  Bits definition for FLASH_SECWM1R2 register  **************/
#define FLASH_SECWM1R2_HDP1_END_Pos         (16U)
#define FLASH_SECWM1R2_HDP1_END_Msk         (0xFFUL << FLASH_SECWM1R2_HDP1_END_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM1R2_HDP1_END             FLASH_SECWM1R2_HDP1_END_Msk             /*!< End page of first hide protection area */
#define FLASH_SECWM1R2_HDP1EN_Pos           (24U)
#define FLASH_SECWM1R2_HDP1EN_Msk           (0xFFUL << FLASH_SECWM1R2_HDP1EN_Pos)   /*!< 0xFF000000 */
#define FLASH_SECWM1R2_HDP1EN               FLASH_SECWM1R2_HDP1EN_Msk               /*!< Hide protection first area enable */

/******************  Bits definition for FLASH_WRP1AR register  ***************/
#define FLASH_WRP1AR_STRT_Pos               (0U)
#define FLASH_WRP1AR_STRT_Msk               (0xFFUL << FLASH_WRP1AR_STRT_Pos)       /*!< 0x000000FF */
#define FLASH_WRP1AR_STRT                   FLASH_WRP1AR_STRT_Msk                   /*!< Bank 1 WRP first area A start page */
#define FLASH_WRP1AR_END_Pos                (16U)
#define FLASH_WRP1AR_END_Msk                (0xFFUL << FLASH_WRP1AR_END_Pos)        /*!< 0x00FF0000 */
#define FLASH_WRP1AR_END                    FLASH_WRP1AR_END_Msk                    /*!< Bank 1 WRP first area A end page */
#define FLASH_WRP1AR_UNLOCK_Pos             (31U)
#define FLASH_WRP1AR_UNLOCK_Msk             (0x1UL << FLASH_WRP1AR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP1AR_UNLOCK                 FLASH_WRP1AR_UNLOCK_Msk                 /*!< Bank 1 WRP first area A unlock */

/******************  Bits definition for FLASH_WRP1BR register  ***************/
#define FLASH_WRP1BR_STRT_Pos               (0U)
#define FLASH_WRP1BR_STRT_Msk               (0xFFUL << FLASH_WRP1BR_STRT_Pos)       /*!< 0x000000FF */
#define FLASH_WRP1BR_STRT                   FLASH_WRP1BR_STRT_Msk                   /*!< Bank 1 WRP second area B start page */
#define FLASH_WRP1BR_END_Pos                (16U)
#define FLASH_WRP1BR_END_Msk                (0xFFUL << FLASH_WRP1BR_END_Pos)        /*!< 0x00FF0000 */
#define FLASH_WRP1BR_END                    FLASH_WRP1BR_END_Msk                    /*!< Bank 1 WRP second area B end page */
#define FLASH_WRP1BR_UNLOCK_Pos             (31U)
#define FLASH_WRP1BR_UNLOCK_Msk             (0x1UL << FLASH_WRP1BR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP1BR_UNLOCK                 FLASH_WRP1BR_UNLOCK_Msk                 /*!< Bank 1 WRP second area B unlock */

/*****************  Bits definition for FLASH_SECWM2R1 register  **************/
#define FLASH_SECWM2R1_SECWM2_STRT_Pos      (0U)
#define FLASH_SECWM2R1_SECWM2_STRT_Msk      (0xFFUL << FLASH_SECWM2R1_SECWM2_STRT_Pos) /*!< 0x000000FF */
#define FLASH_SECWM2R1_SECWM2_STRT          FLASH_SECWM2R1_SECWM2_STRT_Msk             /*!< Start page of second secure area */
#define FLASH_SECWM2R1_SECWM2_END_Pos       (16U)
#define FLASH_SECWM2R1_SECWM2_END_Msk       (0xFFUL << FLASH_SECWM2R1_SECWM2_END_Pos)  /*!< 0x00FF0000 */
#define FLASH_SECWM2R1_SECWM2_END           FLASH_SECWM2R1_SECWM2_END_Msk              /*!< End page of second secure area */

/*****************  Bits definition for FLASH_SECWM2R2 register  **************/
#define FLASH_SECWM2R2_HDP2_END_Pos         (16U)
#define FLASH_SECWM2R2_HDP2_END_Msk         (0xFFUL << FLASH_SECWM2R2_HDP2_END_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM2R2_HDP2_END             FLASH_SECWM2R2_HDP2_END_Msk             /*!< End page of hide protection second area */
#define FLASH_SECWM2R2_HDP2EN_Pos           (24U)
#define FLASH_SECWM2R2_HDP2EN_Msk           (0xFFUL << FLASH_SECWM2R2_HDP2EN_Pos)   /*!< 0xFF000000 */
#define FLASH_SECWM2R2_HDP2EN               FLASH_SECWM2R2_HDP2EN_Msk               /*!< Hide protection second area enable */

/******************  Bits definition for FLASH_WRP2AR register  ***************/
#define FLASH_WRP2AR_STRT_Pos               (0U)
#define FLASH_WRP2AR_STRT_Msk               (0xFFUL << FLASH_WRP2AR_STRT_Pos)       /*!< 0x000000FF */
#define FLASH_WRP2AR_STRT                   FLASH_WRP2AR_STRT_Msk                   /*!< Bank 2 WPR first area A start page */
#define FLASH_WRP2AR_END_Pos                (16U)
#define FLASH_WRP2AR_END_Msk                (0xFFUL << FLASH_WRP2AR_END_Pos)        /*!< 0x00FF0000 */
#define FLASH_WRP2AR_END                    FLASH_WRP2AR_END_Msk                    /*!< Bank 2 WPR first area A end page */
#define FLASH_WRP2AR_UNLOCK_Pos             (31U)
#define FLASH_WRP2AR_UNLOCK_Msk             (0x1UL << FLASH_WRP2AR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP2AR_UNLOCK                 FLASH_WRP2AR_UNLOCK_Msk                 /*!< Bank 2 WPR first area A unlock */

/******************  Bits definition for FLASH_WRP2BR register  ***************/
#define FLASH_WRP2BR_STRT_Pos               (0U)
#define FLASH_WRP2BR_STRT_Msk               (0xFFUL << FLASH_WRP2BR_STRT_Pos)       /*!< 0x000000FF */
#define FLASH_WRP2BR_STRT                   FLASH_WRP2BR_STRT_Msk                   /*!< Bank 2 WPR second area B start page */
#define FLASH_WRP2BR_END_Pos                (16U)
#define FLASH_WRP2BR_END_Msk                (0xFFUL << FLASH_WRP2BR_END_Pos)        /*!< 0x00FF0000 */
#define FLASH_WRP2BR_END                    FLASH_WRP2BR_END_Msk                    /*!< Bank 2 WPR second area B end page */
#define FLASH_WRP2BR_UNLOCK_Pos             (31U)
#define FLASH_WRP2BR_UNLOCK_Msk             (0x1UL << FLASH_WRP2BR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP2BR_UNLOCK                 FLASH_WRP2BR_UNLOCK_Msk                 /*!< Bank 2 WPR second area B unlock */

/*******************  Bit definition for FLASH_SECBB1R1 register  ******************/
#define FLASH_SECBB1R1_SEC0_Pos                   (0U)
#define FLASH_SECBB1R1_SEC0_Msk                   (0x1UL << FLASH_SECBB1R1_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R1_SEC0                       FLASH_SECBB1R1_SEC0_Msk                       /*!< Page 0 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC1_Pos                   (1U)
#define FLASH_SECBB1R1_SEC1_Msk                   (0x1UL << FLASH_SECBB1R1_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R1_SEC1                       FLASH_SECBB1R1_SEC1_Msk                       /*!< Page 1 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC2_Pos                   (2U)
#define FLASH_SECBB1R1_SEC2_Msk                   (0x1UL << FLASH_SECBB1R1_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R1_SEC2                       FLASH_SECBB1R1_SEC2_Msk                       /*!< Page 2 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC3_Pos                   (3U)
#define FLASH_SECBB1R1_SEC3_Msk                   (0x1UL << FLASH_SECBB1R1_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R1_SEC3                       FLASH_SECBB1R1_SEC3_Msk                       /*!< Page 3 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC4_Pos                   (4U)
#define FLASH_SECBB1R1_SEC4_Msk                   (0x1UL << FLASH_SECBB1R1_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R1_SEC4                       FLASH_SECBB1R1_SEC4_Msk                       /*!< Page 4 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC5_Pos                   (5U)
#define FLASH_SECBB1R1_SEC5_Msk                   (0x1UL << FLASH_SECBB1R1_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R1_SEC5                       FLASH_SECBB1R1_SEC5_Msk                       /*!< Page 5 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC6_Pos                   (6U)
#define FLASH_SECBB1R1_SEC6_Msk                   (0x1UL << FLASH_SECBB1R1_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R1_SEC6                       FLASH_SECBB1R1_SEC6_Msk                       /*!< Page 6 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC7_Pos                   (7U)
#define FLASH_SECBB1R1_SEC7_Msk                   (0x1UL << FLASH_SECBB1R1_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R1_SEC7                       FLASH_SECBB1R1_SEC7_Msk                       /*!< Page 7 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC8_Pos                   (8U)
#define FLASH_SECBB1R1_SEC8_Msk                   (0x1UL << FLASH_SECBB1R1_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R1_SEC8                       FLASH_SECBB1R1_SEC8_Msk                       /*!< Page 8 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC9_Pos                   (9U)
#define FLASH_SECBB1R1_SEC9_Msk                   (0x1UL << FLASH_SECBB1R1_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R1_SEC9                       FLASH_SECBB1R1_SEC9_Msk                       /*!< Page 9 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC10_Pos                  (10U)
#define FLASH_SECBB1R1_SEC10_Msk                  (0x1UL << FLASH_SECBB1R1_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R1_SEC10                      FLASH_SECBB1R1_SEC10_Msk                      /*!< Page 10 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC11_Pos                  (11U)
#define FLASH_SECBB1R1_SEC11_Msk                  (0x1UL << FLASH_SECBB1R1_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R1_SEC11                      FLASH_SECBB1R1_SEC11_Msk                      /*!< Page 11 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC12_Pos                  (12U)
#define FLASH_SECBB1R1_SEC12_Msk                  (0x1UL << FLASH_SECBB1R1_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R1_SEC12                      FLASH_SECBB1R1_SEC12_Msk                      /*!< Page 12 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC13_Pos                  (13U)
#define FLASH_SECBB1R1_SEC13_Msk                  (0x1UL << FLASH_SECBB1R1_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R1_SEC13                      FLASH_SECBB1R1_SEC13_Msk                      /*!< Page 13 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC14_Pos                  (14U)
#define FLASH_SECBB1R1_SEC14_Msk                  (0x1UL << FLASH_SECBB1R1_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R1_SEC14                      FLASH_SECBB1R1_SEC14_Msk                      /*!< Page 14 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC15_Pos                  (15U)
#define FLASH_SECBB1R1_SEC15_Msk                  (0x1UL << FLASH_SECBB1R1_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R1_SEC15                      FLASH_SECBB1R1_SEC15_Msk                      /*!< Page 15 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC16_Pos                  (16U)
#define FLASH_SECBB1R1_SEC16_Msk                  (0x1UL << FLASH_SECBB1R1_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R1_SEC16                      FLASH_SECBB1R1_SEC16_Msk                      /*!< Page 16 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC17_Pos                  (17U)
#define FLASH_SECBB1R1_SEC17_Msk                  (0x1UL << FLASH_SECBB1R1_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R1_SEC17                      FLASH_SECBB1R1_SEC17_Msk                      /*!< Page 17 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC18_Pos                  (18U)
#define FLASH_SECBB1R1_SEC18_Msk                  (0x1UL << FLASH_SECBB1R1_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R1_SEC18                      FLASH_SECBB1R1_SEC18_Msk                      /*!< Page 18 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC19_Pos                  (19U)
#define FLASH_SECBB1R1_SEC19_Msk                  (0x1UL << FLASH_SECBB1R1_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R1_SEC19                      FLASH_SECBB1R1_SEC19_Msk                      /*!< Page 19 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC20_Pos                  (20U)
#define FLASH_SECBB1R1_SEC20_Msk                  (0x1UL << FLASH_SECBB1R1_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R1_SEC20                      FLASH_SECBB1R1_SEC20_Msk                      /*!< Page 20 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC21_Pos                  (21U)
#define FLASH_SECBB1R1_SEC21_Msk                  (0x1UL << FLASH_SECBB1R1_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R1_SEC21                      FLASH_SECBB1R1_SEC21_Msk                      /*!< Page 21 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC22_Pos                  (22U)
#define FLASH_SECBB1R1_SEC22_Msk                  (0x1UL << FLASH_SECBB1R1_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R1_SEC22                      FLASH_SECBB1R1_SEC22_Msk                      /*!< Page 22 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC23_Pos                  (23U)
#define FLASH_SECBB1R1_SEC23_Msk                  (0x1UL << FLASH_SECBB1R1_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R1_SEC23                      FLASH_SECBB1R1_SEC23_Msk                      /*!< Page 23 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC24_Pos                  (24U)
#define FLASH_SECBB1R1_SEC24_Msk                  (0x1UL << FLASH_SECBB1R1_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R1_SEC24                      FLASH_SECBB1R1_SEC24_Msk                      /*!< Page 24 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC25_Pos                  (25U)
#define FLASH_SECBB1R1_SEC25_Msk                  (0x1UL << FLASH_SECBB1R1_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R1_SEC25                      FLASH_SECBB1R1_SEC25_Msk                      /*!< Page 25 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC26_Pos                  (26U)
#define FLASH_SECBB1R1_SEC26_Msk                  (0x1UL << FLASH_SECBB1R1_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R1_SEC26                      FLASH_SECBB1R1_SEC26_Msk                      /*!< Page 26 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC27_Pos                  (27U)
#define FLASH_SECBB1R1_SEC27_Msk                  (0x1UL << FLASH_SECBB1R1_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R1_SEC27                      FLASH_SECBB1R1_SEC27_Msk                      /*!< Page 27 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC28_Pos                  (28U)
#define FLASH_SECBB1R1_SEC28_Msk                  (0x1UL << FLASH_SECBB1R1_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R1_SEC28                      FLASH_SECBB1R1_SEC28_Msk                      /*!< Page 28 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC29_Pos                  (29U)
#define FLASH_SECBB1R1_SEC29_Msk                  (0x1UL << FLASH_SECBB1R1_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R1_SEC29                      FLASH_SECBB1R1_SEC29_Msk                      /*!< Page 29 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC30_Pos                  (30U)
#define FLASH_SECBB1R1_SEC30_Msk                  (0x1UL << FLASH_SECBB1R1_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R1_SEC30                      FLASH_SECBB1R1_SEC30_Msk                      /*!< Page 30 in bank 1 block-based secure */
#define FLASH_SECBB1R1_SEC31_Pos                  (31U)
#define FLASH_SECBB1R1_SEC31_Msk                  (0x1UL << FLASH_SECBB1R1_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R1_SEC31                      FLASH_SECBB1R1_SEC31_Msk                      /*!< Page 31 in bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R2 register  ******************/
#define FLASH_SECBB1R2_SEC0_Pos                   (0U)
#define FLASH_SECBB1R2_SEC0_Msk                   (0x1UL << FLASH_SECBB1R2_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R2_SEC0                       FLASH_SECBB1R2_SEC0_Msk                       /*!< Page 32 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC1_Pos                   (1U)
#define FLASH_SECBB1R2_SEC1_Msk                   (0x1UL << FLASH_SECBB1R2_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R2_SEC1                       FLASH_SECBB1R2_SEC1_Msk                       /*!< Page 33 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC2_Pos                   (2U)
#define FLASH_SECBB1R2_SEC2_Msk                   (0x1UL << FLASH_SECBB1R2_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R2_SEC2                       FLASH_SECBB1R2_SEC2_Msk                       /*!< Page 34 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC3_Pos                   (3U)
#define FLASH_SECBB1R2_SEC3_Msk                   (0x1UL << FLASH_SECBB1R2_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R2_SEC3                       FLASH_SECBB1R2_SEC3_Msk                       /*!< Page 35 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC4_Pos                   (4U)
#define FLASH_SECBB1R2_SEC4_Msk                   (0x1UL << FLASH_SECBB1R2_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R2_SEC4                       FLASH_SECBB1R2_SEC4_Msk                       /*!< Page 36 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC5_Pos                   (5U)
#define FLASH_SECBB1R2_SEC5_Msk                   (0x1UL << FLASH_SECBB1R2_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R2_SEC5                       FLASH_SECBB1R2_SEC5_Msk                       /*!< Page 37 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC6_Pos                   (6U)
#define FLASH_SECBB1R2_SEC6_Msk                   (0x1UL << FLASH_SECBB1R2_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R2_SEC6                       FLASH_SECBB1R2_SEC6_Msk                       /*!< Page 38 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC7_Pos                   (7U)
#define FLASH_SECBB1R2_SEC7_Msk                   (0x1UL << FLASH_SECBB1R2_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R2_SEC7                       FLASH_SECBB1R2_SEC7_Msk                       /*!< Page 39 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC8_Pos                   (8U)
#define FLASH_SECBB1R2_SEC8_Msk                   (0x1UL << FLASH_SECBB1R2_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R2_SEC8                       FLASH_SECBB1R2_SEC8_Msk                       /*!< Page 40 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC9_Pos                   (9U)
#define FLASH_SECBB1R2_SEC9_Msk                   (0x1UL << FLASH_SECBB1R2_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R2_SEC9                       FLASH_SECBB1R2_SEC9_Msk                       /*!< Page 41 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC10_Pos                  (10U)
#define FLASH_SECBB1R2_SEC10_Msk                  (0x1UL << FLASH_SECBB1R2_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R2_SEC10                      FLASH_SECBB1R2_SEC10_Msk                      /*!< Page 42 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC11_Pos                  (11U)
#define FLASH_SECBB1R2_SEC11_Msk                  (0x1UL << FLASH_SECBB1R2_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R2_SEC11                      FLASH_SECBB1R2_SEC11_Msk                      /*!< Page 43 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC12_Pos                  (12U)
#define FLASH_SECBB1R2_SEC12_Msk                  (0x1UL << FLASH_SECBB1R2_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R2_SEC12                      FLASH_SECBB1R2_SEC12_Msk                      /*!< Page 44 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC13_Pos                  (13U)
#define FLASH_SECBB1R2_SEC13_Msk                  (0x1UL << FLASH_SECBB1R2_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R2_SEC13                      FLASH_SECBB1R2_SEC13_Msk                      /*!< Page 45 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC14_Pos                  (14U)
#define FLASH_SECBB1R2_SEC14_Msk                  (0x1UL << FLASH_SECBB1R2_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R2_SEC14                      FLASH_SECBB1R2_SEC14_Msk                      /*!< Page 46 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC15_Pos                  (15U)
#define FLASH_SECBB1R2_SEC15_Msk                  (0x1UL << FLASH_SECBB1R2_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R2_SEC15                      FLASH_SECBB1R2_SEC15_Msk                      /*!< Page 47 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC16_Pos                  (16U)
#define FLASH_SECBB1R2_SEC16_Msk                  (0x1UL << FLASH_SECBB1R2_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R2_SEC16                      FLASH_SECBB1R2_SEC16_Msk                      /*!< Page 48 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC17_Pos                  (17U)
#define FLASH_SECBB1R2_SEC17_Msk                  (0x1UL << FLASH_SECBB1R2_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R2_SEC17                      FLASH_SECBB1R2_SEC17_Msk                      /*!< Page 49 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC18_Pos                  (18U)
#define FLASH_SECBB1R2_SEC18_Msk                  (0x1UL << FLASH_SECBB1R2_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R2_SEC18                      FLASH_SECBB1R2_SEC18_Msk                      /*!< Page 50 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC19_Pos                  (19U)
#define FLASH_SECBB1R2_SEC19_Msk                  (0x1UL << FLASH_SECBB1R2_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R2_SEC19                      FLASH_SECBB1R2_SEC19_Msk                      /*!< Page 51 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC20_Pos                  (20U)
#define FLASH_SECBB1R2_SEC20_Msk                  (0x1UL << FLASH_SECBB1R2_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R2_SEC20                      FLASH_SECBB1R2_SEC20_Msk                      /*!< Page 52 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC21_Pos                  (21U)
#define FLASH_SECBB1R2_SEC21_Msk                  (0x1UL << FLASH_SECBB1R2_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R2_SEC21                      FLASH_SECBB1R2_SEC21_Msk                      /*!< Page 53 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC22_Pos                  (22U)
#define FLASH_SECBB1R2_SEC22_Msk                  (0x1UL << FLASH_SECBB1R2_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R2_SEC22                      FLASH_SECBB1R2_SEC22_Msk                      /*!< Page 54 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC23_Pos                  (23U)
#define FLASH_SECBB1R2_SEC23_Msk                  (0x1UL << FLASH_SECBB1R2_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R2_SEC23                      FLASH_SECBB1R2_SEC23_Msk                      /*!< Page 55 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC24_Pos                  (24U)
#define FLASH_SECBB1R2_SEC24_Msk                  (0x1UL << FLASH_SECBB1R2_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R2_SEC24                      FLASH_SECBB1R2_SEC24_Msk                      /*!< Page 56 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC25_Pos                  (25U)
#define FLASH_SECBB1R2_SEC25_Msk                  (0x1UL << FLASH_SECBB1R2_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R2_SEC25                      FLASH_SECBB1R2_SEC25_Msk                      /*!< Page 57 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC26_Pos                  (26U)
#define FLASH_SECBB1R2_SEC26_Msk                  (0x1UL << FLASH_SECBB1R2_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R2_SEC26                      FLASH_SECBB1R2_SEC26_Msk                      /*!< Page 58 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC27_Pos                  (27U)
#define FLASH_SECBB1R2_SEC27_Msk                  (0x1UL << FLASH_SECBB1R2_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R2_SEC27                      FLASH_SECBB1R2_SEC27_Msk                      /*!< Page 59 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC28_Pos                  (28U)
#define FLASH_SECBB1R2_SEC28_Msk                  (0x1UL << FLASH_SECBB1R2_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R2_SEC28                      FLASH_SECBB1R2_SEC28_Msk                      /*!< Page 60 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC29_Pos                  (29U)
#define FLASH_SECBB1R2_SEC29_Msk                  (0x1UL << FLASH_SECBB1R2_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R2_SEC29                      FLASH_SECBB1R2_SEC29_Msk                      /*!< Page 61 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC30_Pos                  (30U)
#define FLASH_SECBB1R2_SEC30_Msk                  (0x1UL << FLASH_SECBB1R2_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R2_SEC30                      FLASH_SECBB1R2_SEC30_Msk                      /*!< Page 62 in bank 1 block-based secure */
#define FLASH_SECBB1R2_SEC31_Pos                  (31U)
#define FLASH_SECBB1R2_SEC31_Msk                  (0x1UL << FLASH_SECBB1R2_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R2_SEC31                      FLASH_SECBB1R2_SEC31_Msk                      /*!< Page 63 in bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R3 register  ******************/
#define FLASH_SECBB1R3_SEC0_Pos                   (0U)
#define FLASH_SECBB1R3_SEC0_Msk                   (0x1UL << FLASH_SECBB1R3_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R3_SEC0                       FLASH_SECBB1R3_SEC0_Msk                       /*!< Page 64 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC1_Pos                   (1U)
#define FLASH_SECBB1R3_SEC1_Msk                   (0x1UL << FLASH_SECBB1R3_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R3_SEC1                       FLASH_SECBB1R3_SEC1_Msk                       /*!< Page 65 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC2_Pos                   (2U)
#define FLASH_SECBB1R3_SEC2_Msk                   (0x1UL << FLASH_SECBB1R3_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R3_SEC2                       FLASH_SECBB1R3_SEC2_Msk                       /*!< Page 66 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC3_Pos                   (3U)
#define FLASH_SECBB1R3_SEC3_Msk                   (0x1UL << FLASH_SECBB1R3_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R3_SEC3                       FLASH_SECBB1R3_SEC3_Msk                       /*!< Page 67 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC4_Pos                   (4U)
#define FLASH_SECBB1R3_SEC4_Msk                   (0x1UL << FLASH_SECBB1R3_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R3_SEC4                       FLASH_SECBB1R3_SEC4_Msk                       /*!< Page 68 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC5_Pos                   (5U)
#define FLASH_SECBB1R3_SEC5_Msk                   (0x1UL << FLASH_SECBB1R3_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R3_SEC5                       FLASH_SECBB1R3_SEC5_Msk                       /*!< Page 69 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC6_Pos                   (6U)
#define FLASH_SECBB1R3_SEC6_Msk                   (0x1UL << FLASH_SECBB1R3_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R3_SEC6                       FLASH_SECBB1R3_SEC6_Msk                       /*!< Page 70 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC7_Pos                   (7U)
#define FLASH_SECBB1R3_SEC7_Msk                   (0x1UL << FLASH_SECBB1R3_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R3_SEC7                       FLASH_SECBB1R3_SEC7_Msk                       /*!< Page 71 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC8_Pos                   (8U)
#define FLASH_SECBB1R3_SEC8_Msk                   (0x1UL << FLASH_SECBB1R3_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R3_SEC8                       FLASH_SECBB1R3_SEC8_Msk                       /*!< Page 72 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC9_Pos                   (9U)
#define FLASH_SECBB1R3_SEC9_Msk                   (0x1UL << FLASH_SECBB1R3_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R3_SEC9                       FLASH_SECBB1R3_SEC9_Msk                       /*!< Page 73 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC10_Pos                  (10U)
#define FLASH_SECBB1R3_SEC10_Msk                  (0x1UL << FLASH_SECBB1R3_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R3_SEC10                      FLASH_SECBB1R3_SEC10_Msk                      /*!< Page 74 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC11_Pos                  (11U)
#define FLASH_SECBB1R3_SEC11_Msk                  (0x1UL << FLASH_SECBB1R3_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R3_SEC11                      FLASH_SECBB1R3_SEC11_Msk                      /*!< Page 75 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC12_Pos                  (12U)
#define FLASH_SECBB1R3_SEC12_Msk                  (0x1UL << FLASH_SECBB1R3_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R3_SEC12                      FLASH_SECBB1R3_SEC12_Msk                      /*!< Page 76 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC13_Pos                  (13U)
#define FLASH_SECBB1R3_SEC13_Msk                  (0x1UL << FLASH_SECBB1R3_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R3_SEC13                      FLASH_SECBB1R3_SEC13_Msk                      /*!< Page 77 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC14_Pos                  (14U)
#define FLASH_SECBB1R3_SEC14_Msk                  (0x1UL << FLASH_SECBB1R3_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R3_SEC14                      FLASH_SECBB1R3_SEC14_Msk                      /*!< Page 78 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC15_Pos                  (15U)
#define FLASH_SECBB1R3_SEC15_Msk                  (0x1UL << FLASH_SECBB1R3_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R3_SEC15                      FLASH_SECBB1R3_SEC15_Msk                      /*!< Page 79 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC16_Pos                  (16U)
#define FLASH_SECBB1R3_SEC16_Msk                  (0x1UL << FLASH_SECBB1R3_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R3_SEC16                      FLASH_SECBB1R3_SEC16_Msk                      /*!< Page 80 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC17_Pos                  (17U)
#define FLASH_SECBB1R3_SEC17_Msk                  (0x1UL << FLASH_SECBB1R3_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R3_SEC17                      FLASH_SECBB1R3_SEC17_Msk                      /*!< Page 81 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC18_Pos                  (18U)
#define FLASH_SECBB1R3_SEC18_Msk                  (0x1UL << FLASH_SECBB1R3_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R3_SEC18                      FLASH_SECBB1R3_SEC18_Msk                      /*!< Page 82 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC19_Pos                  (19U)
#define FLASH_SECBB1R3_SEC19_Msk                  (0x1UL << FLASH_SECBB1R3_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R3_SEC19                      FLASH_SECBB1R3_SEC19_Msk                      /*!< Page 83 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC20_Pos                  (20U)
#define FLASH_SECBB1R3_SEC20_Msk                  (0x1UL << FLASH_SECBB1R3_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R3_SEC20                      FLASH_SECBB1R3_SEC20_Msk                      /*!< Page 84 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC21_Pos                  (21U)
#define FLASH_SECBB1R3_SEC21_Msk                  (0x1UL << FLASH_SECBB1R3_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R3_SEC21                      FLASH_SECBB1R3_SEC21_Msk                      /*!< Page 85 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC22_Pos                  (22U)
#define FLASH_SECBB1R3_SEC22_Msk                  (0x1UL << FLASH_SECBB1R3_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R3_SEC22                      FLASH_SECBB1R3_SEC22_Msk                      /*!< Page 86 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC23_Pos                  (23U)
#define FLASH_SECBB1R3_SEC23_Msk                  (0x1UL << FLASH_SECBB1R3_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R3_SEC23                      FLASH_SECBB1R3_SEC23_Msk                      /*!< Page 87 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC24_Pos                  (24U)
#define FLASH_SECBB1R3_SEC24_Msk                  (0x1UL << FLASH_SECBB1R3_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R3_SEC24                      FLASH_SECBB1R3_SEC24_Msk                      /*!< Page 88 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC25_Pos                  (25U)
#define FLASH_SECBB1R3_SEC25_Msk                  (0x1UL << FLASH_SECBB1R3_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R3_SEC25                      FLASH_SECBB1R3_SEC25_Msk                      /*!< Page 89 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC26_Pos                  (26U)
#define FLASH_SECBB1R3_SEC26_Msk                  (0x1UL << FLASH_SECBB1R3_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R3_SEC26                      FLASH_SECBB1R3_SEC26_Msk                      /*!< Page 90 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC27_Pos                  (27U)
#define FLASH_SECBB1R3_SEC27_Msk                  (0x1UL << FLASH_SECBB1R3_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R3_SEC27                      FLASH_SECBB1R3_SEC27_Msk                      /*!< Page 91 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC28_Pos                  (28U)
#define FLASH_SECBB1R3_SEC28_Msk                  (0x1UL << FLASH_SECBB1R3_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R3_SEC28                      FLASH_SECBB1R3_SEC28_Msk                      /*!< Page 92 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC29_Pos                  (29U)
#define FLASH_SECBB1R3_SEC29_Msk                  (0x1UL << FLASH_SECBB1R3_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R3_SEC29                      FLASH_SECBB1R3_SEC29_Msk                      /*!< Page 93 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC30_Pos                  (30U)
#define FLASH_SECBB1R3_SEC30_Msk                  (0x1UL << FLASH_SECBB1R3_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R3_SEC30                      FLASH_SECBB1R3_SEC30_Msk                      /*!< Page 94 in bank 1 block-based secure */
#define FLASH_SECBB1R3_SEC31_Pos                  (31U)
#define FLASH_SECBB1R3_SEC31_Msk                  (0x1UL << FLASH_SECBB1R3_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R3_SEC31                      FLASH_SECBB1R3_SEC31_Msk                      /*!< Page 95 in bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB1R4 register  ******************/
#define FLASH_SECBB1R4_SEC0_Pos                   (0U)
#define FLASH_SECBB1R4_SEC0_Msk                   (0x1UL << FLASH_SECBB1R4_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB1R4_SEC0                       FLASH_SECBB1R4_SEC0_Msk                       /*!< Page 96 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC1_Pos                   (1U)
#define FLASH_SECBB1R4_SEC1_Msk                   (0x1UL << FLASH_SECBB1R4_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB1R4_SEC1                       FLASH_SECBB1R4_SEC1_Msk                       /*!< Page 97 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC2_Pos                   (2U)
#define FLASH_SECBB1R4_SEC2_Msk                   (0x1UL << FLASH_SECBB1R4_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB1R4_SEC2                       FLASH_SECBB1R4_SEC2_Msk                       /*!< Page 98 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC3_Pos                   (3U)
#define FLASH_SECBB1R4_SEC3_Msk                   (0x1UL << FLASH_SECBB1R4_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB1R4_SEC3                       FLASH_SECBB1R4_SEC3_Msk                       /*!< Page 99 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC4_Pos                   (4U)
#define FLASH_SECBB1R4_SEC4_Msk                   (0x1UL << FLASH_SECBB1R4_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB1R4_SEC4                       FLASH_SECBB1R4_SEC4_Msk                       /*!< Page 100 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC5_Pos                   (5U)
#define FLASH_SECBB1R4_SEC5_Msk                   (0x1UL << FLASH_SECBB1R4_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB1R4_SEC5                       FLASH_SECBB1R4_SEC5_Msk                       /*!< Page 101 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC6_Pos                   (6U)
#define FLASH_SECBB1R4_SEC6_Msk                   (0x1UL << FLASH_SECBB1R4_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB1R4_SEC6                       FLASH_SECBB1R4_SEC6_Msk                       /*!< Page 102 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC7_Pos                   (7U)
#define FLASH_SECBB1R4_SEC7_Msk                   (0x1UL << FLASH_SECBB1R4_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB1R4_SEC7                       FLASH_SECBB1R4_SEC7_Msk                       /*!< Page 103 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC8_Pos                   (8U)
#define FLASH_SECBB1R4_SEC8_Msk                   (0x1UL << FLASH_SECBB1R4_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB1R4_SEC8                       FLASH_SECBB1R4_SEC8_Msk                       /*!< Page 104 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC9_Pos                   (9U)
#define FLASH_SECBB1R4_SEC9_Msk                   (0x1UL << FLASH_SECBB1R4_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB1R4_SEC9                       FLASH_SECBB1R4_SEC9_Msk                       /*!< Page 105 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC10_Pos                  (10U)
#define FLASH_SECBB1R4_SEC10_Msk                  (0x1UL << FLASH_SECBB1R4_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB1R4_SEC10                      FLASH_SECBB1R4_SEC10_Msk                      /*!< Page 106 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC11_Pos                  (11U)
#define FLASH_SECBB1R4_SEC11_Msk                  (0x1UL << FLASH_SECBB1R4_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB1R4_SEC11                      FLASH_SECBB1R4_SEC11_Msk                      /*!< Page 107 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC12_Pos                  (12U)
#define FLASH_SECBB1R4_SEC12_Msk                  (0x1UL << FLASH_SECBB1R4_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB1R4_SEC12                      FLASH_SECBB1R4_SEC12_Msk                      /*!< Page 108 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC13_Pos                  (13U)
#define FLASH_SECBB1R4_SEC13_Msk                  (0x1UL << FLASH_SECBB1R4_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB1R4_SEC13                      FLASH_SECBB1R4_SEC13_Msk                      /*!< Page 109 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC14_Pos                  (14U)
#define FLASH_SECBB1R4_SEC14_Msk                  (0x1UL << FLASH_SECBB1R4_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB1R4_SEC14                      FLASH_SECBB1R4_SEC14_Msk                      /*!< Page 110 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC15_Pos                  (15U)
#define FLASH_SECBB1R4_SEC15_Msk                  (0x1UL << FLASH_SECBB1R4_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB1R4_SEC15                      FLASH_SECBB1R4_SEC15_Msk                      /*!< Page 111 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC16_Pos                  (16U)
#define FLASH_SECBB1R4_SEC16_Msk                  (0x1UL << FLASH_SECBB1R4_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB1R4_SEC16                      FLASH_SECBB1R4_SEC16_Msk                      /*!< Page 112 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC17_Pos                  (17U)
#define FLASH_SECBB1R4_SEC17_Msk                  (0x1UL << FLASH_SECBB1R4_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB1R4_SEC17                      FLASH_SECBB1R4_SEC17_Msk                      /*!< Page 113 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC18_Pos                  (18U)
#define FLASH_SECBB1R4_SEC18_Msk                  (0x1UL << FLASH_SECBB1R4_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB1R4_SEC18                      FLASH_SECBB1R4_SEC18_Msk                      /*!< Page 114 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC19_Pos                  (19U)
#define FLASH_SECBB1R4_SEC19_Msk                  (0x1UL << FLASH_SECBB1R4_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB1R4_SEC19                      FLASH_SECBB1R4_SEC19_Msk                      /*!< Page 115 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC20_Pos                  (20U)
#define FLASH_SECBB1R4_SEC20_Msk                  (0x1UL << FLASH_SECBB1R4_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB1R4_SEC20                      FLASH_SECBB1R4_SEC20_Msk                      /*!< Page 116 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC21_Pos                  (21U)
#define FLASH_SECBB1R4_SEC21_Msk                  (0x1UL << FLASH_SECBB1R4_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB1R4_SEC21                      FLASH_SECBB1R4_SEC21_Msk                      /*!< Page 117 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC22_Pos                  (22U)
#define FLASH_SECBB1R4_SEC22_Msk                  (0x1UL << FLASH_SECBB1R4_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB1R4_SEC22                      FLASH_SECBB1R4_SEC22_Msk                      /*!< Page 118 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC23_Pos                  (23U)
#define FLASH_SECBB1R4_SEC23_Msk                  (0x1UL << FLASH_SECBB1R4_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB1R4_SEC23                      FLASH_SECBB1R4_SEC23_Msk                      /*!< Page 119 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC24_Pos                  (24U)
#define FLASH_SECBB1R4_SEC24_Msk                  (0x1UL << FLASH_SECBB1R4_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB1R4_SEC24                      FLASH_SECBB1R4_SEC24_Msk                      /*!< Page 120 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC25_Pos                  (25U)
#define FLASH_SECBB1R4_SEC25_Msk                  (0x1UL << FLASH_SECBB1R4_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB1R4_SEC25                      FLASH_SECBB1R4_SEC25_Msk                      /*!< Page 121 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC26_Pos                  (26U)
#define FLASH_SECBB1R4_SEC26_Msk                  (0x1UL << FLASH_SECBB1R4_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB1R4_SEC26                      FLASH_SECBB1R4_SEC26_Msk                      /*!< Page 122 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC27_Pos                  (27U)
#define FLASH_SECBB1R4_SEC27_Msk                  (0x1UL << FLASH_SECBB1R4_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB1R4_SEC27                      FLASH_SECBB1R4_SEC27_Msk                      /*!< Page 123 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC28_Pos                  (28U)
#define FLASH_SECBB1R4_SEC28_Msk                  (0x1UL << FLASH_SECBB1R4_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB1R4_SEC28                      FLASH_SECBB1R4_SEC28_Msk                      /*!< Page 124 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC29_Pos                  (29U)
#define FLASH_SECBB1R4_SEC29_Msk                  (0x1UL << FLASH_SECBB1R4_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB1R4_SEC29                      FLASH_SECBB1R4_SEC29_Msk                      /*!< Page 125 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC30_Pos                  (30U)
#define FLASH_SECBB1R4_SEC30_Msk                  (0x1UL << FLASH_SECBB1R4_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB1R4_SEC30                      FLASH_SECBB1R4_SEC30_Msk                      /*!< Page 126 in bank 1 block-based secure */
#define FLASH_SECBB1R4_SEC31_Pos                  (31U)
#define FLASH_SECBB1R4_SEC31_Msk                  (0x1UL << FLASH_SECBB1R4_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB1R4_SEC31                      FLASH_SECBB1R4_SEC31_Msk                      /*!< Page 127 in bank 1 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R1 register  ******************/
#define FLASH_SECBB2R1_SEC0_Pos                   (0U)
#define FLASH_SECBB2R1_SEC0_Msk                   (0x1UL << FLASH_SECBB2R1_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R1_SEC0                       FLASH_SECBB2R1_SEC0_Msk                       /*!< Page 0 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC1_Pos                   (1U)
#define FLASH_SECBB2R1_SEC1_Msk                   (0x1UL << FLASH_SECBB2R1_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R1_SEC1                       FLASH_SECBB2R1_SEC1_Msk                       /*!< Page 1 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC2_Pos                   (2U)
#define FLASH_SECBB2R1_SEC2_Msk                   (0x1UL << FLASH_SECBB2R1_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R1_SEC2                       FLASH_SECBB2R1_SEC2_Msk                       /*!< Page 2 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC3_Pos                   (3U)
#define FLASH_SECBB2R1_SEC3_Msk                   (0x1UL << FLASH_SECBB2R1_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R1_SEC3                       FLASH_SECBB2R1_SEC3_Msk                       /*!< Page 3 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC4_Pos                   (4U)
#define FLASH_SECBB2R1_SEC4_Msk                   (0x1UL << FLASH_SECBB2R1_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R1_SEC4                       FLASH_SECBB2R1_SEC4_Msk                       /*!< Page 4 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC5_Pos                   (5U)
#define FLASH_SECBB2R1_SEC5_Msk                   (0x1UL << FLASH_SECBB2R1_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R1_SEC5                       FLASH_SECBB2R1_SEC5_Msk                       /*!< Page 5 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC6_Pos                   (6U)
#define FLASH_SECBB2R1_SEC6_Msk                   (0x1UL << FLASH_SECBB2R1_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R1_SEC6                       FLASH_SECBB2R1_SEC6_Msk                       /*!< Page 6 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC7_Pos                   (7U)
#define FLASH_SECBB2R1_SEC7_Msk                   (0x1UL << FLASH_SECBB2R1_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R1_SEC7                       FLASH_SECBB2R1_SEC7_Msk                       /*!< Page 7 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC8_Pos                   (8U)
#define FLASH_SECBB2R1_SEC8_Msk                   (0x1UL << FLASH_SECBB2R1_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R1_SEC8                       FLASH_SECBB2R1_SEC8_Msk                       /*!< Page 8 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC9_Pos                   (9U)
#define FLASH_SECBB2R1_SEC9_Msk                   (0x1UL << FLASH_SECBB2R1_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R1_SEC9                       FLASH_SECBB2R1_SEC9_Msk                       /*!< Page 9 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC10_Pos                  (10U)
#define FLASH_SECBB2R1_SEC10_Msk                  (0x1UL << FLASH_SECBB2R1_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R1_SEC10                      FLASH_SECBB2R1_SEC10_Msk                      /*!< Page 10 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC11_Pos                  (11U)
#define FLASH_SECBB2R1_SEC11_Msk                  (0x1UL << FLASH_SECBB2R1_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R1_SEC11                      FLASH_SECBB2R1_SEC11_Msk                      /*!< Page 11 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC12_Pos                  (12U)
#define FLASH_SECBB2R1_SEC12_Msk                  (0x1UL << FLASH_SECBB2R1_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R1_SEC12                      FLASH_SECBB2R1_SEC12_Msk                      /*!< Page 12 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC13_Pos                  (13U)
#define FLASH_SECBB2R1_SEC13_Msk                  (0x1UL << FLASH_SECBB2R1_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R1_SEC13                      FLASH_SECBB2R1_SEC13_Msk                      /*!< Page 13 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC14_Pos                  (14U)
#define FLASH_SECBB2R1_SEC14_Msk                  (0x1UL << FLASH_SECBB2R1_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R1_SEC14                      FLASH_SECBB2R1_SEC14_Msk                      /*!< Page 14 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC15_Pos                  (15U)
#define FLASH_SECBB2R1_SEC15_Msk                  (0x1UL << FLASH_SECBB2R1_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R1_SEC15                      FLASH_SECBB2R1_SEC15_Msk                      /*!< Page 15 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC16_Pos                  (16U)
#define FLASH_SECBB2R1_SEC16_Msk                  (0x1UL << FLASH_SECBB2R1_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R1_SEC16                      FLASH_SECBB2R1_SEC16_Msk                      /*!< Page 16 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC17_Pos                  (17U)
#define FLASH_SECBB2R1_SEC17_Msk                  (0x1UL << FLASH_SECBB2R1_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R1_SEC17                      FLASH_SECBB2R1_SEC17_Msk                      /*!< Page 17 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC18_Pos                  (18U)
#define FLASH_SECBB2R1_SEC18_Msk                  (0x1UL << FLASH_SECBB2R1_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R1_SEC18                      FLASH_SECBB2R1_SEC18_Msk                      /*!< Page 18 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC19_Pos                  (19U)
#define FLASH_SECBB2R1_SEC19_Msk                  (0x1UL << FLASH_SECBB2R1_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R1_SEC19                      FLASH_SECBB2R1_SEC19_Msk                      /*!< Page 19 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC20_Pos                  (20U)
#define FLASH_SECBB2R1_SEC20_Msk                  (0x1UL << FLASH_SECBB2R1_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R1_SEC20                      FLASH_SECBB2R1_SEC20_Msk                      /*!< Page 20 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC21_Pos                  (21U)
#define FLASH_SECBB2R1_SEC21_Msk                  (0x1UL << FLASH_SECBB2R1_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R1_SEC21                      FLASH_SECBB2R1_SEC21_Msk                      /*!< Page 21 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC22_Pos                  (22U)
#define FLASH_SECBB2R1_SEC22_Msk                  (0x1UL << FLASH_SECBB2R1_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R1_SEC22                      FLASH_SECBB2R1_SEC22_Msk                      /*!< Page 22 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC23_Pos                  (23U)
#define FLASH_SECBB2R1_SEC23_Msk                  (0x1UL << FLASH_SECBB2R1_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R1_SEC23                      FLASH_SECBB2R1_SEC23_Msk                      /*!< Page 23 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC24_Pos                  (24U)
#define FLASH_SECBB2R1_SEC24_Msk                  (0x1UL << FLASH_SECBB2R1_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R1_SEC24                      FLASH_SECBB2R1_SEC24_Msk                      /*!< Page 24 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC25_Pos                  (25U)
#define FLASH_SECBB2R1_SEC25_Msk                  (0x1UL << FLASH_SECBB2R1_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R1_SEC25                      FLASH_SECBB2R1_SEC25_Msk                      /*!< Page 25 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC26_Pos                  (26U)
#define FLASH_SECBB2R1_SEC26_Msk                  (0x1UL << FLASH_SECBB2R1_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R1_SEC26                      FLASH_SECBB2R1_SEC26_Msk                      /*!< Page 26 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC27_Pos                  (27U)
#define FLASH_SECBB2R1_SEC27_Msk                  (0x1UL << FLASH_SECBB2R1_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R1_SEC27                      FLASH_SECBB2R1_SEC27_Msk                      /*!< Page 27 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC28_Pos                  (28U)
#define FLASH_SECBB2R1_SEC28_Msk                  (0x1UL << FLASH_SECBB2R1_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R1_SEC28                      FLASH_SECBB2R1_SEC28_Msk                      /*!< Page 28 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC29_Pos                  (29U)
#define FLASH_SECBB2R1_SEC29_Msk                  (0x1UL << FLASH_SECBB2R1_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R1_SEC29                      FLASH_SECBB2R1_SEC29_Msk                      /*!< Page 29 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC30_Pos                  (30U)
#define FLASH_SECBB2R1_SEC30_Msk                  (0x1UL << FLASH_SECBB2R1_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R1_SEC30                      FLASH_SECBB2R1_SEC30_Msk                      /*!< Page 30 in bank 2 block-based secure */
#define FLASH_SECBB2R1_SEC31_Pos                  (31U)
#define FLASH_SECBB2R1_SEC31_Msk                  (0x1UL << FLASH_SECBB2R1_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R1_SEC31                      FLASH_SECBB2R1_SEC31_Msk                      /*!< Page 31 in bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R2 register  ******************/
#define FLASH_SECBB2R2_SEC0_Pos                   (0U)
#define FLASH_SECBB2R2_SEC0_Msk                   (0x1UL << FLASH_SECBB2R2_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R2_SEC0                       FLASH_SECBB2R2_SEC0_Msk                       /*!< Page 32 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC1_Pos                   (1U)
#define FLASH_SECBB2R2_SEC1_Msk                   (0x1UL << FLASH_SECBB2R2_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R2_SEC1                       FLASH_SECBB2R2_SEC1_Msk                       /*!< Page 33 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC2_Pos                   (2U)
#define FLASH_SECBB2R2_SEC2_Msk                   (0x1UL << FLASH_SECBB2R2_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R2_SEC2                       FLASH_SECBB2R2_SEC2_Msk                       /*!< Page 34 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC3_Pos                   (3U)
#define FLASH_SECBB2R2_SEC3_Msk                   (0x1UL << FLASH_SECBB2R2_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R2_SEC3                       FLASH_SECBB2R2_SEC3_Msk                       /*!< Page 35 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC4_Pos                   (4U)
#define FLASH_SECBB2R2_SEC4_Msk                   (0x1UL << FLASH_SECBB2R2_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R2_SEC4                       FLASH_SECBB2R2_SEC4_Msk                       /*!< Page 36 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC5_Pos                   (5U)
#define FLASH_SECBB2R2_SEC5_Msk                   (0x1UL << FLASH_SECBB2R2_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R2_SEC5                       FLASH_SECBB2R2_SEC5_Msk                       /*!< Page 37 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC6_Pos                   (6U)
#define FLASH_SECBB2R2_SEC6_Msk                   (0x1UL << FLASH_SECBB2R2_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R2_SEC6                       FLASH_SECBB2R2_SEC6_Msk                       /*!< Page 38 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC7_Pos                   (7U)
#define FLASH_SECBB2R2_SEC7_Msk                   (0x1UL << FLASH_SECBB2R2_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R2_SEC7                       FLASH_SECBB2R2_SEC7_Msk                       /*!< Page 39 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC8_Pos                   (8U)
#define FLASH_SECBB2R2_SEC8_Msk                   (0x1UL << FLASH_SECBB2R2_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R2_SEC8                       FLASH_SECBB2R2_SEC8_Msk                       /*!< Page 40 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC9_Pos                   (9U)
#define FLASH_SECBB2R2_SEC9_Msk                   (0x1UL << FLASH_SECBB2R2_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R2_SEC9                       FLASH_SECBB2R2_SEC9_Msk                       /*!< Page 41 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC10_Pos                  (10U)
#define FLASH_SECBB2R2_SEC10_Msk                  (0x1UL << FLASH_SECBB2R2_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R2_SEC10                      FLASH_SECBB2R2_SEC10_Msk                      /*!< Page 42 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC11_Pos                  (11U)
#define FLASH_SECBB2R2_SEC11_Msk                  (0x1UL << FLASH_SECBB2R2_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R2_SEC11                      FLASH_SECBB2R2_SEC11_Msk                      /*!< Page 43 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC12_Pos                  (12U)
#define FLASH_SECBB2R2_SEC12_Msk                  (0x1UL << FLASH_SECBB2R2_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R2_SEC12                      FLASH_SECBB2R2_SEC12_Msk                      /*!< Page 44 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC13_Pos                  (13U)
#define FLASH_SECBB2R2_SEC13_Msk                  (0x1UL << FLASH_SECBB2R2_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R2_SEC13                      FLASH_SECBB2R2_SEC13_Msk                      /*!< Page 45 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC14_Pos                  (14U)
#define FLASH_SECBB2R2_SEC14_Msk                  (0x1UL << FLASH_SECBB2R2_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R2_SEC14                      FLASH_SECBB2R2_SEC14_Msk                      /*!< Page 46 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC15_Pos                  (15U)
#define FLASH_SECBB2R2_SEC15_Msk                  (0x1UL << FLASH_SECBB2R2_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R2_SEC15                      FLASH_SECBB2R2_SEC15_Msk                      /*!< Page 47 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC16_Pos                  (16U)
#define FLASH_SECBB2R2_SEC16_Msk                  (0x1UL << FLASH_SECBB2R2_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R2_SEC16                      FLASH_SECBB2R2_SEC16_Msk                      /*!< Page 48 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC17_Pos                  (17U)
#define FLASH_SECBB2R2_SEC17_Msk                  (0x1UL << FLASH_SECBB2R2_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R2_SEC17                      FLASH_SECBB2R2_SEC17_Msk                      /*!< Page 49 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC18_Pos                  (18U)
#define FLASH_SECBB2R2_SEC18_Msk                  (0x1UL << FLASH_SECBB2R2_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R2_SEC18                      FLASH_SECBB2R2_SEC18_Msk                      /*!< Page 50 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC19_Pos                  (19U)
#define FLASH_SECBB2R2_SEC19_Msk                  (0x1UL << FLASH_SECBB2R2_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R2_SEC19                      FLASH_SECBB2R2_SEC19_Msk                      /*!< Page 51 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC20_Pos                  (20U)
#define FLASH_SECBB2R2_SEC20_Msk                  (0x1UL << FLASH_SECBB2R2_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R2_SEC20                      FLASH_SECBB2R2_SEC20_Msk                      /*!< Page 52 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC21_Pos                  (21U)
#define FLASH_SECBB2R2_SEC21_Msk                  (0x1UL << FLASH_SECBB2R2_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R2_SEC21                      FLASH_SECBB2R2_SEC21_Msk                      /*!< Page 53 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC22_Pos                  (22U)
#define FLASH_SECBB2R2_SEC22_Msk                  (0x1UL << FLASH_SECBB2R2_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R2_SEC22                      FLASH_SECBB2R2_SEC22_Msk                      /*!< Page 54 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC23_Pos                  (23U)
#define FLASH_SECBB2R2_SEC23_Msk                  (0x1UL << FLASH_SECBB2R2_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R2_SEC23                      FLASH_SECBB2R2_SEC23_Msk                      /*!< Page 55 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC24_Pos                  (24U)
#define FLASH_SECBB2R2_SEC24_Msk                  (0x1UL << FLASH_SECBB2R2_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R2_SEC24                      FLASH_SECBB2R2_SEC24_Msk                      /*!< Page 56 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC25_Pos                  (25U)
#define FLASH_SECBB2R2_SEC25_Msk                  (0x1UL << FLASH_SECBB2R2_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R2_SEC25                      FLASH_SECBB2R2_SEC25_Msk                      /*!< Page 57 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC26_Pos                  (26U)
#define FLASH_SECBB2R2_SEC26_Msk                  (0x1UL << FLASH_SECBB2R2_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R2_SEC26                      FLASH_SECBB2R2_SEC26_Msk                      /*!< Page 58 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC27_Pos                  (27U)
#define FLASH_SECBB2R2_SEC27_Msk                  (0x1UL << FLASH_SECBB2R2_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R2_SEC27                      FLASH_SECBB2R2_SEC27_Msk                      /*!< Page 59 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC28_Pos                  (28U)
#define FLASH_SECBB2R2_SEC28_Msk                  (0x1UL << FLASH_SECBB2R2_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R2_SEC28                      FLASH_SECBB2R2_SEC28_Msk                      /*!< Page 60 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC29_Pos                  (29U)
#define FLASH_SECBB2R2_SEC29_Msk                  (0x1UL << FLASH_SECBB2R2_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R2_SEC29                      FLASH_SECBB2R2_SEC29_Msk                      /*!< Page 61 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC30_Pos                  (30U)
#define FLASH_SECBB2R2_SEC30_Msk                  (0x1UL << FLASH_SECBB2R2_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R2_SEC30                      FLASH_SECBB2R2_SEC30_Msk                      /*!< Page 62 in bank 2 block-based secure */
#define FLASH_SECBB2R2_SEC31_Pos                  (31U)
#define FLASH_SECBB2R2_SEC31_Msk                  (0x1UL << FLASH_SECBB2R2_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R2_SEC31                      FLASH_SECBB2R2_SEC31_Msk                      /*!< Page 63 in bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R3 register  ******************/
#define FLASH_SECBB2R3_SEC0_Pos                   (0U)
#define FLASH_SECBB2R3_SEC0_Msk                   (0x1UL << FLASH_SECBB2R3_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R3_SEC0                       FLASH_SECBB2R3_SEC0_Msk                       /*!< Page 64 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC1_Pos                   (1U)
#define FLASH_SECBB2R3_SEC1_Msk                   (0x1UL << FLASH_SECBB2R3_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R3_SEC1                       FLASH_SECBB2R3_SEC1_Msk                       /*!< Page 65 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC2_Pos                   (2U)
#define FLASH_SECBB2R3_SEC2_Msk                   (0x1UL << FLASH_SECBB2R3_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R3_SEC2                       FLASH_SECBB2R3_SEC2_Msk                       /*!< Page 66 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC3_Pos                   (3U)
#define FLASH_SECBB2R3_SEC3_Msk                   (0x1UL << FLASH_SECBB2R3_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R3_SEC3                       FLASH_SECBB2R3_SEC3_Msk                       /*!< Page 67 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC4_Pos                   (4U)
#define FLASH_SECBB2R3_SEC4_Msk                   (0x1UL << FLASH_SECBB2R3_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R3_SEC4                       FLASH_SECBB2R3_SEC4_Msk                       /*!< Page 68 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC5_Pos                   (5U)
#define FLASH_SECBB2R3_SEC5_Msk                   (0x1UL << FLASH_SECBB2R3_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R3_SEC5                       FLASH_SECBB2R3_SEC5_Msk                       /*!< Page 69 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC6_Pos                   (6U)
#define FLASH_SECBB2R3_SEC6_Msk                   (0x1UL << FLASH_SECBB2R3_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R3_SEC6                       FLASH_SECBB2R3_SEC6_Msk                       /*!< Page 70 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC7_Pos                   (7U)
#define FLASH_SECBB2R3_SEC7_Msk                   (0x1UL << FLASH_SECBB2R3_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R3_SEC7                       FLASH_SECBB2R3_SEC7_Msk                       /*!< Page 71 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC8_Pos                   (8U)
#define FLASH_SECBB2R3_SEC8_Msk                   (0x1UL << FLASH_SECBB2R3_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R3_SEC8                       FLASH_SECBB2R3_SEC8_Msk                       /*!< Page 72 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC9_Pos                   (9U)
#define FLASH_SECBB2R3_SEC9_Msk                   (0x1UL << FLASH_SECBB2R3_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R3_SEC9                       FLASH_SECBB2R3_SEC9_Msk                       /*!< Page 73 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC10_Pos                  (10U)
#define FLASH_SECBB2R3_SEC10_Msk                  (0x1UL << FLASH_SECBB2R3_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R3_SEC10                      FLASH_SECBB2R3_SEC10_Msk                      /*!< Page 74 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC11_Pos                  (11U)
#define FLASH_SECBB2R3_SEC11_Msk                  (0x1UL << FLASH_SECBB2R3_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R3_SEC11                      FLASH_SECBB2R3_SEC11_Msk                      /*!< Page 75 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC12_Pos                  (12U)
#define FLASH_SECBB2R3_SEC12_Msk                  (0x1UL << FLASH_SECBB2R3_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R3_SEC12                      FLASH_SECBB2R3_SEC12_Msk                      /*!< Page 76 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC13_Pos                  (13U)
#define FLASH_SECBB2R3_SEC13_Msk                  (0x1UL << FLASH_SECBB2R3_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R3_SEC13                      FLASH_SECBB2R3_SEC13_Msk                      /*!< Page 77 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC14_Pos                  (14U)
#define FLASH_SECBB2R3_SEC14_Msk                  (0x1UL << FLASH_SECBB2R3_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R3_SEC14                      FLASH_SECBB2R3_SEC14_Msk                      /*!< Page 78 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC15_Pos                  (15U)
#define FLASH_SECBB2R3_SEC15_Msk                  (0x1UL << FLASH_SECBB2R3_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R3_SEC15                      FLASH_SECBB2R3_SEC15_Msk                      /*!< Page 79 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC16_Pos                  (16U)
#define FLASH_SECBB2R3_SEC16_Msk                  (0x1UL << FLASH_SECBB2R3_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R3_SEC16                      FLASH_SECBB2R3_SEC16_Msk                      /*!< Page 80 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC17_Pos                  (17U)
#define FLASH_SECBB2R3_SEC17_Msk                  (0x1UL << FLASH_SECBB2R3_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R3_SEC17                      FLASH_SECBB2R3_SEC17_Msk                      /*!< Page 81 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC18_Pos                  (18U)
#define FLASH_SECBB2R3_SEC18_Msk                  (0x1UL << FLASH_SECBB2R3_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R3_SEC18                      FLASH_SECBB2R3_SEC18_Msk                      /*!< Page 82 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC19_Pos                  (19U)
#define FLASH_SECBB2R3_SEC19_Msk                  (0x1UL << FLASH_SECBB2R3_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R3_SEC19                      FLASH_SECBB2R3_SEC19_Msk                      /*!< Page 83 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC20_Pos                  (20U)
#define FLASH_SECBB2R3_SEC20_Msk                  (0x1UL << FLASH_SECBB2R3_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R3_SEC20                      FLASH_SECBB2R3_SEC20_Msk                      /*!< Page 84 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC21_Pos                  (21U)
#define FLASH_SECBB2R3_SEC21_Msk                  (0x1UL << FLASH_SECBB2R3_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R3_SEC21                      FLASH_SECBB2R3_SEC21_Msk                      /*!< Page 85 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC22_Pos                  (22U)
#define FLASH_SECBB2R3_SEC22_Msk                  (0x1UL << FLASH_SECBB2R3_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R3_SEC22                      FLASH_SECBB2R3_SEC22_Msk                      /*!< Page 86 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC23_Pos                  (23U)
#define FLASH_SECBB2R3_SEC23_Msk                  (0x1UL << FLASH_SECBB2R3_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R3_SEC23                      FLASH_SECBB2R3_SEC23_Msk                      /*!< Page 87 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC24_Pos                  (24U)
#define FLASH_SECBB2R3_SEC24_Msk                  (0x1UL << FLASH_SECBB2R3_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R3_SEC24                      FLASH_SECBB2R3_SEC24_Msk                      /*!< Page 88 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC25_Pos                  (25U)
#define FLASH_SECBB2R3_SEC25_Msk                  (0x1UL << FLASH_SECBB2R3_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R3_SEC25                      FLASH_SECBB2R3_SEC25_Msk                      /*!< Page 89 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC26_Pos                  (26U)
#define FLASH_SECBB2R3_SEC26_Msk                  (0x1UL << FLASH_SECBB2R3_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R3_SEC26                      FLASH_SECBB2R3_SEC26_Msk                      /*!< Page 90 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC27_Pos                  (27U)
#define FLASH_SECBB2R3_SEC27_Msk                  (0x1UL << FLASH_SECBB2R3_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R3_SEC27                      FLASH_SECBB2R3_SEC27_Msk                      /*!< Page 91 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC28_Pos                  (28U)
#define FLASH_SECBB2R3_SEC28_Msk                  (0x1UL << FLASH_SECBB2R3_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R3_SEC28                      FLASH_SECBB2R3_SEC28_Msk                      /*!< Page 92 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC29_Pos                  (29U)
#define FLASH_SECBB2R3_SEC29_Msk                  (0x1UL << FLASH_SECBB2R3_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R3_SEC29                      FLASH_SECBB2R3_SEC29_Msk                      /*!< Page 93 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC30_Pos                  (30U)
#define FLASH_SECBB2R3_SEC30_Msk                  (0x1UL << FLASH_SECBB2R3_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R3_SEC30                      FLASH_SECBB2R3_SEC30_Msk                      /*!< Page 94 in bank 2 block-based secure */
#define FLASH_SECBB2R3_SEC31_Pos                  (31U)
#define FLASH_SECBB2R3_SEC31_Msk                  (0x1UL << FLASH_SECBB2R3_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R3_SEC31                      FLASH_SECBB2R3_SEC31_Msk                      /*!< Page 95 in bank 2 block-based secure */

/*******************  Bit definition for FLASH_SECBB2R4 register  ******************/
#define FLASH_SECBB2R4_SEC0_Pos                   (0U)
#define FLASH_SECBB2R4_SEC0_Msk                   (0x1UL << FLASH_SECBB2R4_SEC0_Pos)            /*!< 0x00000001 */
#define FLASH_SECBB2R4_SEC0                       FLASH_SECBB2R4_SEC0_Msk                       /*!< Page 96 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC1_Pos                   (1U)
#define FLASH_SECBB2R4_SEC1_Msk                   (0x1UL << FLASH_SECBB2R4_SEC1_Pos)            /*!< 0x00000002 */
#define FLASH_SECBB2R4_SEC1                       FLASH_SECBB2R4_SEC1_Msk                       /*!< Page 97 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC2_Pos                   (2U)
#define FLASH_SECBB2R4_SEC2_Msk                   (0x1UL << FLASH_SECBB2R4_SEC2_Pos)            /*!< 0x00000004 */
#define FLASH_SECBB2R4_SEC2                       FLASH_SECBB2R4_SEC2_Msk                       /*!< Page 98 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC3_Pos                   (3U)
#define FLASH_SECBB2R4_SEC3_Msk                   (0x1UL << FLASH_SECBB2R4_SEC3_Pos)            /*!< 0x00000008 */
#define FLASH_SECBB2R4_SEC3                       FLASH_SECBB2R4_SEC3_Msk                       /*!< Page 99 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC4_Pos                   (4U)
#define FLASH_SECBB2R4_SEC4_Msk                   (0x1UL << FLASH_SECBB2R4_SEC4_Pos)            /*!< 0x00000010 */
#define FLASH_SECBB2R4_SEC4                       FLASH_SECBB2R4_SEC4_Msk                       /*!< Page 100 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC5_Pos                   (5U)
#define FLASH_SECBB2R4_SEC5_Msk                   (0x1UL << FLASH_SECBB2R4_SEC5_Pos)            /*!< 0x00000020 */
#define FLASH_SECBB2R4_SEC5                       FLASH_SECBB2R4_SEC5_Msk                       /*!< Page 101 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC6_Pos                   (6U)
#define FLASH_SECBB2R4_SEC6_Msk                   (0x1UL << FLASH_SECBB2R4_SEC6_Pos)            /*!< 0x00000040 */
#define FLASH_SECBB2R4_SEC6                       FLASH_SECBB2R4_SEC6_Msk                       /*!< Page 102 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC7_Pos                   (7U)
#define FLASH_SECBB2R4_SEC7_Msk                   (0x1UL << FLASH_SECBB2R4_SEC7_Pos)            /*!< 0x00000080 */
#define FLASH_SECBB2R4_SEC7                       FLASH_SECBB2R4_SEC7_Msk                       /*!< Page 103 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC8_Pos                   (8U)
#define FLASH_SECBB2R4_SEC8_Msk                   (0x1UL << FLASH_SECBB2R4_SEC8_Pos)            /*!< 0x00000100 */
#define FLASH_SECBB2R4_SEC8                       FLASH_SECBB2R4_SEC8_Msk                       /*!< Page 104 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC9_Pos                   (9U)
#define FLASH_SECBB2R4_SEC9_Msk                   (0x1UL << FLASH_SECBB2R4_SEC9_Pos)            /*!< 0x00000200 */
#define FLASH_SECBB2R4_SEC9                       FLASH_SECBB2R4_SEC9_Msk                       /*!< Page 105 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC10_Pos                  (10U)
#define FLASH_SECBB2R4_SEC10_Msk                  (0x1UL << FLASH_SECBB2R4_SEC10_Pos)           /*!< 0x00000400 */
#define FLASH_SECBB2R4_SEC10                      FLASH_SECBB2R4_SEC10_Msk                      /*!< Page 106 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC11_Pos                  (11U)
#define FLASH_SECBB2R4_SEC11_Msk                  (0x1UL << FLASH_SECBB2R4_SEC11_Pos)           /*!< 0x00000800 */
#define FLASH_SECBB2R4_SEC11                      FLASH_SECBB2R4_SEC11_Msk                      /*!< Page 107 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC12_Pos                  (12U)
#define FLASH_SECBB2R4_SEC12_Msk                  (0x1UL << FLASH_SECBB2R4_SEC12_Pos)           /*!< 0x00001000 */
#define FLASH_SECBB2R4_SEC12                      FLASH_SECBB2R4_SEC12_Msk                      /*!< Page 108 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC13_Pos                  (13U)
#define FLASH_SECBB2R4_SEC13_Msk                  (0x1UL << FLASH_SECBB2R4_SEC13_Pos)           /*!< 0x00002000 */
#define FLASH_SECBB2R4_SEC13                      FLASH_SECBB2R4_SEC13_Msk                      /*!< Page 109 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC14_Pos                  (14U)
#define FLASH_SECBB2R4_SEC14_Msk                  (0x1UL << FLASH_SECBB2R4_SEC14_Pos)           /*!< 0x00004000 */
#define FLASH_SECBB2R4_SEC14                      FLASH_SECBB2R4_SEC14_Msk                      /*!< Page 110 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC15_Pos                  (15U)
#define FLASH_SECBB2R4_SEC15_Msk                  (0x1UL << FLASH_SECBB2R4_SEC15_Pos)           /*!< 0x00008000 */
#define FLASH_SECBB2R4_SEC15                      FLASH_SECBB2R4_SEC15_Msk                      /*!< Page 111 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC16_Pos                  (16U)
#define FLASH_SECBB2R4_SEC16_Msk                  (0x1UL << FLASH_SECBB2R4_SEC16_Pos)           /*!< 0x00010000 */
#define FLASH_SECBB2R4_SEC16                      FLASH_SECBB2R4_SEC16_Msk                      /*!< Page 112 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC17_Pos                  (17U)
#define FLASH_SECBB2R4_SEC17_Msk                  (0x1UL << FLASH_SECBB2R4_SEC17_Pos)           /*!< 0x00020000 */
#define FLASH_SECBB2R4_SEC17                      FLASH_SECBB2R4_SEC17_Msk                      /*!< Page 113 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC18_Pos                  (18U)
#define FLASH_SECBB2R4_SEC18_Msk                  (0x1UL << FLASH_SECBB2R4_SEC18_Pos)           /*!< 0x00040000 */
#define FLASH_SECBB2R4_SEC18                      FLASH_SECBB2R4_SEC18_Msk                      /*!< Page 114 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC19_Pos                  (19U)
#define FLASH_SECBB2R4_SEC19_Msk                  (0x1UL << FLASH_SECBB2R4_SEC19_Pos)           /*!< 0x00080000 */
#define FLASH_SECBB2R4_SEC19                      FLASH_SECBB2R4_SEC19_Msk                      /*!< Page 115 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC20_Pos                  (20U)
#define FLASH_SECBB2R4_SEC20_Msk                  (0x1UL << FLASH_SECBB2R4_SEC20_Pos)           /*!< 0x00100000 */
#define FLASH_SECBB2R4_SEC20                      FLASH_SECBB2R4_SEC20_Msk                      /*!< Page 116 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC21_Pos                  (21U)
#define FLASH_SECBB2R4_SEC21_Msk                  (0x1UL << FLASH_SECBB2R4_SEC21_Pos)           /*!< 0x00200000 */
#define FLASH_SECBB2R4_SEC21                      FLASH_SECBB2R4_SEC21_Msk                      /*!< Page 117 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC22_Pos                  (22U)
#define FLASH_SECBB2R4_SEC22_Msk                  (0x1UL << FLASH_SECBB2R4_SEC22_Pos)           /*!< 0x00400000 */
#define FLASH_SECBB2R4_SEC22                      FLASH_SECBB2R4_SEC22_Msk                      /*!< Page 118 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC23_Pos                  (23U)
#define FLASH_SECBB2R4_SEC23_Msk                  (0x1UL << FLASH_SECBB2R4_SEC23_Pos)           /*!< 0x00800000 */
#define FLASH_SECBB2R4_SEC23                      FLASH_SECBB2R4_SEC23_Msk                      /*!< Page 119 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC24_Pos                  (24U)
#define FLASH_SECBB2R4_SEC24_Msk                  (0x1UL << FLASH_SECBB2R4_SEC24_Pos)           /*!< 0x01000000 */
#define FLASH_SECBB2R4_SEC24                      FLASH_SECBB2R4_SEC24_Msk                      /*!< Page 120 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC25_Pos                  (25U)
#define FLASH_SECBB2R4_SEC25_Msk                  (0x1UL << FLASH_SECBB2R4_SEC25_Pos)           /*!< 0x02000000 */
#define FLASH_SECBB2R4_SEC25                      FLASH_SECBB2R4_SEC25_Msk                      /*!< Page 121 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC26_Pos                  (26U)
#define FLASH_SECBB2R4_SEC26_Msk                  (0x1UL << FLASH_SECBB2R4_SEC26_Pos)           /*!< 0x04000000 */
#define FLASH_SECBB2R4_SEC26                      FLASH_SECBB2R4_SEC26_Msk                      /*!< Page 122 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC27_Pos                  (27U)
#define FLASH_SECBB2R4_SEC27_Msk                  (0x1UL << FLASH_SECBB2R4_SEC27_Pos)           /*!< 0x08000000 */
#define FLASH_SECBB2R4_SEC27                      FLASH_SECBB2R4_SEC27_Msk                      /*!< Page 123 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC28_Pos                  (28U)
#define FLASH_SECBB2R4_SEC28_Msk                  (0x1UL << FLASH_SECBB2R4_SEC28_Pos)           /*!< 0x10000000 */
#define FLASH_SECBB2R4_SEC28                      FLASH_SECBB2R4_SEC28_Msk                      /*!< Page 124 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC29_Pos                  (29U)
#define FLASH_SECBB2R4_SEC29_Msk                  (0x1UL << FLASH_SECBB2R4_SEC29_Pos)           /*!< 0x20000000 */
#define FLASH_SECBB2R4_SEC29                      FLASH_SECBB2R4_SEC29_Msk                      /*!< Page 125 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC30_Pos                  (30U)
#define FLASH_SECBB2R4_SEC30_Msk                  (0x1UL << FLASH_SECBB2R4_SEC30_Pos)           /*!< 0x40000000 */
#define FLASH_SECBB2R4_SEC30                      FLASH_SECBB2R4_SEC30_Msk                      /*!< Page 126 in bank 2 block-based secure */
#define FLASH_SECBB2R4_SEC31_Pos                  (31U)
#define FLASH_SECBB2R4_SEC31_Msk                  (0x1UL << FLASH_SECBB2R4_SEC31_Pos)           /*!< 0x80000000 */
#define FLASH_SECBB2R4_SEC31                      FLASH_SECBB2R4_SEC31_Msk                      /*!< Page 127 in bank 2 block-based secure */

/**********************  Bits definition for FLASH_SECHDPCR register  ***************/
#define FLASH_SECHDPCR_HDP1_ACCDIS_Pos            (0U)
#define FLASH_SECHDPCR_HDP1_ACCDIS_Msk            (0xFFUL << FLASH_SECHDPCR_HDP1_ACCDIS_Pos)    /*!< 0x000000FF */
#define FLASH_SECHDPCR_HDP1_ACCDIS                FLASH_SECHDPCR_HDP1_ACCDIS_Msk                /*!< HDP1 area access disable */
#define FLASH_SECHDPCR_HDP2_ACCDIS_Pos            (8U)
#define FLASH_SECHDPCR_HDP2_ACCDIS_Msk            (0xFFUL << FLASH_SECHDPCR_HDP2_ACCDIS_Pos)    /*!< 0x0000FF00 */
#define FLASH_SECHDPCR_HDP2_ACCDIS                FLASH_SECHDPCR_HDP2_ACCDIS_Msk                /*!< HDP2 area access disable */
#define FLASH_SECHDPCR_HDP1EXT_ACCDIS_Pos         (16U)
#define FLASH_SECHDPCR_HDP1EXT_ACCDIS_Msk         (0xFFUL << FLASH_SECHDPCR_HDP1EXT_ACCDIS_Pos) /*!< 0x00FF0000 */
#define FLASH_SECHDPCR_HDP1EXT_ACCDIS             FLASH_SECHDPCR_HDP1EXT_ACCDIS_Msk             /*!< HDP1 extension area access disable */
#define FLASH_SECHDPCR_HDP2EXT_ACCDIS_Pos         (24U)
#define FLASH_SECHDPCR_HDP2EXT_ACCDIS_Msk         (0xFFUL << FLASH_SECHDPCR_HDP2EXT_ACCDIS_Pos) /*!< 0xFF000000 */
#define FLASH_SECHDPCR_HDP2EXT_ACCDIS             FLASH_SECHDPCR_HDP2EXT_ACCDIS_Msk             /*!< HDP2 extension area access disable */

/**********************  Bits definition for FLASH_PRIVCFGR register  ***************/
#define FLASH_PRIVCFGR_SPRIV_Pos                  (0U)
#define FLASH_PRIVCFGR_SPRIV_Msk                  (0x1UL << FLASH_PRIVCFGR_SPRIV_Pos)           /*!< 0x00000001 */
#define FLASH_PRIVCFGR_SPRIV                      FLASH_PRIVCFGR_SPRIV_Msk                      /*!< Privilege protection for secure registers */
#define FLASH_PRIVCFGR_PRIV_Pos                   (1U)
#define FLASH_PRIVCFGR_PRIV_Msk                   (0x1UL << FLASH_PRIVCFGR_PRIV_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVCFGR_PRIV                       FLASH_PRIVCFGR_PRIV_Msk                       /*!< Privilege protection for non-secure registers */

/*********************  Bits definition for FLASH_SECHDPEXTR register  **************/
#define FLASH_SECHDPEXTR_HDP1_EXT_Pos             (0U)
#define FLASH_SECHDPEXTR_HDP1_EXT_Msk             (0x1FFUL << FLASH_SECHDPEXTR_HDP1_EXT_Pos)    /*!< 0x000001FF */
#define FLASH_SECHDPEXTR_HDP1_EXT                 FLASH_SECHDPEXTR_HDP1_EXT_Msk                 /*!< HDP area extension in 4Kbytes pages in bank 1 */
#define FLASH_SECHDPEXTR_HDP2_EXT_Pos             (16U)
#define FLASH_SECHDPEXTR_HDP2_EXT_Msk             (0x1FFUL << FLASH_SECHDPEXTR_HDP2_EXT_Pos)    /*!< 0x01FF0000 */
#define FLASH_SECHDPEXTR_HDP2_EXT                 FLASH_SECHDPEXTR_HDP2_EXT_Msk                 /*!< HDP area extension in 4Kbytes pages in bank 2 */

/*******************  Bit definition for FLASH_PRIVBB1R1 register  ******************/
#define FLASH_PRIVBB1R1_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB1R1_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R1_PRIV0                       FLASH_PRIVBB1R1_PRIV0_Msk                       /*!< Page 0 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB1R1_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R1_PRIV1                       FLASH_PRIVBB1R1_PRIV1_Msk                       /*!< Page 1 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB1R1_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R1_PRIV2                       FLASH_PRIVBB1R1_PRIV2_Msk                       /*!< Page 2 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB1R1_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R1_PRIV3                       FLASH_PRIVBB1R1_PRIV3_Msk                       /*!< Page 3 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB1R1_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R1_PRIV4                       FLASH_PRIVBB1R1_PRIV4_Msk                       /*!< Page 4 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB1R1_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R1_PRIV5                       FLASH_PRIVBB1R1_PRIV5_Msk                       /*!< Page 5 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB1R1_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R1_PRIV6                       FLASH_PRIVBB1R1_PRIV6_Msk                       /*!< Page 6 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB1R1_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R1_PRIV7                       FLASH_PRIVBB1R1_PRIV7_Msk                       /*!< Page 7 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB1R1_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R1_PRIV8                       FLASH_PRIVBB1R1_PRIV8_Msk                       /*!< Page 8 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB1R1_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB1R1_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R1_PRIV9                       FLASH_PRIVBB1R1_PRIV9_Msk                       /*!< Page 9 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB1R1_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R1_PRIV10                      FLASH_PRIVBB1R1_PRIV10_Msk                      /*!< Page 10 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB1R1_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R1_PRIV11                      FLASH_PRIVBB1R1_PRIV11_Msk                      /*!< Page 11 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB1R1_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R1_PRIV12                      FLASH_PRIVBB1R1_PRIV12_Msk                      /*!< Page 12 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB1R1_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R1_PRIV13                      FLASH_PRIVBB1R1_PRIV13_Msk                      /*!< Page 13 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB1R1_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R1_PRIV14                      FLASH_PRIVBB1R1_PRIV14_Msk                      /*!< Page 14 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB1R1_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R1_PRIV15                      FLASH_PRIVBB1R1_PRIV15_Msk                      /*!< Page 15 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB1R1_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R1_PRIV16                      FLASH_PRIVBB1R1_PRIV16_Msk                      /*!< Page 16 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB1R1_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R1_PRIV17                      FLASH_PRIVBB1R1_PRIV17_Msk                      /*!< Page 17 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB1R1_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R1_PRIV18                      FLASH_PRIVBB1R1_PRIV18_Msk                      /*!< Page 18 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB1R1_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R1_PRIV19                      FLASH_PRIVBB1R1_PRIV19_Msk                      /*!< Page 19 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB1R1_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R1_PRIV20                      FLASH_PRIVBB1R1_PRIV20_Msk                      /*!< Page 20 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB1R1_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R1_PRIV21                      FLASH_PRIVBB1R1_PRIV21_Msk                      /*!< Page 21 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB1R1_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R1_PRIV22                      FLASH_PRIVBB1R1_PRIV22_Msk                      /*!< Page 22 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB1R1_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R1_PRIV23                      FLASH_PRIVBB1R1_PRIV23_Msk                      /*!< Page 23 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB1R1_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R1_PRIV24                      FLASH_PRIVBB1R1_PRIV24_Msk                      /*!< Page 24 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB1R1_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R1_PRIV25                      FLASH_PRIVBB1R1_PRIV25_Msk                      /*!< Page 25 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB1R1_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R1_PRIV26                      FLASH_PRIVBB1R1_PRIV26_Msk                      /*!< Page 26 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB1R1_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R1_PRIV27                      FLASH_PRIVBB1R1_PRIV27_Msk                      /*!< Page 27 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB1R1_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R1_PRIV28                      FLASH_PRIVBB1R1_PRIV28_Msk                      /*!< Page 28 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB1R1_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R1_PRIV29                      FLASH_PRIVBB1R1_PRIV29_Msk                      /*!< Page 29 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB1R1_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R1_PRIV30                      FLASH_PRIVBB1R1_PRIV30_Msk                      /*!< Page 30 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R1_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB1R1_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB1R1_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R1_PRIV31                      FLASH_PRIVBB1R1_PRIV31_Msk                      /*!< Page 31 in bank 1 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB1R2 register  ******************/
#define FLASH_PRIVBB1R2_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB1R2_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R2_PRIV0                       FLASH_PRIVBB1R2_PRIV0_Msk                       /*!< Page 32 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB1R2_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R2_PRIV1                       FLASH_PRIVBB1R2_PRIV1_Msk                       /*!< Page 33 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB1R2_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R2_PRIV2                       FLASH_PRIVBB1R2_PRIV2_Msk                       /*!< Page 34 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB1R2_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R2_PRIV3                       FLASH_PRIVBB1R2_PRIV3_Msk                       /*!< Page 35 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB1R2_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R2_PRIV4                       FLASH_PRIVBB1R2_PRIV4_Msk                       /*!< Page 36 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB1R2_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R2_PRIV5                       FLASH_PRIVBB1R2_PRIV5_Msk                       /*!< Page 37 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB1R2_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R2_PRIV6                       FLASH_PRIVBB1R2_PRIV6_Msk                       /*!< Page 38 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB1R2_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R2_PRIV7                       FLASH_PRIVBB1R2_PRIV7_Msk                       /*!< Page 39 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB1R2_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R2_PRIV8                       FLASH_PRIVBB1R2_PRIV8_Msk                       /*!< Page 40 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB1R2_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB1R2_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R2_PRIV9                       FLASH_PRIVBB1R2_PRIV9_Msk                       /*!< Page 41 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB1R2_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R2_PRIV10                      FLASH_PRIVBB1R2_PRIV10_Msk                      /*!< Page 42 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB1R2_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R2_PRIV11                      FLASH_PRIVBB1R2_PRIV11_Msk                      /*!< Page 43 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB1R2_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R2_PRIV12                      FLASH_PRIVBB1R2_PRIV12_Msk                      /*!< Page 44 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB1R2_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R2_PRIV13                      FLASH_PRIVBB1R2_PRIV13_Msk                      /*!< Page 45 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB1R2_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R2_PRIV14                      FLASH_PRIVBB1R2_PRIV14_Msk                      /*!< Page 46 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB1R2_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R2_PRIV15                      FLASH_PRIVBB1R2_PRIV15_Msk                      /*!< Page 47 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB1R2_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R2_PRIV16                      FLASH_PRIVBB1R2_PRIV16_Msk                      /*!< Page 48 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB1R2_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R2_PRIV17                      FLASH_PRIVBB1R2_PRIV17_Msk                      /*!< Page 49 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB1R2_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R2_PRIV18                      FLASH_PRIVBB1R2_PRIV18_Msk                      /*!< Page 50 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB1R2_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R2_PRIV19                      FLASH_PRIVBB1R2_PRIV19_Msk                      /*!< Page 51 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB1R2_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R2_PRIV20                      FLASH_PRIVBB1R2_PRIV20_Msk                      /*!< Page 52 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB1R2_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R2_PRIV21                      FLASH_PRIVBB1R2_PRIV21_Msk                      /*!< Page 53 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB1R2_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R2_PRIV22                      FLASH_PRIVBB1R2_PRIV22_Msk                      /*!< Page 54 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB1R2_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R2_PRIV23                      FLASH_PRIVBB1R2_PRIV23_Msk                      /*!< Page 55 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB1R2_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R2_PRIV24                      FLASH_PRIVBB1R2_PRIV24_Msk                      /*!< Page 56 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB1R2_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R2_PRIV25                      FLASH_PRIVBB1R2_PRIV25_Msk                      /*!< Page 57 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB1R2_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R2_PRIV26                      FLASH_PRIVBB1R2_PRIV26_Msk                      /*!< Page 58 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB1R2_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R2_PRIV27                      FLASH_PRIVBB1R2_PRIV27_Msk                      /*!< Page 59 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB1R2_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R2_PRIV28                      FLASH_PRIVBB1R2_PRIV28_Msk                      /*!< Page 60 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB1R2_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R2_PRIV29                      FLASH_PRIVBB1R2_PRIV29_Msk                      /*!< Page 61 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB1R2_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R2_PRIV30                      FLASH_PRIVBB1R2_PRIV30_Msk                      /*!< Page 62 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R2_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB1R2_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB1R2_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R2_PRIV31                      FLASH_PRIVBB1R2_PRIV31_Msk                      /*!< Page 63 in bank 1 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB1R3 register  ******************/
#define FLASH_PRIVBB1R3_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB1R3_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R3_PRIV0                       FLASH_PRIVBB1R3_PRIV0_Msk                       /*!< Page 64 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB1R3_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R3_PRIV1                       FLASH_PRIVBB1R3_PRIV1_Msk                       /*!< Page 65 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB1R3_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R3_PRIV2                       FLASH_PRIVBB1R3_PRIV2_Msk                       /*!< Page 66 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB1R3_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R3_PRIV3                       FLASH_PRIVBB1R3_PRIV3_Msk                       /*!< Page 67 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB1R3_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R3_PRIV4                       FLASH_PRIVBB1R3_PRIV4_Msk                       /*!< Page 68 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB1R3_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R3_PRIV5                       FLASH_PRIVBB1R3_PRIV5_Msk                       /*!< Page 69 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB1R3_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R3_PRIV6                       FLASH_PRIVBB1R3_PRIV6_Msk                       /*!< Page 70 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB1R3_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R3_PRIV7                       FLASH_PRIVBB1R3_PRIV7_Msk                       /*!< Page 71 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB1R3_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R3_PRIV8                       FLASH_PRIVBB1R3_PRIV8_Msk                       /*!< Page 72 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB1R3_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB1R3_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R3_PRIV9                       FLASH_PRIVBB1R3_PRIV9_Msk                       /*!< Page 73 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB1R3_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R3_PRIV10                      FLASH_PRIVBB1R3_PRIV10_Msk                      /*!< Page 74 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB1R3_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R3_PRIV11                      FLASH_PRIVBB1R3_PRIV11_Msk                      /*!< Page 75 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB1R3_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R3_PRIV12                      FLASH_PRIVBB1R3_PRIV12_Msk                      /*!< Page 76 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB1R3_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R3_PRIV13                      FLASH_PRIVBB1R3_PRIV13_Msk                      /*!< Page 77 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB1R3_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R3_PRIV14                      FLASH_PRIVBB1R3_PRIV14_Msk                      /*!< Page 78 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB1R3_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R3_PRIV15                      FLASH_PRIVBB1R3_PRIV15_Msk                      /*!< Page 79 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB1R3_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R3_PRIV16                      FLASH_PRIVBB1R3_PRIV16_Msk                      /*!< Page 80 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB1R3_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R3_PRIV17                      FLASH_PRIVBB1R3_PRIV17_Msk                      /*!< Page 81 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB1R3_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R3_PRIV18                      FLASH_PRIVBB1R3_PRIV18_Msk                      /*!< Page 82 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB1R3_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R3_PRIV19                      FLASH_PRIVBB1R3_PRIV19_Msk                      /*!< Page 83 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB1R3_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R3_PRIV20                      FLASH_PRIVBB1R3_PRIV20_Msk                      /*!< Page 84 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB1R3_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R3_PRIV21                      FLASH_PRIVBB1R3_PRIV21_Msk                      /*!< Page 85 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB1R3_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R3_PRIV22                      FLASH_PRIVBB1R3_PRIV22_Msk                      /*!< Page 86 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB1R3_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R3_PRIV23                      FLASH_PRIVBB1R3_PRIV23_Msk                      /*!< Page 87 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB1R3_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R3_PRIV24                      FLASH_PRIVBB1R3_PRIV24_Msk                      /*!< Page 88 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB1R3_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R3_PRIV25                      FLASH_PRIVBB1R3_PRIV25_Msk                      /*!< Page 89 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB1R3_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R3_PRIV26                      FLASH_PRIVBB1R3_PRIV26_Msk                      /*!< Page 90 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB1R3_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R3_PRIV27                      FLASH_PRIVBB1R3_PRIV27_Msk                      /*!< Page 91 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB1R3_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R3_PRIV28                      FLASH_PRIVBB1R3_PRIV28_Msk                      /*!< Page 92 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB1R3_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R3_PRIV29                      FLASH_PRIVBB1R3_PRIV29_Msk                      /*!< Page 93 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB1R3_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R3_PRIV30                      FLASH_PRIVBB1R3_PRIV30_Msk                      /*!< Page 94 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R3_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB1R3_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB1R3_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R3_PRIV31                      FLASH_PRIVBB1R3_PRIV31_Msk                      /*!< Page 95 in bank 1 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB1R4 register  ******************/
#define FLASH_PRIVBB1R4_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB1R4_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB1R4_PRIV0                       FLASH_PRIVBB1R4_PRIV0_Msk                       /*!< Page 96 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB1R4_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB1R4_PRIV1                       FLASH_PRIVBB1R4_PRIV1_Msk                       /*!< Page 97 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB1R4_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB1R4_PRIV2                       FLASH_PRIVBB1R4_PRIV2_Msk                       /*!< Page 98 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB1R4_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB1R4_PRIV3                       FLASH_PRIVBB1R4_PRIV3_Msk                       /*!< Page 99 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB1R4_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB1R4_PRIV4                       FLASH_PRIVBB1R4_PRIV4_Msk                       /*!< Page 100 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB1R4_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB1R4_PRIV5                       FLASH_PRIVBB1R4_PRIV5_Msk                       /*!< Page 101 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB1R4_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB1R4_PRIV6                       FLASH_PRIVBB1R4_PRIV6_Msk                       /*!< Page 102 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB1R4_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB1R4_PRIV7                       FLASH_PRIVBB1R4_PRIV7_Msk                       /*!< Page 103 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB1R4_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB1R4_PRIV8                       FLASH_PRIVBB1R4_PRIV8_Msk                       /*!< Page 104 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB1R4_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB1R4_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB1R4_PRIV9                       FLASH_PRIVBB1R4_PRIV9_Msk                       /*!< Page 105 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB1R4_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB1R4_PRIV10                      FLASH_PRIVBB1R4_PRIV10_Msk                      /*!< Page 106 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB1R4_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB1R4_PRIV11                      FLASH_PRIVBB1R4_PRIV11_Msk                      /*!< Page 107 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB1R4_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB1R4_PRIV12                      FLASH_PRIVBB1R4_PRIV12_Msk                      /*!< Page 108 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB1R4_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB1R4_PRIV13                      FLASH_PRIVBB1R4_PRIV13_Msk                      /*!< Page 109 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB1R4_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB1R4_PRIV14                      FLASH_PRIVBB1R4_PRIV14_Msk                      /*!< Page 110 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB1R4_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB1R4_PRIV15                      FLASH_PRIVBB1R4_PRIV15_Msk                      /*!< Page 111 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB1R4_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB1R4_PRIV16                      FLASH_PRIVBB1R4_PRIV16_Msk                      /*!< Page 112 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB1R4_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB1R4_PRIV17                      FLASH_PRIVBB1R4_PRIV17_Msk                      /*!< Page 113 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB1R4_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB1R4_PRIV18                      FLASH_PRIVBB1R4_PRIV18_Msk                      /*!< Page 114 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB1R4_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB1R4_PRIV19                      FLASH_PRIVBB1R4_PRIV19_Msk                      /*!< Page 115 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB1R4_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB1R4_PRIV20                      FLASH_PRIVBB1R4_PRIV20_Msk                      /*!< Page 116 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB1R4_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB1R4_PRIV21                      FLASH_PRIVBB1R4_PRIV21_Msk                      /*!< Page 117 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB1R4_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB1R4_PRIV22                      FLASH_PRIVBB1R4_PRIV22_Msk                      /*!< Page 118 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB1R4_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB1R4_PRIV23                      FLASH_PRIVBB1R4_PRIV23_Msk                      /*!< Page 119 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB1R4_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB1R4_PRIV24                      FLASH_PRIVBB1R4_PRIV24_Msk                      /*!< Page 120 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB1R4_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB1R4_PRIV25                      FLASH_PRIVBB1R4_PRIV25_Msk                      /*!< Page 121 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB1R4_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB1R4_PRIV26                      FLASH_PRIVBB1R4_PRIV26_Msk                      /*!< Page 122 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB1R4_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB1R4_PRIV27                      FLASH_PRIVBB1R4_PRIV27_Msk                      /*!< Page 123 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB1R4_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB1R4_PRIV28                      FLASH_PRIVBB1R4_PRIV28_Msk                      /*!< Page 124 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB1R4_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB1R4_PRIV29                      FLASH_PRIVBB1R4_PRIV29_Msk                      /*!< Page 125 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB1R4_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB1R4_PRIV30                      FLASH_PRIVBB1R4_PRIV30_Msk                      /*!< Page 126 in bank 1 block-based privilege */
#define FLASH_PRIVBB1R4_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB1R4_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB1R4_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB1R4_PRIV31                      FLASH_PRIVBB1R4_PRIV31_Msk                      /*!< Page 127 in bank 1 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB2R1 register  ******************/
#define FLASH_PRIVBB2R1_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB2R1_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R1_PRIV0                       FLASH_PRIVBB2R1_PRIV0_Msk                       /*!< Page 0 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB2R1_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R1_PRIV1                       FLASH_PRIVBB2R1_PRIV1_Msk                       /*!< Page 1 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB2R1_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R1_PRIV2                       FLASH_PRIVBB2R1_PRIV2_Msk                       /*!< Page 2 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB2R1_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R1_PRIV3                       FLASH_PRIVBB2R1_PRIV3_Msk                       /*!< Page 3 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB2R1_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R1_PRIV4                       FLASH_PRIVBB2R1_PRIV4_Msk                       /*!< Page 4 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB2R1_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R1_PRIV5                       FLASH_PRIVBB2R1_PRIV5_Msk                       /*!< Page 5 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB2R1_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R1_PRIV6                       FLASH_PRIVBB2R1_PRIV6_Msk                       /*!< Page 6 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB2R1_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R1_PRIV7                       FLASH_PRIVBB2R1_PRIV7_Msk                       /*!< Page 7 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB2R1_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R1_PRIV8                       FLASH_PRIVBB2R1_PRIV8_Msk                       /*!< Page 8 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB2R1_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB2R1_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R1_PRIV9                       FLASH_PRIVBB2R1_PRIV9_Msk                       /*!< Page 9 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB2R1_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R1_PRIV10                      FLASH_PRIVBB2R1_PRIV10_Msk                      /*!< Page 10 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB2R1_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R1_PRIV11                      FLASH_PRIVBB2R1_PRIV11_Msk                      /*!< Page 11 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB2R1_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R1_PRIV12                      FLASH_PRIVBB2R1_PRIV12_Msk                      /*!< Page 12 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB2R1_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R1_PRIV13                      FLASH_PRIVBB2R1_PRIV13_Msk                      /*!< Page 13 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB2R1_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R1_PRIV14                      FLASH_PRIVBB2R1_PRIV14_Msk                      /*!< Page 14 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB2R1_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R1_PRIV15                      FLASH_PRIVBB2R1_PRIV15_Msk                      /*!< Page 15 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB2R1_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R1_PRIV16                      FLASH_PRIVBB2R1_PRIV16_Msk                      /*!< Page 16 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB2R1_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R1_PRIV17                      FLASH_PRIVBB2R1_PRIV17_Msk                      /*!< Page 17 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB2R1_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R1_PRIV18                      FLASH_PRIVBB2R1_PRIV18_Msk                      /*!< Page 18 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB2R1_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R1_PRIV19                      FLASH_PRIVBB2R1_PRIV19_Msk                      /*!< Page 19 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB2R1_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R1_PRIV20                      FLASH_PRIVBB2R1_PRIV20_Msk                      /*!< Page 20 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB2R1_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R1_PRIV21                      FLASH_PRIVBB2R1_PRIV21_Msk                      /*!< Page 21 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB2R1_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R1_PRIV22                      FLASH_PRIVBB2R1_PRIV22_Msk                      /*!< Page 22 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB2R1_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R1_PRIV23                      FLASH_PRIVBB2R1_PRIV23_Msk                      /*!< Page 23 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB2R1_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R1_PRIV24                      FLASH_PRIVBB2R1_PRIV24_Msk                      /*!< Page 24 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB2R1_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R1_PRIV25                      FLASH_PRIVBB2R1_PRIV25_Msk                      /*!< Page 25 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB2R1_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R1_PRIV26                      FLASH_PRIVBB2R1_PRIV26_Msk                      /*!< Page 26 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB2R1_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R1_PRIV27                      FLASH_PRIVBB2R1_PRIV27_Msk                      /*!< Page 27 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB2R1_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R1_PRIV28                      FLASH_PRIVBB2R1_PRIV28_Msk                      /*!< Page 28 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB2R1_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R1_PRIV29                      FLASH_PRIVBB2R1_PRIV29_Msk                      /*!< Page 29 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB2R1_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R1_PRIV30                      FLASH_PRIVBB2R1_PRIV30_Msk                      /*!< Page 30 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R1_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB2R1_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB2R1_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R1_PRIV31                      FLASH_PRIVBB2R1_PRIV31_Msk                      /*!< Page 31 in bank 2 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB2R2 register  ******************/
#define FLASH_PRIVBB2R2_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB2R2_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R2_PRIV0                       FLASH_PRIVBB2R2_PRIV0_Msk                       /*!< Page 32 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB2R2_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R2_PRIV1                       FLASH_PRIVBB2R2_PRIV1_Msk                       /*!< Page 33 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB2R2_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R2_PRIV2                       FLASH_PRIVBB2R2_PRIV2_Msk                       /*!< Page 34 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB2R2_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R2_PRIV3                       FLASH_PRIVBB2R2_PRIV3_Msk                       /*!< Page 35 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB2R2_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R2_PRIV4                       FLASH_PRIVBB2R2_PRIV4_Msk                       /*!< Page 36 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB2R2_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R2_PRIV5                       FLASH_PRIVBB2R2_PRIV5_Msk                       /*!< Page 37 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB2R2_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R2_PRIV6                       FLASH_PRIVBB2R2_PRIV6_Msk                       /*!< Page 38 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB2R2_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R2_PRIV7                       FLASH_PRIVBB2R2_PRIV7_Msk                       /*!< Page 39 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB2R2_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R2_PRIV8                       FLASH_PRIVBB2R2_PRIV8_Msk                       /*!< Page 40 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB2R2_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB2R2_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R2_PRIV9                       FLASH_PRIVBB2R2_PRIV9_Msk                       /*!< Page 41 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB2R2_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R2_PRIV10                      FLASH_PRIVBB2R2_PRIV10_Msk                      /*!< Page 42 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB2R2_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R2_PRIV11                      FLASH_PRIVBB2R2_PRIV11_Msk                      /*!< Page 43 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB2R2_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R2_PRIV12                      FLASH_PRIVBB2R2_PRIV12_Msk                      /*!< Page 44 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB2R2_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R2_PRIV13                      FLASH_PRIVBB2R2_PRIV13_Msk                      /*!< Page 45 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB2R2_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R2_PRIV14                      FLASH_PRIVBB2R2_PRIV14_Msk                      /*!< Page 46 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB2R2_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R2_PRIV15                      FLASH_PRIVBB2R2_PRIV15_Msk                      /*!< Page 47 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB2R2_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R2_PRIV16                      FLASH_PRIVBB2R2_PRIV16_Msk                      /*!< Page 48 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB2R2_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R2_PRIV17                      FLASH_PRIVBB2R2_PRIV17_Msk                      /*!< Page 49 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB2R2_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R2_PRIV18                      FLASH_PRIVBB2R2_PRIV18_Msk                      /*!< Page 50 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB2R2_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R2_PRIV19                      FLASH_PRIVBB2R2_PRIV19_Msk                      /*!< Page 51 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB2R2_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R2_PRIV20                      FLASH_PRIVBB2R2_PRIV20_Msk                      /*!< Page 52 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB2R2_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R2_PRIV21                      FLASH_PRIVBB2R2_PRIV21_Msk                      /*!< Page 53 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB2R2_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R2_PRIV22                      FLASH_PRIVBB2R2_PRIV22_Msk                      /*!< Page 54 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB2R2_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R2_PRIV23                      FLASH_PRIVBB2R2_PRIV23_Msk                      /*!< Page 55 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB2R2_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R2_PRIV24                      FLASH_PRIVBB2R2_PRIV24_Msk                      /*!< Page 56 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB2R2_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R2_PRIV25                      FLASH_PRIVBB2R2_PRIV25_Msk                      /*!< Page 57 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB2R2_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R2_PRIV26                      FLASH_PRIVBB2R2_PRIV26_Msk                      /*!< Page 58 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB2R2_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R2_PRIV27                      FLASH_PRIVBB2R2_PRIV27_Msk                      /*!< Page 59 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB2R2_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R2_PRIV28                      FLASH_PRIVBB2R2_PRIV28_Msk                      /*!< Page 60 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB2R2_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R2_PRIV29                      FLASH_PRIVBB2R2_PRIV29_Msk                      /*!< Page 61 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB2R2_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R2_PRIV30                      FLASH_PRIVBB2R2_PRIV30_Msk                      /*!< Page 62 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R2_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB2R2_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB2R2_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R2_PRIV31                      FLASH_PRIVBB2R2_PRIV31_Msk                      /*!< Page 63 in bank 2 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB2R3 register  ******************/
#define FLASH_PRIVBB2R3_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB2R3_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R3_PRIV0                       FLASH_PRIVBB2R3_PRIV0_Msk                       /*!< Page 64 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB2R3_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R3_PRIV1                       FLASH_PRIVBB2R3_PRIV1_Msk                       /*!< Page 65 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB2R3_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R3_PRIV2                       FLASH_PRIVBB2R3_PRIV2_Msk                       /*!< Page 66 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB2R3_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R3_PRIV3                       FLASH_PRIVBB2R3_PRIV3_Msk                       /*!< Page 67 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB2R3_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R3_PRIV4                       FLASH_PRIVBB2R3_PRIV4_Msk                       /*!< Page 68 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB2R3_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R3_PRIV5                       FLASH_PRIVBB2R3_PRIV5_Msk                       /*!< Page 69 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB2R3_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R3_PRIV6                       FLASH_PRIVBB2R3_PRIV6_Msk                       /*!< Page 70 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB2R3_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R3_PRIV7                       FLASH_PRIVBB2R3_PRIV7_Msk                       /*!< Page 71 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB2R3_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R3_PRIV8                       FLASH_PRIVBB2R3_PRIV8_Msk                       /*!< Page 72 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB2R3_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB2R3_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R3_PRIV9                       FLASH_PRIVBB2R3_PRIV9_Msk                       /*!< Page 73 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB2R3_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R3_PRIV10                      FLASH_PRIVBB2R3_PRIV10_Msk                      /*!< Page 74 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB2R3_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R3_PRIV11                      FLASH_PRIVBB2R3_PRIV11_Msk                      /*!< Page 75 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB2R3_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R3_PRIV12                      FLASH_PRIVBB2R3_PRIV12_Msk                      /*!< Page 76 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB2R3_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R3_PRIV13                      FLASH_PRIVBB2R3_PRIV13_Msk                      /*!< Page 77 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB2R3_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R3_PRIV14                      FLASH_PRIVBB2R3_PRIV14_Msk                      /*!< Page 78 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB2R3_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R3_PRIV15                      FLASH_PRIVBB2R3_PRIV15_Msk                      /*!< Page 79 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB2R3_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R3_PRIV16                      FLASH_PRIVBB2R3_PRIV16_Msk                      /*!< Page 80 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB2R3_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R3_PRIV17                      FLASH_PRIVBB2R3_PRIV17_Msk                      /*!< Page 81 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB2R3_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R3_PRIV18                      FLASH_PRIVBB2R3_PRIV18_Msk                      /*!< Page 82 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB2R3_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R3_PRIV19                      FLASH_PRIVBB2R3_PRIV19_Msk                      /*!< Page 83 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB2R3_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R3_PRIV20                      FLASH_PRIVBB2R3_PRIV20_Msk                      /*!< Page 84 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB2R3_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R3_PRIV21                      FLASH_PRIVBB2R3_PRIV21_Msk                      /*!< Page 85 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB2R3_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R3_PRIV22                      FLASH_PRIVBB2R3_PRIV22_Msk                      /*!< Page 86 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB2R3_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R3_PRIV23                      FLASH_PRIVBB2R3_PRIV23_Msk                      /*!< Page 87 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB2R3_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R3_PRIV24                      FLASH_PRIVBB2R3_PRIV24_Msk                      /*!< Page 88 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB2R3_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R3_PRIV25                      FLASH_PRIVBB2R3_PRIV25_Msk                      /*!< Page 89 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB2R3_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R3_PRIV26                      FLASH_PRIVBB2R3_PRIV26_Msk                      /*!< Page 90 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB2R3_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R3_PRIV27                      FLASH_PRIVBB2R3_PRIV27_Msk                      /*!< Page 91 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB2R3_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R3_PRIV28                      FLASH_PRIVBB2R3_PRIV28_Msk                      /*!< Page 92 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB2R3_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R3_PRIV29                      FLASH_PRIVBB2R3_PRIV29_Msk                      /*!< Page 93 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB2R3_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R3_PRIV30                      FLASH_PRIVBB2R3_PRIV30_Msk                      /*!< Page 94 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R3_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB2R3_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB2R3_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R3_PRIV31                      FLASH_PRIVBB2R3_PRIV31_Msk                      /*!< Page 95 in bank 2 block-based privilege */

/*******************  Bit definition for FLASH_PRIVBB2R4 register  ******************/
#define FLASH_PRIVBB2R4_PRIV0_Pos                   (0U)
#define FLASH_PRIVBB2R4_PRIV0_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV0_Pos)            /*!< 0x00000001 */
#define FLASH_PRIVBB2R4_PRIV0                       FLASH_PRIVBB2R4_PRIV0_Msk                       /*!< Page 96 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV1_Pos                   (1U)
#define FLASH_PRIVBB2R4_PRIV1_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV1_Pos)            /*!< 0x00000002 */
#define FLASH_PRIVBB2R4_PRIV1                       FLASH_PRIVBB2R4_PRIV1_Msk                       /*!< Page 97 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV2_Pos                   (2U)
#define FLASH_PRIVBB2R4_PRIV2_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV2_Pos)            /*!< 0x00000004 */
#define FLASH_PRIVBB2R4_PRIV2                       FLASH_PRIVBB2R4_PRIV2_Msk                       /*!< Page 98 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV3_Pos                   (3U)
#define FLASH_PRIVBB2R4_PRIV3_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV3_Pos)            /*!< 0x00000008 */
#define FLASH_PRIVBB2R4_PRIV3                       FLASH_PRIVBB2R4_PRIV3_Msk                       /*!< Page 99 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV4_Pos                   (4U)
#define FLASH_PRIVBB2R4_PRIV4_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV4_Pos)            /*!< 0x00000010 */
#define FLASH_PRIVBB2R4_PRIV4                       FLASH_PRIVBB2R4_PRIV4_Msk                       /*!< Page 100 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV5_Pos                   (5U)
#define FLASH_PRIVBB2R4_PRIV5_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV5_Pos)            /*!< 0x00000020 */
#define FLASH_PRIVBB2R4_PRIV5                       FLASH_PRIVBB2R4_PRIV5_Msk                       /*!< Page 101 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV6_Pos                   (6U)
#define FLASH_PRIVBB2R4_PRIV6_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV6_Pos)            /*!< 0x00000040 */
#define FLASH_PRIVBB2R4_PRIV6                       FLASH_PRIVBB2R4_PRIV6_Msk                       /*!< Page 102 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV7_Pos                   (7U)
#define FLASH_PRIVBB2R4_PRIV7_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV7_Pos)            /*!< 0x00000080 */
#define FLASH_PRIVBB2R4_PRIV7                       FLASH_PRIVBB2R4_PRIV7_Msk                       /*!< Page 103 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV8_Pos                   (8U)
#define FLASH_PRIVBB2R4_PRIV8_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV8_Pos)            /*!< 0x00000100 */
#define FLASH_PRIVBB2R4_PRIV8                       FLASH_PRIVBB2R4_PRIV8_Msk                       /*!< Page 104 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV9_Pos                   (9U)
#define FLASH_PRIVBB2R4_PRIV9_Msk                   (0x1UL << FLASH_PRIVBB2R4_PRIV9_Pos)            /*!< 0x00000200 */
#define FLASH_PRIVBB2R4_PRIV9                       FLASH_PRIVBB2R4_PRIV9_Msk                       /*!< Page 105 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV10_Pos                  (10U)
#define FLASH_PRIVBB2R4_PRIV10_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV10_Pos)           /*!< 0x00000400 */
#define FLASH_PRIVBB2R4_PRIV10                      FLASH_PRIVBB2R4_PRIV10_Msk                      /*!< Page 106 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV11_Pos                  (11U)
#define FLASH_PRIVBB2R4_PRIV11_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV11_Pos)           /*!< 0x00000800 */
#define FLASH_PRIVBB2R4_PRIV11                      FLASH_PRIVBB2R4_PRIV11_Msk                      /*!< Page 107 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV12_Pos                  (12U)
#define FLASH_PRIVBB2R4_PRIV12_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV12_Pos)           /*!< 0x00001000 */
#define FLASH_PRIVBB2R4_PRIV12                      FLASH_PRIVBB2R4_PRIV12_Msk                      /*!< Page 108 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV13_Pos                  (13U)
#define FLASH_PRIVBB2R4_PRIV13_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV13_Pos)           /*!< 0x00002000 */
#define FLASH_PRIVBB2R4_PRIV13                      FLASH_PRIVBB2R4_PRIV13_Msk                      /*!< Page 109 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV14_Pos                  (14U)
#define FLASH_PRIVBB2R4_PRIV14_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV14_Pos)           /*!< 0x00004000 */
#define FLASH_PRIVBB2R4_PRIV14                      FLASH_PRIVBB2R4_PRIV14_Msk                      /*!< Page 110 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV15_Pos                  (15U)
#define FLASH_PRIVBB2R4_PRIV15_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV15_Pos)           /*!< 0x00008000 */
#define FLASH_PRIVBB2R4_PRIV15                      FLASH_PRIVBB2R4_PRIV15_Msk                      /*!< Page 111 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV16_Pos                  (16U)
#define FLASH_PRIVBB2R4_PRIV16_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV16_Pos)           /*!< 0x00010000 */
#define FLASH_PRIVBB2R4_PRIV16                      FLASH_PRIVBB2R4_PRIV16_Msk                      /*!< Page 112 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV17_Pos                  (17U)
#define FLASH_PRIVBB2R4_PRIV17_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV17_Pos)           /*!< 0x00020000 */
#define FLASH_PRIVBB2R4_PRIV17                      FLASH_PRIVBB2R4_PRIV17_Msk                      /*!< Page 113 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV18_Pos                  (18U)
#define FLASH_PRIVBB2R4_PRIV18_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV18_Pos)           /*!< 0x00040000 */
#define FLASH_PRIVBB2R4_PRIV18                      FLASH_PRIVBB2R4_PRIV18_Msk                      /*!< Page 114 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV19_Pos                  (19U)
#define FLASH_PRIVBB2R4_PRIV19_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV19_Pos)           /*!< 0x00080000 */
#define FLASH_PRIVBB2R4_PRIV19                      FLASH_PRIVBB2R4_PRIV19_Msk                      /*!< Page 115 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV20_Pos                  (20U)
#define FLASH_PRIVBB2R4_PRIV20_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV20_Pos)           /*!< 0x00100000 */
#define FLASH_PRIVBB2R4_PRIV20                      FLASH_PRIVBB2R4_PRIV20_Msk                      /*!< Page 116 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV21_Pos                  (21U)
#define FLASH_PRIVBB2R4_PRIV21_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV21_Pos)           /*!< 0x00200000 */
#define FLASH_PRIVBB2R4_PRIV21                      FLASH_PRIVBB2R4_PRIV21_Msk                      /*!< Page 117 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV22_Pos                  (22U)
#define FLASH_PRIVBB2R4_PRIV22_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV22_Pos)           /*!< 0x00400000 */
#define FLASH_PRIVBB2R4_PRIV22                      FLASH_PRIVBB2R4_PRIV22_Msk                      /*!< Page 118 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV23_Pos                  (23U)
#define FLASH_PRIVBB2R4_PRIV23_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV23_Pos)           /*!< 0x00800000 */
#define FLASH_PRIVBB2R4_PRIV23                      FLASH_PRIVBB2R4_PRIV23_Msk                      /*!< Page 119 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV24_Pos                  (24U)
#define FLASH_PRIVBB2R4_PRIV24_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV24_Pos)           /*!< 0x01000000 */
#define FLASH_PRIVBB2R4_PRIV24                      FLASH_PRIVBB2R4_PRIV24_Msk                      /*!< Page 120 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV25_Pos                  (25U)
#define FLASH_PRIVBB2R4_PRIV25_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV25_Pos)           /*!< 0x02000000 */
#define FLASH_PRIVBB2R4_PRIV25                      FLASH_PRIVBB2R4_PRIV25_Msk                      /*!< Page 121 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV26_Pos                  (26U)
#define FLASH_PRIVBB2R4_PRIV26_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV26_Pos)           /*!< 0x04000000 */
#define FLASH_PRIVBB2R4_PRIV26                      FLASH_PRIVBB2R4_PRIV26_Msk                      /*!< Page 122 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV27_Pos                  (27U)
#define FLASH_PRIVBB2R4_PRIV27_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV27_Pos)           /*!< 0x08000000 */
#define FLASH_PRIVBB2R4_PRIV27                      FLASH_PRIVBB2R4_PRIV27_Msk                      /*!< Page 123 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV28_Pos                  (28U)
#define FLASH_PRIVBB2R4_PRIV28_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV28_Pos)           /*!< 0x10000000 */
#define FLASH_PRIVBB2R4_PRIV28                      FLASH_PRIVBB2R4_PRIV28_Msk                      /*!< Page 124 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV29_Pos                  (29U)
#define FLASH_PRIVBB2R4_PRIV29_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV29_Pos)           /*!< 0x20000000 */
#define FLASH_PRIVBB2R4_PRIV29                      FLASH_PRIVBB2R4_PRIV29_Msk                      /*!< Page 125 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV30_Pos                  (30U)
#define FLASH_PRIVBB2R4_PRIV30_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV30_Pos)           /*!< 0x40000000 */
#define FLASH_PRIVBB2R4_PRIV30                      FLASH_PRIVBB2R4_PRIV30_Msk                      /*!< Page 126 in bank 2 block-based privilege */
#define FLASH_PRIVBB2R4_PRIV31_Pos                  (31U)
#define FLASH_PRIVBB2R4_PRIV31_Msk                  (0x1UL << FLASH_PRIVBB2R4_PRIV31_Pos)           /*!< 0x80000000 */
#define FLASH_PRIVBB2R4_PRIV31                      FLASH_PRIVBB2R4_PRIV31_Msk                      /*!< Page 127 in bank 2 block-based privilege */

/******************  Bits definition for FLASH_OEM1KEYR1 register  *****************/
#define FLASH_OEM1KEYR1_OEM1KEY_Pos         (0U)
#define FLASH_OEM1KEYR1_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR1_OEM1KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR1_OEM1KEY             FLASH_OEM1KEYR1_OEM1KEY_Msk                   /*!< OEM1 [31:0] bytes key */

/******************  Bits definition for FLASH_OEM1KEYR2 register  *****************/
#define FLASH_OEM1KEYR2_OEM1KEY_Pos         (0U)
#define FLASH_OEM1KEYR2_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR2_OEM1KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR2_OEM1KEY             FLASH_OEM1KEYR2_OEM1KEY_Msk                   /*!< OEM1 [63:32] bytes key */

/******************  Bits definition for FLASH_OEM1KEYR3 register  *****************/
#define FLASH_OEM1KEYR3_OEM1KEY_Pos         (0U)
#define FLASH_OEM1KEYR3_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR3_OEM1KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR3_OEM1KEY             FLASH_OEM1KEYR3_OEM1KEY_Msk                   /*!< OEM1 [95:64] bytes key */

/******************  Bits definition for FLASH_OEM1KEYR4 register  *****************/
#define FLASH_OEM1KEYR4_OEM1KEY_Pos         (0U)
#define FLASH_OEM1KEYR4_OEM1KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM1KEYR4_OEM1KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM1KEYR4_OEM1KEY             FLASH_OEM1KEYR4_OEM1KEY_Msk                   /*!< OEM1 [127:96] bytes key */

/******************  Bits definition for FLASH_OEM2KEYR1 register  *****************/
#define FLASH_OEM2KEYR1_OEM2KEY_Pos         (0U)
#define FLASH_OEM2KEYR1_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR1_OEM2KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR1_OEM2KEY             FLASH_OEM2KEYR1_OEM2KEY_Msk                   /*!< OEM2 [31:0] bytes key */

/******************  Bits definition for FLASH_OEM2KEYR2 register  *****************/
#define FLASH_OEM2KEYR2_OEM2KEY_Pos         (0U)
#define FLASH_OEM2KEYR2_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR2_OEM2KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR2_OEM2KEY             FLASH_OEM2KEYR2_OEM2KEY_Msk                   /*!< OEM2 [63:32] bytes key */

/******************  Bits definition for FLASH_OEM2KEYR3 register  *****************/
#define FLASH_OEM2KEYR3_OEM2KEY_Pos         (0U)
#define FLASH_OEM2KEYR3_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR3_OEM2KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR3_OEM2KEY             FLASH_OEM2KEYR3_OEM2KEY_Msk                   /*!< OEM2 [95:64] bytes key */

/******************  Bits definition for FLASH_OEM2KEYR4 register  *****************/
#define FLASH_OEM2KEYR4_OEM2KEY_Pos         (0U)
#define FLASH_OEM2KEYR4_OEM2KEY_Msk         (0xFFFFFFFFUL << FLASH_OEM2KEYR4_OEM2KEY_Pos) /*!< 0xFFFFFFFFF */
#define FLASH_OEM2KEYR4_OEM2KEY             FLASH_OEM2KEYR4_OEM2KEY_Msk                   /*!< OEM2 [127:96] bytes key */

/*******************  Bits definition for FLASH_OEMKEYSR register  *****************/
#define FLASH_OEMKEYSR_OEM1KEYCRC_Pos       (0U)
#define FLASH_OEMKEYSR_OEM1KEYCRC_Msk       (0xFFUL << FLASH_OEMKEYSR_OEM1KEYCRC_Pos)  /*!< 0x000000FF */
#define FLASH_OEMKEYSR_OEM1KEYCRC           FLASH_OEMKEYSR_OEM1KEYCRC_Msk              /*!< 8-bits OEMKEY1 CRC */
#define FLASH_OEMKEYSR_OEM2KEYCRC_Pos       (16U)
#define FLASH_OEMKEYSR_OEM2KEYCRC_Msk       (0xFFUL << FLASH_OEMKEYSR_OEM2KEYCRC_Pos)  /*!< 0x00FF0000 */
#define FLASH_OEMKEYSR_OEM2KEYCRC           FLASH_OEMKEYSR_OEM2KEYCRC_Msk              /*!< 8-bits OEMKEY2 CRC */

/******************************************************************************/
/*                                                                            */
/*                       General Purpose IOs (GPIO)                           */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos                (0U)
#define GPIO_MODER_MODE0_Msk                (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0                    GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0                  (0x1UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1                  (0x2UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000002 */
#define GPIO_MODER_MODE1_Pos                (2U)
#define GPIO_MODER_MODE1_Msk                (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1                    GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0                  (0x1UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1                  (0x2UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000008 */
#define GPIO_MODER_MODE2_Pos                (4U)
#define GPIO_MODER_MODE2_Msk                (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2                    GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0                  (0x1UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1                  (0x2UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000020 */
#define GPIO_MODER_MODE3_Pos                (6U)
#define GPIO_MODER_MODE3_Msk                (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3                    GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0                  (0x1UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1                  (0x2UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000080 */
#define GPIO_MODER_MODE4_Pos                (8U)
#define GPIO_MODER_MODE4_Msk                (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4                    GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0                  (0x1UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1                  (0x2UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000200 */
#define GPIO_MODER_MODE5_Pos                (10U)
#define GPIO_MODER_MODE5_Msk                (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5                    GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0                  (0x1UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1                  (0x2UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000800 */
#define GPIO_MODER_MODE6_Pos                (12U)
#define GPIO_MODER_MODE6_Msk                (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6                    GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0                  (0x1UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1                  (0x2UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00002000 */
#define GPIO_MODER_MODE7_Pos                (14U)
#define GPIO_MODER_MODE7_Msk                (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7                    GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0                  (0x1UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1                  (0x2UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00008000 */
#define GPIO_MODER_MODE8_Pos                (16U)
#define GPIO_MODER_MODE8_Msk                (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8                    GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0                  (0x1UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1                  (0x2UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00020000 */
#define GPIO_MODER_MODE9_Pos                (18U)
#define GPIO_MODER_MODE9_Msk                (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9                    GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0                  (0x1UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1                  (0x2UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00080000 */
#define GPIO_MODER_MODE10_Pos               (20U)
#define GPIO_MODER_MODE10_Msk               (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10                   GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0                 (0x1UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1                 (0x2UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00200000 */
#define GPIO_MODER_MODE11_Pos               (22U)
#define GPIO_MODER_MODE11_Msk               (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11                   GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0                 (0x1UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1                 (0x2UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00800000 */
#define GPIO_MODER_MODE12_Pos               (24U)
#define GPIO_MODER_MODE12_Msk               (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12                   GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0                 (0x1UL << GPIO_MODER_MODE12_Pos)        /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1                 (0x2UL << GPIO_MODER_MODE12_Pos)        /*!< 0x02000000 */
#define GPIO_MODER_MODE13_Pos               (26U)
#define GPIO_MODER_MODE13_Msk               (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13                   GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0                 (0x1UL << GPIO_MODER_MODE13_Pos)        /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1                 (0x2UL << GPIO_MODER_MODE13_Pos)        /*!< 0x08000000 */
#define GPIO_MODER_MODE14_Pos               (28U)
#define GPIO_MODER_MODE14_Msk               (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14                   GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0                 (0x1UL << GPIO_MODER_MODE14_Pos)        /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1                 (0x2UL << GPIO_MODER_MODE14_Pos)        /*!< 0x20000000 */
#define GPIO_MODER_MODE15_Pos               (30U)
#define GPIO_MODER_MODE15_Msk               (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15                   GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0                 (0x1UL << GPIO_MODER_MODE15_Pos)        /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1                 (0x2UL << GPIO_MODER_MODE15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos                 (0U)
#define GPIO_OTYPER_OT0_Msk                 (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                     GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos                 (1U)
#define GPIO_OTYPER_OT1_Msk                 (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                     GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos                 (2U)
#define GPIO_OTYPER_OT2_Msk                 (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                     GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos                 (3U)
#define GPIO_OTYPER_OT3_Msk                 (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                     GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos                 (4U)
#define GPIO_OTYPER_OT4_Msk                 (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                     GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos                 (5U)
#define GPIO_OTYPER_OT5_Msk                 (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                     GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos                 (6U)
#define GPIO_OTYPER_OT6_Msk                 (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                     GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos                 (7U)
#define GPIO_OTYPER_OT7_Msk                 (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                     GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos                 (8U)
#define GPIO_OTYPER_OT8_Msk                 (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                     GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos                 (9U)
#define GPIO_OTYPER_OT9_Msk                 (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                     GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos                (10U)
#define GPIO_OTYPER_OT10_Msk                (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10                    GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos                (11U)
#define GPIO_OTYPER_OT11_Msk                (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11                    GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos                (12U)
#define GPIO_OTYPER_OT12_Msk                (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12                    GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos                (13U)
#define GPIO_OTYPER_OT13_Msk                (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13                    GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos                (14U)
#define GPIO_OTYPER_OT14_Msk                (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14                    GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos                (15U)
#define GPIO_OTYPER_OT15_Msk                (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15                    GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos            (0U)
#define GPIO_OSPEEDR_OSPEED0_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0                GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0              (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1              (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000002 */
#define GPIO_OSPEEDR_OSPEED1_Pos            (2U)
#define GPIO_OSPEEDR_OSPEED1_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1                GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0              (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1              (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000008 */
#define GPIO_OSPEEDR_OSPEED2_Pos            (4U)
#define GPIO_OSPEEDR_OSPEED2_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2                GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0              (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1              (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000020 */
#define GPIO_OSPEEDR_OSPEED3_Pos            (6U)
#define GPIO_OSPEEDR_OSPEED3_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3                GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0              (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1              (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000080 */
#define GPIO_OSPEEDR_OSPEED4_Pos            (8U)
#define GPIO_OSPEEDR_OSPEED4_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4                GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0              (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1              (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000200 */
#define GPIO_OSPEEDR_OSPEED5_Pos            (10U)
#define GPIO_OSPEEDR_OSPEED5_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5                GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0              (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1              (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000800 */
#define GPIO_OSPEEDR_OSPEED6_Pos            (12U)
#define GPIO_OSPEEDR_OSPEED6_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6                GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0              (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1              (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00002000 */
#define GPIO_OSPEEDR_OSPEED7_Pos            (14U)
#define GPIO_OSPEEDR_OSPEED7_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7                GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0              (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1              (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00008000 */
#define GPIO_OSPEEDR_OSPEED8_Pos            (16U)
#define GPIO_OSPEEDR_OSPEED8_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8                GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0              (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1              (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00020000 */
#define GPIO_OSPEEDR_OSPEED9_Pos            (18U)
#define GPIO_OSPEEDR_OSPEED9_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9                GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0              (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1              (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00080000 */
#define GPIO_OSPEEDR_OSPEED10_Pos           (20U)
#define GPIO_OSPEEDR_OSPEED10_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10               GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0             (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1             (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00200000 */
#define GPIO_OSPEEDR_OSPEED11_Pos           (22U)
#define GPIO_OSPEEDR_OSPEED11_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11               GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0             (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1             (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00800000 */
#define GPIO_OSPEEDR_OSPEED12_Pos           (24U)
#define GPIO_OSPEEDR_OSPEED12_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12               GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0             (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1             (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x02000000 */
#define GPIO_OSPEEDR_OSPEED13_Pos           (26U)
#define GPIO_OSPEEDR_OSPEED13_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13               GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0             (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1             (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x08000000 */
#define GPIO_OSPEEDR_OSPEED14_Pos           (28U)
#define GPIO_OSPEEDR_OSPEED14_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14               GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0             (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1             (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x20000000 */
#define GPIO_OSPEEDR_OSPEED15_Pos           (30U)
#define GPIO_OSPEEDR_OSPEED15_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15               GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0             (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1             (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos                (0U)
#define GPIO_PUPDR_PUPD0_Msk                (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0                    GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0                  (0x1UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1                  (0x2UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000002 */
#define GPIO_PUPDR_PUPD1_Pos                (2U)
#define GPIO_PUPDR_PUPD1_Msk                (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1                    GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0                  (0x1UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1                  (0x2UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000008 */
#define GPIO_PUPDR_PUPD2_Pos                (4U)
#define GPIO_PUPDR_PUPD2_Msk                (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2                    GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0                  (0x1UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1                  (0x2UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000020 */
#define GPIO_PUPDR_PUPD3_Pos                (6U)
#define GPIO_PUPDR_PUPD3_Msk                (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3                    GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0                  (0x1UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1                  (0x2UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000080 */
#define GPIO_PUPDR_PUPD4_Pos                (8U)
#define GPIO_PUPDR_PUPD4_Msk                (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4                    GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0                  (0x1UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1                  (0x2UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000200 */
#define GPIO_PUPDR_PUPD5_Pos                (10U)
#define GPIO_PUPDR_PUPD5_Msk                (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5                    GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0                  (0x1UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1                  (0x2UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000800 */
#define GPIO_PUPDR_PUPD6_Pos                (12U)
#define GPIO_PUPDR_PUPD6_Msk                (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6                    GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0                  (0x1UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1                  (0x2UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00002000 */
#define GPIO_PUPDR_PUPD7_Pos                (14U)
#define GPIO_PUPDR_PUPD7_Msk                (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7                    GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0                  (0x1UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1                  (0x2UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00008000 */
#define GPIO_PUPDR_PUPD8_Pos                (16U)
#define GPIO_PUPDR_PUPD8_Msk                (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8                    GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0                  (0x1UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1                  (0x2UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00020000 */
#define GPIO_PUPDR_PUPD9_Pos                (18U)
#define GPIO_PUPDR_PUPD9_Msk                (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9                    GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0                  (0x1UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1                  (0x2UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00080000 */
#define GPIO_PUPDR_PUPD10_Pos               (20U)
#define GPIO_PUPDR_PUPD10_Msk               (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10                   GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0                 (0x1UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1                 (0x2UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00200000 */
#define GPIO_PUPDR_PUPD11_Pos               (22U)
#define GPIO_PUPDR_PUPD11_Msk               (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11                   GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0                 (0x1UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1                 (0x2UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00800000 */
#define GPIO_PUPDR_PUPD12_Pos               (24U)
#define GPIO_PUPDR_PUPD12_Msk               (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12                   GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0                 (0x1UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1                 (0x2UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x02000000 */
#define GPIO_PUPDR_PUPD13_Pos               (26U)
#define GPIO_PUPDR_PUPD13_Msk               (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13                   GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0                 (0x1UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1                 (0x2UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x08000000 */
#define GPIO_PUPDR_PUPD14_Pos               (28U)
#define GPIO_PUPDR_PUPD14_Msk               (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14                   GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0                 (0x1UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1                 (0x2UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x20000000 */
#define GPIO_PUPDR_PUPD15_Pos               (30U)
#define GPIO_PUPDR_PUPD15_Msk               (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15                   GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0                 (0x1UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1                 (0x2UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos                    (0U)
#define GPIO_IDR_ID0_Msk                    (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                        GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos                    (1U)
#define GPIO_IDR_ID1_Msk                    (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                        GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos                    (2U)
#define GPIO_IDR_ID2_Msk                    (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                        GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos                    (3U)
#define GPIO_IDR_ID3_Msk                    (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                        GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos                    (4U)
#define GPIO_IDR_ID4_Msk                    (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                        GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos                    (5U)
#define GPIO_IDR_ID5_Msk                    (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                        GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos                    (6U)
#define GPIO_IDR_ID6_Msk                    (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                        GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos                    (7U)
#define GPIO_IDR_ID7_Msk                    (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                        GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos                    (8U)
#define GPIO_IDR_ID8_Msk                    (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                        GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos                    (9U)
#define GPIO_IDR_ID9_Msk                    (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                        GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos                   (10U)
#define GPIO_IDR_ID10_Msk                   (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                       GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos                   (11U)
#define GPIO_IDR_ID11_Msk                   (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                       GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos                   (12U)
#define GPIO_IDR_ID12_Msk                   (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                       GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos                   (13U)
#define GPIO_IDR_ID13_Msk                   (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                       GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos                   (14U)
#define GPIO_IDR_ID14_Msk                   (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                       GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos                   (15U)
#define GPIO_IDR_ID15_Msk                   (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                       GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos                    (0U)
#define GPIO_ODR_OD0_Msk                    (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                        GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos                    (1U)
#define GPIO_ODR_OD1_Msk                    (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                        GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos                    (2U)
#define GPIO_ODR_OD2_Msk                    (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                        GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos                    (3U)
#define GPIO_ODR_OD3_Msk                    (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                        GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos                    (4U)
#define GPIO_ODR_OD4_Msk                    (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                        GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos                    (5U)
#define GPIO_ODR_OD5_Msk                    (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                        GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos                    (6U)
#define GPIO_ODR_OD6_Msk                    (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                        GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos                    (7U)
#define GPIO_ODR_OD7_Msk                    (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                        GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos                    (8U)
#define GPIO_ODR_OD8_Msk                    (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                        GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos                    (9U)
#define GPIO_ODR_OD9_Msk                    (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                        GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos                   (10U)
#define GPIO_ODR_OD10_Msk                   (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                       GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos                   (11U)
#define GPIO_ODR_OD11_Msk                   (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                       GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos                   (12U)
#define GPIO_ODR_OD12_Msk                   (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                       GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos                   (13U)
#define GPIO_ODR_OD13_Msk                   (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                       GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos                   (14U)
#define GPIO_ODR_OD14_Msk                   (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                       GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos                   (15U)
#define GPIO_ODR_OD15_Msk                   (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                       GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos                   (0U)
#define GPIO_BSRR_BS0_Msk                   (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                       GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos                   (1U)
#define GPIO_BSRR_BS1_Msk                   (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                       GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos                   (2U)
#define GPIO_BSRR_BS2_Msk                   (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                       GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos                   (3U)
#define GPIO_BSRR_BS3_Msk                   (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                       GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos                   (4U)
#define GPIO_BSRR_BS4_Msk                   (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                       GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos                   (5U)
#define GPIO_BSRR_BS5_Msk                   (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                       GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos                   (6U)
#define GPIO_BSRR_BS6_Msk                   (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                       GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos                   (7U)
#define GPIO_BSRR_BS7_Msk                   (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                       GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos                   (8U)
#define GPIO_BSRR_BS8_Msk                   (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                       GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos                   (9U)
#define GPIO_BSRR_BS9_Msk                   (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                       GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos                  (10U)
#define GPIO_BSRR_BS10_Msk                  (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                      GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos                  (11U)
#define GPIO_BSRR_BS11_Msk                  (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                      GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos                  (12U)
#define GPIO_BSRR_BS12_Msk                  (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                      GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos                  (13U)
#define GPIO_BSRR_BS13_Msk                  (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                      GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos                  (14U)
#define GPIO_BSRR_BS14_Msk                  (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                      GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos                  (15U)
#define GPIO_BSRR_BS15_Msk                  (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                      GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos                   (16U)
#define GPIO_BSRR_BR0_Msk                   (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                       GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos                   (17U)
#define GPIO_BSRR_BR1_Msk                   (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                       GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos                   (18U)
#define GPIO_BSRR_BR2_Msk                   (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                       GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos                   (19U)
#define GPIO_BSRR_BR3_Msk                   (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                       GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos                   (20U)
#define GPIO_BSRR_BR4_Msk                   (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                       GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos                   (21U)
#define GPIO_BSRR_BR5_Msk                   (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                       GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos                   (22U)
#define GPIO_BSRR_BR6_Msk                   (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                       GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos                   (23U)
#define GPIO_BSRR_BR7_Msk                   (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                       GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos                   (24U)
#define GPIO_BSRR_BR8_Msk                   (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                       GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos                   (25U)
#define GPIO_BSRR_BR9_Msk                   (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                       GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos                  (26U)
#define GPIO_BSRR_BR10_Msk                  (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                      GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos                  (27U)
#define GPIO_BSRR_BR11_Msk                  (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                      GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos                  (28U)
#define GPIO_BSRR_BR12_Msk                  (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                      GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos                  (29U)
#define GPIO_BSRR_BR13_Msk                  (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                      GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos                  (30U)
#define GPIO_BSRR_BR14_Msk                  (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                      GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos                  (31U)
#define GPIO_BSRR_BR15_Msk                  (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                      GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos                  (0U)
#define GPIO_LCKR_LCK0_Msk                  (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                      GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos                  (1U)
#define GPIO_LCKR_LCK1_Msk                  (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                      GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos                  (2U)
#define GPIO_LCKR_LCK2_Msk                  (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                      GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos                  (3U)
#define GPIO_LCKR_LCK3_Msk                  (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                      GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos                  (4U)
#define GPIO_LCKR_LCK4_Msk                  (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                      GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos                  (5U)
#define GPIO_LCKR_LCK5_Msk                  (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                      GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos                  (6U)
#define GPIO_LCKR_LCK6_Msk                  (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                      GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos                  (7U)
#define GPIO_LCKR_LCK7_Msk                  (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                      GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos                  (8U)
#define GPIO_LCKR_LCK8_Msk                  (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                      GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos                  (9U)
#define GPIO_LCKR_LCK9_Msk                  (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                      GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos                 (10U)
#define GPIO_LCKR_LCK10_Msk                 (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                     GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos                 (11U)
#define GPIO_LCKR_LCK11_Msk                 (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                     GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos                 (12U)
#define GPIO_LCKR_LCK12_Msk                 (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                     GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos                 (13U)
#define GPIO_LCKR_LCK13_Msk                 (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                     GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos                 (14U)
#define GPIO_LCKR_LCK14_Msk                 (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                     GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos                 (15U)
#define GPIO_LCKR_LCK15_Msk                 (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                     GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos                  (16U)
#define GPIO_LCKR_LCKK_Msk                  (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                      GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos                (0U)
#define GPIO_AFRL_AFSEL0_Msk                (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0                    GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0                  (0x1UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1                  (0x2UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2                  (0x4UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3                  (0x8UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos                (4U)
#define GPIO_AFRL_AFSEL1_Msk                (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1                    GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0                  (0x1UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1                  (0x2UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2                  (0x4UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3                  (0x8UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos                (8U)
#define GPIO_AFRL_AFSEL2_Msk                (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2                    GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0                  (0x1UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1                  (0x2UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2                  (0x4UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3                  (0x8UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos                (12U)
#define GPIO_AFRL_AFSEL3_Msk                (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3                    GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0                  (0x1UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1                  (0x2UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2                  (0x4UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3                  (0x8UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos                (16U)
#define GPIO_AFRL_AFSEL4_Msk                (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4                    GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0                  (0x1UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1                  (0x2UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2                  (0x4UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3                  (0x8UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos                (20U)
#define GPIO_AFRL_AFSEL5_Msk                (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5                    GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0                  (0x1UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1                  (0x2UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2                  (0x4UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3                  (0x8UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos                (24U)
#define GPIO_AFRL_AFSEL6_Msk                (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6                    GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0                  (0x1UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1                  (0x2UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2                  (0x4UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3                  (0x8UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos                (28U)
#define GPIO_AFRL_AFSEL7_Msk                (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7                    GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0                  (0x1UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1                  (0x2UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2                  (0x4UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3                  (0x8UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos                (0U)
#define GPIO_AFRH_AFSEL8_Msk                (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8                    GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0                  (0x1UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1                  (0x2UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2                  (0x4UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3                  (0x8UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos                (4U)
#define GPIO_AFRH_AFSEL9_Msk                (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9                    GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0                  (0x1UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1                  (0x2UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2                  (0x4UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3                  (0x8UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos               (8U)
#define GPIO_AFRH_AFSEL10_Msk               (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10                   GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0                 (0x1UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1                 (0x2UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2                 (0x4UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3                 (0x8UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos               (12U)
#define GPIO_AFRH_AFSEL11_Msk               (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11                   GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0                 (0x1UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1                 (0x2UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2                 (0x4UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3                 (0x8UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos               (16U)
#define GPIO_AFRH_AFSEL12_Msk               (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12                   GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0                 (0x1UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1                 (0x2UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2                 (0x4UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3                 (0x8UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos               (20U)
#define GPIO_AFRH_AFSEL13_Msk               (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13                   GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0                 (0x1UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1                 (0x2UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2                 (0x4UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3                 (0x8UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos               (24U)
#define GPIO_AFRH_AFSEL14_Msk               (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14                   GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0                 (0x1UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1                 (0x2UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2                 (0x4UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3                 (0x8UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos               (28U)
#define GPIO_AFRH_AFSEL15_Msk               (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15                   GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0                 (0x1UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1                 (0x2UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2                 (0x4UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3                 (0x8UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos                    (0U)
#define GPIO_BRR_BR0_Msk                    (0x1UL << GPIO_BRR_BR0_Pos)             /*!< 0x00000001 */
#define GPIO_BRR_BR0                        GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos                    (1U)
#define GPIO_BRR_BR1_Msk                    (0x1UL << GPIO_BRR_BR1_Pos)             /*!< 0x00000002 */
#define GPIO_BRR_BR1                        GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos                    (2U)
#define GPIO_BRR_BR2_Msk                    (0x1UL << GPIO_BRR_BR2_Pos)             /*!< 0x00000004 */
#define GPIO_BRR_BR2                        GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos                    (3U)
#define GPIO_BRR_BR3_Msk                    (0x1UL << GPIO_BRR_BR3_Pos)             /*!< 0x00000008 */
#define GPIO_BRR_BR3                        GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos                    (4U)
#define GPIO_BRR_BR4_Msk                    (0x1UL << GPIO_BRR_BR4_Pos)             /*!< 0x00000010 */
#define GPIO_BRR_BR4                        GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos                    (5U)
#define GPIO_BRR_BR5_Msk                    (0x1UL << GPIO_BRR_BR5_Pos)             /*!< 0x00000020 */
#define GPIO_BRR_BR5                        GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos                    (6U)
#define GPIO_BRR_BR6_Msk                    (0x1UL << GPIO_BRR_BR6_Pos)             /*!< 0x00000040 */
#define GPIO_BRR_BR6                        GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos                    (7U)
#define GPIO_BRR_BR7_Msk                    (0x1UL << GPIO_BRR_BR7_Pos)             /*!< 0x00000080 */
#define GPIO_BRR_BR7                        GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos                    (8U)
#define GPIO_BRR_BR8_Msk                    (0x1UL << GPIO_BRR_BR8_Pos)             /*!< 0x00000100 */
#define GPIO_BRR_BR8                        GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos                    (9U)
#define GPIO_BRR_BR9_Msk                    (0x1UL << GPIO_BRR_BR9_Pos)             /*!< 0x00000200 */
#define GPIO_BRR_BR9                        GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos                   (10U)
#define GPIO_BRR_BR10_Msk                   (0x1UL << GPIO_BRR_BR10_Pos)            /*!< 0x00000400 */
#define GPIO_BRR_BR10                       GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos                   (11U)
#define GPIO_BRR_BR11_Msk                   (0x1UL << GPIO_BRR_BR11_Pos)            /*!< 0x00000800 */
#define GPIO_BRR_BR11                       GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos                   (12U)
#define GPIO_BRR_BR12_Msk                   (0x1UL << GPIO_BRR_BR12_Pos)            /*!< 0x00001000 */
#define GPIO_BRR_BR12                       GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos                   (13U)
#define GPIO_BRR_BR13_Msk                   (0x1UL << GPIO_BRR_BR13_Pos)            /*!< 0x00002000 */
#define GPIO_BRR_BR13                       GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos                   (14U)
#define GPIO_BRR_BR14_Msk                   (0x1UL << GPIO_BRR_BR14_Pos)            /*!< 0x00004000 */
#define GPIO_BRR_BR14                       GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos                   (15U)
#define GPIO_BRR_BR15_Msk                   (0x1UL << GPIO_BRR_BR15_Pos)            /*!< 0x00008000 */
#define GPIO_BRR_BR15                       GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_HSLVR register  ******************/
#define GPIO_HSLVR_HSLV0_Pos                (0U)
#define GPIO_HSLVR_HSLV0_Msk                (0x1UL << GPIO_HSLVR_HSLV0_Pos)         /*!< 0x00000001 */
#define GPIO_HSLVR_HSLV0                    GPIO_HSLVR_HSLV0_Msk
#define GPIO_HSLVR_HSLV1_Pos                (1U)
#define GPIO_HSLVR_HSLV1_Msk                (0x1UL << GPIO_HSLVR_HSLV1_Pos)         /*!< 0x00000002 */
#define GPIO_HSLVR_HSLV1                    GPIO_HSLVR_HSLV1_Msk
#define GPIO_HSLVR_HSLV2_Pos                (2U)
#define GPIO_HSLVR_HSLV2_Msk                (0x1UL << GPIO_HSLVR_HSLV2_Pos)         /*!< 0x00000004 */
#define GPIO_HSLVR_HSLV2                    GPIO_HSLVR_HSLV2_Msk
#define GPIO_HSLVR_HSLV3_Pos                (3U)
#define GPIO_HSLVR_HSLV3_Msk                (0x1UL << GPIO_HSLVR_HSLV3_Pos)         /*!< 0x00000008 */
#define GPIO_HSLVR_HSLV3                    GPIO_HSLVR_HSLV3_Msk
#define GPIO_HSLVR_HSLV4_Pos                (4U)
#define GPIO_HSLVR_HSLV4_Msk                (0x1UL << GPIO_HSLVR_HSLV4_Pos)         /*!< 0x00000010 */
#define GPIO_HSLVR_HSLV4                    GPIO_HSLVR_HSLV4_Msk
#define GPIO_HSLVR_HSLV5_Pos                (5U)
#define GPIO_HSLVR_HSLV5_Msk                (0x1UL << GPIO_HSLVR_HSLV5_Pos)         /*!< 0x00000020 */
#define GPIO_HSLVR_HSLV5                    GPIO_HSLVR_HSLV5_Msk
#define GPIO_HSLVR_HSLV6_Pos                (6U)
#define GPIO_HSLVR_HSLV6_Msk                (0x1UL << GPIO_HSLVR_HSLV6_Pos)         /*!< 0x00000040 */
#define GPIO_HSLVR_HSLV6                    GPIO_HSLVR_HSLV6_Msk
#define GPIO_HSLVR_HSLV7_Pos                (7U)
#define GPIO_HSLVR_HSLV7_Msk                (0x1UL << GPIO_HSLVR_HSLV7_Pos)         /*!< 0x00000080 */
#define GPIO_HSLVR_HSLV7                    GPIO_HSLVR_HSLV7_Msk
#define GPIO_HSLVR_HSLV8_Pos                (8U)
#define GPIO_HSLVR_HSLV8_Msk                (0x1UL << GPIO_HSLVR_HSLV8_Pos)         /*!< 0x00000100 */
#define GPIO_HSLVR_HSLV8                    GPIO_HSLVR_HSLV8_Msk
#define GPIO_HSLVR_HSLV9_Pos                (9U)
#define GPIO_HSLVR_HSLV9_Msk                (0x1UL << GPIO_HSLVR_HSLV9_Pos)         /*!< 0x00000200 */
#define GPIO_HSLVR_HSLV9                    GPIO_HSLVR_HSLV9_Msk
#define GPIO_HSLVR_HSLV10_Pos               (10U)
#define GPIO_HSLVR_HSLV10_Msk               (0x1UL << GPIO_HSLVR_HSLV10_Pos)        /*!< 0x00000400 */
#define GPIO_HSLVR_HSLV10                   GPIO_HSLVR_HSLV10_Msk
#define GPIO_HSLVR_HSLV11_Pos               (11U)
#define GPIO_HSLVR_HSLV11_Msk               (x1UL << GPIO_HSLVR_HSLV11_Pos)         /*!< 0x00000800 */
#define GPIO_HSLVR_HSLV11                   GPIO_HSLVR_HSLV11_Msk
#define GPIO_HSLVR_HSLV12_Pos               (12U)
#define GPIO_HSLVR_HSLV12_Msk               (0x1UL << GPIO_HSLVR_HSLV12_Pos)        /*!< 0x00001000 */
#define GPIO_HSLVR_HSLV12                   GPIO_HSLVR_HSLV12_Msk
#define GPIO_HSLVR_HSLV13_Pos               (13U)
#define GPIO_HSLVR_HSLV13_Msk               (0x1UL << GPIO_HSLVR_HSLV13_Pos)        /*!< 0x00002000 */
#define GPIO_HSLVR_HSLV13                   GPIO_HSLVR_HSLV13_Msk
#define GPIO_HSLVR_HSLV14_Pos               (14U)
#define GPIO_HSLVR_HSLV14_Msk               (0x1UL << GPIO_HSLVR_HSLV14_Pos)        /*!< 0x00004000 */
#define GPIO_HSLVR_HSLV14                   GPIO_HSLVR_HSLV14_Msk
#define GPIO_HSLVR_HSLV15_Pos               (15U)
#define GPIO_HSLVR_HSLV15_Msk               (0x1UL << GPIO_HSLVR_HSLV15_Pos)        /*!< 0x00008000 */
#define GPIO_HSLVR_HSLV15                   GPIO_HSLVR_HSLV15_Msk

/******************  Bits definition for GPIO_SECCFGR register  ******************/
#define GPIO_SECCFGR_SEC0_Pos               (0U)
#define GPIO_SECCFGR_SEC0_Msk               (0x1UL << GPIO_SECCFGR_SEC0_Pos)        /*!< 0x00000001 */
#define GPIO_SECCFGR_SEC0                   GPIO_SECCFGR_SEC0_Msk
#define GPIO_SECCFGR_SEC1_Pos               (1U)
#define GPIO_SECCFGR_SEC1_Msk               (0x1UL << GPIO_SECCFGR_SEC1_Pos)        /*!< 0x00000002 */
#define GPIO_SECCFGR_SEC1                   GPIO_SECCFGR_SEC1_Msk
#define GPIO_SECCFGR_SEC2_Pos               (2U)
#define GPIO_SECCFGR_SEC2_Msk               (0x1UL << GPIO_SECCFGR_SEC2_Pos)        /*!< 0x00000004 */
#define GPIO_SECCFGR_SEC2                   GPIO_SECCFGR_SEC2_Msk
#define GPIO_SECCFGR_SEC3_Pos               (3U)
#define GPIO_SECCFGR_SEC3_Msk               (0x1UL << GPIO_SECCFGR_SEC3_Pos)        /*!< 0x00000008 */
#define GPIO_SECCFGR_SEC3                   GPIO_SECCFGR_SEC3_Msk
#define GPIO_SECCFGR_SEC4_Pos               (4U)
#define GPIO_SECCFGR_SEC4_Msk               (0x1UL << GPIO_SECCFGR_SEC4_Pos)        /*!< 0x00000010 */
#define GPIO_SECCFGR_SEC4                   GPIO_SECCFGR_SEC4_Msk
#define GPIO_SECCFGR_SEC5_Pos               (5U)
#define GPIO_SECCFGR_SEC5_Msk               (0x1UL << GPIO_SECCFGR_SEC5_Pos)        /*!< 0x00000020 */
#define GPIO_SECCFGR_SEC5                   GPIO_SECCFGR_SEC5_Msk
#define GPIO_SECCFGR_SEC6_Pos               (6U)
#define GPIO_SECCFGR_SEC6_Msk               (0x1UL << GPIO_SECCFGR_SEC6_Pos)        /*!< 0x00000040 */
#define GPIO_SECCFGR_SEC6                   GPIO_SECCFGR_SEC6_Msk
#define GPIO_SECCFGR_SEC7_Pos               (7U)
#define GPIO_SECCFGR_SEC7_Msk               (0x1UL << GPIO_SECCFGR_SEC7_Pos)        /*!< 0x00000080 */
#define GPIO_SECCFGR_SEC7                   GPIO_SECCFGR_SEC7_Msk
#define GPIO_SECCFGR_SEC8_Pos               (8U)
#define GPIO_SECCFGR_SEC8_Msk               (0x1UL << GPIO_SECCFGR_SEC8_Pos)        /*!< 0x00000100 */
#define GPIO_SECCFGR_SEC8                   GPIO_SECCFGR_SEC8_Msk
#define GPIO_SECCFGR_SEC9_Pos               (9U)
#define GPIO_SECCFGR_SEC9_Msk               (0x1UL << GPIO_SECCFGR_SEC9_Pos)        /*!< 0x00000200 */
#define GPIO_SECCFGR_SEC9                   GPIO_SECCFGR_SEC9_Msk
#define GPIO_SECCFGR_SEC10_Pos              (10U)
#define GPIO_SECCFGR_SEC10_Msk              (0x1UL << GPIO_SECCFGR_SEC10_Pos)       /*!< 0x00000400 */
#define GPIO_SECCFGR_SEC10                  GPIO_SECCFGR_SEC10_Msk
#define GPIO_SECCFGR_SEC11_Pos              (11U)
#define GPIO_SECCFGR_SEC11_Msk              (x1UL << GPIO_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define GPIO_SECCFGR_SEC11                  GPIO_SECCFGR_SEC11_Msk
#define GPIO_SECCFGR_SEC12_Pos              (12U)
#define GPIO_SECCFGR_SEC12_Msk              (0x1UL << GPIO_SECCFGR_SEC12_Pos)       /*!< 0x00001000 */
#define GPIO_SECCFGR_SEC12                  GPIO_SECCFGR_SEC12_Msk
#define GPIO_SECCFGR_SEC13_Pos              (13U)
#define GPIO_SECCFGR_SEC13_Msk              (0x1UL << GPIO_SECCFGR_SEC13_Pos)       /*!< 0x00002000 */
#define GPIO_SECCFGR_SEC13                  GPIO_SECCFGR_SEC13_Msk
#define GPIO_SECCFGR_SEC14_Pos              (14U)
#define GPIO_SECCFGR_SEC14_Msk              (0x1UL << GPIO_SECCFGR_SEC14_Pos)       /*!< 0x00004000 */
#define GPIO_SECCFGR_SEC14                  GPIO_SECCFGR_SEC14_Msk
#define GPIO_SECCFGR_SEC15_Pos              (15U)
#define GPIO_SECCFGR_SEC15_Msk              (0x1UL << GPIO_SECCFGR_SEC15_Pos)       /*!< 0x00008000 */
#define GPIO_SECCFGR_SEC15                  GPIO_SECCFGR_SEC15_Msk

/*****************************************************************************/
/*                                                                           */
/*                        Global TrustZone Control                           */
/*                                                                           */
/*****************************************************************************/
/*******************  Bits definition for GTZC_TZSC_CR register  ******************/
#define GTZC_TZSC_CR_LCK_Pos                (0U)
#define GTZC_TZSC_CR_LCK_Msk                (0x01UL << GTZC_TZSC_CR_LCK_Pos)        /*!< 0x00000001 */

/*******  Bits definition for TZSC _SECCFGRx/_PRIVCFGRx registers  *****/
/*******  Bits definition for TZIC _IERx/_SRx/_IFCRx registers  ********/

/***************  Bits definition for register x=1 (TZSC1) *************/
#define GTZC_CFGR1_TIM2_Pos                 (0U)
#define GTZC_CFGR1_TIM2_Msk                 (0x01UL << GTZC_CFGR1_TIM2_Pos)         /*!< 0x00000001 */
#define GTZC_CFGR1_TIM3_Pos                 (1U)
#define GTZC_CFGR1_TIM3_Msk                 (0x01UL << GTZC_CFGR1_TIM3_Pos)         /*!< 0x00000002 */
#define GTZC_CFGR1_TIM4_Pos                 (2U)
#define GTZC_CFGR1_TIM4_Msk                 (0x01UL << GTZC_CFGR1_TIM4_Pos)         /*!< 0x00000004 */
#define GTZC_CFGR1_TIM6_Pos                 (4U)
#define GTZC_CFGR1_TIM6_Msk                 (0x01UL << GTZC_CFGR1_TIM6_Pos)         /*!< 0x00000010 */
#define GTZC_CFGR1_TIM7_Pos                 (5U)
#define GTZC_CFGR1_TIM7_Msk                 (0x01UL << GTZC_CFGR1_TIM7_Pos)         /*!< 0x00000020 */
#define GTZC_CFGR1_WWDG_Pos                 (6U)
#define GTZC_CFGR1_WWDG_Msk                 (0x01UL << GTZC_CFGR1_WWDG_Pos)         /*!< 0x00000040 */
#define GTZC_CFGR1_IWDG_Pos                 (7U)
#define GTZC_CFGR1_IWDG_Msk                 (0x01UL << GTZC_CFGR1_IWDG_Pos)         /*!< 0x00000080 */
#define GTZC_CFGR1_SPI2_Pos                 (8U)
#define GTZC_CFGR1_SPI2_Msk                 (0x01UL << GTZC_CFGR1_SPI2_Pos)         /*!< 0x00000100 */
#define GTZC_CFGR1_USART2_Pos               (9U)
#define GTZC_CFGR1_USART2_Msk               (0x01UL << GTZC_CFGR1_USART2_Pos)       /*!< 0x00000200 */
#define GTZC_CFGR1_USART3_Pos               (10U)
#define GTZC_CFGR1_USART3_Msk               (0x01UL << GTZC_CFGR1_USART3_Pos)       /*!< 0x00000400 */
#define GTZC_CFGR1_UART4_Pos                (11U)
#define GTZC_CFGR1_UART4_Msk                (0x01UL << GTZC_CFGR1_UART4_Pos)        /*!< 0x00000800 */
#define GTZC_CFGR1_UART5_Pos                (12U)
#define GTZC_CFGR1_UART5_Msk                (0x01UL << GTZC_CFGR1_UART5_Pos)        /*!< 0x00001000 */
#define GTZC_CFGR1_I2C1_Pos                 (13U)
#define GTZC_CFGR1_I2C1_Msk                 (0x01UL << GTZC_CFGR1_I2C1_Pos)         /*!< 0x00002000 */
#define GTZC_CFGR1_I2C2_Pos                 (14U)
#define GTZC_CFGR1_I2C2_Msk                 (0x01UL << GTZC_CFGR1_I2C2_Pos)         /*!< 0x00004000 */
#define GTZC_CFGR1_CRS_Pos                  (15U)
#define GTZC_CFGR1_CRS_Msk                  (0x01UL << GTZC_CFGR1_CRS_Pos)          /*!< 0x00008000 */
#define GTZC_CFGR1_I2C4_Pos                 (16U)
#define GTZC_CFGR1_I2C4_Msk                 (0x01UL << GTZC_CFGR1_I2C4_Pos)         /*!< 0x00010000 */
#define GTZC_CFGR1_LPTIM2_Pos               (17U)
#define GTZC_CFGR1_LPTIM2_Msk               (0x01UL << GTZC_CFGR1_LPTIM2_Pos)       /*!< 0x00020000 */
#define GTZC_CFGR1_FDCAN1_Pos               (18U)
#define GTZC_CFGR1_FDCAN1_Msk               (0x01UL << GTZC_CFGR1_FDCAN1_Pos)       /*!< 0x00040000 */
#define GTZC_CFGR1_FDCAN2_Pos               (20U)
#define GTZC_CFGR1_FDCAN2_Msk               (0x01UL << GTZC_CFGR1_FDCAN2_Pos)       /*!< 0x00100000 */
#define GTZC_CFGR1_SPI3_Pos                 (21U)
#define GTZC_CFGR1_SPI3_Msk                 (0x01UL << GTZC_CFGR1_SPI3_Pos)         /*!< 0x00200000 */
#define GTZC_CFGR1_I3C1_Pos                 (22U)
#define GTZC_CFGR1_I3C1_Msk                 (0x01UL << GTZC_CFGR1_I3C1_Pos)         /*!< 0x00400000 */
#define GTZC_CFGR1_OPAMP_Pos                (23U)
#define GTZC_CFGR1_OPAMP_Msk                (0x01UL << GTZC_CFGR1_OPAMP_Pos)        /*!< 0x00800000 */
#define GTZC_CFGR1_VREFBUF_Pos              (24U)
#define GTZC_CFGR1_VREFBUF_Msk              (0x01UL << GTZC_CFGR1_VREFBUF_Pos)      /*!< 0x01000000 */
#define GTZC_CFGR1_SPI4_Pos                 (25U)
#define GTZC_CFGR1_SPI4_Msk                 (0x01UL << GTZC_CFGR1_SPI4_Pos)         /*!< 0x00010000 */

/***************  Bits definition for register x=2 (TZSC1) *************/
#define GTZC_CFGR2_TIM1_Pos                 (0U)
#define GTZC_CFGR2_TIM1_Msk                 (0x01UL << GTZC_CFGR2_TIM1_Pos)         /*!< 0x00000001 */
#define GTZC_CFGR2_SPI1_Pos                 (1U)
#define GTZC_CFGR2_SPI1_Msk                 (0x01UL << GTZC_CFGR2_SPI1_Pos)         /*!< 0x00000002 */
#define GTZC_CFGR2_TIM8_Pos                 (2U)
#define GTZC_CFGR2_TIM8_Msk                 (0x01UL << GTZC_CFGR2_TIM8_Pos)         /*!< 0x00000004 */
#define GTZC_CFGR2_USART1_Pos               (3U)
#define GTZC_CFGR2_USART1_Msk               (0x01UL << GTZC_CFGR2_USART1_Pos)       /*!< 0x00000008 */
#define GTZC_CFGR2_TIM15_Pos                (4U)
#define GTZC_CFGR2_TIM15_Msk                (0x01UL << GTZC_CFGR2_TIM15_Pos)        /*!< 0x00000010 */
#define GTZC_CFGR2_TIM16_Pos                (5U)
#define GTZC_CFGR2_TIM16_Msk                (0x01UL << GTZC_CFGR2_TIM16_Pos)        /*!< 0x00000020 */
#define GTZC_CFGR2_TIM17_Pos                (6U)
#define GTZC_CFGR2_TIM17_Msk                (0x01UL << GTZC_CFGR2_TIM17_Pos)        /*!< 0x00000040 */
#define GTZC_CFGR2_SAI1_Pos                 (7U)
#define GTZC_CFGR2_SAI1_Msk                 (0x01UL << GTZC_CFGR2_SAI1_Pos)         /*!< 0x00000080 */
#define GTZC_CFGR2_TIM12_Pos                (8U)
#define GTZC_CFGR2_TIM12_Msk                (0x01UL << GTZC_CFGR2_TIM12_Pos)        /*!< 0x00000100 */
#define GTZC_CFGR2_USB_Pos                  (9U)
#define GTZC_CFGR2_USB_Msk                  (0x01UL << GTZC_CFGR2_USB_Pos)          /*!< 0x00000200 */
#define GTZC_CFGR2_I3C2_Pos                 (10U)
#define GTZC_CFGR2_I3C2_Msk                 (0x01UL << GTZC_CFGR2_I3C2_Pos)         /*!< 0x00000400 */
#define GTZC_CFGR2_LPUART1_Pos              (11U)
#define GTZC_CFGR2_LPUART1_Msk              (0x01UL << GTZC_CFGR2_LPUART1_Pos)      /*!< 0x00000800 */
#define GTZC_CFGR2_I2C3_Pos                 (12U)
#define GTZC_CFGR2_I2C3_Msk                 (0x01UL << GTZC_CFGR2_I2C3_Pos)         /*!< 0x00001000 */
#define GTZC_CFGR2_LPTIM1_Pos               (13U)
#define GTZC_CFGR2_LPTIM1_Msk               (0x01UL << GTZC_CFGR2_LPTIM1_Pos)       /*!< 0x00002000 */
#define GTZC_CFGR2_LPTIM3_Pos               (14U)
#define GTZC_CFGR2_LPTIM3_Msk               (0x01UL << GTZC_CFGR2_LPTIM3_Pos)       /*!< 0x00004000 */
#define GTZC_CFGR2_LPTIM4_Pos               (15U)
#define GTZC_CFGR2_LPTIM4_Msk               (0x01UL << GTZC_CFGR2_LPTIM4_Pos)       /*!< 0x00008000 */
#define GTZC_CFGR2_COMP_Pos                 (16U)
#define GTZC_CFGR2_COMP_Msk                 (0x01UL << GTZC_CFGR2_COMP_Pos)         /*!< 0x00010000 */

/***************  Bits definition for register x=3 (TZSC1) *************/
#define GTZC_CFGR3_CRC_Pos                  (3U)
#define GTZC_CFGR3_CRC_Msk                  (0x01UL << GTZC_CFGR3_CRC_Pos)          /*!< 0x00000004 */
#define GTZC_CFGR3_TSC_Pos                  (4U)
#define GTZC_CFGR3_TSC_Msk                  (0x01UL << GTZC_CFGR3_TSC_Pos)          /*!< 0x00000008 */
#define GTZC_CFGR3_ICACHE_REG_Pos           (6U)
#define GTZC_CFGR3_ICACHE_REG_Msk           (0x01UL << GTZC_CFGR3_ICACHE_REG_Pos)   /*!< 0x00000020 */
#define GTZC_CFGR3_ADC12_Pos                (8U)
#define GTZC_CFGR3_ADC12_Msk                (0x01UL << GTZC_CFGR3_ADC12_Pos)        /*!< 0x00000100 */
#define GTZC_CFGR3_HASH_Pos                 (12U)
#define GTZC_CFGR3_HASH_Msk                 (0x01UL << GTZC_CFGR3_HASH_Pos)         /*!< 0x00001000 */
#define GTZC_CFGR3_RNG_Pos                  (13U)
#define GTZC_CFGR3_RNG_Msk                  (0x01UL << GTZC_CFGR3_RNG_Pos)          /*!< 0x00002000 */
#define GTZC_CFGR3_SDMMC1_Pos               (17U)
#define GTZC_CFGR3_SDMMC1_Msk               (0x01UL << GTZC_CFGR3_SDMMC1_Pos)       /*!< 0x00020000 */
#define GTZC_CFGR3_OCTOSPI1_REG_Pos         (20U)
#define GTZC_CFGR3_OCTOSPI1_REG_Msk         (0x01UL << GTZC_CFGR3_OCTOSPI1_REG_Pos) /*!< 0x00080000 */
#define GTZC_CFGR3_RAMCFG_Pos               (22U)
#define GTZC_CFGR3_RAMCFG_Msk               (0x01UL << GTZC_CFGR3_RAMCFG_Pos)       /*!< 0x00400000 */
#define GTZC_CFGR3_DAC1_Pos                 (23U)
#define GTZC_CFGR3_DAC1_Msk                 (0x01UL << GTZC_CFGR3_DAC1_Pos)         /*!< 0x00800000 */
#define GTZC_CFGR3_ADF1_Pos                 (24U)
#define GTZC_CFGR3_ADF1_Msk                 (0x01UL << GTZC_CFGR3_ADF1_Pos)         /*!< 0x01000000 */
#define GTZC_CFGR3_HSP1_Pos                 (29U)
#define GTZC_CFGR3_HSP1_Msk                 (0x01UL << GTZC_CFGR3_HSP1_Pos)         /*!< 0x20000000 */

/***************  Bits definition for register x=4 (TZSC1) *************/
#define GTZC_CFGR4_GPDMA1_Pos               (0U)
#define GTZC_CFGR4_GPDMA1_Msk               (0x01UL << GTZC_CFGR4_GPDMA1_Pos)       /*!< 0x00000001 */
#define GTZC_CFGR4_FLASH_REG_Pos            (1U)
#define GTZC_CFGR4_FLASH_REG_Msk            (0x01UL << GTZC_CFGR4_FLASH_REG_Pos)    /*!< 0x00000002 */
#define GTZC_CFGR4_FLASH_Pos                (2U)
#define GTZC_CFGR4_FLASH_Msk                (0x01UL << GTZC_CFGR4_FLASH_Pos)        /*!< 0x00000004 */
#define GTZC_CFGR4_PWR_Pos                  (3U)
#define GTZC_CFGR4_PWR_Msk                  (0x01UL << GTZC_CFGR4_PWR_Pos)          /*!< 0x00000008 */
#define GTZC_CFGR4_RCC_Pos                  (4U)
#define GTZC_CFGR4_RCC_Msk                  (0x01UL << GTZC_CFGR4_RCC_Pos)          /*!< 0x00000010 */
#define GTZC_CFGR4_SYSCFG_Pos               (5U)
#define GTZC_CFGR4_SYSCFG_Msk               (0x01UL << GTZC_CFGR4_SYSCFG_Pos)       /*!< 0x00000020 */
#define GTZC_CFGR4_EXTI_Pos                 (6U)
#define GTZC_CFGR4_EXTI_Msk                 (0x01UL << GTZC_CFGR4_EXTI_Pos)         /*!< 0x00000040 */
#define GTZC_CFGR4_RTC_Pos                  (7U)
#define GTZC_CFGR4_RTC_Msk                  (0x01UL << GTZC_CFGR4_RTC_Pos)          /*!< 0x00000080 */
#define GTZC_CFGR4_TAMP_Pos                 (8U)
#define GTZC_CFGR4_TAMP_Msk                 (0x01UL << GTZC_CFGR4_TAMP_Pos)         /*!< 0x00000100 */
#define GTZC_CFGR4_TZSC_Pos                 (14U)
#define GTZC_CFGR4_TZSC_Msk                 (0x01UL << GTZC_CFGR4_TZSC_Pos)         /*!< 0x00004000 */
#define GTZC_CFGR4_TZIC_Pos                 (15U)
#define GTZC_CFGR4_TZIC_Msk                 (0x01UL << GTZC_CFGR4_TZIC_Pos)         /*!< 0x00008000 */
#define GTZC_CFGR4_SRAM1_Pos                (24U)
#define GTZC_CFGR4_SRAM1_Msk                (0x01UL << GTZC_CFGR4_SRAM1_Pos)        /*!< 0x01000000 */
#define GTZC_CFGR4_MPCBB1_REG_Pos           (25U)
#define GTZC_CFGR4_MPCBB1_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB1_REG_Pos)   /*!< 0x02000000 */
#define GTZC_CFGR4_SRAM2_Pos                (26U)
#define GTZC_CFGR4_SRAM2_Msk                (0x01UL << GTZC_CFGR4_SRAM2_Pos)        /*!< 0x04000000 */
#define GTZC_CFGR4_MPCBB2_REG_Pos           (27U)
#define GTZC_CFGR4_MPCBB2_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB2_REG_Pos)   /*!< 0x08000000 */
#define GTZC_CFGR4_SRAM3_Pos                (28U)
#define GTZC_CFGR4_SRAM3_Msk                (0x01UL << GTZC_CFGR4_SRAM3_Pos)        /*!< 0x10000000 */
#define GTZC_CFGR4_MPCBB3_REG_Pos           (29U)
#define GTZC_CFGR4_MPCBB3_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB3_REG_Pos)   /*!< 0x20000000 */
#define GTZC_CFGR4_SRAM4_Pos                (30U)
#define GTZC_CFGR4_SRAM4_Msk                (0x01UL << GTZC_CFGR4_SRAM4_Pos)        /*!< 0x40000000 */
#define GTZC_CFGR4_MPCBB4_REG_Pos           (31U)
#define GTZC_CFGR4_MPCBB4_REG_Msk           (0x01UL << GTZC_CFGR4_MPCBB4_REG_Pos)   /*!< 0x80000000 */

/*******************  Bits definition for GTZC_TZSC1_SECCFGR1 register  ***************/
#define GTZC_TZSC1_SECCFGR1_TIM2_Pos            GTZC_CFGR1_TIM2_Pos
#define GTZC_TZSC1_SECCFGR1_TIM2_Msk            GTZC_CFGR1_TIM2_Msk
#define GTZC_TZSC1_SECCFGR1_TIM3_Pos            GTZC_CFGR1_TIM3_Pos
#define GTZC_TZSC1_SECCFGR1_TIM3_Msk            GTZC_CFGR1_TIM3_Msk
#define GTZC_TZSC1_SECCFGR1_TIM4_Pos            GTZC_CFGR1_TIM4_Pos
#define GTZC_TZSC1_SECCFGR1_TIM4_Msk            GTZC_CFGR1_TIM4_Msk
#define GTZC_TZSC1_SECCFGR1_TIM5_Pos            GTZC_CFGR1_TIM5_Pos
#define GTZC_TZSC1_SECCFGR1_TIM5_Msk            GTZC_CFGR1_TIM5_Msk
#define GTZC_TZSC1_SECCFGR1_TIM6_Pos            GTZC_CFGR1_TIM6_Pos
#define GTZC_TZSC1_SECCFGR1_TIM6_Msk            GTZC_CFGR1_TIM6_Msk
#define GTZC_TZSC1_SECCFGR1_TIM7_Pos            GTZC_CFGR1_TIM7_Pos
#define GTZC_TZSC1_SECCFGR1_TIM7_Msk            GTZC_CFGR1_TIM7_Msk
#define GTZC_TZSC1_SECCFGR1_WWDG_Pos            GTZC_CFGR1_WWDG_Pos
#define GTZC_TZSC1_SECCFGR1_WWDG_Msk            GTZC_CFGR1_WWDG_Msk
#define GTZC_TZSC1_SECCFGR1_IWDG_Pos            GTZC_CFGR1_IWDG_Pos
#define GTZC_TZSC1_SECCFGR1_IWDG_Msk            GTZC_CFGR1_IWDG_Msk
#define GTZC_TZSC1_SECCFGR1_SPI2_Pos            GTZC_CFGR1_SPI2_Pos
#define GTZC_TZSC1_SECCFGR1_SPI2_Msk            GTZC_CFGR1_SPI2_Msk
#define GTZC_TZSC1_SECCFGR1_USART2_Pos          GTZC_CFGR1_USART2_Pos
#define GTZC_TZSC1_SECCFGR1_USART2_Msk          GTZC_CFGR1_USART2_Msk
#define GTZC_TZSC1_SECCFGR1_USART3_Pos          GTZC_CFGR1_USART3_Pos
#define GTZC_TZSC1_SECCFGR1_USART3_Msk          GTZC_CFGR1_USART3_Msk
#define GTZC_TZSC1_SECCFGR1_UART4_Pos           GTZC_CFGR1_UART4_Pos
#define GTZC_TZSC1_SECCFGR1_UART4_Msk           GTZC_CFGR1_UART4_Msk
#define GTZC_TZSC1_SECCFGR1_UART5_Pos           GTZC_CFGR1_UART5_Pos
#define GTZC_TZSC1_SECCFGR1_UART5_Msk           GTZC_CFGR1_UART5_Msk
#define GTZC_TZSC1_SECCFGR1_I2C1_Pos            GTZC_CFGR1_I2C1_Pos
#define GTZC_TZSC1_SECCFGR1_I2C1_Msk            GTZC_CFGR1_I2C1_Msk
#define GTZC_TZSC1_SECCFGR1_I2C2_Pos            GTZC_CFGR1_I2C2_Pos
#define GTZC_TZSC1_SECCFGR1_I2C2_Msk            GTZC_CFGR1_I2C2_Msk
#define GTZC_TZSC1_SECCFGR1_CRS_Pos             GTZC_CFGR1_CRS_Pos
#define GTZC_TZSC1_SECCFGR1_CRS_Msk             GTZC_CFGR1_CRS_Msk
#define GTZC_TZSC1_SECCFGR1_I2C4_Pos            GTZC_CFGR1_I2C4_Pos
#define GTZC_TZSC1_SECCFGR1_I2C4_Msk            GTZC_CFGR1_I2C4_Msk
#define GTZC_TZSC1_SECCFGR1_LPTIM2_Pos          GTZC_CFGR1_LPTIM2_Pos
#define GTZC_TZSC1_SECCFGR1_LPTIM2_Msk          GTZC_CFGR1_LPTIM2_Msk
#define GTZC_TZSC1_SECCFGR1_FDCAN1_Pos          GTZC_CFGR1_FDCAN1_Pos
#define GTZC_TZSC1_SECCFGR1_FDCAN1_Msk          GTZC_CFGR1_FDCAN1_Msk
#define GTZC_TZSC1_SECCFGR1_FDCAN2_Pos          GTZC_CFGR1_FDCAN2_Pos
#define GTZC_TZSC1_SECCFGR1_FDCAN2_Msk          GTZC_CFGR1_FDCAN2_Msk
#define GTZC_TZSC1_SECCFGR1_SPI3_Pos            GTZC_CFGR1_SPI3_Pos
#define GTZC_TZSC1_SECCFGR1_SPI3_Msk            GTZC_CFGR1_SPI3_Msk
#define GTZC_TZSC1_SECCFGR1_I3C1_Pos            GTZC_CFGR1_I3C1_Pos
#define GTZC_TZSC1_SECCFGR1_I3C1_Msk            GTZC_CFGR1_I3C1_Msk
#define GTZC_TZSC1_SECCFGR1_OPAMP_Pos           GTZC_CFGR1_OPAMP_Pos
#define GTZC_TZSC1_SECCFGR1_OPAMP_Msk           GTZC_CFGR1_OPAMP_Msk
#define GTZC_TZSC1_SECCFGR1_VREFBUF_Pos         GTZC_CFGR1_VREFBUF_Pos
#define GTZC_TZSC1_SECCFGR1_VREFBUF_Msk         GTZC_CFGR1_VREFBUF_Msk
#define GTZC_TZSC1_SECCFGR1_SPI4_Pos            GTZC_CFGR1_SPI4_Pos
#define GTZC_TZSC1_SECCFGR1_SPI4_Msk            GTZC_CFGR1_SPI4_Msk

/*******************  Bits definition for GTZC_TZSC1_SECCFGR2 register  ***************/
#define GTZC_TZSC1_SECCFGR2_TIM1_Pos            GTZC_CFGR2_TIM1_Pos
#define GTZC_TZSC1_SECCFGR2_TIM1_Msk            GTZC_CFGR2_TIM1_Msk
#define GTZC_TZSC1_SECCFGR2_SPI1_Pos            GTZC_CFGR2_SPI1_Pos
#define GTZC_TZSC1_SECCFGR2_SPI1_Msk            GTZC_CFGR2_SPI1_Msk
#define GTZC_TZSC1_SECCFGR1_TIM8_Pos            GTZC_CFGR2_TIM8_Pos
#define GTZC_TZSC1_SECCFGR1_TIM8_Msk            GTZC_CFGR2_TIM8_Msk
#define GTZC_TZSC1_SECCFGR2_USART1_Pos          GTZC_CFGR2_USART1_Pos
#define GTZC_TZSC1_SECCFGR2_USART1_Msk          GTZC_CFGR2_USART1_Msk
#define GTZC_TZSC1_SECCFGR2_TIM15_Pos           GTZC_CFGR2_TIM15_Pos
#define GTZC_TZSC1_SECCFGR2_TIM15_Msk           GTZC_CFGR2_TIM15_Msk
#define GTZC_TZSC1_SECCFGR2_TIM16_Pos           GTZC_CFGR2_TIM16_Pos
#define GTZC_TZSC1_SECCFGR2_TIM16_Msk           GTZC_CFGR2_TIM16_Msk
#define GTZC_TZSC1_SECCFGR2_TIM17_Pos           GTZC_CFGR2_TIM17_Pos
#define GTZC_TZSC1_SECCFGR2_TIM17_Msk           GTZC_CFGR2_TIM17_Msk
#define GTZC_TZSC1_SECCFGR2_SAI1_Pos            GTZC_CFGR2_SAI1_Pos
#define GTZC_TZSC1_SECCFGR2_SAI1_Msk            GTZC_CFGR2_SAI1_Msk
#define GTZC_TZSC1_SECCFGR1_TIM12_Pos           GTZC_CFGR2_TIM12_Pos
#define GTZC_TZSC1_SECCFGR1_TIM12_Msk           GTZC_CFGR2_TIM12_Msk
#define GTZC_TZSC1_SECCFGR2_USB_Pos             GTZC_CFGR2_USB_Pos
#define GTZC_TZSC1_SECCFGR2_USB_Msk             GTZC_CFGR2_USB_Msk
#define GTZC_TZSC1_SECCFGR2_I3C2_Pos            GTZC_CFGR2_I3C2_Pos
#define GTZC_TZSC1_SECCFGR2_I3C2_Msk            GTZC_CFGR2_I3C2_Msk
#define GTZC_TZSC1_SECCFGR2_LPUART1_Pos         GTZC_CFGR2_LPUART1_Pos
#define GTZC_TZSC1_SECCFGR2_LPUART1_Msk         GTZC_CFGR2_LPUART1_Msk
#define GTZC_TZSC1_SECCFGR2_I2C3_Pos            GTZC_CFGR2_I2C3_Pos
#define GTZC_TZSC1_SECCFGR2_I2C3_Msk            GTZC_CFGR2_I2C3_Msk
#define GTZC_TZSC1_SECCFGR2_LPTIM1_Pos          GTZC_CFGR2_LPTIM1_Pos
#define GTZC_TZSC1_SECCFGR2_LPTIM1_Msk          GTZC_CFGR2_LPTIM1_Msk
#define GTZC_TZSC1_SECCFGR2_LPTIM3_Pos          GTZC_CFGR2_LPTIM3_Pos
#define GTZC_TZSC1_SECCFGR2_LPTIM3_Msk          GTZC_CFGR2_LPTIM3_Msk
#define GTZC_TZSC1_SECCFGR2_LPTIM4_Pos          GTZC_CFGR2_LPTIM4_Pos
#define GTZC_TZSC1_SECCFGR2_LPTIM4_Msk          GTZC_CFGR2_LPTIM4_Msk
#define GTZC_TZSC1_SECCFGR2_COMP_Pos            GTZC_CFGR2_COMP_Pos
#define GTZC_TZSC1_SECCFGR2_COMP_Msk            GTZC_CFGR2_COMP_Msk

/*******************  Bits definition for GTZC_TZSC1_SECCFGR3 register  ***************/
#define GTZC_TZSC1_SECCFGR3_CRC_Pos             GTZC_CFGR3_CRC_Pos
#define GTZC_TZSC1_SECCFGR3_CRC_Msk             GTZC_CFGR3_CRC_Msk
#define GTZC_TZSC1_SECCFGR3_TSC_Pos             GTZC_CFGR3_TSC_Pos
#define GTZC_TZSC1_SECCFGR3_TSC_Msk             GTZC_CFGR3_TSC_Msk
#define GTZC_TZSC1_SECCFGR3_ICACHE_REG_Pos      GTZC_CFGR3_ICACHE_REG_Pos
#define GTZC_TZSC1_SECCFGR3_ICACHE_REG_Msk      GTZC_CFGR3_ICACHE_REG_Msk
#define GTZC_TZSC1_SECCFGR3_ADC12_Pos           GTZC_CFGR3_ADC12_Pos
#define GTZC_TZSC1_SECCFGR3_ADC12_Msk           GTZC_CFGR3_ADC12_Msk
#define GTZC_TZSC1_SECCFGR3_HASH_Pos            GTZC_CFGR3_HASH_Pos
#define GTZC_TZSC1_SECCFGR3_HASH_Msk            GTZC_CFGR3_HASH_Msk
#define GTZC_TZSC1_SECCFGR3_RNG_Pos             GTZC_CFGR3_RNG_Pos
#define GTZC_TZSC1_SECCFGR3_RNG_Msk             GTZC_CFGR3_RNG_Msk
#define GTZC_TZSC1_SECCFGR3_SDMMC1_Pos          GTZC_CFGR3_SDMMC1_Pos
#define GTZC_TZSC1_SECCFGR3_SDMMC1_Msk          GTZC_CFGR3_SDMMC1_Msk
#define GTZC_TZSC1_SECCFGR3_OCTOSPI1_REG_Pos    GTZC_CFGR3_OCTOSPI1_REG_Pos
#define GTZC_TZSC1_SECCFGR3_OCTOSPI1_REG_Msk    GTZC_CFGR3_OCTOSPI1_REG_Msk
#define GTZC_TZSC1_SECCFGR3_RAMCFG_Pos          GTZC_CFGR3_RAMCFG_Pos
#define GTZC_TZSC1_SECCFGR3_RAMCFG_Msk          GTZC_CFGR3_RAMCFG_Msk
#define GTZC_TZSC1_SECCFGR3_DAC1_Pos            GTZC_CFGR3_DAC1_Pos
#define GTZC_TZSC1_SECCFGR3_DAC1_Msk            GTZC_CFGR3_DAC1_Msk
#define GTZC_TZSC1_SECCFGR3_ADF1_Pos            GTZC_CFGR3_ADF1_Pos
#define GTZC_TZSC1_SECCFGR3_ADF1_Msk            GTZC_CFGR3_ADF1_Msk
#define GTZC_TZSC1_SECCFGR1_HSP1_Pos            GTZC_CFGR3_HSP1_Pos
#define GTZC_TZSC1_SECCFGR1_HSP1_Msk            GTZC_CFGR3_HSP1_Msk

/*******************  Bits definition for GTZC_TZSC1_PRIVCFGR1 register  ***************/
#define GTZC_TZSC1_PRIVCFGR1_TIM2_Pos           GTZC_CFGR1_TIM2_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM2_Msk           GTZC_CFGR1_TIM2_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM3_Pos           GTZC_CFGR1_TIM3_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM3_Msk           GTZC_CFGR1_TIM3_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM4_Pos           GTZC_CFGR1_TIM4_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM4_Msk           GTZC_CFGR1_TIM4_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM5_Pos           GTZC_CFGR1_TIM5_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM5_Msk           GTZC_CFGR1_TIM5_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM6_Pos           GTZC_CFGR1_TIM6_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM6_Msk           GTZC_CFGR1_TIM6_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM7_Pos           GTZC_CFGR1_TIM7_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM7_Msk           GTZC_CFGR1_TIM7_Msk
#define GTZC_TZSC1_PRIVCFGR1_WWDG_Pos           GTZC_CFGR1_WWDG_Pos
#define GTZC_TZSC1_PRIVCFGR1_WWDG_Msk           GTZC_CFGR1_WWDG_Msk
#define GTZC_TZSC1_PRIVCFGR1_IWDG_Pos           GTZC_CFGR1_IWDG_Pos
#define GTZC_TZSC1_PRIVCFGR1_IWDG_Msk           GTZC_CFGR1_IWDG_Msk
#define GTZC_TZSC1_PRIVCFGR1_SPI2_Pos           GTZC_CFGR1_SPI2_Pos
#define GTZC_TZSC1_PRIVCFGR1_SPI2_Msk           GTZC_CFGR1_SPI2_Msk
#define GTZC_TZSC1_PRIVCFGR1_USART2_Pos         GTZC_CFGR1_USART2_Pos
#define GTZC_TZSC1_PRIVCFGR1_USART2_Msk         GTZC_CFGR1_USART2_Msk
#define GTZC_TZSC1_PRIVCFGR1_USART3_Pos         GTZC_CFGR1_USART3_Pos
#define GTZC_TZSC1_PRIVCFGR1_USART3_Msk         GTZC_CFGR1_USART3_Msk
#define GTZC_TZSC1_PRIVCFGR1_UART4_Pos          GTZC_CFGR1_UART4_Pos
#define GTZC_TZSC1_PRIVCFGR1_UART4_Msk          GTZC_CFGR1_UART4_Msk
#define GTZC_TZSC1_PRIVCFGR1_UART5_Pos          GTZC_CFGR1_UART5_Pos
#define GTZC_TZSC1_PRIVCFGR1_UART5_Msk          GTZC_CFGR1_UART5_Msk
#define GTZC_TZSC1_PRIVCFGR1_I2C1_Pos           GTZC_CFGR1_I2C1_Pos
#define GTZC_TZSC1_PRIVCFGR1_I2C1_Msk           GTZC_CFGR1_I2C1_Msk
#define GTZC_TZSC1_PRIVCFGR1_I2C2_Pos           GTZC_CFGR1_I2C2_Pos
#define GTZC_TZSC1_PRIVCFGR1_I2C2_Msk           GTZC_CFGR1_I2C2_Msk
#define GTZC_TZSC1_PRIVCFGR1_CRS_Pos            GTZC_CFGR1_CRS_Pos
#define GTZC_TZSC1_PRIVCFGR1_CRS_Msk            GTZC_CFGR1_CRS_Msk
#define GTZC_TZSC1_PRIVCFGR1_I2C4_Pos           GTZC_CFGR1_I2C4_Pos
#define GTZC_TZSC1_PRIVCFGR1_I2C4_Msk           GTZC_CFGR1_I2C4_Msk
#define GTZC_TZSC1_PRIVCFGR1_LPTIM2_Pos         GTZC_CFGR1_LPTIM2_Pos
#define GTZC_TZSC1_PRIVCFGR1_LPTIM2_Msk         GTZC_CFGR1_LPTIM2_Msk
#define GTZC_TZSC1_PRIVCFGR1_FDCAN1_Pos         GTZC_CFGR1_FDCAN1_Pos
#define GTZC_TZSC1_PRIVCFGR1_FDCAN1_Msk         GTZC_CFGR1_FDCAN1_Msk
#define GTZC_TZSC1_PRIVCFGR1_FDCAN2_Pos         GTZC_CFGR1_FDCAN2_Pos
#define GTZC_TZSC1_PRIVCFGR1_FDCAN2_Msk         GTZC_CFGR1_FDCAN2_Msk
#define GTZC_TZSC1_PRIVCFGR1_SPI3_Pos           GTZC_CFGR1_SPI3_Pos
#define GTZC_TZSC1_PRIVCFGR1_SPI3_Msk           GTZC_CFGR1_SPI3_Msk
#define GTZC_TZSC1_PRIVCFGR1_I3C1_Pos           GTZC_CFGR1_I3C1_Pos
#define GTZC_TZSC1_PRIVCFGR1_I3C1_Msk           GTZC_CFGR1_I3C1_Msk
#define GTZC_TZSC1_PRIVCFGR1_OPAMP_Pos          GTZC_CFGR1_OPAMP_Pos
#define GTZC_TZSC1_PRIVCFGR1_OPAMP_Msk          GTZC_CFGR1_OPAMP_Msk
#define GTZC_TZSC1_PRIVCFGR1_VREFBUF_Pos        GTZC_CFGR1_VREFBUF_Pos
#define GTZC_TZSC1_PRIVCFGR1_VREFBUF_Msk        GTZC_CFGR1_VREFBUF_Msk
#define GTZC_TZSC1_PRIVCFGR1_SPI4_Pos           GTZC_CFGR1_SPI4_Pos
#define GTZC_TZSC1_PRIVCFGR1_SPI4_Msk           GTZC_CFGR1_SPI4_Msk

/*******************  Bits definition for GTZC_TZSC1_PRIVCFGR2 register  ***************/
#define GTZC_TZSC1_PRIVCFGR2_TIM1_Pos           GTZC_CFGR2_TIM1_Pos
#define GTZC_TZSC1_PRIVCFGR2_TIM1_Msk           GTZC_CFGR2_TIM1_Msk
#define GTZC_TZSC1_PRIVCFGR2_SPI1_Pos           GTZC_CFGR2_SPI1_Pos
#define GTZC_TZSC1_PRIVCFGR2_SPI1_Msk           GTZC_CFGR2_SPI1_Msk
#define GTZC_TZSC1_PRIVCFGR1_TIM8_Pos           GTZC_CFGR2_TIM8_Pos
#define GTZC_TZSC1_PRIVCFGR1_TIM8_Msk           GTZC_CFGR2_TIM8_Msk
#define GTZC_TZSC1_PRIVCFGR2_USART1_Pos         GTZC_CFGR2_USART1_Pos
#define GTZC_TZSC1_PRIVCFGR2_USART1_Msk         GTZC_CFGR2_USART1_Msk
#define GTZC_TZSC1_PRIVCFGR2_TIM15_Pos          GTZC_CFGR2_TIM15_Pos
#define GTZC_TZSC1_PRIVCFGR2_TIM15_Msk          GTZC_CFGR2_TIM15_Msk
#define GTZC_TZSC1_PRIVCFGR2_TIM16_Pos          GTZC_CFGR2_TIM16_Pos
#define GTZC_TZSC1_PRIVCFGR2_TIM16_Msk          GTZC_CFGR2_TIM16_Msk
#define GTZC_TZSC1_PRIVCFGR2_TIM17_Pos          GTZC_CFGR2_TIM17_Pos
#define GTZC_TZSC1_PRIVCFGR2_TIM17_Msk          GTZC_CFGR2_TIM17_Msk
#define GTZC_TZSC1_PRIVCFGR2_SAI1_Pos           GTZC_CFGR2_SAI1_Pos
#define GTZC_TZSC1_PRIVCFGR2_SAI1_Msk           GTZC_CFGR2_SAI1_Msk
#define GTZC_TZSC1_PRIVCFGR2_TIM12_Pos          GTZC_CFGR2_TIM12_Pos
#define GTZC_TZSC1_PRIVCFGR2_TIM12_Msk          GTZC_CFGR2_TIM12_Msk
#define GTZC_TZSC1_PRIVCFGR2_USB_Pos            GTZC_CFGR2_USB_Pos
#define GTZC_TZSC1_PRIVCFGR2_USB_Msk            GTZC_CFGR2_USB_Msk
#define GTZC_TZSC1_PRIVCFGR2_I3C2_Pos           GTZC_CFGR2_I3C2_Pos
#define GTZC_TZSC1_PRIVCFGR2_I3C2_Msk           GTZC_CFGR2_I3C2_Msk
#define GTZC_TZSC1_PRIVCFGR2_LPUART1_Pos        GTZC_CFGR2_LPUART1_Pos
#define GTZC_TZSC1_PRIVCFGR2_LPUART1_Msk        GTZC_CFGR2_LPUART1_Msk
#define GTZC_TZSC1_PRIVCFGR2_I2C3_Pos           GTZC_CFGR2_I2C3_Pos
#define GTZC_TZSC1_PRIVCFGR2_I2C3_Msk           GTZC_CFGR2_I2C3_Msk
#define GTZC_TZSC1_PRIVCFGR2_LPTIM1_Pos         GTZC_CFGR2_LPTIM1_Pos
#define GTZC_TZSC1_PRIVCFGR2_LPTIM1_Msk         GTZC_CFGR2_LPTIM1_Msk
#define GTZC_TZSC1_PRIVCFGR2_LPTIM3_Pos         GTZC_CFGR2_LPTIM3_Pos
#define GTZC_TZSC1_PRIVCFGR2_LPTIM3_Msk         GTZC_CFGR2_LPTIM3_Msk
#define GTZC_TZSC1_PRIVCFGR2_LPTIM4_Pos         GTZC_CFGR2_LPTIM4_Pos
#define GTZC_TZSC1_PRIVCFGR2_LPTIM4_Msk         GTZC_CFGR2_LPTIM4_Msk
#define GTZC_TZSC1_PRIVCFGR2_COMP_Pos           GTZC_CFGR2_COMP_Pos
#define GTZC_TZSC1_PRIVCFGR2_COMP_Msk           GTZC_CFGR2_COMP_Msk

/*******************  Bits definition for GTZC_TZSC1_PRIVCFGR3 register  ***************/
#define GTZC_TZSC1_PRIVCFGR3_CRC_Pos            GTZC_CFGR3_CRC_Pos
#define GTZC_TZSC1_PRIVCFGR3_CRC_Msk            GTZC_CFGR3_CRC_Msk
#define GTZC_TZSC1_PRIVCFGR3_TSC_Pos            GTZC_CFGR3_TSC_Pos
#define GTZC_TZSC1_PRIVCFGR3_TSC_Msk            GTZC_CFGR3_TSC_Msk
#define GTZC_TZSC1_PRIVCFGR3_ICACHE_REG_Pos     GTZC_CFGR3_ICACHE_REG_Pos
#define GTZC_TZSC1_PRIVCFGR3_ICACHE_REG_Msk     GTZC_CFGR3_ICACHE_REG_Msk
#define GTZC_TZSC1_PRIVCFGR3_ADC12_Pos          GTZC_CFGR3_ADC12_Pos
#define GTZC_TZSC1_PRIVCFGR3_ADC12_Msk          GTZC_CFGR3_ADC12_Msk
#define GTZC_TZSC1_PRIVCFGR3_HASH_Pos           GTZC_CFGR3_HASH_Pos
#define GTZC_TZSC1_PRIVCFGR3_HASH_Msk           GTZC_CFGR3_HASH_Msk
#define GTZC_TZSC1_PRIVCFGR3_RNG_Pos            GTZC_CFGR3_RNG_Pos
#define GTZC_TZSC1_PRIVCFGR3_RNG_Msk            GTZC_CFGR3_RNG_Msk
#define GTZC_TZSC1_PRIVCFGR3_SDMMC1_Pos         GTZC_CFGR3_SDMMC1_Pos
#define GTZC_TZSC1_PRIVCFGR3_SDMMC1_Msk         GTZC_CFGR3_SDMMC1_Msk
#define GTZC_TZSC1_PRIVCFGR3_OCTOSPI1_REG_Pos   GTZC_CFGR3_OCTOSPI1_REG_Pos
#define GTZC_TZSC1_PRIVCFGR3_OCTOSPI1_REG_Msk   GTZC_CFGR3_OCTOSPI1_REG_Msk
#define GTZC_TZSC1_PRIVCFGR3_RAMCFG_Pos         GTZC_CFGR3_RAMCFG_Pos
#define GTZC_TZSC1_PRIVCFGR3_RAMCFG_Msk         GTZC_CFGR3_RAMCFG_Msk
#define GTZC_TZSC1_PRIVCFGR3_DAC1_Pos           GTZC_CFGR3_DAC1_Pos
#define GTZC_TZSC1_PRIVCFGR3_DAC1_Msk           GTZC_CFGR3_DAC1_Msk
#define GTZC_TZSC1_PRIVCFGR3_ADF1_Pos           GTZC_CFGR3_ADF1_Pos
#define GTZC_TZSC1_PRIVCFGR3_ADF1_Msk           GTZC_CFGR3_ADF1_Msk
#define GTZC_TZSC1_PRIVCFGR3_HSP1_Pos           GTZC_CFGR3_HSP1_Pos
#define GTZC_TZSC1_PRIVCFGR3_HSP1_Msk           GTZC_CFGR3_HSP1_Msk

/*******************  Bits definition for GTZC_TZIC1_IER1 register  ***************/
#define GTZC_TZIC1_IER1_TIM2_Pos                GTZC_CFGR1_TIM2_Pos
#define GTZC_TZIC1_IER1_TIM2_Msk                GTZC_CFGR1_TIM2_Msk
#define GTZC_TZIC1_IER1_TIM3_Pos                GTZC_CFGR1_TIM3_Pos
#define GTZC_TZIC1_IER1_TIM3_Msk                GTZC_CFGR1_TIM3_Msk
#define GTZC_TZIC1_IER1_TIM4_Pos                GTZC_CFGR1_TIM4_Pos
#define GTZC_TZIC1_IER1_TIM4_Msk                GTZC_CFGR1_TIM4_Msk
#define GTZC_TZIC1_IER1_TIM5_Pos                GTZC_CFGR1_TIM5_Pos
#define GTZC_TZIC1_IER1_TIM5_Msk                GTZC_CFGR1_TIM5_Msk
#define GTZC_TZIC1_IER1_TIM6_Pos                GTZC_CFGR1_TIM6_Pos
#define GTZC_TZIC1_IER1_TIM6_Msk                GTZC_CFGR1_TIM6_Msk
#define GTZC_TZIC1_IER1_TIM7_Pos                GTZC_CFGR1_TIM7_Pos
#define GTZC_TZIC1_IER1_TIM7_Msk                GTZC_CFGR1_TIM7_Msk
#define GTZC_TZIC1_IER1_WWDG_Pos                GTZC_CFGR1_WWDG_Pos
#define GTZC_TZIC1_IER1_WWDG_Msk                GTZC_CFGR1_WWDG_Msk
#define GTZC_TZIC1_IER1_IWDG_Pos                GTZC_CFGR1_IWDG_Pos
#define GTZC_TZIC1_IER1_IWDG_Msk                GTZC_CFGR1_IWDG_Msk
#define GTZC_TZIC1_IER1_SPI2_Pos                GTZC_CFGR1_SPI2_Pos
#define GTZC_TZIC1_IER1_SPI2_Msk                GTZC_CFGR1_SPI2_Msk
#define GTZC_TZSC1_IER1_USART2_Pos              GTZC_CFGR1_USART2_Pos
#define GTZC_TZSC1_IER1_USART2_Msk              GTZC_CFGR1_USART2_Msk
#define GTZC_TZIC1_IER1_USART3_Pos              GTZC_CFGR1_USART3_Pos
#define GTZC_TZIC1_IER1_USART3_Msk              GTZC_CFGR1_USART3_Msk
#define GTZC_TZIC1_IER1_UART4_Pos               GTZC_CFGR1_UART4_Pos
#define GTZC_TZIC1_IER1_UART4_Msk               GTZC_CFGR1_UART4_Msk
#define GTZC_TZIC1_IER1_UART5_Pos               GTZC_CFGR1_UART5_Pos
#define GTZC_TZIC1_IER1_UART5_Msk               GTZC_CFGR1_UART5_Msk
#define GTZC_TZIC1_IER1_I2C1_Pos                GTZC_CFGR1_I2C1_Pos
#define GTZC_TZIC1_IER1_I2C1_Msk                GTZC_CFGR1_I2C1_Msk
#define GTZC_TZIC1_IER1_I2C2_Pos                GTZC_CFGR1_I2C2_Pos
#define GTZC_TZIC1_IER1_I2C2_Msk                GTZC_CFGR1_I2C2_Msk
#define GTZC_TZIC1_IER1_CRS_Pos                 GTZC_CFGR1_CRS_Pos
#define GTZC_TZIC1_IER1_CRS_Msk                 GTZC_CFGR1_CRS_Msk
#define GTZC_TZSC1_IER1_I2C4_Pos                GTZC_CFGR1_I2C4_Pos
#define GTZC_TZSC1_IER1_I2C4_Msk                GTZC_CFGR1_I2C4_Msk
#define GTZC_TZIC1_IER1_LPTIM2_Pos              GTZC_CFGR1_LPTIM2_Pos
#define GTZC_TZIC1_IER1_LPTIM2_Msk              GTZC_CFGR1_LPTIM2_Msk
#define GTZC_TZIC1_IER1_FDCAN1_Pos              GTZC_CFGR1_FDCAN1_Pos
#define GTZC_TZIC1_IER1_FDCAN1_Msk              GTZC_CFGR1_FDCAN1_Msk
#define GTZC_TZIC1_IER1_FDCAN2_Pos              GTZC_CFGR1_FDCAN2_Pos
#define GTZC_TZIC1_IER1_FDCAN2_Msk              GTZC_CFGR1_FDCAN2_Msk
#define GTZC_TZIC1_IER1_SPI3_Pos                GTZC_CFGR1_SPI3_Pos
#define GTZC_TZIC1_IER1_SPI3_Msk                GTZC_CFGR1_SPI3_Msk
#define GTZC_TZIC1_IER1_I3C1_Pos                GTZC_CFGR1_I3C1_Pos
#define GTZC_TZIC1_IER1_I3C1_Msk                GTZC_CFGR1_I3C1_Msk
#define GTZC_TZIC1_IER1_OPAMP_Pos               GTZC_CFGR1_OPAMP_Pos
#define GTZC_TZIC1_IER1_OPAMP_Msk               GTZC_CFGR1_OPAMP_Msk
#define GTZC_TZIC1_IER1_VREFBUF_Pos             GTZC_CFGR1_VREFBUF_Pos
#define GTZC_TZIC1_IER1_VREFBUF_Msk             GTZC_CFGR1_VREFBUF_Msk
#define GTZC_TZSC1_IER1_SPI4_Pos                GTZC_CFGR1_SPI4_Pos
#define GTZC_TZSC1_IER1_SPI4_Msk                GTZC_CFGR1_SPI4_Msk

/*******************  Bits definition for GTZC_TZIC1_IER2 register  ***************/
#define GTZC_TZIC1_IER2_TIM1_Pos                GTZC_CFGR2_TIM1_Pos
#define GTZC_TZIC1_IER2_TIM1_Msk                GTZC_CFGR2_TIM1_Msk
#define GTZC_TZIC1_IER2_SPI1_Pos                GTZC_CFGR2_SPI1_Pos
#define GTZC_TZIC1_IER2_SPI1_Msk                GTZC_CFGR2_SPI1_Msk
#define GTZC_TZSC1_IER2_TIM8_Pos                GTZC_CFGR2_TIM8_Pos
#define GTZC_TZSC1_IER2_TIM8_Msk                GTZC_CFGR2_TIM8_Msk
#define GTZC_TZIC1_IER2_USART1_Pos              GTZC_CFGR2_USART1_Pos
#define GTZC_TZIC1_IER2_USART1_Msk              GTZC_CFGR2_USART1_Msk
#define GTZC_TZIC1_IER2_TIM15_Pos               GTZC_CFGR2_TIM15_Pos
#define GTZC_TZIC1_IER2_TIM15_Msk               GTZC_CFGR2_TIM15_Msk
#define GTZC_TZIC1_IER2_TIM16_Pos               GTZC_CFGR2_TIM16_Pos
#define GTZC_TZIC1_IER2_TIM16_Msk               GTZC_CFGR2_TIM16_Msk
#define GTZC_TZIC1_IER2_TIM17_Pos               GTZC_CFGR2_TIM17_Pos
#define GTZC_TZIC1_IER2_TIM17_Msk               GTZC_CFGR2_TIM17_Msk
#define GTZC_TZIC1_IER2_SAI1_Pos                GTZC_CFGR2_SAI1_Pos
#define GTZC_TZIC1_IER2_SAI1_Msk                GTZC_CFGR2_SAI1_Msk
#define GTZC_TZSC1_IER2_TIM12_Pos               GTZC_CFGR2_TIM12_Pos
#define GTZC_TZSC1_IER2_TIM12_Msk               GTZC_CFGR2_TIM12_Msk
#define GTZC_TZIC1_IER2_USB_Pos                 GTZC_CFGR2_USB_Pos
#define GTZC_TZIC1_IER2_USB_Msk                 GTZC_CFGR2_USB_Msk
#define GTZC_TZIC1_IER2_I3C2_Pos                GTZC_CFGR2_I3C2_Pos
#define GTZC_TZIC1_IER2_I3C2_Msk                GTZC_CFGR2_I3C2_Msk
#define GTZC_TZIC1_IER2_LPUART1_Pos             GTZC_CFGR2_LPUART1_Pos
#define GTZC_TZIC1_IER2_LPUART1_Msk             GTZC_CFGR2_LPUART1_Msk
#define GTZC_TZIC1_IER2_I2C3_Pos                GTZC_CFGR2_I2C3_Pos
#define GTZC_TZIC1_IER2_I2C3_Msk                GTZC_CFGR2_I2C3_Msk
#define GTZC_TZIC1_IER2_LPTIM1_Pos              GTZC_CFGR2_LPTIM1_Pos
#define GTZC_TZIC1_IER2_LPTIM1_Msk              GTZC_CFGR2_LPTIM1_Msk
#define GTZC_TZIC1_IER2_LPTIM3_Pos              GTZC_CFGR2_LPTIM3_Pos
#define GTZC_TZIC1_IER2_LPTIM3_Msk              GTZC_CFGR2_LPTIM3_Msk
#define GTZC_TZIC1_IER2_LPTIM4_Pos              GTZC_CFGR2_LPTIM4_Pos
#define GTZC_TZIC1_IER2_LPTIM4_Msk              GTZC_CFGR2_LPTIM4_Msk
#define GTZC_TZIC1_IER2_COMP_Pos                GTZC_CFGR2_COMP_Pos
#define GTZC_TZIC1_IER2_COMP_Msk                GTZC_CFGR2_COMP_Msk

/*******************  Bits definition for GTZC_TZIC1_IER3 register  ***************/
#define GTZC_TZIC1_IER3_CRC_Pos                 GTZC_CFGR3_CRC_Pos
#define GTZC_TZIC1_IER3_CRC_Msk                 GTZC_CFGR3_CRC_Msk
#define GTZC_TZIC1_IER3_TSC_Pos                 GTZC_CFGR3_TSC_Pos
#define GTZC_TZIC1_IER3_TSC_Msk                 GTZC_CFGR3_TSC_Msk
#define GTZC_TZIC1_IER3_ICACHE_REG_Pos          GTZC_CFGR3_ICACHE_REG_Pos
#define GTZC_TZIC1_IER3_ICACHE_REG_Msk          GTZC_CFGR3_ICACHE_REG_Msk
#define GTZC_TZIC1_IER3_ADC12_Pos               GTZC_CFGR3_ADC12_Pos
#define GTZC_TZIC1_IER3_ADC12_Msk               GTZC_CFGR3_ADC12_Msk
#define GTZC_TZIC1_IER3_HASH_Pos                GTZC_CFGR3_HASH_Pos
#define GTZC_TZIC1_IER3_HASH_Msk                GTZC_CFGR3_HASH_Msk
#define GTZC_TZIC1_IER3_RNG_Pos                 GTZC_CFGR3_RNG_Pos
#define GTZC_TZIC1_IER3_RNG_Msk                 GTZC_CFGR3_RNG_Msk
#define GTZC_TZIC1_IER3_SDMMC1_Pos              GTZC_CFGR3_SDMMC1_Pos
#define GTZC_TZIC1_IER3_SDMMC1_Msk              GTZC_CFGR3_SDMMC1_Msk
#define GTZC_TZIC1_IER3_OCTOSPI1_REG_Pos        GTZC_CFGR3_OCTOSPI1_REG_Pos
#define GTZC_TZIC1_IER3_OCTOSPI1_REG_Msk        GTZC_CFGR3_OCTOSPI1_REG_Msk
#define GTZC_TZIC1_IER3_RAMCFG_Pos              GTZC_CFGR3_RAMCFG_Pos
#define GTZC_TZIC1_IER3_RAMCFG_Msk              GTZC_CFGR3_RAMCFG_Msk
#define GTZC_TZIC1_IER3_DAC1_Pos                GTZC_CFGR3_DAC1_Pos
#define GTZC_TZIC1_IER3_DAC1_Msk                GTZC_CFGR3_DAC1_Msk
#define GTZC_TZIC1_IER3_ADF1_Pos                GTZC_CFGR3_ADF1_Pos
#define GTZC_TZIC1_IER3_ADF1_Msk                GTZC_CFGR3_ADF1_Msk
#define GTZC_TZSC1_IER3_HSP1_Pos                GTZC_CFGR3_HSP1_Pos
#define GTZC_TZSC1_IER3_HSP1_Msk                GTZC_CFGR3_HSP1_Msk

/*******************  Bits definition for GTZC_TZIC1_IER4 register  ***************/
#define GTZC_TZIC1_IER4_GPDMA1_Pos              GTZC_CFGR4_GPDMA1_Pos
#define GTZC_TZIC1_IER4_GPDMA1_Msk              GTZC_CFGR4_GPDMA1_Msk
#define GTZC_TZIC1_IER4_FLASH_REG_Pos           GTZC_CFGR4_FLASH_REG_Pos
#define GTZC_TZIC1_IER4_FLASH_REG_Msk           GTZC_CFGR4_FLASH_REG_Msk
#define GTZC_TZIC1_IER4_FLASH_Pos               GTZC_CFGR4_FLASH_Pos
#define GTZC_TZIC1_IER4_FLASH_Msk               GTZC_CFGR4_FLASH_Msk
#define GTZC_TZIC1_IER4_PWR_Pos                 GTZC_CFGR4_PWR_Pos
#define GTZC_TZIC1_IER4_PWR_Msk                 GTZC_CFGR4_PWR_Msk
#define GTZC_TZIC1_IER4_RCC_Pos                 GTZC_CFGR4_RCC_Pos
#define GTZC_TZIC1_IER4_RCC_Msk                 GTZC_CFGR4_RCC_Msk
#define GTZC_TZIC1_IER4_SYSCFG_Pos              GTZC_CFGR4_SYSCFG_Pos
#define GTZC_TZIC1_IER4_SYSCFG_Msk              GTZC_CFGR4_SYSCFG_Msk
#define GTZC_TZIC1_IER4_EXTI_Pos                GTZC_CFGR4_EXTI_Pos
#define GTZC_TZIC1_IER4_EXTI_Msk                GTZC_CFGR4_EXTI_Msk
#define GTZC_TZIC1_IER4_RTC_Pos                 GTZC_CFGR4_RTC_Pos
#define GTZC_TZIC1_IER4_RTC_Msk                 GTZC_CFGR4_RTC_Msk
#define GTZC_TZIC1_IER4_TAMP_Pos                GTZC_CFGR4_TAMP_Pos
#define GTZC_TZIC1_IER4_TAMP_Msk                GTZC_CFGR4_TAMP_Msk
#define GTZC_TZIC1_IER4_TZSC_Pos                GTZC_CFGR4_TZSC_Pos
#define GTZC_TZIC1_IER4_TZSC_Msk                GTZC_CFGR4_TZSC_Msk
#define GTZC_TZIC1_IER4_TZIC_Pos                GTZC_CFGR4_TZIC_Pos
#define GTZC_TZIC1_IER4_TZIC_Msk                GTZC_CFGR4_TZIC_Msk
#define GTZC_TZIC1_IER4_SRAM1_Pos               GTZC_CFGR4_SRAM1_Pos
#define GTZC_TZIC1_IER4_SRAM1_Msk               GTZC_CFGR4_SRAM1_Msk
#define GTZC_TZIC1_IER4_MPCBB1_REG_Pos          GTZC_CFGR4_MPCBB1_REG_Pos
#define GTZC_TZIC1_IER4_MPCBB1_REG_Msk          GTZC_CFGR4_MPCBB1_REG_Msk
#define GTZC_TZIC1_IER4_SRAM2_Pos               GTZC_CFGR4_SRAM2_Pos
#define GTZC_TZIC1_IER4_SRAM2_Msk               GTZC_CFGR4_SRAM2_Msk
#define GTZC_TZIC1_IER4_MPCBB2_REG_Pos          GTZC_CFGR4_MPCBB2_REG_Pos
#define GTZC_TZIC1_IER4_MPCBB2_REG_Msk          GTZC_CFGR4_MPCBB2_REG_Msk
#define GTZC_TZIC1_IER4_SRAM3_Pos               GTZC_CFGR4_SRAM3_Pos
#define GTZC_TZIC1_IER4_SRAM3_Msk               GTZC_CFGR4_SRAM3_Msk
#define GTZC_TZIC1_IER4_MPCBB3_REG_Pos          GTZC_CFGR4_MPCBB3_REG_Pos
#define GTZC_TZIC1_IER4_MPCBB3_REG_Msk          GTZC_CFGR4_MPCBB3_REG_Msk
#define GTZC_TZIC1_IER4_SRAM4_Pos               GTZC_CFGR4_SRAM4_Pos
#define GTZC_TZIC1_IER4_SRAM4_Msk               GTZC_CFGR4_SRAM4_Msk
#define GTZC_TZIC1_IER4_MPCBB4_REG_Pos          GTZC_CFGR4_MPCBB4_REG_Pos
#define GTZC_TZIC1_IER4_MPCBB4_REG_Msk          GTZC_CFGR4_MPCBB4_REG_Msk

/*******************  Bits definition for GTZC_TZIC1_SR1 register  ***************/
#define GTZC_TZIC1_SR1_TIM2_Pos                 GTZC_CFGR1_TIM2_Pos
#define GTZC_TZIC1_SR1_TIM2_Msk                 GTZC_CFGR1_TIM2_Msk
#define GTZC_TZIC1_SR1_TIM3_Pos                 GTZC_CFGR1_TIM3_Pos
#define GTZC_TZIC1_SR1_TIM3_Msk                 GTZC_CFGR1_TIM3_Msk
#define GTZC_TZIC1_SR1_TIM4_Pos                 GTZC_CFGR1_TIM4_Pos
#define GTZC_TZIC1_SR1_TIM4_Msk                 GTZC_CFGR1_TIM4_Msk
#define GTZC_TZIC1_SR1_TIM5_Pos                 GTZC_CFGR1_TIM5_Pos
#define GTZC_TZIC1_SR1_TIM5_Msk                 GTZC_CFGR1_TIM5_Msk
#define GTZC_TZIC1_SR1_TIM6_Pos                 GTZC_CFGR1_TIM6_Pos
#define GTZC_TZIC1_SR1_TIM6_Msk                 GTZC_CFGR1_TIM6_Msk
#define GTZC_TZIC1_SR1_TIM7_Pos                 GTZC_CFGR1_TIM7_Pos
#define GTZC_TZIC1_SR1_TIM7_Msk                 GTZC_CFGR1_TIM7_Msk
#define GTZC_TZIC1_SR1_WWDG_Pos                 GTZC_CFGR1_WWDG_Pos
#define GTZC_TZIC1_SR1_WWDG_Msk                 GTZC_CFGR1_WWDG_Msk
#define GTZC_TZIC1_SR1_IWDG_Pos                 GTZC_CFGR1_IWDG_Pos
#define GTZC_TZIC1_SR1_IWDG_Msk                 GTZC_CFGR1_IWDG_Msk
#define GTZC_TZIC1_SR1_SPI2_Pos                 GTZC_CFGR1_SPI2_Pos
#define GTZC_TZIC1_SR1_SPI2_Msk                 GTZC_CFGR1_SPI2_Msk
#define GTZC_TZIC1_SR1_USART2_Pos               GTZC_CFGR1_USART2_Pos
#define GTZC_TZIC1_SR1_USART2_Msk               GTZC_CFGR1_USART2_Msk
#define GTZC_TZIC1_SR1_USART3_Pos               GTZC_CFGR1_USART3_Pos
#define GTZC_TZIC1_SR1_USART3_Msk               GTZC_CFGR1_USART3_Msk
#define GTZC_TZIC1_SR1_UART4_Pos                GTZC_CFGR1_UART4_Pos
#define GTZC_TZIC1_SR1_UART4_Msk                GTZC_CFGR1_UART4_Msk
#define GTZC_TZIC1_SR1_UART5_Pos                GTZC_CFGR1_UART5_Pos
#define GTZC_TZIC1_SR1_UART5_Msk                GTZC_CFGR1_UART5_Msk
#define GTZC_TZIC1_SR1_I2C1_Pos                 GTZC_CFGR1_I2C1_Pos
#define GTZC_TZIC1_SR1_I2C1_Msk                 GTZC_CFGR1_I2C1_Msk
#define GTZC_TZIC1_SR1_I2C2_Pos                 GTZC_CFGR1_I2C2_Pos
#define GTZC_TZIC1_SR1_I2C2_Msk                 GTZC_CFGR1_I2C2_Msk
#define GTZC_TZIC1_SR1_CRS_Pos                  GTZC_CFGR1_CRS_Pos
#define GTZC_TZIC1_SR1_CRS_Msk                  GTZC_CFGR1_CRS_Msk
#define GTZC_TZIC1_SR1_I2C4_Pos                 GTZC_CFGR1_I2C4_Pos
#define GTZC_TZIC1_SR1_I2C4_Msk                 GTZC_CFGR1_I2C4_Msk
#define GTZC_TZIC1_SR1_LPTIM2_Pos               GTZC_CFGR1_LPTIM2_Pos
#define GTZC_TZIC1_SR1_LPTIM2_Msk               GTZC_CFGR1_LPTIM2_Msk
#define GTZC_TZIC1_SR1_FDCAN1_Pos               GTZC_CFGR1_FDCAN1_Pos
#define GTZC_TZIC1_SR1_FDCAN1_Msk               GTZC_CFGR1_FDCAN1_Msk
#define GTZC_TZIC1_SR1_FDCAN2_Pos               GTZC_CFGR1_FDCAN2_Pos
#define GTZC_TZIC1_SR1_FDCAN2_Msk               GTZC_CFGR1_FDCAN2_Msk
#define GTZC_TZIC1_SR1_SPI3_Pos                 GTZC_CFGR1_SPI3_Pos
#define GTZC_TZIC1_SR1_SPI3_Msk                 GTZC_CFGR1_SPI3_Msk
#define GTZC_TZIC1_SR1_I3C1_Pos                 GTZC_CFGR1_I3C1_Pos
#define GTZC_TZIC1_SR1_I3C1_Msk                 GTZC_CFGR1_I3C1_Msk
#define GTZC_TZIC1_SR1_OPAMP_Pos                GTZC_CFGR1_OPAMP_Pos
#define GTZC_TZIC1_SR1_OPAMP_Msk                GTZC_CFGR1_OPAMP_Msk
#define GTZC_TZIC1_SR1_VREFBUF_Pos              GTZC_CFGR1_VREFBUF_Pos
#define GTZC_TZIC1_SR1_VREFBUF_Msk              GTZC_CFGR1_VREFBUF_Msk
#define GTZC_TZIC1_SR1_SPI4_Pos                 GTZC_CFGR1_SPI4_Pos
#define GTZC_TZIC1_SR1_SPI4_Msk                 GTZC_CFGR1_SPI4_Msk

/*******************  Bits definition for GTZC_TZIC1_SR2 register  ***************/
#define GTZC_TZIC1_SR2_TIM1_Pos                 GTZC_CFGR2_TIM1_Pos
#define GTZC_TZIC1_SR2_TIM1_Msk                 GTZC_CFGR2_TIM1_Msk
#define GTZC_TZIC1_SR2_SPI1_Pos                 GTZC_CFGR2_SPI1_Pos
#define GTZC_TZIC1_SR2_SPI1_Msk
#define GTZC_TZIC1_SR2_TIM8_Pos                 GTZC_CFGR2_TIM8_Pos
#define GTZC_TZIC1_SR2_TIM8_Msk                 GTZC_CFGR2_TIM8_Msk
#define GTZC_TZIC1_SR2_USART1_Pos               GTZC_CFGR2_USART1_Pos
#define GTZC_TZIC1_SR2_USART1_Msk               GTZC_CFGR2_USART1_Msk
#define GTZC_TZIC1_SR2_TIM15_Pos                GTZC_CFGR2_TIM15_Pos
#define GTZC_TZIC1_SR2_TIM15_Msk                GTZC_CFGR2_TIM15_Msk
#define GTZC_TZIC1_SR2_TIM16_Pos                GTZC_CFGR2_TIM16_Pos
#define GTZC_TZIC1_SR2_TIM16_Msk                GTZC_CFGR2_TIM16_Msk
#define GTZC_TZIC1_SR2_TIM17_Pos                GTZC_CFGR2_TIM17_Pos
#define GTZC_TZIC1_SR2_TIM17_Msk                GTZC_CFGR2_TIM17_Msk
#define GTZC_TZIC1_SR2_SAI1_Pos                 GTZC_CFGR2_SAI1_Pos
#define GTZC_TZIC1_SR2_SAI1_Msk                 GTZC_CFGR2_SAI1_Msk
#define GTZC_TZIC1_SR2_TIM12_Pos                GTZC_CFGR2_TIM12_Pos
#define GTZC_TZIC1_SR2_TIM12_Msk                GTZC_CFGR2_TIM12_Msk
#define GTZC_TZIC1_SR2_USB_Pos                  GTZC_CFGR2_USB_Pos
#define GTZC_TZIC1_SR2_USB_Msk                  GTZC_CFGR2_USB_Msk
#define GTZC_TZIC1_SR2_I3C2_Pos                 GTZC_CFGR2_I3C2_Pos
#define GTZC_TZIC1_SR2_I3C2_Msk                 GTZC_CFGR2_I3C2_Msk
#define GTZC_TZIC1_SR2_LPUART1_Pos              GTZC_CFGR2_LPUART1_Pos
#define GTZC_TZIC1_SR2_LPUART1_Msk              GTZC_CFGR2_LPUART1_Msk
#define GTZC_TZIC1_SR2_I2C3_Pos                 GTZC_CFGR2_I2C3_Pos
#define GTZC_TZIC1_SR2_I2C3_Msk                 GTZC_CFGR2_I2C3_Msk
#define GTZC_TZIC1_SR2_LPTIM1_Pos               GTZC_CFGR2_LPTIM1_Pos
#define GTZC_TZIC1_SR2_LPTIM1_Msk               GTZC_CFGR2_LPTIM1_Msk
#define GTZC_TZIC1_SR2_LPTIM3_Pos               GTZC_CFGR2_LPTIM3_Pos
#define GTZC_TZIC1_SR2_LPTIM3_Msk               GTZC_CFGR2_LPTIM3_Msk
#define GTZC_TZIC1_SR2_LPTIM4_Pos               GTZC_CFGR2_LPTIM4_Pos
#define GTZC_TZIC1_SR2_LPTIM4_Msk               GTZC_CFGR2_LPTIM4_Msk
#define GTZC_TZIC1_SR2_COMP_Pos                 GTZC_CFGR2_COMP_Pos
#define GTZC_TZIC1_SR2_COMP_Msk                 GTZC_CFGR2_COMP_Msk

/*******************  Bits definition for GTZC_TZIC1_SR3 register  ***************/
#define GTZC_TZIC1_SR3_CRC_Pos                  GTZC_CFGR3_CRC_Pos
#define GTZC_TZIC1_SR3_CRC_Msk                  GTZC_CFGR3_CRC_Msk
#define GTZC_TZIC1_SR3_TSC_Pos                  GTZC_CFGR3_TSC_Pos
#define GTZC_TZIC1_SR3_TSC_Msk                  GTZC_CFGR3_TSC_Msk
#define GTZC_TZIC1_SR3_ICACHE_REG_Pos           GTZC_CFGR3_ICACHE_REG_Pos
#define GTZC_TZIC1_SR3_ICACHE_REG_Msk           GTZC_CFGR3_ICACHE_REG_Msk
#define GTZC_TZIC1_SR3_ADC12_Pos                GTZC_CFGR3_ADC12_Pos
#define GTZC_TZIC1_SR3_ADC12_Msk                GTZC_CFGR3_ADC12_Msk
#define GTZC_TZIC1_SR3_HASH_Pos                 GTZC_CFGR3_HASH_Pos
#define GTZC_TZIC1_SR3_HASH_Msk                 GTZC_CFGR3_HASH_Msk
#define GTZC_TZIC1_SR3_RNG_Pos                  GTZC_CFGR3_RNG_Pos
#define GTZC_TZIC1_SR3_RNG_Msk                  GTZC_CFGR3_RNG_Msk
#define GTZC_TZIC1_SR3_SDMMC1_Pos               GTZC_CFGR3_SDMMC1_Pos
#define GTZC_TZIC1_SR3_SDMMC1_Msk               GTZC_CFGR3_SDMMC1_Msk
#define GTZC_TZIC1_SR3_OCTOSPI1_REG_Pos         GTZC_CFGR3_OCTOSPI1_REG_Pos
#define GTZC_TZIC1_SR3_OCTOSPI1_REG_Msk         GTZC_CFGR3_OCTOSPI1_REG_Msk
#define GTZC_TZIC1_SR3_RAMCFG_Pos               GTZC_CFGR3_RAMCFG_Pos
#define GTZC_TZIC1_SR3_RAMCFG_Msk               GTZC_CFGR3_RAMCFG_Msk
#define GTZC_TZIC1_SR3_DAC1_Pos                 GTZC_CFGR3_DAC1_Pos
#define GTZC_TZIC1_SR3_DAC1_Msk                 GTZC_CFGR3_DAC1_Msk
#define GTZC_TZIC1_SR3_ADF1_Pos                 GTZC_CFGR3_ADF1_Pos
#define GTZC_TZIC1_SR3_ADF1_Msk                 GTZC_CFGR3_ADF1_Msk
#define GTZC_TZIC1_SR2_HSP1_Pos                 GTZC_CFGR3_TIM8_Pos
#define GTZC_TZIC1_SR2_HSP1_Msk                 GTZC_CFGR3_TIM8_Msk

/*******************  Bits definition for GTZC_TZIC1_SR4 register  ***************/
#define GTZC_TZIC1_SR4_GPDMA1_Pos               GTZC_CFGR4_GPDMA1_Pos
#define GTZC_TZIC1_SR4_GPDMA1_Msk               GTZC_CFGR4_GPDMA1_Msk
#define GTZC_TZIC1_SR4_FLASH_REG_Pos            GTZC_CFGR4_FLASH_REG_Pos
#define GTZC_TZIC1_SR4_FLASH_REG_Msk            GTZC_CFGR4_FLASH_REG_Msk
#define GTZC_TZIC1_SR4_FLASH_Pos                GTZC_CFGR4_FLASH_Pos
#define GTZC_TZIC1_SR4_FLASH_Msk                GTZC_CFGR4_FLASH_Msk
#define GTZC_TZIC1_SR4_PWR_Pos                  GTZC_CFGR4_PWR_Pos
#define GTZC_TZIC1_SR4_PWR_Msk                  GTZC_CFGR4_PWR_Msk
#define GTZC_TZIC1_SR4_RCC_Pos                  GTZC_CFGR4_RCC_Pos
#define GTZC_TZIC1_SR4_RCC_Msk                  GTZC_CFGR4_RCC_Msk
#define GTZC_TZIC1_SR4_SYSCFG_Pos               GTZC_CFGR4_SYSCFG_Pos
#define GTZC_TZIC1_SR4_SYSCFG_Msk               GTZC_CFGR4_SYSCFG_Msk
#define GTZC_TZIC1_SR4_EXTI_Pos                 GTZC_CFGR4_EXTI_Pos
#define GTZC_TZIC1_SR4_EXTI_Msk                 GTZC_CFGR4_EXTI_Msk
#define GTZC_TZIC1_SR4_RTC_Pos                  GTZC_CFGR4_RTC_Pos
#define GTZC_TZIC1_SR4_RTC_Msk                  GTZC_CFGR4_RTC_Msk
#define GTZC_TZIC1_SR4_TAMP_Pos                 GTZC_CFGR4_TAMP_Pos
#define GTZC_TZIC1_SR4_TAMP_Msk                 GTZC_CFGR4_TAMP_Msk
#define GTZC_TZIC1_SR4_TZSC_Pos                 GTZC_CFGR4_TZSC_Pos
#define GTZC_TZIC1_SR4_TZSC_Msk                 GTZC_CFGR4_TZSC_Msk
#define GTZC_TZIC1_SR4_TZIC_Pos                 GTZC_CFGR4_TZIC_Pos
#define GTZC_TZIC1_SR4_TZIC_Msk                 GTZC_CFGR4_TZIC_Msk
#define GTZC_TZIC1_SR4_SRAM1_Pos                GTZC_CFGR4_SRAM1_Pos
#define GTZC_TZIC1_SR4_SRAM1_Msk                GTZC_CFGR4_SRAM1_Msk
#define GTZC_TZIC1_SR4_MPCBB1_REG_Pos           GTZC_CFGR4_MPCBB1_REG_Pos
#define GTZC_TZIC1_SR4_MPCBB1_REG_Msk           GTZC_CFGR4_MPCBB1_REG_Msk
#define GTZC_TZIC1_SR4_SRAM2_Pos                GTZC_CFGR4_SRAM2_Pos
#define GTZC_TZIC1_SR4_SRAM2_Msk                GTZC_CFGR4_SRAM2_Msk
#define GTZC_TZIC1_SR4_MPCBB2_REG_Pos           GTZC_CFGR4_MPCBB2_REG_Pos
#define GTZC_TZIC1_SR4_MPCBB2_REG_Msk           GTZC_CFGR4_MPCBB2_REG_Msk
#define GTZC_TZIC1_SR4_SRAM3_Pos                GTZC_CFGR4_SRAM3_Pos
#define GTZC_TZIC1_SR4_SRAM3_Msk                GTZC_CFGR4_SRAM3_Msk
#define GTZC_TZIC1_SR4_MPCBB3_REG_Pos           GTZC_CFGR4_MPCBB3_REG_Pos
#define GTZC_TZIC1_SR4_MPCBB3_REG_Msk           GTZC_CFGR4_MPCBB3_REG_Msk
#define GTZC_TZIC1_SR4_SRAM4_Pos                GTZC_CFGR4_SRAM4_Pos
#define GTZC_TZIC1_SR4_SRAM4_Msk                GTZC_CFGR4_SRAM4_Msk
#define GTZC_TZIC1_SR4_MPCBB4_REG_Pos           GTZC_CFGR4_MPCBB4_REG_Pos
#define GTZC_TZIC1_SR4_MPCBB4_REG_Msk           GTZC_CFGR4_MPCBB4_REG_Msk

/******************  Bits definition for GTZC_TZIC1_FCR1 register  ***************/
#define GTZC_TZIC1_FCR1_TIM2_Pos                GTZC_CFGR1_TIM2_Pos
#define GTZC_TZIC1_FCR1_TIM2_Msk                GTZC_CFGR1_TIM2_Msk
#define GTZC_TZIC1_FCR1_TIM3_Pos                GTZC_CFGR1_TIM3_Pos
#define GTZC_TZIC1_FCR1_TIM3_Msk                GTZC_CFGR1_TIM3_Msk
#define GTZC_TZIC1_FCR1_TIM4_Pos                GTZC_CFGR1_TIM4_Pos
#define GTZC_TZIC1_FCR1_TIM4_Msk                GTZC_CFGR1_TIM4_Msk
#define GTZC_TZIC1_FCR1_TIM5_Pos                GTZC_CFGR1_TIM5_Pos
#define GTZC_TZIC1_FCR1_TIM5_Msk                GTZC_CFGR1_TIM5_Msk
#define GTZC_TZIC1_FCR1_TIM6_Pos                GTZC_CFGR1_TIM6_Pos
#define GTZC_TZIC1_FCR1_TIM6_Msk                GTZC_CFGR1_TIM6_Msk
#define GTZC_TZIC1_FCR1_TIM7_Pos                GTZC_CFGR1_TIM7_Pos
#define GTZC_TZIC1_FCR1_TIM7_Msk                GTZC_CFGR1_TIM7_Msk
#define GTZC_TZIC1_FCR1_WWDG_Pos                GTZC_CFGR1_WWDG_Pos
#define GTZC_TZIC1_FCR1_WWDG_Msk                GTZC_CFGR1_WWDG_Msk
#define GTZC_TZIC1_FCR1_IWDG_Pos                GTZC_CFGR1_IWDG_Pos
#define GTZC_TZIC1_FCR1_IWDG_Msk                GTZC_CFGR1_IWDG_Msk
#define GTZC_TZIC1_FCR1_SPI2_Pos                GTZC_CFGR1_SPI2_Pos
#define GTZC_TZIC1_FCR1_SPI2_Msk                GTZC_CFGR1_SPI2_Msk
#define GTZC_TZIC1_FCR1_USART2_Pos              GTZC_CFGR1_USART2_Pos
#define GTZC_TZIC1_FCR1_USART2_Msk              GTZC_CFGR1_USART2_Msk
#define GTZC_TZIC1_FCR1_USART3_Pos              GTZC_CFGR1_USART3_Pos
#define GTZC_TZIC1_FCR1_USART3_Msk              GTZC_CFGR1_USART3_Msk
#define GTZC_TZIC1_FCR1_UART4_Pos               GTZC_CFGR1_UART4_Pos
#define GTZC_TZIC1_FCR1_UART4_Msk               GTZC_CFGR1_UART4_Msk
#define GTZC_TZIC1_FCR1_UART5_Pos               GTZC_CFGR1_UART5_Pos
#define GTZC_TZIC1_FCR1_UART5_Msk               GTZC_CFGR1_UART5_Msk
#define GTZC_TZIC1_FCR1_I2C1_Pos                GTZC_CFGR1_I2C1_Pos
#define GTZC_TZIC1_FCR1_I2C1_Msk                GTZC_CFGR1_I2C1_Msk
#define GTZC_TZIC1_FCR1_I2C2_Pos                GTZC_CFGR1_I2C2_Pos
#define GTZC_TZIC1_FCR1_I2C2_Msk                GTZC_CFGR1_I2C2_Msk
#define GTZC_TZIC1_FCR1_CRS_Pos                 GTZC_CFGR1_CRS_Pos
#define GTZC_TZIC1_FCR1_CRS_Msk                 GTZC_CFGR1_CRS_Msk
#define GTZC_TZIC1_FCR1_I2C4_Pos                GTZC_CFGR1_I2C4_Pos
#define GTZC_TZIC1_FCR1_I2C4_Msk                GTZC_CFGR1_I2C4_Msk
#define GTZC_TZIC1_FCR1_LPTIM2_Pos              GTZC_CFGR1_LPTIM2_Pos
#define GTZC_TZIC1_FCR1_LPTIM2_Msk              GTZC_CFGR1_LPTIM2_Msk
#define GTZC_TZIC1_FCR1_FDCAN1_Pos              GTZC_CFGR1_FDCAN1_Pos
#define GTZC_TZIC1_FCR1_FDCAN1_Msk              GTZC_CFGR1_FDCAN1_Msk
#define GTZC_TZIC1_FCR1_FDCAN2_Pos              GTZC_CFGR1_FDCAN2_Pos
#define GTZC_TZIC1_FCR1_FDCAN2_Msk              GTZC_CFGR1_FDCAN2_Msk
#define GTZC_TZIC1_FCR1_SPI3_Pos                GTZC_CFGR1_SPI3_Pos
#define GTZC_TZIC1_FCR1_SPI3_Msk                GTZC_CFGR1_SPI3_Msk
#define GTZC_TZIC1_FCR1_I3C1_Pos                GTZC_CFGR1_I3C1_Pos
#define GTZC_TZIC1_FCR1_I3C1_Msk                GTZC_CFGR1_I3C1_Msk
#define GTZC_TZIC1_FCR1_OPAMP_Pos               GTZC_CFGR1_OPAMP_Pos
#define GTZC_TZIC1_FCR1_OPAMP_Msk               GTZC_CFGR1_OPAMP_Msk
#define GTZC_TZIC1_FCR1_VREFBUF_Pos             GTZC_CFGR1_VREFBUF_Pos
#define GTZC_TZIC1_FCR1_VREFBUF_Msk             GTZC_CFGR1_VREFBUF_Msk
#define GTZC_TZIC1_FCR1_SPI4_Pos                GTZC_CFGR1_SPI4_Pos
#define GTZC_TZIC1_FCR1_SPI4_Msk                GTZC_CFGR1_SPI4_Msk

/******************  Bits definition for GTZC_TZIC1_FCR2 register  ***************/
#define GTZC_TZIC1_FCR2_TIM1_Pos                GTZC_CFGR2_TIM1_Pos
#define GTZC_TZIC1_FCR2_TIM1_Msk                GTZC_CFGR2_TIM1_Msk
#define GTZC_TZIC1_FCR2_SPI1_Pos                GTZC_CFGR2_SPI1_Pos
#define GTZC_TZIC1_FCR2_SPI1_Msk                GTZC_CFGR2_SPI1_Msk
#define GTZC_TZIC1_FCR2_TIM8_Pos                GTZC_CFGR2_TIM8_Pos
#define GTZC_TZIC1_FCR2_TIM8_Msk                GTZC_CFGR2_TIM8_Msk
#define GTZC_TZIC1_FCR2_USART1_Pos              GTZC_CFGR2_USART1_Pos
#define GTZC_TZIC1_FCR2_USART1_Msk              GTZC_CFGR2_USART1_Msk
#define GTZC_TZIC1_FCR2_TIM15_Pos               GTZC_CFGR2_TIM15_Pos
#define GTZC_TZIC1_FCR2_TIM15_Msk               GTZC_CFGR2_TIM15_Msk
#define GTZC_TZIC1_FCR2_TIM16_Pos               GTZC_CFGR2_TIM16_Pos
#define GTZC_TZIC1_FCR2_TIM16_Msk               GTZC_CFGR2_TIM16_Msk
#define GTZC_TZIC1_FCR2_TIM17_Pos               GTZC_CFGR2_TIM17_Pos
#define GTZC_TZIC1_FCR2_TIM17_Msk               GTZC_CFGR2_TIM17_Msk
#define GTZC_TZIC1_FCR2_SAI1_Pos                GTZC_CFGR2_SAI1_Pos
#define GTZC_TZIC1_FCR2_SAI1_Msk                GTZC_CFGR2_SAI1_Msk
#define GTZC_TZIC1_FCR2_TIM12_Pos               GTZC_CFGR2_TIM12_Pos
#define GTZC_TZIC1_FCR2_TIM12_Msk               GTZC_CFGR2_TIM12_Msk
#define GTZC_TZIC1_FCR2_USB_Pos                 GTZC_CFGR2_USB_Pos
#define GTZC_TZIC1_FCR2_USB_Msk                 GTZC_CFGR2_USB_Msk
#define GTZC_TZIC1_FCR2_I3C2_Pos                GTZC_CFGR2_I3C2_Pos
#define GTZC_TZIC1_FCR2_I3C2_Msk                GTZC_CFGR2_I3C2_Msk
#define GTZC_TZIC1_FCR2_LPUART1_Pos             GTZC_CFGR2_LPUART1_Pos
#define GTZC_TZIC1_FCR2_LPUART1_Msk             GTZC_CFGR2_LPUART1_Msk
#define GTZC_TZIC1_FCR2_I2C3_Pos                GTZC_CFGR2_I2C3_Pos
#define GTZC_TZIC1_FCR2_I2C3_Msk                GTZC_CFGR2_I2C3_Msk
#define GTZC_TZIC1_FCR2_LPTIM1_Pos              GTZC_CFGR2_LPTIM1_Pos
#define GTZC_TZIC1_FCR2_LPTIM1_Msk              GTZC_CFGR2_LPTIM1_Msk
#define GTZC_TZIC1_FCR2_LPTIM3_Pos              GTZC_CFGR2_LPTIM3_Pos
#define GTZC_TZIC1_FCR2_LPTIM3_Msk              GTZC_CFGR2_LPTIM3_Msk
#define GTZC_TZIC1_FCR2_LPTIM4_Pos              GTZC_CFGR2_LPTIM4_Pos
#define GTZC_TZIC1_FCR2_LPTIM4_Msk              GTZC_CFGR2_LPTIM4_Msk
#define GTZC_TZIC1_FCR2_COMP_Pos                GTZC_CFGR2_COMP_Pos
#define GTZC_TZIC1_FCR2_COMP_Msk                GTZC_CFGR2_COMP_Msk

/******************  Bits definition for GTZC_TZIC1_FCR3 register  ***************/
#define GTZC_TZIC1_FCR3_CRC_Pos                 GTZC_CFGR3_CRC_Pos
#define GTZC_TZIC1_FCR3_CRC_Msk                 GTZC_CFGR3_CRC_Msk
#define GTZC_TZIC1_FCR3_TSC_Pos                 GTZC_CFGR3_TSC_Pos
#define GTZC_TZIC1_FCR3_TSC_Msk                 GTZC_CFGR3_TSC_Msk
#define GTZC_TZIC1_FCR3_ICACHE_REG_Pos          GTZC_CFGR3_ICACHE_REG_Pos
#define GTZC_TZIC1_FCR3_ICACHE_REG_Msk          GTZC_CFGR3_ICACHE_REG_Msk
#define GTZC_TZIC1_FCR3_ADC12_Pos               GTZC_CFGR3_ADC12_Pos
#define GTZC_TZIC1_FCR3_ADC12_Msk               GTZC_CFGR3_ADC12_Msk
#define GTZC_TZIC1_FCR3_HASH_Pos                GTZC_CFGR3_HASH_Pos
#define GTZC_TZIC1_FCR3_HASH_Msk                GTZC_CFGR3_HASH_Msk
#define GTZC_TZIC1_FCR3_RNG_Pos                 GTZC_CFGR3_RNG_Pos
#define GTZC_TZIC1_FCR3_RNG_Msk                 GTZC_CFGR3_RNG_Msk
#define GTZC_TZIC1_FCR3_SDMMC1_Pos              GTZC_CFGR3_SDMMC1_Pos
#define GTZC_TZIC1_FCR3_SDMMC1_Msk              GTZC_CFGR3_SDMMC1_Msk
#define GTZC_TZIC1_FCR3_OCTOSPI1_REG_Pos        GTZC_CFGR3_OCTOSPI1_REG_Pos
#define GTZC_TZIC1_FCR3_OCTOSPI1_REG_Msk        GTZC_CFGR3_OCTOSPI1_REG_Msk
#define GTZC_TZIC1_FCR3_RAMCFG_Pos              GTZC_CFGR3_RAMCFG_Pos
#define GTZC_TZIC1_FCR3_RAMCFG_Msk              GTZC_CFGR3_RAMCFG_Msk
#define GTZC_TZIC1_FCR3_DAC1_Pos                GTZC_CFGR3_DAC1_Pos
#define GTZC_TZIC1_FCR3_DAC1_Msk                GTZC_CFGR3_DAC1_Msk
#define GTZC_TZIC1_FCR3_ADF1_Pos                GTZC_CFGR3_ADF1_Pos
#define GTZC_TZIC1_FCR3_ADF1_Msk                GTZC_CFGR3_ADF1_Msk
#define GTZC_TZIC1_FCR3_HSP1_Pos               GTZC_CFGR2_HSP1_Pos
#define GTZC_TZIC1_FCR3_HSP1_Msk               GTZC_CFGR2_HSP1_Msk

/******************  Bits definition for GTZC_TZIC1_FCR4 register  ***************/
#define GTZC_TZIC1_FCR4_GPDMA1_Pos              GTZC_CFGR4_GPDMA1_Pos
#define GTZC_TZIC1_FCR4_GPDMA1_Msk              GTZC_CFGR4_GPDMA1_Msk
#define GTZC_TZIC1_FCR4_FLASH_REG_Pos           GTZC_CFGR4_FLASH_REG_Pos
#define GTZC_TZIC1_FCR4_FLASH_REG_Msk           GTZC_CFGR4_FLASH_REG_Msk
#define GTZC_TZIC1_FCR4_FLASH_Pos               GTZC_CFGR4_FLASH_Pos
#define GTZC_TZIC1_FCR4_FLASH_Msk               GTZC_CFGR4_FLASH_Msk
#define GTZC_TZIC1_FCR4_PWR_Pos                 GTZC_CFGR4_PWR_Pos
#define GTZC_TZIC1_FCR4_PWR_Msk                 GTZC_CFGR4_PWR_Msk
#define GTZC_TZIC1_FCR4_RCC_Pos                 GTZC_CFGR4_RCC_Pos
#define GTZC_TZIC1_FCR4_RCC_Msk                 GTZC_CFGR4_RCC_Msk
#define GTZC_TZIC1_FCR4_SYSCFG_Pos              GTZC_CFGR4_SYSCFG_Pos
#define GTZC_TZIC1_FCR4_SYSCFG_Msk              GTZC_CFGR4_SYSCFG_Msk
#define GTZC_TZIC1_FCR4_EXTI_Pos                GTZC_CFGR4_EXTI_Pos
#define GTZC_TZIC1_FCR4_EXTI_Msk                GTZC_CFGR4_EXTI_Msk
#define GTZC_TZIC1_FCR4_RTC_Pos                 GTZC_CFGR4_RTC_Pos
#define GTZC_TZIC1_FCR4_RTC_Msk                 GTZC_CFGR4_RTC_Msk
#define GTZC_TZIC1_FCR4_TAMP_Pos                GTZC_CFGR4_TAMP_Pos
#define GTZC_TZIC1_FCR4_TAMP_Msk                GTZC_CFGR4_TAMP_Msk
#define GTZC_TZIC1_FCR4_TZSC_Pos                GTZC_CFGR4_TZSC_Pos
#define GTZC_TZIC1_FCR4_TZSC_Msk                GTZC_CFGR4_TZSC_Msk
#define GTZC_TZIC1_FCR4_TZIC_Pos                GTZC_CFGR4_TZIC_Pos
#define GTZC_TZIC1_FCR4_TZIC_Msk                GTZC_CFGR4_TZIC_Msk
#define GTZC_TZIC1_FCR4_SRAM1_Pos               GTZC_CFGR4_SRAM1_Pos
#define GTZC_TZIC1_FCR4_SRAM1_Msk               GTZC_CFGR4_SRAM1_Msk
#define GTZC_TZIC1_FCR4_MPCBB1_REG_Pos          GTZC_CFGR4_MPCBB1_REG_Pos
#define GTZC_TZIC1_FCR4_MPCBB1_REG_Msk          GTZC_CFGR4_MPCBB1_REG_Msk
#define GTZC_TZIC1_FCR4_SRAM2_Pos               GTZC_CFGR4_SRAM2_Pos
#define GTZC_TZIC1_FCR4_SRAM2_Msk               GTZC_CFGR4_SRAM2_Msk
#define GTZC_TZIC1_FCR4_MPCBB2_REG_Pos          GTZC_CFGR4_MPCBB2_REG_Pos
#define GTZC_TZIC1_FCR4_MPCBB2_REG_Msk          GTZC_CFGR4_MPCBB2_REG_Msk
#define GTZC_TZIC1_IER4_SRAM3_Pos               GTZC_CFGR4_SRAM3_Pos
#define GTZC_TZIC1_FCR4_SRAM3_Msk               GTZC_CFGR4_SRAM3_Msk
#define GTZC_TZIC1_FCR4_MPCBB3_REG_Pos          GTZC_CFGR4_MPCBB3_REG_Pos
#define GTZC_TZIC1_FCR4_MPCBB3_REG_Msk          GTZC_CFGR4_MPCBB3_REG_Msk
#define GTZC_TZIC1_FCR4_SRAM4_Pos               GTZC_CFGR4_SRAM4_Pos
#define GTZC_TZIC1_FCR4_SRAM4_Msk               GTZC_CFGR4_SRAM4_Msk
#define GTZC_TZIC1_FCR4_MPCBB4_REG_Pos          GTZC_CFGR4_MPCBB4_REG_Pos
#define GTZC_TZIC1_FCR4_MPCBB4_REG_Msk          GTZC_CFGR4_MPCBB4_REG_Msk

/*******************  Bits definition for GTZC_MPCBB_CR register  *****************/
#define GTZC_MPCBB_CR_GLOCK_Pos             (0U)
#define GTZC_MPCBB_CR_GLOCK_Msk             (0x01UL << GTZC_MPCBB_CR_GLOCK_Pos)       /*!< 0x00000001 */
#define GTZC_MPCBB_CR_INVSECSTATE_Pos       (30U)
#define GTZC_MPCBB_CR_INVSECSTATE_Msk       (0x01UL << GTZC_MPCBB_CR_INVSECSTATE_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_CR_SRWILADIS_Pos         (31U)
#define GTZC_MPCBB_CR_SRWILADIS_Msk         (0x01UL << GTZC_MPCBB_CR_SRWILADIS_Pos)   /*!< 0x80000000 */

/*******************  Bits definition for GTZC_MPCBB_CFGLOCKR1 register  ************/
#define GTZC_MPCBB_CFGLOCKR1_SPLCK0_Pos      (0U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK0_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK0_Pos) /*!< 0x00000001 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK1_Pos      (1U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK1_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK1_Pos) /*!< 0x00000002 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK2_Pos      (2U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK2_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK2_Pos) /*!< 0x00000004 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK3_Pos      (3U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK3_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK3_Pos) /*!< 0x00000008 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK4_Pos      (4U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK4_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK4_Pos) /*!< 0x00000010 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK5_Pos      (5U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK5_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK5_Pos) /*!< 0x00000020 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK6_Pos      (6U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK6_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK6_Pos) /*!< 0x00000040 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK7_Pos      (7U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK7_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK7_Pos) /*!< 0x00000080 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK8_Pos      (8U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK8_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK8_Pos) /*!< 0x00000100 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK9_Pos      (9U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK9_Msk      (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK9_Pos) /*!< 0x00000200 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK10_Pos     (10U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK10_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK10_Pos) /*!< 0x00000400 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK11_Pos     (11U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK11_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK11_Pos) /*!< 0x00000800 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK12_Pos     (12U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK12_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK12_Pos) /*!< 0x00001000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK13_Pos     (13U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK13_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK13_Pos) /*!< 0x00002000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK14_Pos     (14U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK14_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK14_Pos) /*!< 0x00004000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK15_Pos     (15U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK15_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK15_Pos) /*!< 0x00008000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK16_Pos     (16U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK16_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK16_Pos) /*!< 0x00010000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK17_Pos     (17U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK17_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK17_Pos) /*!< 0x00020000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK18_Pos     (18U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK18_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK18_Pos) /*!< 0x00040000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK19_Pos     (19U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK19_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK19_Pos) /*!< 0x00080000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK20_Pos     (20U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK20_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK20_Pos) /*!< 0x00100000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK21_Pos     (21U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK21_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK21_Pos) /*!< 0x00200000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK22_Pos     (22U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK22_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK22_Pos) /*!< 0x00400000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK23_Pos     (23U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK23_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK23_Pos) /*!< 0x00800000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK24_Pos     (24U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK24_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK24_Pos) /*!< 0x01000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK25_Pos     (25U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK25_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK25_Pos) /*!< 0x02000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK26_Pos     (26U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK26_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK26_Pos) /*!< 0x04000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK27_Pos     (27U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK27_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK27_Pos) /*!< 0x08000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK28_Pos     (28U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK28_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK28_Pos) /*!< 0x10000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK29_Pos     (29U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK29_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK29_Pos) /*!< 0x20000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK30_Pos     (30U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK30_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK30_Pos) /*!< 0x40000000 */
#define GTZC_MPCBB_CFGLOCKR1_SPLCK31_Pos     (31U)
#define GTZC_MPCBB_CFGLOCKR1_SPLCK31_Msk     (0x01UL << GTZC_MPCBB_CFGLOCKR1_SPLCK31_Pos) /*!< 0x80000000 */

/*******************  Bits definition for GTZC_MPCBB_SECCFGR register  ************/
#define GTZC_MPCBB_SECCFGR_SEC0_Pos      (0U)
#define GTZC_MPCBB_SECCFGR_SEC0_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC0_Pos)          /*!< 0x00000001 */
#define GTZC_MPCBB_SECCFGR_SEC1_Pos      (1U)
#define GTZC_MPCBB_SECCFGR_SEC1_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC1_Pos)          /*!< 0x00000002 */
#define GTZC_MPCBB_SECCFGR_SEC2_Pos      (2U)
#define GTZC_MPCBB_SECCFGR_SEC2_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC2_Pos)          /*!< 0x00000004 */
#define GTZC_MPCBB_SECCFGR_SEC3_Pos      (3U)
#define GTZC_MPCBB_SECCFGR_SEC3_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC3_Pos)         /*!< 0x00000008 */
#define GTZC_MPCBB_SECCFGR_SEC4_Pos      (4U)
#define GTZC_MPCBB_SECCFGR_SEC4_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC4_Pos)         /*!< 0x00000010 */
#define GTZC_MPCBB_SECCFGR_SEC5_Pos      (5U)
#define GTZC_MPCBB_SECCFGR_SEC5_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC5_Pos)         /*!< 0x00000020 */
#define GTZC_MPCBB_SECCFGR_SEC6_Pos      (6U)
#define GTZC_MPCBB_SECCFGR_SEC6_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC6_Pos)         /*!< 0x00000040 */
#define GTZC_MPCBB_SECCFGR_SEC7_Pos      (7U)
#define GTZC_MPCBB_SECCFGR_SEC7_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC7_Pos)         /*!< 0x00000080 */
#define GTZC_MPCBB_SECCFGR_SEC8_Pos      (8U)
#define GTZC_MPCBB_SECCFGR_SEC8_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC8_Pos)         /*!< 0x00000100 */
#define GTZC_MPCBB_SECCFGR_SEC9_Pos      (9U)
#define GTZC_MPCBB_SECCFGR_SEC9_Msk      (0x01UL << GTZC_MPCBB_SECCFGR_SEC9_Pos)         /*!< 0x00000200 */
#define GTZC_MPCBB_SECCFGR_SEC10_Pos     (10U)
#define GTZC_MPCBB_SECCFGR_SEC10_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC10_Pos)        /*!< 0x00000400 */
#define GTZC_MPCBB_SECCFGR_SEC11_Pos     (11U)
#define GTZC_MPCBB_SECCFGR_SEC11_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define GTZC_MPCBB_SECCFGR_SEC12_Pos     (12U)
#define GTZC_MPCBB_SECCFGR_SEC12_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC12_Pos)        /*!< 0x00001000 */
#define GTZC_MPCBB_SECCFGR_SEC13_Pos     (13U)
#define GTZC_MPCBB_SECCFGR_SEC13_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC13_Pos)        /*!< 0x00002000 */
#define GTZC_MPCBB_SECCFGR_SEC14_Pos     (14U)
#define GTZC_MPCBB_SECCFGR_SEC14_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC14_Pos)        /*!< 0x00004000 */
#define GTZC_MPCBB_SECCFGR_SEC15_Pos     (15U)
#define GTZC_MPCBB_SECCFGR_SEC15_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC15_Pos)        /*!< 0x00008000 */
#define GTZC_MPCBB_SECCFGR_SEC16_Pos     (16U)
#define GTZC_MPCBB_SECCFGR_SEC16_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC16_Pos)        /*!< 0x00010000 */
#define GTZC_MPCBB_SECCFGR_SEC17_Pos     (17U)
#define GTZC_MPCBB_SECCFGR_SEC17_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC17_Pos)        /*!< 0x00020000 */
#define GTZC_MPCBB_SECCFGR_SEC18_Pos     (18U)
#define GTZC_MPCBB_SECCFGR_SEC18_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC18_Pos)        /*!< 0x00040000 */
#define GTZC_MPCBB_SECCFGR_SEC19_Pos     (19U)
#define GTZC_MPCBB_SECCFGR_SEC19_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC19_Pos)        /*!< 0x00080000 */
#define GTZC_MPCBB_SECCFGR_SEC20_Pos     (20U)
#define GTZC_MPCBB_SECCFGR_SEC20_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC20_Pos)        /*!< 0x00100000 */
#define GTZC_MPCBB_SECCFGR_SEC21_Pos     (21U)
#define GTZC_MPCBB_SECCFGR_SEC21_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC21_Pos)        /*!< 0x00200000 */
#define GTZC_MPCBB_SECCFGR_SEC22_Pos     (22U)
#define GTZC_MPCBB_SECCFGR_SEC22_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC22_Pos)        /*!< 0x00400000 */
#define GTZC_MPCBB_SECCFGR_SEC23_Pos     (23U)
#define GTZC_MPCBB_SECCFGR_SEC23_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC23_Pos)        /*!< 0x00800000 */
#define GTZC_MPCBB_SECCFGR_SEC24_Pos     (24U)
#define GTZC_MPCBB_SECCFGR_SEC24_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC24_Pos)        /*!< 0x01000000 */
#define GTZC_MPCBB_SECCFGR_SEC25_Pos     (25U)
#define GTZC_MPCBB_SECCFGR_SEC25_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC25_Pos)        /*!< 0x02000000 */
#define GTZC_MPCBB_SECCFGR_SEC26_Pos     (26U)
#define GTZC_MPCBB_SECCFGR_SEC26_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC26_Pos)        /*!< 0x04000000 */
#define GTZC_MPCBB_SECCFGR_SEC27_Pos     (27U)
#define GTZC_MPCBB_SECCFGR_SEC27_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC27_Pos)        /*!< 0x08000000 */
#define GTZC_MPCBB_SECCFGR_SEC28_Pos     (28U)
#define GTZC_MPCBB_SECCFGR_SEC28_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC28_Pos)        /*!< 0x10000000 */
#define GTZC_MPCBB_SECCFGR_SEC29_Pos     (29U)
#define GTZC_MPCBB_SECCFGR_SEC29_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC29_Pos)        /*!< 0x20000000 */
#define GTZC_MPCBB_SECCFGR_SEC30_Pos     (30U)
#define GTZC_MPCBB_SECCFGR_SEC30_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC30_Pos)        /*!< 0x40000000 */
#define GTZC_MPCBB_SECCFGR_SEC31_Pos     (31U)
#define GTZC_MPCBB_SECCFGR_SEC31_Msk     (0x01UL << GTZC_MPCBB_SECCFGR_SEC31_Pos)        /*!< 0x80000000 */

/*******************  Bits definition for GTZC_MPCBB_PRIVCFGR register  ************/
#define GTZC_MPCBB_PRIVCFGR_PRIV0_Pos      (0U)
#define GTZC_MPCBB_PRIVCFGR_PRIV0_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV0_Pos)     /*!< 0x00000001 */
#define GTZC_MPCBB_PRIVCFGR_PRIV1_Pos      (1U)
#define GTZC_MPCBB_PRIVCFGR_PRIV1_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV1_Pos)     /*!< 0x00000002 */
#define GTZC_MPCBB_PRIVCFGR_PRIV2_Pos      (2U)
#define GTZC_MPCBB_PRIVCFGR_PRIV2_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV2_Pos)     /*!< 0x00000004 */
#define GTZC_MPCBB_PRIVCFGR_PRIV3_Pos      (3U)
#define GTZC_MPCBB_PRIVCFGR_PRIV3_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV3_Pos)     /*!< 0x00000008 */
#define GTZC_MPCBB_PRIVCFGR_PRIV4_Pos      (4U)
#define GTZC_MPCBB_PRIVCFGR_PRIV4_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV4_Pos)     /*!< 0x00000010 */
#define GTZC_MPCBB_PRIVCFGR_PRIV5_Pos      (5U)
#define GTZC_MPCBB_PRIVCFGR_PRIV5_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV5_Pos)     /*!< 0x00000020 */
#define GTZC_MPCBB_PRIVCFGR_PRIV6_Pos      (6U)
#define GTZC_MPCBB_PRIVCFGR_PRIV6_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV6_Pos)     /*!< 0x00000040 */
#define GTZC_MPCBB_PRIVCFGR_PRIV7_Pos      (7U)
#define GTZC_MPCBB_PRIVCFGR_PRIV7_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV7_Pos)     /*!< 0x00000080 */
#define GTZC_MPCBB_PRIVCFGR_PRIV8_Pos      (8U)
#define GTZC_MPCBB_PRIVCFGR_PRIV8_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV8_Pos)     /*!< 0x00000100 */
#define GTZC_MPCBB_PRIVCFGR_PRIV9_Pos      (9U)
#define GTZC_MPCBB_PRIVCFGR_PRIV9_Msk      (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV9_Pos)     /*!< 0x00000200 */
#define GTZC_MPCBB_PRIVCFGR_PRIV10_Pos     (10U)
#define GTZC_MPCBB_PRIVCFGR_PRIV10_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV10_Pos)    /*!< 0x00000400 */
#define GTZC_MPCBB_PRIVCFGR_PRIV11_Pos     (11U)
#define GTZC_MPCBB_PRIVCFGR_PRIV11_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV11_Pos)    /*!< 0x00000800 */
#define GTZC_MPCBB_PRIVCFGR_PRIV12_Pos     (12U)
#define GTZC_MPCBB_PRIVCFGR_PRIV12_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV12_Pos)    /*!< 0x00001000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV13_Pos     (13U)
#define GTZC_MPCBB_PRIVCFGR_PRIV13_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV13_Pos)    /*!< 0x00002000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV14_Pos     (14U)
#define GTZC_MPCBB_PRIVCFGR_PRIV14_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV14_Pos)    /*!< 0x00004000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV15_Pos     (15U)
#define GTZC_MPCBB_PRIVCFGR_PRIV15_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV15_Pos)    /*!< 0x00008000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV16_Pos     (16U)
#define GTZC_MPCBB_PRIVCFGR_PRIV16_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV16_Pos)    /*!< 0x00010000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV17_Pos     (17U)
#define GTZC_MPCBB_PRIVCFGR_PRIV17_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV17_Pos)    /*!< 0x00020000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV18_Pos     (18U)
#define GTZC_MPCBB_PRIVCFGR_PRIV18_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV18_Pos)    /*!< 0x00040000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV19_Pos     (19U)
#define GTZC_MPCBB_PRIVCFGR_PRIV19_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV19_Pos)    /*!< 0x00080000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV20_Pos     (20U)
#define GTZC_MPCBB_PRIVCFGR_PRIV20_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV20_Pos)    /*!< 0x00100000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV21_Pos     (21U)
#define GTZC_MPCBB_PRIVCFGR_PRIV21_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV21_Pos)    /*!< 0x00200000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV22_Pos     (22U)
#define GTZC_MPCBB_PRIVCFGR_PRIV22_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV22_Pos)    /*!< 0x00400000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV23_Pos     (23U)
#define GTZC_MPCBB_PRIVCFGR_PRIV23_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV23_Pos)    /*!< 0x00800000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV24_Pos     (24U)
#define GTZC_MPCBB_PRIVCFGR_PRIV24_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV24_Pos)    /*!< 0x01000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV25_Pos     (25U)
#define GTZC_MPCBB_PRIVCFGR_PRIV25_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV25_Pos)    /*!< 0x02000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV26_Pos     (26U)
#define GTZC_MPCBB_PRIVCFGR_PRIV26_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV26_Pos)    /*!< 0x04000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV27_Pos     (27U)
#define GTZC_MPCBB_PRIVCFGR_PRIV27_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV27_Pos)    /*!< 0x08000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV28_Pos     (28U)
#define GTZC_MPCBB_PRIVCFGR_PRIV28_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV28_Pos)    /*!< 0x10000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV29_Pos     (29U)
#define GTZC_MPCBB_PRIVCFGR_PRIV29_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV29_Pos)    /*!< 0x20000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV30_Pos     (30U)
#define GTZC_MPCBB_PRIVCFGR_PRIV30_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV30_Pos)    /*!< 0x40000000 */
#define GTZC_MPCBB_PRIVCFGR_PRIV31_Pos     (31U)
#define GTZC_MPCBB_PRIVCFGR_PRIV31_Msk     (0x01UL << GTZC_MPCBB_PRIVCFGR_PRIV31_Pos)    /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos                    (2U)
#define HASH_CR_INIT_Msk                    (0x1UL << HASH_CR_INIT_Pos)             /*!< 0x00000004 */
#define HASH_CR_INIT                        HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos                    (3U)
#define HASH_CR_DMAE_Msk                    (0x1UL << HASH_CR_DMAE_Pos)             /*!< 0x00000008 */
#define HASH_CR_DMAE                        HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos                (4U)
#define HASH_CR_DATATYPE_Msk                (0x3UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000030 */
#define HASH_CR_DATATYPE                    HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0                  (0x1UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1                  (0x2UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000020 */
#define HASH_CR_MODE_Pos                    (6U)
#define HASH_CR_MODE_Msk                    (0x1UL << HASH_CR_MODE_Pos)             /*!< 0x00000040 */
#define HASH_CR_MODE                        HASH_CR_MODE_Msk
#define HASH_CR_NBW_Pos                     (8U)
#define HASH_CR_NBW_Msk                     (0xFUL << HASH_CR_NBW_Pos)              /*!< 0x00000F00 */
#define HASH_CR_NBW                         HASH_CR_NBW_Msk
#define HASH_CR_NBW_0                       (0x1UL << HASH_CR_NBW_Pos)              /*!< 0x00000100 */
#define HASH_CR_NBW_1                       (0x2UL << HASH_CR_NBW_Pos)              /*!< 0x00000200 */
#define HASH_CR_NBW_2                       (0x4UL << HASH_CR_NBW_Pos)              /*!< 0x00000400 */
#define HASH_CR_NBW_3                       (0x8UL << HASH_CR_NBW_Pos)              /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos                   (12U)
#define HASH_CR_DINNE_Msk                   (0x1UL << HASH_CR_DINNE_Pos)            /*!< 0x00001000 */
#define HASH_CR_DINNE                       HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos                   (13U)
#define HASH_CR_MDMAT_Msk                   (0x1UL << HASH_CR_MDMAT_Pos)            /*!< 0x00002000 */
#define HASH_CR_MDMAT                       HASH_CR_MDMAT_Msk
#define HASH_CR_LKEY_Pos                    (16U)
#define HASH_CR_LKEY_Msk                    (0x1UL << HASH_CR_LKEY_Pos)             /*!< 0x00010000 */
#define HASH_CR_LKEY                        HASH_CR_LKEY_Msk
#define HASH_CR_ALGO_Pos                    (17U)
#define HASH_CR_ALGO_Msk                    (0xFUL << HASH_CR_ALGO_Pos)             /*!< 0x001E0000 */
#define HASH_CR_ALGO                        HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0                      (0x1UL << HASH_CR_ALGO_Pos)             /*!< 0x00020000 */
#define HASH_CR_ALGO_1                      (0x2UL << HASH_CR_ALGO_Pos)             /*!< 0x00040000 */
#define HASH_CR_ALGO_2                      (0x4UL << HASH_CR_ALGO_Pos)             /*!< 0x00080000 */
#define HASH_CR_ALGO_3                      (0x8UL << HASH_CR_ALGO_Pos)             /*!< 0x00100000 */

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos                   (0U)
#define HASH_STR_NBLW_Msk                   (0x1FUL << HASH_STR_NBLW_Pos)           /*!< 0x0000001F */
#define HASH_STR_NBLW                       HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0                     (0x01UL << HASH_STR_NBLW_Pos)           /*!< 0x00000001 */
#define HASH_STR_NBLW_1                     (0x02UL << HASH_STR_NBLW_Pos)           /*!< 0x00000002 */
#define HASH_STR_NBLW_2                     (0x04UL << HASH_STR_NBLW_Pos)           /*!< 0x00000004 */
#define HASH_STR_NBLW_3                     (0x08UL << HASH_STR_NBLW_Pos)           /*!< 0x00000008 */
#define HASH_STR_NBLW_4                     (0x10UL << HASH_STR_NBLW_Pos)           /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos                   (8U)
#define HASH_STR_DCAL_Msk                   (0x1UL << HASH_STR_DCAL_Pos)            /*!< 0x00000100 */
#define HASH_STR_DCAL                       HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_SHA3CFGR register  ********************/
#define HASH_SHA3CFGR_PADBYTE_Pos           (0U)
#define HASH_SHA3CFGR_PADBYTE_Msk           (0xFFUL << HASH_SHA3CFGR_PADBYTE_Pos)            /*!< 0x000000FF */
#define HASH_SHA3CFGR_PADBYTE               HASH_SHA3CFGR_PADBYTE_Msk
#define HASH_SHA3CFGR_PADCONFIG_Pos         (8U)
#define HASH_SHA3CFGR_PADCONFIG_Msk         (0x1UL << HASH_SHA3CFGR_PADCONFIG_Pos)             /*!< 0x00000100 */
#define HASH_SHA3CFGR_PADCONFIG             HASH_SHA3CFGR_PADCONFIG_Msk
#define HASH_SHA3CFGR_START_RND_Pos         (9U)
#define HASH_SHA3CFGR_START_RND_Msk         (0x1FUL << HASH_SHA3CFGR_START_RND_Pos)             /*!< 0x00003E00 */
#define HASH_SHA3CFGR_START_RND             HASH_SHA3CFGR_START_RND_Msk
#define HASH_SHA3CFGR_END_RND_Pos           (14U)
#define HASH_SHA3CFGR_END_RND_Msk           (0x1FUL << HASH_SHA3CFGR_END_RND_Pos)             /*!< 0x0007C000 */
#define HASH_SHA3CFGR_END_RND               HASH_SHA3CFGR_END_RND_Msk
#define HASH_SHA3CFGR_IN_RATE_Pos           (19U)
#define HASH_SHA3CFGR_IN_RATE_Msk           (0x1FUL << HASH_SHA3CFGR_IN_RATE_Pos)             /*!< 0x0F80000 */
#define HASH_SHA3CFGR_IN_RATE               HASH_SHA3CFGR_IN_RATE_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos                  (0U)
#define HASH_IMR_DINIE_Msk                  (0x1UL << HASH_IMR_DINIE_Pos)           /*!< 0x00000001 */
#define HASH_IMR_DINIE                      HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos                   (1U)
#define HASH_IMR_DCIE_Msk                   (0x1UL << HASH_IMR_DCIE_Pos)            /*!< 0x00000002 */
#define HASH_IMR_DCIE                       HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos                   (0U)
#define HASH_SR_DINIS_Msk                   (0x1UL << HASH_SR_DINIS_Pos)            /*!< 0x00000001 */
#define HASH_SR_DINIS                       HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos                    (1U)
#define HASH_SR_DCIS_Msk                    (0x1UL << HASH_SR_DCIS_Pos)             /*!< 0x00000002 */
#define HASH_SR_DCIS                        HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos                    (2U)
#define HASH_SR_DMAS_Msk                    (0x1UL << HASH_SR_DMAS_Pos)             /*!< 0x00000004 */
#define HASH_SR_DMAS                        HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos                    (3U)
#define HASH_SR_BUSY_Msk                    (0x1UL << HASH_SR_BUSY_Pos)             /*!< 0x00000008 */
#define HASH_SR_BUSY                        HASH_SR_BUSY_Msk
#define HASH_SR_NBWP_Pos                    (9U)
#define HASH_SR_NBWP_Msk                    (0x3FUL << HASH_SR_NBWP_Pos)             /*!< 0x00007E00 */
#define HASH_SR_NBWP                        HASH_SR_NBWP_Msk
#define HASH_SR_DINNE_Pos                   (15U)
#define HASH_SR_DINNE_Msk                   (0x1UL << HASH_SR_DINNE_Pos)            /*!< 0x00008000 */
#define HASH_SR_DINNE                       HASH_SR_DINNE_Msk
#define HASH_SR_NBWE_Pos                    (16U)
#define HASH_SR_NBWE_Msk                    (0x3FUL << HASH_SR_NBWE_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWE                        HASH_SR_NBWE_Msk

/******************************************************************************/
/*                                                                            */
/*                      Hardware Signal Processor (HSP)                       */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for HSP_CR register  ********************/
/*!< BOOTEN configuration */
#define HSP_CR_BOOTEN_Pos    (0U)
#define HSP_CR_BOOTEN_Msk    (0x1UL << HSP_CR_BOOTEN_Pos)    /*!< 0x00000001 */
#define HSP_CR_BOOTEN        HSP_CR_BOOTEN_Msk               /*!< BOOTEN (Boot Enable control) */
/*!< CTRLCGDIS configuration */
#define HSP_CR_CTRLCGDIS_Pos (4U)
#define HSP_CR_CTRLCGDIS_Msk (0x1UL << HSP_CR_CTRLCGDIS_Pos) /*!< 0x00000010 */
#define HSP_CR_CTRLCGDIS     HSP_CR_CTRLCGDIS_Msk            /*!< CTRLCGDIS (HSP_CTRL clock gating disable) */
/*!< MMCCGDIS configuration */
#define HSP_CR_MMCCGDIS_Pos  (6U)
#define HSP_CR_MMCCGDIS_Msk  (0x1UL << HSP_CR_MMCCGDIS_Pos)  /*!< 0x00000040 */
#define HSP_CR_MMCCGDIS      HSP_CR_MMCCGDIS_Msk             /*!< MMCCGDIS (MMC clock gating disable) */
/*!< SPECGDIS configuration */
#define HSP_CR_SPECGDIS_Pos  (7U)
#define HSP_CR_SPECGDIS_Msk  (0x1UL << HSP_CR_SPECGDIS_Pos)  /*!< 0x00000080 */
#define HSP_CR_SPECGDIS      HSP_CR_SPECGDIS_Msk             /*!< SPECGDIS (SPE clock gating disable) */
/*!< DCMDEVEN configuration */
#define HSP_CR_DCMDEVEN_Pos  (12U)
#define HSP_CR_DCMDEVEN_Msk  (0x1UL << HSP_CR_DCMDEVEN_Pos)  /*!< 0x00001000 */
#define HSP_CR_DCMDEVEN      HSP_CR_DCMDEVEN_Msk             /*!< DCMDEVEN (Direct command event enable) */
/*!< CDRLCK configuration */
#define HSP_CR_CDRLCK_Pos    (13U)
#define HSP_CR_CDRLCK_Msk    (0x3UL << HSP_CR_CDRLCK_Pos)    /*!< 0x00006000 */
#define HSP_CR_CDRLCK        HSP_CR_CDRLCK_Msk               /*!< CDRLCK[1:0] bits (CRAM & DRAM lock access control) */
#define HSP_CR_CDRLCK_0      (0x1UL << HSP_CR_CDRLCK_Pos)    /*!< 0x00002000 */
#define HSP_CR_CDRLCK_1      (0x2UL << HSP_CR_CDRLCK_Pos)    /*!< 0x00004000 */
/*!< REGLCK configuration */
#define HSP_CR_REGLCK_Pos    (15U)
#define HSP_CR_REGLCK_Msk    (0x1UL << HSP_CR_REGLCK_Pos)    /*!< 0x00008000 */
#define HSP_CR_REGLCK        HSP_CR_REGLCK_Msk               /*!< REGLCK (Register write lock access control) */
/*!< RSTREQ configuration */
#define HSP_CR_RSTREQ_Pos    (16U)
#define HSP_CR_RSTREQ_Msk    (0x1UL << HSP_CR_RSTREQ_Pos)    /*!< 0x00010000 */
#define HSP_CR_RSTREQ        HSP_CR_RSTREQ_Msk               /*!< RSTREQ (Reset request) */
/*!< RSTOK configuration */
#define HSP_CR_RSTOK_Pos     (17U)
#define HSP_CR_RSTOK_Msk     (0x1UL << HSP_CR_RSTOK_Pos)     /*!< 0x00020000 */
#define HSP_CR_RSTOK         HSP_CR_RSTOK_Msk                /*!< RSTOK (Reset request accepted) */
/*!< BARB configuration */
#define HSP_CR_BARB_Pos      (24U)
#define HSP_CR_BARB_Msk      (0x3UL << HSP_CR_BARB_Pos)      /*!< 0x03000000 */
#define HSP_CR_BARB          HSP_CR_BARB_Msk                 /*!< BARB[1:0] bits (BRAM Arbitration) */
#define HSP_CR_BARB_0        (0x1UL << HSP_CR_BARB_Pos)      /*!< 0x01000000 */
#define HSP_CR_BARB_1        (0x2UL << HSP_CR_BARB_Pos)      /*!< 0x02000000 */
/*!< BSTAT configuration */
#define HSP_CR_BSTAT_Pos     (28U)
#define HSP_CR_BSTAT_Msk     (0xFUL << HSP_CR_BSTAT_Pos)     /*!< 0xF0000000 */
#define HSP_CR_BSTAT         HSP_CR_BSTAT_Msk                /*!< BSTAT[3:0] bits (Boot status) */
#define HSP_CR_BSTAT_0       (0x01UL << HSP_CR_BSTAT_Pos)    /*!< 0x10000000 */
#define HSP_CR_BSTAT_1       (0x02UL << HSP_CR_BSTAT_Pos)    /*!< 0x20000000 */
#define HSP_CR_BSTAT_2       (0x04UL << HSP_CR_BSTAT_Pos)    /*!< 0x40000000 */
#define HSP_CR_BSTAT_3       (0x08UL << HSP_CR_BSTAT_Pos)    /*!< 0x80000000 */

/********************  Bit definition for HSP_OR register  ********************/
/*!< OPTION configuration */
#define HSP_OR_OPTION_Pos (0U)
#define HSP_OR_OPTION_Msk (0xFFFFFFFFUL << HSP_OR_OPTION_Pos) /*!< 0xFFFFFFFF */
#define HSP_OR_OPTION     HSP_OR_OPTION_Msk                   /*!< OPTION[31:0] bits (Option control bits) */
#define HSP_OR_OPTION_0   (0x00001UL << HSP_OR_OPTION_Pos)    /*!< 0x00000001 */
#define HSP_OR_OPTION_1   (0x00002UL << HSP_OR_OPTION_Pos)    /*!< 0x00000002 */
#define HSP_OR_OPTION_2   (0x00004UL << HSP_OR_OPTION_Pos)    /*!< 0x00000004 */
#define HSP_OR_OPTION_3   (0x00008UL << HSP_OR_OPTION_Pos)    /*!< 0x00000008 */
#define HSP_OR_OPTION_4   (0x00010UL << HSP_OR_OPTION_Pos)    /*!< 0x00000010 */
#define HSP_OR_OPTION_5   (0x00020UL << HSP_OR_OPTION_Pos)    /*!< 0x00000020 */
#define HSP_OR_OPTION_6   (0x00040UL << HSP_OR_OPTION_Pos)    /*!< 0x00000040 */
#define HSP_OR_OPTION_7   (0x00080UL << HSP_OR_OPTION_Pos)    /*!< 0x00000080 */
#define HSP_OR_OPTION_8   (0x00100UL << HSP_OR_OPTION_Pos)    /*!< 0x00000100 */
#define HSP_OR_OPTION_9   (0x00200UL << HSP_OR_OPTION_Pos)    /*!< 0x00000200 */
#define HSP_OR_OPTION_10  (0x00400UL << HSP_OR_OPTION_Pos)    /*!< 0x00000400 */
#define HSP_OR_OPTION_11  (0x00800UL << HSP_OR_OPTION_Pos)    /*!< 0x00000800 */
#define HSP_OR_OPTION_12  (0x01000UL << HSP_OR_OPTION_Pos)    /*!< 0x00001000 */
#define HSP_OR_OPTION_13  (0x02000UL << HSP_OR_OPTION_Pos)    /*!< 0x00002000 */
#define HSP_OR_OPTION_14  (0x04000UL << HSP_OR_OPTION_Pos)    /*!< 0x00004000 */
#define HSP_OR_OPTION_15  (0x08000UL << HSP_OR_OPTION_Pos)    /*!< 0x00008000 */
#define HSP_OR_OPTION_16  (0x10000UL << HSP_OR_OPTION_Pos)    /*!< 0x00010000 */
#define HSP_OR_OPTION_17  (0x20000UL << HSP_OR_OPTION_Pos)    /*!< 0x00020000 */
#define HSP_OR_OPTION_18  (0x40000UL << HSP_OR_OPTION_Pos)    /*!< 0x00040000 */
#define HSP_OR_OPTION_19  (0x80000UL << HSP_OR_OPTION_Pos)    /*!< 0x00080000 */
#define HSP_OR_OPTION_20  (0x100000UL << HSP_OR_OPTION_Pos)   /*!< 0x00100000 */
#define HSP_OR_OPTION_21  (0x200000UL << HSP_OR_OPTION_Pos)   /*!< 0x00200000 */
#define HSP_OR_OPTION_22  (0x400000UL << HSP_OR_OPTION_Pos)   /*!< 0x00400000 */
#define HSP_OR_OPTION_23  (0x800000UL << HSP_OR_OPTION_Pos)   /*!< 0x00800000 */
#define HSP_OR_OPTION_24  (0x1000000UL << HSP_OR_OPTION_Pos)  /*!< 0x01000000 */
#define HSP_OR_OPTION_25  (0x2000000UL << HSP_OR_OPTION_Pos)  /*!< 0x02000000 */
#define HSP_OR_OPTION_26  (0x4000000UL << HSP_OR_OPTION_Pos)  /*!< 0x04000000 */
#define HSP_OR_OPTION_27  (0x8000000UL << HSP_OR_OPTION_Pos)  /*!< 0x08000000 */
#define HSP_OR_OPTION_28  (0x10000000UL << HSP_OR_OPTION_Pos) /*!< 0x10000000 */
#define HSP_OR_OPTION_29  (0x20000000UL << HSP_OR_OPTION_Pos) /*!< 0x20000000 */
#define HSP_OR_OPTION_30  (0x40000000UL << HSP_OR_OPTION_Pos) /*!< 0x40000000 */
#define HSP_OR_OPTION_31  (0x80000000UL << HSP_OR_OPTION_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_C2HSEMR register  ********************/
/*!< C2HSEM configuration */
#define HSP_C2HSEMR_C2HSEM_Pos (0U)
#define HSP_C2HSEMR_C2HSEM_Msk (0x1UL << HSP_C2HSEMR_C2HSEM_Pos) /*!< 0x00000001 */
#define HSP_C2HSEMR_C2HSEM     HSP_C2HSEMR_C2HSEM_Msk            /*!< C2HSEM (CPU to HSP semaphore) */

/********************  Bit definition for HSP_C2HMSGDR register  ********************/
/*!< C2HDATA configuration */
#define HSP_C2HMSGDR_C2HDATA_Pos (0U)
#define HSP_C2HMSGDR_C2HDATA_Msk (0xFFFFFFFFUL << HSP_C2HMSGDR_C2HDATA_Pos) /*!< 0xFFFFFFFF */
#define HSP_C2HMSGDR_C2HDATA     HSP_C2HMSGDR_C2HDATA_Msk                   /*!< C2HDATA[31:0] bits (CPU Message for the HSP) */
#define HSP_C2HMSGDR_C2HDATA_0   (0x00001UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000001 */
#define HSP_C2HMSGDR_C2HDATA_1   (0x00002UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000002 */
#define HSP_C2HMSGDR_C2HDATA_2   (0x00004UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000004 */
#define HSP_C2HMSGDR_C2HDATA_3   (0x00008UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000008 */
#define HSP_C2HMSGDR_C2HDATA_4   (0x00010UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000010 */
#define HSP_C2HMSGDR_C2HDATA_5   (0x00020UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000020 */
#define HSP_C2HMSGDR_C2HDATA_6   (0x00040UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000040 */
#define HSP_C2HMSGDR_C2HDATA_7   (0x00080UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000080 */
#define HSP_C2HMSGDR_C2HDATA_8   (0x00100UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000100 */
#define HSP_C2HMSGDR_C2HDATA_9   (0x00200UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000200 */
#define HSP_C2HMSGDR_C2HDATA_10  (0x00400UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000400 */
#define HSP_C2HMSGDR_C2HDATA_11  (0x00800UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00000800 */
#define HSP_C2HMSGDR_C2HDATA_12  (0x01000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00001000 */
#define HSP_C2HMSGDR_C2HDATA_13  (0x02000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00002000 */
#define HSP_C2HMSGDR_C2HDATA_14  (0x04000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00004000 */
#define HSP_C2HMSGDR_C2HDATA_15  (0x08000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00008000 */
#define HSP_C2HMSGDR_C2HDATA_16  (0x10000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00010000 */
#define HSP_C2HMSGDR_C2HDATA_17  (0x20000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00020000 */
#define HSP_C2HMSGDR_C2HDATA_18  (0x40000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00040000 */
#define HSP_C2HMSGDR_C2HDATA_19  (0x80000UL << HSP_C2HMSGDR_C2HDATA_Pos)    /*!< 0x00080000 */
#define HSP_C2HMSGDR_C2HDATA_20  (0x100000UL << HSP_C2HMSGDR_C2HDATA_Pos)   /*!< 0x00100000 */
#define HSP_C2HMSGDR_C2HDATA_21  (0x200000UL << HSP_C2HMSGDR_C2HDATA_Pos)   /*!< 0x00200000 */
#define HSP_C2HMSGDR_C2HDATA_22  (0x400000UL << HSP_C2HMSGDR_C2HDATA_Pos)   /*!< 0x00400000 */
#define HSP_C2HMSGDR_C2HDATA_23  (0x800000UL << HSP_C2HMSGDR_C2HDATA_Pos)   /*!< 0x00800000 */
#define HSP_C2HMSGDR_C2HDATA_24  (0x1000000UL << HSP_C2HMSGDR_C2HDATA_Pos)  /*!< 0x01000000 */
#define HSP_C2HMSGDR_C2HDATA_25  (0x2000000UL << HSP_C2HMSGDR_C2HDATA_Pos)  /*!< 0x02000000 */
#define HSP_C2HMSGDR_C2HDATA_26  (0x4000000UL << HSP_C2HMSGDR_C2HDATA_Pos)  /*!< 0x04000000 */
#define HSP_C2HMSGDR_C2HDATA_27  (0x8000000UL << HSP_C2HMSGDR_C2HDATA_Pos)  /*!< 0x08000000 */
#define HSP_C2HMSGDR_C2HDATA_28  (0x10000000UL << HSP_C2HMSGDR_C2HDATA_Pos) /*!< 0x10000000 */
#define HSP_C2HMSGDR_C2HDATA_29  (0x20000000UL << HSP_C2HMSGDR_C2HDATA_Pos) /*!< 0x20000000 */
#define HSP_C2HMSGDR_C2HDATA_30  (0x40000000UL << HSP_C2HMSGDR_C2HDATA_Pos) /*!< 0x40000000 */
#define HSP_C2HMSGDR_C2HDATA_31  (0x80000000UL << HSP_C2HMSGDR_C2HDATA_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_H2CSEMR register  ********************/
/*!< H2CSEM configuration */
#define HSP_H2CSEMR_H2CSEM_Pos (0U)
#define HSP_H2CSEMR_H2CSEM_Msk (0x1UL << HSP_H2CSEMR_H2CSEM_Pos) /*!< 0x00000001 */
#define HSP_H2CSEMR_H2CSEM     HSP_H2CSEMR_H2CSEM_Msk            /*!< H2CSEM (HSP to CPU semaphore) */

/********************  Bit definition for HSP_H2CMSGDR register  ********************/
/*!< H2CDATA configuration */
#define HSP_H2CMSGDR_H2CDATA_Pos (0U)
#define HSP_H2CMSGDR_H2CDATA_Msk (0xFFFFFFFFUL << HSP_H2CMSGDR_H2CDATA_Pos) /*!< 0xFFFFFFFF */
#define HSP_H2CMSGDR_H2CDATA     HSP_H2CMSGDR_H2CDATA_Msk                   /*!< H2CDATA[31:0] bits (HSP Message for the CPU) */
#define HSP_H2CMSGDR_H2CDATA_0   (0x00001UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000001 */
#define HSP_H2CMSGDR_H2CDATA_1   (0x00002UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000002 */
#define HSP_H2CMSGDR_H2CDATA_2   (0x00004UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000004 */
#define HSP_H2CMSGDR_H2CDATA_3   (0x00008UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000008 */
#define HSP_H2CMSGDR_H2CDATA_4   (0x00010UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000010 */
#define HSP_H2CMSGDR_H2CDATA_5   (0x00020UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000020 */
#define HSP_H2CMSGDR_H2CDATA_6   (0x00040UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000040 */
#define HSP_H2CMSGDR_H2CDATA_7   (0x00080UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000080 */
#define HSP_H2CMSGDR_H2CDATA_8   (0x00100UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000100 */
#define HSP_H2CMSGDR_H2CDATA_9   (0x00200UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000200 */
#define HSP_H2CMSGDR_H2CDATA_10  (0x00400UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000400 */
#define HSP_H2CMSGDR_H2CDATA_11  (0x00800UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00000800 */
#define HSP_H2CMSGDR_H2CDATA_12  (0x01000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00001000 */
#define HSP_H2CMSGDR_H2CDATA_13  (0x02000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00002000 */
#define HSP_H2CMSGDR_H2CDATA_14  (0x04000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00004000 */
#define HSP_H2CMSGDR_H2CDATA_15  (0x08000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00008000 */
#define HSP_H2CMSGDR_H2CDATA_16  (0x10000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00010000 */
#define HSP_H2CMSGDR_H2CDATA_17  (0x20000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00020000 */
#define HSP_H2CMSGDR_H2CDATA_18  (0x40000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00040000 */
#define HSP_H2CMSGDR_H2CDATA_19  (0x80000UL << HSP_H2CMSGDR_H2CDATA_Pos)    /*!< 0x00080000 */
#define HSP_H2CMSGDR_H2CDATA_20  (0x100000UL << HSP_H2CMSGDR_H2CDATA_Pos)   /*!< 0x00100000 */
#define HSP_H2CMSGDR_H2CDATA_21  (0x200000UL << HSP_H2CMSGDR_H2CDATA_Pos)   /*!< 0x00200000 */
#define HSP_H2CMSGDR_H2CDATA_22  (0x400000UL << HSP_H2CMSGDR_H2CDATA_Pos)   /*!< 0x00400000 */
#define HSP_H2CMSGDR_H2CDATA_23  (0x800000UL << HSP_H2CMSGDR_H2CDATA_Pos)   /*!< 0x00800000 */
#define HSP_H2CMSGDR_H2CDATA_24  (0x1000000UL << HSP_H2CMSGDR_H2CDATA_Pos)  /*!< 0x01000000 */
#define HSP_H2CMSGDR_H2CDATA_25  (0x2000000UL << HSP_H2CMSGDR_H2CDATA_Pos)  /*!< 0x02000000 */
#define HSP_H2CMSGDR_H2CDATA_26  (0x4000000UL << HSP_H2CMSGDR_H2CDATA_Pos)  /*!< 0x04000000 */
#define HSP_H2CMSGDR_H2CDATA_27  (0x8000000UL << HSP_H2CMSGDR_H2CDATA_Pos)  /*!< 0x08000000 */
#define HSP_H2CMSGDR_H2CDATA_28  (0x10000000UL << HSP_H2CMSGDR_H2CDATA_Pos) /*!< 0x10000000 */
#define HSP_H2CMSGDR_H2CDATA_29  (0x20000000UL << HSP_H2CMSGDR_H2CDATA_Pos) /*!< 0x20000000 */
#define HSP_H2CMSGDR_H2CDATA_30  (0x40000000UL << HSP_H2CMSGDR_H2CDATA_Pos) /*!< 0x40000000 */
#define HSP_H2CMSGDR_H2CDATA_31  (0x80000000UL << HSP_H2CMSGDR_H2CDATA_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_DCMDSR register  ********************/
/*!< DCBSY configuration */
#define HSP_DCMDSR_DCBSY_Pos (0U)
#define HSP_DCMDSR_DCBSY_Msk (0x1UL << HSP_DCMDSR_DCBSY_Pos) /*!< 0x00000001 */
#define HSP_DCMDSR_DCBSY     HSP_DCMDSR_DCBSY_Msk            /*!< DCBSY (Direct command busy flag) */

/********************  Bit definition for HSP_DCMDPTSR register  ********************/
/*!< PTRF0 configuration */
#define HSP_DCMDPTSR_PTRF0_Pos (0U)
#define HSP_DCMDPTSR_PTRF0_Msk (0x1UL << HSP_DCMDPTSR_PTRF0_Pos) /*!< 0x00000001 */
#define HSP_DCMDPTSR_PTRF0     HSP_DCMDPTSR_PTRF0_Msk            /*!< PTRF0 (Address pointer 0 flag) */
/*!< PTRF1 configuration */
#define HSP_DCMDPTSR_PTRF1_Pos (1U)
#define HSP_DCMDPTSR_PTRF1_Msk (0x1UL << HSP_DCMDPTSR_PTRF1_Pos) /*!< 0x00000002 */
#define HSP_DCMDPTSR_PTRF1     HSP_DCMDPTSR_PTRF1_Msk            /*!< PTRF1 (Address pointer 1 flag) */
/*!< PTRF2 configuration */
#define HSP_DCMDPTSR_PTRF2_Pos (2U)
#define HSP_DCMDPTSR_PTRF2_Msk (0x1UL << HSP_DCMDPTSR_PTRF2_Pos) /*!< 0x00000004 */
#define HSP_DCMDPTSR_PTRF2     HSP_DCMDPTSR_PTRF2_Msk            /*!< PTRF2 (Address pointer 2 flag) */
/*!< RDOG configuration */
#define HSP_DCMDPTSR_RDOG_Pos  (15U)
#define HSP_DCMDPTSR_RDOG_Msk  (0x1UL << HSP_DCMDPTSR_RDOG_Pos)  /*!< 0x00008000 */
#define HSP_DCMDPTSR_RDOG      HSP_DCMDPTSR_RDOG_Msk             /*!< RDOG (Read on-going indicator) */

/********************  Bit definition for HSP_DCMDIDR register  ********************/
/*!< CMDID configuration */
#define HSP_DCMDIDR_CMDID_Pos (0U)
#define HSP_DCMDIDR_CMDID_Msk (0xFFFFUL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x0000FFFF */
#define HSP_DCMDIDR_CMDID     HSP_DCMDIDR_CMDID_Msk               /*!< CMDID[15:0] bits (Command ID) */
#define HSP_DCMDIDR_CMDID_0   (0x0001UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000001 */
#define HSP_DCMDIDR_CMDID_1   (0x0002UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000002 */
#define HSP_DCMDIDR_CMDID_2   (0x0004UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000004 */
#define HSP_DCMDIDR_CMDID_3   (0x0008UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000008 */
#define HSP_DCMDIDR_CMDID_4   (0x0010UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000010 */
#define HSP_DCMDIDR_CMDID_5   (0x0020UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000020 */
#define HSP_DCMDIDR_CMDID_6   (0x0040UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000040 */
#define HSP_DCMDIDR_CMDID_7   (0x0080UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000080 */
#define HSP_DCMDIDR_CMDID_8   (0x0100UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000100 */
#define HSP_DCMDIDR_CMDID_9   (0x0200UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000200 */
#define HSP_DCMDIDR_CMDID_10  (0x0400UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000400 */
#define HSP_DCMDIDR_CMDID_11  (0x0800UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00000800 */
#define HSP_DCMDIDR_CMDID_12  (0x1000UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00001000 */
#define HSP_DCMDIDR_CMDID_13  (0x2000UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00002000 */
#define HSP_DCMDIDR_CMDID_14  (0x4000UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00004000 */
#define HSP_DCMDIDR_CMDID_15  (0x8000UL << HSP_DCMDIDR_CMDID_Pos) /*!< 0x00008000 */

/********************  Bit definition for HSP_DCMDPTR0 register  ********************/
/*!< PTCPU configuration */
#define HSP_DCMDPTR0_PTCPU_Pos (0U)
#define HSP_DCMDPTR0_PTCPU_Msk (0xFFFFFFFFUL << HSP_DCMDPTR0_PTCPU_Pos) /*!< 0xFFFFFFFF */
#define HSP_DCMDPTR0_PTCPU     HSP_DCMDPTR0_PTCPU_Msk                   /*!< PTCPU[31:0] bits (Address pointer value) */
#define HSP_DCMDPTR0_PTCPU_0   (0x00001UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000001 */
#define HSP_DCMDPTR0_PTCPU_1   (0x00002UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000002 */
#define HSP_DCMDPTR0_PTCPU_2   (0x00004UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000004 */
#define HSP_DCMDPTR0_PTCPU_3   (0x00008UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000008 */
#define HSP_DCMDPTR0_PTCPU_4   (0x00010UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000010 */
#define HSP_DCMDPTR0_PTCPU_5   (0x00020UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000020 */
#define HSP_DCMDPTR0_PTCPU_6   (0x00040UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000040 */
#define HSP_DCMDPTR0_PTCPU_7   (0x00080UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000080 */
#define HSP_DCMDPTR0_PTCPU_8   (0x00100UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000100 */
#define HSP_DCMDPTR0_PTCPU_9   (0x00200UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000200 */
#define HSP_DCMDPTR0_PTCPU_10  (0x00400UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000400 */
#define HSP_DCMDPTR0_PTCPU_11  (0x00800UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00000800 */
#define HSP_DCMDPTR0_PTCPU_12  (0x01000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00001000 */
#define HSP_DCMDPTR0_PTCPU_13  (0x02000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00002000 */
#define HSP_DCMDPTR0_PTCPU_14  (0x04000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00004000 */
#define HSP_DCMDPTR0_PTCPU_15  (0x08000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00008000 */
#define HSP_DCMDPTR0_PTCPU_16  (0x10000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00010000 */
#define HSP_DCMDPTR0_PTCPU_17  (0x20000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00020000 */
#define HSP_DCMDPTR0_PTCPU_18  (0x40000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00040000 */
#define HSP_DCMDPTR0_PTCPU_19  (0x80000UL << HSP_DCMDPTR0_PTCPU_Pos)    /*!< 0x00080000 */
#define HSP_DCMDPTR0_PTCPU_20  (0x100000UL << HSP_DCMDPTR0_PTCPU_Pos)   /*!< 0x00100000 */
#define HSP_DCMDPTR0_PTCPU_21  (0x200000UL << HSP_DCMDPTR0_PTCPU_Pos)   /*!< 0x00200000 */
#define HSP_DCMDPTR0_PTCPU_22  (0x400000UL << HSP_DCMDPTR0_PTCPU_Pos)   /*!< 0x00400000 */
#define HSP_DCMDPTR0_PTCPU_23  (0x800000UL << HSP_DCMDPTR0_PTCPU_Pos)   /*!< 0x00800000 */
#define HSP_DCMDPTR0_PTCPU_24  (0x1000000UL << HSP_DCMDPTR0_PTCPU_Pos)  /*!< 0x01000000 */
#define HSP_DCMDPTR0_PTCPU_25  (0x2000000UL << HSP_DCMDPTR0_PTCPU_Pos)  /*!< 0x02000000 */
#define HSP_DCMDPTR0_PTCPU_26  (0x4000000UL << HSP_DCMDPTR0_PTCPU_Pos)  /*!< 0x04000000 */
#define HSP_DCMDPTR0_PTCPU_27  (0x8000000UL << HSP_DCMDPTR0_PTCPU_Pos)  /*!< 0x08000000 */
#define HSP_DCMDPTR0_PTCPU_28  (0x10000000UL << HSP_DCMDPTR0_PTCPU_Pos) /*!< 0x10000000 */
#define HSP_DCMDPTR0_PTCPU_29  (0x20000000UL << HSP_DCMDPTR0_PTCPU_Pos) /*!< 0x20000000 */
#define HSP_DCMDPTR0_PTCPU_30  (0x40000000UL << HSP_DCMDPTR0_PTCPU_Pos) /*!< 0x40000000 */
#define HSP_DCMDPTR0_PTCPU_31  (0x80000000UL << HSP_DCMDPTR0_PTCPU_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_DCMDPTR1 register  ********************/
/*!< PTCPU configuration */
#define HSP_DCMDPTR1_PTCPU_Pos (0U)
#define HSP_DCMDPTR1_PTCPU_Msk (0xFFFFFFFFUL << HSP_DCMDPTR1_PTCPU_Pos) /*!< 0xFFFFFFFF */
#define HSP_DCMDPTR1_PTCPU     HSP_DCMDPTR1_PTCPU_Msk                   /*!< PTCPU[31:0] bits (Address pointer value) */
#define HSP_DCMDPTR1_PTCPU_0   (0x00001UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000001 */
#define HSP_DCMDPTR1_PTCPU_1   (0x00002UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000002 */
#define HSP_DCMDPTR1_PTCPU_2   (0x00004UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000004 */
#define HSP_DCMDPTR1_PTCPU_3   (0x00008UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000008 */
#define HSP_DCMDPTR1_PTCPU_4   (0x00010UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000010 */
#define HSP_DCMDPTR1_PTCPU_5   (0x00020UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000020 */
#define HSP_DCMDPTR1_PTCPU_6   (0x00040UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000040 */
#define HSP_DCMDPTR1_PTCPU_7   (0x00080UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000080 */
#define HSP_DCMDPTR1_PTCPU_8   (0x00100UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000100 */
#define HSP_DCMDPTR1_PTCPU_9   (0x00200UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000200 */
#define HSP_DCMDPTR1_PTCPU_10  (0x00400UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000400 */
#define HSP_DCMDPTR1_PTCPU_11  (0x00800UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00000800 */
#define HSP_DCMDPTR1_PTCPU_12  (0x01000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00001000 */
#define HSP_DCMDPTR1_PTCPU_13  (0x02000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00002000 */
#define HSP_DCMDPTR1_PTCPU_14  (0x04000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00004000 */
#define HSP_DCMDPTR1_PTCPU_15  (0x08000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00008000 */
#define HSP_DCMDPTR1_PTCPU_16  (0x10000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00010000 */
#define HSP_DCMDPTR1_PTCPU_17  (0x20000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00020000 */
#define HSP_DCMDPTR1_PTCPU_18  (0x40000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00040000 */
#define HSP_DCMDPTR1_PTCPU_19  (0x80000UL << HSP_DCMDPTR1_PTCPU_Pos)    /*!< 0x00080000 */
#define HSP_DCMDPTR1_PTCPU_20  (0x100000UL << HSP_DCMDPTR1_PTCPU_Pos)   /*!< 0x00100000 */
#define HSP_DCMDPTR1_PTCPU_21  (0x200000UL << HSP_DCMDPTR1_PTCPU_Pos)   /*!< 0x00200000 */
#define HSP_DCMDPTR1_PTCPU_22  (0x400000UL << HSP_DCMDPTR1_PTCPU_Pos)   /*!< 0x00400000 */
#define HSP_DCMDPTR1_PTCPU_23  (0x800000UL << HSP_DCMDPTR1_PTCPU_Pos)   /*!< 0x00800000 */
#define HSP_DCMDPTR1_PTCPU_24  (0x1000000UL << HSP_DCMDPTR1_PTCPU_Pos)  /*!< 0x01000000 */
#define HSP_DCMDPTR1_PTCPU_25  (0x2000000UL << HSP_DCMDPTR1_PTCPU_Pos)  /*!< 0x02000000 */
#define HSP_DCMDPTR1_PTCPU_26  (0x4000000UL << HSP_DCMDPTR1_PTCPU_Pos)  /*!< 0x04000000 */
#define HSP_DCMDPTR1_PTCPU_27  (0x8000000UL << HSP_DCMDPTR1_PTCPU_Pos)  /*!< 0x08000000 */
#define HSP_DCMDPTR1_PTCPU_28  (0x10000000UL << HSP_DCMDPTR1_PTCPU_Pos) /*!< 0x10000000 */
#define HSP_DCMDPTR1_PTCPU_29  (0x20000000UL << HSP_DCMDPTR1_PTCPU_Pos) /*!< 0x20000000 */
#define HSP_DCMDPTR1_PTCPU_30  (0x40000000UL << HSP_DCMDPTR1_PTCPU_Pos) /*!< 0x40000000 */
#define HSP_DCMDPTR1_PTCPU_31  (0x80000000UL << HSP_DCMDPTR1_PTCPU_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_DCMDPTR2 register  ********************/
/*!< PTCPU configuration */
#define HSP_DCMDPTR2_PTCPU_Pos (0U)
#define HSP_DCMDPTR2_PTCPU_Msk (0xFFFFFFFFUL << HSP_DCMDPTR2_PTCPU_Pos) /*!< 0xFFFFFFFF */
#define HSP_DCMDPTR2_PTCPU     HSP_DCMDPTR2_PTCPU_Msk                   /*!< PTCPU[31:0] bits (Address pointer value) */
#define HSP_DCMDPTR2_PTCPU_0   (0x00001UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000001 */
#define HSP_DCMDPTR2_PTCPU_1   (0x00002UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000002 */
#define HSP_DCMDPTR2_PTCPU_2   (0x00004UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000004 */
#define HSP_DCMDPTR2_PTCPU_3   (0x00008UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000008 */
#define HSP_DCMDPTR2_PTCPU_4   (0x00010UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000010 */
#define HSP_DCMDPTR2_PTCPU_5   (0x00020UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000020 */
#define HSP_DCMDPTR2_PTCPU_6   (0x00040UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000040 */
#define HSP_DCMDPTR2_PTCPU_7   (0x00080UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000080 */
#define HSP_DCMDPTR2_PTCPU_8   (0x00100UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000100 */
#define HSP_DCMDPTR2_PTCPU_9   (0x00200UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000200 */
#define HSP_DCMDPTR2_PTCPU_10  (0x00400UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000400 */
#define HSP_DCMDPTR2_PTCPU_11  (0x00800UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00000800 */
#define HSP_DCMDPTR2_PTCPU_12  (0x01000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00001000 */
#define HSP_DCMDPTR2_PTCPU_13  (0x02000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00002000 */
#define HSP_DCMDPTR2_PTCPU_14  (0x04000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00004000 */
#define HSP_DCMDPTR2_PTCPU_15  (0x08000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00008000 */
#define HSP_DCMDPTR2_PTCPU_16  (0x10000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00010000 */
#define HSP_DCMDPTR2_PTCPU_17  (0x20000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00020000 */
#define HSP_DCMDPTR2_PTCPU_18  (0x40000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00040000 */
#define HSP_DCMDPTR2_PTCPU_19  (0x80000UL << HSP_DCMDPTR2_PTCPU_Pos)    /*!< 0x00080000 */
#define HSP_DCMDPTR2_PTCPU_20  (0x100000UL << HSP_DCMDPTR2_PTCPU_Pos)   /*!< 0x00100000 */
#define HSP_DCMDPTR2_PTCPU_21  (0x200000UL << HSP_DCMDPTR2_PTCPU_Pos)   /*!< 0x00200000 */
#define HSP_DCMDPTR2_PTCPU_22  (0x400000UL << HSP_DCMDPTR2_PTCPU_Pos)   /*!< 0x00400000 */
#define HSP_DCMDPTR2_PTCPU_23  (0x800000UL << HSP_DCMDPTR2_PTCPU_Pos)   /*!< 0x00800000 */
#define HSP_DCMDPTR2_PTCPU_24  (0x1000000UL << HSP_DCMDPTR2_PTCPU_Pos)  /*!< 0x01000000 */
#define HSP_DCMDPTR2_PTCPU_25  (0x2000000UL << HSP_DCMDPTR2_PTCPU_Pos)  /*!< 0x02000000 */
#define HSP_DCMDPTR2_PTCPU_26  (0x4000000UL << HSP_DCMDPTR2_PTCPU_Pos)  /*!< 0x04000000 */
#define HSP_DCMDPTR2_PTCPU_27  (0x8000000UL << HSP_DCMDPTR2_PTCPU_Pos)  /*!< 0x08000000 */
#define HSP_DCMDPTR2_PTCPU_28  (0x10000000UL << HSP_DCMDPTR2_PTCPU_Pos) /*!< 0x10000000 */
#define HSP_DCMDPTR2_PTCPU_29  (0x20000000UL << HSP_DCMDPTR2_PTCPU_Pos) /*!< 0x20000000 */
#define HSP_DCMDPTR2_PTCPU_30  (0x40000000UL << HSP_DCMDPTR2_PTCPU_Pos) /*!< 0x40000000 */
#define HSP_DCMDPTR2_PTCPU_31  (0x80000000UL << HSP_DCMDPTR2_PTCPU_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_EVTENR register  ********************/
/*!< EVTEN configuration */
#define HSP_EVTENR_EVTEN_Pos (1U)
#define HSP_EVTENR_EVTEN_Msk (0x3FFFFFUL << HSP_EVTENR_EVTEN_Pos) /*!< 0x007FFFFE */
#define HSP_EVTENR_EVTEN     HSP_EVTENR_EVTEN_Msk                 /*!< EVTEN[21:0] bits (Events enable) */
#define HSP_EVTENR_EVTEN_0   (0x0001UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000002 */
#define HSP_EVTENR_EVTEN_1   (0x0002UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000004 */
#define HSP_EVTENR_EVTEN_2   (0x0004UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000008 */
#define HSP_EVTENR_EVTEN_3   (0x0008UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000010 */
#define HSP_EVTENR_EVTEN_4   (0x0010UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000020 */
#define HSP_EVTENR_EVTEN_5   (0x0020UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000040 */
#define HSP_EVTENR_EVTEN_6   (0x0040UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000080 */
#define HSP_EVTENR_EVTEN_7   (0x0080UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000100 */
#define HSP_EVTENR_EVTEN_8   (0x0100UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000200 */
#define HSP_EVTENR_EVTEN_9   (0x0200UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000400 */
#define HSP_EVTENR_EVTEN_10  (0x0400UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00000800 */
#define HSP_EVTENR_EVTEN_11  (0x0800UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00001000 */
#define HSP_EVTENR_EVTEN_12  (0x1000UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00002000 */
#define HSP_EVTENR_EVTEN_13  (0x2000UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00004000 */
#define HSP_EVTENR_EVTEN_14  (0x4000UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00008000 */
#define HSP_EVTENR_EVTEN_15  (0x8000UL << HSP_EVTENR_EVTEN_Pos)   /*!< 0x00010000 */
#define HSP_EVTENR_EVTEN_16  (0x10000UL << HSP_EVTENR_EVTEN_Pos)  /*!< 0x00020000 */
#define HSP_EVTENR_EVTEN_17  (0x20000UL << HSP_EVTENR_EVTEN_Pos)  /*!< 0x00040000 */
#define HSP_EVTENR_EVTEN_18  (0x40000UL << HSP_EVTENR_EVTEN_Pos)  /*!< 0x00080000 */
#define HSP_EVTENR_EVTEN_19  (0x80000UL << HSP_EVTENR_EVTEN_Pos)  /*!< 0x00100000 */
#define HSP_EVTENR_EVTEN_20  (0x100000UL << HSP_EVTENR_EVTEN_Pos) /*!< 0x00200000 */
#define HSP_EVTENR_EVTEN_21  (0x200000UL << HSP_EVTENR_EVTEN_Pos) /*!< 0x00400000 */

/********************  Bit definition for HSP_ESYNCENR register  ********************/
/*!< EVTSYNCEN configuration */
#define HSP_ESYNCENR_EVTSYNCEN_Pos  (1U)
#define HSP_ESYNCENR_EVTSYNCEN_Msk  (0x3FFFFFUL << HSP_ESYNCENR_EVTSYNCEN_Pos) /*!< 0x007FFFFE */
#define HSP_ESYNCENR_EVTSYNCEN      HSP_ESYNCENR_EVTSYNCEN_Msk                 /*!< EVTSYNCEN[21:0] bits (Event synchronization enable) */
#define HSP_ESYNCENR_EVTSYNCEN_0    (0x0001UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000002 */
#define HSP_ESYNCENR_EVTSYNCEN_1    (0x0002UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000004 */
#define HSP_ESYNCENR_EVTSYNCEN_2    (0x0004UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000008 */
#define HSP_ESYNCENR_EVTSYNCEN_3    (0x0008UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000010 */
#define HSP_ESYNCENR_EVTSYNCEN_4    (0x0010UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000020 */
#define HSP_ESYNCENR_EVTSYNCEN_5    (0x0020UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000040 */
#define HSP_ESYNCENR_EVTSYNCEN_6    (0x0040UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000080 */
#define HSP_ESYNCENR_EVTSYNCEN_7    (0x0080UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000100 */
#define HSP_ESYNCENR_EVTSYNCEN_8    (0x0100UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000200 */
#define HSP_ESYNCENR_EVTSYNCEN_9    (0x0200UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000400 */
#define HSP_ESYNCENR_EVTSYNCEN_10   (0x0400UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00000800 */
#define HSP_ESYNCENR_EVTSYNCEN_11   (0x0800UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00001000 */
#define HSP_ESYNCENR_EVTSYNCEN_12   (0x1000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00002000 */
#define HSP_ESYNCENR_EVTSYNCEN_13   (0x2000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00004000 */
#define HSP_ESYNCENR_EVTSYNCEN_14   (0x4000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00008000 */
#define HSP_ESYNCENR_EVTSYNCEN_15   (0x8000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)   /*!< 0x00010000 */
#define HSP_ESYNCENR_EVTSYNCEN_16   (0x10000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)  /*!< 0x00020000 */
#define HSP_ESYNCENR_EVTSYNCEN_17   (0x20000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)  /*!< 0x00040000 */
#define HSP_ESYNCENR_EVTSYNCEN_18   (0x40000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)  /*!< 0x00080000 */
#define HSP_ESYNCENR_EVTSYNCEN_19   (0x80000UL << HSP_ESYNCENR_EVTSYNCEN_Pos)  /*!< 0x00100000 */
#define HSP_ESYNCENR_EVTSYNCEN_20   (0x100000UL << HSP_ESYNCENR_EVTSYNCEN_Pos) /*!< 0x00200000 */
#define HSP_ESYNCENR_EVTSYNCEN_21   (0x200000UL << HSP_ESYNCENR_EVTSYNCEN_Pos) /*!< 0x00400000 */
/*!< CDEGSYNCEN configuration */
#define HSP_ESYNCENR_CDEGSYNCEN_Pos (26U)
#define HSP_ESYNCENR_CDEGSYNCEN_Msk (0x1UL << HSP_ESYNCENR_CDEGSYNCEN_Pos)     /*!< 0x04000000 */
#define HSP_ESYNCENR_CDEGSYNCEN     HSP_ESYNCENR_CDEGSYNCEN_Msk                /*!< CDEGSYNCEN (CPU dedicated event synchronization enable) */

/********************  Bit definition for HSP_ESYNC0SRCR register  ********************/
/*!< EV1SSRC configuration */
#define HSP_ESYNC0SRCR_EV1SSRC_Pos (0U)
#define HSP_ESYNC0SRCR_EV1SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV1SSRC_Pos) /*!< 0x00000003 */
#define HSP_ESYNC0SRCR_EV1SSRC     HSP_ESYNC0SRCR_EV1SSRC_Msk            /*!< EV1SSRC[1:0] bits (Event 1 synchronization source) */
#define HSP_ESYNC0SRCR_EV1SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV1SSRC_Pos) /*!< 0x00000001 */
#define HSP_ESYNC0SRCR_EV1SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV1SSRC_Pos) /*!< 0x00000002 */
/*!< EV2SSRC configuration */
#define HSP_ESYNC0SRCR_EV2SSRC_Pos (4U)
#define HSP_ESYNC0SRCR_EV2SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV2SSRC_Pos) /*!< 0x00000030 */
#define HSP_ESYNC0SRCR_EV2SSRC     HSP_ESYNC0SRCR_EV2SSRC_Msk            /*!< EV2SSRC[1:0] bits (Event 2 synchronization source) */
#define HSP_ESYNC0SRCR_EV2SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV2SSRC_Pos) /*!< 0x00000010 */
#define HSP_ESYNC0SRCR_EV2SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV2SSRC_Pos) /*!< 0x00000020 */
/*!< EV3SSRC configuration */
#define HSP_ESYNC0SRCR_EV3SSRC_Pos (8U)
#define HSP_ESYNC0SRCR_EV3SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV3SSRC_Pos) /*!< 0x00000300 */
#define HSP_ESYNC0SRCR_EV3SSRC     HSP_ESYNC0SRCR_EV3SSRC_Msk            /*!< EV3SSRC[1:0] bits (Event 3 synchronization source) */
#define HSP_ESYNC0SRCR_EV3SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV3SSRC_Pos) /*!< 0x00000100 */
#define HSP_ESYNC0SRCR_EV3SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV3SSRC_Pos) /*!< 0x00000200 */
/*!< EV4SSRC configuration */
#define HSP_ESYNC0SRCR_EV4SSRC_Pos (12U)
#define HSP_ESYNC0SRCR_EV4SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV4SSRC_Pos) /*!< 0x00003000 */
#define HSP_ESYNC0SRCR_EV4SSRC     HSP_ESYNC0SRCR_EV4SSRC_Msk            /*!< EV4SSRC[1:0] bits (Event 4 synchronization source) */
#define HSP_ESYNC0SRCR_EV4SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV4SSRC_Pos) /*!< 0x00001000 */
#define HSP_ESYNC0SRCR_EV4SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV4SSRC_Pos) /*!< 0x00002000 */
/*!< EV5SSRC configuration */
#define HSP_ESYNC0SRCR_EV5SSRC_Pos (16U)
#define HSP_ESYNC0SRCR_EV5SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV5SSRC_Pos) /*!< 0x00030000 */
#define HSP_ESYNC0SRCR_EV5SSRC     HSP_ESYNC0SRCR_EV5SSRC_Msk            /*!< EV5SSRC[1:0] bits (Event 5 synchronization source) */
#define HSP_ESYNC0SRCR_EV5SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV5SSRC_Pos) /*!< 0x00010000 */
#define HSP_ESYNC0SRCR_EV5SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV5SSRC_Pos) /*!< 0x00020000 */
/*!< EV6SSRC configuration */
#define HSP_ESYNC0SRCR_EV6SSRC_Pos (20U)
#define HSP_ESYNC0SRCR_EV6SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV6SSRC_Pos) /*!< 0x00300000 */
#define HSP_ESYNC0SRCR_EV6SSRC     HSP_ESYNC0SRCR_EV6SSRC_Msk            /*!< EV6SSRC[1:0] bits (Event 6 synchronization source) */
#define HSP_ESYNC0SRCR_EV6SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV6SSRC_Pos) /*!< 0x00100000 */
#define HSP_ESYNC0SRCR_EV6SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV6SSRC_Pos) /*!< 0x00200000 */
/*!< EV7SSRC configuration */
#define HSP_ESYNC0SRCR_EV7SSRC_Pos (24U)
#define HSP_ESYNC0SRCR_EV7SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV7SSRC_Pos) /*!< 0x03000000 */
#define HSP_ESYNC0SRCR_EV7SSRC     HSP_ESYNC0SRCR_EV7SSRC_Msk            /*!< EV7SSRC[1:0] bits (Event 7 synchronization source) */
#define HSP_ESYNC0SRCR_EV7SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV7SSRC_Pos) /*!< 0x01000000 */
#define HSP_ESYNC0SRCR_EV7SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV7SSRC_Pos) /*!< 0x02000000 */
/*!< EV8SSRC configuration */
#define HSP_ESYNC0SRCR_EV8SSRC_Pos (28U)
#define HSP_ESYNC0SRCR_EV8SSRC_Msk (0x3UL << HSP_ESYNC0SRCR_EV8SSRC_Pos) /*!< 0x30000000 */
#define HSP_ESYNC0SRCR_EV8SSRC     HSP_ESYNC0SRCR_EV8SSRC_Msk            /*!< EV8SSRC[1:0] bits (Event 8 synchronization source) */
#define HSP_ESYNC0SRCR_EV8SSRC_0   (0x1UL << HSP_ESYNC0SRCR_EV8SSRC_Pos) /*!< 0x10000000 */
#define HSP_ESYNC0SRCR_EV8SSRC_1   (0x2UL << HSP_ESYNC0SRCR_EV8SSRC_Pos) /*!< 0x20000000 */

/********************  Bit definition for HSP_ESYNC1SRCR register  ********************/
/*!< EV9SSRC configuration */
#define HSP_ESYNC1SRCR_EV9SSRC_Pos  (0U)
#define HSP_ESYNC1SRCR_EV9SSRC_Msk  (0x3UL << HSP_ESYNC1SRCR_EV9SSRC_Pos)  /*!< 0x00000003 */
#define HSP_ESYNC1SRCR_EV9SSRC      HSP_ESYNC1SRCR_EV9SSRC_Msk             /*!< EV9SSRC[1:0] bits (Event 9 synchronization source) */
#define HSP_ESYNC1SRCR_EV9SSRC_0    (0x1UL << HSP_ESYNC1SRCR_EV9SSRC_Pos)  /*!< 0x00000001 */
#define HSP_ESYNC1SRCR_EV9SSRC_1    (0x2UL << HSP_ESYNC1SRCR_EV9SSRC_Pos)  /*!< 0x00000002 */
/*!< EV10SSRC configuration */
#define HSP_ESYNC1SRCR_EV10SSRC_Pos (4U)
#define HSP_ESYNC1SRCR_EV10SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV10SSRC_Pos) /*!< 0x00000030 */
#define HSP_ESYNC1SRCR_EV10SSRC     HSP_ESYNC1SRCR_EV10SSRC_Msk            /*!< EV10SSRC[1:0] bits (Event 10 synchronization source) */
#define HSP_ESYNC1SRCR_EV10SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV10SSRC_Pos) /*!< 0x00000010 */
#define HSP_ESYNC1SRCR_EV10SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV10SSRC_Pos) /*!< 0x00000020 */
/*!< EV11SSRC configuration */
#define HSP_ESYNC1SRCR_EV11SSRC_Pos (8U)
#define HSP_ESYNC1SRCR_EV11SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV11SSRC_Pos) /*!< 0x00000300 */
#define HSP_ESYNC1SRCR_EV11SSRC     HSP_ESYNC1SRCR_EV11SSRC_Msk            /*!< EV11SSRC[1:0] bits (Event 11 synchronization source) */
#define HSP_ESYNC1SRCR_EV11SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV11SSRC_Pos) /*!< 0x00000100 */
#define HSP_ESYNC1SRCR_EV11SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV11SSRC_Pos) /*!< 0x00000200 */
/*!< EV12SSRC configuration */
#define HSP_ESYNC1SRCR_EV12SSRC_Pos (12U)
#define HSP_ESYNC1SRCR_EV12SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV12SSRC_Pos) /*!< 0x00003000 */
#define HSP_ESYNC1SRCR_EV12SSRC     HSP_ESYNC1SRCR_EV12SSRC_Msk            /*!< EV12SSRC[1:0] bits (Event 12 synchronization source) */
#define HSP_ESYNC1SRCR_EV12SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV12SSRC_Pos) /*!< 0x00001000 */
#define HSP_ESYNC1SRCR_EV12SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV12SSRC_Pos) /*!< 0x00002000 */
/*!< EV13SSRC configuration */
#define HSP_ESYNC1SRCR_EV13SSRC_Pos (16U)
#define HSP_ESYNC1SRCR_EV13SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV13SSRC_Pos) /*!< 0x00030000 */
#define HSP_ESYNC1SRCR_EV13SSRC     HSP_ESYNC1SRCR_EV13SSRC_Msk            /*!< EV13SSRC[1:0] bits (Event 13 synchronization source) */
#define HSP_ESYNC1SRCR_EV13SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV13SSRC_Pos) /*!< 0x00010000 */
#define HSP_ESYNC1SRCR_EV13SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV13SSRC_Pos) /*!< 0x00020000 */
/*!< EV14SSRC configuration */
#define HSP_ESYNC1SRCR_EV14SSRC_Pos (20U)
#define HSP_ESYNC1SRCR_EV14SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV14SSRC_Pos) /*!< 0x00300000 */
#define HSP_ESYNC1SRCR_EV14SSRC     HSP_ESYNC1SRCR_EV14SSRC_Msk            /*!< EV14SSRC[1:0] bits (Event 14 synchronization source) */
#define HSP_ESYNC1SRCR_EV14SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV14SSRC_Pos) /*!< 0x00100000 */
#define HSP_ESYNC1SRCR_EV14SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV14SSRC_Pos) /*!< 0x00200000 */
/*!< EV15SSRC configuration */
#define HSP_ESYNC1SRCR_EV15SSRC_Pos (24U)
#define HSP_ESYNC1SRCR_EV15SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV15SSRC_Pos) /*!< 0x03000000 */
#define HSP_ESYNC1SRCR_EV15SSRC     HSP_ESYNC1SRCR_EV15SSRC_Msk            /*!< EV15SSRC[1:0] bits (Event 15 synchronization source) */
#define HSP_ESYNC1SRCR_EV15SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV15SSRC_Pos) /*!< 0x01000000 */
#define HSP_ESYNC1SRCR_EV15SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV15SSRC_Pos) /*!< 0x02000000 */
/*!< EV16SSRC configuration */
#define HSP_ESYNC1SRCR_EV16SSRC_Pos (28U)
#define HSP_ESYNC1SRCR_EV16SSRC_Msk (0x3UL << HSP_ESYNC1SRCR_EV16SSRC_Pos) /*!< 0x30000000 */
#define HSP_ESYNC1SRCR_EV16SSRC     HSP_ESYNC1SRCR_EV16SSRC_Msk            /*!< EV16SSRC[1:0] bits (Event 16 synchronization source) */
#define HSP_ESYNC1SRCR_EV16SSRC_0   (0x1UL << HSP_ESYNC1SRCR_EV16SSRC_Pos) /*!< 0x10000000 */
#define HSP_ESYNC1SRCR_EV16SSRC_1   (0x2UL << HSP_ESYNC1SRCR_EV16SSRC_Pos) /*!< 0x20000000 */

/********************  Bit definition for HSP_ESYNC2SRCR register  ********************/
/*!< EV17SSRC configuration */
#define HSP_ESYNC2SRCR_EV17SSRC_Pos (0U)
#define HSP_ESYNC2SRCR_EV17SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV17SSRC_Pos) /*!< 0x00000003 */
#define HSP_ESYNC2SRCR_EV17SSRC     HSP_ESYNC2SRCR_EV17SSRC_Msk            /*!< EV17SSRC[1:0] bits (Event 17 synchronization source) */
#define HSP_ESYNC2SRCR_EV17SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV17SSRC_Pos) /*!< 0x00000001 */
#define HSP_ESYNC2SRCR_EV17SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV17SSRC_Pos) /*!< 0x00000002 */
/*!< EV18SSRC configuration */
#define HSP_ESYNC2SRCR_EV18SSRC_Pos (4U)
#define HSP_ESYNC2SRCR_EV18SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV18SSRC_Pos) /*!< 0x00000030 */
#define HSP_ESYNC2SRCR_EV18SSRC     HSP_ESYNC2SRCR_EV18SSRC_Msk            /*!< EV18SSRC[1:0] bits (Event 18 synchronization source) */
#define HSP_ESYNC2SRCR_EV18SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV18SSRC_Pos) /*!< 0x00000010 */
#define HSP_ESYNC2SRCR_EV18SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV18SSRC_Pos) /*!< 0x00000020 */
/*!< EV19SSRC configuration */
#define HSP_ESYNC2SRCR_EV19SSRC_Pos (8U)
#define HSP_ESYNC2SRCR_EV19SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV19SSRC_Pos) /*!< 0x00000300 */
#define HSP_ESYNC2SRCR_EV19SSRC     HSP_ESYNC2SRCR_EV19SSRC_Msk            /*!< EV19SSRC[1:0] bits (Event 19 synchronization source) */
#define HSP_ESYNC2SRCR_EV19SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV19SSRC_Pos) /*!< 0x00000100 */
#define HSP_ESYNC2SRCR_EV19SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV19SSRC_Pos) /*!< 0x00000200 */
/*!< EV20SSRC configuration */
#define HSP_ESYNC2SRCR_EV20SSRC_Pos (12U)
#define HSP_ESYNC2SRCR_EV20SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV20SSRC_Pos) /*!< 0x00003000 */
#define HSP_ESYNC2SRCR_EV20SSRC     HSP_ESYNC2SRCR_EV20SSRC_Msk            /*!< EV20SSRC[1:0] bits (Event 20 synchronization source) */
#define HSP_ESYNC2SRCR_EV20SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV20SSRC_Pos) /*!< 0x00001000 */
#define HSP_ESYNC2SRCR_EV20SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV20SSRC_Pos) /*!< 0x00002000 */
/*!< EV21SSRC configuration */
#define HSP_ESYNC2SRCR_EV21SSRC_Pos (16U)
#define HSP_ESYNC2SRCR_EV21SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV21SSRC_Pos) /*!< 0x00030000 */
#define HSP_ESYNC2SRCR_EV21SSRC     HSP_ESYNC2SRCR_EV21SSRC_Msk            /*!< EV21SSRC[1:0] bits (Event 21 synchronization source) */
#define HSP_ESYNC2SRCR_EV21SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV21SSRC_Pos) /*!< 0x00010000 */
#define HSP_ESYNC2SRCR_EV21SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV21SSRC_Pos) /*!< 0x00020000 */
/*!< EV22SSRC configuration */
#define HSP_ESYNC2SRCR_EV22SSRC_Pos (20U)
#define HSP_ESYNC2SRCR_EV22SSRC_Msk (0x3UL << HSP_ESYNC2SRCR_EV22SSRC_Pos) /*!< 0x00300000 */
#define HSP_ESYNC2SRCR_EV22SSRC     HSP_ESYNC2SRCR_EV22SSRC_Msk            /*!< EV22SSRC[1:0] bits (Event 22 synchronization source) */
#define HSP_ESYNC2SRCR_EV22SSRC_0   (0x1UL << HSP_ESYNC2SRCR_EV22SSRC_Pos) /*!< 0x00100000 */
#define HSP_ESYNC2SRCR_EV22SSRC_1   (0x2UL << HSP_ESYNC2SRCR_EV22SSRC_Pos) /*!< 0x00200000 */
/*!< CDEGSSRC configuration */
#define HSP_ESYNC2SRCR_CDEGSSRC_Pos (30U)
#define HSP_ESYNC2SRCR_CDEGSSRC_Msk (0x3UL << HSP_ESYNC2SRCR_CDEGSSRC_Pos) /*!< 0xC0000000 */
#define HSP_ESYNC2SRCR_CDEGSSRC     HSP_ESYNC2SRCR_CDEGSSRC_Msk            /*!< CDEGSSRC[1:0] bits (CPU dedicated event synchronization source) */
#define HSP_ESYNC2SRCR_CDEGSSRC_0   (0x1UL << HSP_ESYNC2SRCR_CDEGSSRC_Pos) /*!< 0x40000000 */
#define HSP_ESYNC2SRCR_CDEGSSRC_1   (0x2UL << HSP_ESYNC2SRCR_CDEGSSRC_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_PEVTLR register  ********************/
/*!< EVTL configuration */
#define HSP_PEVTLR_EVTL_Pos (0U)
#define HSP_PEVTLR_EVTL_Msk (0xFFFFFFFUL << HSP_PEVTLR_EVTL_Pos) /*!< 0x0FFFFFFF */
#define HSP_PEVTLR_EVTL     HSP_PEVTLR_EVTL_Msk                  /*!< EVTL[27:0] bits (Event level) */
#define HSP_PEVTLR_EVTL_0   (0x0001UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000001 */
#define HSP_PEVTLR_EVTL_1   (0x0002UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000002 */
#define HSP_PEVTLR_EVTL_2   (0x0004UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000004 */
#define HSP_PEVTLR_EVTL_3   (0x0008UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000008 */
#define HSP_PEVTLR_EVTL_4   (0x0010UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000010 */
#define HSP_PEVTLR_EVTL_5   (0x0020UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000020 */
#define HSP_PEVTLR_EVTL_6   (0x0040UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000040 */
#define HSP_PEVTLR_EVTL_7   (0x0080UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000080 */
#define HSP_PEVTLR_EVTL_8   (0x0100UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000100 */
#define HSP_PEVTLR_EVTL_9   (0x0200UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000200 */
#define HSP_PEVTLR_EVTL_10  (0x0400UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000400 */
#define HSP_PEVTLR_EVTL_11  (0x0800UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00000800 */
#define HSP_PEVTLR_EVTL_12  (0x1000UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00001000 */
#define HSP_PEVTLR_EVTL_13  (0x2000UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00002000 */
#define HSP_PEVTLR_EVTL_14  (0x4000UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00004000 */
#define HSP_PEVTLR_EVTL_15  (0x8000UL << HSP_PEVTLR_EVTL_Pos)    /*!< 0x00008000 */
#define HSP_PEVTLR_EVTL_16  (0x10000UL << HSP_PEVTLR_EVTL_Pos)   /*!< 0x00010000 */
#define HSP_PEVTLR_EVTL_17  (0x20000UL << HSP_PEVTLR_EVTL_Pos)   /*!< 0x00020000 */
#define HSP_PEVTLR_EVTL_18  (0x40000UL << HSP_PEVTLR_EVTL_Pos)   /*!< 0x00040000 */
#define HSP_PEVTLR_EVTL_19  (0x80000UL << HSP_PEVTLR_EVTL_Pos)   /*!< 0x00080000 */
#define HSP_PEVTLR_EVTL_20  (0x100000UL << HSP_PEVTLR_EVTL_Pos)  /*!< 0x00100000 */
#define HSP_PEVTLR_EVTL_21  (0x200000UL << HSP_PEVTLR_EVTL_Pos)  /*!< 0x00200000 */
#define HSP_PEVTLR_EVTL_22  (0x400000UL << HSP_PEVTLR_EVTL_Pos)  /*!< 0x00400000 */
#define HSP_PEVTLR_EVTL_23  (0x800000UL << HSP_PEVTLR_EVTL_Pos)  /*!< 0x00800000 */
#define HSP_PEVTLR_EVTL_24  (0x1000000UL << HSP_PEVTLR_EVTL_Pos) /*!< 0x01000000 */
#define HSP_PEVTLR_EVTL_25  (0x2000000UL << HSP_PEVTLR_EVTL_Pos) /*!< 0x02000000 */
#define HSP_PEVTLR_EVTL_26  (0x4000000UL << HSP_PEVTLR_EVTL_Pos) /*!< 0x04000000 */
#define HSP_PEVTLR_EVTL_27  (0x8000000UL << HSP_PEVTLR_EVTL_Pos) /*!< 0x08000000 */

/********************  Bit definition for HSP_ITFENR register  ********************/
/*!< STREAMEN configuration */
#define HSP_ITFENR_STREAMEN_Pos (8U)
#define HSP_ITFENR_STREAMEN_Msk (0x1UL << HSP_ITFENR_STREAMEN_Pos) /*!< 0x00000100 */
#define HSP_ITFENR_STREAMEN     HSP_ITFENR_STREAMEN_Msk            /*!< STREAMEN (STREAMITF enable <sup>(1)</sup>) */
/*!< TRGOEN configuration */
#define HSP_ITFENR_TRGOEN_Pos   (12U)
#define HSP_ITFENR_TRGOEN_Msk   (0x1UL << HSP_ITFENR_TRGOEN_Pos)   /*!< 0x00001000 */
#define HSP_ITFENR_TRGOEN       HSP_ITFENR_TRGOEN_Msk              /*!< TRGOEN (TRGO enable bit <sup>(1)</sup>) */
/*!< TRGI0EN configuration */
#define HSP_ITFENR_TRGI0EN_Pos  (16U)
#define HSP_ITFENR_TRGI0EN_Msk  (0x1UL << HSP_ITFENR_TRGI0EN_Pos)  /*!< 0x00010000 */
#define HSP_ITFENR_TRGI0EN      HSP_ITFENR_TRGI0EN_Msk             /*!< TRGI0EN (TRGIN0 enable bit <sup>(1)</sup>) */
/*!< TRGI1EN configuration */
#define HSP_ITFENR_TRGI1EN_Pos  (17U)
#define HSP_ITFENR_TRGI1EN_Msk  (0x1UL << HSP_ITFENR_TRGI1EN_Pos)  /*!< 0x00020000 */
#define HSP_ITFENR_TRGI1EN      HSP_ITFENR_TRGI1EN_Msk             /*!< TRGI1EN (TRGIN1 enable bit <sup>(1)</sup>) */
/*!< TRGI2EN configuration */
#define HSP_ITFENR_TRGI2EN_Pos  (18U)
#define HSP_ITFENR_TRGI2EN_Msk  (0x1UL << HSP_ITFENR_TRGI2EN_Pos)  /*!< 0x00040000 */
#define HSP_ITFENR_TRGI2EN      HSP_ITFENR_TRGI2EN_Msk             /*!< TRGI2EN (TRGIN2 enable bit <sup>(1)</sup>) */
/*!< TRGI3EN configuration */
#define HSP_ITFENR_TRGI3EN_Pos  (19U)
#define HSP_ITFENR_TRGI3EN_Msk  (0x1UL << HSP_ITFENR_TRGI3EN_Pos)  /*!< 0x00080000 */
#define HSP_ITFENR_TRGI3EN      HSP_ITFENR_TRGI3EN_Msk             /*!< TRGI3EN (TRGIN3 enable bit <sup>(1)</sup>) */
/*!< TRGI4EN configuration */
#define HSP_ITFENR_TRGI4EN_Pos  (20U)
#define HSP_ITFENR_TRGI4EN_Msk  (0x1UL << HSP_ITFENR_TRGI4EN_Pos)  /*!< 0x00100000 */
#define HSP_ITFENR_TRGI4EN      HSP_ITFENR_TRGI4EN_Msk             /*!< TRGI4EN (TRGIN4 enable bit <sup>(1)</sup>) */
/*!< TRGI5EN configuration */
#define HSP_ITFENR_TRGI5EN_Pos  (21U)
#define HSP_ITFENR_TRGI5EN_Msk  (0x1UL << HSP_ITFENR_TRGI5EN_Pos)  /*!< 0x00200000 */
#define HSP_ITFENR_TRGI5EN      HSP_ITFENR_TRGI5EN_Msk             /*!< TRGI5EN (TRGIN5 enable bit <sup>(1)</sup>) */
/*!< TRGI6EN configuration */
#define HSP_ITFENR_TRGI6EN_Pos  (22U)
#define HSP_ITFENR_TRGI6EN_Msk  (0x1UL << HSP_ITFENR_TRGI6EN_Pos)  /*!< 0x00400000 */
#define HSP_ITFENR_TRGI6EN      HSP_ITFENR_TRGI6EN_Msk             /*!< TRGI6EN (TRGIN6 enable bit <sup>(1)</sup>) */
/*!< TRGI7EN configuration */
#define HSP_ITFENR_TRGI7EN_Pos  (23U)
#define HSP_ITFENR_TRGI7EN_Msk  (0x1UL << HSP_ITFENR_TRGI7EN_Pos)  /*!< 0x00800000 */
#define HSP_ITFENR_TRGI7EN      HSP_ITFENR_TRGI7EN_Msk             /*!< TRGI7EN (TRGIN7 enable bit <sup>(1)</sup>) */
/*!< TRGI8EN configuration */
#define HSP_ITFENR_TRGI8EN_Pos  (24U)
#define HSP_ITFENR_TRGI8EN_Msk  (0x1UL << HSP_ITFENR_TRGI8EN_Pos)  /*!< 0x01000000 */
#define HSP_ITFENR_TRGI8EN      HSP_ITFENR_TRGI8EN_Msk             /*!< TRGI8EN (TRGIN8 enable bit <sup>(1)</sup>) */
/*!< TRGI9EN configuration */
#define HSP_ITFENR_TRGI9EN_Pos  (25U)
#define HSP_ITFENR_TRGI9EN_Msk  (0x1UL << HSP_ITFENR_TRGI9EN_Pos)  /*!< 0x02000000 */
#define HSP_ITFENR_TRGI9EN      HSP_ITFENR_TRGI9EN_Msk             /*!< TRGI9EN (TRGIN9 enable bit <sup>(1)</sup>) */
/*!< DCMDDIS configuration */
#define HSP_ITFENR_DCMDDIS_Pos  (27U)
#define HSP_ITFENR_DCMDDIS_Msk  (0x1UL << HSP_ITFENR_DCMDDIS_Pos)  /*!< 0x08000000 */
#define HSP_ITFENR_DCMDDIS      HSP_ITFENR_DCMDDIS_Msk             /*!< DCMDDIS (Direct command interface disable bit ) */
/*!< CSEGEN configuration */
#define HSP_ITFENR_CSEGEN_Pos   (28U)
#define HSP_ITFENR_CSEGEN_Msk   (0x1UL << HSP_ITFENR_CSEGEN_Pos)   /*!< 0x10000000 */
#define HSP_ITFENR_CSEGEN       HSP_ITFENR_CSEGEN_Msk              /*!< CSEGEN (CSEG interface enable bit <sup>(1)</sup>) */
/*!< CDEGEN configuration */
#define HSP_ITFENR_CDEGEN_Pos   (29U)
#define HSP_ITFENR_CDEGEN_Msk   (0x1UL << HSP_ITFENR_CDEGEN_Pos)   /*!< 0x20000000 */
#define HSP_ITFENR_CDEGEN       HSP_ITFENR_CDEGEN_Msk              /*!< CDEGEN (CDEG interface enable bit ) */
/*!< HSEGEN configuration */
#define HSP_ITFENR_HSEGEN_Pos   (30U)
#define HSP_ITFENR_HSEGEN_Msk   (0x1UL << HSP_ITFENR_HSEGEN_Pos)   /*!< 0x40000000 */
#define HSP_ITFENR_HSEGEN       HSP_ITFENR_HSEGEN_Msk              /*!< HSEGEN (HSEG interface enable bit ) */
/*!< HDEGEN configuration */
#define HSP_ITFENR_HDEGEN_Pos   (31U)
#define HSP_ITFENR_HDEGEN_Msk   (0x1UL << HSP_ITFENR_HDEGEN_Pos)   /*!< 0x80000000 */
#define HSP_ITFENR_HDEGEN       HSP_ITFENR_HDEGEN_Msk              /*!< HDEGEN (HDEG interface enable bit ) */

/********************  Bit definition for HSP_EVTSRC0R register  ********************/
/*!< EVT1SRC configuration */
#define HSP_EVTSRC0R_EVT1SRC_Pos (0U)
#define HSP_EVTSRC0R_EVT1SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT1SRC_Pos) /*!< 0x00000007 */
#define HSP_EVTSRC0R_EVT1SRC     HSP_EVTSRC0R_EVT1SRC_Msk            /*!< EVT1SRC[2:0] bits (Event source selection for priority encoder input 1) */
#define HSP_EVTSRC0R_EVT1SRC_0   (0x1UL << HSP_EVTSRC0R_EVT1SRC_Pos) /*!< 0x00000001 */
#define HSP_EVTSRC0R_EVT1SRC_1   (0x2UL << HSP_EVTSRC0R_EVT1SRC_Pos) /*!< 0x00000002 */
#define HSP_EVTSRC0R_EVT1SRC_2   (0x4UL << HSP_EVTSRC0R_EVT1SRC_Pos) /*!< 0x00000004 */
/*!< EVT2SRC configuration */
#define HSP_EVTSRC0R_EVT2SRC_Pos (4U)
#define HSP_EVTSRC0R_EVT2SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT2SRC_Pos) /*!< 0x00000070 */
#define HSP_EVTSRC0R_EVT2SRC     HSP_EVTSRC0R_EVT2SRC_Msk            /*!< EVT2SRC[2:0] bits (Event source selection for priority encoder input 2) */
#define HSP_EVTSRC0R_EVT2SRC_0   (0x1UL << HSP_EVTSRC0R_EVT2SRC_Pos) /*!< 0x00000010 */
#define HSP_EVTSRC0R_EVT2SRC_1   (0x2UL << HSP_EVTSRC0R_EVT2SRC_Pos) /*!< 0x00000020 */
#define HSP_EVTSRC0R_EVT2SRC_2   (0x4UL << HSP_EVTSRC0R_EVT2SRC_Pos) /*!< 0x00000040 */
/*!< EVT3SRC configuration */
#define HSP_EVTSRC0R_EVT3SRC_Pos (8U)
#define HSP_EVTSRC0R_EVT3SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT3SRC_Pos) /*!< 0x00000700 */
#define HSP_EVTSRC0R_EVT3SRC     HSP_EVTSRC0R_EVT3SRC_Msk            /*!< EVT3SRC[2:0] bits (Event source selection for priority encoder input 3) */
#define HSP_EVTSRC0R_EVT3SRC_0   (0x1UL << HSP_EVTSRC0R_EVT3SRC_Pos) /*!< 0x00000100 */
#define HSP_EVTSRC0R_EVT3SRC_1   (0x2UL << HSP_EVTSRC0R_EVT3SRC_Pos) /*!< 0x00000200 */
#define HSP_EVTSRC0R_EVT3SRC_2   (0x4UL << HSP_EVTSRC0R_EVT3SRC_Pos) /*!< 0x00000400 */
/*!< EVT4SRC configuration */
#define HSP_EVTSRC0R_EVT4SRC_Pos (12U)
#define HSP_EVTSRC0R_EVT4SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT4SRC_Pos) /*!< 0x00007000 */
#define HSP_EVTSRC0R_EVT4SRC     HSP_EVTSRC0R_EVT4SRC_Msk            /*!< EVT4SRC[2:0] bits (Event source selection for priority encoder input 4) */
#define HSP_EVTSRC0R_EVT4SRC_0   (0x1UL << HSP_EVTSRC0R_EVT4SRC_Pos) /*!< 0x00001000 */
#define HSP_EVTSRC0R_EVT4SRC_1   (0x2UL << HSP_EVTSRC0R_EVT4SRC_Pos) /*!< 0x00002000 */
#define HSP_EVTSRC0R_EVT4SRC_2   (0x4UL << HSP_EVTSRC0R_EVT4SRC_Pos) /*!< 0x00004000 */
/*!< EVT5SRC configuration */
#define HSP_EVTSRC0R_EVT5SRC_Pos (16U)
#define HSP_EVTSRC0R_EVT5SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT5SRC_Pos) /*!< 0x00070000 */
#define HSP_EVTSRC0R_EVT5SRC     HSP_EVTSRC0R_EVT5SRC_Msk            /*!< EVT5SRC[2:0] bits (Event source selection for priority encoder input 5) */
#define HSP_EVTSRC0R_EVT5SRC_0   (0x1UL << HSP_EVTSRC0R_EVT5SRC_Pos) /*!< 0x00010000 */
#define HSP_EVTSRC0R_EVT5SRC_1   (0x2UL << HSP_EVTSRC0R_EVT5SRC_Pos) /*!< 0x00020000 */
#define HSP_EVTSRC0R_EVT5SRC_2   (0x4UL << HSP_EVTSRC0R_EVT5SRC_Pos) /*!< 0x00040000 */
/*!< EVT6SRC configuration */
#define HSP_EVTSRC0R_EVT6SRC_Pos (20U)
#define HSP_EVTSRC0R_EVT6SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT6SRC_Pos) /*!< 0x00700000 */
#define HSP_EVTSRC0R_EVT6SRC     HSP_EVTSRC0R_EVT6SRC_Msk            /*!< EVT6SRC[2:0] bits (Event source selection for priority encoder input 6) */
#define HSP_EVTSRC0R_EVT6SRC_0   (0x1UL << HSP_EVTSRC0R_EVT6SRC_Pos) /*!< 0x00100000 */
#define HSP_EVTSRC0R_EVT6SRC_1   (0x2UL << HSP_EVTSRC0R_EVT6SRC_Pos) /*!< 0x00200000 */
#define HSP_EVTSRC0R_EVT6SRC_2   (0x4UL << HSP_EVTSRC0R_EVT6SRC_Pos) /*!< 0x00400000 */
/*!< EVT7SRC configuration */
#define HSP_EVTSRC0R_EVT7SRC_Pos (24U)
#define HSP_EVTSRC0R_EVT7SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT7SRC_Pos) /*!< 0x07000000 */
#define HSP_EVTSRC0R_EVT7SRC     HSP_EVTSRC0R_EVT7SRC_Msk            /*!< EVT7SRC[2:0] bits (Event source selection for priority encoder input 7) */
#define HSP_EVTSRC0R_EVT7SRC_0   (0x1UL << HSP_EVTSRC0R_EVT7SRC_Pos) /*!< 0x01000000 */
#define HSP_EVTSRC0R_EVT7SRC_1   (0x2UL << HSP_EVTSRC0R_EVT7SRC_Pos) /*!< 0x02000000 */
#define HSP_EVTSRC0R_EVT7SRC_2   (0x4UL << HSP_EVTSRC0R_EVT7SRC_Pos) /*!< 0x04000000 */
/*!< EVT8SRC configuration */
#define HSP_EVTSRC0R_EVT8SRC_Pos (28U)
#define HSP_EVTSRC0R_EVT8SRC_Msk (0x7UL << HSP_EVTSRC0R_EVT8SRC_Pos) /*!< 0x70000000 */
#define HSP_EVTSRC0R_EVT8SRC     HSP_EVTSRC0R_EVT8SRC_Msk            /*!< EVT8SRC[2:0] bits (Event source selection for priority encoder input 8) */
#define HSP_EVTSRC0R_EVT8SRC_0   (0x1UL << HSP_EVTSRC0R_EVT8SRC_Pos) /*!< 0x10000000 */
#define HSP_EVTSRC0R_EVT8SRC_1   (0x2UL << HSP_EVTSRC0R_EVT8SRC_Pos) /*!< 0x20000000 */
#define HSP_EVTSRC0R_EVT8SRC_2   (0x4UL << HSP_EVTSRC0R_EVT8SRC_Pos) /*!< 0x40000000 */

/********************  Bit definition for HSP_EVTSRC1R register  ********************/
/*!< EVT9SRC configuration */
#define HSP_EVTSRC1R_EVT9SRC_Pos  (0U)
#define HSP_EVTSRC1R_EVT9SRC_Msk  (0x7UL << HSP_EVTSRC1R_EVT9SRC_Pos)  /*!< 0x00000007 */
#define HSP_EVTSRC1R_EVT9SRC      HSP_EVTSRC1R_EVT9SRC_Msk             /*!< EVT9SRC[2:0] bits (Event source selection for priority encoder input 9) */
#define HSP_EVTSRC1R_EVT9SRC_0    (0x1UL << HSP_EVTSRC1R_EVT9SRC_Pos)  /*!< 0x00000001 */
#define HSP_EVTSRC1R_EVT9SRC_1    (0x2UL << HSP_EVTSRC1R_EVT9SRC_Pos)  /*!< 0x00000002 */
#define HSP_EVTSRC1R_EVT9SRC_2    (0x4UL << HSP_EVTSRC1R_EVT9SRC_Pos)  /*!< 0x00000004 */
/*!< EVT10SRC configuration */
#define HSP_EVTSRC1R_EVT10SRC_Pos (4U)
#define HSP_EVTSRC1R_EVT10SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT10SRC_Pos) /*!< 0x00000070 */
#define HSP_EVTSRC1R_EVT10SRC     HSP_EVTSRC1R_EVT10SRC_Msk            /*!< EVT10SRC[2:0] bits (Event source selection for priority encoder input 10) */
#define HSP_EVTSRC1R_EVT10SRC_0   (0x1UL << HSP_EVTSRC1R_EVT10SRC_Pos) /*!< 0x00000010 */
#define HSP_EVTSRC1R_EVT10SRC_1   (0x2UL << HSP_EVTSRC1R_EVT10SRC_Pos) /*!< 0x00000020 */
#define HSP_EVTSRC1R_EVT10SRC_2   (0x4UL << HSP_EVTSRC1R_EVT10SRC_Pos) /*!< 0x00000040 */
/*!< EVT11SRC configuration */
#define HSP_EVTSRC1R_EVT11SRC_Pos (8U)
#define HSP_EVTSRC1R_EVT11SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT11SRC_Pos) /*!< 0x00000700 */
#define HSP_EVTSRC1R_EVT11SRC     HSP_EVTSRC1R_EVT11SRC_Msk            /*!< EVT11SRC[2:0] bits (Event source selection for priority encoder input 11) */
#define HSP_EVTSRC1R_EVT11SRC_0   (0x1UL << HSP_EVTSRC1R_EVT11SRC_Pos) /*!< 0x00000100 */
#define HSP_EVTSRC1R_EVT11SRC_1   (0x2UL << HSP_EVTSRC1R_EVT11SRC_Pos) /*!< 0x00000200 */
#define HSP_EVTSRC1R_EVT11SRC_2   (0x4UL << HSP_EVTSRC1R_EVT11SRC_Pos) /*!< 0x00000400 */
/*!< EVT12SRC configuration */
#define HSP_EVTSRC1R_EVT12SRC_Pos (12U)
#define HSP_EVTSRC1R_EVT12SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT12SRC_Pos) /*!< 0x00007000 */
#define HSP_EVTSRC1R_EVT12SRC     HSP_EVTSRC1R_EVT12SRC_Msk            /*!< EVT12SRC[2:0] bits (Event source selection for priority encoder input 12) */
#define HSP_EVTSRC1R_EVT12SRC_0   (0x1UL << HSP_EVTSRC1R_EVT12SRC_Pos) /*!< 0x00001000 */
#define HSP_EVTSRC1R_EVT12SRC_1   (0x2UL << HSP_EVTSRC1R_EVT12SRC_Pos) /*!< 0x00002000 */
#define HSP_EVTSRC1R_EVT12SRC_2   (0x4UL << HSP_EVTSRC1R_EVT12SRC_Pos) /*!< 0x00004000 */
/*!< EVT13SRC configuration */
#define HSP_EVTSRC1R_EVT13SRC_Pos (16U)
#define HSP_EVTSRC1R_EVT13SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT13SRC_Pos) /*!< 0x00070000 */
#define HSP_EVTSRC1R_EVT13SRC     HSP_EVTSRC1R_EVT13SRC_Msk            /*!< EVT13SRC[2:0] bits (Event source selection for priority encoder input 13) */
#define HSP_EVTSRC1R_EVT13SRC_0   (0x1UL << HSP_EVTSRC1R_EVT13SRC_Pos) /*!< 0x00010000 */
#define HSP_EVTSRC1R_EVT13SRC_1   (0x2UL << HSP_EVTSRC1R_EVT13SRC_Pos) /*!< 0x00020000 */
#define HSP_EVTSRC1R_EVT13SRC_2   (0x4UL << HSP_EVTSRC1R_EVT13SRC_Pos) /*!< 0x00040000 */
/*!< EVT14SRC configuration */
#define HSP_EVTSRC1R_EVT14SRC_Pos (20U)
#define HSP_EVTSRC1R_EVT14SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT14SRC_Pos) /*!< 0x00700000 */
#define HSP_EVTSRC1R_EVT14SRC     HSP_EVTSRC1R_EVT14SRC_Msk            /*!< EVT14SRC[2:0] bits (Event source selection for priority encoder input 14) */
#define HSP_EVTSRC1R_EVT14SRC_0   (0x1UL << HSP_EVTSRC1R_EVT14SRC_Pos) /*!< 0x00100000 */
#define HSP_EVTSRC1R_EVT14SRC_1   (0x2UL << HSP_EVTSRC1R_EVT14SRC_Pos) /*!< 0x00200000 */
#define HSP_EVTSRC1R_EVT14SRC_2   (0x4UL << HSP_EVTSRC1R_EVT14SRC_Pos) /*!< 0x00400000 */
/*!< EVT15SRC configuration */
#define HSP_EVTSRC1R_EVT15SRC_Pos (24U)
#define HSP_EVTSRC1R_EVT15SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT15SRC_Pos) /*!< 0x07000000 */
#define HSP_EVTSRC1R_EVT15SRC     HSP_EVTSRC1R_EVT15SRC_Msk            /*!< EVT15SRC[2:0] bits (Event source selection for priority encoder input 15) */
#define HSP_EVTSRC1R_EVT15SRC_0   (0x1UL << HSP_EVTSRC1R_EVT15SRC_Pos) /*!< 0x01000000 */
#define HSP_EVTSRC1R_EVT15SRC_1   (0x2UL << HSP_EVTSRC1R_EVT15SRC_Pos) /*!< 0x02000000 */
#define HSP_EVTSRC1R_EVT15SRC_2   (0x4UL << HSP_EVTSRC1R_EVT15SRC_Pos) /*!< 0x04000000 */
/*!< EVT16SRC configuration */
#define HSP_EVTSRC1R_EVT16SRC_Pos (28U)
#define HSP_EVTSRC1R_EVT16SRC_Msk (0x7UL << HSP_EVTSRC1R_EVT16SRC_Pos) /*!< 0x70000000 */
#define HSP_EVTSRC1R_EVT16SRC     HSP_EVTSRC1R_EVT16SRC_Msk            /*!< EVT16SRC[2:0] bits (Event source selection for priority encoder input 16) */
#define HSP_EVTSRC1R_EVT16SRC_0   (0x1UL << HSP_EVTSRC1R_EVT16SRC_Pos) /*!< 0x10000000 */
#define HSP_EVTSRC1R_EVT16SRC_1   (0x2UL << HSP_EVTSRC1R_EVT16SRC_Pos) /*!< 0x20000000 */
#define HSP_EVTSRC1R_EVT16SRC_2   (0x4UL << HSP_EVTSRC1R_EVT16SRC_Pos) /*!< 0x40000000 */

/********************  Bit definition for HSP_EVTSRC2R register  ********************/
/*!< EVT17SRC configuration */
#define HSP_EVTSRC2R_EVT17SRC_Pos (0U)
#define HSP_EVTSRC2R_EVT17SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT17SRC_Pos) /*!< 0x00000007 */
#define HSP_EVTSRC2R_EVT17SRC     HSP_EVTSRC2R_EVT17SRC_Msk            /*!< EVT17SRC[2:0] bits (Event source selection for priority encoder input 17) */
#define HSP_EVTSRC2R_EVT17SRC_0   (0x1UL << HSP_EVTSRC2R_EVT17SRC_Pos) /*!< 0x00000001 */
#define HSP_EVTSRC2R_EVT17SRC_1   (0x2UL << HSP_EVTSRC2R_EVT17SRC_Pos) /*!< 0x00000002 */
#define HSP_EVTSRC2R_EVT17SRC_2   (0x4UL << HSP_EVTSRC2R_EVT17SRC_Pos) /*!< 0x00000004 */
/*!< EVT18SRC configuration */
#define HSP_EVTSRC2R_EVT18SRC_Pos (4U)
#define HSP_EVTSRC2R_EVT18SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT18SRC_Pos) /*!< 0x00000070 */
#define HSP_EVTSRC2R_EVT18SRC     HSP_EVTSRC2R_EVT18SRC_Msk            /*!< EVT18SRC[2:0] bits (Event source selection for priority encoder input 18) */
#define HSP_EVTSRC2R_EVT18SRC_0   (0x1UL << HSP_EVTSRC2R_EVT18SRC_Pos) /*!< 0x00000010 */
#define HSP_EVTSRC2R_EVT18SRC_1   (0x2UL << HSP_EVTSRC2R_EVT18SRC_Pos) /*!< 0x00000020 */
#define HSP_EVTSRC2R_EVT18SRC_2   (0x4UL << HSP_EVTSRC2R_EVT18SRC_Pos) /*!< 0x00000040 */
/*!< EVT19SRC configuration */
#define HSP_EVTSRC2R_EVT19SRC_Pos (8U)
#define HSP_EVTSRC2R_EVT19SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT19SRC_Pos) /*!< 0x00000700 */
#define HSP_EVTSRC2R_EVT19SRC     HSP_EVTSRC2R_EVT19SRC_Msk            /*!< EVT19SRC[2:0] bits (Event source selection for priority encoder input 19) */
#define HSP_EVTSRC2R_EVT19SRC_0   (0x1UL << HSP_EVTSRC2R_EVT19SRC_Pos) /*!< 0x00000100 */
#define HSP_EVTSRC2R_EVT19SRC_1   (0x2UL << HSP_EVTSRC2R_EVT19SRC_Pos) /*!< 0x00000200 */
#define HSP_EVTSRC2R_EVT19SRC_2   (0x4UL << HSP_EVTSRC2R_EVT19SRC_Pos) /*!< 0x00000400 */
/*!< EVT20SRC configuration */
#define HSP_EVTSRC2R_EVT20SRC_Pos (12U)
#define HSP_EVTSRC2R_EVT20SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT20SRC_Pos) /*!< 0x00007000 */
#define HSP_EVTSRC2R_EVT20SRC     HSP_EVTSRC2R_EVT20SRC_Msk            /*!< EVT20SRC[2:0] bits (Event source selection for priority encoder input 20) */
#define HSP_EVTSRC2R_EVT20SRC_0   (0x1UL << HSP_EVTSRC2R_EVT20SRC_Pos) /*!< 0x00001000 */
#define HSP_EVTSRC2R_EVT20SRC_1   (0x2UL << HSP_EVTSRC2R_EVT20SRC_Pos) /*!< 0x00002000 */
#define HSP_EVTSRC2R_EVT20SRC_2   (0x4UL << HSP_EVTSRC2R_EVT20SRC_Pos) /*!< 0x00004000 */
/*!< EVT21SRC configuration */
#define HSP_EVTSRC2R_EVT21SRC_Pos (16U)
#define HSP_EVTSRC2R_EVT21SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT21SRC_Pos) /*!< 0x00070000 */
#define HSP_EVTSRC2R_EVT21SRC     HSP_EVTSRC2R_EVT21SRC_Msk            /*!< EVT21SRC[2:0] bits (Event source selection for priority encoder input 21) */
#define HSP_EVTSRC2R_EVT21SRC_0   (0x1UL << HSP_EVTSRC2R_EVT21SRC_Pos) /*!< 0x00010000 */
#define HSP_EVTSRC2R_EVT21SRC_1   (0x2UL << HSP_EVTSRC2R_EVT21SRC_Pos) /*!< 0x00020000 */
#define HSP_EVTSRC2R_EVT21SRC_2   (0x4UL << HSP_EVTSRC2R_EVT21SRC_Pos) /*!< 0x00040000 */
/*!< EVT22SRC configuration */
#define HSP_EVTSRC2R_EVT22SRC_Pos (20U)
#define HSP_EVTSRC2R_EVT22SRC_Msk (0x7UL << HSP_EVTSRC2R_EVT22SRC_Pos) /*!< 0x00700000 */
#define HSP_EVTSRC2R_EVT22SRC     HSP_EVTSRC2R_EVT22SRC_Msk            /*!< EVT22SRC[2:0] bits (Event source selection for priority encoder input 22) */
#define HSP_EVTSRC2R_EVT22SRC_0   (0x1UL << HSP_EVTSRC2R_EVT22SRC_Pos) /*!< 0x00100000 */
#define HSP_EVTSRC2R_EVT22SRC_1   (0x2UL << HSP_EVTSRC2R_EVT22SRC_Pos) /*!< 0x00200000 */
#define HSP_EVTSRC2R_EVT22SRC_2   (0x4UL << HSP_EVTSRC2R_EVT22SRC_Pos) /*!< 0x00400000 */

/********************  Bit definition for HSP_BUFFCFGR register  ********************/
/*!< BUFF0DIR configuration */
#define HSP_BUFFCFGR_BUFF0DIR_Pos (0U)
#define HSP_BUFFCFGR_BUFF0DIR_Msk (0x1UL << HSP_BUFFCFGR_BUFF0DIR_Pos) /*!< 0x00000001 */
#define HSP_BUFFCFGR_BUFF0DIR     HSP_BUFFCFGR_BUFF0DIR_Msk            /*!< BUFF0DIR (Direction selection of BUFF0 <sup>(1)</sup>) */
/*!< BUFF1DIR configuration */
#define HSP_BUFFCFGR_BUFF1DIR_Pos (1U)
#define HSP_BUFFCFGR_BUFF1DIR_Msk (0x1UL << HSP_BUFFCFGR_BUFF1DIR_Pos) /*!< 0x00000002 */
#define HSP_BUFFCFGR_BUFF1DIR     HSP_BUFFCFGR_BUFF1DIR_Msk            /*!< BUFF1DIR (Direction selection of BUFF1 <sup>(1)</sup>) */
/*!< BUFF2DIR configuration */
#define HSP_BUFFCFGR_BUFF2DIR_Pos (2U)
#define HSP_BUFFCFGR_BUFF2DIR_Msk (0x1UL << HSP_BUFFCFGR_BUFF2DIR_Pos) /*!< 0x00000004 */
#define HSP_BUFFCFGR_BUFF2DIR     HSP_BUFFCFGR_BUFF2DIR_Msk            /*!< BUFF2DIR (Direction selection of BUFF2 <sup>(1)</sup>) */
/*!< BUFF3DIR configuration */
#define HSP_BUFFCFGR_BUFF3DIR_Pos (3U)
#define HSP_BUFFCFGR_BUFF3DIR_Msk (0x1UL << HSP_BUFFCFGR_BUFF3DIR_Pos) /*!< 0x00000008 */
#define HSP_BUFFCFGR_BUFF3DIR     HSP_BUFFCFGR_BUFF3DIR_Msk            /*!< BUFF3DIR (Direction selection of BUFF3 <sup>(1)</sup>) */
/*!< I2FEN configuration */
#define HSP_BUFFCFGR_I2FEN_Pos    (8U)
#define HSP_BUFFCFGR_I2FEN_Msk    (0x1UL << HSP_BUFFCFGR_I2FEN_Pos)    /*!< 0x00000100 */
#define HSP_BUFFCFGR_I2FEN        HSP_BUFFCFGR_I2FEN_Msk               /*!< I2FEN (integer to float32 conversion <sup>(1)</sup>) */
/*!< COMB0 configuration */
#define HSP_BUFFCFGR_COMB0_Pos    (16U)
#define HSP_BUFFCFGR_COMB0_Msk    (0x1UL << HSP_BUFFCFGR_COMB0_Pos)    /*!< 0x00010000 */
#define HSP_BUFFCFGR_COMB0        HSP_BUFFCFGR_COMB0_Msk               /*!< COMB0 (BUFCMB control for buff_evt[0] <sup>(1)</sup>) */
/*!< COMB1 configuration */
#define HSP_BUFFCFGR_COMB1_Pos    (17U)
#define HSP_BUFFCFGR_COMB1_Msk    (0x1UL << HSP_BUFFCFGR_COMB1_Pos)    /*!< 0x00020000 */
#define HSP_BUFFCFGR_COMB1        HSP_BUFFCFGR_COMB1_Msk               /*!< COMB1 (BUFCMB control for buff_evt[1] <sup>(1)</sup>) */
/*!< COMB2 configuration */
#define HSP_BUFFCFGR_COMB2_Pos    (18U)
#define HSP_BUFFCFGR_COMB2_Msk    (0x1UL << HSP_BUFFCFGR_COMB2_Pos)    /*!< 0x00040000 */
#define HSP_BUFFCFGR_COMB2        HSP_BUFFCFGR_COMB2_Msk               /*!< COMB2 (BUFCMB control for buff_evt[2] ) */

/********************  Bit definition for HSP_BUFF0DR register  ********************/
/*!< BUFFDAT configuration */
#define HSP_BUFF0DR_BUFFDAT_Pos (0U)
#define HSP_BUFF0DR_BUFFDAT_Msk (0xFFFFFFFFUL << HSP_BUFF0DR_BUFFDAT_Pos) /*!< 0xFFFFFFFF */
#define HSP_BUFF0DR_BUFFDAT     HSP_BUFF0DR_BUFFDAT_Msk                   /*!< BUFFDAT[31:0] bits (Data buffer) */
#define HSP_BUFF0DR_BUFFDAT_0   (0x00001UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000001 */
#define HSP_BUFF0DR_BUFFDAT_1   (0x00002UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000002 */
#define HSP_BUFF0DR_BUFFDAT_2   (0x00004UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000004 */
#define HSP_BUFF0DR_BUFFDAT_3   (0x00008UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000008 */
#define HSP_BUFF0DR_BUFFDAT_4   (0x00010UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000010 */
#define HSP_BUFF0DR_BUFFDAT_5   (0x00020UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000020 */
#define HSP_BUFF0DR_BUFFDAT_6   (0x00040UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000040 */
#define HSP_BUFF0DR_BUFFDAT_7   (0x00080UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000080 */
#define HSP_BUFF0DR_BUFFDAT_8   (0x00100UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000100 */
#define HSP_BUFF0DR_BUFFDAT_9   (0x00200UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000200 */
#define HSP_BUFF0DR_BUFFDAT_10  (0x00400UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000400 */
#define HSP_BUFF0DR_BUFFDAT_11  (0x00800UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00000800 */
#define HSP_BUFF0DR_BUFFDAT_12  (0x01000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00001000 */
#define HSP_BUFF0DR_BUFFDAT_13  (0x02000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00002000 */
#define HSP_BUFF0DR_BUFFDAT_14  (0x04000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00004000 */
#define HSP_BUFF0DR_BUFFDAT_15  (0x08000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00008000 */
#define HSP_BUFF0DR_BUFFDAT_16  (0x10000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00010000 */
#define HSP_BUFF0DR_BUFFDAT_17  (0x20000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00020000 */
#define HSP_BUFF0DR_BUFFDAT_18  (0x40000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00040000 */
#define HSP_BUFF0DR_BUFFDAT_19  (0x80000UL << HSP_BUFF0DR_BUFFDAT_Pos)    /*!< 0x00080000 */
#define HSP_BUFF0DR_BUFFDAT_20  (0x100000UL << HSP_BUFF0DR_BUFFDAT_Pos)   /*!< 0x00100000 */
#define HSP_BUFF0DR_BUFFDAT_21  (0x200000UL << HSP_BUFF0DR_BUFFDAT_Pos)   /*!< 0x00200000 */
#define HSP_BUFF0DR_BUFFDAT_22  (0x400000UL << HSP_BUFF0DR_BUFFDAT_Pos)   /*!< 0x00400000 */
#define HSP_BUFF0DR_BUFFDAT_23  (0x800000UL << HSP_BUFF0DR_BUFFDAT_Pos)   /*!< 0x00800000 */
#define HSP_BUFF0DR_BUFFDAT_24  (0x1000000UL << HSP_BUFF0DR_BUFFDAT_Pos)  /*!< 0x01000000 */
#define HSP_BUFF0DR_BUFFDAT_25  (0x2000000UL << HSP_BUFF0DR_BUFFDAT_Pos)  /*!< 0x02000000 */
#define HSP_BUFF0DR_BUFFDAT_26  (0x4000000UL << HSP_BUFF0DR_BUFFDAT_Pos)  /*!< 0x04000000 */
#define HSP_BUFF0DR_BUFFDAT_27  (0x8000000UL << HSP_BUFF0DR_BUFFDAT_Pos)  /*!< 0x08000000 */
#define HSP_BUFF0DR_BUFFDAT_28  (0x10000000UL << HSP_BUFF0DR_BUFFDAT_Pos) /*!< 0x10000000 */
#define HSP_BUFF0DR_BUFFDAT_29  (0x20000000UL << HSP_BUFF0DR_BUFFDAT_Pos) /*!< 0x20000000 */
#define HSP_BUFF0DR_BUFFDAT_30  (0x40000000UL << HSP_BUFF0DR_BUFFDAT_Pos) /*!< 0x40000000 */
#define HSP_BUFF0DR_BUFFDAT_31  (0x80000000UL << HSP_BUFF0DR_BUFFDAT_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_BUFF1DR register  ********************/
/*!< BUFFDAT configuration */
#define HSP_BUFF1DR_BUFFDAT_Pos (0U)
#define HSP_BUFF1DR_BUFFDAT_Msk (0xFFFFFFFFUL << HSP_BUFF1DR_BUFFDAT_Pos) /*!< 0xFFFFFFFF */
#define HSP_BUFF1DR_BUFFDAT     HSP_BUFF1DR_BUFFDAT_Msk                   /*!< BUFFDAT[31:0] bits (Data buffer) */
#define HSP_BUFF1DR_BUFFDAT_0   (0x00001UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000001 */
#define HSP_BUFF1DR_BUFFDAT_1   (0x00002UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000002 */
#define HSP_BUFF1DR_BUFFDAT_2   (0x00004UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000004 */
#define HSP_BUFF1DR_BUFFDAT_3   (0x00008UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000008 */
#define HSP_BUFF1DR_BUFFDAT_4   (0x00010UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000010 */
#define HSP_BUFF1DR_BUFFDAT_5   (0x00020UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000020 */
#define HSP_BUFF1DR_BUFFDAT_6   (0x00040UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000040 */
#define HSP_BUFF1DR_BUFFDAT_7   (0x00080UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000080 */
#define HSP_BUFF1DR_BUFFDAT_8   (0x00100UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000100 */
#define HSP_BUFF1DR_BUFFDAT_9   (0x00200UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000200 */
#define HSP_BUFF1DR_BUFFDAT_10  (0x00400UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000400 */
#define HSP_BUFF1DR_BUFFDAT_11  (0x00800UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00000800 */
#define HSP_BUFF1DR_BUFFDAT_12  (0x01000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00001000 */
#define HSP_BUFF1DR_BUFFDAT_13  (0x02000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00002000 */
#define HSP_BUFF1DR_BUFFDAT_14  (0x04000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00004000 */
#define HSP_BUFF1DR_BUFFDAT_15  (0x08000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00008000 */
#define HSP_BUFF1DR_BUFFDAT_16  (0x10000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00010000 */
#define HSP_BUFF1DR_BUFFDAT_17  (0x20000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00020000 */
#define HSP_BUFF1DR_BUFFDAT_18  (0x40000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00040000 */
#define HSP_BUFF1DR_BUFFDAT_19  (0x80000UL << HSP_BUFF1DR_BUFFDAT_Pos)    /*!< 0x00080000 */
#define HSP_BUFF1DR_BUFFDAT_20  (0x100000UL << HSP_BUFF1DR_BUFFDAT_Pos)   /*!< 0x00100000 */
#define HSP_BUFF1DR_BUFFDAT_21  (0x200000UL << HSP_BUFF1DR_BUFFDAT_Pos)   /*!< 0x00200000 */
#define HSP_BUFF1DR_BUFFDAT_22  (0x400000UL << HSP_BUFF1DR_BUFFDAT_Pos)   /*!< 0x00400000 */
#define HSP_BUFF1DR_BUFFDAT_23  (0x800000UL << HSP_BUFF1DR_BUFFDAT_Pos)   /*!< 0x00800000 */
#define HSP_BUFF1DR_BUFFDAT_24  (0x1000000UL << HSP_BUFF1DR_BUFFDAT_Pos)  /*!< 0x01000000 */
#define HSP_BUFF1DR_BUFFDAT_25  (0x2000000UL << HSP_BUFF1DR_BUFFDAT_Pos)  /*!< 0x02000000 */
#define HSP_BUFF1DR_BUFFDAT_26  (0x4000000UL << HSP_BUFF1DR_BUFFDAT_Pos)  /*!< 0x04000000 */
#define HSP_BUFF1DR_BUFFDAT_27  (0x8000000UL << HSP_BUFF1DR_BUFFDAT_Pos)  /*!< 0x08000000 */
#define HSP_BUFF1DR_BUFFDAT_28  (0x10000000UL << HSP_BUFF1DR_BUFFDAT_Pos) /*!< 0x10000000 */
#define HSP_BUFF1DR_BUFFDAT_29  (0x20000000UL << HSP_BUFF1DR_BUFFDAT_Pos) /*!< 0x20000000 */
#define HSP_BUFF1DR_BUFFDAT_30  (0x40000000UL << HSP_BUFF1DR_BUFFDAT_Pos) /*!< 0x40000000 */
#define HSP_BUFF1DR_BUFFDAT_31  (0x80000000UL << HSP_BUFF1DR_BUFFDAT_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_BUFF2DR register  ********************/
/*!< BUFFDAT configuration */
#define HSP_BUFF2DR_BUFFDAT_Pos (0U)
#define HSP_BUFF2DR_BUFFDAT_Msk (0xFFFFFFFFUL << HSP_BUFF2DR_BUFFDAT_Pos) /*!< 0xFFFFFFFF */
#define HSP_BUFF2DR_BUFFDAT     HSP_BUFF2DR_BUFFDAT_Msk                   /*!< BUFFDAT[31:0] bits (Data buffer) */
#define HSP_BUFF2DR_BUFFDAT_0   (0x00001UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000001 */
#define HSP_BUFF2DR_BUFFDAT_1   (0x00002UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000002 */
#define HSP_BUFF2DR_BUFFDAT_2   (0x00004UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000004 */
#define HSP_BUFF2DR_BUFFDAT_3   (0x00008UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000008 */
#define HSP_BUFF2DR_BUFFDAT_4   (0x00010UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000010 */
#define HSP_BUFF2DR_BUFFDAT_5   (0x00020UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000020 */
#define HSP_BUFF2DR_BUFFDAT_6   (0x00040UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000040 */
#define HSP_BUFF2DR_BUFFDAT_7   (0x00080UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000080 */
#define HSP_BUFF2DR_BUFFDAT_8   (0x00100UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000100 */
#define HSP_BUFF2DR_BUFFDAT_9   (0x00200UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000200 */
#define HSP_BUFF2DR_BUFFDAT_10  (0x00400UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000400 */
#define HSP_BUFF2DR_BUFFDAT_11  (0x00800UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00000800 */
#define HSP_BUFF2DR_BUFFDAT_12  (0x01000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00001000 */
#define HSP_BUFF2DR_BUFFDAT_13  (0x02000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00002000 */
#define HSP_BUFF2DR_BUFFDAT_14  (0x04000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00004000 */
#define HSP_BUFF2DR_BUFFDAT_15  (0x08000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00008000 */
#define HSP_BUFF2DR_BUFFDAT_16  (0x10000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00010000 */
#define HSP_BUFF2DR_BUFFDAT_17  (0x20000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00020000 */
#define HSP_BUFF2DR_BUFFDAT_18  (0x40000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00040000 */
#define HSP_BUFF2DR_BUFFDAT_19  (0x80000UL << HSP_BUFF2DR_BUFFDAT_Pos)    /*!< 0x00080000 */
#define HSP_BUFF2DR_BUFFDAT_20  (0x100000UL << HSP_BUFF2DR_BUFFDAT_Pos)   /*!< 0x00100000 */
#define HSP_BUFF2DR_BUFFDAT_21  (0x200000UL << HSP_BUFF2DR_BUFFDAT_Pos)   /*!< 0x00200000 */
#define HSP_BUFF2DR_BUFFDAT_22  (0x400000UL << HSP_BUFF2DR_BUFFDAT_Pos)   /*!< 0x00400000 */
#define HSP_BUFF2DR_BUFFDAT_23  (0x800000UL << HSP_BUFF2DR_BUFFDAT_Pos)   /*!< 0x00800000 */
#define HSP_BUFF2DR_BUFFDAT_24  (0x1000000UL << HSP_BUFF2DR_BUFFDAT_Pos)  /*!< 0x01000000 */
#define HSP_BUFF2DR_BUFFDAT_25  (0x2000000UL << HSP_BUFF2DR_BUFFDAT_Pos)  /*!< 0x02000000 */
#define HSP_BUFF2DR_BUFFDAT_26  (0x4000000UL << HSP_BUFF2DR_BUFFDAT_Pos)  /*!< 0x04000000 */
#define HSP_BUFF2DR_BUFFDAT_27  (0x8000000UL << HSP_BUFF2DR_BUFFDAT_Pos)  /*!< 0x08000000 */
#define HSP_BUFF2DR_BUFFDAT_28  (0x10000000UL << HSP_BUFF2DR_BUFFDAT_Pos) /*!< 0x10000000 */
#define HSP_BUFF2DR_BUFFDAT_29  (0x20000000UL << HSP_BUFF2DR_BUFFDAT_Pos) /*!< 0x20000000 */
#define HSP_BUFF2DR_BUFFDAT_30  (0x40000000UL << HSP_BUFF2DR_BUFFDAT_Pos) /*!< 0x40000000 */
#define HSP_BUFF2DR_BUFFDAT_31  (0x80000000UL << HSP_BUFF2DR_BUFFDAT_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_BUFF3DR register  ********************/
/*!< BUFFDAT configuration */
#define HSP_BUFF3DR_BUFFDAT_Pos (0U)
#define HSP_BUFF3DR_BUFFDAT_Msk (0xFFFFFFFFUL << HSP_BUFF3DR_BUFFDAT_Pos) /*!< 0xFFFFFFFF */
#define HSP_BUFF3DR_BUFFDAT     HSP_BUFF3DR_BUFFDAT_Msk                   /*!< BUFFDAT[31:0] bits (Data buffer) */
#define HSP_BUFF3DR_BUFFDAT_0   (0x00001UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000001 */
#define HSP_BUFF3DR_BUFFDAT_1   (0x00002UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000002 */
#define HSP_BUFF3DR_BUFFDAT_2   (0x00004UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000004 */
#define HSP_BUFF3DR_BUFFDAT_3   (0x00008UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000008 */
#define HSP_BUFF3DR_BUFFDAT_4   (0x00010UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000010 */
#define HSP_BUFF3DR_BUFFDAT_5   (0x00020UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000020 */
#define HSP_BUFF3DR_BUFFDAT_6   (0x00040UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000040 */
#define HSP_BUFF3DR_BUFFDAT_7   (0x00080UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000080 */
#define HSP_BUFF3DR_BUFFDAT_8   (0x00100UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000100 */
#define HSP_BUFF3DR_BUFFDAT_9   (0x00200UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000200 */
#define HSP_BUFF3DR_BUFFDAT_10  (0x00400UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000400 */
#define HSP_BUFF3DR_BUFFDAT_11  (0x00800UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00000800 */
#define HSP_BUFF3DR_BUFFDAT_12  (0x01000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00001000 */
#define HSP_BUFF3DR_BUFFDAT_13  (0x02000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00002000 */
#define HSP_BUFF3DR_BUFFDAT_14  (0x04000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00004000 */
#define HSP_BUFF3DR_BUFFDAT_15  (0x08000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00008000 */
#define HSP_BUFF3DR_BUFFDAT_16  (0x10000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00010000 */
#define HSP_BUFF3DR_BUFFDAT_17  (0x20000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00020000 */
#define HSP_BUFF3DR_BUFFDAT_18  (0x40000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00040000 */
#define HSP_BUFF3DR_BUFFDAT_19  (0x80000UL << HSP_BUFF3DR_BUFFDAT_Pos)    /*!< 0x00080000 */
#define HSP_BUFF3DR_BUFFDAT_20  (0x100000UL << HSP_BUFF3DR_BUFFDAT_Pos)   /*!< 0x00100000 */
#define HSP_BUFF3DR_BUFFDAT_21  (0x200000UL << HSP_BUFF3DR_BUFFDAT_Pos)   /*!< 0x00200000 */
#define HSP_BUFF3DR_BUFFDAT_22  (0x400000UL << HSP_BUFF3DR_BUFFDAT_Pos)   /*!< 0x00400000 */
#define HSP_BUFF3DR_BUFFDAT_23  (0x800000UL << HSP_BUFF3DR_BUFFDAT_Pos)   /*!< 0x00800000 */
#define HSP_BUFF3DR_BUFFDAT_24  (0x1000000UL << HSP_BUFF3DR_BUFFDAT_Pos)  /*!< 0x01000000 */
#define HSP_BUFF3DR_BUFFDAT_25  (0x2000000UL << HSP_BUFF3DR_BUFFDAT_Pos)  /*!< 0x02000000 */
#define HSP_BUFF3DR_BUFFDAT_26  (0x4000000UL << HSP_BUFF3DR_BUFFDAT_Pos)  /*!< 0x04000000 */
#define HSP_BUFF3DR_BUFFDAT_27  (0x8000000UL << HSP_BUFF3DR_BUFFDAT_Pos)  /*!< 0x08000000 */
#define HSP_BUFF3DR_BUFFDAT_28  (0x10000000UL << HSP_BUFF3DR_BUFFDAT_Pos) /*!< 0x10000000 */
#define HSP_BUFF3DR_BUFFDAT_29  (0x20000000UL << HSP_BUFF3DR_BUFFDAT_Pos) /*!< 0x20000000 */
#define HSP_BUFF3DR_BUFFDAT_30  (0x40000000UL << HSP_BUFF3DR_BUFFDAT_Pos) /*!< 0x40000000 */
#define HSP_BUFF3DR_BUFFDAT_31  (0x80000000UL << HSP_BUFF3DR_BUFFDAT_Pos) /*!< 0x80000000 */

/********************  Bit definition for HSP_TRGINCFGR register  ********************/
/*!< TRG0POL configuration */
#define HSP_TRGINCFGR_TRG0POL_Pos (0U)
#define HSP_TRGINCFGR_TRG0POL_Msk (0x1UL << HSP_TRGINCFGR_TRG0POL_Pos) /*!< 0x00000001 */
#define HSP_TRGINCFGR_TRG0POL     HSP_TRGINCFGR_TRG0POL_Msk            /*!< TRG0POL (Polarity selection for TRGIN0) */
/*!< TRG1POL configuration */
#define HSP_TRGINCFGR_TRG1POL_Pos (1U)
#define HSP_TRGINCFGR_TRG1POL_Msk (0x1UL << HSP_TRGINCFGR_TRG1POL_Pos) /*!< 0x00000002 */
#define HSP_TRGINCFGR_TRG1POL     HSP_TRGINCFGR_TRG1POL_Msk            /*!< TRG1POL (Polarity selection for TRGIN1) */
/*!< TRG2POL configuration */
#define HSP_TRGINCFGR_TRG2POL_Pos (2U)
#define HSP_TRGINCFGR_TRG2POL_Msk (0x1UL << HSP_TRGINCFGR_TRG2POL_Pos) /*!< 0x00000004 */
#define HSP_TRGINCFGR_TRG2POL     HSP_TRGINCFGR_TRG2POL_Msk            /*!< TRG2POL (Polarity selection for TRGIN2) */
/*!< TRG3POL configuration */
#define HSP_TRGINCFGR_TRG3POL_Pos (3U)
#define HSP_TRGINCFGR_TRG3POL_Msk (0x1UL << HSP_TRGINCFGR_TRG3POL_Pos) /*!< 0x00000008 */
#define HSP_TRGINCFGR_TRG3POL     HSP_TRGINCFGR_TRG3POL_Msk            /*!< TRG3POL (Polarity selection for TRGIN3) */
/*!< TRG4POL configuration */
#define HSP_TRGINCFGR_TRG4POL_Pos (4U)
#define HSP_TRGINCFGR_TRG4POL_Msk (0x1UL << HSP_TRGINCFGR_TRG4POL_Pos) /*!< 0x00000010 */
#define HSP_TRGINCFGR_TRG4POL     HSP_TRGINCFGR_TRG4POL_Msk            /*!< TRG4POL (Polarity selection for TRGIN4) */
/*!< TRG5POL configuration */
#define HSP_TRGINCFGR_TRG5POL_Pos (5U)
#define HSP_TRGINCFGR_TRG5POL_Msk (0x1UL << HSP_TRGINCFGR_TRG5POL_Pos) /*!< 0x00000020 */
#define HSP_TRGINCFGR_TRG5POL     HSP_TRGINCFGR_TRG5POL_Msk            /*!< TRG5POL (Polarity selection for TRGIN5) */
/*!< TRG6POL configuration */
#define HSP_TRGINCFGR_TRG6POL_Pos (6U)
#define HSP_TRGINCFGR_TRG6POL_Msk (0x1UL << HSP_TRGINCFGR_TRG6POL_Pos) /*!< 0x00000040 */
#define HSP_TRGINCFGR_TRG6POL     HSP_TRGINCFGR_TRG6POL_Msk            /*!< TRG6POL (Polarity selection for TRGIN6) */
/*!< TRG7POL configuration */
#define HSP_TRGINCFGR_TRG7POL_Pos (7U)
#define HSP_TRGINCFGR_TRG7POL_Msk (0x1UL << HSP_TRGINCFGR_TRG7POL_Pos) /*!< 0x00000080 */
#define HSP_TRGINCFGR_TRG7POL     HSP_TRGINCFGR_TRG7POL_Msk            /*!< TRG7POL (Polarity selection for TRGIN7) */
/*!< TRG8POL configuration */
#define HSP_TRGINCFGR_TRG8POL_Pos (8U)
#define HSP_TRGINCFGR_TRG8POL_Msk (0x1UL << HSP_TRGINCFGR_TRG8POL_Pos) /*!< 0x00000100 */
#define HSP_TRGINCFGR_TRG8POL     HSP_TRGINCFGR_TRG8POL_Msk            /*!< TRG8POL (Polarity selection for TRGIN8) */
/*!< TRG9POL configuration */
#define HSP_TRGINCFGR_TRG9POL_Pos (9U)
#define HSP_TRGINCFGR_TRG9POL_Msk (0x1UL << HSP_TRGINCFGR_TRG9POL_Pos) /*!< 0x00000200 */
#define HSP_TRGINCFGR_TRG9POL     HSP_TRGINCFGR_TRG9POL_Msk            /*!< TRG9POL (Polarity selection for TRGIN9) */

/********************  Bit definition for HSP_TRGOCFGR register  ********************/
/*!< TRGO0SRC configuration */
#define HSP_TRGOCFGR_TRGO0SRC_Pos (0U)
#define HSP_TRGOCFGR_TRGO0SRC_Msk (0x3UL << HSP_TRGOCFGR_TRGO0SRC_Pos) /*!< 0x00000003 */
#define HSP_TRGOCFGR_TRGO0SRC     HSP_TRGOCFGR_TRGO0SRC_Msk            /*!< TRGO0SRC[1:0] bits (Trigger source selection for hsp_trg_out[0] <sup>(1)</sup>) */
#define HSP_TRGOCFGR_TRGO0SRC_0   (0x1UL << HSP_TRGOCFGR_TRGO0SRC_Pos) /*!< 0x00000001 */
#define HSP_TRGOCFGR_TRGO0SRC_1   (0x2UL << HSP_TRGOCFGR_TRGO0SRC_Pos) /*!< 0x00000002 */
/*!< TRGO1SRC configuration */
#define HSP_TRGOCFGR_TRGO1SRC_Pos (2U)
#define HSP_TRGOCFGR_TRGO1SRC_Msk (0x3UL << HSP_TRGOCFGR_TRGO1SRC_Pos) /*!< 0x0000000C */
#define HSP_TRGOCFGR_TRGO1SRC     HSP_TRGOCFGR_TRGO1SRC_Msk            /*!< TRGO1SRC[1:0] bits (Trigger source selection for hsp_trg_out[1] <sup>(1)</sup>) */
#define HSP_TRGOCFGR_TRGO1SRC_0   (0x1UL << HSP_TRGOCFGR_TRGO1SRC_Pos) /*!< 0x00000004 */
#define HSP_TRGOCFGR_TRGO1SRC_1   (0x2UL << HSP_TRGOCFGR_TRGO1SRC_Pos) /*!< 0x00000008 */
/*!< TRGO2SRC configuration */
#define HSP_TRGOCFGR_TRGO2SRC_Pos (4U)
#define HSP_TRGOCFGR_TRGO2SRC_Msk (0x3UL << HSP_TRGOCFGR_TRGO2SRC_Pos) /*!< 0x00000030 */
#define HSP_TRGOCFGR_TRGO2SRC     HSP_TRGOCFGR_TRGO2SRC_Msk            /*!< TRGO2SRC[1:0] bits (Trigger source selection for hsp_trg_out[2] <sup>(1)</sup>) */
#define HSP_TRGOCFGR_TRGO2SRC_0   (0x1UL << HSP_TRGOCFGR_TRGO2SRC_Pos) /*!< 0x00000010 */
#define HSP_TRGOCFGR_TRGO2SRC_1   (0x2UL << HSP_TRGOCFGR_TRGO2SRC_Pos) /*!< 0x00000020 */
/*!< TRGO3SRC configuration */
#define HSP_TRGOCFGR_TRGO3SRC_Pos (6U)
#define HSP_TRGOCFGR_TRGO3SRC_Msk (0x3UL << HSP_TRGOCFGR_TRGO3SRC_Pos) /*!< 0x000000C0 */
#define HSP_TRGOCFGR_TRGO3SRC     HSP_TRGOCFGR_TRGO3SRC_Msk            /*!< TRGO3SRC[1:0] bits (Trigger source selection for hsp_trg_out[3] ) */
#define HSP_TRGOCFGR_TRGO3SRC_0   (0x1UL << HSP_TRGOCFGR_TRGO3SRC_Pos) /*!< 0x00000040 */
#define HSP_TRGOCFGR_TRGO3SRC_1   (0x2UL << HSP_TRGOCFGR_TRGO3SRC_Pos) /*!< 0x00000080 */

/********************  Bit definition for HSP_CSEGR register  ********************/
/*!< CSEVT configuration */
#define HSP_CSEGR_CSEVT_Pos (1U)
#define HSP_CSEGR_CSEVT_Msk (0x3FFFFFUL << HSP_CSEGR_CSEVT_Pos) /*!< 0x007FFFFE */
#define HSP_CSEGR_CSEVT     HSP_CSEGR_CSEVT_Msk                 /*!< CSEVT[21:0] bits (CPU Shared Software Event ) */
#define HSP_CSEGR_CSEVT_0   (0x0001UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000002 */
#define HSP_CSEGR_CSEVT_1   (0x0002UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000004 */
#define HSP_CSEGR_CSEVT_2   (0x0004UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000008 */
#define HSP_CSEGR_CSEVT_3   (0x0008UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000010 */
#define HSP_CSEGR_CSEVT_4   (0x0010UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000020 */
#define HSP_CSEGR_CSEVT_5   (0x0020UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000040 */
#define HSP_CSEGR_CSEVT_6   (0x0040UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000080 */
#define HSP_CSEGR_CSEVT_7   (0x0080UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000100 */
#define HSP_CSEGR_CSEVT_8   (0x0100UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000200 */
#define HSP_CSEGR_CSEVT_9   (0x0200UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000400 */
#define HSP_CSEGR_CSEVT_10  (0x0400UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00000800 */
#define HSP_CSEGR_CSEVT_11  (0x0800UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00001000 */
#define HSP_CSEGR_CSEVT_12  (0x1000UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00002000 */
#define HSP_CSEGR_CSEVT_13  (0x2000UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00004000 */
#define HSP_CSEGR_CSEVT_14  (0x4000UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00008000 */
#define HSP_CSEGR_CSEVT_15  (0x8000UL << HSP_CSEGR_CSEVT_Pos)   /*!< 0x00010000 */
#define HSP_CSEGR_CSEVT_16  (0x10000UL << HSP_CSEGR_CSEVT_Pos)  /*!< 0x00020000 */
#define HSP_CSEGR_CSEVT_17  (0x20000UL << HSP_CSEGR_CSEVT_Pos)  /*!< 0x00040000 */
#define HSP_CSEGR_CSEVT_18  (0x40000UL << HSP_CSEGR_CSEVT_Pos)  /*!< 0x00080000 */
#define HSP_CSEGR_CSEVT_19  (0x80000UL << HSP_CSEGR_CSEVT_Pos)  /*!< 0x00100000 */
#define HSP_CSEGR_CSEVT_20  (0x100000UL << HSP_CSEGR_CSEVT_Pos) /*!< 0x00200000 */
#define HSP_CSEGR_CSEVT_21  (0x200000UL << HSP_CSEGR_CSEVT_Pos) /*!< 0x00400000 */

/********************  Bit definition for HSP_CDEGR register  ********************/
/*!< CTSKN configuration */
#define HSP_CDEGR_CTSKN_Pos   (0U)
#define HSP_CDEGR_CTSKN_Msk   (0x3FUL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x0000003F */
#define HSP_CDEGR_CTSKN       HSP_CDEGR_CTSKN_Msk              /*!< CTSKN[5:0] bits (CPU Task number) */
#define HSP_CDEGR_CTSKN_0     (0x01UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000001 */
#define HSP_CDEGR_CTSKN_1     (0x02UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000002 */
#define HSP_CDEGR_CTSKN_2     (0x04UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000004 */
#define HSP_CDEGR_CTSKN_3     (0x08UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000008 */
#define HSP_CDEGR_CTSKN_4     (0x10UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000010 */
#define HSP_CDEGR_CTSKN_5     (0x20UL << HSP_CDEGR_CTSKN_Pos)  /*!< 0x00000020 */
/*!< CDEGBSY configuration */
#define HSP_CDEGR_CDEGBSY_Pos (31U)
#define HSP_CDEGR_CDEGBSY_Msk (0x1UL << HSP_CDEGR_CDEGBSY_Pos) /*!< 0x80000000 */
#define HSP_CDEGR_CDEGBSY     HSP_CDEGR_CDEGBSY_Msk            /*!< CDEGBSY (CPU dedicated event generator busy) */

/********************  Bit definition for HSP_TRGINSELR0 register  ********************/
/*!< TRG0SEL configuration */
#define HSP_TRGINSELR0_TRG0SEL_Pos (0U)
#define HSP_TRGINSELR0_TRG0SEL_Msk (0x3FUL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x0000003F */
#define HSP_TRGINSELR0_TRG0SEL     HSP_TRGINSELR0_TRG0SEL_Msk             /*!< TRG0SEL[5:0] bits (Input trigger selection for TRGIN0) */
#define HSP_TRGINSELR0_TRG0SEL_0   (0x01UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000001 */
#define HSP_TRGINSELR0_TRG0SEL_1   (0x02UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000002 */
#define HSP_TRGINSELR0_TRG0SEL_2   (0x04UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000004 */
#define HSP_TRGINSELR0_TRG0SEL_3   (0x08UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000008 */
#define HSP_TRGINSELR0_TRG0SEL_4   (0x10UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000010 */
#define HSP_TRGINSELR0_TRG0SEL_5   (0x20UL << HSP_TRGINSELR0_TRG0SEL_Pos) /*!< 0x00000020 */
/*!< TRG1SEL configuration */
#define HSP_TRGINSELR0_TRG1SEL_Pos (8U)
#define HSP_TRGINSELR0_TRG1SEL_Msk (0x3FUL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00003F00 */
#define HSP_TRGINSELR0_TRG1SEL     HSP_TRGINSELR0_TRG1SEL_Msk             /*!< TRG1SEL[5:0] bits (Input trigger selection for TRGIN1) */
#define HSP_TRGINSELR0_TRG1SEL_0   (0x01UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00000100 */
#define HSP_TRGINSELR0_TRG1SEL_1   (0x02UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00000200 */
#define HSP_TRGINSELR0_TRG1SEL_2   (0x04UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00000400 */
#define HSP_TRGINSELR0_TRG1SEL_3   (0x08UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00000800 */
#define HSP_TRGINSELR0_TRG1SEL_4   (0x10UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00001000 */
#define HSP_TRGINSELR0_TRG1SEL_5   (0x20UL << HSP_TRGINSELR0_TRG1SEL_Pos) /*!< 0x00002000 */
/*!< TRG2SEL configuration */
#define HSP_TRGINSELR0_TRG2SEL_Pos (16U)
#define HSP_TRGINSELR0_TRG2SEL_Msk (0x3FUL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x003F0000 */
#define HSP_TRGINSELR0_TRG2SEL     HSP_TRGINSELR0_TRG2SEL_Msk             /*!< TRG2SEL[5:0] bits (Input trigger selection for TRGIN2) */
#define HSP_TRGINSELR0_TRG2SEL_0   (0x01UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00010000 */
#define HSP_TRGINSELR0_TRG2SEL_1   (0x02UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00020000 */
#define HSP_TRGINSELR0_TRG2SEL_2   (0x04UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00040000 */
#define HSP_TRGINSELR0_TRG2SEL_3   (0x08UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00080000 */
#define HSP_TRGINSELR0_TRG2SEL_4   (0x10UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00100000 */
#define HSP_TRGINSELR0_TRG2SEL_5   (0x20UL << HSP_TRGINSELR0_TRG2SEL_Pos) /*!< 0x00200000 */
/*!< TRG3SEL configuration */
#define HSP_TRGINSELR0_TRG3SEL_Pos (24U)
#define HSP_TRGINSELR0_TRG3SEL_Msk (0x3FUL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x3F000000 */
#define HSP_TRGINSELR0_TRG3SEL     HSP_TRGINSELR0_TRG3SEL_Msk             /*!< TRG3SEL[5:0] bits (Input trigger selection for TRGIN3) */
#define HSP_TRGINSELR0_TRG3SEL_0   (0x01UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x01000000 */
#define HSP_TRGINSELR0_TRG3SEL_1   (0x02UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x02000000 */
#define HSP_TRGINSELR0_TRG3SEL_2   (0x04UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x04000000 */
#define HSP_TRGINSELR0_TRG3SEL_3   (0x08UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x08000000 */
#define HSP_TRGINSELR0_TRG3SEL_4   (0x10UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x10000000 */
#define HSP_TRGINSELR0_TRG3SEL_5   (0x20UL << HSP_TRGINSELR0_TRG3SEL_Pos) /*!< 0x20000000 */

/********************  Bit definition for HSP_TRGINSELR1 register  ********************/
/*!< TRG4SEL configuration */
#define HSP_TRGINSELR1_TRG4SEL_Pos (0U)
#define HSP_TRGINSELR1_TRG4SEL_Msk (0x3FUL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x0000003F */
#define HSP_TRGINSELR1_TRG4SEL     HSP_TRGINSELR1_TRG4SEL_Msk             /*!< TRG4SEL[5:0] bits (Input trigger selection for TRGIN4) */
#define HSP_TRGINSELR1_TRG4SEL_0   (0x01UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000001 */
#define HSP_TRGINSELR1_TRG4SEL_1   (0x02UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000002 */
#define HSP_TRGINSELR1_TRG4SEL_2   (0x04UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000004 */
#define HSP_TRGINSELR1_TRG4SEL_3   (0x08UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000008 */
#define HSP_TRGINSELR1_TRG4SEL_4   (0x10UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000010 */
#define HSP_TRGINSELR1_TRG4SEL_5   (0x20UL << HSP_TRGINSELR1_TRG4SEL_Pos) /*!< 0x00000020 */
/*!< TRG5SEL configuration */
#define HSP_TRGINSELR1_TRG5SEL_Pos (8U)
#define HSP_TRGINSELR1_TRG5SEL_Msk (0x3FUL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00003F00 */
#define HSP_TRGINSELR1_TRG5SEL     HSP_TRGINSELR1_TRG5SEL_Msk             /*!< TRG5SEL[5:0] bits (Input trigger selection for TRGIN5) */
#define HSP_TRGINSELR1_TRG5SEL_0   (0x01UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00000100 */
#define HSP_TRGINSELR1_TRG5SEL_1   (0x02UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00000200 */
#define HSP_TRGINSELR1_TRG5SEL_2   (0x04UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00000400 */
#define HSP_TRGINSELR1_TRG5SEL_3   (0x08UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00000800 */
#define HSP_TRGINSELR1_TRG5SEL_4   (0x10UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00001000 */
#define HSP_TRGINSELR1_TRG5SEL_5   (0x20UL << HSP_TRGINSELR1_TRG5SEL_Pos) /*!< 0x00002000 */
/*!< TRG6SEL configuration */
#define HSP_TRGINSELR1_TRG6SEL_Pos (16U)
#define HSP_TRGINSELR1_TRG6SEL_Msk (0x3FUL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x003F0000 */
#define HSP_TRGINSELR1_TRG6SEL     HSP_TRGINSELR1_TRG6SEL_Msk             /*!< TRG6SEL[5:0] bits (Input trigger selection for TRGIN6) */
#define HSP_TRGINSELR1_TRG6SEL_0   (0x01UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00010000 */
#define HSP_TRGINSELR1_TRG6SEL_1   (0x02UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00020000 */
#define HSP_TRGINSELR1_TRG6SEL_2   (0x04UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00040000 */
#define HSP_TRGINSELR1_TRG6SEL_3   (0x08UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00080000 */
#define HSP_TRGINSELR1_TRG6SEL_4   (0x10UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00100000 */
#define HSP_TRGINSELR1_TRG6SEL_5   (0x20UL << HSP_TRGINSELR1_TRG6SEL_Pos) /*!< 0x00200000 */
/*!< TRG7SEL configuration */
#define HSP_TRGINSELR1_TRG7SEL_Pos (24U)
#define HSP_TRGINSELR1_TRG7SEL_Msk (0x3FUL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x3F000000 */
#define HSP_TRGINSELR1_TRG7SEL     HSP_TRGINSELR1_TRG7SEL_Msk             /*!< TRG7SEL[5:0] bits (Input trigger selection for TRGIN7) */
#define HSP_TRGINSELR1_TRG7SEL_0   (0x01UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x01000000 */
#define HSP_TRGINSELR1_TRG7SEL_1   (0x02UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x02000000 */
#define HSP_TRGINSELR1_TRG7SEL_2   (0x04UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x04000000 */
#define HSP_TRGINSELR1_TRG7SEL_3   (0x08UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x08000000 */
#define HSP_TRGINSELR1_TRG7SEL_4   (0x10UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x10000000 */
#define HSP_TRGINSELR1_TRG7SEL_5   (0x20UL << HSP_TRGINSELR1_TRG7SEL_Pos) /*!< 0x20000000 */

/********************  Bit definition for HSP_TRGINSELR2 register  ********************/
/*!< TRG8SEL configuration */
#define HSP_TRGINSELR2_TRG8SEL_Pos (0U)
#define HSP_TRGINSELR2_TRG8SEL_Msk (0x3FUL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x0000003F */
#define HSP_TRGINSELR2_TRG8SEL     HSP_TRGINSELR2_TRG8SEL_Msk             /*!< TRG8SEL[5:0] bits (Input trigger selection for TRGIN8) */
#define HSP_TRGINSELR2_TRG8SEL_0   (0x01UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000001 */
#define HSP_TRGINSELR2_TRG8SEL_1   (0x02UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000002 */
#define HSP_TRGINSELR2_TRG8SEL_2   (0x04UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000004 */
#define HSP_TRGINSELR2_TRG8SEL_3   (0x08UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000008 */
#define HSP_TRGINSELR2_TRG8SEL_4   (0x10UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000010 */
#define HSP_TRGINSELR2_TRG8SEL_5   (0x20UL << HSP_TRGINSELR2_TRG8SEL_Pos) /*!< 0x00000020 */
/*!< TRG9SEL configuration */
#define HSP_TRGINSELR2_TRG9SEL_Pos (8U)
#define HSP_TRGINSELR2_TRG9SEL_Msk (0x3FUL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00003F00 */
#define HSP_TRGINSELR2_TRG9SEL     HSP_TRGINSELR2_TRG9SEL_Msk             /*!< TRG9SEL[5:0] bits (Input trigger selection for TRGIN9) */
#define HSP_TRGINSELR2_TRG9SEL_0   (0x01UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00000100 */
#define HSP_TRGINSELR2_TRG9SEL_1   (0x02UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00000200 */
#define HSP_TRGINSELR2_TRG9SEL_2   (0x04UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00000400 */
#define HSP_TRGINSELR2_TRG9SEL_3   (0x08UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00000800 */
#define HSP_TRGINSELR2_TRG9SEL_4   (0x10UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00001000 */
#define HSP_TRGINSELR2_TRG9SEL_5   (0x20UL << HSP_TRGINSELR2_TRG9SEL_Pos) /*!< 0x00002000 */

/********************  Bit definition for HSP_BKO0CFGR register  ********************/
/*!< ACCEREN configuration */
#define HSP_BKO0CFGR_ACCEREN_Pos  (0U)
#define HSP_BKO0CFGR_ACCEREN_Msk  (0x1UL << HSP_BKO0CFGR_ACCEREN_Pos)  /*!< 0x00000001 */
#define HSP_BKO0CFGR_ACCEREN      HSP_BKO0CFGR_ACCEREN_Msk             /*!< ACCEREN (Access error break enable for ACCERRF <sup>(1)</sup>) */
/*!< FPUEREN configuration */
#define HSP_BKO0CFGR_FPUEREN_Pos  (1U)
#define HSP_BKO0CFGR_FPUEREN_Msk  (0x1UL << HSP_BKO0CFGR_FPUEREN_Pos)  /*!< 0x00000002 */
#define HSP_BKO0CFGR_FPUEREN      HSP_BKO0CFGR_FPUEREN_Msk             /*!< FPUEREN (FPU error break enable for FPUERRF <sup>(1)</sup>) */
/*!< OPCEREN configuration */
#define HSP_BKO0CFGR_OPCEREN_Pos  (2U)
#define HSP_BKO0CFGR_OPCEREN_Msk  (0x1UL << HSP_BKO0CFGR_OPCEREN_Pos)  /*!< 0x00000004 */
#define HSP_BKO0CFGR_OPCEREN      HSP_BKO0CFGR_OPCEREN_Msk             /*!< OPCEREN (Opcode error break enable for OPCOERRF ) */
/*!< PFCT28EN configuration */
#define HSP_BKO0CFGR_PFCT28EN_Pos (4U)
#define HSP_BKO0CFGR_PFCT28EN_Msk (0x1UL << HSP_BKO0CFGR_PFCT28EN_Pos) /*!< 0x00000010 */
#define HSP_BKO0CFGR_PFCT28EN     HSP_BKO0CFGR_PFCT28EN_Msk            /*!< PFCT28EN (Processing function flag break enable for PFCTF[28] <sup>(1)</sup>) */
/*!< PFCT29EN configuration */
#define HSP_BKO0CFGR_PFCT29EN_Pos (5U)
#define HSP_BKO0CFGR_PFCT29EN_Msk (0x1UL << HSP_BKO0CFGR_PFCT29EN_Pos) /*!< 0x00000020 */
#define HSP_BKO0CFGR_PFCT29EN     HSP_BKO0CFGR_PFCT29EN_Msk            /*!< PFCT29EN (Processing function flag break enable for PFCTF[29] <sup>(1)</sup>) */
/*!< PFCT30EN configuration */
#define HSP_BKO0CFGR_PFCT30EN_Pos (6U)
#define HSP_BKO0CFGR_PFCT30EN_Msk (0x1UL << HSP_BKO0CFGR_PFCT30EN_Pos) /*!< 0x00000040 */
#define HSP_BKO0CFGR_PFCT30EN     HSP_BKO0CFGR_PFCT30EN_Msk            /*!< PFCT30EN (Processing function flag break enable for PFCTF[30] <sup>(1)</sup>) */
/*!< PFCT31EN configuration */
#define HSP_BKO0CFGR_PFCT31EN_Pos (7U)
#define HSP_BKO0CFGR_PFCT31EN_Msk (0x1UL << HSP_BKO0CFGR_PFCT31EN_Pos) /*!< 0x00000080 */
#define HSP_BKO0CFGR_PFCT31EN     HSP_BKO0CFGR_PFCT31EN_Msk            /*!< PFCT31EN (Processing function flag break enable for PFCTF[31] <sup>(1)</sup>) */
/*!< FWEREN configuration */
#define HSP_BKO0CFGR_FWEREN_Pos   (12U)
#define HSP_BKO0CFGR_FWEREN_Msk   (0x1UL << HSP_BKO0CFGR_FWEREN_Pos)   /*!< 0x00001000 */
#define HSP_BKO0CFGR_FWEREN       HSP_BKO0CFGR_FWEREN_Msk              /*!< FWEREN (Firmware error break enable for FWERRF <sup>(1)</sup>) */
/*!< HDEGOVEN configuration */
#define HSP_BKO0CFGR_HDEGOVEN_Pos (13U)
#define HSP_BKO0CFGR_HDEGOVEN_Msk (0x1UL << HSP_BKO0CFGR_HDEGOVEN_Pos) /*!< 0x00002000 */
#define HSP_BKO0CFGR_HDEGOVEN     HSP_BKO0CFGR_HDEGOVEN_Msk            /*!< HDEGOVEN (HSP dedicated event generator overrun break enable for HDEGOVRF <sup>(1)</sup>) */

/********************  Bit definition for HSP_BKO1CFGR register  ********************/
/*!< ACCEREN configuration */
#define HSP_BKO1CFGR_ACCEREN_Pos  (0U)
#define HSP_BKO1CFGR_ACCEREN_Msk  (0x1UL << HSP_BKO1CFGR_ACCEREN_Pos)  /*!< 0x00000001 */
#define HSP_BKO1CFGR_ACCEREN      HSP_BKO1CFGR_ACCEREN_Msk             /*!< ACCEREN (Access error break enable for ACCERRF <sup>(1)</sup>) */
/*!< FPUEREN configuration */
#define HSP_BKO1CFGR_FPUEREN_Pos  (1U)
#define HSP_BKO1CFGR_FPUEREN_Msk  (0x1UL << HSP_BKO1CFGR_FPUEREN_Pos)  /*!< 0x00000002 */
#define HSP_BKO1CFGR_FPUEREN      HSP_BKO1CFGR_FPUEREN_Msk             /*!< FPUEREN (FPU error break enable for FPUERRF <sup>(1)</sup>) */
/*!< OPCEREN configuration */
#define HSP_BKO1CFGR_OPCEREN_Pos  (2U)
#define HSP_BKO1CFGR_OPCEREN_Msk  (0x1UL << HSP_BKO1CFGR_OPCEREN_Pos)  /*!< 0x00000004 */
#define HSP_BKO1CFGR_OPCEREN      HSP_BKO1CFGR_OPCEREN_Msk             /*!< OPCEREN (Opcode error break enable for OPCOERRF ) */
/*!< PFCT28EN configuration */
#define HSP_BKO1CFGR_PFCT28EN_Pos (4U)
#define HSP_BKO1CFGR_PFCT28EN_Msk (0x1UL << HSP_BKO1CFGR_PFCT28EN_Pos) /*!< 0x00000010 */
#define HSP_BKO1CFGR_PFCT28EN     HSP_BKO1CFGR_PFCT28EN_Msk            /*!< PFCT28EN (Processing function flag break enable for PFCTF[28] <sup>(1)</sup>) */
/*!< PFCT29EN configuration */
#define HSP_BKO1CFGR_PFCT29EN_Pos (5U)
#define HSP_BKO1CFGR_PFCT29EN_Msk (0x1UL << HSP_BKO1CFGR_PFCT29EN_Pos) /*!< 0x00000020 */
#define HSP_BKO1CFGR_PFCT29EN     HSP_BKO1CFGR_PFCT29EN_Msk            /*!< PFCT29EN (Processing function flag break enable for PFCTF[29] <sup>(1)</sup>) */
/*!< PFCT30EN configuration */
#define HSP_BKO1CFGR_PFCT30EN_Pos (6U)
#define HSP_BKO1CFGR_PFCT30EN_Msk (0x1UL << HSP_BKO1CFGR_PFCT30EN_Pos) /*!< 0x00000040 */
#define HSP_BKO1CFGR_PFCT30EN     HSP_BKO1CFGR_PFCT30EN_Msk            /*!< PFCT30EN (Processing function flag break enable for PFCTF[30] <sup>(1)</sup>) */
/*!< PFCT31EN configuration */
#define HSP_BKO1CFGR_PFCT31EN_Pos (7U)
#define HSP_BKO1CFGR_PFCT31EN_Msk (0x1UL << HSP_BKO1CFGR_PFCT31EN_Pos) /*!< 0x00000080 */
#define HSP_BKO1CFGR_PFCT31EN     HSP_BKO1CFGR_PFCT31EN_Msk            /*!< PFCT31EN (Processing function flag break enable for PFCTF[31] <sup>(1)</sup>) */
/*!< FWEREN configuration */
#define HSP_BKO1CFGR_FWEREN_Pos   (12U)
#define HSP_BKO1CFGR_FWEREN_Msk   (0x1UL << HSP_BKO1CFGR_FWEREN_Pos)   /*!< 0x00001000 */
#define HSP_BKO1CFGR_FWEREN       HSP_BKO1CFGR_FWEREN_Msk              /*!< FWEREN (Firmware error break enable for FWERRF <sup>(1)</sup>) */
/*!< HDEGOVEN configuration */
#define HSP_BKO1CFGR_HDEGOVEN_Pos (13U)
#define HSP_BKO1CFGR_HDEGOVEN_Msk (0x1UL << HSP_BKO1CFGR_HDEGOVEN_Pos) /*!< 0x00002000 */
#define HSP_BKO1CFGR_HDEGOVEN     HSP_BKO1CFGR_HDEGOVEN_Msk            /*!< HDEGOVEN (HSP dedicated event generator overrun break enable for HDEGOVRF <sup>(1)</sup>) */

/********************  Bit definition for HSP_BKO2CFGR register  ********************/
/*!< ACCEREN configuration */
#define HSP_BKO2CFGR_ACCEREN_Pos  (0U)
#define HSP_BKO2CFGR_ACCEREN_Msk  (0x1UL << HSP_BKO2CFGR_ACCEREN_Pos)  /*!< 0x00000001 */
#define HSP_BKO2CFGR_ACCEREN      HSP_BKO2CFGR_ACCEREN_Msk             /*!< ACCEREN (Access error break enable for ACCERRF <sup>(1)</sup>) */
/*!< FPUEREN configuration */
#define HSP_BKO2CFGR_FPUEREN_Pos  (1U)
#define HSP_BKO2CFGR_FPUEREN_Msk  (0x1UL << HSP_BKO2CFGR_FPUEREN_Pos)  /*!< 0x00000002 */
#define HSP_BKO2CFGR_FPUEREN      HSP_BKO2CFGR_FPUEREN_Msk             /*!< FPUEREN (FPU error break enable for FPUERRF <sup>(1)</sup>) */
/*!< OPCEREN configuration */
#define HSP_BKO2CFGR_OPCEREN_Pos  (2U)
#define HSP_BKO2CFGR_OPCEREN_Msk  (0x1UL << HSP_BKO2CFGR_OPCEREN_Pos)  /*!< 0x00000004 */
#define HSP_BKO2CFGR_OPCEREN      HSP_BKO2CFGR_OPCEREN_Msk             /*!< OPCEREN (Opcode error break enable for OPCOERRF ) */
/*!< PFCT28EN configuration */
#define HSP_BKO2CFGR_PFCT28EN_Pos (4U)
#define HSP_BKO2CFGR_PFCT28EN_Msk (0x1UL << HSP_BKO2CFGR_PFCT28EN_Pos) /*!< 0x00000010 */
#define HSP_BKO2CFGR_PFCT28EN     HSP_BKO2CFGR_PFCT28EN_Msk            /*!< PFCT28EN (Processing function flag break enable for PFCTF[28] <sup>(1)</sup>) */
/*!< PFCT29EN configuration */
#define HSP_BKO2CFGR_PFCT29EN_Pos (5U)
#define HSP_BKO2CFGR_PFCT29EN_Msk (0x1UL << HSP_BKO2CFGR_PFCT29EN_Pos) /*!< 0x00000020 */
#define HSP_BKO2CFGR_PFCT29EN     HSP_BKO2CFGR_PFCT29EN_Msk            /*!< PFCT29EN (Processing function flag break enable for PFCTF[29] <sup>(1)</sup>) */
/*!< PFCT30EN configuration */
#define HSP_BKO2CFGR_PFCT30EN_Pos (6U)
#define HSP_BKO2CFGR_PFCT30EN_Msk (0x1UL << HSP_BKO2CFGR_PFCT30EN_Pos) /*!< 0x00000040 */
#define HSP_BKO2CFGR_PFCT30EN     HSP_BKO2CFGR_PFCT30EN_Msk            /*!< PFCT30EN (Processing function flag break enable for PFCTF[30] <sup>(1)</sup>) */
/*!< PFCT31EN configuration */
#define HSP_BKO2CFGR_PFCT31EN_Pos (7U)
#define HSP_BKO2CFGR_PFCT31EN_Msk (0x1UL << HSP_BKO2CFGR_PFCT31EN_Pos) /*!< 0x00000080 */
#define HSP_BKO2CFGR_PFCT31EN     HSP_BKO2CFGR_PFCT31EN_Msk            /*!< PFCT31EN (Processing function flag break enable for PFCTF[31] <sup>(1)</sup>) */
/*!< FWEREN configuration */
#define HSP_BKO2CFGR_FWEREN_Pos   (12U)
#define HSP_BKO2CFGR_FWEREN_Msk   (0x1UL << HSP_BKO2CFGR_FWEREN_Pos)   /*!< 0x00001000 */
#define HSP_BKO2CFGR_FWEREN       HSP_BKO2CFGR_FWEREN_Msk              /*!< FWEREN (Firmware error break enable for FWERRF <sup>(1)</sup>) */
/*!< HDEGOVEN configuration */
#define HSP_BKO2CFGR_HDEGOVEN_Pos (13U)
#define HSP_BKO2CFGR_HDEGOVEN_Msk (0x1UL << HSP_BKO2CFGR_HDEGOVEN_Pos) /*!< 0x00002000 */
#define HSP_BKO2CFGR_HDEGOVEN     HSP_BKO2CFGR_HDEGOVEN_Msk            /*!< HDEGOVEN (HSP dedicated event generator overrun break enable for HDEGOVRF <sup>(1)</sup>) */

/********************  Bit definition for HSP_BKO3CFGR register  ********************/
/*!< ACCEREN configuration */
#define HSP_BKO3CFGR_ACCEREN_Pos  (0U)
#define HSP_BKO3CFGR_ACCEREN_Msk  (0x1UL << HSP_BKO3CFGR_ACCEREN_Pos)  /*!< 0x00000001 */
#define HSP_BKO3CFGR_ACCEREN      HSP_BKO3CFGR_ACCEREN_Msk             /*!< ACCEREN (Access error break enable for ACCERRF <sup>(1)</sup>) */
/*!< FPUEREN configuration */
#define HSP_BKO3CFGR_FPUEREN_Pos  (1U)
#define HSP_BKO3CFGR_FPUEREN_Msk  (0x1UL << HSP_BKO3CFGR_FPUEREN_Pos)  /*!< 0x00000002 */
#define HSP_BKO3CFGR_FPUEREN      HSP_BKO3CFGR_FPUEREN_Msk             /*!< FPUEREN (FPU error break enable for FPUERRF <sup>(1)</sup>) */
/*!< OPCEREN configuration */
#define HSP_BKO3CFGR_OPCEREN_Pos  (2U)
#define HSP_BKO3CFGR_OPCEREN_Msk  (0x1UL << HSP_BKO3CFGR_OPCEREN_Pos)  /*!< 0x00000004 */
#define HSP_BKO3CFGR_OPCEREN      HSP_BKO3CFGR_OPCEREN_Msk             /*!< OPCEREN (Opcode error break enable for OPCOERRF ) */
/*!< PFCT28EN configuration */
#define HSP_BKO3CFGR_PFCT28EN_Pos (4U)
#define HSP_BKO3CFGR_PFCT28EN_Msk (0x1UL << HSP_BKO3CFGR_PFCT28EN_Pos) /*!< 0x00000010 */
#define HSP_BKO3CFGR_PFCT28EN     HSP_BKO3CFGR_PFCT28EN_Msk            /*!< PFCT28EN (Processing function flag break enable for PFCTF[28] <sup>(1)</sup>) */
/*!< PFCT29EN configuration */
#define HSP_BKO3CFGR_PFCT29EN_Pos (5U)
#define HSP_BKO3CFGR_PFCT29EN_Msk (0x1UL << HSP_BKO3CFGR_PFCT29EN_Pos) /*!< 0x00000020 */
#define HSP_BKO3CFGR_PFCT29EN     HSP_BKO3CFGR_PFCT29EN_Msk            /*!< PFCT29EN (Processing function flag break enable for PFCTF[29] <sup>(1)</sup>) */
/*!< PFCT30EN configuration */
#define HSP_BKO3CFGR_PFCT30EN_Pos (6U)
#define HSP_BKO3CFGR_PFCT30EN_Msk (0x1UL << HSP_BKO3CFGR_PFCT30EN_Pos) /*!< 0x00000040 */
#define HSP_BKO3CFGR_PFCT30EN     HSP_BKO3CFGR_PFCT30EN_Msk            /*!< PFCT30EN (Processing function flag break enable for PFCTF[30] <sup>(1)</sup>) */
/*!< PFCT31EN configuration */
#define HSP_BKO3CFGR_PFCT31EN_Pos (7U)
#define HSP_BKO3CFGR_PFCT31EN_Msk (0x1UL << HSP_BKO3CFGR_PFCT31EN_Pos) /*!< 0x00000080 */
#define HSP_BKO3CFGR_PFCT31EN     HSP_BKO3CFGR_PFCT31EN_Msk            /*!< PFCT31EN (Processing function flag break enable for PFCTF[31] <sup>(1)</sup>) */
/*!< FWEREN configuration */
#define HSP_BKO3CFGR_FWEREN_Pos   (12U)
#define HSP_BKO3CFGR_FWEREN_Msk   (0x1UL << HSP_BKO3CFGR_FWEREN_Pos)   /*!< 0x00001000 */
#define HSP_BKO3CFGR_FWEREN       HSP_BKO3CFGR_FWEREN_Msk              /*!< FWEREN (Firmware error break enable for FWERRF <sup>(1)</sup>) */
/*!< HDEGOVEN configuration */
#define HSP_BKO3CFGR_HDEGOVEN_Pos (13U)
#define HSP_BKO3CFGR_HDEGOVEN_Msk (0x1UL << HSP_BKO3CFGR_HDEGOVEN_Pos) /*!< 0x00002000 */
#define HSP_BKO3CFGR_HDEGOVEN     HSP_BKO3CFGR_HDEGOVEN_Msk            /*!< HDEGOVEN (HSP dedicated event generator overrun break enable for HDEGOVRF <sup>(1)</sup>) */

/********************  Bit definition for HSP_BKICFGR register  ********************/
/*!< ACCEREN configuration */
#define HSP_BKICFGR_ACCEREN_Pos  (0U)
#define HSP_BKICFGR_ACCEREN_Msk  (0x1UL << HSP_BKICFGR_ACCEREN_Pos)  /*!< 0x00000001 */
#define HSP_BKICFGR_ACCEREN      HSP_BKICFGR_ACCEREN_Msk             /*!< ACCEREN (Access error break enable for ACCERRF <sup>(1)</sup>) */
/*!< FPUEREN configuration */
#define HSP_BKICFGR_FPUEREN_Pos  (1U)
#define HSP_BKICFGR_FPUEREN_Msk  (0x1UL << HSP_BKICFGR_FPUEREN_Pos)  /*!< 0x00000002 */
#define HSP_BKICFGR_FPUEREN      HSP_BKICFGR_FPUEREN_Msk             /*!< FPUEREN (FPU error break enable for FPUERRF <sup>(1)</sup>) */
/*!< OPCEREN configuration */
#define HSP_BKICFGR_OPCEREN_Pos  (2U)
#define HSP_BKICFGR_OPCEREN_Msk  (0x1UL << HSP_BKICFGR_OPCEREN_Pos)  /*!< 0x00000004 */
#define HSP_BKICFGR_OPCEREN      HSP_BKICFGR_OPCEREN_Msk             /*!< OPCEREN (Opcode error break enable for OPCOERRF ) */
/*!< BKIEN configuration */
#define HSP_BKICFGR_BKIEN_Pos    (3U)
#define HSP_BKICFGR_BKIEN_Msk    (0x1UL << HSP_BKICFGR_BKIEN_Pos)    /*!< 0x00000008 */
#define HSP_BKICFGR_BKIEN        HSP_BKICFGR_BKIEN_Msk               /*!< BKIEN (Break enable for hsp_break_in signal <sup>(1)</sup>) */
/*!< PFCT28EN configuration */
#define HSP_BKICFGR_PFCT28EN_Pos (4U)
#define HSP_BKICFGR_PFCT28EN_Msk (0x1UL << HSP_BKICFGR_PFCT28EN_Pos) /*!< 0x00000010 */
#define HSP_BKICFGR_PFCT28EN     HSP_BKICFGR_PFCT28EN_Msk            /*!< PFCT28EN (Processing function flag break enable for PFCTF[28] <sup>(1)</sup>) */