#ifndef _STM32YYXX_LL_FSMC_H_
#define _STM32YYXX_LL_FSMC_H_
/* LL raised several warnings, ignore them */
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#ifdef __cplusplus
  #pragma GCC diagnostic ignored "-Wregister"
#endif

#ifdef STM32F1xx
  #include "stm32f1xx_ll_fsmc.h"
#elif STM32F2xx
  #include "stm32f2xx_ll_fsmc.h"
#elif STM32F4xx
  #include "stm32f4xx_ll_fsmc.h"
#elif STM32L1xx
  #include "stm32l1xx_ll_fsmc.h"
#endif
#pragma GCC diagnostic pop
#endif /* _STM32YYXX_LL_FSMC_H_ */
