/*
  Mouse.cpp

  Copyright (c) 2015, Arduino LLC
  Original code (pre-library): Copyright (c) 2011, Peter Barrett

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "Mouse.h"

#if defined(USBCON)
#include "usbd_hid_composite_if.h"

//================================================================================
//================================================================================
//  Mouse

Mouse_::Mouse_(void) : _buttons(0)
{
}

void Mouse_::begin(void)
{
  HID_Composite_Init(HID_MOUSE);
}

void Mouse_::end(void)
{
  HID_Composite_DeInit(HID_MOUSE);
}

void Mouse_::click(uint8_t b)
{
  _buttons = b;
  move(0, 0, 0);
  _buttons = 0;
  move(0, 0, 0);
}

void Mouse_::move(signed char x, signed char y, signed char wheel)
{
  uint8_t m[4];
  m[0] = _buttons;
  m[1] = x;
  m[2] = y;
  m[3] = wheel;

  HID_Composite_mouse_sendReport(m, 4);
}

void Mouse_::buttons(uint8_t b)
{
  if (b != _buttons) {
    _buttons = b;
    move(0, 0, 0);
  }
}

void Mouse_::press(uint8_t b)
{
  buttons(_buttons | b);
}

void Mouse_::release(uint8_t b)
{
  buttons(_buttons & ~b);
}

bool Mouse_::isPressed(uint8_t b)
{
  if ((b & _buttons) > 0) {
    return true;
  }
  return false;
}

Mouse_ Mouse;

#endif
