---
sidebarDepth: 6
---
# v12.0.0 知微


<p style="font-family:宋体;font-size:20px;">见隐与微，知著察细。</p>
<p style="font-family:宋体;font-size:20px;text-align:right;">--《礼记·中庸》</p>


::: tip 提示

软件问题，请在Github提出[Issue](https://github.com/CopyTranslator/CopyTranslator/issues)进行反馈。

**反馈问题前请确认该问题在指南当中没有提及，且您使用的是最新版本[![](https://img.shields.io/github/release/copytranslator/copytranslator.svg)](https://github.com/copytranslator/copytranslator/releases)。
**。

:::

::: tip 新特性摘要
- [大模型 AI 翻译](#大模型-ai-翻译)：支持 OpenAI 格式 API 的各种大语言模型翻译服务
- [阶跃星辰翻译引擎](#阶跃星辰翻译引擎)：内置 StepFun step-3.5-flash 模型，提供限时免费的大模型翻译
- [预定义供应商模板](#预定义供应商模板)：快速配置 OpenAI、DeepSeek、Moonshot 等常用 AI 服务
- [可视化供应商管理](#ai-翻译供应商)：通过设置界面管理所有翻译供应商
:::

## 大模型 AI 翻译

v12 版本最大的亮点是支持大模型 AI 翻译。CopyTranslator 现在可以接入各种符合 OpenAI 格式 API 的翻译服务，带来更智能、更准确的翻译体验。

### 阶跃星辰翻译引擎

[阶跃星辰](https://www.stepfun.com/)（StepFun）是国内领先的大模型服务商，我们已获得官方支持，为用户提供**限时免费的 step-3.5-flash 模型翻译支持**。

**特点：**
- 使用 StepFun 的 step-3.5-flash 大语言模型
- 完全免费，无需配置 API Key
- 开箱即用，选择即可翻译

**使用方法：**
1. 确保您使用的是 v12.0.0 或更高版本
2. 在翻译引擎列表中选择"阶跃星辰"
3. 直接使用，无需任何配置

阶跃星辰作为内置翻译引擎，已默认集成到软件中，**您无需任何配置即可直接使用**。

### 其他 AI 翻译服务

软件提供了多个预定义的供应商模板，支持各种符合 OpenAI 格式 API 的翻译服务：

- **OpenAI**：OpenAI 官方 API 服务
- **DeepSeek（深度求索）**：国产大模型
- **Moonshot AI（月之暗面/Kimi）**：长文本处理能力强
- **智谱 AI（GLM/清言）**：国产大模型
- **阿里云百炼（通义千问）**：阿里云大模型服务
- **Ollama（本地）**：本地部署的大模型
- **Azure OpenAI**：Microsoft Azure 的 OpenAI 服务
- **自定义**：支持任何 OpenAI 格式 API

### AI 翻译供应商设置

**添加 AI 翻译供应商：**

1. 打开设置 → API 设置
2. 找到"**AI 翻译供应商**"或"**自定义翻译器**"选项卡
3. 点击"**添加 AI 供应商**"按钮
4. 从下拉菜单中选择供应商类型（如 OpenAI、DeepSeek 等）
5. 填写必要的配置信息：
   - **供应商名称**：自定义，如"OpenAI 官方账号"
   - **API Base URL**：根据选择的供应商自动填充
   - **API Key**：您的 API 密钥
   - **高级配置**（可选）：
     - 温度（Temperature）：控制创造性，范围 0-1
     - 最大 Token 数
     - 自定义提示词（留空使用默认）
6. 点击"**刷新**"按钮获取可用模型列表
7. 在模型列表中选择要启用的模型（可多选）
8. 点击"**确定**"保存

**管理供应商：**

在"AI 翻译供应商"界面中，您可以：
- **查看**：所有已添加的供应商及其启用的模型数量
- **编辑**：点击"编辑"按钮修改供应商配置
- **删除**：点击"删除"按钮移除不需要的供应商
- **测试**：点击"测试"按钮验证配置是否正确
- **刷新模型**：点击"刷新"重新从 API 获取模型列表

**使用 AI 翻译：**

1. 添加并配置好 AI 翻译供应商后，返回主界面
2. 点击引擎按钮，在下拉列表中找到您添加的供应商
3. 选择具体的模型（格式为"供应商名 - 模型名"）
4. 正常复制文本即可使用 AI 翻译

### 供应商图标

每个预定义的供应商都有对应的图标显示，让您更直观地识别不同的翻译服务。

## 核心功能

### 复制翻译

CopyTranslator 监听到剪贴板变化，会将剪贴板内容进行[净化](#自动净化)（如去除多余换行等），并显示翻译结果，翻译效果相比于直接复制粘贴到网页版翻译有了巨大的改善，同时翻译所需时间也大大减少，借助于强大的在线翻译 API，翻译质量有保证。

![这是一个动图，请耐心等待加载](https://s2.ax1x.com/2019/12/07/QNF4Qf.gif)

::: tip 提示
- 勾选**监听剪贴板**以启用。
- 当关闭**监听剪贴板**时，可以在设置页面打开**双击Ctrl+C**选项，通过**双击Ctrl+C**来触发**CopyTranslator**的翻译功能。
:::

### 拖拽复制

**默认关闭**。在打开**拖拽复制**选项后，只需按住鼠标单击并拖拽选中文字，即可复制文字。

:::tip 说明
其机制为当鼠标拖动一定时间和距离后释放，会模拟一次Ctrl+C，**拖动后的释放很重要，不是按越久越好。**

**拖拽选中=>复制=>翻译**

**v10.2.4后，强烈建议您启用拖拽复制的白名单/黑名单模式（设置->拖拽复制）,仅在特定程序触发拖拽复制。**
:::

![这是一个动图，请耐心等待加载](https://s2.ax1x.com/2019/09/19/nOKkFA.gif)
:::warning 警告
拖拽复制触发时会模拟Ctrl+C，大部分情况下，这都意味着安全的文本复制，但在某些场景中可能会引起一些意料之外的问题，如卡顿，剪贴板数据被覆盖、在shell中触发Ctrl+C会使正在运行的程序中断等等，启用时请务必注意。

:::
::: tip 提示
- 在打开拖拽复制时，可以通过**鼠标双击**来复制。
- 拖拽时按住**Ctrl**则该次复制为[增量复制](#增量复制)。
:::

### 单次增量复制

v11后，右键[布局按钮](#界面示意图)可以标记下一次复制为[增量复制](#增量复制)，即**将下次复制的文本附加到原文而不是替换它**，下次复制结束即恢复原样。当段落在不同页面中分隔时尤其有用。用来解决一句话被页面断成两句，一次复制不全的场景。如下图所示

![这是一个动图，请耐心等待加载](/images/incrementCounter.gif)

#### 增量复制

将新复制的文本附加到原文而不是替换它。

:::tip 提示
- 在**拖拽复制**打开时，拖拽时按住`Ctrl`即可增量复制。
- 可以使用快捷键 win+shift+\` 进行快速增量复制。
:::

### 智能互译

CopyTranslator 会自动识别所复制的文本，根据所设置的**源语言**和**目标语言**进行智能互译。

如果您复制的是**源语言**，会翻译为**目标语言**，复制**目标语言**则会翻译为**源语言**。

如果复制的文字既非**源语言**也不是**目标语言**，则会翻译为**目标语言**。

**智能互译**可以在设置-开关界面关闭。不用担心，**自动复制**不会与此机制相互影响。

### 配置快照

v11 引入一个配置快照机制，拍摄的快照会保存当前时刻的几乎所有配置信息，使得你可以快速在各个应用场景间切换。

举个例子，你在玩游戏时，可能希望 copytranslator 是透明的，鼠标穿透的，标题栏比较矮，然后可能是专注模式，字体颜色是白色的。
然而你在读论文时，可能需要对比模式，夜间模式，不透明，鼠标不穿透，拖拽复制启动的。

**如果你手动进行这样的切换，需要进行很多繁琐、重复性的设置，利用快照机制，你可以快速地在不同应用场景间切换。**
你只需要在调试好玩游戏时候的设置之后，拍摄一个快照，下次要玩游戏时，切换到该快照即可。

::: tip 提示
你可以在设置窗口的**几乎任何地方**通过右键菜单来进行快照管理，此外主窗口的大部分位置的右键菜单都有**拍摄配置快照**以及**切换配置快照**的选项。
:::

![这是一个动图，请耐心等待加载](/images/snapshot.gif)

### 智能词典

单词少于**3**的**英语句子**将被视为短语或单词，您将能够看到更加详细的解释。

![iManhV.png](https://s2.ax1x.com/2019/12/04/Q1CAYQ.png)


## 自动化选项

### 自动复制

在翻译完成后自动复制译文到剪贴板。

### 自动粘贴

**前提：选中自动复制**，自动复制之后模拟**ctrl+v**自动粘贴，替换选中文字。自动粘贴的延迟在设置中调节。

![这是一个动图，请耐心等待加载](/images/autopaste.gif)

### 自动格式化

**注意：此功能与自动复制冲突，会自动反选[自动复制](#自动复制)**，将剪贴板中存在错误空行的原文进行[净化](#自动净化)并更新到剪贴板。


## 外观设置

### 始终置顶

让**CopyTranslator**窗口总是在其他窗口上方，就不会被其他窗口挡住了。

### 切换布局
**可以通过右上角的[布局按钮](#界面示意图)在不同布局间切换**

#### 对照模式（水平布局/垂直布局）

对照模式**以固定比例**同时显示原文和译文以供对照

**v11后，你可以通过拖动分隔线来调节原文与译文的比例。**

![](https://s1.ax1x.com/2020/10/06/0N4Kvq.png)

#### 专注模式

专注模式只提供一个结果窗口，让您更好地关注结果。通常需要配合**监听剪贴板**和[始终置顶](#始终置顶)选项使用。
**v11后，你可以选择在专注模式中也显示原文，但不是固定比例的，在设置->开关中打开`专注模式原文`即可**

![](/images/focus.png)

### 多源对比

在设置->开关可以启用`多源对比`(或者是引擎按钮菜单中选择 copytranslator 图标)，然后你就可以直观地看到不同翻译引擎的结果的对比视图。
**v11后，多源对比引擎可以通过结果框的右键菜单来快速设置。此外还可以通过复制按钮直接复制特定引擎的译文**

![](/images/multisource.png)

### 自动隐藏与显示

#### 自动隐藏

打开**自动隐藏**选项后
- 专注模式窗口贴上边（Y坐标小于0）|贴左边|贴右边 失去焦点后会自动隐藏，可设置，另外可设置翻译后自动显示。所谓失去焦点指的是，原本焦点在专注模式，而后鼠标/键盘点击其他软件，焦点转移这一事件。
- 当专注模式处于贴边收起时可以点击其下边缘，使其获得焦点，专注模式展开。

![这是一个动图，请耐心等待加载](https://s2.ax1x.com/2019/12/07/QN0lLV.gif)

:::tip 提示
- 可以在设置中更改双击隐藏以及自动隐藏的方向。
- 可以选择向上，向左，向右，无，最小化
- 双屏用户务必选择**向上**
:::

#### 自动显示

勾选此选项后，当专注模式处于收起状态，且监听到剪贴板变化，专注模式将自动展开。**展开后想要收起结果框，请先点击一下结果框，后点击其他地方，如果贴边隐藏选项处于打开状态则结果框会收起。**
![这是一个动图，请耐心等待加载](https://s2.ax1x.com/2019/12/07/QN0Qs0.gif)


### 字体与颜色

#### 字体大小/缩放

任意模式均可通过`Ctrl`配合加号或减号进行字体大小的缩放调节。

**V11后，字体大小调节更加完善：原文，译文，词典，多源对比，其字体大小均可调节，并且可以使用ctrl+滚轮进行调节**

#### 字体家族

**v11后，界面的字体，以及正文的字体都可以在`设置->外观`选项卡中设置**

#### 夜间模式

可以在设置界面中选择配色模式**dark**启动**夜间模式**。

如果设置为**auto**则会跟随系统的设置自动切换夜间模式，默认是跟随系统的设置。

#### 颜色设置

**v11后，背景颜色，字体颜色，界面主题颜色都可以在`设置->外观`选项卡中更换**

:::tip 提示
你在明亮模式设置的颜色，只会作用在明亮模式，夜间模式同理。
:::

#### 界面透明度

**v11后，你可以在`设置->外观`选项卡中调节界面的透明度**

#### 鼠标穿透

**v11后，在`设置->外观`选项卡，可以选中此项。选中后，会多出一个用于拖动的按钮，除特定动作按钮外，copytranslator将不再响应鼠标事件，也就是你可以透过copytranslator的界面操作到后面的程序。一般配合透明度调节使用。**

### 标题栏高度

**v11后，在需要时，你可以调节标题栏的高度，把标题栏变小**

### 界面语言

在设置界面中可以**选择界面语言**（当前原生支持：English，简体中文，繁体中文），逐步生效，无需重启。


## 其他

### 聚合引擎

聚合物查词引擎会**使用一些引擎查询，并缓存不同引擎的查询结果，让你在不同引擎切换时更快。**

**v11后，化合物翻译引擎目前默认是没有加速缓存的，但是你可以自行设置。**

::: tip 提示
**通过单击标题栏的引擎按钮可以选择其他引擎。**

- 翻译引擎: Google, Baidu, Caiyun, Tencent, Keyan, Deepl, Bing, Youdao, Sogou, StepFun, OpenAI 等
- 查词引擎: Google, Bing
:::

- **禁用并关闭引擎**：如果有些引擎，经常无法使用，或者是你不是很喜欢，平常用不着，可以到设置->翻译器设置当中的 translator-enabled 里面把它去掉，软件就会禁用并关闭该引擎，能减少一些资源占用。
- **禁用非主引擎缓存**：如果你平常只使用特定引擎，某些引擎只是偶尔使用，不需要频繁切换，可以到设置->翻译器设置当中的 translator-cache 中去掉你不需要加速切换的引擎，这样 copytranslator 就不会在后台请求非主引擎来加速你的切换。举个例子，设置 google 为主引擎时，其实其他引擎默认也会去获取结果，这样你切换就会很快，但是有时候其实你不需要频繁切换。坏处就是他会等到你切换的时候才会请求，你就要等待了，相对慢点。


### 快捷操作

以下操作**无法**通过[自定义局部快捷键](#自定义局部快捷键)修改

- 当光标位于专注模式结果框中时 `Ctrl+Enter` 实现翻译（监听剪贴板时会复制框内文本，当不监听剪贴板时复制框内文本）
- `Ctrl+B` 百度搜索框内内容。
- `Ctrl+G` Google 搜索框内内容。
- `Ctrl+P` 将原文框中文本当做动作执行，详见[动作系统](#动作系统)

以下操作**可以**通过[自定义局部快捷键](#自定义局部快捷键)修改
- `Ctrl+S` 复制译文
- `Ctrl+D` 复制原文
- `ESC` 当 CopyTranslator 有焦点时会隐藏 CopyTranslator（如果你找不到 Copytranslator，可以尝试点击任务栏图标）

### 角标颜色说明

- 红色表示翻译失败
- 绿色表示翻译成功或者处于监听剪贴板状态，紫色表示**增量复制**已启用
- 黄色表示正在翻译
- 灰色表示未启用监听剪贴板

### 自动净化

此功能默认打开（**一般用不着切换**），PDF 翻译时去除多余换行，解决多余的断句和换行带来的乱码问题，翻译结果更符合阅读习惯，极大地提升了翻译效果。

但是对于非 PDF 的翻译结果可能会有一定的影响。

### 自动更新

每次启动，CopyTranslator 会在后台检测更新，如果有新版本会提示，windows 用户可以选择自动下载并更新，Mac 用户可以点击链接前往下载 dmg 后自行更新。


### 停靠桌面

让翻译窗口永远停靠在桌面右侧，**其他窗口自动避让，翻译如行云流水般自然**。灵感来自 `OneNote` 的停靠桌面功能。此功能依赖外部插件，[点击了解更多](https://github.com/Andy-AO/CopytranslatorAppBar)。


### 启用通知

在托盘菜单或设置页面勾选，可以在通知中看到翻译结果（过长的翻译结果无法显示完全）
![这是一个动图，请耐心等待加载](https://s2.ax1x.com/2019/12/07/QNMm8g.gif)

### 操作提示/调试

可以在开关中打开，之后的大部分操作都会有 toast 提示，可用于调试

### 悬浮提示

**v11后，鼠标短暂悬浮在各类按钮，选项，文本框上，你就能看到关于该项的提示信息。**

### OCR 配置（光学字符识别）

#### 在线 OCR

只要你申请百度 OCR API 的 API key 然后将其填入设置->API 设置中的 baidu-ocr 中，设置好后，只要你截图并将图片复制到剪贴板，copytranslator 检测到图片，就会对图片进行 ocr 随后进行翻译。

#### 离线 OCR

由于在线的 ocr 比如百度 OCR 收费比较贵，CopyTranslator 现基于 [PaddleOCR-json](https://github.com/hiroi-sora/PaddleOCR-json/) 提供离线 OCR 功能，此功能目前还处于体验阶段，下面是使用指南。

您需要另外下载 [CopyTranslator-PaddleOCR-json.v1.2.1.7z](https://github.com/CopyTranslator/CopyTranslator/releases/download/v10.1.0/CopyTranslator-PaddleOCR-json.v1.2.1.7z)，并将其解压到一个最好没有中文的路径下，在此例子当中，我解压到 `D:\CopyTranslator-PaddleOCR-json.v1.2.1`，请您确认存在文件 `D:\CopyTranslator-PaddleOCR-json.v1.2.1\PaddleOCR_json.exe`。

然后在 copytranslator 的设置->API 设置界面，你可以看到（如下图），pp-ocr 的选项卡下有两个字段需要设置一个是 cwd，一个是 config_name。
- cwd 就是你解压的路径，在我的例子中，即 `D:\CopyTranslator-PaddleOCR-json.v1.2.1`
- config_name 是配置文件名，不同语言的 OCR 需要不同的配置文件
  - 英文：PaddleOCR_json_config_en.txt
  - 中文：PaddleOCR_json_config_ch.txt
  - 日文：PaddleOCR_json_config_jp.txt
  - 韩语：PaddleOCR_json_config_korean.txt

然后就可以关闭设置，如果没有报错的话，就说明配置成功了。

只要你截图并将图片复制到剪贴板，copytranslator 检测到图片，就会对图片进行 ocr 随后进行翻译。

::: tip 注意
- 如果同时配置了 baidu-ocr 和 pp-ocr，软件只会使用 pp-ocr
- pp-ocr 暂不支持切换语言，你在 API 设置里填的就是你用的 ocr
:::

![image](/images/pp-ocr.png)


## 进阶教程

CopyTranslator 提供了强大的自定义功能，但是需要用户有一定的动手能力。

### 自定义界面语言

由于我无法自己维护所有界面语言文件，因此最新版本的最新的界面语言文件可能不会和 `CopyTranslator` 一同发布（除了 `en` 和 `zh-cn`）。现在，您可以下载本仓库目录 [dist_locales](https://github.com/CopyTranslator/CopyTranslator/tree/master/dist_locales) 下的语言文件 `{locale}.json`，并将其放在[配置目录](/guide/questions.html#copytranslator%E7%9A%84%E9%85%8D%E7%BD%AE%E7%9B%AE%E5%BD%95%E5%9C%A8%E5%93%AA%E9%87%8C)下的 `locales` 文件夹下面，`CopyTranslator` 将在启动时检测它们，然后您可以在设置面板上选择它们。


### 动作系统

CopyTranslator 的核心为动作系统，动作系统统一了界面设置，菜单设置，按钮，快捷键，翻译等等。

**换句话说我们可以将 CopyTranslator 视为交互式命令行程序，通过命令来执行特定操作。**

::: tip 提示
可以直接在**原文框中**输入动作，并按 `Ctrl+P` 执行该动作。

例：在原文框输入 `exit` 并按 `Ctrl+P` 即可退出程序。

:::

**注意，不同版本间同一个动作的标识符可能会变化。**

动作可分为两种
- 无参动作
- 带参动作

以下会列出所有可用动作的标识符，大部分都是字面意思，另外也可以查阅[中文翻译](https://github.com/CopyTranslator/CopyTranslator/blob/master/dist_locales/zh-CN.json)

#### 无参动作

一个 `无参动作` 由以下部分组成：
```
标识符
```
:::tip
实例：执行 `copyResult` 动作即可复制译文

:::
以下是目前所有无参动作的标识符。
```json
//以下是做一个特定的事的动作
export const normalActionTypes = [
  "doubleCopyTranslate", //双击ctrl c 触发
  "translate", //翻译
  "selectionQuery", //翻译
  "copySource", //复制原文
  "copyResult", //复制译文
  "pasteResult", //粘贴译文
  "clear", //清空
  "helpAndUpdate",
  "exit",
  "viewSource",
  "return",
  "retryTranslate",
  "evaluate",
  "homepage",
  "userManual",
  "checkUpdate",
  "toDownload",
  "changelog",
  "cancel",
  "ok",
  "restoreDefault",
  "capture",
  "font+",
  "font-",
  "drawer",
  "editConfigFile",
  "showConfigFolder",
  "hideWindow",
  "closeWindow",
  "showWindow",
  "translateClipboard",
  "notify",
  "toast",
] as const;

//切换值的动作
export const switchActionTypes = [
  "skipTaskbar",
  "stayTop",
  "listenClipboard",
  "autoCopy",
  "autoPaste",
  "autoPurify",
  "neverShow",
  "smartDict",
  "autoHide",
  "autoFormat",
  "autoShow",
  "incrementalCopy",
  "enableNotify",
  "smartTranslate",
  "smartDict",
  "dragCopy",
  "closeAsQuit",
  "contrastDict",
  "openAtLogin",
] as const;

//Electron 原生 角色
export const roles = [
  "undo",
  "redo",
  "cut",
  "copy",
  "paste",
  "pasteAndMatchStyle",
  "selectAll",
  "delete",
  "minimize",
  "close",
  "quit",
  "reload",
  "forceReload",
  "toggleDevTools",
  "togglefullscreen",
  "resetZoom",
  "zoomIn",
  "zoomOut",
  "editMenu",
  "windowMenu",
] as const;

```

#### 带参动作

一个 `带参动作` 由以下部分组成：
```
标识符|值
```
:::tip 提示
实例：执行 `translatorType|google` 动作会将翻译引擎设置为 google
:::
下面为可用的带参动作的标识符
```json
//设置常量为某一个值
export const constantActionTypes = [
  "source",
  "result",
  "localeName",
  "sourceLanguage",
  "targetLanguage",
  "localeSetting",
  "hideDirect",
  "translatorType",
  "dictionaryType",
  "layoutType",
  "frameMode",
  "autoCheckUpdate",
  "colorMode",
  "version",
] as const;
```


### 定制动作按钮

你可以在设置->动作按钮界面自定义动作按钮


### 自定义全局快捷键

对于大多数[动作](#动作系统)，您可以通过修改[配置目录](/guide/questions.html#copytranslator%E7%9A%84%E9%85%8D%E7%BD%AE%E7%9B%AE%E5%BD%95%E5%9C%A8%E5%93%AA%E9%87%8C)的 `shortcuts.json` 来绑定全局快捷键。

::: warning 警告
当快捷键已被其他应用程序占用时，绑定将失败。
:::

每条记录的形式为：`action:accelerator`。

以下为一个例子

```json
{
  "listenClipboard": "CommandOrControl+J",
  "translatorType|google": "CommandOrControl+T"
}
```

它将切换监听剪贴板的动作绑定到快捷键 `CommandOrControl+J`。并将切换为 Google 翻译器的操作绑定到快捷键 `CommandOrControl+T`。

对于所有可用操作，请参看 [动作](#动作系统)。

所有可用的快捷键，请查看 [Electron Accelerator](https://electronjs.org/docs/api/accelerator)。

### 自定义局部快捷键

与全局快捷键不同，局部快捷键不会与其他应用冲突，但是只能在焦点在 copytranslator 时使用

对于大多数[动作](#动作系统)，您可以通过修改[配置目录](/guide/questions.html#copytranslator%E7%9A%84%E9%85%8D%E7%BD%AE%E7%9B%AE%E5%BD%95%E5%9C%A8%E5%93%AA%E9%87%8C)的 `localShortcuts.json` 来绑定全局快捷键。

每条记录的形式为：`action:accelerator`。

以下为默认局部快捷键

```json
{
    "undo": "CmdOrCtrl+Z",
    "redo": "Shift+CmdOrCtrl+Z",
    "cut": "CmdOrCtrl+X",
    "copy": "CmdOrCtrl+C",
    "paste": "CmdOrCtrl+V",
    "selectAll": "CmdOrCtrl+A",
    "copyResult": "CmdOrCtrl+S",
    "copySource": "CmdOrCtrl+D",
    "quit": "Cmd+Q",
    "font+": "CmdOrCtrl+=",
    "font-": "CmdOrCtrl+-",
    "hideWindow": "Escape"
}
```

以 `"copyResult": "CmdOrCtrl+S"` 为例，它将复制译文的动作绑定到快捷键 `CmdOrCtrl+S`，也就是说如果你的焦点在 copytranslator 时，按下 `ctrl+s` 即可复制译文。

对于所有可用操作，请参看 [动作](#动作系统)。

所有可用的快捷键，请查看 [Electron Accelerator](https://electronjs.org/docs/api/accelerator)。
