// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.

// This file was generated by NvParameterized/scripts/GenParameterized.pl


#include "DestructibleAssetParameters_0p3.h"
#include <string.h>
#include <stdlib.h>

using namespace NvParameterized;

namespace nvidia
{
namespace parameterized
{

using namespace DestructibleAssetParameters_0p3NS;

const char* const DestructibleAssetParameters_0p3Factory::vptr =
    NvParameterized::getVptr<DestructibleAssetParameters_0p3, DestructibleAssetParameters_0p3::ClassAlignment>();

const uint32_t NumParamDefs = 78;
static NvParameterized::DefinitionImpl* ParamDefTable; // now allocated in buildTree [NumParamDefs];


static const size_t ParamLookupChildrenTable[] =
{
	1, 2, 3, 4, 14, 16, 49, 59, 60, 61, 62, 64, 65, 66, 68, 69, 71, 73, 74, 75, 76, 77,
	5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 41, 42, 43, 35, 36, 37, 38, 39, 40, 44, 45, 46, 47, 48, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 63, 67, 70, 72,
};

#define TENUM(type) nvidia::##type
#define CHILDREN(index) &ParamLookupChildrenTable[index]
static const NvParameterized::ParamLookupNode ParamLookupTable[NumParamDefs] =
{
	{ TYPE_STRUCT, false, 0, CHILDREN(0), 22 },
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->depthCount), NULL, 0 }, // depthCount
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->originalDepthCount), NULL, 0 }, // originalDepthCount
	{ TYPE_BOUNDS3, false, (size_t)(&((ParametersStruct*)0)->bounds), NULL, 0 }, // bounds
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunks), CHILDREN(22), 1 }, // chunks
	{ TYPE_STRUCT, false, 1 * sizeof(Chunk_Type), CHILDREN(23), 8 }, // chunks[]
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->depth), NULL, 0 }, // chunks[].depth
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->parentIndex), NULL, 0 }, // chunks[].parentIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->firstChildIndex), NULL, 0 }, // chunks[].firstChildIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->numChildren), NULL, 0 }, // chunks[].numChildren
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->meshPartIndex), NULL, 0 }, // chunks[].meshPartIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->flags), NULL, 0 }, // chunks[].flags
	{ TYPE_BOUNDS3, false, (size_t)(&((Chunk_Type*)0)->bounds), NULL, 0 }, // chunks[].bounds
	{ TYPE_VEC3, false, (size_t)(&((Chunk_Type*)0)->surfaceNormal), NULL, 0 }, // chunks[].surfaceNormal
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunkConvexHulls), CHILDREN(31), 1 }, // chunkConvexHulls
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // chunkConvexHulls[]
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->destructibleParameters), CHILDREN(32), 21 }, // destructibleParameters
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageThreshold), NULL, 0 }, // destructibleParameters.damageThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageToRadius), NULL, 0 }, // destructibleParameters.damageToRadius
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageCap), NULL, 0 }, // destructibleParameters.damageCap
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->forceToDamage), NULL, 0 }, // destructibleParameters.forceToDamage
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactVelocityThreshold), NULL, 0 }, // destructibleParameters.impactVelocityThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->materialStrength), NULL, 0 }, // destructibleParameters.materialStrength
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageToPercentDeformation), NULL, 0 }, // destructibleParameters.damageToPercentDeformation
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->deformationPercentLimit), NULL, 0 }, // destructibleParameters.deformationPercentLimit
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->minimumFractureDepth), NULL, 0 }, // destructibleParameters.minimumFractureDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDepth), NULL, 0 }, // destructibleParameters.debrisDepth
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->essentialDepth), NULL, 0 }, // destructibleParameters.essentialDepth
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMin), NULL, 0 }, // destructibleParameters.debrisLifetimeMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMax), NULL, 0 }, // destructibleParameters.debrisLifetimeMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMin), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMax), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMax
	{ TYPE_BOUNDS3, false, (size_t)(&((DestructibleParameters_Type*)0)->validBounds), NULL, 0 }, // destructibleParameters.validBounds
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->maxChunkSpeed), NULL, 0 }, // destructibleParameters.maxChunkSpeed
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->flags), CHILDREN(53), 6 }, // destructibleParameters.flags
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCUMULATE_DAMAGE), NULL, 0 }, // destructibleParameters.flags.ACCUMULATE_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_TIMEOUT), NULL, 0 }, // destructibleParameters.flags.DEBRIS_TIMEOUT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_MAX_SEPARATION), NULL, 0 }, // destructibleParameters.flags.DEBRIS_MAX_SEPARATION
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_SMALLEST_CHUNKS), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCURATE_RAYCASTS), NULL, 0 }, // destructibleParameters.flags.ACCURATE_RAYCASTS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->USE_VALID_BOUNDS), NULL, 0 }, // destructibleParameters.flags.USE_VALID_BOUNDS
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->fractureImpulseScale), NULL, 0 }, // destructibleParameters.fractureImpulseScale
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunkDominanceGroup), NULL, 0 }, // destructibleParameters.dynamicChunkDominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunksGroupsMask), CHILDREN(59), 5 }, // destructibleParameters.dynamicChunksGroupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits3
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->depthParameters), CHILDREN(64), 1 }, // depthParameters
	{ TYPE_STRUCT, false, 1 * sizeof(DestructibleDepthParameters_Type), CHILDREN(65), 8 }, // depthParameters[]
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->TAKE_IMPACT_DAMAGE), NULL, 0 }, // depthParameters[].TAKE_IMPACT_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_POSE_UPDATES), NULL, 0 }, // depthParameters[].IGNORE_POSE_UPDATES
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_RAYCAST_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_RAYCAST_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_CONTACT_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_CONTACT_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_0), NULL, 0 }, // depthParameters[].USER_FLAG_0
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_1), NULL, 0 }, // depthParameters[].USER_FLAG_1
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_2), NULL, 0 }, // depthParameters[].USER_FLAG_2
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_3), NULL, 0 }, // depthParameters[].USER_FLAG_3
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->crumbleEmitterName), NULL, 0 }, // crumbleEmitterName
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->dustEmitterName), NULL, 0 }, // dustEmitterName
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->collisionData), NULL, 0 }, // collisionData
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->surfaceTraceSets), CHILDREN(73), 1 }, // surfaceTraceSets
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // surfaceTraceSets[]
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->renderMeshAsset), NULL, 0 }, // renderMeshAsset
	{ TYPE_I32, false, (size_t)(&((ParametersStruct*)0)->interiorSubmeshIndex), NULL, 0 }, // interiorSubmeshIndex
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->staticMaterialNames), CHILDREN(74), 1 }, // staticMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // staticMaterialNames[]
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->neighborPadding), NULL, 0 }, // neighborPadding
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overlapsAtDepth), CHILDREN(75), 1 }, // overlapsAtDepth
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // overlapsAtDepth[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->firstChunkAtDepth), CHILDREN(76), 1 }, // firstChunkAtDepth
	{ TYPE_U32, false, 1 * sizeof(uint32_t), NULL, 0 }, // firstChunkAtDepth[]
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->supportDepth), NULL, 0 }, // supportDepth
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->formExtendedStructures), NULL, 0 }, // formExtendedStructures
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useAssetDefinedSupport), NULL, 0 }, // useAssetDefinedSupport
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useWorldSupport), NULL, 0 }, // useWorldSupport
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->massScaleExponent), NULL, 0 }, // massScaleExponent
};


bool DestructibleAssetParameters_0p3::mBuiltFlag = false;
NvParameterized::MutexType DestructibleAssetParameters_0p3::mBuiltFlagMutex;

DestructibleAssetParameters_0p3::DestructibleAssetParameters_0p3(NvParameterized::Traits* traits, void* buf, int32_t* refCount) :
	NvParameters(traits, buf, refCount)
{
	//mParameterizedTraits->registerFactory(className(), &DestructibleAssetParameters_0p3FactoryInst);

	if (!buf) //Do not init data if it is inplace-deserialized
	{
		initDynamicArrays();
		initStrings();
		initReferences();
		initDefaults();
	}
}

DestructibleAssetParameters_0p3::~DestructibleAssetParameters_0p3()
{
	freeStrings();
	freeReferences();
	freeDynamicArrays();
}

void DestructibleAssetParameters_0p3::destroy()
{
	// We cache these fields here to avoid overwrite in destructor
	bool doDeallocateSelf = mDoDeallocateSelf;
	NvParameterized::Traits* traits = mParameterizedTraits;
	int32_t* refCount = mRefCount;
	void* buf = mBuffer;

	this->~DestructibleAssetParameters_0p3();

	NvParameters::destroy(this, traits, doDeallocateSelf, refCount, buf);
}

const NvParameterized::DefinitionImpl* DestructibleAssetParameters_0p3::getParameterDefinitionTree(void)
{
	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

const NvParameterized::DefinitionImpl* DestructibleAssetParameters_0p3::getParameterDefinitionTree(void) const
{
	DestructibleAssetParameters_0p3* tmpParam = const_cast<DestructibleAssetParameters_0p3*>(this);

	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			tmpParam->buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

NvParameterized::ErrorType DestructibleAssetParameters_0p3::getParameterHandle(const char* long_name, Handle& handle) const
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

NvParameterized::ErrorType DestructibleAssetParameters_0p3::getParameterHandle(const char* long_name, Handle& handle)
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

void DestructibleAssetParameters_0p3::getVarPtr(const Handle& handle, void*& ptr, size_t& offset) const
{
	ptr = getVarPtrHelper(&ParamLookupTable[0], const_cast<DestructibleAssetParameters_0p3::ParametersStruct*>(&parameters()), handle, offset);
}


/* Dynamic Handle Indices */
/* [0] - chunkConvexHulls (not an array of structs) */
/* [0] - surfaceTraceSets (not an array of structs) */
/* [0] - staticMaterialNames (not an array of structs) */
/* [0] - overlapsAtDepth (not an array of structs) */

void DestructibleAssetParameters_0p3::freeParameterDefinitionTable(NvParameterized::Traits* traits)
{
	if (!traits)
	{
		return;
	}

	if (!mBuiltFlag) // Double-checked lock
	{
		return;
	}

	NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);

	if (!mBuiltFlag)
	{
		return;
	}

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		ParamDefTable[i].~DefinitionImpl();
	}

	traits->free(ParamDefTable);

	mBuiltFlag = false;
}

#define PDEF_PTR(index) (&ParamDefTable[index])

void DestructibleAssetParameters_0p3::buildTree(void)
{

	uint32_t allocSize = sizeof(NvParameterized::DefinitionImpl) * NumParamDefs;
	ParamDefTable = (NvParameterized::DefinitionImpl*)(mParameterizedTraits->alloc(allocSize));
	memset(ParamDefTable, 0, allocSize);

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		NV_PARAM_PLACEMENT_NEW(ParamDefTable + i, NvParameterized::DefinitionImpl)(*mParameterizedTraits);
	}

	// Initialize DefinitionImpl node: nodeIndex=0, longName=""
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[0];
		ParamDef->init("", TYPE_STRUCT, "STRUCT", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=1, longName="depthCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[1];
		ParamDef->init("depthCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The number of chunk depth levels.  This is 1 for an unfractured mesh.", true);
		HintTable[1].init("shortDescription", "The number of chunk depth levels", true);
		ParamDefTable[1].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=2, longName="originalDepthCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[2];
		ParamDef->init("originalDepthCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The depth count when authored - this way we can tell how far it's been reduced.", true);
		HintTable[1].init("shortDescription", "The depth count when authored", true);
		ParamDefTable[2].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=3, longName="bounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[3];
		ParamDef->init("bounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The axis-aligned bounding box of the destructible asset.  This is the smallest AABB\n					which contains all chunk AABBs.", true);
		HintTable[1].init("shortDescription", "The AABB of the destructible asset", true);
		ParamDefTable[3].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=4, longName="chunks"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[4];
		ParamDef->init("chunks", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of chunks.  Chunks are stored breadth-first in their hierarchy.", true);
		HintTable[1].init("shortDescription", "The array of chunks", true);
		ParamDefTable[4].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=5, longName="chunks[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[5];
		ParamDef->init("chunks", TYPE_STRUCT, "Chunk", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of chunks.  Chunks are stored breadth-first in their hierarchy.", true);
		HintTable[1].init("shortDescription", "The array of chunks", true);
		ParamDefTable[5].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=6, longName="chunks[].depth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[6];
		ParamDef->init("depth", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The depth of the chunk in the hierarchy.\n							Level 0 chunks correspond to the unfractured (original) mesh.  Level 1 chunks\n							are their children, formed by splitting level 0 chunks, etc.", true);
		HintTable[1].init("shortDescription", "The depth of the chunk in the hierarchy", true);
		ParamDefTable[6].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=7, longName="chunks[].parentIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[7];
		ParamDef->init("parentIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The index of the chunk's parent in the hierarchy.\n							If the chunk has no parent (its depth is 0), then the parentIndex is -1.", true);
		HintTable[1].init("shortDescription", "The index of the chunk's parent in the hierarchy", true);
		ParamDefTable[7].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=8, longName="chunks[].firstChildIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[8];
		ParamDef->init("firstChildIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The index of this chunk's first child in the hierarchy.\n							All children have contiguous chunk indices, and lie in the range\n							[firstChildIndex,firstChildIndex+numChildren-1].  If the chunk has no children,\n							this value is undefined.", true);
		HintTable[1].init("shortDescription", "The index of this chunk's first child in the hierarchy", true);
		ParamDefTable[8].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=9, longName="chunks[].numChildren"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[9];
		ParamDef->init("numChildren", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "This chunk's number of children.  If not 0, firstChildIndex\n							is valid (see firstChildIndex).", true);
		HintTable[1].init("shortDescription", "This chunk's number of children", true);
		ParamDefTable[9].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=10, longName="chunks[].meshPartIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[10];
		ParamDef->init("meshPartIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The corresponding mesh part for this chunk, in the NxApexRenderMeshAsset\n							included withing this destructible asset.", true);
		HintTable[1].init("shortDescription", "The corresponding mesh part for this chunk", true);
		ParamDefTable[10].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=11, longName="chunks[].flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[11];
		ParamDef->init("flags", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Flags which define individual chunk attributes, such as support,\n							fractureability, etc.", true);
		HintTable[2].init("shortDescription", "Flags which define individual chunk attributes", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=12, longName="chunks[].bounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[12];
		ParamDef->init("bounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The axis-aligned bounding box of this chunk.", true);
		HintTable[1].init("shortDescription", "The AABB of this chunk", true);
		ParamDefTable[12].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=13, longName="chunks[].surfaceNormal"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[13];
		ParamDef->init("surfaceNormal", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The average surface normal of this chunk.  This is the normalized\n							average of all triangle normals which are part of the original (unfractured) mesh.", true);
		HintTable[1].init("shortDescription", "The average surface normal of this chunk", true);
		ParamDefTable[13].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=14, longName="chunkConvexHulls"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[14];
		ParamDef->init("chunkConvexHulls", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Convex hull data for each chunk.  This is not cooked convex hull data\n					used for PhysX collision.  These hulls are used to (a) create cooked PhysX convex hulls, and (b)\n					for APEX scene queries.", true);
		HintTable[2].init("shortDescription", "Convex hull data for each chunk", true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "ConvexHullParameters" };
		ParamDefTable[14].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=15, longName="chunkConvexHulls[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[15];
		ParamDef->init("chunkConvexHulls", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Convex hull data for each chunk.  This is not cooked convex hull data\n					used for PhysX collision.  These hulls are used to (a) create cooked PhysX convex hulls, and (b)\n					for APEX scene queries.", true);
		HintTable[2].init("shortDescription", "Convex hull data for each chunk", true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "ConvexHullParameters" };
		ParamDefTable[15].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=16, longName="destructibleParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[16];
		ParamDef->init("destructibleParameters", TYPE_STRUCT, "DestructibleParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible properties for this asset.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible properties for this asset", true);
		ParamDefTable[16].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=17, longName="destructibleParameters.damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[17];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\nThis is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\nor NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).\n", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[17].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=18, longName="destructibleParameters.damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[18];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\nis multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\nwill have damage applied to them.  The damage applied to each chunk varies with distance to the damage\napplication position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[18].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=19, longName="destructibleParameters.damageCap"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[19];
		ParamDef->init("damageCap", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Limits the amount of damage applied to a chunk.  This is useful for preventing the entire destructible\nfrom getting pulverized by a very large application of damage.  This can easily happen when impact damage is\nused, and the damage amount is proportional to the impact force (see forceToDamage).\n", true);
		HintTable[1].init("shortDescription", "Limits the amount of damage applied to a chunk.", true);
		ParamDefTable[19].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=20, longName="destructibleParameters.forceToDamage"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[20];
		ParamDef->init("forceToDamage", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk is at a depth which has NX_DESTRUCTIBLE_TAKE_IMPACT_DAMAGE set (see NxDestructibleDepthParameters),\nthen when a chunk has a collision in the NxScene, it will take damage equal to forceToDamage mulitplied by\nthe impact force.\nThe default value is zero, which effectively disables impact damage.\n", true);
		HintTable[1].init("shortDescription", "If a chunk is at a depth which has NX_DESTRUCTIBLE_TAKE_IMPACT_DAMAGE set", true);
		ParamDefTable[20].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=21, longName="destructibleParameters.impactVelocityThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[21];
		ParamDef->init("impactVelocityThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.  In this case the realative velocity of the two\nobjects will be low.  This variable allows the user to set a minimum velocity threshold for impacts to ensure that the objects are\nmoving at a min velocity in order for the impact force to be considered.\n", true);
		HintTable[1].init("shortDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.", true);
		ParamDefTable[21].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=22, longName="destructibleParameters.materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[22];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see NxDestructibleDepthParametersFlag::TAKE_IMPACT_DAMAGE), this parameter\nis the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\nheavier objects will pass through them during fracture.\nN.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\nDefault value = 0.0f.\n", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[22].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=23, longName="destructibleParameters.damageToPercentDeformation"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[23];
		ParamDef->init("damageToPercentDeformation", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Damage applied to chunks may deform (move) a chunk without fracturing it, if damageToPercentDeformation is\npositive.  The damage applied to the chunk is multiplied by damageToPercentDeformation, and the resulting\n'percent deformation' is used to translate and rotate the chunk.  The translation is the 'percent deformation'\ntimes the size of the chunk, in the direction given by the 'direction' paramater in applyDamage\n(see NxDestructibleActor).  For radius damage, the direction is always radial from the impact position.\nThe rotation appplied is the 'percent deformation' times one radian.\nThe default value is zero, which disables deformation.\n", true);
		HintTable[1].init("shortDescription", "Damage applied to chunks may deform (move) a chunk without fracturing it", true);
		ParamDefTable[23].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=24, longName="destructibleParameters.deformationPercentLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[24];
		ParamDef->init("deformationPercentLimit", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk\'s percent deformation (see damageToPercentDeformation) exceeds deformationPercentLimit in\neither translation or rotation, then the chunk will fracture.\n", true);
		HintTable[1].init("shortDescription", "If a chunk's percent deformation (see damageToPercentDeformation) exceeds deformationPercentLimit in either translation or rotation, then the chunk will fracture.", true);
		ParamDefTable[24].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=25, longName="destructibleParameters.minimumFractureDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[25];
		ParamDef->init("minimumFractureDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks will not be broken free below this depth.\n", true);
		HintTable[1].init("shortDescription", "The chunks will not be broken free below this depth.", true);
		ParamDefTable[25].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=26, longName="destructibleParameters.debrisDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[26];
		ParamDef->init("debrisDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'  Chunks at this depth or\nbelow will be considered for various debris settings, such as debrisLifetime.\nNegative values indicate that no chunk depth is considered debris.\nDefault value is -1.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'", true);
		ParamDefTable[26].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=27, longName="destructibleParameters.essentialDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[27];
		ParamDef->init("essentialDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth up to which chunks will always be processed.  These chunks are considered\nto be essential either for gameplay or visually.\nThe minimum value is 0, meaning the level 0 chunk is always considered essential.\nDefault value is 0.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth up to which chunks will always be processed", true);
		ParamDefTable[27].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=28, longName="destructibleParameters.debrisLifetimeMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[28];
		ParamDef->init("debrisLifetimeMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum time to destroy debris", true);
		ParamDefTable[28].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=29, longName="destructibleParameters.debrisLifetimeMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[29];
		ParamDef->init("debrisLifetimeMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Maximum time to destroy debris", true);
		ParamDefTable[29].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=30, longName="destructibleParameters.debrisMaxSeparationMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[30];
		ParamDef->init("debrisMaxSeparationMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[30].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=31, longName="destructibleParameters.debrisMaxSeparationMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[31];
		ParamDef->init("debrisMaxSeparationMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[31].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=32, longName="destructibleParameters.validBounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[32];
		ParamDef->init("validBounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation multiplied by the original\ndestructible asset size.  The actual maxSeparation is interpolated between these\ntwo values, based upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "valid bounding region for debris", true);
		ParamDefTable[32].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=33, longName="destructibleParameters.maxChunkSpeed"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[33];
		ParamDef->init("maxChunkSpeed", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If greater than 0, the chunks' speeds will not be allowed to exceed this value.  Use 0\nto disable this feature (this is the default).\n", true);
		HintTable[1].init("shortDescription", "Maximum speed of a chunk", true);
		ParamDefTable[33].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=34, longName="destructibleParameters.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[34];
		ParamDef->init("flags", TYPE_STRUCT, "DestructibleParametersFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A collection of flags defined in NxDestructibleParametersFlag.\n", true);
		HintTable[1].init("shortDescription", "A collection of flags defined in DestructibleParametersFlag.", true);
		ParamDefTable[34].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=35, longName="destructibleParameters.flags.ACCUMULATE_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[35];
		ParamDef->init("ACCUMULATE_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, chunks will 'remember' damage applied to them, so that many applications of a damage amount\nbelow damageThreshold will eventually fracture the chunk.  If not set, a single application of\ndamage must exceed damageThreshold in order to fracture the chunk.\n", true);
		HintTable[1].init("shortDescription", "Determines if chunks accumulate damage", true);
		ParamDefTable[35].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=36, longName="destructibleParameters.flags.DEBRIS_TIMEOUT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[36];
		ParamDef->init("DEBRIS_TIMEOUT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill time out.  The lifetime is a value between NxDestructibleParameters::debrisLifetimeMin and\nNxDestructibleParameters::debrisLifetimeMax, based upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will timeout", true);
		ParamDefTable[36].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=37, longName="destructibleParameters.flags.DEBRIS_MAX_SEPARATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[37];
		ParamDef->init("DEBRIS_MAX_SEPARATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill be removed if they separate too far from their origins.  The maxSeparation is a value between\nNxDestructibleParameters::debrisMaxSeparationMin and NxDestructibleParameters::debrisMaxSeparationMax,\nbased upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will be removed if separated too far", true);
		ParamDefTable[37].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=38, longName="destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[38];
		ParamDef->init("CRUMBLE_SMALLEST_CHUNKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the smallest chunks may be further broken down, either by fluid crumbles (if a crumble particle\nsystem is specified in the NxDestructibleActorDesc), or by simply removing the chunk if no crumble\nparticle system is specified.  Note: the 'smallest chunks' are normally defined to be the deepest level\nof the fracture hierarchy.  However, they may be taken from higher levels of the hierarchy if\nNxModuleDestructible::setMaxChunkDepthOffset is called with a non-zero value.\n", true);
		HintTable[1].init("shortDescription", "If set, the smallest chunks may be further broken down", true);
		ParamDefTable[38].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=39, longName="destructibleParameters.flags.ACCURATE_RAYCASTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[39];
		ParamDef->init("ACCURATE_RAYCASTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit\nfor collisions with child chunks.  This is used to get a better raycast position and normal, in\ncase the parent collision volume does not tightly fit the graphics mesh.  The returned chunk index\nwill always be that of the visible parent that is intersected, however.\n", true);
		HintTable[1].init("shortDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit", true);
		ParamDefTable[39].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=40, longName="destructibleParameters.flags.USE_VALID_BOUNDS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[40];
		ParamDef->init("USE_VALID_BOUNDS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the validBounds field of NxDestructibleParameters will be used.  These bounds are translated\n(but not scaled or rotated) to the origin of the destructible actor.  If a chunk or chunk island moves\noutside of those bounds, it is destroyed.\n", true);
		HintTable[1].init("shortDescription", "If set, the validBounds field of NxDestructibleParameters will be used.", true);
		ParamDefTable[40].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=41, longName="destructibleParameters.fractureImpulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[41];
		ParamDef->init("fractureImpulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.  This is used\nin order to 'push' the pieces out as they fracture.\n", true);
		HintTable[1].init("shortDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.", true);
		ParamDefTable[41].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=42, longName="destructibleParameters.dynamicChunkDominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[42];
		ParamDef->init("dynamicChunkDominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional dominance group for dynamic chunks created when fractured. (ignored if > 31)\n", true);
		HintTable[1].init("shortDescription", "Optional dominance group for dynamic chunks created when fractured.", true);
		ParamDefTable[42].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=43, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[43];
		ParamDef->init("dynamicChunksGroupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.\n", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		ParamDefTable[43].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=44, longName="destructibleParameters.dynamicChunksGroupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[44];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[44].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=45, longName="destructibleParameters.dynamicChunksGroupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[45];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=46, longName="destructibleParameters.dynamicChunksGroupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[46];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=47, longName="destructibleParameters.dynamicChunksGroupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[47];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=48, longName="destructibleParameters.dynamicChunksGroupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[48];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[48].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=49, longName="depthParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[49];
		ParamDef->init("depthParameters", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible depth parameters for this asset.  These\n					are properties that apply to all chunks at a particular level of the hierarchy.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible depth parameters for this asset", true);
		ParamDefTable[49].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=50, longName="depthParameters[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[50];
		ParamDef->init("depthParameters", TYPE_STRUCT, "DestructibleDepthParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible depth parameters for this asset.  These\n					are properties that apply to all chunks at a particular level of the hierarchy.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible depth parameters for this asset", true);
		ParamDefTable[50].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=51, longName="depthParameters[].TAKE_IMPACT_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[51];
		ParamDef->init("TAKE_IMPACT_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this hierarchy depth level may take impact damage if this flag is set.\nNote, NxDestructibleParameters::forceToDamage must also be positive for this\nto take effect.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this hierarchy depth level may take impact damage if this flag is set.", true);
		ParamDefTable[51].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=52, longName="depthParameters[].IGNORE_POSE_UPDATES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[52];
		ParamDef->init("IGNORE_POSE_UPDATES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should have pose updates ignored.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should have pose updates ignored.", true);
		ParamDefTable[52].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=53, longName="depthParameters[].IGNORE_RAYCAST_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[53];
		ParamDef->init("IGNORE_RAYCAST_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in raycast callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in raycast callbacks.", true);
		ParamDefTable[53].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=54, longName="depthParameters[].IGNORE_CONTACT_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[54];
		ParamDef->init("IGNORE_CONTACT_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in contact callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in contact callbacks.", true);
		ParamDefTable[54].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=55, longName="depthParameters[].USER_FLAG_0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[55];
		ParamDef->init("USER_FLAG_0", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[55].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=56, longName="depthParameters[].USER_FLAG_1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[56];
		ParamDef->init("USER_FLAG_1", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[56].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=57, longName="depthParameters[].USER_FLAG_2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[57];
		ParamDef->init("USER_FLAG_2", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[57].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=58, longName="depthParameters[].USER_FLAG_3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[58];
		ParamDef->init("USER_FLAG_3", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[58].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=59, longName="crumbleEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[59];
		ParamDef->init("crumbleEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the crumble emitter to use when crumbling\n					the smallest chunks.", true);
		HintTable[1].init("shortDescription", "The name of the crumble emitter to use", true);
		ParamDefTable[59].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=60, longName="dustEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[60];
		ParamDef->init("dustEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the dust emitter to use.  If defined, dust particles\n					will be spawned above the chunk surface traces when a chunk is fractured.", true);
		HintTable[1].init("shortDescription", "The name of the dust emitter to use", true);
		ParamDefTable[60].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=61, longName="collisionData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[61];
		ParamDef->init("collisionData", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[61].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The cooked convex data for PhysX collision.  All cooked convex hulls for a set of\n					scales may be included", true);
		HintTable[2].init("shortDescription", "The cooked convex data for PhysX collision", true);
		ParamDefTable[61].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "DestructibleAssetCollisionDataSet" };
		ParamDefTable[61].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=62, longName="surfaceTraceSets"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[62];
		ParamDef->init("surfaceTraceSets", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[62].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Traces along the surface boundaries of chunks.  Used\n					if the dustEmitterName is defined.", true);
		HintTable[2].init("shortDescription", "Traces along the surface boundaries of chunks", true);
		ParamDefTable[62].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "SurfaceTraceSetParameters" };
		ParamDefTable[62].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=63, longName="surfaceTraceSets[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[63];
		ParamDef->init("surfaceTraceSets", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[63].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Traces along the surface boundaries of chunks.  Used\n					if the dustEmitterName is defined.", true);
		HintTable[2].init("shortDescription", "Traces along the surface boundaries of chunks", true);
		ParamDefTable[63].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "SurfaceTraceSetParameters" };
		ParamDefTable[63].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=64, longName="renderMeshAsset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[64];
		ParamDef->init("renderMeshAsset", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[64].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The included render mesh asset.  This asset defines the\n					graphical representation of all chunks.", true);
		HintTable[2].init("shortDescription", "The included render mesh asset", true);
		ParamDefTable[64].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "RenderMeshAssetParameters" };
		ParamDefTable[64].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=65, longName="interiorSubmeshIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[65];
		ParamDef->init("interiorSubmeshIndex", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The index of the interior submesh.  When fractured, the new (interior) triangles are put into\n					their own submesh.  This is its index.  If there is no interior submesh, this index is -1.", true);
		HintTable[1].init("shortDescription", "The index of the interior submesh", true);
		ParamDefTable[65].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=66, longName="staticMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[66];
		ParamDef->init("staticMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Alternative material names for the static render mesh, if it's created.", true);
		HintTable[1].init("shortDescription", "Alternative material names for the static render mesh, if it's created", true);
		ParamDefTable[66].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=67, longName="staticMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[67];
		ParamDef->init("staticMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Alternative material names for the static render mesh, if it's created.", true);
		HintTable[1].init("shortDescription", "Alternative material names for the static render mesh, if it's created", true);
		ParamDefTable[67].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=68, longName="neighborPadding"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[68];
		ParamDef->init("neighborPadding", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Padding used for chunk neighbor tests.  This padding is relative to the largest diagonal\n					of the asset's local bounding box.\n					This value must be non-negative.\n					Default value = 0.001f.", true);
		HintTable[1].init("shortDescription", "Padding used for chunk neighbor tests.", true);
		ParamDefTable[68].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=69, longName="overlapsAtDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[69];
		ParamDef->init("overlapsAtDepth", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[69].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The chunk overlaps (adjacencies) at each depth of the hierarchy.", true);
		HintTable[2].init("shortDescription", "The chunk overlaps at each depth of the hierarchy", true);
		ParamDefTable[69].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "CachedOverlaps" };
		ParamDefTable[69].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=70, longName="overlapsAtDepth[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[70];
		ParamDef->init("overlapsAtDepth", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[70].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The chunk overlaps (adjacencies) at each depth of the hierarchy.", true);
		HintTable[2].init("shortDescription", "The chunk overlaps at each depth of the hierarchy", true);
		ParamDefTable[70].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "CachedOverlaps" };
		ParamDefTable[70].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=71, longName="firstChunkAtDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[71];
		ParamDef->init("firstChunkAtDepth", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The first index of chunks at each depth in the hierarchy.  All chunks\n					at a given depth are stored contiguously.", true);
		HintTable[1].init("shortDescription", "The first index of chunks at each depth", true);
		ParamDefTable[71].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=72, longName="firstChunkAtDepth[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[72];
		ParamDef->init("firstChunkAtDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The first index of chunks at each depth in the hierarchy.  All chunks\n					at a given depth are stored contiguously.", true);
		HintTable[1].init("shortDescription", "The first index of chunks at each depth", true);
		ParamDefTable[72].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=73, longName="supportDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[73];
		ParamDef->init("supportDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which to create a support graph.  Higher depth levels give more detailed support,\nbut will give a higher computational load.  Chunks below the support depth will never be supported.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which to create a support graph.", true);
		ParamDefTable[73].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=74, longName="formExtendedStructures"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[74];
		ParamDef->init("formExtendedStructures", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If initially static, the destructible will become part of an extended support structure if it is\nin contact with another static destructible that also has this flag set.\n", true);
		HintTable[1].init("shortDescription", "If initially static, the destructible will become part of an extended support structure if it is in contact with another static destructible that also has this flag set.", true);
		ParamDefTable[74].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=75, longName="useAssetDefinedSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[75];
		ParamDef->init("useAssetDefinedSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which are tagged as 'support' chunks (via NxDestructibleChunkDesc::isSupportChunk)\nwill have environmental support in static destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which are tagged as 'support' chunks", true);
		ParamDefTable[75].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=76, longName="useWorldSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[76];
		ParamDef->init("useWorldSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which overlap the NxScene\'s static geometry will have environmental support in\nstatic destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which overlap the NxScene's static geometry will have environmental support", true);
		ParamDefTable[76].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=77, longName="massScaleExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[77];
		ParamDef->init("massScaleExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Dynamic chunk islands will have their masses raised to this power.  Values less than 1 have the\neffect of reducing the ratio of different masses.  The closer massScaleExponent is to zero, the\nmore the ratio will be 'flattened.'  This helps PhysX converge when there is a very large number\nof interacting rigid bodies (such as a pile of destructible chunks).\nValid range: [0,1].  Default = 0.5.\n", true);
		HintTable[1].init("shortDescription", "Dynamic chunk islands will have their masses raised to this power.", true);
		ParamDefTable[77].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// SetChildren for: nodeIndex=0, longName=""
	{
		static Definition* Children[22];
		Children[0] = PDEF_PTR(1);
		Children[1] = PDEF_PTR(2);
		Children[2] = PDEF_PTR(3);
		Children[3] = PDEF_PTR(4);
		Children[4] = PDEF_PTR(14);
		Children[5] = PDEF_PTR(16);
		Children[6] = PDEF_PTR(49);
		Children[7] = PDEF_PTR(59);
		Children[8] = PDEF_PTR(60);
		Children[9] = PDEF_PTR(61);
		Children[10] = PDEF_PTR(62);
		Children[11] = PDEF_PTR(64);
		Children[12] = PDEF_PTR(65);
		Children[13] = PDEF_PTR(66);
		Children[14] = PDEF_PTR(68);
		Children[15] = PDEF_PTR(69);
		Children[16] = PDEF_PTR(71);
		Children[17] = PDEF_PTR(73);
		Children[18] = PDEF_PTR(74);
		Children[19] = PDEF_PTR(75);
		Children[20] = PDEF_PTR(76);
		Children[21] = PDEF_PTR(77);

		ParamDefTable[0].setChildren(Children, 22);
	}

	// SetChildren for: nodeIndex=4, longName="chunks"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(5);

		ParamDefTable[4].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=5, longName="chunks[]"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(6);
		Children[1] = PDEF_PTR(7);
		Children[2] = PDEF_PTR(8);
		Children[3] = PDEF_PTR(9);
		Children[4] = PDEF_PTR(10);
		Children[5] = PDEF_PTR(11);
		Children[6] = PDEF_PTR(12);
		Children[7] = PDEF_PTR(13);

		ParamDefTable[5].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=14, longName="chunkConvexHulls"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(15);

		ParamDefTable[14].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=16, longName="destructibleParameters"
	{
		static Definition* Children[21];
		Children[0] = PDEF_PTR(17);
		Children[1] = PDEF_PTR(18);
		Children[2] = PDEF_PTR(19);
		Children[3] = PDEF_PTR(20);
		Children[4] = PDEF_PTR(21);
		Children[5] = PDEF_PTR(22);
		Children[6] = PDEF_PTR(23);
		Children[7] = PDEF_PTR(24);
		Children[8] = PDEF_PTR(25);
		Children[9] = PDEF_PTR(26);
		Children[10] = PDEF_PTR(27);
		Children[11] = PDEF_PTR(28);
		Children[12] = PDEF_PTR(29);
		Children[13] = PDEF_PTR(30);
		Children[14] = PDEF_PTR(31);
		Children[15] = PDEF_PTR(32);
		Children[16] = PDEF_PTR(33);
		Children[17] = PDEF_PTR(34);
		Children[18] = PDEF_PTR(41);
		Children[19] = PDEF_PTR(42);
		Children[20] = PDEF_PTR(43);

		ParamDefTable[16].setChildren(Children, 21);
	}

	// SetChildren for: nodeIndex=34, longName="destructibleParameters.flags"
	{
		static Definition* Children[6];
		Children[0] = PDEF_PTR(35);
		Children[1] = PDEF_PTR(36);
		Children[2] = PDEF_PTR(37);
		Children[3] = PDEF_PTR(38);
		Children[4] = PDEF_PTR(39);
		Children[5] = PDEF_PTR(40);

		ParamDefTable[34].setChildren(Children, 6);
	}

	// SetChildren for: nodeIndex=43, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(44);
		Children[1] = PDEF_PTR(45);
		Children[2] = PDEF_PTR(46);
		Children[3] = PDEF_PTR(47);
		Children[4] = PDEF_PTR(48);

		ParamDefTable[43].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=49, longName="depthParameters"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(50);

		ParamDefTable[49].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=50, longName="depthParameters[]"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(51);
		Children[1] = PDEF_PTR(52);
		Children[2] = PDEF_PTR(53);
		Children[3] = PDEF_PTR(54);
		Children[4] = PDEF_PTR(55);
		Children[5] = PDEF_PTR(56);
		Children[6] = PDEF_PTR(57);
		Children[7] = PDEF_PTR(58);

		ParamDefTable[50].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=62, longName="surfaceTraceSets"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(63);

		ParamDefTable[62].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=66, longName="staticMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(67);

		ParamDefTable[66].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=69, longName="overlapsAtDepth"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(70);

		ParamDefTable[69].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=71, longName="firstChunkAtDepth"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(72);

		ParamDefTable[71].setChildren(Children, 1);
	}

	mBuiltFlag = true;

}
void DestructibleAssetParameters_0p3::initStrings(void)
{
	crumbleEmitterName.isAllocated = true;
	crumbleEmitterName.buf = NULL;
	dustEmitterName.isAllocated = true;
	dustEmitterName.buf = NULL;
}

void DestructibleAssetParameters_0p3::initDynamicArrays(void)
{
	chunks.buf = NULL;
	chunks.isAllocated = true;
	chunks.elementSize = sizeof(Chunk_Type);
	chunks.arraySizes[0] = 0;
	chunkConvexHulls.buf = NULL;
	chunkConvexHulls.isAllocated = true;
	chunkConvexHulls.elementSize = sizeof(NvParameterized::Interface*);
	chunkConvexHulls.arraySizes[0] = 0;
	depthParameters.buf = NULL;
	depthParameters.isAllocated = true;
	depthParameters.elementSize = sizeof(DestructibleDepthParameters_Type);
	depthParameters.arraySizes[0] = 0;
	surfaceTraceSets.buf = NULL;
	surfaceTraceSets.isAllocated = true;
	surfaceTraceSets.elementSize = sizeof(NvParameterized::Interface*);
	surfaceTraceSets.arraySizes[0] = 0;
	staticMaterialNames.buf = NULL;
	staticMaterialNames.isAllocated = true;
	staticMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	staticMaterialNames.arraySizes[0] = 0;
	overlapsAtDepth.buf = NULL;
	overlapsAtDepth.isAllocated = true;
	overlapsAtDepth.elementSize = sizeof(NvParameterized::Interface*);
	overlapsAtDepth.arraySizes[0] = 0;
	firstChunkAtDepth.buf = NULL;
	firstChunkAtDepth.isAllocated = true;
	firstChunkAtDepth.elementSize = sizeof(uint32_t);
	firstChunkAtDepth.arraySizes[0] = 0;
}

void DestructibleAssetParameters_0p3::initDefaults(void)
{

	freeStrings();
	freeReferences();
	freeDynamicArrays();
	depthCount = uint32_t(0);
	originalDepthCount = uint32_t(0);
	destructibleParameters.damageThreshold = float(1);
	destructibleParameters.damageToRadius = float(0.1);
	destructibleParameters.damageCap = float(0);
	destructibleParameters.forceToDamage = float(0);
	destructibleParameters.impactVelocityThreshold = float(0);
	destructibleParameters.materialStrength = float(0);
	destructibleParameters.damageToPercentDeformation = float(0);
	destructibleParameters.deformationPercentLimit = float(1);
	destructibleParameters.minimumFractureDepth = uint32_t(0);
	destructibleParameters.debrisDepth = int32_t(-1);
	destructibleParameters.essentialDepth = uint32_t(0);
	destructibleParameters.debrisLifetimeMin = float(1);
	destructibleParameters.debrisLifetimeMax = float(10);
	destructibleParameters.debrisMaxSeparationMin = float(1);
	destructibleParameters.debrisMaxSeparationMax = float(10);
	destructibleParameters.validBounds = physx::PxBounds3(init(-1000, -1000, -1000, 1000, 1000, 1000));
	destructibleParameters.maxChunkSpeed = float(0);
	destructibleParameters.flags.ACCUMULATE_DAMAGE = bool(true);
	destructibleParameters.flags.DEBRIS_TIMEOUT = bool(false);
	destructibleParameters.flags.DEBRIS_MAX_SEPARATION = bool(false);
	destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS = bool(false);
	destructibleParameters.flags.ACCURATE_RAYCASTS = bool(false);
	destructibleParameters.flags.USE_VALID_BOUNDS = bool(false);
	destructibleParameters.fractureImpulseScale = float(0);
	destructibleParameters.dynamicChunkDominanceGroup = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunksGroupsMask.useGroupsMask = bool(false);
	destructibleParameters.dynamicChunksGroupsMask.bits0 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits1 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits2 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits3 = uint32_t(0);
	interiorSubmeshIndex = int32_t(-1);
	neighborPadding = float(0.001);
	supportDepth = uint32_t(0);
	formExtendedStructures = bool(false);
	useAssetDefinedSupport = bool(false);
	useWorldSupport = bool(false);
	massScaleExponent = float(0.5);

	initDynamicArrays();
	initStrings();
	initReferences();
}

void DestructibleAssetParameters_0p3::initReferences(void)
{
	collisionData = NULL;

	renderMeshAsset = NULL;

}

void DestructibleAssetParameters_0p3::freeDynamicArrays(void)
{
	if (chunks.isAllocated && chunks.buf)
	{
		mParameterizedTraits->free(chunks.buf);
	}
	if (chunkConvexHulls.isAllocated && chunkConvexHulls.buf)
	{
		mParameterizedTraits->free(chunkConvexHulls.buf);
	}
	if (depthParameters.isAllocated && depthParameters.buf)
	{
		mParameterizedTraits->free(depthParameters.buf);
	}
	if (surfaceTraceSets.isAllocated && surfaceTraceSets.buf)
	{
		mParameterizedTraits->free(surfaceTraceSets.buf);
	}
	if (staticMaterialNames.isAllocated && staticMaterialNames.buf)
	{
		mParameterizedTraits->free(staticMaterialNames.buf);
	}
	if (overlapsAtDepth.isAllocated && overlapsAtDepth.buf)
	{
		mParameterizedTraits->free(overlapsAtDepth.buf);
	}
	if (firstChunkAtDepth.isAllocated && firstChunkAtDepth.buf)
	{
		mParameterizedTraits->free(firstChunkAtDepth.buf);
	}
}

void DestructibleAssetParameters_0p3::freeStrings(void)
{

	if (crumbleEmitterName.isAllocated && crumbleEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)crumbleEmitterName.buf);
	}

	if (dustEmitterName.isAllocated && dustEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)dustEmitterName.buf);
	}

	for (int i = 0; i < staticMaterialNames.arraySizes[0]; ++i)
	{
		if (staticMaterialNames.buf[i].isAllocated && staticMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)staticMaterialNames.buf[i].buf);
		}
	}
}

void DestructibleAssetParameters_0p3::freeReferences(void)
{

	for (int i = 0; i < chunkConvexHulls.arraySizes[0]; ++i)
	{
		if (chunkConvexHulls.buf[i])
		{
			chunkConvexHulls.buf[i]->destroy();
		}
	}
	if (collisionData)
	{
		collisionData->destroy();
	}


	for (int i = 0; i < surfaceTraceSets.arraySizes[0]; ++i)
	{
		if (surfaceTraceSets.buf[i])
		{
			surfaceTraceSets.buf[i]->destroy();
		}
	}
	if (renderMeshAsset)
	{
		renderMeshAsset->destroy();
	}


	for (int i = 0; i < overlapsAtDepth.arraySizes[0]; ++i)
	{
		if (overlapsAtDepth.buf[i])
		{
			overlapsAtDepth.buf[i]->destroy();
		}
	}
}

} // namespace parameterized
} // namespace nvidia
