// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.

// This file was generated by NvParameterized/scripts/GenParameterized.pl


#include "DestructibleActorState_0p1.h"
#include <string.h>
#include <stdlib.h>

using namespace NvParameterized;

namespace nvidia
{
namespace parameterized
{

using namespace DestructibleActorState_0p1NS;

const char* const DestructibleActorState_0p1Factory::vptr =
    NvParameterized::getVptr<DestructibleActorState_0p1, DestructibleActorState_0p1::ClassAlignment>();

const uint32_t NumParamDefs = 48;
static NvParameterized::DefinitionImpl* ParamDefTable; // now allocated in buildTree [NumParamDefs];


static const size_t ParamLookupChildrenTable[] =
{
	1, 2, 3, 9, 10, 11, 45, 46, 47, 4, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20,
	21, 22, 23, 24, 25, 26, 27, 28, 29, 37, 38, 39, 30, 31, 32, 33, 34, 35, 36, 40, 41,
	42, 43, 44,
};

#define TENUM(type) nvidia::##type
#define CHILDREN(index) &ParamLookupChildrenTable[index]
static const NvParameterized::ParamLookupNode ParamLookupTable[NumParamDefs] =
{
	{ TYPE_STRUCT, false, 0, CHILDREN(0), 9 },
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->enableCrumbleEmitter), NULL, 0 }, // enableCrumbleEmitter
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->enableDustEmitter), NULL, 0 }, // enableDustEmitter
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->internalLODWeights), CHILDREN(9), 5 }, // internalLODWeights
	{ TYPE_F32, false, (size_t)(&((LODWeights_Type*)0)->maxDistance), NULL, 0 }, // internalLODWeights.maxDistance
	{ TYPE_F32, false, (size_t)(&((LODWeights_Type*)0)->distanceWeight), NULL, 0 }, // internalLODWeights.distanceWeight
	{ TYPE_F32, false, (size_t)(&((LODWeights_Type*)0)->maxAge), NULL, 0 }, // internalLODWeights.maxAge
	{ TYPE_F32, false, (size_t)(&((LODWeights_Type*)0)->ageWeight), NULL, 0 }, // internalLODWeights.ageWeight
	{ TYPE_F32, false, (size_t)(&((LODWeights_Type*)0)->bias), NULL, 0 }, // internalLODWeights.bias
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->lod), NULL, 0 }, // lod
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->forceLod), NULL, 0 }, // forceLod
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->destructibleParameters), CHILDREN(14), 21 }, // destructibleParameters
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageThreshold), NULL, 0 }, // destructibleParameters.damageThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageToRadius), NULL, 0 }, // destructibleParameters.damageToRadius
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageCap), NULL, 0 }, // destructibleParameters.damageCap
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->forceToDamage), NULL, 0 }, // destructibleParameters.forceToDamage
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactVelocityThreshold), NULL, 0 }, // destructibleParameters.impactVelocityThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->materialStrength), NULL, 0 }, // destructibleParameters.materialStrength
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->minimumFractureDepth), NULL, 0 }, // destructibleParameters.minimumFractureDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactDamageDefaultDepth), NULL, 0 }, // destructibleParameters.impactDamageDefaultDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDepth), NULL, 0 }, // destructibleParameters.debrisDepth
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->essentialDepth), NULL, 0 }, // destructibleParameters.essentialDepth
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMin), NULL, 0 }, // destructibleParameters.debrisLifetimeMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMax), NULL, 0 }, // destructibleParameters.debrisLifetimeMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMin), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMax), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDestructionProbability), NULL, 0 }, // destructibleParameters.debrisDestructionProbability
	{ TYPE_BOUNDS3, false, (size_t)(&((DestructibleParameters_Type*)0)->validBounds), NULL, 0 }, // destructibleParameters.validBounds
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->maxChunkSpeed), NULL, 0 }, // destructibleParameters.maxChunkSpeed
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->flags), CHILDREN(35), 7 }, // destructibleParameters.flags
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCUMULATE_DAMAGE), NULL, 0 }, // destructibleParameters.flags.ACCUMULATE_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_TIMEOUT), NULL, 0 }, // destructibleParameters.flags.DEBRIS_TIMEOUT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_MAX_SEPARATION), NULL, 0 }, // destructibleParameters.flags.DEBRIS_MAX_SEPARATION
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_SMALLEST_CHUNKS), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCURATE_RAYCASTS), NULL, 0 }, // destructibleParameters.flags.ACCURATE_RAYCASTS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->USE_VALID_BOUNDS), NULL, 0 }, // destructibleParameters.flags.USE_VALID_BOUNDS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_VIA_RUNTIME_FRACTURE), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->fractureImpulseScale), NULL, 0 }, // destructibleParameters.fractureImpulseScale
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunkDominanceGroup), NULL, 0 }, // destructibleParameters.dynamicChunkDominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunksGroupsMask), CHILDREN(42), 5 }, // destructibleParameters.dynamicChunksGroupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits3
	{ TYPE_U64, false, (size_t)(&((ParametersStruct*)0)->userData), NULL, 0 }, // userData
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->actorParameters), NULL, 0 }, // actorParameters
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->actorChunks), NULL, 0 }, // actorChunks
};


bool DestructibleActorState_0p1::mBuiltFlag = false;
NvParameterized::MutexType DestructibleActorState_0p1::mBuiltFlagMutex;

DestructibleActorState_0p1::DestructibleActorState_0p1(NvParameterized::Traits* traits, void* buf, int32_t* refCount) :
	NvParameters(traits, buf, refCount)
{
	//mParameterizedTraits->registerFactory(className(), &DestructibleActorState_0p1FactoryInst);

	if (!buf) //Do not init data if it is inplace-deserialized
	{
		initDynamicArrays();
		initStrings();
		initReferences();
		initDefaults();
	}
}

DestructibleActorState_0p1::~DestructibleActorState_0p1()
{
	freeStrings();
	freeReferences();
	freeDynamicArrays();
}

void DestructibleActorState_0p1::destroy()
{
	// We cache these fields here to avoid overwrite in destructor
	bool doDeallocateSelf = mDoDeallocateSelf;
	NvParameterized::Traits* traits = mParameterizedTraits;
	int32_t* refCount = mRefCount;
	void* buf = mBuffer;

	this->~DestructibleActorState_0p1();

	NvParameters::destroy(this, traits, doDeallocateSelf, refCount, buf);
}

const NvParameterized::DefinitionImpl* DestructibleActorState_0p1::getParameterDefinitionTree(void)
{
	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

const NvParameterized::DefinitionImpl* DestructibleActorState_0p1::getParameterDefinitionTree(void) const
{
	DestructibleActorState_0p1* tmpParam = const_cast<DestructibleActorState_0p1*>(this);

	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			tmpParam->buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

NvParameterized::ErrorType DestructibleActorState_0p1::getParameterHandle(const char* long_name, Handle& handle) const
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

NvParameterized::ErrorType DestructibleActorState_0p1::getParameterHandle(const char* long_name, Handle& handle)
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

void DestructibleActorState_0p1::getVarPtr(const Handle& handle, void*& ptr, size_t& offset) const
{
	ptr = getVarPtrHelper(&ParamLookupTable[0], const_cast<DestructibleActorState_0p1::ParametersStruct*>(&parameters()), handle, offset);
}


/* Dynamic Handle Indices */

void DestructibleActorState_0p1::freeParameterDefinitionTable(NvParameterized::Traits* traits)
{
	if (!traits)
	{
		return;
	}

	if (!mBuiltFlag) // Double-checked lock
	{
		return;
	}

	NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);

	if (!mBuiltFlag)
	{
		return;
	}

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		ParamDefTable[i].~DefinitionImpl();
	}

	traits->free(ParamDefTable);

	mBuiltFlag = false;
}

#define PDEF_PTR(index) (&ParamDefTable[index])

void DestructibleActorState_0p1::buildTree(void)
{

	uint32_t allocSize = sizeof(NvParameterized::DefinitionImpl) * NumParamDefs;
	ParamDefTable = (NvParameterized::DefinitionImpl*)(mParameterizedTraits->alloc(allocSize));
	memset(ParamDefTable, 0, allocSize);

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		NV_PARAM_PLACEMENT_NEW(ParamDefTable + i, NvParameterized::DefinitionImpl)(*mParameterizedTraits);
	}

	// Initialize DefinitionImpl node: nodeIndex=0, longName=""
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[0];
		ParamDef->init("", TYPE_STRUCT, "STRUCT", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=1, longName="enableCrumbleEmitter"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[1];
		ParamDef->init("enableCrumbleEmitter", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the crumble emitter is active.", true);
		HintTable[1].init("shortDescription", "Whether or not the crumble emitter is active", true);
		ParamDefTable[1].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=2, longName="enableDustEmitter"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[2];
		ParamDef->init("enableDustEmitter", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the dust emitter is active.", true);
		HintTable[1].init("shortDescription", "Whether or not the dust emitter is active", true);
		ParamDefTable[2].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=3, longName="internalLODWeights"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[3];
		ParamDef->init("internalLODWeights", TYPE_STRUCT, "LODWeights", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Values include: maxDistance, distanceWeight, maxAge, ageWeight and bias.", true);
		HintTable[1].init("shortDescription", "Parameters used internally to specify LOD behavior", true);
		ParamDefTable[3].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=4, longName="internalLODWeights.maxDistance"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[4];
		ParamDef->init("maxDistance", TYPE_F32, NULL, true);






	}

	// Initialize DefinitionImpl node: nodeIndex=5, longName="internalLODWeights.distanceWeight"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[5];
		ParamDef->init("distanceWeight", TYPE_F32, NULL, true);






	}

	// Initialize DefinitionImpl node: nodeIndex=6, longName="internalLODWeights.maxAge"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[6];
		ParamDef->init("maxAge", TYPE_F32, NULL, true);






	}

	// Initialize DefinitionImpl node: nodeIndex=7, longName="internalLODWeights.ageWeight"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[7];
		ParamDef->init("ageWeight", TYPE_F32, NULL, true);






	}

	// Initialize DefinitionImpl node: nodeIndex=8, longName="internalLODWeights.bias"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[8];
		ParamDef->init("bias", TYPE_F32, NULL, true);






	}

	// Initialize DefinitionImpl node: nodeIndex=9, longName="lod"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[9];
		ParamDef->init("lod", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Destructible actor LOD.", true);
		HintTable[1].init("shortDescription", "Destructible actor LOD", true);
		ParamDefTable[9].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=10, longName="forceLod"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[10];
		ParamDef->init("forceLod", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not to force LOD behavior on the actor.", true);
		HintTable[1].init("shortDescription", "Whether or not to force LOD behavior on the actor", true);
		ParamDefTable[10].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=11, longName="destructibleParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[11];
		ParamDef->init("destructibleParameters", TYPE_STRUCT, "DestructibleParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters that control destruction of a destructible actor.", true);
		HintTable[1].init("shortDescription", "Parameters that control destruction of a destructible actor", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=12, longName="destructibleParameters.damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[12];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\nThis is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\nor NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).\n", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[12].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=13, longName="destructibleParameters.damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[13];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\nis multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\nwill have damage applied to them.  The damage applied to each chunk varies with distance to the damage\napplication position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[13].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=14, longName="destructibleParameters.damageCap"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[14];
		ParamDef->init("damageCap", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Limits the amount of damage applied to a chunk.  This is useful for preventing the entire destructible\nfrom getting pulverized by a very large application of damage.  This can easily happen when impact damage is\nused, and the damage amount is proportional to the impact force (see forceToDamage).\n", true);
		HintTable[1].init("shortDescription", "Limits the amount of damage applied to a chunk.", true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=15, longName="destructibleParameters.forceToDamage"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[15];
		ParamDef->init("forceToDamage", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk is at a depth which takes impact damage (see NxDestructibleDepthParameters),\nthen when a chunk has a collision in the NxScene, it will take damage equal to forceToDamage mulitplied by\nthe impact force.\nThe default value is zero, which effectively disables impact damage.\n", true);
		HintTable[1].init("shortDescription", "Multiplier to calculate applied damage from an impact.", true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=16, longName="destructibleParameters.impactVelocityThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[16];
		ParamDef->init("impactVelocityThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.  In this case the relative velocity of the two\nobjects will be low.  This variable allows the user to set a minimum velocity threshold for impacts to ensure that the objects are\nmoving at a min velocity in order for the impact force to be considered.\n", true);
		HintTable[1].init("shortDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.", true);
		ParamDefTable[16].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=17, longName="destructibleParameters.materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[17];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see see NxDestructibleDepthParameters), this parameter\nis the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\nheavier objects will pass through them during fracture.\nN.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\nDefault value = 0.0f.\n", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[17].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=18, longName="destructibleParameters.minimumFractureDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[18];
		ParamDef->init("minimumFractureDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks will not be broken free below this depth.\n", true);
		HintTable[1].init("shortDescription", "The chunks will not be broken free below this depth.", true);
		ParamDefTable[18].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=19, longName="destructibleParameters.impactDamageDefaultDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[19];
		ParamDef->init("impactDamageDefaultDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default depth to which chunks will take impact damage.  This default may be overridden in the depth settings.\n", true);
		HintTable[1].init("shortDescription", "The default depth to which chunks will take impact damage.", true);
		ParamDefTable[19].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=20, longName="destructibleParameters.debrisDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[20];
		ParamDef->init("debrisDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'  Chunks at this depth or\nbelow will be considered for various debris settings, such as debrisLifetime.\nNegative values indicate that no chunk depth is considered debris.\nDefault value is -1.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'", true);
		ParamDefTable[20].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=21, longName="destructibleParameters.essentialDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[21];
		ParamDef->init("essentialDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth up to which chunks will always be processed.  These chunks are considered\nto be essential either for gameplay or visually.\nThe minimum value is 0, meaning the level 0 chunk is always considered essential.\nDefault value is 0.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth up to which chunks will always be processed", true);
		ParamDefTable[21].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=22, longName="destructibleParameters.debrisLifetimeMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[22];
		ParamDef->init("debrisLifetimeMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin and debrisLifetimeMax (see below), based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum time to destroy debris", true);
		ParamDefTable[22].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=23, longName="destructibleParameters.debrisLifetimeMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[23];
		ParamDef->init("debrisLifetimeMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin (see above) and debrisLifetimeMax, based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Maximum time to destroy debris", true);
		ParamDefTable[23].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=24, longName="destructibleParameters.debrisMaxSeparationMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[24];
		ParamDef->init("debrisMaxSeparationMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin and debrisMaxSeparationMax (see below),\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[24].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=25, longName="destructibleParameters.debrisMaxSeparationMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[25];
		ParamDef->init("debrisMaxSeparationMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin (see above) and debrisMaxSeparationMax,\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[25].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=26, longName="destructibleParameters.debrisDestructionProbability"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[26];
		ParamDef->init("debrisDestructionProbability", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed instead of becoming dynamic or breaking down\n						further into child chunks.  Valid range = [0.0,1.0].  Default value = 0.0.", true);
		HintTable[1].init("shortDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed", true);
		ParamDefTable[26].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=27, longName="destructibleParameters.validBounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[27];
		ParamDef->init("validBounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A bounding box around each NxDestructibleActor created, defining a range of validity\nfor chunks that break free.  These bounds are scaled and translated with the\nNxDestructibleActor\'s scale and position, but they are not rotated with the\nNxDestructibleActor.\n", true);
		HintTable[1].init("shortDescription", "valid bounding region for debris", true);
		ParamDefTable[27].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=28, longName="destructibleParameters.maxChunkSpeed"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[28];
		ParamDef->init("maxChunkSpeed", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If greater than 0, the chunks' speeds will not be allowed to exceed this value.  Use 0\nto disable this feature (this is the default).\n", true);
		HintTable[1].init("shortDescription", "Maximum speed of a chunk", true);
		ParamDefTable[28].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=29, longName="destructibleParameters.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[29];
		ParamDef->init("flags", TYPE_STRUCT, "DestructibleParametersFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A collection of flags defined in NxDestructibleParametersFlag.\n", true);
		HintTable[1].init("shortDescription", "A collection of flags defined in DestructibleParametersFlag.", true);
		ParamDefTable[29].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=30, longName="destructibleParameters.flags.ACCUMULATE_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[30];
		ParamDef->init("ACCUMULATE_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, chunks will 'remember' damage applied to them, so that many applications of a damage amount\nbelow damageThreshold will eventually fracture the chunk.  If not set, a single application of\ndamage must exceed damageThreshold in order to fracture the chunk.\n", true);
		HintTable[1].init("shortDescription", "Determines if chunks accumulate damage", true);
		ParamDefTable[30].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=31, longName="destructibleParameters.flags.DEBRIS_TIMEOUT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[31];
		ParamDef->init("DEBRIS_TIMEOUT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill time out.  The lifetime is a value between NxDestructibleParameters::debrisLifetimeMin and\nNxDestructibleParameters::debrisLifetimeMax, based upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will timeout", true);
		ParamDefTable[31].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=32, longName="destructibleParameters.flags.DEBRIS_MAX_SEPARATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[32];
		ParamDef->init("DEBRIS_MAX_SEPARATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill be removed if they separate too far from their origins.  The maxSeparation is a value between\nNxDestructibleParameters::debrisMaxSeparationMin and NxDestructibleParameters::debrisMaxSeparationMax,\nbased upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will be removed if separated too far", true);
		ParamDefTable[32].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=33, longName="destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[33];
		ParamDef->init("CRUMBLE_SMALLEST_CHUNKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the smallest chunks may be further broken down, either by fluid crumbles (if a crumble particle\nsystem is specified in the NxDestructibleActorDesc), or by simply removing the chunk if no crumble\nparticle system is specified.  Note: the 'smallest chunks' are normally defined to be the deepest level\nof the fracture hierarchy.  However, they may be taken from higher levels of the hierarchy if\nNxModuleDestructible::setMaxChunkDepthOffset is called with a non-zero value.\n", true);
		HintTable[1].init("shortDescription", "If set, the smallest chunks may be further broken down", true);
		ParamDefTable[33].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=34, longName="destructibleParameters.flags.ACCURATE_RAYCASTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[34];
		ParamDef->init("ACCURATE_RAYCASTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit\nfor collisions with child chunks.  This is used to get a better raycast position and normal, in\ncase the parent collision volume does not tightly fit the graphics mesh.  The returned chunk index\nwill always be that of the visible parent that is intersected, however.\n", true);
		HintTable[1].init("shortDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit", true);
		ParamDefTable[34].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=35, longName="destructibleParameters.flags.USE_VALID_BOUNDS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[35];
		ParamDef->init("USE_VALID_BOUNDS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the validBounds field of NxDestructibleParameters will be used.  These bounds are translated\n(but not scaled or rotated) to the origin of the destructible actor.  If a chunk or chunk island moves\noutside of those bounds, it is destroyed.\n", true);
		HintTable[1].init("shortDescription", "If set, the validBounds field of NxDestructibleParameters will be used.", true);
		ParamDefTable[35].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=36, longName="destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[36];
		ParamDef->init("CRUMBLE_VIA_RUNTIME_FRACTURE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, crumbled chunks will use the runtime fracture pipeline. The chunk will be procedurally broken\ndestroyed using either the default or a specified fracture pattern.\n", true);
		HintTable[1].init("shortDescription", "If set, crumbled chunks will use the runtime fracture pipeline.", true);
		ParamDefTable[36].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=37, longName="destructibleParameters.fractureImpulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[37];
		ParamDef->init("fractureImpulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.  This is used\nin order to 'push' the pieces out as they fracture.\n", true);
		HintTable[1].init("shortDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.", true);
		ParamDefTable[37].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=38, longName="destructibleParameters.dynamicChunkDominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[38];
		ParamDef->init("dynamicChunkDominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional dominance group for dynamic chunks created when fractured. (ignored if > 31)\n", true);
		HintTable[1].init("shortDescription", "Optional dominance group for dynamic chunks created when fractured.", true);
		ParamDefTable[38].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=39, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[39];
		ParamDef->init("dynamicChunksGroupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.\n", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		ParamDefTable[39].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=40, longName="destructibleParameters.dynamicChunksGroupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[40];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[40].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=41, longName="destructibleParameters.dynamicChunksGroupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[41];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[41].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=42, longName="destructibleParameters.dynamicChunksGroupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[42];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[42].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=43, longName="destructibleParameters.dynamicChunksGroupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[43];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[43].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=44, longName="destructibleParameters.dynamicChunksGroupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[44];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[44].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=45, longName="userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[45];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer. Note: Any pointer references will not be properly serialized.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=46, longName="actorParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[46];
		ParamDef->init("actorParameters", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The destructible actor parameters.", true);
		HintTable[2].init("shortDescription", "The destructible actor parameters", true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "DestructibleActorParam" };
		ParamDefTable[46].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=47, longName="actorChunks"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[47];
		ParamDef->init("actorChunks", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The actor's chunk data.", true);
		HintTable[2].init("shortDescription", "The actor's chunk data", true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "DestructibleActorChunks" };
		ParamDefTable[47].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// SetChildren for: nodeIndex=0, longName=""
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(1);
		Children[1] = PDEF_PTR(2);
		Children[2] = PDEF_PTR(3);
		Children[3] = PDEF_PTR(9);
		Children[4] = PDEF_PTR(10);
		Children[5] = PDEF_PTR(11);
		Children[6] = PDEF_PTR(45);
		Children[7] = PDEF_PTR(46);
		Children[8] = PDEF_PTR(47);

		ParamDefTable[0].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=3, longName="internalLODWeights"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(4);
		Children[1] = PDEF_PTR(5);
		Children[2] = PDEF_PTR(6);
		Children[3] = PDEF_PTR(7);
		Children[4] = PDEF_PTR(8);

		ParamDefTable[3].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=11, longName="destructibleParameters"
	{
		static Definition* Children[21];
		Children[0] = PDEF_PTR(12);
		Children[1] = PDEF_PTR(13);
		Children[2] = PDEF_PTR(14);
		Children[3] = PDEF_PTR(15);
		Children[4] = PDEF_PTR(16);
		Children[5] = PDEF_PTR(17);
		Children[6] = PDEF_PTR(18);
		Children[7] = PDEF_PTR(19);
		Children[8] = PDEF_PTR(20);
		Children[9] = PDEF_PTR(21);
		Children[10] = PDEF_PTR(22);
		Children[11] = PDEF_PTR(23);
		Children[12] = PDEF_PTR(24);
		Children[13] = PDEF_PTR(25);
		Children[14] = PDEF_PTR(26);
		Children[15] = PDEF_PTR(27);
		Children[16] = PDEF_PTR(28);
		Children[17] = PDEF_PTR(29);
		Children[18] = PDEF_PTR(37);
		Children[19] = PDEF_PTR(38);
		Children[20] = PDEF_PTR(39);

		ParamDefTable[11].setChildren(Children, 21);
	}

	// SetChildren for: nodeIndex=29, longName="destructibleParameters.flags"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(30);
		Children[1] = PDEF_PTR(31);
		Children[2] = PDEF_PTR(32);
		Children[3] = PDEF_PTR(33);
		Children[4] = PDEF_PTR(34);
		Children[5] = PDEF_PTR(35);
		Children[6] = PDEF_PTR(36);

		ParamDefTable[29].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=39, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(40);
		Children[1] = PDEF_PTR(41);
		Children[2] = PDEF_PTR(42);
		Children[3] = PDEF_PTR(43);
		Children[4] = PDEF_PTR(44);

		ParamDefTable[39].setChildren(Children, 5);
	}

	mBuiltFlag = true;

}
void DestructibleActorState_0p1::initStrings(void)
{
}

void DestructibleActorState_0p1::initDynamicArrays(void)
{
}

void DestructibleActorState_0p1::initDefaults(void)
{

	freeStrings();
	freeReferences();
	freeDynamicArrays();
	enableCrumbleEmitter = bool(true);
	enableDustEmitter = bool(true);
	internalLODWeights.maxDistance = float(2000);
	internalLODWeights.distanceWeight = float(0.5);
	internalLODWeights.maxAge = float(10);
	internalLODWeights.ageWeight = float(0.5);
	internalLODWeights.bias = float(0);
	lod = uint32_t(0);
	forceLod = bool(false);
	destructibleParameters.damageThreshold = float(1);
	destructibleParameters.damageToRadius = float(0.1);
	destructibleParameters.damageCap = float(0);
	destructibleParameters.forceToDamage = float(0);
	destructibleParameters.impactVelocityThreshold = float(0);
	destructibleParameters.materialStrength = float(0);
	destructibleParameters.minimumFractureDepth = uint32_t(0);
	destructibleParameters.impactDamageDefaultDepth = int32_t(-1);
	destructibleParameters.debrisDepth = int32_t(-1);
	destructibleParameters.essentialDepth = uint32_t(0);
	destructibleParameters.debrisLifetimeMin = float(1);
	destructibleParameters.debrisLifetimeMax = float(10);
	destructibleParameters.debrisMaxSeparationMin = float(1);
	destructibleParameters.debrisMaxSeparationMax = float(10);
	destructibleParameters.debrisDestructionProbability = float(0);
	destructibleParameters.validBounds = physx::PxBounds3(init(-1000, -1000, -1000, 1000, 1000, 1000));
	destructibleParameters.maxChunkSpeed = float(0);
	destructibleParameters.flags.ACCUMULATE_DAMAGE = bool(true);
	destructibleParameters.flags.DEBRIS_TIMEOUT = bool(false);
	destructibleParameters.flags.DEBRIS_MAX_SEPARATION = bool(false);
	destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS = bool(false);
	destructibleParameters.flags.ACCURATE_RAYCASTS = bool(false);
	destructibleParameters.flags.USE_VALID_BOUNDS = bool(false);
	destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE = bool(false);
	destructibleParameters.fractureImpulseScale = float(0);
	destructibleParameters.dynamicChunkDominanceGroup = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunksGroupsMask.useGroupsMask = bool(false);
	destructibleParameters.dynamicChunksGroupsMask.bits0 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits1 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits2 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits3 = uint32_t(0);
	userData = uint64_t(0);

	initDynamicArrays();
	initStrings();
	initReferences();
}

void DestructibleActorState_0p1::initReferences(void)
{
	actorParameters = NULL;

	actorChunks = NULL;

}

void DestructibleActorState_0p1::freeDynamicArrays(void)
{
}

void DestructibleActorState_0p1::freeStrings(void)
{
}

void DestructibleActorState_0p1::freeReferences(void)
{
	if (actorParameters)
	{
		actorParameters->destroy();
	}

	if (actorChunks)
	{
		actorChunks->destroy();
	}

}

} // namespace parameterized
} // namespace nvidia
