// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.

// This file was generated by NvParameterized/scripts/GenParameterized.pl


#include "DestructibleActorParam_0p29.h"
#include <string.h>
#include <stdlib.h>

using namespace NvParameterized;

namespace nvidia
{
namespace parameterized
{

using namespace DestructibleActorParam_0p29NS;

const char* const DestructibleActorParam_0p29Factory::vptr =
    NvParameterized::getVptr<DestructibleActorParam_0p29, DestructibleActorParam_0p29::ClassAlignment>();

const uint32_t NumParamDefs = 293;
static NvParameterized::DefinitionImpl* ParamDefTable; // now allocated in buildTree [NumParamDefs];


static const size_t ParamLookupChildrenTable[] =
{
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 23, 24, 84,
	95, 129, 158, 175, 198, 224, 238, 242, 266, 291, 292, 19, 21, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 47, 48, 49, 50, 56, 81, 82, 83, 40, 41, 42,
	43, 44, 45, 46, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 69, 74, 64, 65, 66,
	67, 68, 70, 71, 72, 73, 75, 76, 77, 78, 79, 80, 85, 86, 87, 88, 89, 90, 91, 92, 93,
	94, 96, 117, 118, 124, 125, 126, 127, 128, 97, 98, 99, 100, 101, 102, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 119, 120, 121, 122, 123, 130,
	138, 139, 140, 141, 154, 155, 156, 157, 131, 132, 133, 134, 135, 136, 137, 142, 143,
	144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 159, 164, 165, 166, 167, 168, 169,
	170, 171, 172, 173, 174, 160, 161, 162, 163, 176, 183, 188, 193, 194, 195, 196, 197,
	177, 178, 179, 180, 181, 182, 184, 185, 186, 187, 189, 190, 191, 192, 199, 203, 204,
	205, 206, 222, 223, 200, 201, 202, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
	217, 218, 219, 220, 221, 225, 226, 229, 230, 231, 232, 233, 234, 235, 236, 237, 227,
	228, 239, 240, 241, 243, 244, 245, 246, 250, 254, 255, 256, 257, 258, 259, 265, 247,
	248, 249, 251, 252, 253, 260, 261, 262, 263, 264, 267, 268, 269, 270, 271, 275, 279,
	280, 281, 282, 283, 284, 290, 272, 273, 274, 276, 277, 278, 285, 286, 287, 288, 289,
};

#define TENUM(type) nvidia::##type
#define CHILDREN(index) &ParamLookupChildrenTable[index]
static const NvParameterized::ParamLookupNode ParamLookupTable[NumParamDefs] =
{
	{ TYPE_STRUCT, false, 0, CHILDREN(0), 34 },
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->crumbleEmitterName), NULL, 0 }, // crumbleEmitterName
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->crumbleParticleSpacing), NULL, 0 }, // crumbleParticleSpacing
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->dustEmitterName), NULL, 0 }, // dustEmitterName
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->dustParticleSpacing), NULL, 0 }, // dustParticleSpacing
	{ TYPE_MAT34, false, (size_t)(&((ParametersStruct*)0)->globalPose), NULL, 0 }, // globalPose
	{ TYPE_VEC3, false, (size_t)(&((ParametersStruct*)0)->scale), NULL, 0 }, // scale
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->dynamic), NULL, 0 }, // dynamic
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->supportDepth), NULL, 0 }, // supportDepth
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->formExtendedStructures), NULL, 0 }, // formExtendedStructures
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->performDetailedOverlapTestForExtendedStructures), NULL, 0 }, // performDetailedOverlapTestForExtendedStructures
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->keepPreviousFrameBoneBuffer), NULL, 0 }, // keepPreviousFrameBoneBuffer
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->doNotCreateRenderable), NULL, 0 }, // doNotCreateRenderable
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useAssetDefinedSupport), NULL, 0 }, // useAssetDefinedSupport
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useWorldSupport), NULL, 0 }, // useWorldSupport
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->renderStaticChunksSeparately), NULL, 0 }, // renderStaticChunksSeparately
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->keepVisibleBonesPacked), NULL, 0 }, // keepVisibleBonesPacked
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->createChunkEvents), NULL, 0 }, // createChunkEvents
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overrideSkinnedMaterialNames), CHILDREN(34), 1 }, // overrideSkinnedMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // overrideSkinnedMaterialNames[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overrideStaticMaterialNames), CHILDREN(35), 1 }, // overrideStaticMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // overrideStaticMaterialNames[]
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->sleepVelocityFrameDecayConstant), NULL, 0 }, // sleepVelocityFrameDecayConstant
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useHardSleeping), NULL, 0 }, // useHardSleeping
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->destructibleParameters), CHILDREN(36), 23 }, // destructibleParameters
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageCap), NULL, 0 }, // destructibleParameters.damageCap
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->forceToDamage), NULL, 0 }, // destructibleParameters.forceToDamage
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactVelocityThreshold), NULL, 0 }, // destructibleParameters.impactVelocityThreshold
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->minimumFractureDepth), NULL, 0 }, // destructibleParameters.minimumFractureDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactDamageDefaultDepth), NULL, 0 }, // destructibleParameters.impactDamageDefaultDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDepth), NULL, 0 }, // destructibleParameters.debrisDepth
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->essentialDepth), NULL, 0 }, // destructibleParameters.essentialDepth
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMin), NULL, 0 }, // destructibleParameters.debrisLifetimeMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMax), NULL, 0 }, // destructibleParameters.debrisLifetimeMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMin), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMax), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDestructionProbability), NULL, 0 }, // destructibleParameters.debrisDestructionProbability
	{ TYPE_BOUNDS3, false, (size_t)(&((DestructibleParameters_Type*)0)->validBounds), NULL, 0 }, // destructibleParameters.validBounds
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->maxChunkSpeed), NULL, 0 }, // destructibleParameters.maxChunkSpeed
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->flags), CHILDREN(59), 7 }, // destructibleParameters.flags
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCUMULATE_DAMAGE), NULL, 0 }, // destructibleParameters.flags.ACCUMULATE_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_TIMEOUT), NULL, 0 }, // destructibleParameters.flags.DEBRIS_TIMEOUT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_MAX_SEPARATION), NULL, 0 }, // destructibleParameters.flags.DEBRIS_MAX_SEPARATION
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_SMALLEST_CHUNKS), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCURATE_RAYCASTS), NULL, 0 }, // destructibleParameters.flags.ACCURATE_RAYCASTS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->USE_VALID_BOUNDS), NULL, 0 }, // destructibleParameters.flags.USE_VALID_BOUNDS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_VIA_RUNTIME_FRACTURE), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->fractureImpulseScale), NULL, 0 }, // destructibleParameters.fractureImpulseScale
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->damageDepthLimit), NULL, 0 }, // destructibleParameters.damageDepthLimit
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunkDominanceGroup), NULL, 0 }, // destructibleParameters.dynamicChunkDominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunksGroupsMask), CHILDREN(66), 5 }, // destructibleParameters.dynamicChunksGroupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits3
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->runtimeFracture), CHILDREN(71), 9 }, // destructibleParameters.runtimeFracture
	{ TYPE_ENUM, false, (size_t)(&((RuntimeFracture_Type*)0)->RuntimeFractureType), NULL, 0 }, // destructibleParameters.runtimeFracture.RuntimeFractureType
	{ TYPE_BOOL, false, (size_t)(&((RuntimeFracture_Type*)0)->sheetFracture), NULL, 0 }, // destructibleParameters.runtimeFracture.sheetFracture
	{ TYPE_U32, false, (size_t)(&((RuntimeFracture_Type*)0)->depthLimit), NULL, 0 }, // destructibleParameters.runtimeFracture.depthLimit
	{ TYPE_BOOL, false, (size_t)(&((RuntimeFracture_Type*)0)->destroyIfAtDepthLimit), NULL, 0 }, // destructibleParameters.runtimeFracture.destroyIfAtDepthLimit
	{ TYPE_F32, false, (size_t)(&((RuntimeFracture_Type*)0)->minConvexSize), NULL, 0 }, // destructibleParameters.runtimeFracture.minConvexSize
	{ TYPE_F32, false, (size_t)(&((RuntimeFracture_Type*)0)->impulseScale), NULL, 0 }, // destructibleParameters.runtimeFracture.impulseScale
	{ TYPE_STRUCT, false, (size_t)(&((RuntimeFracture_Type*)0)->glass), CHILDREN(80), 5 }, // destructibleParameters.runtimeFracture.glass
	{ TYPE_U32, false, (size_t)(&((FractureGlass_Type*)0)->numSectors), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.numSectors
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->sectorRand), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.sectorRand
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->firstSegmentSize), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.firstSegmentSize
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->segmentScale), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.segmentScale
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->segmentRand), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.segmentRand
	{ TYPE_STRUCT, false, (size_t)(&((RuntimeFracture_Type*)0)->voronoi), CHILDREN(85), 4 }, // destructibleParameters.runtimeFracture.voronoi
	{ TYPE_VEC3, false, (size_t)(&((FractureVoronoi_Type*)0)->dimensions), NULL, 0 }, // destructibleParameters.runtimeFracture.voronoi.dimensions
	{ TYPE_U32, false, (size_t)(&((FractureVoronoi_Type*)0)->numCells), NULL, 0 }, // destructibleParameters.runtimeFracture.voronoi.numCells
	{ TYPE_F32, false, (size_t)(&((FractureVoronoi_Type*)0)->biasExp), NULL, 0 }, // destructibleParameters.runtimeFracture.voronoi.biasExp
	{ TYPE_F32, false, (size_t)(&((FractureVoronoi_Type*)0)->maxDist), NULL, 0 }, // destructibleParameters.runtimeFracture.voronoi.maxDist
	{ TYPE_STRUCT, false, (size_t)(&((RuntimeFracture_Type*)0)->attachment), CHILDREN(89), 6 }, // destructibleParameters.runtimeFracture.attachment
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posX), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posX
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negX), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negX
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posY), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posY
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negY), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negY
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posZ), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posZ
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negZ), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negZ
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->supportStrength), NULL, 0 }, // destructibleParameters.supportStrength
	{ TYPE_I8, false, (size_t)(&((DestructibleParameters_Type*)0)->legacyChunkBoundsTestSetting), NULL, 0 }, // destructibleParameters.legacyChunkBoundsTestSetting
	{ TYPE_I8, false, (size_t)(&((DestructibleParameters_Type*)0)->legacyDamageRadiusSpreadSetting), NULL, 0 }, // destructibleParameters.legacyDamageRadiusSpreadSetting
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->depthParameters), CHILDREN(95), 1 }, // depthParameters
	{ TYPE_STRUCT, false, 1 * sizeof(DestructibleDepthParameters_Type), CHILDREN(96), 9 }, // depthParameters[]
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->OVERRIDE_IMPACT_DAMAGE), NULL, 0 }, // depthParameters[].OVERRIDE_IMPACT_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->OVERRIDE_IMPACT_DAMAGE_VALUE), NULL, 0 }, // depthParameters[].OVERRIDE_IMPACT_DAMAGE_VALUE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_POSE_UPDATES), NULL, 0 }, // depthParameters[].IGNORE_POSE_UPDATES
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_RAYCAST_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_RAYCAST_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_CONTACT_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_CONTACT_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_0), NULL, 0 }, // depthParameters[].USER_FLAG_0
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_1), NULL, 0 }, // depthParameters[].USER_FLAG_1
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_2), NULL, 0 }, // depthParameters[].USER_FLAG_2
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_3), NULL, 0 }, // depthParameters[].USER_FLAG_3
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->shapeDescTemplate), CHILDREN(105), 8 }, // shapeDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((ShapeDescTemplate_Type*)0)->flags), CHILDREN(113), 20 }, // shapeDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_ENTER), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_LEAVE), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_STAY), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_STAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_VISUALIZATION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_VISUALIZATION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FEATURE_INDICES), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FEATURE_INDICES
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_RAYCASTING), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_POINT_CONTACT_FORCE), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_RESPONSE), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DYNAMIC_DYNAMIC_CCD), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_SCENE_QUERIES), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY
	{ TYPE_U16, false, (size_t)(&((ShapeDescTemplate_Type*)0)->collisionGroup), NULL, 0 }, // shapeDescTemplate.collisionGroup
	{ TYPE_STRUCT, false, (size_t)(&((ShapeDescTemplate_Type*)0)->groupsMask), CHILDREN(133), 5 }, // shapeDescTemplate.groupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // shapeDescTemplate.groupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // shapeDescTemplate.groupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // shapeDescTemplate.groupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // shapeDescTemplate.groupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // shapeDescTemplate.groupsMask.bits3
	{ TYPE_U16, false, (size_t)(&((ShapeDescTemplate_Type*)0)->materialIndex), NULL, 0 }, // shapeDescTemplate.materialIndex
	{ TYPE_F32, false, (size_t)(&((ShapeDescTemplate_Type*)0)->density), NULL, 0 }, // shapeDescTemplate.density
	{ TYPE_F32, false, (size_t)(&((ShapeDescTemplate_Type*)0)->skinWidth), NULL, 0 }, // shapeDescTemplate.skinWidth
	{ TYPE_U64, false, (size_t)(&((ShapeDescTemplate_Type*)0)->userData), NULL, 0 }, // shapeDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((ShapeDescTemplate_Type*)0)->name), NULL, 0 }, // shapeDescTemplate.name
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->actorDescTemplate), CHILDREN(138), 9 }, // actorDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((ActorDescTemplate_Type*)0)->flags), CHILDREN(147), 7 }, // actorDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_DISABLE_COLLISION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_DISABLE_RESPONSE), NULL, 0 }, // actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_LOCK_COM), NULL, 0 }, // actorDescTemplate.flags.NX_AF_LOCK_COM
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_FLUID_DISABLE_COLLISION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_CONTACT_MODIFICATION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_FORCE_CONE_FRICTION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_USER_ACTOR_PAIR_FILTERING), NULL, 0 }, // actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING
	{ TYPE_F32, false, (size_t)(&((ActorDescTemplate_Type*)0)->density), NULL, 0 }, // actorDescTemplate.density
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->actorCollisionGroup), NULL, 0 }, // actorDescTemplate.actorCollisionGroup
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->dominanceGroup), NULL, 0 }, // actorDescTemplate.dominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((ActorDescTemplate_Type*)0)->contactReportFlags), CHILDREN(154), 12 }, // actorDescTemplate.contactReportFlags
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_IGNORE_PAIR), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_START_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_END_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_IMPACT), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_ROLL), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_SLIDE), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_FORCES), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_CONTACT_MODIFICATION), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->forceFieldMaterial), NULL, 0 }, // actorDescTemplate.forceFieldMaterial
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->userData), NULL, 0 }, // actorDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->name), NULL, 0 }, // actorDescTemplate.name
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->compartment), NULL, 0 }, // actorDescTemplate.compartment
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->bodyDescTemplate), CHILDREN(166), 12 }, // bodyDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((BodyDescTemplate_Type*)0)->flags), CHILDREN(178), 4 }, // bodyDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_DISABLE_GRAVITY), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_FILTER_SLEEP_VEL), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_ENERGY_SLEEP_TEST), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_VISUALIZATION), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_VISUALIZATION
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->wakeUpCounter), NULL, 0 }, // bodyDescTemplate.wakeUpCounter
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->linearDamping), NULL, 0 }, // bodyDescTemplate.linearDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->angularDamping), NULL, 0 }, // bodyDescTemplate.angularDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->maxAngularVelocity), NULL, 0 }, // bodyDescTemplate.maxAngularVelocity
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->CCDMotionThreshold), NULL, 0 }, // bodyDescTemplate.CCDMotionThreshold
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepLinearVelocity), NULL, 0 }, // bodyDescTemplate.sleepLinearVelocity
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepAngularVelocity), NULL, 0 }, // bodyDescTemplate.sleepAngularVelocity
	{ TYPE_U32, false, (size_t)(&((BodyDescTemplate_Type*)0)->solverIterationCount), NULL, 0 }, // bodyDescTemplate.solverIterationCount
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepEnergyThreshold), NULL, 0 }, // bodyDescTemplate.sleepEnergyThreshold
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepDamping), NULL, 0 }, // bodyDescTemplate.sleepDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->contactReportThreshold), NULL, 0 }, // bodyDescTemplate.contactReportThreshold
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->p3ShapeDescTemplate), CHILDREN(182), 8 }, // p3ShapeDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->flags), CHILDREN(190), 6 }, // p3ShapeDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->eSIMULATION_SHAPE), NULL, 0 }, // p3ShapeDescTemplate.flags.eSIMULATION_SHAPE
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->eSCENE_QUERY_SHAPE), NULL, 0 }, // p3ShapeDescTemplate.flags.eSCENE_QUERY_SHAPE
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->eTRIGGER_SHAPE), NULL, 0 }, // p3ShapeDescTemplate.flags.eTRIGGER_SHAPE
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->eVISUALIZATION), NULL, 0 }, // p3ShapeDescTemplate.flags.eVISUALIZATION
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->ePARTICLE_DRAIN), NULL, 0 }, // p3ShapeDescTemplate.flags.ePARTICLE_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((P3ShapeFlags_Type*)0)->eDEFORMABLE_DRAIN), NULL, 0 }, // p3ShapeDescTemplate.flags.eDEFORMABLE_DRAIN
	{ TYPE_STRUCT, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->simulationFilterData), CHILDREN(196), 4 }, // p3ShapeDescTemplate.simulationFilterData
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word0), NULL, 0 }, // p3ShapeDescTemplate.simulationFilterData.word0
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word1), NULL, 0 }, // p3ShapeDescTemplate.simulationFilterData.word1
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word2), NULL, 0 }, // p3ShapeDescTemplate.simulationFilterData.word2
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word3), NULL, 0 }, // p3ShapeDescTemplate.simulationFilterData.word3
	{ TYPE_STRUCT, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->queryFilterData), CHILDREN(200), 4 }, // p3ShapeDescTemplate.queryFilterData
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word0), NULL, 0 }, // p3ShapeDescTemplate.queryFilterData.word0
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word1), NULL, 0 }, // p3ShapeDescTemplate.queryFilterData.word1
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word2), NULL, 0 }, // p3ShapeDescTemplate.queryFilterData.word2
	{ TYPE_U32, false, (size_t)(&((P3FilterData_Type*)0)->word3), NULL, 0 }, // p3ShapeDescTemplate.queryFilterData.word3
	{ TYPE_U64, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->material), NULL, 0 }, // p3ShapeDescTemplate.material
	{ TYPE_F32, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->contactOffset), NULL, 0 }, // p3ShapeDescTemplate.contactOffset
	{ TYPE_F32, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->restOffset), NULL, 0 }, // p3ShapeDescTemplate.restOffset
	{ TYPE_U64, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->userData), NULL, 0 }, // p3ShapeDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((P3ShapeDescTemplate_Type*)0)->name), NULL, 0 }, // p3ShapeDescTemplate.name
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->p3ActorDescTemplate), CHILDREN(204), 7 }, // p3ActorDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->flags), CHILDREN(211), 3 }, // p3ActorDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((P3ActorFlags_Type*)0)->eVISUALIZATION), NULL, 0 }, // p3ActorDescTemplate.flags.eVISUALIZATION
	{ TYPE_BOOL, false, (size_t)(&((P3ActorFlags_Type*)0)->eDISABLE_GRAVITY), NULL, 0 }, // p3ActorDescTemplate.flags.eDISABLE_GRAVITY
	{ TYPE_BOOL, false, (size_t)(&((P3ActorFlags_Type*)0)->eSEND_SLEEP_NOTIFIES), NULL, 0 }, // p3ActorDescTemplate.flags.eSEND_SLEEP_NOTIFIES
	{ TYPE_U8, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->dominanceGroup), NULL, 0 }, // p3ActorDescTemplate.dominanceGroup
	{ TYPE_U8, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->ownerClient), NULL, 0 }, // p3ActorDescTemplate.ownerClient
	{ TYPE_U32, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->clientBehaviorBits), NULL, 0 }, // p3ActorDescTemplate.clientBehaviorBits
	{ TYPE_STRUCT, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->contactReportFlags), CHILDREN(214), 15 }, // p3ActorDescTemplate.contactReportFlags
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eRESOLVE_CONTACTS), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eRESOLVE_CONTACTS
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eMODIFY_CONTACTS), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eMODIFY_CONTACTS
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_TOUCH_FOUND), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_FOUND
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_TOUCH_PERSISTS), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_PERSISTS
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_TOUCH_LOST), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_LOST
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_THRESHOLD_FORCE_FOUND), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_FOUND
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_THRESHOLD_FORCE_PERSISTS), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_PERSISTS
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_THRESHOLD_FORCE_LOST), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_LOST
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_CONTACT_POINTS), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_POINTS
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_CONTACT_FORCES), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCES
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_CONTACT_FORCE_PER_POINT), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCE_PER_POINT
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eNOTIFY_CONTACT_FEATURE_INDICES_PER_POINT), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FEATURE_INDICES_PER_POINT
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eCCD_LINEAR), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eCCD_LINEAR
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eCONTACT_DEFAULT), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eCONTACT_DEFAULT
	{ TYPE_BOOL, false, (size_t)(&((P3PairFlag_Type*)0)->eTRIGGER_DEFAULT), NULL, 0 }, // p3ActorDescTemplate.contactReportFlags.eTRIGGER_DEFAULT
	{ TYPE_U64, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->userData), NULL, 0 }, // p3ActorDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((P3ActorDescTemplate_Type*)0)->name), NULL, 0 }, // p3ActorDescTemplate.name
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->p3BodyDescTemplate), CHILDREN(229), 11 }, // p3BodyDescTemplate
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->density), NULL, 0 }, // p3BodyDescTemplate.density
	{ TYPE_STRUCT, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->flags), CHILDREN(240), 2 }, // p3BodyDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((P3BodyDescFlags_Type*)0)->eKINEMATIC), NULL, 0 }, // p3BodyDescTemplate.flags.eKINEMATIC
	{ TYPE_BOOL, false, (size_t)(&((P3BodyDescFlags_Type*)0)->eENABLE_CCD), NULL, 0 }, // p3BodyDescTemplate.flags.eENABLE_CCD
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->sleepThreshold), NULL, 0 }, // p3BodyDescTemplate.sleepThreshold
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->wakeUpCounter), NULL, 0 }, // p3BodyDescTemplate.wakeUpCounter
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->linearDamping), NULL, 0 }, // p3BodyDescTemplate.linearDamping
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->angularDamping), NULL, 0 }, // p3BodyDescTemplate.angularDamping
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->maxAngularVelocity), NULL, 0 }, // p3BodyDescTemplate.maxAngularVelocity
	{ TYPE_U32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->solverIterationCount), NULL, 0 }, // p3BodyDescTemplate.solverIterationCount
	{ TYPE_U32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->velocityIterationCount), NULL, 0 }, // p3BodyDescTemplate.velocityIterationCount
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->contactReportThreshold), NULL, 0 }, // p3BodyDescTemplate.contactReportThreshold
	{ TYPE_F32, false, (size_t)(&((P3BodyDescTemplate_Type*)0)->sleepLinearVelocity), NULL, 0 }, // p3BodyDescTemplate.sleepLinearVelocity
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->structureSettings), CHILDREN(242), 3 }, // structureSettings
	{ TYPE_BOOL, false, (size_t)(&((StructureSettings_Type*)0)->useStressSolver), NULL, 0 }, // structureSettings.useStressSolver
	{ TYPE_F32, false, (size_t)(&((StructureSettings_Type*)0)->stressSolverTimeDelay), NULL, 0 }, // structureSettings.stressSolverTimeDelay
	{ TYPE_F32, false, (size_t)(&((StructureSettings_Type*)0)->stressSolverMassThreshold), NULL, 0 }, // structureSettings.stressSolverMassThreshold
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->defaultBehaviorGroup), CHILDREN(245), 12 }, // defaultBehaviorGroup
	{ TYPE_STRING, false, (size_t)(&((BehaviorGroup_Type*)0)->name), NULL, 0 }, // defaultBehaviorGroup.name
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageThreshold), NULL, 0 }, // defaultBehaviorGroup.damageThreshold
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageToRadius), NULL, 0 }, // defaultBehaviorGroup.damageToRadius
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageSpread), CHILDREN(257), 3 }, // defaultBehaviorGroup.damageSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // defaultBehaviorGroup.damageSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // defaultBehaviorGroup.damageSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // defaultBehaviorGroup.damageSpread.falloffExponent
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorSpread), CHILDREN(260), 3 }, // defaultBehaviorGroup.damageColorSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.falloffExponent
	{ TYPE_VEC4, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorChange), NULL, 0 }, // defaultBehaviorGroup.damageColorChange
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->materialStrength), NULL, 0 }, // defaultBehaviorGroup.materialStrength
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->density), NULL, 0 }, // defaultBehaviorGroup.density
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->fadeOut), NULL, 0 }, // defaultBehaviorGroup.fadeOut
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->maxDepenetrationVelocity), NULL, 0 }, // defaultBehaviorGroup.maxDepenetrationVelocity
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->groupsMask), CHILDREN(263), 5 }, // defaultBehaviorGroup.groupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // defaultBehaviorGroup.groupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // defaultBehaviorGroup.groupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // defaultBehaviorGroup.groupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // defaultBehaviorGroup.groupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // defaultBehaviorGroup.groupsMask.bits3
	{ TYPE_U64, false, (size_t)(&((BehaviorGroup_Type*)0)->userData), NULL, 0 }, // defaultBehaviorGroup.userData
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->behaviorGroups), CHILDREN(268), 1 }, // behaviorGroups
	{ TYPE_STRUCT, false, 1 * sizeof(BehaviorGroup_Type), CHILDREN(269), 12 }, // behaviorGroups[]
	{ TYPE_STRING, false, (size_t)(&((BehaviorGroup_Type*)0)->name), NULL, 0 }, // behaviorGroups[].name
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageThreshold), NULL, 0 }, // behaviorGroups[].damageThreshold
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageToRadius), NULL, 0 }, // behaviorGroups[].damageToRadius
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageSpread), CHILDREN(281), 3 }, // behaviorGroups[].damageSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // behaviorGroups[].damageSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // behaviorGroups[].damageSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // behaviorGroups[].damageSpread.falloffExponent
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorSpread), CHILDREN(284), 3 }, // behaviorGroups[].damageColorSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // behaviorGroups[].damageColorSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // behaviorGroups[].damageColorSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // behaviorGroups[].damageColorSpread.falloffExponent
	{ TYPE_VEC4, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorChange), NULL, 0 }, // behaviorGroups[].damageColorChange
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->materialStrength), NULL, 0 }, // behaviorGroups[].materialStrength
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->density), NULL, 0 }, // behaviorGroups[].density
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->fadeOut), NULL, 0 }, // behaviorGroups[].fadeOut
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->maxDepenetrationVelocity), NULL, 0 }, // behaviorGroups[].maxDepenetrationVelocity
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->groupsMask), CHILDREN(287), 5 }, // behaviorGroups[].groupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // behaviorGroups[].groupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // behaviorGroups[].groupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // behaviorGroups[].groupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // behaviorGroups[].groupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // behaviorGroups[].groupsMask.bits3
	{ TYPE_U64, false, (size_t)(&((BehaviorGroup_Type*)0)->userData), NULL, 0 }, // behaviorGroups[].userData
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->deleteChunksLeavingUserDefinedBB), NULL, 0 }, // deleteChunksLeavingUserDefinedBB
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->deleteChunksEnteringUserDefinedBB), NULL, 0 }, // deleteChunksEnteringUserDefinedBB
};


bool DestructibleActorParam_0p29::mBuiltFlag = false;
NvParameterized::MutexType DestructibleActorParam_0p29::mBuiltFlagMutex;

DestructibleActorParam_0p29::DestructibleActorParam_0p29(NvParameterized::Traits* traits, void* buf, int32_t* refCount) :
	NvParameters(traits, buf, refCount)
{
	//mParameterizedTraits->registerFactory(className(), &DestructibleActorParam_0p29FactoryInst);

	if (!buf) //Do not init data if it is inplace-deserialized
	{
		initDynamicArrays();
		initStrings();
		initReferences();
		initDefaults();
	}
}

DestructibleActorParam_0p29::~DestructibleActorParam_0p29()
{
	freeStrings();
	freeReferences();
	freeDynamicArrays();
}

void DestructibleActorParam_0p29::destroy()
{
	// We cache these fields here to avoid overwrite in destructor
	bool doDeallocateSelf = mDoDeallocateSelf;
	NvParameterized::Traits* traits = mParameterizedTraits;
	int32_t* refCount = mRefCount;
	void* buf = mBuffer;

	this->~DestructibleActorParam_0p29();

	NvParameters::destroy(this, traits, doDeallocateSelf, refCount, buf);
}

const NvParameterized::DefinitionImpl* DestructibleActorParam_0p29::getParameterDefinitionTree(void)
{
	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

const NvParameterized::DefinitionImpl* DestructibleActorParam_0p29::getParameterDefinitionTree(void) const
{
	DestructibleActorParam_0p29* tmpParam = const_cast<DestructibleActorParam_0p29*>(this);

	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			tmpParam->buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

NvParameterized::ErrorType DestructibleActorParam_0p29::getParameterHandle(const char* long_name, Handle& handle) const
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

NvParameterized::ErrorType DestructibleActorParam_0p29::getParameterHandle(const char* long_name, Handle& handle)
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

void DestructibleActorParam_0p29::getVarPtr(const Handle& handle, void*& ptr, size_t& offset) const
{
	ptr = getVarPtrHelper(&ParamLookupTable[0], const_cast<DestructibleActorParam_0p29::ParametersStruct*>(&parameters()), handle, offset);
}


/* Dynamic Handle Indices */
/* [0] - overrideSkinnedMaterialNames (not an array of structs) */
/* [0] - overrideStaticMaterialNames (not an array of structs) */
/* [1,0] - behaviorGroups.name */

void DestructibleActorParam_0p29::freeParameterDefinitionTable(NvParameterized::Traits* traits)
{
	if (!traits)
	{
		return;
	}

	if (!mBuiltFlag) // Double-checked lock
	{
		return;
	}

	NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);

	if (!mBuiltFlag)
	{
		return;
	}

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		ParamDefTable[i].~DefinitionImpl();
	}

	traits->free(ParamDefTable);

	mBuiltFlag = false;
}

#define PDEF_PTR(index) (&ParamDefTable[index])

void DestructibleActorParam_0p29::buildTree(void)
{

	uint32_t allocSize = sizeof(NvParameterized::DefinitionImpl) * NumParamDefs;
	ParamDefTable = (NvParameterized::DefinitionImpl*)(mParameterizedTraits->alloc(allocSize));
	memset(ParamDefTable, 0, allocSize);

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		NV_PARAM_PLACEMENT_NEW(ParamDefTable + i, NvParameterized::DefinitionImpl)(*mParameterizedTraits);
	}

	// Initialize DefinitionImpl node: nodeIndex=0, longName=""
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[0];
		ParamDef->init("", TYPE_STRUCT, "STRUCT", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=1, longName="crumbleEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[1];
		ParamDef->init("crumbleEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the NxMeshParticleSystem to use for crumbling.  This overrides the crumble system defined\nin the NxDestructibleAsset if specified.\n", true);
		HintTable[1].init("shortDescription", "The name of the NxMeshParticleSystem to use for crumbling", true);
		ParamDefTable[1].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=2, longName="crumbleParticleSpacing"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[2];
		ParamDef->init("crumbleParticleSpacing", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How far apart to space the particles when crumling.  If set to zero or a negative value, then the spacing is taken to be the crumble emitter's particle radius, if the\ncrumble emitter exists.  This spacing will be used when placing particle positions in the crumble emitter and the crumble buffer callback.  Note - if there is no crumble emitter\nbut there is a crumble buffer callback, then this value must be positive in order to have a proper spacing for the callback.  Otherwise, the callback will not be called.\nThe default value is 0.\n", true);
		HintTable[1].init("shortDescription", "How far apart to space the particles when crumbling", true);
		ParamDefTable[2].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=3, longName="dustEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[3];
		ParamDef->init("dustEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the NxMeshParticleSystem to use for fracture-line dust.  This overrides the dust system defined\nin the NxDestructibleAsset if specified.\n", true);
		HintTable[1].init("shortDescription", "The name of the NxMeshParticleSystem to use for fracture-line dust", true);
		ParamDefTable[3].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=4, longName="dustParticleSpacing"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[4];
		ParamDef->init("dustParticleSpacing", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How far apart to space the particles when crumling.  If set to zero or a negative value, then the spacing is taken to be the dust emitter's particle radius, if the\ndust emitter exists.  This spacing will be used when placing particle positions in the dust emitter and the dust particle buffer callback.  Note - if there is no dust emitter\nbut there is a dust particle buffer callback, then this value must be positive in order to have a proper spacing for the callback.  Otherwise, the callback will not be called.\nThe default value is 0.\n", true);
		HintTable[1].init("shortDescription", "How far apart to space the particles when creating dust particles", true);
		ParamDefTable[4].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=5, longName="globalPose"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[5];
		ParamDef->init("globalPose", TYPE_MAT34, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Initial global pose of undamaged destructible\n", true);
		HintTable[1].init("shortDescription", "The initial pose where the destructible actor will be put into the scene", true);
		ParamDefTable[5].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=6, longName="scale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[6];
		ParamDef->init("scale", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "3D Scale\n", true);
		HintTable[1].init("shortDescription", "3D Scale", true);
		ParamDefTable[6].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=7, longName="dynamic"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[7];
		ParamDef->init("dynamic", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the destructible starts life as a dynamic actor\n", true);
		HintTable[1].init("shortDescription", "Whether or not the destructible starts life as a dynamic actor", true);
		ParamDefTable[7].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=8, longName="supportDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[8];
		ParamDef->init("supportDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which to create a support graph.  Higher depth levels give more detailed support,\nbut will give a higher computational load.  Chunks below the support depth will never be supported.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which to create a support graph.", true);
		ParamDefTable[8].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=9, longName="formExtendedStructures"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[9];
		ParamDef->init("formExtendedStructures", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If initially static, the destructible will become part of an extended support structure if it is\nin contact with another static destructible that also has this flag set.\n", true);
		HintTable[1].init("shortDescription", "If initially static, the destructible will become part of an extended support structure if it is in contact with another static destructible that also has this flag set.", true);
		ParamDefTable[9].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=10, longName="performDetailedOverlapTestForExtendedStructures"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[10];
		ParamDef->init("performDetailedOverlapTestForExtendedStructures", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When testing for chunk overlap with other destructibles in an extended structure (see formExtendedStructures), perform detailed collision test.  Otherwise, just test AABBs.\nDefault = TRUE.\n", true);
		HintTable[1].init("shortDescription", "When testing for chunk overlap with other destructibles, perform detailed collision test.  Otherwise, just test AABBs.", true);
		ParamDefTable[10].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=11, longName="keepPreviousFrameBoneBuffer"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[11];
		ParamDef->init("keepPreviousFrameBoneBuffer", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, the skinned mesh will hold a bone buffer for the last frame.  The poses in the new buffer correspond the poses in the current frame buffer,\n				chunk was not visible in the last frame.", true);
		HintTable[1].init("shortDescription", "If true, the skinned mesh will hold a bone buffer for the last frame", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=12, longName="doNotCreateRenderable"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[12];
		ParamDef->init("doNotCreateRenderable", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, a renderable will not be created for the destructible actor.  This prevents unnecessary updates when the APEX render API is not being used.", true);
		HintTable[1].init("shortDescription", "If true, a renderable will not be created for the destructible actor", true);
		ParamDefTable[12].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=13, longName="useAssetDefinedSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[13];
		ParamDef->init("useAssetDefinedSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which are tagged as 'support' chunks (via NxDestructibleChunkDesc::isSupportChunk)\nwill have environmental support in static destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which are tagged as 'support' chunks", true);
		ParamDefTable[13].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=14, longName="useWorldSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[14];
		ParamDef->init("useWorldSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which overlap the NxScene\'s static geometry will have environmental support in\nstatic destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which overlap the NxScene's static geometry will have environmental support", true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=15, longName="renderStaticChunksSeparately"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[15];
		ParamDef->init("renderStaticChunksSeparately", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, static chunks will be renderered separately from dynamic chunks, as a single mesh (not using skinning).\nThis parameter is ignored if the \'dynamic\' parameter is true.\nDefault value = false.\n", true);
		HintTable[1].init("shortDescription", "Whether or not to render static chunks in a separate mesh", true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=16, longName="keepVisibleBonesPacked"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[16];
		ParamDef->init("keepVisibleBonesPacked", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameter passed into skinned ApexRenderMeshActor.  If true, visible bone matrices are packed into the bone render buffer, and a per-actor vertex buffer is created to handle re-indexed bones.\nDefault value = true.\n", true);
		HintTable[1].init("shortDescription", "Parameter passed into skinned ApexRenderMeshActor", true);
		ParamDefTable[16].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=17, longName="createChunkEvents"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[17];
		ParamDef->init("createChunkEvents", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not to create an event buffer for chunk.\nIf true, the user has access to a chunk event buffer, which currently holds visibility state change events.\nThe user must empty this buffer themselves after reading, otherwise it will continue to grow as new events are added.\nDefault value = false.\n", true);
		HintTable[1].init("shortDescription", "Whether or not to create an event buffer for chunks", true);
		ParamDefTable[17].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=18, longName="overrideSkinnedMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[18];
		ParamDef->init("overrideSkinnedMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for skinned rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for skinned rendering", true);
		ParamDefTable[18].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=19, longName="overrideSkinnedMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[19];
		ParamDef->init("overrideSkinnedMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for skinned rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for skinned rendering", true);
		ParamDefTable[19].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=20, longName="overrideStaticMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[20];
		ParamDef->init("overrideStaticMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for static rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for static rendering", true);
		ParamDefTable[20].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=21, longName="overrideStaticMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[21];
		ParamDef->init("overrideStaticMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for static rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for static rendering", true);
		ParamDefTable[21].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=22, longName="sleepVelocityFrameDecayConstant"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[22];
		ParamDef->init("sleepVelocityFrameDecayConstant", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Frame memory decay constant used for actor velocity smoothing.  Valid range: [1.0,infinity).  Roughly speaking,\n				the number of frames for which past velocities have significance.  A value of 1.0 (or less) gives no smoothing.", true);
		HintTable[1].init("shortDescription", "Frame memory decay constant used for actor velocity smoothing.  Valid range: [1.0,infinity).", true);
		ParamDefTable[22].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=23, longName="useHardSleeping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[23];
		ParamDef->init("useHardSleeping", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, turn chunk islands kinematic when they sleep.  These islands may be turned dynamic again if enough damage is applied.", true);
		HintTable[1].init("shortDescription", "If true, turn chunk islands kinematic when they sleep.", true);
		ParamDefTable[23].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=24, longName="destructibleParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[24];
		ParamDef->init("destructibleParameters", TYPE_STRUCT, "DestructibleParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters controlling the destruction properties - damage thresholds, damage radius multipliers, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters controlling the destruction properties - damage thresholds, damage radius multipliers, etc.", true);
		ParamDefTable[24].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=25, longName="destructibleParameters.damageCap"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[25];
		ParamDef->init("damageCap", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Limits the amount of damage applied to a chunk.  This is useful for preventing the entire destructible\nfrom getting pulverized by a very large application of damage.  This can easily happen when impact damage is\nused, and the damage amount is proportional to the impact force (see forceToDamage).\n", true);
		HintTable[1].init("shortDescription", "Limits the amount of damage applied to a chunk.", true);
		ParamDefTable[25].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=26, longName="destructibleParameters.forceToDamage"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[26];
		ParamDef->init("forceToDamage", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk is at a depth which takes impact damage (see NxDestructibleDepthParameters),\nthen when a chunk has a collision in the NxScene, it will take damage equal to forceToDamage mulitplied by\nthe impact force.\nThe default value is zero, which effectively disables impact damage.\n", true);
		HintTable[1].init("shortDescription", "Multiplier to calculate applied damage from an impact.", true);
		ParamDefTable[26].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=27, longName="destructibleParameters.impactVelocityThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[27];
		ParamDef->init("impactVelocityThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.  In this case the relative velocity of the two\nobjects will be low.  This variable allows the user to set a minimum velocity threshold for impacts to ensure that the objects are\nmoving at a min velocity in order for the impact force to be considered.\n", true);
		HintTable[1].init("shortDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.", true);
		ParamDefTable[27].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=28, longName="destructibleParameters.minimumFractureDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[28];
		ParamDef->init("minimumFractureDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks will not be broken free below this depth.\n", true);
		HintTable[1].init("shortDescription", "The chunks will not be broken free below this depth.", true);
		ParamDefTable[28].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=29, longName="destructibleParameters.impactDamageDefaultDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[29];
		ParamDef->init("impactDamageDefaultDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default depth to which chunks will take impact damage.  This default may be overridden in the depth settings.\n", true);
		HintTable[1].init("shortDescription", "The default depth to which chunks will take impact damage.", true);
		ParamDefTable[29].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=30, longName="destructibleParameters.debrisDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[30];
		ParamDef->init("debrisDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'  Chunks at this depth or\nbelow will be considered for various debris settings, such as debrisLifetime.\nNegative values indicate that no chunk depth is considered debris.\nDefault value is -1.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'", true);
		ParamDefTable[30].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=31, longName="destructibleParameters.essentialDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[31];
		ParamDef->init("essentialDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth up to which chunks will always be processed.  These chunks are considered\nto be essential either for gameplay or visually.\nThe minimum value is 0, meaning the level 0 chunk is always considered essential.\nDefault value is 0.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth up to which chunks will always be processed", true);
		ParamDefTable[31].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=32, longName="destructibleParameters.debrisLifetimeMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[32];
		ParamDef->init("debrisLifetimeMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin and debrisLifetimeMax (see below), based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum time to destroy debris", true);
		ParamDefTable[32].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=33, longName="destructibleParameters.debrisLifetimeMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[33];
		ParamDef->init("debrisLifetimeMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin (see above) and debrisLifetimeMax, based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Maximum time to destroy debris", true);
		ParamDefTable[33].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=34, longName="destructibleParameters.debrisMaxSeparationMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[34];
		ParamDef->init("debrisMaxSeparationMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin and debrisMaxSeparationMax (see below),\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[34].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=35, longName="destructibleParameters.debrisMaxSeparationMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[35];
		ParamDef->init("debrisMaxSeparationMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin (see above) and debrisMaxSeparationMax,\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[35].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=36, longName="destructibleParameters.debrisDestructionProbability"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[36];
		ParamDef->init("debrisDestructionProbability", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed instead of becoming dynamic or breaking down\n						further into child chunks.  Valid range = [0.0,1.0].  Default value = 0.0.", true);
		HintTable[1].init("shortDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed", true);
		ParamDefTable[36].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=37, longName="destructibleParameters.validBounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[37];
		ParamDef->init("validBounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A bounding box around each NxDestructibleActor created, defining a range of validity\nfor chunks that break free.  These bounds are scaled and translated with the\nNxDestructibleActor\'s scale and position, but they are not rotated with the\nNxDestructibleActor.\n", true);
		HintTable[1].init("shortDescription", "valid bounding region for debris", true);
		ParamDefTable[37].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=38, longName="destructibleParameters.maxChunkSpeed"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[38];
		ParamDef->init("maxChunkSpeed", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If greater than 0, the chunks' speeds will not be allowed to exceed this value.  Use 0\nto disable this feature (this is the default).\n", true);
		HintTable[1].init("shortDescription", "Maximum speed of a chunk", true);
		ParamDefTable[38].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=39, longName="destructibleParameters.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[39];
		ParamDef->init("flags", TYPE_STRUCT, "DestructibleParametersFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A collection of flags defined in NxDestructibleParametersFlag.\n", true);
		HintTable[1].init("shortDescription", "A collection of flags defined in DestructibleParametersFlag.", true);
		ParamDefTable[39].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=40, longName="destructibleParameters.flags.ACCUMULATE_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[40];
		ParamDef->init("ACCUMULATE_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, chunks will 'remember' damage applied to them, so that many applications of a damage amount\nbelow damageThreshold will eventually fracture the chunk.  If not set, a single application of\ndamage must exceed damageThreshold in order to fracture the chunk.\n", true);
		HintTable[1].init("shortDescription", "Determines if chunks accumulate damage", true);
		ParamDefTable[40].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=41, longName="destructibleParameters.flags.DEBRIS_TIMEOUT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[41];
		ParamDef->init("DEBRIS_TIMEOUT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill time out.  The lifetime is a value between NxDestructibleParameters::debrisLifetimeMin and\nNxDestructibleParameters::debrisLifetimeMax, based upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will timeout", true);
		ParamDefTable[41].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=42, longName="destructibleParameters.flags.DEBRIS_MAX_SEPARATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[42];
		ParamDef->init("DEBRIS_MAX_SEPARATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill be removed if they separate too far from their origins.  The maxSeparation is a value between\nNxDestructibleParameters::debrisMaxSeparationMin and NxDestructibleParameters::debrisMaxSeparationMax,\nbased upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will be removed if separated too far", true);
		ParamDefTable[42].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=43, longName="destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[43];
		ParamDef->init("CRUMBLE_SMALLEST_CHUNKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the smallest chunks may be further broken down, either by fluid crumbles (if a crumble particle\nsystem is specified in the NxDestructibleActorDesc), or by simply removing the chunk if no crumble\nparticle system is specified.  Note: the 'smallest chunks' are normally defined to be the deepest level\nof the fracture hierarchy.  However, they may be taken from higher levels of the hierarchy if\nNxModuleDestructible::setMaxChunkDepthOffset is called with a non-zero value.\n", true);
		HintTable[1].init("shortDescription", "If set, the smallest chunks may be further broken down", true);
		ParamDefTable[43].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=44, longName="destructibleParameters.flags.ACCURATE_RAYCASTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[44];
		ParamDef->init("ACCURATE_RAYCASTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit\nfor collisions with child chunks.  This is used to get a better raycast position and normal, in\ncase the parent collision volume does not tightly fit the graphics mesh.  The returned chunk index\nwill always be that of the visible parent that is intersected, however.\n", true);
		HintTable[1].init("shortDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit", true);
		ParamDefTable[44].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=45, longName="destructibleParameters.flags.USE_VALID_BOUNDS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[45];
		ParamDef->init("USE_VALID_BOUNDS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the validBounds field of NxDestructibleParameters will be used.  These bounds are translated\n(but not scaled or rotated) to the origin of the destructible actor.  If a chunk or chunk island moves\noutside of those bounds, it is destroyed.\n", true);
		HintTable[1].init("shortDescription", "If set, the validBounds field of NxDestructibleParameters will be used.", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=46, longName="destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[46];
		ParamDef->init("CRUMBLE_VIA_RUNTIME_FRACTURE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, crumbled chunks will use the runtime fracture pipeline. The chunk will be procedurally broken\ndestroyed using either the default or a specified fracture pattern.\n", true);
		HintTable[1].init("shortDescription", "If set, crumbled chunks will use the runtime fracture pipeline.", true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=47, longName="destructibleParameters.fractureImpulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[47];
		ParamDef->init("fractureImpulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.  This is used\nin order to 'push' the pieces out as they fracture.\n", true);
		HintTable[1].init("shortDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.", true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=48, longName="destructibleParameters.damageDepthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[48];
		ParamDef->init("damageDepthLimit", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How deep in the hierarchy damage will be propagated, relative to the chunk hit.", true);
		HintTable[1].init("shortDescription", "How deep in the hierarchy damage will be propagated, relative to the chunk hit.", true);
		ParamDefTable[48].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=49, longName="destructibleParameters.dynamicChunkDominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[49];
		ParamDef->init("dynamicChunkDominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional dominance group for dynamic chunks created when fractured. (ignored if > 31)\n", true);
		HintTable[1].init("shortDescription", "Optional dominance group for dynamic chunks created when fractured.", true);
		ParamDefTable[49].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=50, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[50];
		ParamDef->init("dynamicChunksGroupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.\n", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		ParamDefTable[50].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=51, longName="destructibleParameters.dynamicChunksGroupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[51];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[51].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=52, longName="destructibleParameters.dynamicChunksGroupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[52];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[52].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=53, longName="destructibleParameters.dynamicChunksGroupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[53];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[53].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=54, longName="destructibleParameters.dynamicChunksGroupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[54];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[54].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=55, longName="destructibleParameters.dynamicChunksGroupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[55];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[55].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=56, longName="destructibleParameters.runtimeFracture"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[56];
		ParamDef->init("runtimeFracture", TYPE_STRUCT, "RuntimeFracture", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Runtime Fracture Settings. 'CRUMBLE_VIA_RUNTIME_FRACTURE' must be set for this to do anything.\n", true);
		HintTable[1].init("shortDescription", "Runtime Fracture Settings", true);
		ParamDefTable[56].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=57, longName="destructibleParameters.runtimeFracture.RuntimeFractureType"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[57];
		ParamDef->init("RuntimeFractureType", TYPE_ENUM, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Which type of fracture pattern to choose", true);
		ParamDefTable[57].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */

		static const char* const EnumVals[] = { "VORONOI", "GLASS" };
		ParamDefTable[57].setEnumVals((const char**)EnumVals, 2);




	}

	// Initialize DefinitionImpl node: nodeIndex=58, longName="destructibleParameters.runtimeFracture.sheetFracture"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[58];
		ParamDef->init("sheetFracture", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, align fracture pattern to largest face. \nIf false, the fracture pattern will be aligned to the hit normal with each fracture.\n", true);
		HintTable[1].init("shortDescription", "If true, align fracture pattern to largest face", true);
		ParamDefTable[58].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=59, longName="destructibleParameters.runtimeFracture.depthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[59];
		ParamDef->init("depthLimit", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of times deep a chunk can be fractured. Can help limit the number of chunks produced by\nruntime fracture.\n", true);
		HintTable[1].init("shortDescription", "Number of times deep a chunk can be fractured.", true);
		ParamDefTable[59].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=60, longName="destructibleParameters.runtimeFracture.destroyIfAtDepthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[60];
		ParamDef->init("destroyIfAtDepthLimit", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, destroy chunks when they hit their depth limit. \nIf false, then chunks at their depth limit will not fracture but will have a force applied.\n", true);
		HintTable[1].init("shortDescription", "Destroy chunk if at depth limit", true);
		ParamDefTable[60].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=61, longName="destructibleParameters.runtimeFracture.minConvexSize"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[61];
		ParamDef->init("minConvexSize", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Minimum Convex Size. Minimum size of convex produced by a fracture.\n", true);
		HintTable[1].init("shortDescription", "Minimum Convex Size.", true);
		ParamDefTable[61].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=62, longName="destructibleParameters.runtimeFracture.impulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[62];
		ParamDef->init("impulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scales impulse applied by a fracture.\n", true);
		HintTable[1].init("shortDescription", "Scales impulse applied by a fracture.", true);
		ParamDefTable[62].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=63, longName="destructibleParameters.runtimeFracture.glass"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[63];
		ParamDef->init("glass", TYPE_STRUCT, "FractureGlass", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Glass Fracture Pattern Settings.\n", true);
		HintTable[1].init("shortDescription", "Glass Fracture Pattern Settings.", true);
		ParamDefTable[63].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=64, longName="destructibleParameters.runtimeFracture.glass.numSectors"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[64];
		ParamDef->init("numSectors", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of angular slices in the glass fracture pattern. \n", true);
		HintTable[1].init("shortDescription", "Number of angular slices.", true);
		ParamDefTable[64].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=65, longName="destructibleParameters.runtimeFracture.glass.sectorRand"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[65];
		ParamDef->init("sectorRand", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Creates variance in the angle of slices. A value of zero results in all angular slices having the same angle.\n", true);
		HintTable[1].init("shortDescription", "Creates variance in the angle of slices.", true);
		ParamDefTable[65].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=66, longName="destructibleParameters.runtimeFracture.glass.firstSegmentSize"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[66];
		ParamDef->init("firstSegmentSize", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum shard size. Shards below this size will not be created and thus not visible.\n", true);
		HintTable[1].init("shortDescription", "The minimum shard size.", true);
		ParamDefTable[66].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=67, longName="destructibleParameters.runtimeFracture.glass.segmentScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[67];
		ParamDef->init("segmentScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scales the radial spacing in the glass fracture pattern. A larger value results in radially longer shards.\n", true);
		HintTable[1].init("shortDescription", "Scales the radial spacing.", true);
		ParamDefTable[67].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=68, longName="destructibleParameters.runtimeFracture.glass.segmentRand"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[68];
		ParamDef->init("segmentRand", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Creates variance in the radial size of shards. A value of zero results in a low noise circular pattern.\n", true);
		HintTable[1].init("shortDescription", "Creates variance in the radial size of shards.", true);
		ParamDefTable[68].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=69, longName="destructibleParameters.runtimeFracture.voronoi"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[69];
		ParamDef->init("voronoi", TYPE_STRUCT, "FractureVoronoi", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Voronoi Fracture Pattern Settings.\n", true);
		HintTable[1].init("shortDescription", "Voronoi Fracture Pattern Settings.", true);
		ParamDefTable[69].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=70, longName="destructibleParameters.runtimeFracture.voronoi.dimensions"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[70];
		ParamDef->init("dimensions", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The size of the entire block. \n", true);
		HintTable[1].init("shortDescription", "The size of the entire block", true);
		ParamDefTable[70].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=71, longName="destructibleParameters.runtimeFracture.voronoi.numCells"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[71];
		ParamDef->init("numCells", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of Cells corresponds to the number of chunks to create during the fracture, default value is only one chunk.\n", true);
		HintTable[1].init("shortDescription", "Max Number of Cells to create.", true);
		ParamDefTable[71].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=72, longName="destructibleParameters.runtimeFracture.voronoi.biasExp"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[72];
		ParamDef->init("biasExp", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Bias Exponential value is used in distributing voronoi points which is used to fracture the original chunk.\n", true);
		HintTable[1].init("shortDescription", "Bias Exponential value.", true);
		ParamDefTable[72].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=73, longName="destructibleParameters.runtimeFracture.voronoi.maxDist"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[73];
		ParamDef->init("maxDist", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "This is to prevent a illegal voronoi point that's used to generate voronoi chunks.\n", true);
		HintTable[1].init("shortDescription", "The max distance a Voronoi point away from origin.", true);
		ParamDefTable[73].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=74, longName="destructibleParameters.runtimeFracture.attachment"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[74];
		ParamDef->init("attachment", TYPE_STRUCT, "FractureAttachment", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Attachment Settings. Allows the sides of a runtime fracture chunk to be kinematic rather than dynamic.\n", true);
		HintTable[1].init("shortDescription", "Attachment Settings", true);
		ParamDefTable[74].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=75, longName="destructibleParameters.runtimeFracture.attachment.posX"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[75];
		ParamDef->init("posX", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive x side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive x side of sheet.", true);
		ParamDefTable[75].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=76, longName="destructibleParameters.runtimeFracture.attachment.negX"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[76];
		ParamDef->init("negX", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative x side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative x side of sheet.", true);
		ParamDefTable[76].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=77, longName="destructibleParameters.runtimeFracture.attachment.posY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[77];
		ParamDef->init("posY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive y side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive y side of sheet.", true);
		ParamDefTable[77].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=78, longName="destructibleParameters.runtimeFracture.attachment.negY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[78];
		ParamDef->init("negY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative y side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative y side of sheet.", true);
		ParamDefTable[78].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=79, longName="destructibleParameters.runtimeFracture.attachment.posZ"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[79];
		ParamDef->init("posZ", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive z side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive z side of sheet.", true);
		ParamDefTable[79].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=80, longName="destructibleParameters.runtimeFracture.attachment.negZ"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[80];
		ParamDef->init("negZ", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative z side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative z side of sheet.", true);
		ParamDefTable[80].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=81, longName="destructibleParameters.supportStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[81];
		ParamDef->init("supportStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The larger the supportStrength is, the harder it will break under stressSolver. SupportStrength should be larger\nthan 0.0 so that it is not extremely fragile.\nDefault supportStrength = -1.0 which means strength is turned off initially.\n", true);
		HintTable[1].init("shortDescription", "The support strength threshold for breaking chunks in stressSolver", true);
		ParamDefTable[81].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=82, longName="destructibleParameters.legacyChunkBoundsTestSetting"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[82];
		ParamDef->init("legacyChunkBoundsTestSetting", TYPE_I8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not to use the old chunk bounds testing for damage, or use the module setting.  A value of 0 forces the new method to be used.\nA positive value forces the old method to be used.  Negative values cause the global (NxModuleDestructible) setting to be used.\n", true);
		HintTable[1].init("shortDescription", "Whether or not to use the old chunk bounds testing for damage, or use the module setting.", true);
		ParamDefTable[82].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=83, longName="destructibleParameters.legacyDamageRadiusSpreadSetting"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[83];
		ParamDef->init("legacyDamageRadiusSpreadSetting", TYPE_I8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("END", "", true);
		ParamDefTable[83].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("END", "", true);
		HintTable[1].init("longDescription", "Whether or not to use the old damage spread method, or use the module setting.  A value of 0 forces the new method to be used.\nA positive value forces the old method to be used.  Negative values cause the global (NxModuleDestructible) setting to be used.\n", true);
		HintTable[2].init("shortDescription", "Whether or not to use the old damage spread method, or use the module setting.", true);
		ParamDefTable[83].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=84, longName="depthParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[84];
		ParamDef->init("depthParameters", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters)\nthe element [0] of the array applies to the level 0 (unfractured) chunk, element [1] applies\nto the level 1 chunks, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters).", true);
		ParamDefTable[84].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=85, longName="depthParameters[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[85];
		ParamDef->init("depthParameters", TYPE_STRUCT, "DestructibleDepthParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters)\nthe element [0] of the array applies to the level 0 (unfractured) chunk, element [1] applies\nto the level 1 chunks, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters).", true);
		ParamDefTable[85].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=86, longName="depthParameters[].OVERRIDE_IMPACT_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[86];
		ParamDef->init("OVERRIDE_IMPACT_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE, no matter the setting of impactDamageDefaultDepth.\n", true);
		HintTable[1].init("shortDescription", "If true, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE, no matter the setting of impactDamageDefaultDepth.", true);
		ParamDefTable[86].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=87, longName="depthParameters[].OVERRIDE_IMPACT_DAMAGE_VALUE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[87];
		ParamDef->init("OVERRIDE_IMPACT_DAMAGE_VALUE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If OVERRIDE_IMPACT_DAMAGE = TRUE, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE.\n", true);
		HintTable[1].init("shortDescription", "If OVERRIDE_IMPACT_DAMAGE = TRUE, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE.", true);
		ParamDefTable[87].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=88, longName="depthParameters[].IGNORE_POSE_UPDATES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[88];
		ParamDef->init("IGNORE_POSE_UPDATES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should have pose updates ignored.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should have pose updates ignored.", true);
		ParamDefTable[88].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=89, longName="depthParameters[].IGNORE_RAYCAST_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[89];
		ParamDef->init("IGNORE_RAYCAST_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in raycast callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in raycast callbacks.", true);
		ParamDefTable[89].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=90, longName="depthParameters[].IGNORE_CONTACT_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[90];
		ParamDef->init("IGNORE_CONTACT_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in contact callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in contact callbacks.", true);
		ParamDefTable[90].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=91, longName="depthParameters[].USER_FLAG_0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[91];
		ParamDef->init("USER_FLAG_0", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[91].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=92, longName="depthParameters[].USER_FLAG_1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[92];
		ParamDef->init("USER_FLAG_1", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[92].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=93, longName="depthParameters[].USER_FLAG_2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[93];
		ParamDef->init("USER_FLAG_2", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[93].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=94, longName="depthParameters[].USER_FLAG_3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[94];
		ParamDef->init("USER_FLAG_3", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[94].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=95, longName="shapeDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[95];
		ParamDef->init("shapeDescTemplate", TYPE_STRUCT, "ShapeDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[95].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actor shapes created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actor shapes created", true);
		ParamDefTable[95].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=96, longName="shapeDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[96];
		ParamDef->init("flags", TYPE_STRUCT, "ShapeDescFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=97, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[97];
		ParamDef->init("NX_TRIGGER_ON_ENTER", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called when a shape enters the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called when a shape enters the trigger volume.", true);
		ParamDefTable[97].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=98, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[98];
		ParamDef->init("NX_TRIGGER_ON_LEAVE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called after a shape leaves the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called after a shape leaves the trigger volume.", true);
		ParamDefTable[98].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=99, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_STAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[99];
		ParamDef->init("NX_TRIGGER_ON_STAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called while a shape is intersecting the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called while a shape is intersecting the trigger volume.", true);
		ParamDefTable[99].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=100, longName="shapeDescTemplate.flags.NX_SF_VISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[100];
		ParamDef->init("NX_SF_VISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable debug renderer for shapes.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable debug renderer for shapes", true);
		ParamDefTable[100].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=101, longName="shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[101];
		ParamDef->init("NX_SF_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision detection for shapes (counterpart of NX_AF_DISABLE_COLLISION).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision detection for shapes (counterpart of NX_AF_DISABLE_COLLISION)", true);
		ParamDefTable[101].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=102, longName="shapeDescTemplate.flags.NX_SF_FEATURE_INDICES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[102];
		ParamDef->init("NX_SF_FEATURE_INDICES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable feature indices in contact stream.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable feature indices in contact stream.", true);
		ParamDefTable[102].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=103, longName="shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[103];
		ParamDef->init("NX_SF_DISABLE_RAYCASTING", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable raycasting for shapes.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable raycasting for shapes", true);
		ParamDefTable[103].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=104, longName="shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[104];
		ParamDef->init("NX_SF_POINT_CONTACT_FORCE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable contact force reporting per contact point in contact stream (otherwise we only report force per actor pair).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable contact force reporting per contact point in contact stream (otherwise we only report force per actor pair)", true);
		ParamDefTable[104].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=105, longName="shapeDescTemplate.flags.NX_SF_FLUID_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[105];
		ParamDef->init("NX_SF_FLUID_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a fluid drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a fluid drain.", true);
		ParamDefTable[105].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=106, longName="shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[106];
		ParamDef->init("NX_SF_FLUID_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with fluids.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with fluids.", true);
		ParamDefTable[106].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=107, longName="shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[107];
		ParamDef->init("NX_SF_FLUID_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shapes actor on fluid collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shapes actor on fluid collision.", true);
		ParamDefTable[107].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=108, longName="shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[108];
		ParamDef->init("NX_SF_DISABLE_RESPONSE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision response for shapes (counterpart of NX_AF_DISABLE_RESPONSE).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision response for shapes (counterpart of NX_AF_DISABLE_RESPONSE)", true);
		ParamDefTable[108].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=109, longName="shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[109];
		ParamDef->init("NX_SF_DYNAMIC_DYNAMIC_CCD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable dynamic-dynamic CCD for shapes. Used only when CCD is globally enabled and shape have a CCD skeleton.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable dynamic-dynamic CCD for shapes. Used only when CCD is globally enabled and shape have a CCD skeleton.", true);
		ParamDefTable[109].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=110, longName="shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[110];
		ParamDef->init("NX_SF_DISABLE_SCENE_QUERIES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable participation in ray casts, overlap tests and sweeps.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable participation in ray casts, overlap tests and sweeps.", true);
		ParamDefTable[110].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=111, longName="shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[111];
		ParamDef->init("NX_SF_CLOTH_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a cloth drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a cloth drain.", true);
		ParamDefTable[111].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=112, longName="shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[112];
		ParamDef->init("NX_SF_CLOTH_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with cloths.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with cloths.", true);
		ParamDefTable[112].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=113, longName="shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[113];
		ParamDef->init("NX_SF_CLOTH_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shapes actor on cloth collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shapes actor on cloth collision.", true);
		ParamDefTable[113].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=114, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[114];
		ParamDef->init("NX_SF_SOFTBODY_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a soft body drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a soft body drain.", true);
		ParamDefTable[114].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=115, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[115];
		ParamDef->init("NX_SF_SOFTBODY_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with soft bodies.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with soft bodies.", true);
		ParamDefTable[115].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=116, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[116];
		ParamDef->init("NX_SF_SOFTBODY_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shape's actor on soft body collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shape's actor on soft body collision.", true);
		ParamDefTable[116].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=117, longName="shapeDescTemplate.collisionGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[117];
		ParamDef->init("collisionGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets which collision group shapes are part of.\n						Default group is 0. Maximum possible group is 31. Collision groups are sets of shapes which may or may not be set to collision detect with each other; this can be set using NxScene::setGroupCollisionFlag() Sleeping: Does NOT wake the associated actor up automatically.  param[in] collisionGroup The collision group for shapes.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets which collision group shapes are part of.", true);
		ParamDefTable[117].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=118, longName="shapeDescTemplate.groupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[118];
		ParamDef->init("groupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the 128-bit mask used for collision filtering.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the 128-bit mask used for collision filtering.", true);
		ParamDefTable[118].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=119, longName="shapeDescTemplate.groupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[119];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[119].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=120, longName="shapeDescTemplate.groupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[120];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[120].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=121, longName="shapeDescTemplate.groupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[121];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[121].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=122, longName="shapeDescTemplate.groupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[122];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[122].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=123, longName="shapeDescTemplate.groupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[123];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[123].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=124, longName="shapeDescTemplate.materialIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[124];
		ParamDef->init("materialIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The material index of a shape.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The material index of a shape.", true);
		ParamDefTable[124].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=125, longName="shapeDescTemplate.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[125];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The density of this individual shape when computing mass inertial properties for a rigidbody (unless a valid mass >0.0 is provided).  Note that this will only be used if the body has a zero inertia tensor, or if you call NxActor::updateMassFromShapes explicitly.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The density of an individual shape.", true);
		ParamDefTable[125].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=126, longName="shapeDescTemplate.skinWidth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[126];
		ParamDef->init("skinWidth", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Specifies by how much shapes can interpenetrate; if -1 it uses the global default.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Specifies by how much shapes can interpenetrate; if -1 it uses the global default", true);
		ParamDefTable[126].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=127, longName="shapeDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[127];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[127].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[127].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=128, longName="shapeDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[128];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[128].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape.", true);
		ParamDefTable[128].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=129, longName="actorDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[129];
		ParamDef->init("actorDescTemplate", TYPE_STRUCT, "ActorDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[129].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actors created", true);
		ParamDefTable[129].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=130, longName="actorDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[130];
		ParamDef->init("flags", TYPE_STRUCT, "ActorDescFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=131, longName="actorDescTemplate.flags.NX_AF_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[131];
		ParamDef->init("NX_AF_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable collision detection.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable collision detection", true);
		ParamDefTable[131].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=132, longName="actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[132];
		ParamDef->init("NX_AF_DISABLE_RESPONSE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable collision response (reports contacts but dont use them).\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable collision response (reports contacts but dont use them)", true);
		ParamDefTable[132].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=133, longName="actorDescTemplate.flags.NX_AF_LOCK_COM"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[133];
		ParamDef->init("NX_AF_LOCK_COM", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disables COM update when computing inertial properties at creation time.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disables COM update when computing inertial properties at creation time.", true);
		ParamDefTable[133].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=134, longName="actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[134];
		ParamDef->init("NX_AF_FLUID_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disables COM update when computing inertial properties at creation time.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disables COM update when computing inertial properties at creation time.", true);
		ParamDefTable[134].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=135, longName="actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[135];
		ParamDef->init("NX_AF_CONTACT_MODIFICATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Turn on contact modification callback for the actor.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Turn on contact modification callback for the actor.", true);
		ParamDefTable[135].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=136, longName="actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[136];
		ParamDef->init("NX_AF_FORCE_CONE_FRICTION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Force cone friction to be used for this actor.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Force cone friction to be used for this actor.", true);
		ParamDefTable[136].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=137, longName="actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[137];
		ParamDef->init("NX_AF_USER_ACTOR_PAIR_FILTERING", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable custom contact filtering.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable custom contact filtering.", true);
		ParamDefTable[137].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=138, longName="actorDescTemplate.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[138];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Density to be applied to the whole actor.  If the body descriptor contains a zero mass but the actor descriptor contains a non-zero density, we compute a new mass automatically from the density and a shapes.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Density to be applied to the whole actor.", true);
		ParamDefTable[138].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=139, longName="actorDescTemplate.actorCollisionGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[139];
		ParamDef->init("actorCollisionGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets which NxActorGroup an actor is part of.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets which NxActorGroup an actor is part of", true);
		ParamDefTable[139].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=140, longName="actorDescTemplate.dominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[140];
		ParamDef->init("dominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Dominance group for an actor.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Dominance group for an actor.", true);
		ParamDefTable[140].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=141, longName="actorDescTemplate.contactReportFlags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[141];
		ParamDef->init("contactReportFlags", TYPE_STRUCT, "ContactPairFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of ContactPairFlag flags.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of ContactPairFlag flags", true);
		ParamDefTable[141].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=142, longName="actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[142];
		ParamDef->init("NX_IGNORE_PAIR", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable contact generation for this pair.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Disable contact generation for this pair", true);
		ParamDefTable[142].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=143, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[143];
		ParamDef->init("NX_NOTIFY_ON_START_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the pair starts to be in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the pair starts to be in contact", true);
		ParamDefTable[143].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=144, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[144];
		ParamDef->init("NX_NOTIFY_ON_END_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the pair stops to be in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the pair stops to be in contact", true);
		ParamDefTable[144].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=145, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[145];
		ParamDef->init("NX_NOTIFY_ON_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will keep getting called while the pair is in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will keep getting called while the pair is in contact", true);
		ParamDefTable[145].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=146, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[146];
		ParamDef->init("NX_NOTIFY_ON_IMPACT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when it may be appropriate for the pair to play an impact sound.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when it may be appropriate for the pair to play an impact sound", true);
		ParamDefTable[146].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=147, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[147];
		ParamDef->init("NX_NOTIFY_ON_ROLL", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and rolling.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and rolling.", true);
		ParamDefTable[147].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=148, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[148];
		ParamDef->init("NX_NOTIFY_ON_SLIDE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and sliding (and not rolling).  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and sliding (and not rolling).", true);
		ParamDefTable[148].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=149, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[149];
		ParamDef->init("NX_NOTIFY_FORCES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The (summed total) friction force and normal force will be given in the NxContactPair variable in the contact report.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "The (summed total) friction force and normal force will be given in the NxContactPair variable in the contact report.", true);
		ParamDefTable[149].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=150, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[150];
		ParamDef->init("NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds", true);
		ParamDefTable[150].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=151, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[151];
		ParamDef->init("NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds", true);
		ParamDefTable[151].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=152, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[152];
		ParamDef->init("NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will keep getting called while the contact force between two actors exceeds one of the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will keep getting called while the contact force between two actors exceeds one of the actor-defined force thresholds", true);
		ParamDefTable[152].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=153, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[153];
		ParamDef->init("NX_NOTIFY_CONTACT_MODIFICATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Generate a callback for all associated contact constraints, making it possible to edit the constraint. This flag is not included in NX_NOTIFY_ALL for performance reasons. see NxUserContactModify.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Generate a callback for all associated contact constraints, making it possible to edit the constraint. This flag is not included in NX_NOTIFY_ALL for performance reasons. see NxUserContactModify.", true);
		ParamDefTable[153].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=154, longName="actorDescTemplate.forceFieldMaterial"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[154];
		ParamDef->init("forceFieldMaterial", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Force Field Material Index, index != 0 has to be created.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Force Field Material Index", true);
		ParamDefTable[154].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=155, longName="actorDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[155];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[155].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[155].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=156, longName="actorDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[156];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[156].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.", true);
		ParamDefTable[156].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=157, longName="actorDescTemplate.compartment"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[157];
		ParamDef->init("compartment", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[157].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional compartment pointer; must be set by the application.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional compartment pointer", true);
		ParamDefTable[157].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=158, longName="bodyDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[158];
		ParamDef->init("bodyDescTemplate", TYPE_STRUCT, "BodyDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[158].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created", true);
		ParamDefTable[158].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=159, longName="bodyDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[159];
		ParamDef->init("flags", TYPE_STRUCT, "BodyDescFlags", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of body descriptor flags.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of body descriptor flags", true);
		ParamDefTable[159].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=160, longName="bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[160];
		ParamDef->init("NX_BF_DISABLE_GRAVITY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Set if gravity should not be applied on this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Set if gravity should not be applied on this body", true);
		ParamDefTable[160].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=161, longName="bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[161];
		ParamDef->init("NX_BF_FILTER_SLEEP_VEL", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Filter velocities used keep body awake. The filter reduces rapid oscillations and transient spikes.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Filter velocities used keep body awake. The filter reduces rapid oscillations and transient spikes", true);
		ParamDefTable[161].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=162, longName="bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[162];
		ParamDef->init("NX_BF_ENERGY_SLEEP_TEST", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables energy-based sleeping algorithm.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables energy-based sleeping algorithm", true);
		ParamDefTable[162].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=163, longName="bodyDescTemplate.flags.NX_BF_VISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[163];
		ParamDef->init("NX_BF_VISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables debug visualization for this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables debug visualization for this body", true);
		ParamDefTable[163].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=164, longName="bodyDescTemplate.wakeUpCounter"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[164];
		ParamDef->init("wakeUpCounter", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The bodys initial wake up counter.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The bodys initial wake up counter", true);
		ParamDefTable[164].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=165, longName="bodyDescTemplate.linearDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[165];
		ParamDef->init("linearDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Linear damping applied to the body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Linear damping applied to the body", true);
		ParamDefTable[165].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=166, longName="bodyDescTemplate.angularDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[166];
		ParamDef->init("angularDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Angular damping applied to the body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Angular damping applied to the body", true);
		ParamDefTable[166].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=167, longName="bodyDescTemplate.maxAngularVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[167];
		ParamDef->init("maxAngularVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum allowed angular velocity.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum allowed angular velocity", true);
		ParamDefTable[167].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=168, longName="bodyDescTemplate.CCDMotionThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[168];
		ParamDef->init("CCDMotionThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When CCD is globally enabled, it is still not performed if the motion distance of all points on the body is below this threshold.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Distance threshold for CCD", true);
		ParamDefTable[168].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=169, longName="bodyDescTemplate.sleepLinearVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[169];
		ParamDef->init("sleepLinearVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum linear velocity at which body can go to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum linear velocity at which body can go to sleep", true);
		ParamDefTable[169].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=170, longName="bodyDescTemplate.sleepAngularVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[170];
		ParamDef->init("sleepAngularVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum angular velocity at which body can go to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum angular velocity at which body can go to sleep", true);
		ParamDefTable[170].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=171, longName="bodyDescTemplate.solverIterationCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[171];
		ParamDef->init("solverIterationCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of solver iterations performed when processing joint/contacts connected to this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Number of solver iterations performed when processing joint/contacts connected to this body", true);
		ParamDefTable[171].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=172, longName="bodyDescTemplate.sleepEnergyThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[172];
		ParamDef->init("sleepEnergyThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Threshold for the energy-based sleeping algorithm. Only used when the NX_BF_ENERGY_SLEEP_TEST flag is set.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Threshold for the energy-based sleeping algorithm. Only used when the NX_BF_ENERGY_SLEEP_TEST flag is set", true);
		ParamDefTable[172].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=173, longName="bodyDescTemplate.sleepDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[173];
		ParamDef->init("sleepDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Damping factor for bodies that are about to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Damping factor for bodies that are about to sleep", true);
		ParamDefTable[173].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=174, longName="bodyDescTemplate.contactReportThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[174];
		ParamDef->init("contactReportThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The force threshold for contact reports.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The force threshold for contact reports", true);
		ParamDefTable[174].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=175, longName="p3ShapeDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[175];
		ParamDef->init("p3ShapeDescTemplate", TYPE_STRUCT, "P3ShapeDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[175].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actor shapes created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actor shapes created", true);
		ParamDefTable[175].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=176, longName="p3ShapeDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[176];
		ParamDef->init("flags", TYPE_STRUCT, "P3ShapeFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=177, longName="p3ShapeDescTemplate.flags.eSIMULATION_SHAPE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[177];
		ParamDef->init("eSIMULATION_SHAPE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "The shape will partake in collision in the physical simulation.", true);
		ParamDefTable[177].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=178, longName="p3ShapeDescTemplate.flags.eSCENE_QUERY_SHAPE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[178];
		ParamDef->init("eSCENE_QUERY_SHAPE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "The shape will partake in scene queries (ray casts, overlap tests, sweeps, ...). ", true);
		ParamDefTable[178].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=179, longName="p3ShapeDescTemplate.flags.eTRIGGER_SHAPE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[179];
		ParamDef->init("eTRIGGER_SHAPE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The shape is a trigger which can send reports whenever other shapes enter/leave its volume.\n\nNote:\nTriangle meshes and heightfields can not be triggers. Shape creation will fail in these cases.\nShapes marked as triggers do not collide with other objects. If an object should act both as a trigger shape and a collision shape then create a rigid body with two shapes, one being a trigger shape and the other a collision shape.\n", true);
		HintTable[1].init("shortDescription", "The shape is a trigger which can send reports whenever other shapes enter/leave its volume. ", true);
		ParamDefTable[179].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=180, longName="p3ShapeDescTemplate.flags.eVISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[180];
		ParamDef->init("eVISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Enable debug renderer for this shape", true);
		ParamDefTable[180].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=181, longName="p3ShapeDescTemplate.flags.ePARTICLE_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[181];
		ParamDef->init("ePARTICLE_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Sets the shape to be a particle drain", true);
		ParamDefTable[181].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=182, longName="p3ShapeDescTemplate.flags.eDEFORMABLE_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[182];
		ParamDef->init("eDEFORMABLE_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Sets the shape to be a deformable drain", true);
		ParamDefTable[182].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=183, longName="p3ShapeDescTemplate.simulationFilterData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[183];
		ParamDef->init("simulationFilterData", TYPE_STRUCT, "P3FilterData", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the user definable collision filter data.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the user definable collision filter data", true);
		ParamDefTable[183].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=184, longName="p3ShapeDescTemplate.simulationFilterData.word0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[184];
		ParamDef->init("word0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word0 of the filter data", true);
		ParamDefTable[184].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=185, longName="p3ShapeDescTemplate.simulationFilterData.word1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[185];
		ParamDef->init("word1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word1 of the filter data", true);
		ParamDefTable[185].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=186, longName="p3ShapeDescTemplate.simulationFilterData.word2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[186];
		ParamDef->init("word2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word2 of the filter data", true);
		ParamDefTable[186].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=187, longName="p3ShapeDescTemplate.simulationFilterData.word3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[187];
		ParamDef->init("word3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word3 of the filter data", true);
		ParamDefTable[187].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=188, longName="p3ShapeDescTemplate.queryFilterData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[188];
		ParamDef->init("queryFilterData", TYPE_STRUCT, "P3FilterData", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the user definable query filter data.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the user definable query filter data", true);
		ParamDefTable[188].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=189, longName="p3ShapeDescTemplate.queryFilterData.word0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[189];
		ParamDef->init("word0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word0 of the filter data", true);
		ParamDefTable[189].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=190, longName="p3ShapeDescTemplate.queryFilterData.word1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[190];
		ParamDef->init("word1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word1 of the filter data", true);
		ParamDefTable[190].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=191, longName="p3ShapeDescTemplate.queryFilterData.word2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[191];
		ParamDef->init("word2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word2 of the filter data", true);
		ParamDefTable[191].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=192, longName="p3ShapeDescTemplate.queryFilterData.word3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[192];
		ParamDef->init("word3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "word3 of the filter data", true);
		ParamDefTable[192].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=193, longName="p3ShapeDescTemplate.material"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[193];
		ParamDef->init("material", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A PxMaterial pointer for the shape.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "A PxMaterial pointer for the shape", true);
		ParamDefTable[193].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=194, longName="p3ShapeDescTemplate.contactOffset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[194];
		ParamDef->init("contactOffset", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the contact offset; if -1 it uses the global default.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the contact offset", true);
		ParamDefTable[194].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=195, longName="p3ShapeDescTemplate.restOffset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[195];
		ParamDef->init("restOffset", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the rest offset; if -1 it uses the global default.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the rest offset", true);
		ParamDefTable[195].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=196, longName="p3ShapeDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[196];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[196].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[196].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=197, longName="p3ShapeDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[197];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[197].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This is applied to all shapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape.", true);
		ParamDefTable[197].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=198, longName="p3ActorDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[198];
		ParamDef->init("p3ActorDescTemplate", TYPE_STRUCT, "P3ActorDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[198].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actors created", true);
		ParamDefTable[198].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=199, longName="p3ActorDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[199];
		ParamDef->init("flags", TYPE_STRUCT, "P3ActorFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=200, longName="p3ActorDescTemplate.flags.eVISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[200];
		ParamDef->init("eVISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable debug renderer for this actor.\n						This flag will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable debug renderer for this actor", true);
		ParamDefTable[200].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=201, longName="p3ActorDescTemplate.flags.eDISABLE_GRAVITY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[201];
		ParamDef->init("eDISABLE_GRAVITY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disables scene gravity for this actor.\n						This flag will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disables scene gravity for this actor", true);
		ParamDefTable[201].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=202, longName="p3ActorDescTemplate.flags.eSEND_SLEEP_NOTIFIES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[202];
		ParamDef->init("eSEND_SLEEP_NOTIFIES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the sending of PxSimulationEventCallback::onWake() and PxSimulationEventCallback::onSleep() notify events.\n						This flag will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the sending of PxSimulationEventCallback::onWake() and PxSimulationEventCallback::onSleep() notify events", true);
		ParamDefTable[202].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=203, longName="p3ActorDescTemplate.dominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[203];
		ParamDef->init("dominanceGroup", TYPE_U8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Assigns dynamic actors a dominance group identifier.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Assigns dynamic actors a dominance group identifier.", true);
		ParamDefTable[203].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=204, longName="p3ActorDescTemplate.ownerClient"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[204];
		ParamDef->init("ownerClient", TYPE_U8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the owner client of an actor.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the owner client of an actor.", true);
		ParamDefTable[204].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=205, longName="p3ActorDescTemplate.clientBehaviorBits"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[205];
		ParamDef->init("clientBehaviorBits", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Changes the behavior bits initially specified with PxActorDesc::clientBehaviorBits.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Changes the behavior bits initially specified with PxActorDesc::clientBehaviorBits.", true);
		ParamDefTable[205].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=206, longName="p3ActorDescTemplate.contactReportFlags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[206];
		ParamDef->init("contactReportFlags", TYPE_STRUCT, "P3PairFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of P3PairFlag flags.\n						This will be applied to all shapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of P3PairFlag flags", true);
		ParamDefTable[206].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=207, longName="p3ActorDescTemplate.contactReportFlags.eRESOLVE_CONTACTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[207];
		ParamDef->init("eRESOLVE_CONTACTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Process the contacts of this collision pair in the dynamics solver.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Process the contacts of this collision pair in the dynamics solver.", true);
		ParamDefTable[207].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=208, longName="p3ActorDescTemplate.contactReportFlags.eMODIFY_CONTACTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[208];
		ParamDef->init("eMODIFY_CONTACTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact modification callback for this collision pair.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Call contact modification callback for this collision pair. ", true);
		ParamDefTable[208].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=209, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_FOUND"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[209];
		ParamDef->init("eNOTIFY_TOUCH_FOUND", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact report callback or trigger callback when this collision pair starts to be in contact.\nIf one of the two collision objects is a trigger shape (see PxShapeFlag::eTRIGGER_SHAPE) then the trigger callback will get called as soon as the other object enters the trigger volume. If none of the two collision objects is a trigger shape then the contact report callback will get called when the actors of this collision pair start to be in contact.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Call contact report callback or trigger callback when this collision pair starts to be in contact", true);
		ParamDefTable[209].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=210, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_PERSISTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[210];
		ParamDef->init("eNOTIFY_TOUCH_PERSISTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Process the contacts of this collision pair in the dynamics solver.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Call contact report callback or trigger callback while this collision pair is in contact", true);
		ParamDefTable[210].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=211, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_LOST"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[211];
		ParamDef->init("eNOTIFY_TOUCH_LOST", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact report callback or trigger callback when this collision pair stops to be in contact.\nIf one of the two collision objects is a trigger shape (see PxShapeFlag::eTRIGGER_SHAPE) then the trigger callback will get called as soon as the other object leaves the trigger volume. If none of the two collision objects is a trigger shape then the contact report callback will get called when the actors of this collision pair stop to be in contact.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", " Call contact report callback or trigger callback when this collision pair stops to be in contact.", true);
		ParamDefTable[211].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=212, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_FOUND"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[212];
		ParamDef->init("eNOTIFY_THRESHOLD_FORCE_FOUND", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact report callback when the contact force between the actors of this collision pair exceeds one of the actor-defined force thresholds.\n\nNote: Only takes effect if the colliding actors are rigid bodies\n", true);
		HintTable[1].init("shortDescription", "Call contact report callback when the contact force between the actors of this collision pair exceeds one of the actor-defined force thresholds.", true);
		ParamDefTable[212].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=213, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_PERSISTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[213];
		ParamDef->init("eNOTIFY_THRESHOLD_FORCE_PERSISTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact report callback when the contact force between the actors of this collision pair continues to exceed one of the actor-defined force thresholds.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Call contact report callback when the contact force between the actors of this collision pair continues to exceed one of the actor-defined force thresholds", true);
		ParamDefTable[213].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=214, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_LOST"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[214];
		ParamDef->init("eNOTIFY_THRESHOLD_FORCE_LOST", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Call contact report callback when the contact force between the actors of this collision pair falls below one of the actor-defined force thresholds (includes the case where this collision pair stops being in contact).\n\nNote: Only takes effect if the colliding actors are rigid bodies\n", true);
		HintTable[1].init("shortDescription", "Call contact report callback when the contact force between the actors of this collision pair falls below one of the actor-defined force thresholds (includes the case where this collision pair stops being in contact).", true);
		ParamDefTable[214].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=215, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_POINTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[215];
		ParamDef->init("eNOTIFY_CONTACT_POINTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Provide contact points in contact reports for this collision pair.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Provide contact points in contact reports for this collision pair.", true);
		ParamDefTable[215].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=216, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[216];
		ParamDef->init("eNOTIFY_CONTACT_FORCES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Provide the (summed total) friction force and normal force in contact reports for this collision pair (see PxContactPair).\n\nNote: Only takes effect if the colliding actors are rigid bodies\n", true);
		HintTable[1].init("shortDescription", "Provide the (summed total) friction force and normal force in contact reports for this collision pair (see PxContactPair).", true);
		ParamDefTable[216].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=217, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCE_PER_POINT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[217];
		ParamDef->init("eNOTIFY_CONTACT_FORCE_PER_POINT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Provide contact forces per contact point in contact reports for this collision pair.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Provide contact forces per contact point in contact reports for this collision pair.", true);
		ParamDefTable[217].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=218, longName="p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FEATURE_INDICES_PER_POINT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[218];
		ParamDef->init("eNOTIFY_CONTACT_FEATURE_INDICES_PER_POINT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Provide feature indices per contact point in contact reports for this collision pair.\n\nNote: Only takes effect if the colliding actors are rigid bodies.\n", true);
		HintTable[1].init("shortDescription", "Provide feature indices per contact point in contact reports for this collision pair.", true);
		ParamDefTable[218].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=219, longName="p3ActorDescTemplate.contactReportFlags.eCCD_LINEAR"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[219];
		ParamDef->init("eCCD_LINEAR", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A less expensive approximation of eSWEPT_INTEGRATION_FULL, where the rotational motion of the objects is neglected. Should be used when performance is of the essence, for objects where angular motion is unlikely to lead to tunneling.\n\nNote: The scene must have PxSceneFlag::eENABLE_CCD enabled to use this feature.\n", true);
		HintTable[1].init("shortDescription", "A less expensive approximation of eSWEPT_INTEGRATION_FULL, where the rotational motion of the objects is neglected. Should be used when performance is of the essence, for objects where angular motion is unlikely to lead to tunneling.", true);
		ParamDefTable[219].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=220, longName="p3ActorDescTemplate.contactReportFlags.eCONTACT_DEFAULT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[220];
		ParamDef->init("eCONTACT_DEFAULT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Provided default flag to do simple contact processing for this collision pair.", true);
		ParamDefTable[220].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=221, longName="p3ActorDescTemplate.contactReportFlags.eTRIGGER_DEFAULT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[221];
		ParamDef->init("eTRIGGER_DEFAULT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("shortDescription", "Provided default flag to get commonly used trigger behavior for this collision pair.", true);
		ParamDefTable[221].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=222, longName="p3ActorDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[222];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[222].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[222].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=223, longName="p3ActorDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[223];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[223].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.", true);
		ParamDefTable[223].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=224, longName="p3BodyDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[224];
		ParamDef->init("p3BodyDescTemplate", TYPE_STRUCT, "P3BodyDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[224].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created", true);
		ParamDefTable[224].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=225, longName="p3BodyDescTemplate.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[225];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The density of the body. Used to compute the mass of the body.  If the body descriptor contains a zero mass but the actor descriptor contains a non-zero density, we compute a new mass automatically from the density and a shapes.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The density of the body. Used to compute the mass of the body.", true);
		ParamDefTable[225].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=226, longName="p3BodyDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[226];
		ParamDef->init("flags", TYPE_STRUCT, "P3BodyDescFlags", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of body descriptor flags.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of body descriptor flags", true);
		ParamDefTable[226].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=227, longName="p3BodyDescTemplate.flags.eKINEMATIC"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[227];
		ParamDef->init("eKINEMATIC", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Kinematic actors are special dynamic actors that are not influenced by forces (such as gravity), and have no momentum. They are considered to have infinite mass and can be moved around the world using the moveKinematic() method. They will push regular dynamic actors out of the way. Kinematics will not collide with static or other kinematic objects.\nKinematic actors are great for moving platforms or characters, where direct motion control is desired.\nYou can not connect Reduced joints to kinematic actors. Lagrange joints work ok if the platform is moving with a relatively low, uniform velocity.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables kinematic mode for the actor", true);
		ParamDefTable[227].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=228, longName="p3BodyDescTemplate.flags.eENABLE_CCD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[228];
		ParamDef->init("eENABLE_CCD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables swept integration for the actor.\n		If this flag is raised and swept integration is enabled on the scene, then this body will be simulated by the CCD system to ensure that collisions are not missed due to \n		high-speed motion. Note, individual shape pairs still need to enable PxPairFlag::eCCD_LINEAR in the collision filtering to enable the CCD to respond to \n		individual interactions.", true);
		HintTable[1].init("shortDescription", "Enables swept integration for the actor.", true);
		ParamDefTable[228].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=229, longName="p3BodyDescTemplate.sleepThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[229];
		ParamDef->init("sleepThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the mass-normalized kinetic energy threshold below which an actor may go to sleep.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the mass-normalized kinetic energy threshold below which an actor may go to sleep.", true);
		ParamDefTable[229].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=230, longName="p3BodyDescTemplate.wakeUpCounter"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[230];
		ParamDef->init("wakeUpCounter", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The bodys initial wake up counter.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The bodys initial wake up counter", true);
		ParamDefTable[230].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=231, longName="p3BodyDescTemplate.linearDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[231];
		ParamDef->init("linearDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Linear damping applied to the body.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Linear damping applied to the body", true);
		ParamDefTable[231].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=232, longName="p3BodyDescTemplate.angularDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[232];
		ParamDef->init("angularDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the angular damping coefficient.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the angular damping coefficient", true);
		ParamDefTable[232].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=233, longName="p3BodyDescTemplate.maxAngularVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[233];
		ParamDef->init("maxAngularVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum allowed angular velocity.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum allowed angular velocity", true);
		ParamDefTable[233].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=234, longName="p3BodyDescTemplate.solverIterationCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[234];
		ParamDef->init("solverIterationCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the solver iteration counts for the body.\nThe solver iteration count determines how accurately joints and contacts are resolved. If you are having trouble with jointed bodies oscillating and behaving erratically, then setting a higher position iteration count may improve their stability.\nIf intersecting bodies are being depenetrated too violently, increase the number of velocity iterations.", true);
		HintTable[1].init("shortDescription", "Sets the solver iteration counts for the body", true);
		ParamDefTable[234].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=235, longName="p3BodyDescTemplate.velocityIterationCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[235];
		ParamDef->init("velocityIterationCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the velocity solver iteration counts for the body.\nThe solver iteration count determines how accurately joints and contacts are resolved. If you are having trouble with jointed bodies oscillating and behaving erratically, then setting a higher position iteration count may improve their stability.\nIf intersecting bodies are being depenetrated too violently, increase the number of velocity iterations.", true);
		HintTable[1].init("shortDescription", "Sets the velocity solver iteration counts for the body", true);
		ParamDefTable[235].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=236, longName="p3BodyDescTemplate.contactReportThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[236];
		ParamDef->init("contactReportThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The force threshold for contact reports.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The force threshold for contact reports", true);
		ParamDefTable[236].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=237, longName="p3BodyDescTemplate.sleepLinearVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[237];
		ParamDef->init("sleepLinearVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum linear velocity at which body can go to sleep.\n						This will be applied to all actors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum linear velocity at which body can go to sleep", true);
		ParamDefTable[237].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=238, longName="structureSettings"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[238];
		ParamDef->init("structureSettings", TYPE_STRUCT, "StructureSettings", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[238].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains parameters that affect structure-wide settings.", true);
		HintTable[2].init("shortDescription", "Contains parameters that affect structure-wide settings", true);
		ParamDefTable[238].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=239, longName="structureSettings.useStressSolver"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[239];
		ParamDef->init("useStressSolver", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Determines whether to invoke the use of the stress solver. The stress solver is a self-checking mechanism\nemployed within the structure, with the purpose of detecting and breaking off overly-strained links to masses\nof chunks. Its behavior can be tweaked by customizing the parameters stressSolverTimeDelay and stressSolverMassThreshold.\n", true);
		HintTable[1].init("shortDescription", "If true, the structure containing this actor will use the stress solver.", true);
		ParamDefTable[239].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=240, longName="structureSettings.stressSolverTimeDelay"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[240];
		ParamDef->init("stressSolverTimeDelay", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Determines the amount of time to run down until an identified overly-strained link breaks. From the time the stress\nsolver qualifies a link as being overly-strained, this value will be used to count down to the actual breaking-off\nevent being executed. This should always be some positive value.\n", true);
		HintTable[1].init("shortDescription", "The structure containing this actor will use the minimum stressSolverTimeDelay of all actors in the structure.", true);
		ParamDefTable[240].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=241, longName="structureSettings.stressSolverMassThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[241];
		ParamDef->init("stressSolverMassThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Determines the minimum threshold mass to meet before an indentified overly-strained link breaks. This mass threshold\nis part of the condition that the stress solver uses to qualify whether a link is overly-strained. The accumulated sum\nof the chunk masses that the link is supporting will be used against this value. This should always be some positive value.\n", true);
		HintTable[1].init("shortDescription", "The structure containing this actor will use the minimum stressSolverMassThreshold of all actors in the structure.", true);
		ParamDefTable[241].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=242, longName="defaultBehaviorGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[242];
		ParamDef->init("defaultBehaviorGroup", TYPE_STRUCT, "BehaviorGroup", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default behavior group referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The default behavior group referenced by chunks", true);
		ParamDefTable[242].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=243, longName="defaultBehaviorGroup.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[243];
		ParamDef->init("name", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Name of behavior group, eg Concrete or Glass.", true);
		HintTable[1].init("shortDescription", "Name of behavior group", true);
		ParamDefTable[243].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=244, longName="defaultBehaviorGroup.damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[244];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\n						This is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\n						or NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[244].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=245, longName="defaultBehaviorGroup.damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[245];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\n						is multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\n						will have damage applied to them.  The damage applied to each chunk varies with distance to the damage\n						application position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n						NOTE: This parameter is deprecated for point and radius damage.  It will be used for those types of damage if legacy damage\n						behavior is enabled with NxModuleDestructible::setUseLegacyDamageRadiusSpread.  Otherwise, the new parameters\n						damageSpread.minimumRadius, damageSpread.radiusMultiplier, and damageSpread.falloffExponent are used.  For impact damage, this parameter\n						will continue to be used, however the radius will no longer scale with object size.  The radius will continue\n						to scale with the damage as a fraction of damageThreshold, however.  If legacy damage behavior is used, this parameter\n						will behave as before with respect to impact damage as well (scaling with object size).", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[245].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=246, longName="defaultBehaviorGroup.damageSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[246];
		ParamDef->init("damageSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		ParamDefTable[246].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=247, longName="defaultBehaviorGroup.damageSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[247];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[247].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=248, longName="defaultBehaviorGroup.damageSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[248];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[248].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=249, longName="defaultBehaviorGroup.damageSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[249];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[249].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=250, longName="defaultBehaviorGroup.damageColorSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[250];
		ParamDef->init("damageColorSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		ParamDefTable[250].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=251, longName="defaultBehaviorGroup.damageColorSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[251];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[251].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=252, longName="defaultBehaviorGroup.damageColorSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[252];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[252].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=253, longName="defaultBehaviorGroup.damageColorSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[253];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[253].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=254, longName="defaultBehaviorGroup.damageColorChange"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[254];
		ParamDef->init("damageColorChange", TYPE_VEC4, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes how damage changes the color of vertices in the render mesh.  If this vector is non-zero, then a dynamic\n						(per-actor) color channel will be created and initialized to the asset's color channel, if it exists.  Damage taken will go through\n						the spread and envelope function described by damageColorSpread, and each color will be modified by the resulting damage, scaled\n						by the values in damageColorChange.  The change to color channel C is given by\n						color[C] = clamp(color[C] + damageColorChange[C]*255*min(1.0, damage/damageThreshold), 0, 255).", true);
		HintTable[1].init("shortDescription", "Describes how damage changes the color of vertices in the render mesh.", true);
		ParamDefTable[254].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=255, longName="defaultBehaviorGroup.materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[255];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see see NxDestructibleDepthParameters), this parameter\n						is the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\n						heavier objects will pass through them during fracture.\n						N.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\n						Default value = 0.0f.", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[255].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=256, longName="defaultBehaviorGroup.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[256];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk density. (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk density", true);
		ParamDefTable[256].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=257, longName="defaultBehaviorGroup.fadeOut"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[257];
		ParamDef->init("fadeOut", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk fade out.  (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk fade out", true);
		ParamDefTable[257].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=258, longName="defaultBehaviorGroup.maxDepenetrationVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[258];
		ParamDef->init("maxDepenetrationVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "In case some chunk is created inside static geometry it will be pushed out of it without limiting it's velocity. Sometimes it's not desirable, \n						so this parameter can limit depenetration velocity. Keep in mind, that for low values you can see chunks 'floating' off the static meshes, which is also not always desirable.", true);
		HintTable[1].init("shortDescription", "Chunk maximum depenetration velocity", true);
		ParamDefTable[258].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=259, longName="defaultBehaviorGroup.groupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[259];
		ParamDef->init("groupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured", true);
		ParamDefTable[259].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=260, longName="defaultBehaviorGroup.groupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[260];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[260].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=261, longName="defaultBehaviorGroup.groupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[261];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[261].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=262, longName="defaultBehaviorGroup.groupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[262];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[262].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=263, longName="defaultBehaviorGroup.groupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[263];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[263].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=264, longName="defaultBehaviorGroup.groupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[264];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[264].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=265, longName="defaultBehaviorGroup.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[265];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User data field.  This 64-bit field can be set and retrieved by the user at runtime.", true);
		HintTable[1].init("shortDescription", "User data field.", true);
		ParamDefTable[265].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=266, longName="behaviorGroups"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[266];
		ParamDef->init("behaviorGroups", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of behavior groups referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The array of behavior groups referenced by chunks", true);
		ParamDefTable[266].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[2] = { 1, 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 2);

	}

	// Initialize DefinitionImpl node: nodeIndex=267, longName="behaviorGroups[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[267];
		ParamDef->init("behaviorGroups", TYPE_STRUCT, "BehaviorGroup", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of behavior groups referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The array of behavior groups referenced by chunks", true);
		ParamDefTable[267].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=268, longName="behaviorGroups[].name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[268];
		ParamDef->init("name", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Name of behavior group, eg Concrete or Glass.", true);
		HintTable[1].init("shortDescription", "Name of behavior group", true);
		ParamDefTable[268].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=269, longName="behaviorGroups[].damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[269];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\n						This is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\n						or NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[269].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=270, longName="behaviorGroups[].damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[270];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\n						is multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\n						will have damage applied to them.  The damage applied to each chunk varies with distance to the damage\n						application position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n						NOTE: This parameter is deprecated for point and radius damage.  It will be used for those types of damage if legacy damage\n						behavior is enabled with NxModuleDestructible::setUseLegacyDamageRadiusSpread.  Otherwise, the new parameters\n						damageSpread.minimumRadius, damageSpread.radiusMultiplier, and damageSpread.falloffExponent are used.  For impact damage, this parameter\n						will continue to be used, however the radius will no longer scale with object size.  The radius will continue\n						to scale with the damage as a fraction of damageThreshold, however.  If legacy damage behavior is used, this parameter\n						will behave as before with respect to impact damage as well (scaling with object size).", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[270].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=271, longName="behaviorGroups[].damageSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[271];
		ParamDef->init("damageSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		ParamDefTable[271].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=272, longName="behaviorGroups[].damageSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[272];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[272].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=273, longName="behaviorGroups[].damageSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[273];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[273].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=274, longName="behaviorGroups[].damageSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[274];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[274].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=275, longName="behaviorGroups[].damageColorSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[275];
		ParamDef->init("damageColorSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		ParamDefTable[275].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=276, longName="behaviorGroups[].damageColorSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[276];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[276].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=277, longName="behaviorGroups[].damageColorSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[277];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[277].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=278, longName="behaviorGroups[].damageColorSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[278];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[278].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=279, longName="behaviorGroups[].damageColorChange"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[279];
		ParamDef->init("damageColorChange", TYPE_VEC4, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes how damage changes the color of vertices in the render mesh.  If this vector is non-zero, then a dynamic\n						(per-actor) color channel will be created and initialized to the asset's color channel, if it exists.  Damage taken will go through\n						the spread and envelope function described by damageColorSpread, and each color will be modified by the resulting damage, scaled\n						by the values in damageColorChange.  The change to color channel C is given by\n						color[C] = clamp(color[C] + damageColorChange[C]*255*min(1.0, damage/damageThreshold), 0, 255).", true);
		HintTable[1].init("shortDescription", "Describes how damage changes the color of vertices in the render mesh.", true);
		ParamDefTable[279].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=280, longName="behaviorGroups[].materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[280];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see see NxDestructibleDepthParameters), this parameter\n						is the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\n						heavier objects will pass through them during fracture.\n						N.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\n						Default value = 0.0f.", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[280].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=281, longName="behaviorGroups[].density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[281];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk density. (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk density", true);
		ParamDefTable[281].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=282, longName="behaviorGroups[].fadeOut"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[282];
		ParamDef->init("fadeOut", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk fade out.  (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk fade out", true);
		ParamDefTable[282].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=283, longName="behaviorGroups[].maxDepenetrationVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[283];
		ParamDef->init("maxDepenetrationVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "In case some chunk is created inside static geometry it will be pushed out of it without limiting it's velocity. Sometimes it's not desirable, \n						so this parameter can limit depenetration velocity. Keep in mind, that for low values you can see chunks 'floating' off the static meshes, which is also not always desirable.", true);
		HintTable[1].init("shortDescription", "Chunk maximum depenetration velocity", true);
		ParamDefTable[283].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=284, longName="behaviorGroups[].groupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[284];
		ParamDef->init("groupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured", true);
		ParamDefTable[284].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=285, longName="behaviorGroups[].groupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[285];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[285].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=286, longName="behaviorGroups[].groupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[286];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[286].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=287, longName="behaviorGroups[].groupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[287];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[287].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=288, longName="behaviorGroups[].groupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[288];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[288].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=289, longName="behaviorGroups[].groupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[289];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[289].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=290, longName="behaviorGroups[].userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[290];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User data field.  This 64-bit field can be set and retrieved by the user at runtime.", true);
		HintTable[1].init("shortDescription", "User data field.", true);
		ParamDefTable[290].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=291, longName="deleteChunksLeavingUserDefinedBB"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[291];
		ParamDef->init("deleteChunksLeavingUserDefinedBB", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The user can specify arbitrary number of bounding boxes in the scene using NxApexScene::addBoundingBox interface along with the flag, which marks a bounding box \n				as either UserBoundingBoxFlags::ENTER or UserBoundingBoxFlags::LEAVE. If user also specifies 'deleteChunksLeavingUserDefinedBB' flag to true, then chunks that are leaving a bounding box marked as\n				UserBoundingBoxFlags::LEAVE are going to be deleted. User can specify more complex deletion volumes by combining 2 types of bounding boxes.", true);
		HintTable[1].init("shortDescription", "Whether or not the destructible chunks are going to be deleted upon leaving any user-defined bounding box.", true);
		ParamDefTable[291].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=292, longName="deleteChunksEnteringUserDefinedBB"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[292];
		ParamDef->init("deleteChunksEnteringUserDefinedBB", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The user can specify arbitrary number of bounding boxes in the scene using NxApexScene::addBoundingBox interface along with the flag, which marks a bounding box \n				as either UserBoundingBoxFlags::ENTER or UserBoundingBoxFlags::LEAVE. If user also specifies 'deleteChunksEnteringUserDefinedBB' flag to true, then chunks that are entering a bounding box marked as\n				UserBoundingBoxFlags::ENTER are going to be deleted. User can specify more complex deletion volumes by combining 2 types of bounding boxes.", true);
		HintTable[1].init("shortDescription", "Whether or not the destructible chunks are going to be deleted upon entering any user-defined bounding box.", true);
		ParamDefTable[292].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// SetChildren for: nodeIndex=0, longName=""
	{
		static Definition* Children[34];
		Children[0] = PDEF_PTR(1);
		Children[1] = PDEF_PTR(2);
		Children[2] = PDEF_PTR(3);
		Children[3] = PDEF_PTR(4);
		Children[4] = PDEF_PTR(5);
		Children[5] = PDEF_PTR(6);
		Children[6] = PDEF_PTR(7);
		Children[7] = PDEF_PTR(8);
		Children[8] = PDEF_PTR(9);
		Children[9] = PDEF_PTR(10);
		Children[10] = PDEF_PTR(11);
		Children[11] = PDEF_PTR(12);
		Children[12] = PDEF_PTR(13);
		Children[13] = PDEF_PTR(14);
		Children[14] = PDEF_PTR(15);
		Children[15] = PDEF_PTR(16);
		Children[16] = PDEF_PTR(17);
		Children[17] = PDEF_PTR(18);
		Children[18] = PDEF_PTR(20);
		Children[19] = PDEF_PTR(22);
		Children[20] = PDEF_PTR(23);
		Children[21] = PDEF_PTR(24);
		Children[22] = PDEF_PTR(84);
		Children[23] = PDEF_PTR(95);
		Children[24] = PDEF_PTR(129);
		Children[25] = PDEF_PTR(158);
		Children[26] = PDEF_PTR(175);
		Children[27] = PDEF_PTR(198);
		Children[28] = PDEF_PTR(224);
		Children[29] = PDEF_PTR(238);
		Children[30] = PDEF_PTR(242);
		Children[31] = PDEF_PTR(266);
		Children[32] = PDEF_PTR(291);
		Children[33] = PDEF_PTR(292);

		ParamDefTable[0].setChildren(Children, 34);
	}

	// SetChildren for: nodeIndex=18, longName="overrideSkinnedMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(19);

		ParamDefTable[18].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=20, longName="overrideStaticMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(21);

		ParamDefTable[20].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=24, longName="destructibleParameters"
	{
		static Definition* Children[23];
		Children[0] = PDEF_PTR(25);
		Children[1] = PDEF_PTR(26);
		Children[2] = PDEF_PTR(27);
		Children[3] = PDEF_PTR(28);
		Children[4] = PDEF_PTR(29);
		Children[5] = PDEF_PTR(30);
		Children[6] = PDEF_PTR(31);
		Children[7] = PDEF_PTR(32);
		Children[8] = PDEF_PTR(33);
		Children[9] = PDEF_PTR(34);
		Children[10] = PDEF_PTR(35);
		Children[11] = PDEF_PTR(36);
		Children[12] = PDEF_PTR(37);
		Children[13] = PDEF_PTR(38);
		Children[14] = PDEF_PTR(39);
		Children[15] = PDEF_PTR(47);
		Children[16] = PDEF_PTR(48);
		Children[17] = PDEF_PTR(49);
		Children[18] = PDEF_PTR(50);
		Children[19] = PDEF_PTR(56);
		Children[20] = PDEF_PTR(81);
		Children[21] = PDEF_PTR(82);
		Children[22] = PDEF_PTR(83);

		ParamDefTable[24].setChildren(Children, 23);
	}

	// SetChildren for: nodeIndex=39, longName="destructibleParameters.flags"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(40);
		Children[1] = PDEF_PTR(41);
		Children[2] = PDEF_PTR(42);
		Children[3] = PDEF_PTR(43);
		Children[4] = PDEF_PTR(44);
		Children[5] = PDEF_PTR(45);
		Children[6] = PDEF_PTR(46);

		ParamDefTable[39].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=50, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(51);
		Children[1] = PDEF_PTR(52);
		Children[2] = PDEF_PTR(53);
		Children[3] = PDEF_PTR(54);
		Children[4] = PDEF_PTR(55);

		ParamDefTable[50].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=56, longName="destructibleParameters.runtimeFracture"
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(57);
		Children[1] = PDEF_PTR(58);
		Children[2] = PDEF_PTR(59);
		Children[3] = PDEF_PTR(60);
		Children[4] = PDEF_PTR(61);
		Children[5] = PDEF_PTR(62);
		Children[6] = PDEF_PTR(63);
		Children[7] = PDEF_PTR(69);
		Children[8] = PDEF_PTR(74);

		ParamDefTable[56].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=63, longName="destructibleParameters.runtimeFracture.glass"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(64);
		Children[1] = PDEF_PTR(65);
		Children[2] = PDEF_PTR(66);
		Children[3] = PDEF_PTR(67);
		Children[4] = PDEF_PTR(68);

		ParamDefTable[63].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=69, longName="destructibleParameters.runtimeFracture.voronoi"
	{
		static Definition* Children[4];
		Children[0] = PDEF_PTR(70);
		Children[1] = PDEF_PTR(71);
		Children[2] = PDEF_PTR(72);
		Children[3] = PDEF_PTR(73);

		ParamDefTable[69].setChildren(Children, 4);
	}

	// SetChildren for: nodeIndex=74, longName="destructibleParameters.runtimeFracture.attachment"
	{
		static Definition* Children[6];
		Children[0] = PDEF_PTR(75);
		Children[1] = PDEF_PTR(76);
		Children[2] = PDEF_PTR(77);
		Children[3] = PDEF_PTR(78);
		Children[4] = PDEF_PTR(79);
		Children[5] = PDEF_PTR(80);

		ParamDefTable[74].setChildren(Children, 6);
	}

	// SetChildren for: nodeIndex=84, longName="depthParameters"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(85);

		ParamDefTable[84].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=85, longName="depthParameters[]"
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(86);
		Children[1] = PDEF_PTR(87);
		Children[2] = PDEF_PTR(88);
		Children[3] = PDEF_PTR(89);
		Children[4] = PDEF_PTR(90);
		Children[5] = PDEF_PTR(91);
		Children[6] = PDEF_PTR(92);
		Children[7] = PDEF_PTR(93);
		Children[8] = PDEF_PTR(94);

		ParamDefTable[85].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=95, longName="shapeDescTemplate"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(96);
		Children[1] = PDEF_PTR(117);
		Children[2] = PDEF_PTR(118);
		Children[3] = PDEF_PTR(124);
		Children[4] = PDEF_PTR(125);
		Children[5] = PDEF_PTR(126);
		Children[6] = PDEF_PTR(127);
		Children[7] = PDEF_PTR(128);

		ParamDefTable[95].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=96, longName="shapeDescTemplate.flags"
	{
		static Definition* Children[20];
		Children[0] = PDEF_PTR(97);
		Children[1] = PDEF_PTR(98);
		Children[2] = PDEF_PTR(99);
		Children[3] = PDEF_PTR(100);
		Children[4] = PDEF_PTR(101);
		Children[5] = PDEF_PTR(102);
		Children[6] = PDEF_PTR(103);
		Children[7] = PDEF_PTR(104);
		Children[8] = PDEF_PTR(105);
		Children[9] = PDEF_PTR(106);
		Children[10] = PDEF_PTR(107);
		Children[11] = PDEF_PTR(108);
		Children[12] = PDEF_PTR(109);
		Children[13] = PDEF_PTR(110);
		Children[14] = PDEF_PTR(111);
		Children[15] = PDEF_PTR(112);
		Children[16] = PDEF_PTR(113);
		Children[17] = PDEF_PTR(114);
		Children[18] = PDEF_PTR(115);
		Children[19] = PDEF_PTR(116);

		ParamDefTable[96].setChildren(Children, 20);
	}

	// SetChildren for: nodeIndex=118, longName="shapeDescTemplate.groupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(119);
		Children[1] = PDEF_PTR(120);
		Children[2] = PDEF_PTR(121);
		Children[3] = PDEF_PTR(122);
		Children[4] = PDEF_PTR(123);

		ParamDefTable[118].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=129, longName="actorDescTemplate"
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(130);
		Children[1] = PDEF_PTR(138);
		Children[2] = PDEF_PTR(139);
		Children[3] = PDEF_PTR(140);
		Children[4] = PDEF_PTR(141);
		Children[5] = PDEF_PTR(154);
		Children[6] = PDEF_PTR(155);
		Children[7] = PDEF_PTR(156);
		Children[8] = PDEF_PTR(157);

		ParamDefTable[129].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=130, longName="actorDescTemplate.flags"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(131);
		Children[1] = PDEF_PTR(132);
		Children[2] = PDEF_PTR(133);
		Children[3] = PDEF_PTR(134);
		Children[4] = PDEF_PTR(135);
		Children[5] = PDEF_PTR(136);
		Children[6] = PDEF_PTR(137);

		ParamDefTable[130].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=141, longName="actorDescTemplate.contactReportFlags"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(142);
		Children[1] = PDEF_PTR(143);
		Children[2] = PDEF_PTR(144);
		Children[3] = PDEF_PTR(145);
		Children[4] = PDEF_PTR(146);
		Children[5] = PDEF_PTR(147);
		Children[6] = PDEF_PTR(148);
		Children[7] = PDEF_PTR(149);
		Children[8] = PDEF_PTR(150);
		Children[9] = PDEF_PTR(151);
		Children[10] = PDEF_PTR(152);
		Children[11] = PDEF_PTR(153);

		ParamDefTable[141].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=158, longName="bodyDescTemplate"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(159);
		Children[1] = PDEF_PTR(164);
		Children[2] = PDEF_PTR(165);
		Children[3] = PDEF_PTR(166);
		Children[4] = PDEF_PTR(167);
		Children[5] = PDEF_PTR(168);
		Children[6] = PDEF_PTR(169);
		Children[7] = PDEF_PTR(170);
		Children[8] = PDEF_PTR(171);
		Children[9] = PDEF_PTR(172);
		Children[10] = PDEF_PTR(173);
		Children[11] = PDEF_PTR(174);

		ParamDefTable[158].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=159, longName="bodyDescTemplate.flags"
	{
		static Definition* Children[4];
		Children[0] = PDEF_PTR(160);
		Children[1] = PDEF_PTR(161);
		Children[2] = PDEF_PTR(162);
		Children[3] = PDEF_PTR(163);

		ParamDefTable[159].setChildren(Children, 4);
	}

	// SetChildren for: nodeIndex=175, longName="p3ShapeDescTemplate"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(176);
		Children[1] = PDEF_PTR(183);
		Children[2] = PDEF_PTR(188);
		Children[3] = PDEF_PTR(193);
		Children[4] = PDEF_PTR(194);
		Children[5] = PDEF_PTR(195);
		Children[6] = PDEF_PTR(196);
		Children[7] = PDEF_PTR(197);

		ParamDefTable[175].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=176, longName="p3ShapeDescTemplate.flags"
	{
		static Definition* Children[6];
		Children[0] = PDEF_PTR(177);
		Children[1] = PDEF_PTR(178);
		Children[2] = PDEF_PTR(179);
		Children[3] = PDEF_PTR(180);
		Children[4] = PDEF_PTR(181);
		Children[5] = PDEF_PTR(182);

		ParamDefTable[176].setChildren(Children, 6);
	}

	// SetChildren for: nodeIndex=183, longName="p3ShapeDescTemplate.simulationFilterData"
	{
		static Definition* Children[4];
		Children[0] = PDEF_PTR(184);
		Children[1] = PDEF_PTR(185);
		Children[2] = PDEF_PTR(186);
		Children[3] = PDEF_PTR(187);

		ParamDefTable[183].setChildren(Children, 4);
	}

	// SetChildren for: nodeIndex=188, longName="p3ShapeDescTemplate.queryFilterData"
	{
		static Definition* Children[4];
		Children[0] = PDEF_PTR(189);
		Children[1] = PDEF_PTR(190);
		Children[2] = PDEF_PTR(191);
		Children[3] = PDEF_PTR(192);

		ParamDefTable[188].setChildren(Children, 4);
	}

	// SetChildren for: nodeIndex=198, longName="p3ActorDescTemplate"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(199);
		Children[1] = PDEF_PTR(203);
		Children[2] = PDEF_PTR(204);
		Children[3] = PDEF_PTR(205);
		Children[4] = PDEF_PTR(206);
		Children[5] = PDEF_PTR(222);
		Children[6] = PDEF_PTR(223);

		ParamDefTable[198].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=199, longName="p3ActorDescTemplate.flags"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(200);
		Children[1] = PDEF_PTR(201);
		Children[2] = PDEF_PTR(202);

		ParamDefTable[199].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=206, longName="p3ActorDescTemplate.contactReportFlags"
	{
		static Definition* Children[15];
		Children[0] = PDEF_PTR(207);
		Children[1] = PDEF_PTR(208);
		Children[2] = PDEF_PTR(209);
		Children[3] = PDEF_PTR(210);
		Children[4] = PDEF_PTR(211);
		Children[5] = PDEF_PTR(212);
		Children[6] = PDEF_PTR(213);
		Children[7] = PDEF_PTR(214);
		Children[8] = PDEF_PTR(215);
		Children[9] = PDEF_PTR(216);
		Children[10] = PDEF_PTR(217);
		Children[11] = PDEF_PTR(218);
		Children[12] = PDEF_PTR(219);
		Children[13] = PDEF_PTR(220);
		Children[14] = PDEF_PTR(221);

		ParamDefTable[206].setChildren(Children, 15);
	}

	// SetChildren for: nodeIndex=224, longName="p3BodyDescTemplate"
	{
		static Definition* Children[11];
		Children[0] = PDEF_PTR(225);
		Children[1] = PDEF_PTR(226);
		Children[2] = PDEF_PTR(229);
		Children[3] = PDEF_PTR(230);
		Children[4] = PDEF_PTR(231);
		Children[5] = PDEF_PTR(232);
		Children[6] = PDEF_PTR(233);
		Children[7] = PDEF_PTR(234);
		Children[8] = PDEF_PTR(235);
		Children[9] = PDEF_PTR(236);
		Children[10] = PDEF_PTR(237);

		ParamDefTable[224].setChildren(Children, 11);
	}

	// SetChildren for: nodeIndex=226, longName="p3BodyDescTemplate.flags"
	{
		static Definition* Children[2];
		Children[0] = PDEF_PTR(227);
		Children[1] = PDEF_PTR(228);

		ParamDefTable[226].setChildren(Children, 2);
	}

	// SetChildren for: nodeIndex=238, longName="structureSettings"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(239);
		Children[1] = PDEF_PTR(240);
		Children[2] = PDEF_PTR(241);

		ParamDefTable[238].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=242, longName="defaultBehaviorGroup"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(243);
		Children[1] = PDEF_PTR(244);
		Children[2] = PDEF_PTR(245);
		Children[3] = PDEF_PTR(246);
		Children[4] = PDEF_PTR(250);
		Children[5] = PDEF_PTR(254);
		Children[6] = PDEF_PTR(255);
		Children[7] = PDEF_PTR(256);
		Children[8] = PDEF_PTR(257);
		Children[9] = PDEF_PTR(258);
		Children[10] = PDEF_PTR(259);
		Children[11] = PDEF_PTR(265);

		ParamDefTable[242].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=246, longName="defaultBehaviorGroup.damageSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(247);
		Children[1] = PDEF_PTR(248);
		Children[2] = PDEF_PTR(249);

		ParamDefTable[246].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=250, longName="defaultBehaviorGroup.damageColorSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(251);
		Children[1] = PDEF_PTR(252);
		Children[2] = PDEF_PTR(253);

		ParamDefTable[250].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=259, longName="defaultBehaviorGroup.groupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(260);
		Children[1] = PDEF_PTR(261);
		Children[2] = PDEF_PTR(262);
		Children[3] = PDEF_PTR(263);
		Children[4] = PDEF_PTR(264);

		ParamDefTable[259].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=266, longName="behaviorGroups"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(267);

		ParamDefTable[266].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=267, longName="behaviorGroups[]"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(268);
		Children[1] = PDEF_PTR(269);
		Children[2] = PDEF_PTR(270);
		Children[3] = PDEF_PTR(271);
		Children[4] = PDEF_PTR(275);
		Children[5] = PDEF_PTR(279);
		Children[6] = PDEF_PTR(280);
		Children[7] = PDEF_PTR(281);
		Children[8] = PDEF_PTR(282);
		Children[9] = PDEF_PTR(283);
		Children[10] = PDEF_PTR(284);
		Children[11] = PDEF_PTR(290);

		ParamDefTable[267].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=271, longName="behaviorGroups[].damageSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(272);
		Children[1] = PDEF_PTR(273);
		Children[2] = PDEF_PTR(274);

		ParamDefTable[271].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=275, longName="behaviorGroups[].damageColorSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(276);
		Children[1] = PDEF_PTR(277);
		Children[2] = PDEF_PTR(278);

		ParamDefTable[275].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=284, longName="behaviorGroups[].groupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(285);
		Children[1] = PDEF_PTR(286);
		Children[2] = PDEF_PTR(287);
		Children[3] = PDEF_PTR(288);
		Children[4] = PDEF_PTR(289);

		ParamDefTable[284].setChildren(Children, 5);
	}

	mBuiltFlag = true;

}
void DestructibleActorParam_0p29::initStrings(void)
{
	crumbleEmitterName.isAllocated = false;
	crumbleEmitterName.buf = (const char*)0;
	dustEmitterName.isAllocated = false;
	dustEmitterName.buf = (const char*)0;
	defaultBehaviorGroup.name.isAllocated = true;
	defaultBehaviorGroup.name.buf = NULL;
}

void DestructibleActorParam_0p29::initDynamicArrays(void)
{
	overrideSkinnedMaterialNames.buf = NULL;
	overrideSkinnedMaterialNames.isAllocated = true;
	overrideSkinnedMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	overrideSkinnedMaterialNames.arraySizes[0] = 0;
	overrideStaticMaterialNames.buf = NULL;
	overrideStaticMaterialNames.isAllocated = true;
	overrideStaticMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	overrideStaticMaterialNames.arraySizes[0] = 0;
	depthParameters.buf = NULL;
	depthParameters.isAllocated = true;
	depthParameters.elementSize = sizeof(DestructibleDepthParameters_Type);
	depthParameters.arraySizes[0] = 0;
	behaviorGroups.buf = NULL;
	behaviorGroups.isAllocated = true;
	behaviorGroups.elementSize = sizeof(BehaviorGroup_Type);
	behaviorGroups.arraySizes[0] = 0;
}

void DestructibleActorParam_0p29::initDefaults(void)
{

	freeStrings();
	freeReferences();
	freeDynamicArrays();
	crumbleParticleSpacing = float(0);
	dustParticleSpacing = float(0);
	{
		const float value[12] = {true};
		for (int i = 0; i < 12; ++i)
		{
			globalPose[i] = value[i];
		}
	}
	scale = physx::PxVec3(init(1, 1, 1));
	dynamic = bool(true);
	supportDepth = uint32_t(0);
	formExtendedStructures = bool(false);
	performDetailedOverlapTestForExtendedStructures = bool(true);
	keepPreviousFrameBoneBuffer = bool(false);
	doNotCreateRenderable = bool(false);
	useAssetDefinedSupport = bool(false);
	useWorldSupport = bool(false);
	renderStaticChunksSeparately = bool(false);
	keepVisibleBonesPacked = bool(true);
	createChunkEvents = bool(false);
	sleepVelocityFrameDecayConstant = float(1);
	useHardSleeping = bool(false);
	destructibleParameters.damageCap = float(0);
	destructibleParameters.forceToDamage = float(0);
	destructibleParameters.impactVelocityThreshold = float(0);
	destructibleParameters.minimumFractureDepth = uint32_t(0);
	destructibleParameters.impactDamageDefaultDepth = int32_t(-1);
	destructibleParameters.debrisDepth = int32_t(-1);
	destructibleParameters.essentialDepth = uint32_t(0);
	destructibleParameters.debrisLifetimeMin = float(1);
	destructibleParameters.debrisLifetimeMax = float(10);
	destructibleParameters.debrisMaxSeparationMin = float(1);
	destructibleParameters.debrisMaxSeparationMax = float(10);
	destructibleParameters.debrisDestructionProbability = float(0);
	destructibleParameters.validBounds = physx::PxBounds3(init(-1000, -1000, -1000, 1000, 1000, 1000));
	destructibleParameters.maxChunkSpeed = float(0);
	destructibleParameters.flags.ACCUMULATE_DAMAGE = bool(true);
	destructibleParameters.flags.DEBRIS_TIMEOUT = bool(false);
	destructibleParameters.flags.DEBRIS_MAX_SEPARATION = bool(false);
	destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS = bool(false);
	destructibleParameters.flags.ACCURATE_RAYCASTS = bool(false);
	destructibleParameters.flags.USE_VALID_BOUNDS = bool(false);
	destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE = bool(false);
	destructibleParameters.fractureImpulseScale = float(0);
	destructibleParameters.damageDepthLimit = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunkDominanceGroup = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunksGroupsMask.useGroupsMask = bool(false);
	destructibleParameters.dynamicChunksGroupsMask.bits0 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits1 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits2 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits3 = uint32_t(0);
	destructibleParameters.runtimeFracture.RuntimeFractureType = (const char*)"VORONOI";
	destructibleParameters.runtimeFracture.sheetFracture = bool(true);
	destructibleParameters.runtimeFracture.depthLimit = uint32_t(2);
	destructibleParameters.runtimeFracture.destroyIfAtDepthLimit = bool(false);
	destructibleParameters.runtimeFracture.minConvexSize = float(0.02);
	destructibleParameters.runtimeFracture.impulseScale = float(1);
	destructibleParameters.runtimeFracture.glass.numSectors = uint32_t(10);
	destructibleParameters.runtimeFracture.glass.sectorRand = float(0.3);
	destructibleParameters.runtimeFracture.glass.firstSegmentSize = float(0.06);
	destructibleParameters.runtimeFracture.glass.segmentScale = float(1.4);
	destructibleParameters.runtimeFracture.glass.segmentRand = float(0.3);
	destructibleParameters.runtimeFracture.voronoi.dimensions = physx::PxVec3(physx::PxVec3(10.0f));
	destructibleParameters.runtimeFracture.voronoi.numCells = uint32_t(1);
	destructibleParameters.runtimeFracture.voronoi.biasExp = float(10);
	destructibleParameters.runtimeFracture.voronoi.maxDist = float(PX_MAX_F32);
	destructibleParameters.runtimeFracture.attachment.posX = bool(false);
	destructibleParameters.runtimeFracture.attachment.negX = bool(false);
	destructibleParameters.runtimeFracture.attachment.posY = bool(false);
	destructibleParameters.runtimeFracture.attachment.negY = bool(false);
	destructibleParameters.runtimeFracture.attachment.posZ = bool(false);
	destructibleParameters.runtimeFracture.attachment.negZ = bool(false);
	destructibleParameters.supportStrength = float(-1);
	destructibleParameters.legacyChunkBoundsTestSetting = int8_t(-1);
	destructibleParameters.legacyDamageRadiusSpreadSetting = int8_t(-1);
	shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER = bool(false);
	shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE = bool(false);
	shapeDescTemplate.flags.NX_TRIGGER_ON_STAY = bool(false);
	shapeDescTemplate.flags.NX_SF_VISUALIZATION = bool(true);
	shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_FEATURE_INDICES = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING = bool(false);
	shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE = bool(false);
	shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY = bool(true);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY = bool(true);
	shapeDescTemplate.collisionGroup = uint16_t(0);
	shapeDescTemplate.groupsMask.useGroupsMask = bool(false);
	shapeDescTemplate.groupsMask.bits0 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits1 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits2 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits3 = uint32_t(0);
	shapeDescTemplate.materialIndex = uint16_t(0);
	shapeDescTemplate.density = float(1);
	shapeDescTemplate.skinWidth = float(-1);
	shapeDescTemplate.userData = uint64_t(0);
	shapeDescTemplate.name = uint64_t(0);
	actorDescTemplate.flags.NX_AF_DISABLE_COLLISION = bool(false);
	actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE = bool(false);
	actorDescTemplate.flags.NX_AF_LOCK_COM = bool(false);
	actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION = bool(false);
	actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION = bool(false);
	actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION = bool(false);
	actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING = bool(false);
	actorDescTemplate.density = float(1);
	actorDescTemplate.actorCollisionGroup = uint16_t(0);
	actorDescTemplate.dominanceGroup = uint16_t(0);
	actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION = bool(false);
	actorDescTemplate.forceFieldMaterial = uint16_t(0);
	actorDescTemplate.userData = uint64_t(0);
	actorDescTemplate.name = uint64_t(0);
	actorDescTemplate.compartment = uint64_t(0);
	bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY = bool(false);
	bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL = bool(false);
	bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST = bool(true);
	bodyDescTemplate.flags.NX_BF_VISUALIZATION = bool(true);
	bodyDescTemplate.wakeUpCounter = float(0.4);
	bodyDescTemplate.linearDamping = float(0);
	bodyDescTemplate.angularDamping = float(0.05);
	bodyDescTemplate.maxAngularVelocity = float(-1);
	bodyDescTemplate.CCDMotionThreshold = float(0);
	bodyDescTemplate.sleepLinearVelocity = float(-1);
	bodyDescTemplate.sleepAngularVelocity = float(-1);
	bodyDescTemplate.solverIterationCount = uint32_t(4);
	bodyDescTemplate.sleepEnergyThreshold = float(0.005);
	bodyDescTemplate.sleepDamping = float(0);
	bodyDescTemplate.contactReportThreshold = float(PX_MAX_F32);
	p3ShapeDescTemplate.flags.eSIMULATION_SHAPE = bool(true);
	p3ShapeDescTemplate.flags.eSCENE_QUERY_SHAPE = bool(true);
	p3ShapeDescTemplate.flags.eTRIGGER_SHAPE = bool(false);
	p3ShapeDescTemplate.flags.eVISUALIZATION = bool(true);
	p3ShapeDescTemplate.flags.ePARTICLE_DRAIN = bool(false);
	p3ShapeDescTemplate.flags.eDEFORMABLE_DRAIN = bool(false);
	p3ShapeDescTemplate.simulationFilterData.word0 = uint32_t(0);
	p3ShapeDescTemplate.simulationFilterData.word1 = uint32_t(0);
	p3ShapeDescTemplate.simulationFilterData.word2 = uint32_t(0);
	p3ShapeDescTemplate.simulationFilterData.word3 = uint32_t(0);
	p3ShapeDescTemplate.queryFilterData.word0 = uint32_t(0);
	p3ShapeDescTemplate.queryFilterData.word1 = uint32_t(0);
	p3ShapeDescTemplate.queryFilterData.word2 = uint32_t(0);
	p3ShapeDescTemplate.queryFilterData.word3 = uint32_t(0);
	p3ShapeDescTemplate.material = uint64_t(0);
	p3ShapeDescTemplate.contactOffset = float(0.02);
	p3ShapeDescTemplate.restOffset = float(0);
	p3ShapeDescTemplate.userData = uint64_t(0);
	p3ShapeDescTemplate.name = uint64_t(0);
	p3ActorDescTemplate.flags.eVISUALIZATION = bool(true);
	p3ActorDescTemplate.flags.eDISABLE_GRAVITY = bool(false);
	p3ActorDescTemplate.flags.eSEND_SLEEP_NOTIFIES = bool(true);
	p3ActorDescTemplate.dominanceGroup = uint8_t(0);
	p3ActorDescTemplate.ownerClient = uint8_t(0);
	p3ActorDescTemplate.clientBehaviorBits = uint32_t(0);
	p3ActorDescTemplate.contactReportFlags.eRESOLVE_CONTACTS = bool(false);
	p3ActorDescTemplate.contactReportFlags.eMODIFY_CONTACTS = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_FOUND = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_PERSISTS = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_TOUCH_LOST = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_FOUND = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_PERSISTS = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_THRESHOLD_FORCE_LOST = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_POINTS = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCES = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FORCE_PER_POINT = bool(false);
	p3ActorDescTemplate.contactReportFlags.eNOTIFY_CONTACT_FEATURE_INDICES_PER_POINT = bool(false);
	p3ActorDescTemplate.contactReportFlags.eCCD_LINEAR = bool(false);
	p3ActorDescTemplate.contactReportFlags.eCONTACT_DEFAULT = bool(false);
	p3ActorDescTemplate.contactReportFlags.eTRIGGER_DEFAULT = bool(false);
	p3ActorDescTemplate.userData = uint64_t(0);
	p3ActorDescTemplate.name = uint64_t(0);
	p3BodyDescTemplate.density = float(1);
	p3BodyDescTemplate.flags.eKINEMATIC = bool(false);
	p3BodyDescTemplate.flags.eENABLE_CCD = bool(false);
	p3BodyDescTemplate.sleepThreshold = float(0.005);
	p3BodyDescTemplate.wakeUpCounter = float(0.4);
	p3BodyDescTemplate.linearDamping = float(0);
	p3BodyDescTemplate.angularDamping = float(0.05);
	p3BodyDescTemplate.maxAngularVelocity = float(7);
	p3BodyDescTemplate.solverIterationCount = uint32_t(4);
	p3BodyDescTemplate.velocityIterationCount = uint32_t(1);
	p3BodyDescTemplate.contactReportThreshold = float(PX_MAX_F32);
	p3BodyDescTemplate.sleepLinearVelocity = float(-1);
	structureSettings.useStressSolver = bool(false);
	structureSettings.stressSolverTimeDelay = float(1.0);
	structureSettings.stressSolverMassThreshold = float(0.0);
	defaultBehaviorGroup.damageThreshold = float(1);
	defaultBehaviorGroup.damageToRadius = float(0.1);
	defaultBehaviorGroup.damageSpread.minimumRadius = float(0);
	defaultBehaviorGroup.damageSpread.radiusMultiplier = float(1);
	defaultBehaviorGroup.damageSpread.falloffExponent = float(1);
	defaultBehaviorGroup.damageColorSpread.minimumRadius = float(0);
	defaultBehaviorGroup.damageColorSpread.radiusMultiplier = float(1);
	defaultBehaviorGroup.damageColorSpread.falloffExponent = float(1);
	defaultBehaviorGroup.damageColorChange = physx::PxVec4(initVec4(0, 0, 0, 0));
	defaultBehaviorGroup.materialStrength = float(0);
	defaultBehaviorGroup.density = float(0);
	defaultBehaviorGroup.fadeOut = float(1);
	defaultBehaviorGroup.maxDepenetrationVelocity = float(PX_MAX_F32);
	defaultBehaviorGroup.groupsMask.useGroupsMask = bool(false);
	defaultBehaviorGroup.groupsMask.bits0 = uint32_t(0);
	defaultBehaviorGroup.groupsMask.bits1 = uint32_t(0);
	defaultBehaviorGroup.groupsMask.bits2 = uint32_t(0);
	defaultBehaviorGroup.groupsMask.bits3 = uint32_t(0);
	defaultBehaviorGroup.userData = uint64_t(0);
	deleteChunksLeavingUserDefinedBB = bool(false);
	deleteChunksEnteringUserDefinedBB = bool(false);

	initDynamicArrays();
	initStrings();
	initReferences();
}

void DestructibleActorParam_0p29::initReferences(void)
{
}

void DestructibleActorParam_0p29::freeDynamicArrays(void)
{
	if (overrideSkinnedMaterialNames.isAllocated && overrideSkinnedMaterialNames.buf)
	{
		mParameterizedTraits->free(overrideSkinnedMaterialNames.buf);
	}
	if (overrideStaticMaterialNames.isAllocated && overrideStaticMaterialNames.buf)
	{
		mParameterizedTraits->free(overrideStaticMaterialNames.buf);
	}
	if (depthParameters.isAllocated && depthParameters.buf)
	{
		mParameterizedTraits->free(depthParameters.buf);
	}
	if (behaviorGroups.isAllocated && behaviorGroups.buf)
	{
		mParameterizedTraits->free(behaviorGroups.buf);
	}
}

void DestructibleActorParam_0p29::freeStrings(void)
{

	if (crumbleEmitterName.isAllocated && crumbleEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)crumbleEmitterName.buf);
	}

	if (dustEmitterName.isAllocated && dustEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)dustEmitterName.buf);
	}

	for (int i = 0; i < overrideSkinnedMaterialNames.arraySizes[0]; ++i)
	{
		if (overrideSkinnedMaterialNames.buf[i].isAllocated && overrideSkinnedMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)overrideSkinnedMaterialNames.buf[i].buf);
		}
	}

	for (int i = 0; i < overrideStaticMaterialNames.arraySizes[0]; ++i)
	{
		if (overrideStaticMaterialNames.buf[i].isAllocated && overrideStaticMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)overrideStaticMaterialNames.buf[i].buf);
		}
	}

	if (defaultBehaviorGroup.name.isAllocated && defaultBehaviorGroup.name.buf)
	{
		mParameterizedTraits->strfree((char*)defaultBehaviorGroup.name.buf);
	}

	for (int i = 0; i < behaviorGroups.arraySizes[0]; ++i)
	{
		if (behaviorGroups.buf[i].name.isAllocated && behaviorGroups.buf[i].name.buf)
		{
			mParameterizedTraits->strfree((char*)behaviorGroups.buf[i].name.buf);
		}
	}
}

void DestructibleActorParam_0p29::freeReferences(void)
{
}

} // namespace parameterized
} // namespace nvidia
