#
# Build NvBlastExtPhysX Common
#


SET(COMMON_SOURCE_DIR ${PROJECT_SOURCE_DIR}/common)

SET(COMMON_EXT_SOURCE_DIR ${PROJECT_SOURCE_DIR}/extensions/common/source)
SET(PHYSX_EXT_SOURCE_DIR ${PROJECT_SOURCE_DIR}/extensions/physx/source)
SET(COMMON_EXT_INCLUDE_DIR ${PROJECT_SOURCE_DIR}/extensions/common/include)
SET(PHYSX_EXT_INCLUDE_DIR ${PROJECT_SOURCE_DIR}/extensions/physx/include)

FIND_PACKAGE(PxSharedSDK ${PM_physxsdk_VERSION} REQUIRED)
FIND_PACKAGE(PhysXSDK ${PM_pxshared_VERSION} REQUIRED)

# Include here after the directories are defined so that the platform specific file can use the variables.
include(${PROJECT_CMAKE_FILES_DIR}/${TARGET_BUILD_PLATFORM}/NvBlastExtPhysX.cmake)

SET(COMMON_FILES
	${BLASTEXT_PLATFORM_COMMON_FILES}
	
	${COMMON_SOURCE_DIR}/NvBlastAssert.cpp
	${COMMON_SOURCE_DIR}/NvBlastAssert.h

	${COMMON_SOURCE_DIR}/NvBlastArray.h
	${COMMON_SOURCE_DIR}/NvBlastHashMap.h
	${COMMON_SOURCE_DIR}/NvBlastHashSet.h
)

SET(PUBLIC_FILES
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtImpactDamageManager.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPx.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxActor.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxAsset.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxCollisionBuilder.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxFamily.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxListener.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxManager.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxStressSolver.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtPxTask.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtSync.h
)

SET(EXT_PHYSICS_FILES
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtImpactDamageManager.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxStressSolverImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxStressSolverImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxActorImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxActorImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxAssetImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxAssetImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxCollisionBuilderImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxCollisionBuilderImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxFamilyImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxFamilyImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxManagerImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxManagerImpl.cpp
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxTaskImpl.h
	${PHYSX_EXT_SOURCE_DIR}/physics/NvBlastExtPxTaskImpl.cpp
)

SET(EXT_CALLBACKS_FILES
    ${PHYSX_EXT_INCLUDE_DIR}/NvBlastExtCustomProfiler.h
	${PHYSX_EXT_INCLUDE_DIR}/NvBlastPxCallbacks.h
)

SET(EXT_SYNC_FILES
	${PHYSX_EXT_SOURCE_DIR}/sync/NvBlastExtSync.cpp
)

ADD_LIBRARY(NvBlastExtPhysX ${BLASTEXT_PHYSX_LIBTYPE}
	${COMMON_FILES}
	${PUBLIC_FILES}

	${EXT_PHYSICS_FILES}
	${EXT_SYNC_FILES}
	${EXT_CALLBACKS_FILES}
)

SOURCE_GROUP("common" FILES ${COMMON_FILES})
SOURCE_GROUP("public" FILES ${PUBLIC_FILES})
SOURCE_GROUP("src\\physics" FILES ${EXT_PHYSICS_FILES})
SOURCE_GROUP("src\\sync" FILES ${EXT_SYNC_FILES})
SOURCE_GROUP("src\\callbacks" FILES ${EXT_CALLBACKS_FILES})


# Target specific compile options

TARGET_INCLUDE_DIRECTORIES(NvBlastExtPhysX 
	PRIVATE ${BLASTEXT_PLATFORM_INCLUDES}

	PUBLIC ${PROJECT_SOURCE_DIR}/lowlevel/include
	PUBLIC ${PHYSX_EXT_INCLUDE_DIR}

	PRIVATE ${PROJECT_SOURCE_DIR}/common
	PRIVATE ${COMMON_EXT_SOURCE_DIR}
	
	PRIVATE ${PHYSX_EXT_SOURCE_DIR}/physics
	PRIVATE ${PHYSX_EXT_SOURCE_DIR}/sync
	
   	PUBLIC ${PROJECT_SOURCE_DIR}/extensions/profiler/include
	PUBLIC ${PROJECT_SOURCE_DIR}/extensions/authoringCommon/include

	PUBLIC ${PHYSXSDK_INCLUDE_DIRS}
	PRIVATE ${PXSHAREDSDK_INCLUDE_DIRS}
	PUBLIC ${BLAST_ROOT_DIR}/shared/filebuf/include
)

TARGET_COMPILE_DEFINITIONS(NvBlastExtPhysX
	PRIVATE ${BLASTEXT_COMPILE_DEFS}
)

# Warning disables for Capn Proto
TARGET_COMPILE_OPTIONS(NvBlastExtPhysX
	PRIVATE ${BLASTEXT_PLATFORM_COMPILE_OPTIONS}
)

SET_TARGET_PROPERTIES(NvBlastExtPhysX PROPERTIES 
	PDB_NAME_DEBUG "NvBlastExtPhysX${CMAKE_DEBUG_POSTFIX}"
	PDB_NAME_CHECKED "NvBlastExtPhysX${CMAKE_CHECKED_POSTFIX}"
	PDB_NAME_PROFILE "NvBlastExtPhysX${CMAKE_PROFILE_POSTFIX}"
	PDB_NAME_RELEASE "NvBlastExtPhysX${CMAKE_RELEASE_POSTFIX}"
    ARCHIVE_OUTPUT_DIRECTORY_DEBUG "${BL_LIB_OUTPUT_DIR}/debug"
    LIBRARY_OUTPUT_DIRECTORY_DEBUG "${BL_DLL_OUTPUT_DIR}/debug"
    RUNTIME_OUTPUT_DIRECTORY_DEBUG "${BL_EXE_OUTPUT_DIR}/debug"
    ARCHIVE_OUTPUT_DIRECTORY_CHECKED "${BL_LIB_OUTPUT_DIR}/checked"
    LIBRARY_OUTPUT_DIRECTORY_CHECKED "${BL_DLL_OUTPUT_DIR}/checked"
    RUNTIME_OUTPUT_DIRECTORY_CHECKED "${BL_EXE_OUTPUT_DIR}/checked"
    ARCHIVE_OUTPUT_DIRECTORY_PROFILE "${BL_LIB_OUTPUT_DIR}/profile"
    LIBRARY_OUTPUT_DIRECTORY_PROFILE "${BL_DLL_OUTPUT_DIR}/profile"
    RUNTIME_OUTPUT_DIRECTORY_PROFILE "${BL_EXE_OUTPUT_DIR}/profile"
    ARCHIVE_OUTPUT_DIRECTORY_RELEASE "${BL_LIB_OUTPUT_DIR}/release"
    LIBRARY_OUTPUT_DIRECTORY_RELEASE "${BL_DLL_OUTPUT_DIR}/release"
    RUNTIME_OUTPUT_DIRECTORY_RELEASE "${BL_EXE_OUTPUT_DIR}/release"
)

# Do final direct sets after the target has been defined
TARGET_LINK_LIBRARIES(NvBlastExtPhysX 
	PUBLIC NvBlastTk NvBlastExtShaders NvBlastExtStress
	PUBLIC $<$<CONFIG:debug>:${PHYSX_LIB_DEBUG}> $<$<CONFIG:debug>:${PHYSXCOOKING_LIB_DEBUG}> $<$<CONFIG:debug>:${PHYSXEXTENSIONS_STATIC_LIB_DEBUG}> $<$<CONFIG:debug>:${PHYSXFOUNDATION_LIB_DEBUG}>
	PUBLIC $<$<CONFIG:checked>:${PHYSX_LIB_CHECKED}> $<$<CONFIG:checked>:${PHYSXCOOKING_LIB_CHECKED}> $<$<CONFIG:checked>:${PHYSXEXTENSIONS_STATIC_LIB_CHECKED}> $<$<CONFIG:checked>:${PHYSXFOUNDATION_LIB_CHECKED}>
	PUBLIC $<$<CONFIG:profile>:${PHYSX_LIB_PROFILE}> $<$<CONFIG:profile>:${PHYSXCOOKING_LIB_PROFILE}> $<$<CONFIG:profile>:${PHYSXEXTENSIONS_STATIC_LIB_PROFILE}> $<$<CONFIG:profile>:${PHYSXFOUNDATION_LIB_PROFILE}>
	PUBLIC $<$<CONFIG:release>:${PHYSX_LIB}> $<$<CONFIG:release>:${PHYSXCOOKING_LIB}> $<$<CONFIG:release>:${PHYSXEXTENSIONS_STATIC_LIB}> $<$<CONFIG:release>:${PHYSXFOUNDATION_LIB}>

	PUBLIC ${BLASTEXT_PLATFORM_LINKED_LIBS}
)
