#
# Build NvBlastExt Common
#


SET(COMMON_SOURCE_DIR ${PROJECT_SOURCE_DIR}/common)

SET(EXPORTER_EXT_SOURCE_DIR ${PROJECT_SOURCE_DIR}/extensions/exporter/source)
SET(COMMON_EXT_SOURCE_DIR ${PROJECT_SOURCE_DIR}/extensions/common/source)
SET(EXPORTER_EXT_INCLUDE_DIR ${PROJECT_SOURCE_DIR}/extensions/exporter/include)
SET(EXT_AUTHORING_INCLUDE_DIR ${BLAST_ROOT_DIR}/sdk/extensions/authoring/include)
SET(TK_INCLUDE_DIR ${BLAST_ROOT_DIR}/sdk/toolkit/include)

FIND_PACKAGE(PxSharedSDK ${PM_physxsdk_VERSION} REQUIRED)
FIND_PACKAGE(PhysXSDK ${PM_pxshared_VERSION} REQUIRED)
FIND_PACKAGE(tinyObjLoader $ENV{PM_tinyObjLoader_VERSION} REQUIRED)
FIND_PACKAGE(FBXSDK $ENV{PM_FBXSDK_VERSION} REQUIRED)

# Include here after the directories are defined so that the platform specific file can use the variables.
include(${PROJECT_CMAKE_FILES_DIR}/${TARGET_BUILD_PLATFORM}/NvBlastExtExporter.cmake)

SET(COMMON_FILES
	${BLASTEXT_PLATFORM_COMMON_FILES}
	
	#${COMMON_SOURCE_DIR}/NvBlastAssert.cpp
	#${COMMON_SOURCE_DIR}/NvBlastAssert.h
)

SET(PUBLIC_FILES
	${EXPORTER_EXT_INCLUDE_DIR}/NvBlastExtExporter.h
	${EXPORTER_EXT_INCLUDE_DIR}/NvBlastExtExporterJsonCollision.h
)

SET(EXT_EXPORTER_FILES	
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxUtils.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxUtils.h
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporter.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxReader.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxReader.h
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxWriter.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterFbxWriter.h
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterObjReader.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterObjReader.h
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterObjWriter.cpp
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterObjWriter.h
	${EXPORTER_EXT_SOURCE_DIR}/NvBlastExtExporterJsonCollision.cpp
)

ADD_LIBRARY(NvBlastExtExporter SHARED 
	${COMMON_FILES}
	${PUBLIC_FILES}
	${EXT_EXPORTER_FILES}
)

SOURCE_GROUP("common" FILES ${COMMON_FILES})
SOURCE_GROUP("public" FILES ${PUBLIC_FILES})
SOURCE_GROUP("src" FILES ${EXT_EXPORTER_FILES})


# Target specific compile options

TARGET_INCLUDE_DIRECTORIES(NvBlastExtExporter
	PRIVATE ${BLASTEXT_PLATFORM_INCLUDES}
	PRIVATE ${TK_INCLUDE_DIR}

	PUBLIC ${PROJECT_SOURCE_DIR}/lowlevel/include
	PUBLIC ${EXPORTER_EXT_INCLUDE_DIR}

	PRIVATE ${PROJECT_SOURCE_DIR}/common
	PRIVATE ${COMMON_EXT_SOURCE_DIR}
	PUBLIC ${EXT_AUTHORING_INCLUDE_DIR}
	
	PRIVATE ${EXPORTER_EXT_SOURCE_DIR}

	PRIVATE ${PXSHAREDSDK_INCLUDE_DIRS}
	PRIVATE ${PHYSXSDK_INCLUDE_DIRS}
	
	PRIVATE ${TINYOBJLOADER_INCLUDE_DIRS}
	PRIVATE ${FBXSDK_INCLUDE_DIRS}
)

TARGET_COMPILE_DEFINITIONS(NvBlastExtExporter
	PRIVATE ${BLASTEXT_COMPILE_DEFS} 
)

TARGET_COMPILE_OPTIONS(NvBlastExtExporter
	PRIVATE ${BLASTEXT_PLATFORM_COMPILE_OPTIONS}
)

SET_TARGET_PROPERTIES(NvBlastExtExporter PROPERTIES 
	PDB_NAME_DEBUG "NvBlastExtExporter${CMAKE_DEBUG_POSTFIX}"
	PDB_NAME_CHECKED "NvBlastExtExporter${CMAKE_CHECKED_POSTFIX}"
	PDB_NAME_PROFILE "NvBlastExtExporter${CMAKE_PROFILE_POSTFIX}"
	PDB_NAME_RELEASE "NvBlastExtExporter${CMAKE_RELEASE_POSTFIX}"
    ARCHIVE_OUTPUT_DIRECTORY_DEBUG "${BL_LIB_OUTPUT_DIR}/debug"
    LIBRARY_OUTPUT_DIRECTORY_DEBUG "${BL_DLL_OUTPUT_DIR}/debug"
    RUNTIME_OUTPUT_DIRECTORY_DEBUG "${BL_EXE_OUTPUT_DIR}/debug"
    ARCHIVE_OUTPUT_DIRECTORY_CHECKED "${BL_LIB_OUTPUT_DIR}/checked"
    LIBRARY_OUTPUT_DIRECTORY_CHECKED "${BL_DLL_OUTPUT_DIR}/checked"
    RUNTIME_OUTPUT_DIRECTORY_CHECKED "${BL_EXE_OUTPUT_DIR}/checked"
    ARCHIVE_OUTPUT_DIRECTORY_PROFILE "${BL_LIB_OUTPUT_DIR}/profile"
    LIBRARY_OUTPUT_DIRECTORY_PROFILE "${BL_DLL_OUTPUT_DIR}/profile"
    RUNTIME_OUTPUT_DIRECTORY_PROFILE "${BL_EXE_OUTPUT_DIR}/profile"
    ARCHIVE_OUTPUT_DIRECTORY_RELEASE "${BL_LIB_OUTPUT_DIR}/release"
    LIBRARY_OUTPUT_DIRECTORY_RELEASE "${BL_DLL_OUTPUT_DIR}/release"
    RUNTIME_OUTPUT_DIRECTORY_RELEASE "${BL_EXE_OUTPUT_DIR}/release"
)

# Do final direct sets after the target has been defined
TARGET_LINK_LIBRARIES(NvBlastExtExporter 
	PUBLIC NvBlast NvBlastGlobals NvBlastTk NvBlastExtAuthoring
	PUBLIC ${BLASTEXT_PLATFORM_LINKED_LIBS}
	PUBLIC ${FBXSDK_LIBRARIES}
)
