#
# Build SampleAssetViewer Common
#


SET(SAV_SOURCE_DIR ${PROJECT_SOURCE_DIR}/SampleAssetViewer)
SET(SAMPLEBASE_SOURCE_DIR ${PROJECT_SOURCE_DIR}/SampleBase)


# Include here after the directories are defined so that the platform specific file can use the variables.
include(${PROJECT_CMAKE_FILES_DIR}/${TARGET_BUILD_PLATFORM}/SampleAssetViewer.cmake)

SET(ROOT_FILES
	${SAV_SOURCE_DIR}/Main.cpp
)

ADD_EXECUTABLE(SampleAssetViewer
	${ROOT_FILES}
)

set_target_properties(SampleAssetViewer 
	PROPERTIES DEBUG_POSTFIX ${CMAKE_DEBUG_POSTFIX}
	CHECKED_POSTFIX ${CMAKE_CHECKED_POSTFIX}
	RELEASE_POSTFIX ${CMAKE_RELEASE_POSTFIX}
	PROFILE_POSTFIX ${CMAKE_PROFILE_POSTFIX}
)

SOURCE_GROUP("Source" FILES ${ROOT_FILES})

# Target specific compile options
TARGET_INCLUDE_DIRECTORIES(SampleAssetViewer 
	PRIVATE ${SAMPLEASSETVIEWER_PLATFORM_INCLUDES}

	PRIVATE ${TCLAP_INCLUDE_DIRS}
	PRIVATE ${PXSHAREDSDK_INCLUDE_DIRS}
	
	PRIVATE ${SAMPLEBASE_SOURCE_DIR}
	
)

TARGET_COMPILE_DEFINITIONS(SampleAssetViewer
	PRIVATE ${SAMPLEASSETVIEWER_COMPILE_DEFS}
)

SET_TARGET_PROPERTIES(SampleAssetViewer PROPERTIES 
	COMPILE_PDB_NAME_DEBUG "SampleAssetViewer${CMAKE_DEBUG_POSTFIX}"
	COMPILE_PDB_NAME_CHECKED "SampleAssetViewer${CMAKE_CHECKED_POSTFIX}"
	COMPILE_PDB_NAME_PROFILE "SampleAssetViewer${CMAKE_PROFILE_POSTFIX}"
	COMPILE_PDB_NAME_RELEASE "SampleAssetViewer${CMAKE_RELEASE_POSTFIX}"
    ARCHIVE_OUTPUT_DIRECTORY_DEBUG "${BL_LIB_OUTPUT_DIR}/debug"
    LIBRARY_OUTPUT_DIRECTORY_DEBUG "${BL_DLL_OUTPUT_DIR}/debug"
    RUNTIME_OUTPUT_DIRECTORY_DEBUG "${BL_EXE_OUTPUT_DIR}/debug"
    ARCHIVE_OUTPUT_DIRECTORY_CHECKED "${BL_LIB_OUTPUT_DIR}/checked"
    LIBRARY_OUTPUT_DIRECTORY_CHECKED "${BL_DLL_OUTPUT_DIR}/checked"
    RUNTIME_OUTPUT_DIRECTORY_CHECKED "${BL_EXE_OUTPUT_DIR}/checked"
    ARCHIVE_OUTPUT_DIRECTORY_PROFILE "${BL_LIB_OUTPUT_DIR}/profile"
    LIBRARY_OUTPUT_DIRECTORY_PROFILE "${BL_DLL_OUTPUT_DIR}/profile"
    RUNTIME_OUTPUT_DIRECTORY_PROFILE "${BL_EXE_OUTPUT_DIR}/profile"
    ARCHIVE_OUTPUT_DIRECTORY_RELEASE "${BL_LIB_OUTPUT_DIR}/release"
    LIBRARY_OUTPUT_DIRECTORY_RELEASE "${BL_DLL_OUTPUT_DIR}/release"
    RUNTIME_OUTPUT_DIRECTORY_RELEASE "${BL_EXE_OUTPUT_DIR}/release"
)

TARGET_COMPILE_OPTIONS(SampleAssetViewer PRIVATE /wd4005 /wd4244 ${SAMPLEASSETVIEWER_COMPILE_OPTIONS})

# Do final direct sets after the target has been defined
TARGET_LINK_LIBRARIES(SampleAssetViewer PUBLIC SampleBase)

SET_TARGET_PROPERTIES(SampleAssetViewer PROPERTIES LINK_FLAGS ${SAMPLEASSETVIEWER_LINK_FLAGS})
