% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{spatialFeaturePlot}
\alias{spatialFeaturePlot}
\title{A spatial feature plots}
\usage{
spatialFeaturePlot(
  object,
  features = NULL,
  signaling = NULL,
  pairLR.use = NULL,
  sample.use = NULL,
  enriched.only = TRUE,
  thresh = 0.05,
  do.group = TRUE,
  color.heatmap = "Spectral",
  n.colors = 8,
  direction = -1,
  do.binary = FALSE,
  cutoff = NULL,
  color.use = NULL,
  alpha = 1,
  point.size = 0.8,
  legend.size = 3,
  legend.text.size = 8,
  shape.by = 16,
  ncol = NULL,
  show.legend = TRUE,
  show.legend.combined = FALSE
)
}
\arguments{
\item{object}{cellchat object}

\item{features}{a char vector containing features to visualize. `features` can be genes or column names of `object@meta`.}

\item{signaling}{signalling names to visualize}

\item{pairLR.use}{a data frame consisting of one column named "interaction_name", defining the L-R pairs of interest}

\item{sample.use}{the sample used for visualization, which should be the element in `object@meta$samples`.}

\item{enriched.only}{whether only return the identified enriched signaling genes in the database. Default = TRUE, returning the significantly enriched signaling interactions}

\item{thresh}{threshold of the p-value for determining significant interaction when visualizing links at the level of ligands/receptors;}

\item{do.group}{set `do.group = TRUE` when only showing enriched signaling based on cell group-level communication; set `do.group = FALSE` when only showing enriched signaling based on individual cell-level communication}

\item{color.heatmap}{A character string or vector indicating the colormap option to use. It can be the avaibale color palette in brewer.pal() or viridis_pal() (e.g., "Spectral","viridis")}

\item{n.colors, direction}{n.colors: number of basic colors to generate from color palette; direction: Sets the order of colors in the scale. If 1, the default colors are used. If -1, the order of colors is reversed.}

\item{do.binary, cutoff}{whether binarizing the expression using a given cutoff}

\item{color.use}{defining the color for cells/spots expressing ligand only, expressing receptor only, expressing both ligand & receptor and cells/spots without expression of given ligands and receptors}

\item{alpha}{the transparency of individual spot}

\item{point.size}{the size of cell slot}

\item{legend.size}{the size of legend}

\item{legend.text.size}{the text size on the legend}

\item{shape.by}{the shape of individual spot}

\item{ncol}{number of columns if plotting multiple plots}

\item{show.legend}{whether show each figure legend}

\item{show.legend.combined}{whether show the figure legend for the last plot}
}
\description{
This function takes a CellChat object as input, and then plot gene expression distribution over spots/cells on the image.
}
