% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{spatialDimPlot}
\alias{spatialDimPlot}
\title{Visualize spatial cell groups}
\usage{
spatialDimPlot(
  object,
  color.use = NULL,
  group.by = NULL,
  sample.use = NULL,
  sources.use = NULL,
  targets.use = NULL,
  idents.use = NULL,
  alpha = 1,
  shape.by = 16,
  title.name = NULL,
  point.size = 2.4,
  legend.size = 5,
  legend.text.size = 8,
  legend.position = "right",
  ncol = 1,
  byrow = FALSE
)
}
\arguments{
\item{object}{cellchat object}

\item{color.use}{defining the color for each cell group}

\item{group.by}{Name of one metadata columns to group (color) cells. Default is the defined cell groups in CellChat object}

\item{sample.use}{the sample name used for visualization, which should be the element in `object@meta$samples`.}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups}

\item{idents.use}{a vector giving the index or the name of cell groups of interest}

\item{alpha}{the transparency of individual spot}

\item{shape.by}{the shape of individual spot}

\item{title.name}{title name}

\item{point.size}{the size of spots}

\item{legend.size}{the size of legend}

\item{legend.text.size}{the text size on the legend}

\item{legend.position}{legend position}

\item{ncol}{number of columns of the legend text}

\item{byrow}{arrange the legend text byrow or not}
}
\description{
This function takes a CellChat object as input, and then plot cell groups of interest.
}
