% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{rankSimilarity}
\alias{rankSimilarity}
\title{Rank the similarity of the shared signaling pathways based on their joint manifold learning}
\usage{
rankSimilarity(
  object,
  slot.name = "netP",
  type = c("functional", "structural"),
  comparison1 = NULL,
  comparison2 = c(1, 2),
  x.rotation = 90,
  title = NULL,
  color.use = NULL,
  bar.w = NULL,
  font.size = 8
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{type}{"functional","structural"}

\item{comparison1}{a numerical vector giving the datasets for comparison. This should be the same as `comparison` in `computeNetSimilarityPairwise`}

\item{comparison2}{a numerical vector with two elements giving the datasets for comparison.

If there are more than 2 datasets defined in `comparison1`, `comparison2` can be defined to indicate which two datasets used for computing the distance.
e.g., comparison2 = c(1,3) indicates the first and third datasets defined in `comparison1` will be used for comparison.}

\item{x.rotation}{rotation of x-labels}

\item{title}{main title of the plot}

\item{color.use}{defining the color}

\item{bar.w}{the width of bar plot}

\item{font.size}{font size}
}
\description{
Rank the similarity of the shared signaling pathways based on their joint manifold learning
}
