% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{projectAndRecombine}
\alias{projectAndRecombine}
\title{Perform network projecting on network when the network genes and the
experiment genes aren't exactly the same.}
\usage{
projectAndRecombine(
  gene_expression,
  adj_matrix,
  alpha,
  projecting.function = randomWalkBySolve,
  normalizeAdjMatrix = c("rows", "columns")
)
}
\arguments{
\item{gene_expression}{gene expession data to be projected
[N_genes x M_samples]}

\item{adj_matrix}{adjacenty matrix of network to perform projecting over.
Will be column-normalized.
Rownames and colnames should be genes.}

\item{alpha}{network projecting parameter (1 - restart probability in random
walk model.}

\item{projecting.function}{must be a function that takes in data, adjacency
matrix, and alpha. Will be used to perform the
actual projecting.}

\item{normalizeAdjMatrix}{which dimension (rows or columns) should the
adjacency matrix be normalized by. rows
corresponds to in-degree, columns to
out-degree.}
}
\value{
matrix with network-projected gene expression data. Genes that are
         not present in projecting network will retain original values.
}
\description{
The gene network might be defined only on a subset of genes that are
measured in any experiment. Further, an experiment might not measure all
genes that are present in the network. This function projects the experiment
data onto the gene space defined by the network prior to projecting. Then,
it projects the projected data back into the original dimansions.
}
\keyword{internal}
