% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGeneExpression}
\alias{plotGeneExpression}
\title{A Seurat wrapper function for plotting gene expression using violin plot, dot plot or bar plot}
\usage{
plotGeneExpression(
  object,
  features = NULL,
  signaling = NULL,
  enriched.only = TRUE,
  type = c("violin", "dot", "bar"),
  color.use = NULL,
  group.by = NULL,
  ...
)
}
\arguments{
\item{object}{CellChat object}

\item{features}{Features to plot gene expression}

\item{signaling}{a char vector containing signaling pathway names for searching}

\item{enriched.only}{whether only return the identified enriched signaling genes in the database. Default = TRUE, returning the significantly enriched signaling interactions}

\item{type}{violin plot or dot plot}

\item{color.use}{defining the color for each cell group}

\item{group.by}{Name of one metadata columns to group (color) cells. Default is the defined cell groups in CellChat object}

\item{...}{other arguments passing to either VlnPlot or DotPlot from Seurat package}
}
\description{
This function create a Seurat object from an input CellChat object, and then plot gene expression distribution using a modified violin plot or dot plot based on Seurat's function or a bar plot.
Please check \code{\link{StackedVlnPlot}},\code{\link{dotPlot}} and \code{\link{barPlot}}for detailed description of the arguments.
}
\details{
USER can extract the signaling genes related to the inferred L-R pairs or signaling pathway using \code{\link{extractEnrichedLR}}, and then plot gene expression using Seurat package.
}
