% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_heatmap}
\alias{netVisual_heatmap}
\title{Visualization of network using heatmap}
\usage{
netVisual_heatmap(
  object,
  comparison = c(1, 2),
  measure = c("count", "weight"),
  signaling = NULL,
  slot.name = c("netP", "net"),
  color.use = NULL,
  color.heatmap = NULL,
  title.name = NULL,
  width = NULL,
  height = NULL,
  ylim.top = NULL,
  ylim.right = NULL,
  font.size = 8,
  font.size.title = 10,
  cluster.rows = FALSE,
  cluster.cols = FALSE,
  sources.use = NULL,
  targets.use = NULL,
  remove.isolate = FALSE,
  row.show = NULL,
  col.show = NULL
)
}
\arguments{
\item{object}{A merged CellChat object or a single CellChat object}

\item{comparison}{a numerical vector giving the datasets for comparison in object.list; e.g., comparison = c(1,2)}

\item{measure}{"count" or "weight". "count": comparing the number of interactions; "weight": comparing the total interaction weights (strength)}

\item{signaling}{a character vector giving the name of signaling networks in a single CellChat object}

\item{slot.name}{the slot name of object. Set is to be "netP" if input signaling is a pathway name; Set is to be "net" if input signaling is a ligand-receptor pair}

\item{color.use}{the character vector defining the color of each cell group}

\item{color.heatmap}{A vector of two colors corresponding to max/min values, or a color name in brewer.pal only when the data in the heatmap do not contain negative values.
By default, color.heatmap = c('#2166ac','#b2182b') when taking a merged CellChat object as input; color.heatmap = "Reds" when taking a single CellChat object as input.}

\item{title.name}{the name of the title}

\item{width}{width of heatmap}

\item{height}{height of heatmap}

\item{ylim.top}{set the range of the top barplot (e.g., ylim.top = c(0, 4))}

\item{ylim.right}{set the range of the right barplot (e.g., ylim.right = c(0, 5))}

\item{font.size}{fontsize in heatmap}

\item{font.size.title}{font size of the title}

\item{cluster.rows}{whether cluster rows}

\item{cluster.cols}{whether cluster columns}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{remove.isolate}{whether remove the isolate nodes in the communication network}

\item{row.show, col.show}{a vector giving the index or the name of row or columns to show in the heatmap}
}
\value{
an object of ComplexHeatmap
}
\description{
This heatmap can be used to 1) show differential number of interactions or interaction strength in the cell-cell communication network between two datasets;
2) the number of interactions or interaction strength in a single dataset;
3) the inferred cell-cell communication network in a single dataset, defined by `signaling`. Please see @Details below for detailed explanations of this heatmap plot.
}
\details{
When show differential number of interactions or interaction strength in the cell-cell communication network between two datasets, the width of edges represent the relative number of interactions or interaction strength.
Red (or blue) colored edges represent increased (or decreased) signaling in the second dataset compared to the first one.

The top colored bar plot represents the sum of absolute values displayed in each column of the heatmap. The right colored bar plot represents the sum of absolute values in each row.
}
