% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_embeddingPairwiseZoomIn}
\alias{netVisual_embeddingPairwiseZoomIn}
\title{Zoom into the 2D visualization of the joint manifold learning of signaling networks from two datasets}
\usage{
netVisual_embeddingPairwiseZoomIn(
  object,
  slot.name = "netP",
  type = c("functional", "structural"),
  comparison = NULL,
  color.use = NULL,
  nCol = 1,
  point.shape = NULL,
  pathway.remove = NULL,
  dot.size = c(2, 6),
  label.size = 2.8,
  dot.alpha = 0.5,
  xlabel = NULL,
  ylabel = NULL,
  do.label = T,
  show.legend = F,
  show.axes = T
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{type}{"functional","structural"}

\item{comparison}{a numerical vector giving the datasets for comparison. Default are all datasets when object is a merged object}

\item{color.use}{defining the color for each cell group}

\item{nCol}{number of columns in the plot}

\item{point.shape}{a numeric vector giving the point shapes. By default point.shape <- c(21, 0, 24, 23, 25, 10, 12), see available shapes at http://www.sthda.com/english/wiki/r-plot-pch-symbols-the-different-point-shapes-available-in-r}

\item{pathway.remove}{a character vector defining the signaling to remove}

\item{dot.size}{a range defining the size of the symbol}

\item{label.size}{font size of the text}

\item{dot.alpha}{transparency}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{do.label}{label the each point}

\item{show.legend}{whether show the legend}

\item{show.axes}{whether show the axes}
}
\description{
Zoom into the 2D visualization of the joint manifold learning of signaling networks from two datasets
}
