% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_chord_gene}
\alias{netVisual_chord_gene}
\title{Chord diagram for visualizing cell-cell communication for a set of ligands/receptors or signaling pathways}
\usage{
netVisual_chord_gene(
  object,
  slot.name = "net",
  color.use = NULL,
  signaling = NULL,
  pairLR.use = NULL,
  net = NULL,
  sources.use = NULL,
  targets.use = NULL,
  lab.cex = 0.8,
  small.gap = 1,
  big.gap = 10,
  annotationTrackHeight = c(0.03),
  link.visible = TRUE,
  scale = FALSE,
  directional = 1,
  link.target.prop = TRUE,
  reduce = -1,
  transparency = 0.4,
  link.border = NA,
  title.name = NULL,
  legend.pos.x = 20,
  legend.pos.y = 20,
  show.legend = TRUE,
  thresh = 0.05,
  ...
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object: slot.name = "net" when visualizing links at the level of ligands/receptors; slot.name = "netP" when visualizing links at the level of signaling pathways}

\item{color.use}{colors for the cell groups}

\item{signaling}{a character vector giving the name of signaling networks}

\item{pairLR.use}{a data frame consisting of one column named either "interaction_name" or "pathway_name", defining the interactions of interest}

\item{net}{A data frame consisting of the interactions of interest.
net should have at least three columns: "source","target" and "interaction_name" when visualizing links at the level of ligands/receptors;
"source","target" and "pathway_name" when visualizing links at the level of signaling pathway; "interaction_name" and "pathway_name" must be the matched names in CellChatDB$interaction.}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{lab.cex}{font size for the text}

\item{small.gap}{Small gap between sectors.}

\item{big.gap}{Gap between the different sets of sectors, which are defined in the `group` parameter}

\item{annotationTrackHeight}{annotationTrack Height}

\item{link.visible}{whether plot the link. The value is logical, if it is set to FALSE, the corresponding link will not plotted, but the space is still ocuppied. The format is a matrix with names or a data frame with three columns}

\item{scale}{scale each sector to same width; default = FALSE; however, it is set to be TRUE when remove.isolate = TRUE}

\item{directional}{Whether links have directions. 1 means the direction is from the first column in df to the second column, -1 is the reverse, 0 is no direction, and 2 for two directional.}

\item{link.target.prop}{If the Chord diagram is directional, for each source sector, whether to draw bars that shows the proportion of target sectors.}

\item{reduce}{if the ratio of the width of certain grid compared to the whole circle is less than this value, the grid is removed on the plot. Set it to value less than zero if you want to keep all tiny grid.}

\item{transparency}{Transparency of link colors}

\item{link.border}{border for links, single scalar or a matrix with names or a data frame with three columns}

\item{title.name}{title name of the plot}

\item{legend.pos.x, legend.pos.y}{adjust the legend position}

\item{show.legend}{whether show the figure legend}

\item{thresh}{threshold of the p-value for determining significant interaction when visualizing links at the level of ligands/receptors;}

\item{...}{other parameters to chordDiagram}
}
\value{
an object of class "recordedplot"
}
\description{
Names of ligands/receptors or signaling pathways will be displayed in this chord diagram
}
