% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_barplot}
\alias{netVisual_barplot}
\title{Visualization of (differential) number of interactions}
\usage{
netVisual_barplot(
  object,
  comparison = c(1, 2),
  measure = c("count", "weight"),
  sources.use = NULL,
  targets.use = NULL,
  invert.source = FALSE,
  invert.target = FALSE,
  signaling = NULL,
  slot.name = c("netP", "net"),
  color.use = NULL,
  title.name = NULL,
  x.lab.rot = FALSE,
  ...
)
}
\arguments{
\item{object}{A merged CellChat object or a single CellChat object}

\item{comparison}{a numerical vector giving the datasets for comparison in object.list; e.g., comparison = c(1,2)}

\item{measure}{"count" or "weight". "count": comparing the number of interactions; "weight": comparing the total interaction weights (strength)}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{invert.source, invert.target}{retain the complementary set}

\item{signaling}{a character vector giving the name of signaling networks in a single CellChat object}

\item{slot.name}{the slot name of object. Set is to be "netP" if input signaling is a pathway name; Set is to be "net" if input signaling is a ligand-receptor pair}

\item{color.use}{the character vector defining the color of each cell group}

\item{title.name}{the name of the title}

\item{x.lab.rot}{do rotation for the x-ticklabels}

\item{...}{Parameters passing to `barplot_internal`}
}
\value{
an object of ggplot
}
\description{
Visualization of (differential) number of interactions
}
